/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.apache.commons.lang3.reflect;

import com.eg.org.apache.commons.lang3.Validate;
import com.eg.org.apache.commons.lang3.reflect.TypeUtils;
import com.eg.org.apache.commons.lang3.reflect.Typed;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeLiteral<T>
implements Typed<T> {
    private static final TypeVariable<Class<TypeLiteral>> T = TypeLiteral.class.getTypeParameters()[0];
    public final Type value = Validate.notNull(TypeUtils.getTypeArguments(this.getClass(), TypeLiteral.class).get(T), "%s does not assign type parameter %s", this.getClass(), TypeUtils.toLongString(T));
    private final String toString;

    protected TypeLiteral() {
        Object[] objectArray = new Object[2];
        objectArray[0] = TypeLiteral.class.getSimpleName();
        objectArray[1] = TypeUtils.toString(this.value);
        this.toString = String.format("%s<%s>", objectArray);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TypeLiteral)) {
            return false;
        }
        TypeLiteral typeLiteral = (TypeLiteral)object;
        return TypeUtils.equals(this.value, typeLiteral.value);
    }

    public int hashCode() {
        return 0x250 | this.value.hashCode();
    }

    public String toString() {
        return this.toString;
    }

    @Override
    public Type getType() {
        return this.value;
    }
}

