/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.objectweb.asm.commons;

import com.eg.org.objectweb.asm.commons.Remapper;
import com.eg.org.objectweb.asm.signature.SignatureVisitor;
import java.util.ArrayList;

public class SignatureRemapper
extends SignatureVisitor {
    private final SignatureVisitor signatureVisitor;
    private final Remapper remapper;
    private ArrayList<String> classNames = new ArrayList();

    public SignatureRemapper(SignatureVisitor signatureVisitor, Remapper remapper) {
        this(589824, signatureVisitor, remapper);
    }

    protected SignatureRemapper(int n2, SignatureVisitor signatureVisitor, Remapper remapper) {
        super(n2);
        this.signatureVisitor = signatureVisitor;
        this.remapper = remapper;
    }

    public void visitClassType(String string) {
        this.classNames.add(string);
        this.signatureVisitor.visitClassType(this.remapper.mapType(string));
    }

    public void visitInnerClassType(String string) {
        String string2 = this.classNames.remove(this.classNames.size() - 1);
        String string3 = string2 + '$' + string;
        this.classNames.add(string3);
        String string4 = this.remapper.mapType(string2) + '$';
        String string5 = this.remapper.mapType(string3);
        int n2 = string5.startsWith(string4) ? string4.length() : string5.lastIndexOf(36) + 1;
        this.signatureVisitor.visitInnerClassType(string5.substring(n2));
    }

    public void visitFormalTypeParameter(String string) {
        this.signatureVisitor.visitFormalTypeParameter(string);
    }

    public void visitTypeVariable(String string) {
        this.signatureVisitor.visitTypeVariable(string);
    }

    public SignatureVisitor visitArrayType() {
        this.signatureVisitor.visitArrayType();
        return this;
    }

    public void visitBaseType(char c10) {
        this.signatureVisitor.visitBaseType(c10);
    }

    public SignatureVisitor visitClassBound() {
        this.signatureVisitor.visitClassBound();
        return this;
    }

    public SignatureVisitor visitExceptionType() {
        this.signatureVisitor.visitExceptionType();
        return this;
    }

    public SignatureVisitor visitInterface() {
        this.signatureVisitor.visitInterface();
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.signatureVisitor.visitInterfaceBound();
        return this;
    }

    public SignatureVisitor visitParameterType() {
        this.signatureVisitor.visitParameterType();
        return this;
    }

    public SignatureVisitor visitReturnType() {
        this.signatureVisitor.visitReturnType();
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        this.signatureVisitor.visitSuperclass();
        return this;
    }

    public void visitTypeArgument() {
        this.signatureVisitor.visitTypeArgument();
    }

    public SignatureVisitor visitTypeArgument(char c10) {
        this.signatureVisitor.visitTypeArgument(c10);
        return this;
    }

    public void visitEnd() {
        this.signatureVisitor.visitEnd();
        this.classNames.remove(this.classNames.size() - 1);
    }
}

