/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.models;

import net.sourceforge.openforecast.models.AbstractForecastingModel;
import net.sourceforge.openforecast.models.AbstractTimeBasedModel;

public class WeightedMovingAverageModel
extends AbstractTimeBasedModel {
    private double[] weights;

    public WeightedMovingAverageModel(double[] weights) {
        this.setWeights(weights);
    }

    public WeightedMovingAverageModel(String independentVariable, double[] weights) {
        super(independentVariable);
        this.setWeights(weights);
    }

    protected WeightedMovingAverageModel() {
    }

    protected WeightedMovingAverageModel(String independentVariable) {
        super(independentVariable);
    }

    protected void setWeights(double[] weights) {
        int periods = weights.length;
        double sum = 0.0;
        int w = 0;
        while (w < periods) {
            sum += weights[w];
            ++w;
        }
        boolean adjust = false;
        if (Math.abs(sum - 1.0) > AbstractForecastingModel.TOLERANCE) {
            adjust = true;
        }
        this.weights = new double[periods];
        int w2 = 0;
        while (w2 < periods) {
            this.weights[w2] = adjust ? weights[w2] / sum : weights[w2];
            ++w2;
        }
    }

    protected double forecast(double timeValue) throws IllegalArgumentException {
        int periods = this.getNumberOfPeriods();
        double t = timeValue;
        double timeDiff = this.getTimeInterval();
        if (timeValue - timeDiff * (double)periods < this.getMinimumTimeValue()) {
            return this.getObservedValue(t);
        }
        double forecast = 0.0;
        int p = periods - 1;
        while (p >= 0) {
            t -= timeDiff;
            try {
                forecast += this.weights[p] * this.getObservedValue(t);
            }
            catch (IllegalArgumentException iaex) {
                forecast += this.weights[p] * this.getForecastValue(t);
            }
            --p;
        }
        return forecast;
    }

    protected int getNumberOfPeriods() {
        return this.weights.length;
    }

    public String getForecastType() {
        return "Weighted Moving Average";
    }

    public String toString() {
        return "weighted moving average model, spanning " + this.getNumberOfPeriods() + " periods and using an independent variable of " + this.getIndependentVariable() + ".";
    }
}

