/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.output;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Iterator;
import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.output.Outputter;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesDataItem;

public class TimeSeriesOutputter
implements Outputter {
    private TimeSeries timeSeries;
    private Constructor timePeriodConstructor;

    public TimeSeriesOutputter(TimeSeries timeSeries, Class timePeriodClass) throws ClassNotFoundException, NoSuchMethodException {
        this.timeSeries = timeSeries;
        Class[] args = new Class[]{Class.forName("java.util.Date")};
        this.timePeriodConstructor = timePeriodClass.getConstructor(args);
    }

    public void output(DataSet dataSet) throws InstantiationException, IllegalAccessException, InvocationTargetException, InstantiationException {
        String timeVariable = dataSet.getTimeVariable();
        Iterator it = dataSet.iterator();
        while (it.hasNext()) {
            DataPoint dataPoint = (DataPoint)it.next();
            this.output(dataPoint, timeVariable);
        }
    }

    private void output(DataPoint dataPoint, String timeVariable) throws InstantiationException, IllegalAccessException, InvocationTargetException, InstantiationException {
        long timeValue = (long)dataPoint.getIndependentValue(timeVariable);
        Object[] args = new Object[]{new Date(timeValue)};
        RegularTimePeriod period = (RegularTimePeriod)this.timePeriodConstructor.newInstance(args);
        double value = dataPoint.getDependentValue();
        this.timeSeries.add(new TimeSeriesDataItem(period, value));
    }
}

