/*
 * Decompiled with CFR 0.152.
 */
package javapns.test;

import java.util.List;
import javapns.Push;
import javapns.communication.exceptions.CommunicationException;
import javapns.communication.exceptions.KeystoreException;
import javapns.devices.Device;
import javapns.test.TestFoundation;

public class FeedbackTest
extends TestFoundation {
    public static void main(String[] args) {
        if (!FeedbackTest.verifyCorrectUsage(FeedbackTest.class, args, "keystore-path", "keystore-password", "[production|sandbox]")) {
            return;
        }
        FeedbackTest.configureBasicLogging();
        FeedbackTest.feedbackTest(args);
    }

    private FeedbackTest() {
    }

    private static void feedbackTest(String[] args) {
        String keystore = args[0];
        String password = args[1];
        boolean production = args.length >= 3 ? args[2].equalsIgnoreCase("production") : false;
        try {
            List<Device> devices = Push.feedback(keystore, password, production);
            for (Device device : devices) {
                System.out.println("Inactive device: " + device.getToken());
            }
        }
        catch (CommunicationException e) {
            e.printStackTrace();
        }
        catch (KeystoreException e) {
            e.printStackTrace();
        }
    }
}

