/*
 * Decompiled with CFR 0.152.
 */
package Acme.JPM.Filters;

import Acme.JPM.Filters.ImageFilterPlus;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;

public class Tile
extends ImageFilterPlus {
    private int width;
    private int height;
    private int newWidth;
    private int newHeight;
    private int nWide;
    private int nHigh;

    public Tile(ImageProducer producer, int newWidth, int newHeight) {
        super(producer, true);
        this.newWidth = newWidth;
        this.newHeight = newHeight;
    }

    public void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
        this.consumer.setDimensions(this.newWidth, this.newHeight);
        this.nWide = (this.newWidth + width - 1) / width;
        this.nHigh = (this.newHeight + height - 1) / height;
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int r = 0;
        while (r < this.nHigh) {
            int ty = r * this.height + y;
            int th = h;
            if (ty + th > this.newHeight) {
                th = this.newHeight - ty;
            }
            int c = 0;
            while (c < this.nWide) {
                int tx = c * this.width + x;
                int tw = w;
                if (tx + tw > this.newWidth) {
                    tw = this.newWidth - tx;
                }
                this.consumer.setPixels(tx, ty, tw, th, model, pixels, off, scansize);
                ++c;
            }
            ++r;
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int r = 0;
        while (r < this.nHigh) {
            int ty = r * this.height + y;
            int th = h;
            if (ty + th > this.newHeight) {
                th = this.newHeight - ty;
            }
            int c = 0;
            while (c < this.nWide) {
                int tx = c * this.width + x;
                int tw = w;
                if (tx + tw > this.newWidth) {
                    tw = this.newWidth - tx;
                }
                this.consumer.setPixels(tx, ty, tw, th, model, pixels, off, scansize);
                ++c;
            }
            ++r;
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            Tile.usage();
        }
        Tile filter = new Tile(null, Integer.parseInt(args[0]), Integer.parseInt(args[1]));
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, filter));
    }

    private static void usage() {
        System.err.println("usage: Tile <width> <height>");
        System.exit(1);
    }
}

