/*
 * Decompiled with CFR 0.152.
 */
package Acme;

import Acme.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class UnixUser {
    private String userName;
    private String encPasswd;
    private int userId;
    private int groupId;
    private String realName;
    private String homeDir;
    private String loginShell;
    private static final String etcPasswd = "/etc/passwd";

    public UnixUser(String name) throws IOException {
        BufferedReader br = this.openFile();
        do {
            this.readFields(br);
        } while (!this.userName.equals(name));
    }

    public UnixUser(int id) throws IOException {
        BufferedReader br = this.openFile();
        do {
            this.readFields(br);
        } while (this.userId != id);
    }

    private BufferedReader openFile() throws IOException {
        return new BufferedReader(new FileReader(etcPasswd));
    }

    private void readFields(BufferedReader br) throws IOException {
        String line;
        String[] fields;
        do {
            if ((line = br.readLine()) != null) continue;
            throw new IOException("unknown user: " + this.userName);
        } while ((fields = Utils.splitStr(line, ':')).length != 7);
        this.userName = fields[0];
        this.encPasswd = fields[1];
        this.userId = Integer.parseInt(fields[2]);
        this.groupId = Integer.parseInt(fields[3]);
        this.realName = fields[4];
        this.homeDir = fields[5];
        this.loginShell = fields[6];
    }

    public String getUserName() {
        return this.userName;
    }

    public String getEncPasswd() {
        return this.encPasswd;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getGroupid() {
        return this.groupId;
    }

    public String getRealName() {
        return this.realName;
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    public String getLoginShell() {
        return this.loginShell;
    }
}

