/*
 * Decompiled with CFR 0.152.
 */
package Acme.Widgets;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;

public class Slider
extends Canvas {
    private static final int THUMB_SIZE = 14;
    private static final int BUFFER = 2;
    private static final int TEXT_HEIGHT = 15;
    private static final int TEXT_BUFFER = 3;
    private static final int DEFAULT_WIDTH = 100;
    private static final int DEFAULT_HEIGHT = 15;
    private static final int MIN_WIDTH = 34;
    private static final int MIN_HEIGHT = 6;
    private static final int DEFAULT_MIN = 1;
    private static final int DEFAULT_MAX = 100;
    int value;
    int valueMin;
    int valueMax;
    int pixel;
    int pixelMin;
    int pixelMax;
    Color barColor;
    Color thumbColor;
    Color lineColor;
    Color textColor;

    public Slider() {
        this.setDefaults();
    }

    public Slider(int valueMin, int valueMax) {
        this.setDefaults();
        this.setMinimum(valueMin);
        this.setMaximum(valueMax);
        this.setValue(valueMin);
    }

    public Slider(int valueMin, int valueMax, int width) {
        this.setDefaults();
        this.setMinimum(valueMin);
        this.setMaximum(valueMax);
        this.setValue(valueMin);
        this.setWidth(width);
    }

    private void setDefaults() {
        this.valueMin = 1;
        this.valueMax = 100;
        this.thumbColor = this.getBackground();
        if (this.thumbColor == null) {
            this.thumbColor = Color.lightGray;
        }
        this.barColor = this.thumbColor.darker();
        this.textColor = this.getForeground();
        if (this.textColor == null) {
            this.textColor = Color.black;
        }
        this.lineColor = this.textColor;
        this.resize(100, 30);
        this.setValue(this.valueMin);
    }

    public void motion() {
    }

    public void release() {
    }

    public void setMaximum(int num) {
        this.valueMax = num;
        if (this.valueMin > this.valueMax) {
            this.valueMin = this.valueMax;
        }
        this.setValue(this.value);
    }

    public void setMinimum(int num) {
        this.valueMin = num;
        if (this.valueMax < this.valueMin) {
            this.valueMax = this.valueMin;
        }
        this.setValue(this.value);
    }

    public void setValue(int num) {
        this.value = num;
        if (this.value < this.valueMin) {
            this.value = this.valueMin;
        } else if (this.value > this.valueMax) {
            this.value = this.valueMax;
        }
        this.pixel = this.value != this.valueMin ? (int)(Math.round(Math.abs((double)(this.value - this.valueMin) / (double)(this.valueMax - this.valueMin)) * (double)(this.pixelMax - this.pixelMin)) + (long)this.pixelMin) : this.pixelMin;
        this.repaint();
    }

    public void setHeight(int num) {
        if (num < 21) {
            num = 21;
        }
        this.resize(this.size().width, num);
        this.repaint();
    }

    public void setWidth(int num) {
        if (num < 34) {
            num = 34;
        }
        this.resize(num, this.size().height);
        this.repaint();
    }

    public void setBarColor(Color color) {
        this.barColor = color;
        this.repaint();
    }

    public void setThumbColor(Color color) {
        this.thumbColor = color;
        this.repaint();
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
        this.repaint();
    }

    public void setTextColor(Color color) {
        this.textColor = color;
        this.repaint();
    }

    public int getValue() {
        return this.value;
    }

    public void paint(Graphics g) {
        int width = this.size().width;
        int height = this.size().height;
        g.setColor(this.barColor);
        g.fill3DRect(0, 15, width, height - 15, false);
        g.setColor(this.thumbColor);
        g.fill3DRect(this.pixel - 14, 17, 29, height - 4 - 15, true);
        g.setColor(this.lineColor);
        g.drawLine(this.pixel, 18, this.pixel, height - 4);
        g.setColor(this.textColor);
        String str = String.valueOf(this.value);
        int strWidth = this.getFontMetrics(g.getFont()).stringWidth(str);
        g.drawString(str, this.pixel - strWidth / 2, 12);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.pixelMin = 16;
        this.pixelMax = width - 14 - 2 - 1;
        this.pixel = this.value != this.valueMin ? (int)(Math.round(Math.abs((double)(this.value - this.valueMin) / (double)(this.valueMax - this.valueMin)) * (double)(this.pixelMax - this.pixelMin)) + (long)this.pixelMin) : this.pixelMin;
    }

    public boolean mouseDown(Event e, int x, int y) {
        if (x >= this.pixel - 14 && x <= this.pixel + 14) {
            if (x < this.pixel) {
                this.setValue(this.value - 1);
            } else if (x > this.pixel) {
                this.setValue(this.value + 1);
            }
        } else {
            this.mouseAction(x);
        }
        this.motion();
        return true;
    }

    public boolean mouseDrag(Event e, int x, int y) {
        this.mouseAction(x);
        this.motion();
        return true;
    }

    public boolean mouseUp(Event e, int x, int y) {
        this.release();
        return true;
    }

    private void mouseAction(int x) {
        this.pixel = Math.min(Math.max(x, this.pixelMin), this.pixelMax);
        double percent = this.pixel != this.pixelMin ? ((double)this.pixel - (double)this.pixelMin) / (double)(this.pixelMax - this.pixelMin) : 0.0;
        this.value = (int)Math.round(percent * (double)(this.valueMax - this.valueMin)) + this.valueMin;
        this.repaint();
    }
}

