/*
 * Decompiled with CFR 0.152.
 */
package com.eg.cli;

import com.eg.cli.CLIConfigInfo;
import com.eg.cli.CLILogFormatter;
import com.eg.cli.CLIValidator;
import com.eg.cli.EgCLISSL;
import com.eg.cli.MyHostnameVerifier;
import com.eg.cli.MyX509TrustManager;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CLIClientBase {
    private Hashtable ht;
    private String fileDir = CLIConfigInfo.Accounts_File_Dir + CLIConfigInfo.separator;
    private String accountFileName = "";
    private String mgrIPWithPort = "";
    private String mgrIP = "";
    private String mgrURL = "";
    private String xml = "";
    private String element = "";
    private String elementType = "";
    private String action = "";
    private String mgrID = "";
    private FileHandler fh = null;
    private FileHandler errFileHandler = null;
    private Logger logger = null;
    private Logger errLogger = null;
    private ArrayList argsList = new ArrayList();

    public void setArgs(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        this.setArgs(arrayList);
    }

    public void setArgs(ArrayList arrayList) {
        this.argsList = arrayList;
    }

    public void setElement(String string) {
        this.element = string;
    }

    public void setElementType(String string) {
        this.elementType = string;
    }

    public void setAction(String string) {
        this.action = string;
    }

    public String getElement() {
        return this.element;
    }

    public String getElementType() {
        return this.elementType;
    }

    public String getAction() {
        return this.action;
    }

    public void doExecute() {
        boolean bl = true;
        this.initLog();
        bl = this.populateArgs();
        if (!bl || this.ht == null || this.ht.size() == 0) {
            return;
        }
        bl = this.readCredentials();
        if (!bl) {
            return;
        }
        String string = (String)this.ht.get("allowallusers");
        if (string != null && string.equals("no") && !this.isValidSysLogin()) {
            System.out.println("Error : Current user authentication failed for this command.");
            return;
        }
        this.setMgrIPWithPort();
        this.setMgrIP();
        this.setMgrURL(this.isHttpsEnabled());
        if (this.ht.containsKey("file")) {
            String string2 = (String)this.ht.get("file");
            File file = new File(string2);
            if (!file.exists()) {
                System.out.println("Error : File does not exist");
                return;
            }
        } else {
            bl = this.createXML();
            if (!bl) {
                return;
            }
        }
        this.sendData();
        this.closeLogs();
    }

    private boolean isValidSysLogin() {
        String string = (String)this.ht.get("systemuser");
        return string.equals(System.getProperty("user.name"));
    }

    private void closeLogs() {
        if (this.fh != null) {
            this.fh.close();
        }
        if (this.errFileHandler != null) {
            this.errFileHandler.close();
        }
    }

    private void initLog() {
        String string = CLIConfigInfo.CLI_Install_Dir + CLIConfigInfo.separator + "lib" + CLIConfigInfo.separator + "eGCLILog.properties";
        String string2 = CLIConfigInfo.CLI_Install_Dir + CLIConfigInfo.separator + "logs" + CLIConfigInfo.separator;
        System.setProperty("java.util.logging.config.file", string);
        File file = new File(string2);
        int n = 2000000;
        int n2 = 5;
        boolean bl = true;
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        try {
            this.fh = new FileHandler(string2 + "CLILog%g.log", n, n2, bl);
        }
        catch (Exception exception) {
            System.out.println("Problem while initiating logger : " + exception);
        }
        this.fh.setFormatter(new CLILogFormatter());
        this.logger = Logger.getLogger("CommonErrorLog");
        this.logger.addHandler(this.fh);
        this.logger.setLevel(Level.INFO);
    }

    private void initErrorLog() {
        String string = CLIConfigInfo.CLI_Install_Dir + CLIConfigInfo.separator + "lib" + CLIConfigInfo.separator + "eGCLILog.properties";
        String string2 = CLIConfigInfo.CLI_Install_Dir + CLIConfigInfo.separator + "logs" + CLIConfigInfo.separator;
        System.setProperty("java.util.logging.config.file", string);
        File file = new File(string2);
        int n = 2000000;
        int n2 = 2;
        boolean bl = true;
        if (this.ht != null && this.ht.containsKey("managerid")) {
            this.mgrID = (String)this.ht.get("managerid");
        }
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        try {
            this.errFileHandler = new FileHandler(string2 + this.mgrID + "Log%g.log", n, n2, bl);
        }
        catch (Exception exception) {
            System.out.println("Problem while initiating errLogger : " + exception);
        }
        this.errFileHandler.setFormatter(new CLILogFormatter());
        this.errLogger = Logger.getLogger("BulkErrorLog");
        this.errLogger.addHandler(this.errFileHandler);
    }

    private boolean populateArgs() {
        this.logger.log(Level.INFO, "NewLine");
        this.logger.log(Level.INFO, "LogTime");
        this.logger.log(Level.INFO, "NewLine");
        this.logger.log(Level.INFO, this.argsList.toString());
        this.ht = new Hashtable();
        boolean bl = true;
        try {
            if (this.argsList != null) {
                String string = "";
                String string2 = "";
                for (int i = 0; i < this.argsList.size(); ++i) {
                    String string3 = (String)this.argsList.get(i);
                    if (string3.startsWith("-") && string3.length() > 1) {
                        if (string.length() > 0 && string2.length() > 0) {
                            this.ht.put(string.substring(1).toLowerCase(), string2);
                        }
                        string = string3;
                        string2 = "";
                        continue;
                    }
                    string2 = string2.length() == 0 ? string3 : string2 + " " + string3;
                }
                this.ht.put(string.substring(1).toLowerCase(), string2);
            }
            if (this.ht.containsKey("managerid")) {
                this.accountFileName = this.fileDir + (String)this.ht.get("managerid");
            }
        }
        catch (Exception exception) {
            System.out.println("Error : Error in command arguments. Please try again.");
            this.logger.log(Level.INFO, "NewLine");
            this.logger.log(Level.SEVERE, "Error : Error in command arguments. Please try again.", exception);
            bl = false;
        }
        return bl;
    }

    private void setMgrIPWithPort() {
        this.mgrIPWithPort = (String)this.ht.get("mgrip") + ":" + (String)this.ht.get("mgrport");
    }

    private void setMgrIP() {
        this.mgrIP = (String)this.ht.get("mgrip");
    }

    private boolean isHttpsEnabled() {
        boolean bl = false;
        String string = (String)this.ht.get("ssl");
        if (string != null && string.length() > 0 && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
            bl = true;
        }
        return bl;
    }

    private void setMgrURL() {
        this.setMgrURL(false);
    }

    private void setMgrURL(boolean bl) {
        if (this.mgrIPWithPort.length() > 0 && this.mgrIPWithPort.indexOf(":") > 0) {
            if (bl) {
                this.enableSSL();
                this.mgrURL = "https://";
            } else {
                this.mgrURL = "http://";
            }
            this.mgrURL = this.mgrURL + this.mgrIPWithPort + "/final/servlet/com.eg.FileReceiver";
        }
    }

    private void enableSSL() {
        EgCLISSL egCLISSL = EgCLISSL.getInstance();
        egCLISSL.enableSSL();
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        Object var3_3 = null;
        try {
            MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
            HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
        }
        catch (Exception exception) {
            System.out.println("Error : Problem in SSL Connection");
            this.logger.log(Level.INFO, "NewLine");
            this.logger.log(Level.SEVERE, "Error : Problem in SSL Connection", exception);
        }
    }

    private boolean readCredentials() {
        String string = "";
        String string2 = "";
        try {
            char[] cArray;
            FileInputStream fileInputStream = new FileInputStream(this.accountFileName + CLIConfigInfo.suffix);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
            String string3 = bufferedReader.readLine();
            if (string3 != null && (cArray = string3.toCharArray()).length != 0 && cArray[0] == '\ufeff') {
                string3 = string3.substring(1);
            }
            while (string3 != null) {
                if (string3.length() == 0) {
                    string3 = bufferedReader.readLine();
                    continue;
                }
                int n = string3.indexOf("#");
                if (n > 0) {
                    string = string3.substring(0, n).trim();
                    string2 = string3.substring(n + 1).trim();
                    this.ht.put(CLIConfigInfo.AESdecrypt(string), CLIConfigInfo.AESdecrypt(string2));
                }
                string3 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            System.out.println("Error : Problem while retrieving account information");
            System.out.println("Possible reason : The manager ID may not exist or invalid");
            this.logger.log(Level.INFO, "NewLine");
            this.logger.log(Level.SEVERE, "Error : Problem while retrieving account information", exception);
            return false;
        }
        return true;
    }

    private boolean createXML() {
        String string = this.getElement();
        String string2 = this.getAction();
        this.logger.log(Level.INFO, "NewLine");
        this.logger.log(Level.INFO, "root :" + string + "  action :" + string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("element");
        arrayList.add("action");
        arrayList.add("user");
        arrayList.add("pwd");
        arrayList.add("mgrip");
        arrayList.add("mgrport");
        arrayList.add("ssl");
        arrayList.add("managerid");
        try {
            Object object;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(string);
            document.appendChild(element);
            element.setAttribute("action", string2);
            Element element2 = document.createElement(this.getElementType());
            String string32 = "";
            String string4 = "";
            element.appendChild(element2);
            for (String string32 : this.ht.keySet()) {
                if (arrayList.contains(string32)) continue;
                string4 = (String)this.ht.get(string32);
                if (string4.length() == 0) {
                    System.out.println("Error : Parameter " + string32 + " does not hold a value.");
                    return false;
                }
                object = document.createElement(string32);
                object.appendChild(document.createTextNode(string4));
                element2.appendChild((Node)object);
            }
            object = TransformerFactory.newInstance();
            Transformer transformer = ((TransformerFactory)object).newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(byteArrayOutputStream);
            transformer.transform(dOMSource, streamResult);
            this.xml = byteArrayOutputStream.toString("UTF-8");
            this.logger.log(Level.INFO, "NewLine");
            this.logger.log(Level.INFO, "XML :" + this.xml);
        }
        catch (Exception exception) {
            System.out.println("Error : Unable to execute the command. please try again.");
            this.logger.log(Level.INFO, "NewLine");
            this.logger.log(Level.SEVERE, "Error : Unable to execute the command. please try again.");
            this.logger.log(Level.INFO, "NewLine");
            this.logger.log(Level.SEVERE, "Problem in command execution--Command to XML converion", exception);
            return false;
        }
        return true;
    }

    private boolean sendData() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        String string = "";
        URL uRL = null;
        HttpURLConnection httpURLConnection = null;
        try {
            uRL = new URL(this.mgrURL);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Content-Type", "text/xml;charset=UTF-8");
            object6 = new ObjectOutputStream(httpURLConnection.getOutputStream());
            object5 = (String)this.ht.get("eguser");
            object5 = object5 == null ? (String)this.ht.get("user") : object5;
            object4 = (String)this.ht.get("pwd");
            object3 = "";
            object2 = new Hashtable<String, String>();
            ((Hashtable)object2).put("user", object5);
            ((Hashtable)object2).put("password", object4);
            if (this.ht.containsKey("file")) {
                string = "file";
                object = (String)this.ht.get("file");
                if (object != null) {
                    if (((String)(object = ((String)object).toLowerCase())).endsWith(".xml")) {
                        object3 = "xml";
                    } else if (((String)object).endsWith(".csv")) {
                        object3 = "csv";
                    }
                }
                ((Hashtable)object2).put("content", string);
                ((Hashtable)object2).put("filetype", object3);
            } else {
                string = "string";
                ((Hashtable)object2).put("content", string);
            }
            object = new ArrayList();
            ((ArrayList)object).add(object2);
            if (string.equalsIgnoreCase("string")) {
                ((ArrayList)object).add(this.xml);
                ((ObjectOutputStream)object6).writeObject(object);
            } else {
                String string2 = (String)this.ht.get("file");
                ArrayList arrayList = this.readFile(string2);
                ((ArrayList)object).add(arrayList);
                boolean bl = this.isValidFile(string2, (String)object3, arrayList);
                if (!bl) {
                    System.out.println("Error : The command does not match with file.");
                    this.logger.log(Level.INFO, "NewLine");
                    this.logger.log(Level.SEVERE, "Error : The command does not match with the uploded file's element and/or action values.");
                    return false;
                }
                ((ObjectOutputStream)object6).writeObject(object);
            }
            ((ObjectOutputStream)object6).flush();
            ((ObjectOutputStream)object6).close();
        }
        catch (Exception exception) {
            System.out.println("Error : Problem while connecting with manager");
            this.logger.log(Level.INFO, "NewLine");
            this.logger.log(Level.SEVERE, "Error : Problem while connecting with manager", exception);
            return false;
        }
        try {
            object6 = new ArrayList();
            object5 = null;
            object5 = new ObjectInputStream(httpURLConnection.getInputStream());
            object6 = (ArrayList)((ObjectInputStream)object5).readObject();
            if (object6 != null) {
                if (string.equalsIgnoreCase("string")) {
                    if (this.action.equals("show")) {
                        if (((ArrayList)object6).get(0).toString().indexOf("~Hash~") == -1) {
                            System.out.println(((ArrayList)object6).get(0));
                        } else if (((ArrayList)object6).get(0).toString().indexOf("~Hash~") != -1) {
                            object4 = object6;
                            object3 = new CLIValidator();
                            if (this.ht.containsKey("csvformat") && ((String)(object2 = (String)this.ht.get("csvformat"))).equalsIgnoreCase("yes")) {
                                ((CLIValidator)object3).showInCSVFormat((ArrayList)object4);
                                System.exit(1);
                            }
                            ((CLIValidator)object3).showInTabularFormat((ArrayList)object4);
                        }
                    } else if (this.action.equals("showPolicyDetails")) {
                        if (((ArrayList)object6).get(0).toString().indexOf("~Hash~") == -1) {
                            System.out.println(((ArrayList)object6).get(0));
                        } else if (((ArrayList)object6).get(0).toString().indexOf("~Hash~") != -1) {
                            object4 = object6;
                            object3 = new CLIValidator();
                            if (this.ht.containsKey("csvformat") && ((String)(object2 = (String)this.ht.get("csvformat"))).equalsIgnoreCase("yes")) {
                                ((CLIValidator)object3).showInCSVFormat((ArrayList)object4);
                                System.exit(1);
                            }
                            ((CLIValidator)object3).showInTabularFormat((ArrayList)object4);
                        }
                    } else {
                        for (int i = 0; i < ((ArrayList)object6).size(); ++i) {
                            System.out.println(((ArrayList)object6).get(i));
                            this.logger.log(Level.INFO, "NewLine");
                            this.logger.log(Level.INFO, ((ArrayList)object6).get(i).toString());
                        }
                    }
                } else {
                    object4 = "@#@";
                    this.initErrorLog();
                    if (((ArrayList)object6).size() > 1) {
                        this.errLogger.log(Level.INFO, "NewLine");
                        this.errLogger.log(Level.INFO, "NewLine");
                        this.errLogger.log(Level.INFO, "LogTime");
                        this.errLogger.log(Level.INFO, "NewLine");
                        object3 = "Please check the <eGCLI_Install_Dir>/logs/" + this.mgrID + "Log0.log file for more details";
                        System.out.println(((ArrayList)object6).get(0));
                        System.out.println();
                        this.errLogger.log(Level.INFO, "NewLine");
                        this.errLogger.log(Level.INFO, (String)object4 + ((ArrayList)object6).get(0).toString());
                        for (int i = 1; i < ((ArrayList)object6).size(); ++i) {
                            object = ((ArrayList)object6).get(i).toString();
                            System.out.println(((String)object).substring(((String)object).indexOf("\n") + 1));
                            this.errLogger.log(Level.INFO, "NewLine");
                            this.errLogger.log(Level.INFO, (String)object4 + (String)object);
                        }
                        System.out.println();
                        System.out.println((String)object3);
                    } else if (((ArrayList)object6).size() == 1) {
                        System.out.println(((ArrayList)object6).get(0));
                        this.logger.log(Level.INFO, "NewLine");
                        this.logger.log(Level.INFO, ((ArrayList)object6).get(0).toString());
                    }
                }
            }
            if (object5 != null) {
                ((ObjectInputStream)object5).close();
            }
        }
        catch (Exception exception) {
            System.out.println("Error : Problem in command execution in manager");
            System.out.println("Possible reason : Error in command or File");
            this.logger.log(Level.INFO, "NewLine");
            this.logger.log(Level.SEVERE, "Problem in manager, while executing the command or parsing the file", exception);
            return false;
        }
        return true;
    }

    private boolean isValidFile(String string, String string2, ArrayList arrayList) {
        String string3 = this.getElement();
        String string4 = this.getAction();
        String string5 = "";
        String string6 = "";
        boolean bl = false;
        if (string2.equalsIgnoreCase("xml")) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(string);
                Element element = document.getDocumentElement();
                string5 = element.getTagName();
                string6 = element.getAttribute("action");
            }
            catch (Exception exception) {
                this.logger.log(Level.INFO, "NewLine");
                this.logger.log(Level.SEVERE, "Error : Unable to read / parse the XML file.");
            }
        } else if (string2.equalsIgnoreCase("csv")) {
            int n;
            String string7 = "";
            if (arrayList.size() > 1 && (n = (string7 = (String)arrayList.get(1)).indexOf(",")) > -1) {
                string5 = string7.substring(0, n);
                string6 = string7.substring(n + 1);
            }
        }
        if (string3.equalsIgnoreCase(string5) && string4.equalsIgnoreCase(string6)) {
            bl = true;
        }
        return bl;
    }

    private ArrayList readFile(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            char[] cArray;
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8");
            bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = bufferedReader.readLine();
            if (string2 != null && (cArray = string2.toCharArray()).length != 0 && cArray[0] == '\ufeff') {
                string2 = string2.substring(1);
            }
            while (string2 != null) {
                if (!string2.equals("") && string2.length() > 0) {
                    arrayList.add(string2);
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            this.logger.log(Level.INFO, "NewLine");
            this.logger.log(Level.INFO, "File reading in non UTF-8 mode", exception);
            try {
                inputStreamReader = new InputStreamReader(new FileInputStream(string));
                bufferedReader = new BufferedReader(inputStreamReader);
                String string3 = bufferedReader.readLine();
                while (string3 != null) {
                    if (!string3.equals("") && string3.length() > 0) {
                        arrayList.add(string3);
                    }
                    string3 = bufferedReader.readLine();
                }
            }
            catch (Exception exception2) {
                this.logger.log(Level.INFO, "NewLine");
                this.logger.log(Level.SEVERE, "Problem while reading the file", exception2);
            }
        }
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    private void setAccountFileName() {
        if (this.ht.containsKey("managerid")) {
            this.accountFileName = "C:/eGurkha/eGCLI/account/" + (String)this.ht.get("managerid");
        }
        System.out.println("accountFileName: " + this.accountFileName);
    }

    public ArrayList doExecuteForREST(Hashtable hashtable) {
        if (hashtable == null) {
            return new ArrayList();
        }
        this.ht = hashtable;
        String string = (String)this.ht.get("element");
        String string2 = "Agent";
        String string3 = (String)this.ht.get("action");
        this.setElement(string);
        if (string.equalsIgnoreCase("UserMgmt")) {
            this.setElementType("User");
        } else if (string.equalsIgnoreCase("Zone") || string.equalsIgnoreCase("Group")) {
            this.setElementType("Element");
        } else {
            this.setElementType("Agent");
        }
        this.setAction(string3);
        String string4 = hashtable.get("mgrUserName").toString();
        String string5 = hashtable.get("mgrPassword").toString();
        hashtable.remove("mgrPassword");
        this.ht.remove("mgrPassword");
        this.createXMLForREST();
        String string6 = hashtable.get("managerhost").toString();
        string6 = string6 + ":" + hashtable.get("managerport").toString();
        String string7 = hashtable.get("ssl").toString();
        String string8 = "";
        if (string6.length() > 0 && string6.indexOf(":") > 0) {
            if (string7.equals("true")) {
                this.enableSSL();
                string8 = "https://";
            } else {
                string8 = "http://";
            }
            string8 = string8 + string6 + "/final/servlet/com.eg.FileReceiver";
        }
        ArrayList arrayList = this.sendDataForREST(string8, string4, string5);
        return arrayList;
    }

    private boolean createXMLForREST() {
        String string = this.getElement();
        String string2 = this.getAction();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("element");
        arrayList.add("action");
        arrayList.add("user");
        arrayList.add("pwd");
        arrayList.add("mgrip");
        arrayList.add("mgrport");
        arrayList.add("ssl");
        arrayList.add("managerid");
        arrayList.add("fileContentList");
        try {
            Object object;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(string);
            document.appendChild(element);
            element.setAttribute("action", string2);
            Element element2 = document.createElement(this.getElementType());
            String string32 = "";
            String string4 = "";
            element.appendChild(element2);
            for (String string32 : this.ht.keySet()) {
                if (arrayList.contains(string32)) continue;
                string4 = (String)this.ht.get(string32);
                if (string4.length() == 0) {
                    System.err.println("Error : Parameter " + string32 + " does not hold a value.");
                    return false;
                }
                object = document.createElement(string32);
                object.appendChild(document.createTextNode(string4));
                element2.appendChild((Node)object);
            }
            object = TransformerFactory.newInstance();
            Transformer transformer = ((TransformerFactory)object).newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(byteArrayOutputStream);
            transformer.transform(dOMSource, streamResult);
            this.xml = byteArrayOutputStream.toString("UTF-8");
        }
        catch (Exception exception) {
            System.out.println("Error : Unable to execute the command. please try again.");
            return false;
        }
        return true;
    }

    private ArrayList sendDataForREST(String string, String string2, String string3) {
        Object object;
        Object object2;
        Object object3;
        Object object4 = new ArrayList<Object>();
        String string4 = "";
        String string5 = "";
        URL uRL = null;
        HttpURLConnection httpURLConnection = null;
        try {
            uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Content-Type", "text/xml;charset=UTF-8");
            object3 = new ObjectOutputStream(httpURLConnection.getOutputStream());
            object2 = new Hashtable<String, String>();
            ((Hashtable)object2).put("user", string2);
            ((Hashtable)object2).put("password", string3);
            if (this.ht.containsKey("fileType") && this.ht.containsKey("fileContentList")) {
                string5 = this.ht.get("fileType").toString();
                ((Hashtable)object2).put("content", "file");
                ((Hashtable)object2).put("filetype", string5);
            } else {
                string4 = "string";
                ((Hashtable)object2).put("content", string4);
            }
            object = new ArrayList<Object>();
            ((ArrayList)object).add(object2);
            if (string4.equalsIgnoreCase("string")) {
                ((ArrayList)object).add(this.xml);
                ((ObjectOutputStream)object3).writeObject(object);
            } else {
                ArrayList arrayList = (ArrayList)this.ht.get("fileContentList");
                ((ArrayList)object).add(arrayList);
                boolean bl = this.isValidFile("", string5, arrayList);
                if (!bl) {
                    System.err.println("Error : The command does not match with file.");
                    this.logger.log(Level.INFO, "NewLine");
                    this.logger.log(Level.SEVERE, "Error : The command does not match with the uploded file's element and/or action values.");
                }
                ((ObjectOutputStream)object3).writeObject(object);
                System.out.println(">>REST-CLI object opstream written");
            }
            ((ObjectOutputStream)object3).flush();
            ((ObjectOutputStream)object3).close();
        }
        catch (Exception exception) {
            String string6 = "Error : Problem while connecting with manager";
            exception.printStackTrace();
            ((ArrayList)object4).add(string6);
            return object4;
        }
        try {
            object3 = new ArrayList();
            object2 = null;
            object2 = new ObjectInputStream(httpURLConnection.getInputStream());
            object3 = (ArrayList)((ObjectInputStream)object2).readObject();
            if (object3 != null) {
                if (string4.equalsIgnoreCase("string")) {
                    System.out.println(">>REST-CLI result list:" + ((ArrayList)object3).size());
                    if (this.action.equals("show")) {
                        if (((ArrayList)object3).get(0).toString().indexOf("~Hash~") == -1) {
                            object = "Error : " + ((ArrayList)object3).get(0).toString();
                            ((ArrayList)object4).add(object);
                        } else if (((ArrayList)object3).get(0).toString().indexOf("~Hash~") != -1) {
                            object4 = object3;
                        }
                    } else if (this.action.equals("showPolicyDetails")) {
                        if (((ArrayList)object3).get(0).toString().indexOf("~Hash~") == -1) {
                            object = "Error : " + ((ArrayList)object3).get(0).toString();
                            ((ArrayList)object4).add(object);
                        } else if (((ArrayList)object3).get(0).toString().indexOf("~Hash~") != -1) {
                            object4 = object3;
                        }
                    } else {
                        object4 = (ArrayList)((ArrayList)object3).clone();
                    }
                } else {
                    object = "@#@";
                    this.initErrorLog();
                    if (((ArrayList)object3).size() > 1) {
                        object4 = object3;
                        System.out.println(">>REST-CLI bulk result list:" + ((ArrayList)object3).size());
                    } else if (((ArrayList)object3).size() == 1) {
                        ((ArrayList)object4).add(((ArrayList)object3).get(0).toString());
                        System.out.println(">>REST-CLI result list:" + ((ArrayList)object3).size());
                    }
                }
            }
            if (object2 != null) {
                ((ObjectInputStream)object2).close();
            }
        }
        catch (Exception exception) {
            object2 = "Error : Problem in command execution in manager";
            ((ArrayList)object4).add(object2);
            System.out.println(exception);
            exception.printStackTrace();
        }
        return object4;
    }

    public static void main(String[] stringArray) {
        CLIClientBase cLIClientBase = new CLIClientBase();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-element");
        arrayList.add("ExternalAgent");
        arrayList.add("-action");
        arrayList.add("add");
        arrayList.add("-ip");
        arrayList.add("2.3.4.5");
        arrayList.add("-nick");
        arrayList.add("asdf");
        cLIClientBase.setArgs(arrayList);
        cLIClientBase.populateArgs();
        cLIClientBase.sendData();
    }
}

