/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.BarChart;
import com.objectplanet.chart.BarChartRenderer;
import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartRenderer;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.Grid;
import com.objectplanet.chart.LineChart;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;

public class LineChartRenderer
extends ChartRenderer {
    private static final int PERSPECTIVE_BOTH = 0;
    private static final int PERSPECTIVE_TOP = 1;
    private static final int PERSPECTIVE_BOTTOM = 2;
    protected int[][][] samplePoints;
    private int[] sampleLabelPos;
    private boolean stackedOn;
    protected int lastSelectedLine;
    LineChart chart;

    public LineChartRenderer(LineChart chart) {
        super(chart);
        this.chart = chart;
        this.legend = chart.legend;
        this.gridRenderer = chart.gridRenderer;
        this.legendRenderer = chart.legendRenderer;
        this.sampleLabelPos = new int[chart.getSampleCount()];
        this.lastSelectedLine = -1;
    }

    public ChartSample checkSelection(Point point) {
        int selected;
        if (point == null) {
            return null;
        }
        ChartSample foundSample = super.checkSelection(point);
        int seriesCount = this.getSeriesCount();
        int sampleCount = this.getSampleCount();
        if (foundSample == null && (selected = this.legendRenderer.getSelectedElement(point, this.legend)) > -1) {
            if (seriesCount > 1 || this.chart.chartType.equals("line") || this.chart.multiSeriesOn) {
                foundSample = new ChartSample(-1);
                foundSample.setSeries(selected);
            } else if (selected < sampleCount) {
                foundSample = this.chart.getSample(0, selected);
                if (foundSample != null) {
                    foundSample.setSeries(-1);
                }
            } else {
                if (selected >= sampleCount) {
                    selected = -1;
                }
                foundSample = this.chart.getSample(0, selected);
            }
            if (foundSample != null && this.overlayRenderers != null) {
                int overlay_count = this.overlayRenderers.size();
                for (int i = overlay_count - 1; i >= 0; --i) {
                    ChartRenderer overlay = (ChartRenderer)this.overlayRenderers.elementAt(i);
                    if (overlay == null) continue;
                    overlay.mouseOverSampleIndex = foundSample.getIndex();
                    overlay.mouseOverSeriesIndex = foundSample.getSeries();
                    overlay.mousePosition.x = this.mousePosition.x;
                    overlay.mousePosition.y = -1;
                }
            }
        }
        if (foundSample == null && this.samplePoints != null) {
            int off = 3;
            for (int serie = 0; foundSample == null && serie < this.samplePoints.length; ++serie) {
                for (int sample = 0; foundSample == null && sample < this.samplePoints[serie].length; ++sample) {
                    Point pos = new Point(this.samplePoints[serie][sample][0], this.samplePoints[serie][sample][1]);
                    if (this.chart.is3DModeOn()) {
                        pos.x -= this.depth3dPoint.x;
                    }
                    boolean inside = point.x >= pos.x - off && point.x <= pos.x + off;
                    if (!(inside &= point.y >= pos.y - off && point.y <= pos.y + off)) continue;
                    foundSample = this.chart.getSample(serie, sample);
                }
            }
        }
        if (foundSample != null) {
            this.mouseOverSampleIndex = foundSample.getIndex();
            this.mouseOverSeriesIndex = foundSample.getSeries();
            this.mousePosition = point;
        } else {
            this.mouseOverSampleIndex = -1;
            this.mouseOverSeriesIndex = -1;
        }
        return foundSample;
    }

    public void render(Graphics g) {
        this.render(g, !this.chart.isServletModeOn());
    }

    protected void paintGrid(Graphics g, Grid grid, Rectangle gridBounds) {
        this.gridRenderer.paintGrid(g, grid, gridBounds);
        if (this.isAnyBelowLabelsOn()) {
            this.paintBelowSampleLabels(g, gridBounds);
        } else {
            for (int i = 0; i < this.overlayRenderers.size(); ++i) {
                ChartRenderer overlay = (ChartRenderer)this.overlayRenderers.elementAt(i);
                if (overlay == null || !(overlay.chart instanceof Chart) || !overlay.isAnyBelowLabelsOn()) continue;
                overlay.paintBelowSampleLabels(g, gridBounds);
                break;
            }
        }
    }

    protected void calculateChartData(Rectangle gridBounds, Rectangle dataBounds) {
        if (!this.chart.needChartCalculation && !this.chart.isServletModeOn()) {
            return;
        }
        int sampleCount = this.getSampleCount();
        int seriesCount = this.getSeriesCount();
        this.display3dOn = this.chart.is3DModeOn();
        this.stackedOn = this.chart.isStackedOn();
        this.gridRenderer.calculateZeroLines(this.chart.getGrid(), gridBounds);
        if (this.samplePoints == null || this.samplePoints.length != seriesCount || this.samplePoints.length == 0 || this.samplePoints[0] == null || this.samplePoints[0].length != sampleCount) {
            this.samplePoints = new int[seriesCount][sampleCount][2];
        }
        boolean rightToLeftScrollingOn = this.chart.isRightToLeftScrollingOn();
        int[] last_index = new int[seriesCount];
        if (this.chart.isRightToLeftScrollingOn()) {
            block14: for (int serie = 0; serie < last_index.length; ++serie) {
                ChartSample[] samples = null;
                try {
                    samples = this.chart.getSamples(serie);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                if (samples == null) continue;
                for (int sample = samples.length - 1; sample >= 0; --sample) {
                    if (samples[sample] == null || !samples[sample].hasValue()) continue;
                    last_index[serie] = Math.max(last_index[serie], sample);
                    continue block14;
                }
            }
        }
        double delta_x = dataBounds.width;
        if (sampleCount > 2) {
            delta_x = (double)dataBounds.width / (double)(sampleCount - 1);
        }
        if (this.sampleLabelPos == null || this.sampleLabelPos.length < sampleCount) {
            int[] newSampleLabelPos = new int[sampleCount];
            if (this.sampleLabelPos != null) {
                System.arraycopy(this.sampleLabelPos, 0, newSampleLabelPos, 0, Math.min(this.sampleLabelPos.length, newSampleLabelPos.length));
            }
            this.sampleLabelPos = newSampleLabelPos;
        }
        double sample_xpos = dataBounds.x;
        if (rightToLeftScrollingOn) {
            int last_label_index = 0;
            String[] labels = this.chart.getSampleLabels();
            if (labels != null) {
                for (int i = labels.length - 1; i >= 0; --i) {
                    if (labels[i] == null) continue;
                    last_label_index = Math.max(last_label_index, i);
                    break;
                }
            }
            sample_xpos = sample_xpos + (double)dataBounds.width - delta_x * (double)last_label_index;
        }
        if (sampleCount == 1) {
            this.sampleLabelPos[0] = dataBounds.x + dataBounds.width / 2;
        } else {
            for (int i = 0; i < sampleCount && i < this.sampleLabelPos.length; ++i) {
                int xpos = sample_xpos >= 0.0 ? (int)(sample_xpos + 0.5) : (int)(sample_xpos - 0.5);
                this.sampleLabelPos[i] = xpos;
                sample_xpos += delta_x;
            }
        }
        for (int serie = 0; serie < seriesCount && this.samplePoints != null && serie < this.samplePoints.length; ++serie) {
            double depth_x = (double)this.depth3dPoint.x / (double)seriesCount * (double)serie;
            sample_xpos = dataBounds.x;
            if (rightToLeftScrollingOn) {
                sample_xpos = sample_xpos + (double)dataBounds.width - delta_x * (double)last_index[serie];
            }
            double last_value = Double.NaN;
            for (int sample = 0; sample < sampleCount && this.samplePoints[serie] != null && sample < this.samplePoints[serie].length; ++sample) {
                double factor;
                int xpos = sampleCount == 1 ? dataBounds.x + dataBounds.width / 2 : (sample_xpos >= 0.0 ? (int)(sample_xpos + 0.5) : (int)(sample_xpos - 0.5));
                try {
                    this.samplePoints[serie][sample][0] = xpos;
                    if (this.display3dOn && this.chart.getLine3DLayout() == 0 && !this.stackedOn) {
                        int[] nArray = this.samplePoints[serie][sample];
                        nArray[0] = (int)((double)nArray[0] + depth_x);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                double value = Double.NaN;
                try {
                    value = this.chart.getSampleValue(serie, sample);
                    if (!this.chart.isConnectedLinesOn(serie) && !this.chart.isMissingValuesInterpolated()) {
                        if (new Double(value).isNaN()) {
                            value = 0.0;
                        }
                        last_value = value;
                    } else if (!new Double(value).isNaN()) {
                        last_value = value;
                    } else if (this.stackedOn) {
                        for (int cur = sample + 1; cur < sampleCount; ++cur) {
                            ChartSample cur_s = this.chart.getSample(serie, cur);
                            if (cur_s == null || !cur_s.hasValue()) continue;
                            if (new Double(last_value).isNaN()) {
                                value = cur_s.getValue();
                                break;
                            }
                            double delta = ((double)cur_s.getValue() - last_value) / (double)(cur - sample + 1);
                            last_value = value = last_value + delta;
                            if (!this.chart.isConnectedLinesOn(serie)) break;
                            this.chart.setSampleValue(serie, sample, value);
                            break;
                        }
                        if (new Double(value).isNaN()) {
                            value = last_value;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                int rangeIndex = this.chart.getSeriesRange(serie);
                double currentUpperRange = this.chart.getCurrentRange(rangeIndex);
                double currentLowerRange = this.chart.getCurrentLowerRange(rangeIndex);
                try {
                    factor = (value - currentLowerRange) / (currentUpperRange - currentLowerRange);
                }
                catch (Exception e) {
                    factor = Double.NaN;
                }
                double y_value = (double)(gridBounds.y + gridBounds.height) - factor * (double)gridBounds.height;
                if (serie > 0 && this.stackedOn) {
                    try {
                        factor = value / (currentUpperRange - currentLowerRange);
                        y_value = (double)this.samplePoints[serie - 1][sample][1] - (double)gridBounds.height * factor;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                try {
                    this.samplePoints[serie][sample][1] = y_value >= 0.0 ? (int)(y_value + 0.5) : (int)(y_value - 0.5);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (this.display3dOn && this.stackedOn) {
                        if (serie == 0) {
                            int[] nArray = this.samplePoints[serie][sample];
                            nArray[1] = nArray[1] - this.depth3dPoint.y;
                        }
                    } else if (this.display3dOn) {
                        int[] nArray = this.samplePoints[serie][sample];
                        nArray[1] = nArray[1] - this.depth3dPoint.y;
                        double depth_y = (double)this.depth3dPoint.y / (double)this.getSeriesCount() * (double)serie;
                        int[] nArray2 = this.samplePoints[serie][sample];
                        nArray2[1] = nArray2[1] + (int)Math.round(depth_y);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                sample_xpos += delta_x;
            }
        }
        this.chart.needChartCalculation = false;
    }

    protected void checkDataIntegrity() {
        if (this.lastSelectedLine >= this.chart.getSeriesCount()) {
            this.lastSelectedLine = -1;
        }
    }

    protected void renderData(Graphics g, Rectangle gridBounds, Rectangle dataBounds) {
        this.paintLines((Graphics2D)g, gridBounds, dataBounds);
    }

    protected Point getSampleCenter(int sample, int serie) {
        Point centerPoint;
        Rectangle bounds = new Rectangle(this.chart.getGraphBounds());
        bounds.grow(1, 1);
        if (this.chart.is3DModeOn()) {
            bounds.x -= this.depth3dPoint.x;
            bounds.width += this.depth3dPoint.x;
            bounds.height -= this.depth3dPoint.y;
        }
        if ((centerPoint = this.chart.getSamplePoint(serie, sample)) != null && bounds.contains(centerPoint)) {
            return centerPoint;
        }
        return null;
    }

    protected void calculateGraphBounds(Rectangle gridBounds) {
        this.legendRenderer.calculateGraphBounds(this.legend, gridBounds);
        Dimension size = this.chart.getSize();
        int left = gridBounds.x;
        int right = size.width - gridBounds.width - gridBounds.x;
        int top = gridBounds.y;
        int bottom = size.height - gridBounds.height - gridBounds.y;
        this.display3dOn = this.chart.is3DModeOn();
        this.stackedOn = this.chart.isStackedOn();
        boolean display3dOn = this.chart.is3DModeOn();
        if (display3dOn) {
            if (this.parentRenderer != null) {
                if (this.parentRenderer instanceof BarChartRenderer || this.parentRenderer instanceof LineChartRenderer) {
                    this.depth3dPoint.x = this.parentRenderer.depth3dPoint.x / this.parentRenderer.getSeriesCount();
                    this.depth3dPoint.y = this.parentRenderer.depth3dPoint.y / this.parentRenderer.getSeriesCount();
                }
            } else if (this.chart.depth3d > -1) {
                this.depth3dPoint.x = Math.round((float)this.chart.depth3d * 1.25f);
                this.depth3dPoint.y = Math.round((float)(-this.chart.depth3d) / 1.25f);
            } else {
                int sample_count = Math.max(this.chart.getSampleCount(), 20);
                if (this.chart.getSeriesCount() > 1 && !this.stackedOn) {
                    sample_count /= this.chart.getSeriesCount();
                    sample_count = Math.max(sample_count, 4);
                }
                double sampleWidth = (double)gridBounds.width / (double)sample_count;
                this.depth3dPoint.x = (int)Math.round(sampleWidth * 1.25);
                this.depth3dPoint.y = (int)Math.round(-sampleWidth / 1.25);
            }
        }
        String[] labels = null;
        Font font = this.getFont("sampleLabelFont");
        int angle = this.getLabelAngle("sampleLabelAngle");
        if (this.isAnyBelowLabelsOn()) {
            labels = this.chart.getSampleLabels();
        } else {
            for (int i = 0; i < this.overlayRenderers.size(); ++i) {
                ChartRenderer overlay = (ChartRenderer)this.overlayRenderers.elementAt(i);
                if (overlay == null || !(overlay.chart instanceof Chart) || !overlay.isAnyBelowLabelsOn()) continue;
                font = overlay.getFont("sampleLabelFont");
                angle = overlay.getLabelAngle("sampleLabelAngle");
                labels = ((Chart)overlay.chart).getSampleLabels();
                if (!(overlay instanceof BarChartRenderer) || !((BarChart)overlay.chart).isBarLabelsOn()) break;
                font = overlay.getFont("barLabelFont");
                angle = overlay.getLabelAngle("barLabelAngle");
                labels = ((BarChart)overlay.chart).getBarLabels();
                break;
            }
        }
        if (this.getSampleCount() > 0 && labels != null) {
            FontMetrics fm = this.getFontMetrics(font);
            int height = 0;
            for (int i = 0; i < labels.length; ++i) {
                Dimension labelSize = this.getLabelSize(labels[i], fm);
                Dimension angledSize = this.getAngledLabelSize(labelSize, angle);
                height = Math.max(angledSize.height, height);
            }
            int bottom_offset = height + 6;
            if (angle % 180 == 0) {
                bottom_offset -= fm.getMaxDescent();
            }
            bottom += bottom_offset;
        }
        if (display3dOn) {
            left += this.depth3dPoint.x;
            bottom -= this.depth3dPoint.y;
            for (int i = 0; i < this.overlayRenderers.size(); ++i) {
                ChartRenderer overlay = (ChartRenderer)this.overlayRenderers.elementAt(i);
                if (overlay == null || !(overlay.chart instanceof Chart)) continue;
                overlay.depth3dPoint.x = this.depth3dPoint.x / this.chart.getSeriesCount();
                overlay.depth3dPoint.y = this.depth3dPoint.y / this.chart.getSeriesCount();
            }
        }
        gridBounds.x = left;
        gridBounds.width = size.width - left - right;
        gridBounds.y = top;
        gridBounds.height = size.height - top - bottom;
        this.gridRenderer.calculateGraphBounds(this.chart.getGrid(), gridBounds);
    }

    private void paintLines(Graphics2D g, Rectangle gridBounds, Rectangle dataBounds) {
        int seriesCount = this.getSeriesCount();
        if (seriesCount > 0) {
            int range;
            int i;
            int[][] areaSeries = this.chart.areaSeries;
            Color[] areaColors = this.chart.areaColors;
            if (this.display3dOn) {
                if (this.stackedOn) {
                    this.paintStacked3DLines(g, seriesCount, gridBounds, dataBounds);
                } else {
                    for (int i2 = seriesCount - 1; i2 >= 0; --i2) {
                        int range2 = this.chart.getSeriesRange(i2);
                        if (this.chart.getCurrentRange(range2) == this.chart.getCurrentLowerRange(range2)) continue;
                        this.paintLine(g, i2, gridBounds, dataBounds, this.chart.getSampleColor(i2), this.chart.isSelected(i2, -1));
                    }
                }
            }
            boolean repaint_selected = true;
            for (i = 0; areaSeries != null && i < areaSeries.length; ++i) {
                range = this.chart.getSeriesRange(i);
                if (this.stackedOn || this.chart.getCurrentRange(range) == this.chart.getCurrentLowerRange(range) || areaSeries[i] == null) continue;
                Color color = new Color(231, 231, 231);
                if (areaColors != null && i < areaColors.length && areaColors[i] != null) {
                    color = areaColors[i];
                }
                this.paintArea(g, i, areaSeries[i][0], areaSeries[i][1], gridBounds, dataBounds, color, false);
                if (areaSeries[i][0] != this.lastSelectedLine && areaSeries[i][1] != this.lastSelectedLine) continue;
                repaint_selected = false;
            }
            if (!this.display3dOn) {
                for (i = seriesCount - 1; i >= 0; --i) {
                    range = this.chart.getSeriesRange(i);
                    if (this.chart.getCurrentRange(range) == this.chart.getCurrentLowerRange(range)) continue;
                    this.paintLine(g, i, gridBounds, dataBounds, this.chart.getSampleColor(i), this.chart.isSelected(i, -1));
                }
            }
            if (!this.display3dOn && repaint_selected && this.lastSelectedLine >= 0) {
                i = this.lastSelectedLine;
                this.paintLine(g, i, gridBounds, dataBounds, this.chart.getSampleColor(i), this.chart.isSelected(i, -1));
            }
            if (this.chart.isValueLabelsOn(-1) || this.chart.isSampleLabelsOn() || this.chart.isSeriesLabelsOn()) {
                this.paintStaticLabels(g, gridBounds, dataBounds);
            }
        }
    }

    protected void paintStacked3DLines(Graphics2D g, int seriesCount, Rectangle gridBounds, Rectangle dataBounds) {
        int series;
        Polygon poly = new Polygon();
        poly.addPoint(gridBounds.x - this.depth3dPoint.x + 1, gridBounds.y - this.depth3dPoint.y + 1);
        poly.addPoint(gridBounds.x + 1, gridBounds.y + 1);
        poly.addPoint(gridBounds.x + gridBounds.width, gridBounds.y + 1);
        poly.addPoint(gridBounds.x + gridBounds.width, gridBounds.y + gridBounds.height);
        poly.addPoint(gridBounds.x + gridBounds.width - this.depth3dPoint.x, gridBounds.y + gridBounds.height - this.depth3dPoint.y);
        poly.addPoint(gridBounds.x - this.depth3dPoint.x + 1, gridBounds.y + gridBounds.height - this.depth3dPoint.y);
        g.setClip(poly);
        double depth_x = this.depth3dPoint.x;
        double depth_y = this.depth3dPoint.y;
        if (this.chart.getLine3DLayout() == 0 && !this.stackedOn) {
            depth_x /= (double)seriesCount;
            depth_y /= (double)seriesCount;
        }
        boolean[] paintSerie = new boolean[seriesCount];
        for (int serie = 0; serie < paintSerie.length; ++serie) {
            int range = this.chart.getSeriesRange(serie);
            paintSerie[serie] = this.chart.getCurrentRange(range) != this.chart.getCurrentLowerRange(range);
            ChartSample[] samples = this.chart.getSamples(serie);
            if (samples != null && samples.length != 0 && this.samplePoints != null && serie < this.samplePoints.length) continue;
            paintSerie[serie] = false;
        }
        double[] x1 = new double[seriesCount];
        double[] y1 = new double[seriesCount];
        double[] x2 = new double[seriesCount];
        double[] y2 = new double[seriesCount];
        for (int series2 = 0; series2 < seriesCount; ++series2) {
            x1[series2] = -2.147483648E9;
            y1[series2] = -2.147483648E9;
            x2[series2] = -2.147483648E9;
            y2[series2] = -2.147483648E9;
        }
        int sampleCount = this.chart.getSampleCount();
        int[] firstValid = new int[seriesCount];
        int[] lastValid = new int[seriesCount];
        for (series = 0; series < seriesCount; ++series) {
            firstValid[series] = Integer.MIN_VALUE;
            lastValid[series] = Integer.MIN_VALUE;
        }
        block9: for (series = 0; series < seriesCount; ++series) {
            int sample;
            ChartSample[] samples = this.chart.getSamples(series);
            for (sample = 0; sample < sampleCount; ++sample) {
                if (samples[sample] == null || samples[sample].value == null || samples[sample].value.isNaN()) continue;
                firstValid[series] = sample;
                break;
            }
            for (sample = sampleCount - 1; sample >= 0; --sample) {
                if (samples[sample] == null || samples[sample].value == null || samples[sample].value.isNaN()) continue;
                lastValid[series] = sample;
                continue block9;
            }
        }
        double[] offset_x = new double[seriesCount];
        double[] offset_y = new double[seriesCount];
        for (int series3 = 0; series3 < seriesCount; ++series3) {
            double lineDepth = this.chart.getLine3DDepth(series3);
            offset_x[series3] = (1.0 - lineDepth) * depth_x * 0.5;
            offset_y[series3] = (1.0 - lineDepth) * depth_y * 0.5;
        }
        int[] visibleSamples = this.chart.getVisibleSamples();
        int startIndex = Math.max(visibleSamples[0] - 2, 0);
        int stopIndex = Math.min(startIndex + visibleSamples[1] + 5, sampleCount);
        if (this.chart.isRightToLeftScrollingOn()) {
            startIndex = 0;
            stopIndex = sampleCount;
        }
        for (int sample = startIndex; sample <= stopIndex - 1; ++sample) {
            int series4;
            boolean[] connected = new boolean[seriesCount];
            boolean[] prev_sample_valid = new boolean[seriesCount];
            boolean[] this_sample_valid = new boolean[seriesCount];
            boolean[] next_sample_valid = new boolean[seriesCount];
            for (series4 = 0; series4 < seriesCount; ++series4) {
                ChartSample[] samples = this.chart.getSamples(series4);
                connected[series4] = this.chart.isConnectedLinesOn(series4);
                prev_sample_valid[series4] = sample > 0 && samples[sample - 1] != null && samples[sample - 1].value != null && !samples[sample - 1].value.isNaN();
                this_sample_valid[series4] = samples[sample] != null && samples[sample].value != null && !samples[sample].value.isNaN();
                next_sample_valid[series4] = sample < sampleCount - 1 && samples[sample + 1] != null && samples[sample + 1].value != null && !samples[sample + 1].value.isNaN();
            }
            for (series4 = 0; series4 < seriesCount; ++series4) {
                if (!this_sample_valid[series4] || prev_sample_valid[series4]) continue;
                this.paintStackedLineEdge(g, series4, sample, gridBounds, depth_x, depth_y, offset_x, offset_y);
            }
            for (series4 = 0; series4 < seriesCount; ++series4) {
                if (!prev_sample_valid[series4] || !this_sample_valid[series4] || next_sample_valid[series4]) continue;
                this.paintStackedLineEdge(g, series4, sample, gridBounds, depth_x, depth_y, offset_x, offset_y);
            }
            for (series4 = seriesCount - 1; series4 >= 0; --series4) {
                if (!paintSerie[series4]) continue;
                try {
                    if (!this_sample_valid[series4] || !next_sample_valid[series4]) continue;
                    x1[series4] = (double)(this.samplePoints[series4][sample][0] - this.depth3dPoint.x) + offset_x[series4];
                    y1[series4] = (double)this.samplePoints[series4][sample][1] + offset_y[series4];
                    x2[series4] = (double)(this.samplePoints[series4][sample + 1][0] - this.depth3dPoint.x) + offset_x[series4];
                    y2[series4] = (double)this.samplePoints[series4][sample + 1][1] + offset_y[series4];
                    if (!this.chart.isSeriesLineOn(series4)) continue;
                    this.paint3DLine(g, series4, x1[series4], y1[series4], x2[series4], y2[series4], 0.0, this.chart.getSampleColor(series4), true, false, 2, this.chart.isOutlineOn(series4));
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            for (series4 = 0; series4 < seriesCount; ++series4) {
                if (!paintSerie[series4]) continue;
                try {
                    if (!this_sample_valid[series4] || !next_sample_valid[series4]) continue;
                    x1[series4] = (double)(this.samplePoints[series4][sample][0] - this.depth3dPoint.x) + offset_x[series4];
                    y1[series4] = (double)this.samplePoints[series4][sample][1] + offset_y[series4];
                    x2[series4] = (double)(this.samplePoints[series4][sample + 1][0] - this.depth3dPoint.x) + offset_x[series4];
                    y2[series4] = (double)this.samplePoints[series4][sample + 1][1] + offset_y[series4];
                    if (!this.chart.isSeriesLineOn(series4)) continue;
                    this.paint3DLine(g, series4, x1[series4], y1[series4], x2[series4], y2[series4], 0.0, this.chart.getSampleColor(series4), true, false, 1, this.chart.isOutlineOn(series4));
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        for (int i = 0; i < seriesCount; ++i) {
            ChartSample[] samples;
            int range = this.chart.getSeriesRange(i);
            if (this.chart.getCurrentRange(range) == this.chart.getCurrentLowerRange(range) || (samples = this.chart.getSamples(i)) == null || samples.length == 0 || this.samplePoints == null || i >= this.samplePoints.length) continue;
            this.paintLine(g, i, gridBounds, dataBounds, this.chart.getSampleColor(i), this.chart.isSelected(i, -1));
        }
    }

    private void paintStackedLineEdge(Graphics2D g, int series, int sample, Rectangle gridBounds, double depth_x, double depth_y, double[] offset_x, double[] offset_y) {
        GeneralPath path = new GeneralPath();
        try {
            double x = (double)this.samplePoints[series][sample][0] - depth_x + offset_x[series];
            double y = (double)this.samplePoints[series][sample][1] + offset_y[series];
            double prev_y = (series > 0 ? (double)this.samplePoints[series - 1][sample][1] : (double)(gridBounds.y + gridBounds.height) - depth_y) + offset_y[series];
            path.moveTo((float)x, (float)y);
            path.lineTo((float)(x + depth_x - offset_x[series] * 2.0), (float)(y + depth_y - offset_y[series] * 2.0));
            path.lineTo((float)(x + depth_x - offset_x[series] * 2.0), (float)(prev_y + depth_y - offset_y[series] * 2.0));
            path.lineTo((float)x, (float)prev_y);
            path.closePath();
            g.setPaint(LineChartRenderer.getDarker(this.chart.getSampleColor(series)));
            g.fill(path);
            if (this.chart.isOutlineOn(series)) {
                g.draw(path);
            }
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    protected void paintLine(Graphics g, int series, Rectangle gridBounds, Rectangle dataBounds, Color color, boolean selected) {
        ChartSample[] samples;
        int seriesCount = this.getSeriesCount();
        if (series < 0 || series >= seriesCount) {
            throw new IllegalArgumentException("Invalid series: " + series);
        }
        if (selected) {
            this.lastSelectedLine = series;
        }
        if ((samples = this.chart.getSamples(series)) == null || samples.length == 0 || this.samplePoints == null || series >= this.samplePoints.length) {
            return;
        }
        Graphics cg = g;
        if (this.display3dOn) {
            Polygon poly = new Polygon();
            poly.addPoint(gridBounds.x - this.depth3dPoint.x + 1, gridBounds.y - this.depth3dPoint.y + 1);
            poly.addPoint(gridBounds.x + 1, gridBounds.y + 1);
            poly.addPoint(gridBounds.x + gridBounds.width, gridBounds.y + 1);
            poly.addPoint(gridBounds.x + gridBounds.width, gridBounds.y + gridBounds.height);
            poly.addPoint(gridBounds.x + gridBounds.width - this.depth3dPoint.x, gridBounds.y + gridBounds.height - this.depth3dPoint.y);
            poly.addPoint(gridBounds.x - this.depth3dPoint.x + 1, gridBounds.y + gridBounds.height - this.depth3dPoint.y);
            cg.setClip(poly);
        } else {
            cg.setClip(gridBounds.x + 1, gridBounds.y + 1, gridBounds.width - 1, gridBounds.height - 1);
        }
        if (this.chart.getLineStyle(series) == 1) {
            this.paintTubeLine((Graphics2D)g, samples, series, gridBounds, dataBounds, selected);
        } else if (this.stackedOn) {
            this.paintStackedLine((Graphics2D)g, samples, series, gridBounds, dataBounds, color, selected);
        } else if (this.display3dOn) {
            this.paintSimple3DLine((Graphics2D)g, samples, series, gridBounds, dataBounds, color, selected);
        } else {
            if (this.chart.isSeriesLineOn(series)) {
                this.paintSimpleLine((Graphics2D)g, samples, series, gridBounds, dataBounds, color, selected);
            }
            this.paintSampleHighlights(g, samples, series, gridBounds, color);
        }
        g.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    protected void paintSimpleLine(Graphics2D g, ChartSample[] samples, int series, Rectangle gridBounds, Rectangle dataBounds, Color color, boolean selected) {
        Color color2 = this.chart.getSampleColor2(series);
        if (selected) {
            color = LineChartRenderer.getDarker(color);
            color2 = LineChartRenderer.getDarker(color2);
        }
        int x1 = Integer.MIN_VALUE;
        int y1 = Integer.MIN_VALUE;
        int x2 = Integer.MIN_VALUE;
        int y2 = Integer.MIN_VALUE;
        if (color2 == null || color == color2) {
            g.setColor(color);
        } else {
            GradientPaint gp = new GradientPaint(dataBounds.x, 0.0f, color, dataBounds.x + dataBounds.width, 0.0f, color2);
            g.setPaint(gp);
        }
        int line_width = this.chart.getLineWidth(series);
        float[] lineStroke = this.chart.getLineStroke(series);
        boolean lineStroke_set = false;
        for (int i = 0; lineStroke != null && i < lineStroke.length; ++i) {
            if (lineStroke[0] == 0.0f) continue;
            lineStroke_set = true;
            break;
        }
        if (!lineStroke_set) {
            lineStroke = null;
        }
        BasicStroke bs = new BasicStroke(line_width, 1, 0, 1.0f, lineStroke, 0.0f);
        BasicStroke normal = new BasicStroke(1.0f, 1, 0, 1.0f, null, 0.0f);
        for (int sample = 0; sample < samples.length - 1; ++sample) {
            boolean isNaN;
            boolean next_sample_valid;
            boolean sampleHighlightOn = this.chart.isSampleHighlightOn(series, sample);
            boolean this_sample_valid = samples[sample] != null && samples[sample].value != null && !samples[sample].value.isNaN();
            boolean bl = next_sample_valid = samples[sample + 1] != null && samples[sample + 1].value != null && !samples[sample + 1].value.isNaN();
            if (this_sample_valid) {
                try {
                    x1 = this.samplePoints[series][sample][0];
                    y1 = this.samplePoints[series][sample][1];
                }
                catch (IndexOutOfBoundsException e) {
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            boolean bl2 = isNaN = samples[sample] == null || samples[sample].value == null || samples[sample].value.isNaN();
            if (isNaN && !this.chart.isConnectedLinesOn(series)) {
                x1 = Integer.MIN_VALUE;
            }
            if (!this_sample_valid && x1 == Integer.MIN_VALUE || !next_sample_valid) continue;
            try {
                x2 = this.samplePoints[series][sample + 1][0];
                y2 = this.samplePoints[series][sample + 1][1];
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            if (sampleHighlightOn) {
                if (y1 >= gridBounds.y && y1 <= gridBounds.y + gridBounds.height - this.depth3dPoint.y && x1 >= gridBounds.x - this.depth3dPoint.x && x1 <= gridBounds.x + gridBounds.width + 1 + this.depth3dPoint.x) {
                    this.paintSampleHighlight(g, series, sample, x1, y1, color);
                }
                if (this.display3dOn) {
                    int size = this.chart.getSampleHighlightSize(series);
                    x1 += size / 2;
                    x2 -= size / 2;
                }
            }
            if (!this.chart.isSeriesLineOn(series)) continue;
            boolean inside_grid = false;
            int left = gridBounds.x - (this.display3dOn ? this.depth3dPoint.x * 2 : 0);
            int right = gridBounds.x + gridBounds.width;
            inside_grid |= x1 >= left && x1 <= right;
            inside_grid |= x2 >= left && x2 <= right;
            if (!(inside_grid |= x1 <= left && x2 >= right)) continue;
            g.setStroke(bs);
            g.drawLine(x1, y1, x2, y2);
            g.setStroke(normal);
        }
    }

    protected void paintSampleHighlights(Graphics g, ChartSample[] samples, int series, Rectangle gridBounds, Color color) {
        for (int sample = 0; samples != null && sample < samples.length; ++sample) {
            ChartSample s = samples[sample];
            if (!this.chart.isSampleHighlightOn(series, sample) || s == null || !s.hasValue()) continue;
            try {
                int xpos = this.getSamplePoint3DX(this.samplePoints[series][sample][0], series) - this.depth3dPoint.x;
                int ypos = this.getSamplePoint3DY(this.samplePoints[series][sample][1], series);
                if (ypos < gridBounds.y || ypos > gridBounds.y + gridBounds.height - this.depth3dPoint.y || xpos < gridBounds.x - this.depth3dPoint.x || xpos > gridBounds.x + gridBounds.width + 1 + this.depth3dPoint.x) continue;
                this.paintSampleHighlight(g, series, sample, xpos, ypos, color);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected void paintSimple3DLine(Graphics2D g, ChartSample[] samples, int series, Rectangle gridBounds, Rectangle dataBounds, Color color, boolean selected) {
        int sample;
        int seriesCount = this.chart.getSeriesCount();
        double depth_x = this.depth3dPoint.x;
        double depth_y = this.depth3dPoint.y;
        if (this.chart.getLine3DLayout() == 0 && !this.stackedOn) {
            depth_x /= (double)seriesCount;
            depth_y /= (double)seriesCount;
        }
        double lineDepth = this.chart.getLine3DDepth(series);
        int offset_x = (int)((1.0 - lineDepth) * depth_x * 0.5);
        int offset_y = (int)((1.0 - lineDepth) * depth_y * 0.5);
        depth_x *= lineDepth;
        depth_y *= lineDepth;
        int x1 = Integer.MIN_VALUE;
        int y1 = Integer.MIN_VALUE;
        int x2 = Integer.MIN_VALUE;
        int y2 = Integer.MIN_VALUE;
        int[] visibleSamples = this.chart.getVisibleSamples();
        int startIndex = Math.max(visibleSamples[0] - 2, 0);
        int stopIndex = Math.min(startIndex + visibleSamples[1] + 5, this.chart.getSampleCount());
        if (this.chart.isRightToLeftScrollingOn()) {
            startIndex = 0;
            stopIndex = this.getSampleCount();
        }
        for (sample = startIndex; sample < stopIndex - 1; ++sample) {
            boolean isNaN;
            boolean next_sample_valid;
            boolean sampleHighlightOn = this.chart.isSampleHighlightOn(series, sample);
            boolean this_sample_valid = samples[sample] != null && samples[sample].value != null && !samples[sample].value.isNaN();
            boolean bl = next_sample_valid = samples[sample + 1] != null && samples[sample + 1].value != null && !samples[sample + 1].value.isNaN();
            if (this_sample_valid) {
                try {
                    x1 = this.samplePoints[series][sample][0] - this.depth3dPoint.x + offset_x;
                    y1 = this.samplePoints[series][sample][1] + offset_y;
                }
                catch (IndexOutOfBoundsException e) {
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            boolean bl2 = isNaN = samples[sample] != null && samples[sample].value != null && samples[sample].value.isNaN();
            if (isNaN && !this.chart.isConnectedLinesOn(series)) {
                x1 = Integer.MIN_VALUE;
            }
            if (!this_sample_valid && x1 == Integer.MIN_VALUE || !next_sample_valid) continue;
            try {
                x2 = this.samplePoints[series][sample + 1][0] - this.depth3dPoint.x + offset_x;
                y2 = this.samplePoints[series][sample + 1][1] + offset_y;
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            if (sampleHighlightOn) {
                this.paintSampleHighlight(g, series, sample, x1, y1, color);
                int size = this.chart.getSampleHighlightSize(series);
                x1 += size / 2;
                x2 -= size / 2;
            }
            if (!this.chart.isSeriesLineOn(series)) continue;
            this.paint3DLine(g, series, x1, y1, x2, y2, 0.0, color, true, false, 0, this.chart.isOutlineOn(series));
        }
        ChartSample s = samples[sample];
        if (this.chart.isSampleHighlightOn(series, sample) && s != null && s.hasValue()) {
            this.paintSampleHighlight(g, series, sample, this.getSamplePoint3DX(this.samplePoints[series][sample][0], series) - this.depth3dPoint.x, this.getSamplePoint3DY(this.samplePoints[series][sample][1], series), color);
        }
    }

    protected void paintStackedLine(Graphics2D g, ChartSample[] samples, int serie, Rectangle gridBounds, Rectangle dataBounds, Color color, boolean selected) {
        this.paintStackedLine(g, samples, serie, gridBounds, dataBounds, color, selected, false);
    }

    protected void paintStackedLine(Graphics2D g, ChartSample[] samples, int serie, Rectangle gridBounds, Rectangle dataBounds, Color color, boolean selected, boolean paintEdge) {
        Color color2 = this.chart.getSampleColor2(serie);
        if (selected) {
            color = LineChartRenderer.getDarker(color);
            color2 = LineChartRenderer.getDarker(color2);
        }
        Paint paint = color;
        if (color2 != null) {
            paint = new GradientPaint(dataBounds.x, 0.0f, color, dataBounds.x + dataBounds.width, 0.0f, color2);
        }
        Paint outline = LineChartRenderer.getDarker(color);
        if (color2 != null) {
            outline = new GradientPaint(dataBounds.x, 0.0f, LineChartRenderer.getDarker(color), dataBounds.x + dataBounds.width, 0.0f, LineChartRenderer.getDarker(color2));
        }
        double dx = this.display3dOn ? (double)this.depth3dPoint.x : 0.0;
        double dy = this.display3dOn ? (double)this.depth3dPoint.y : 0.0;
        double lineDepth = this.chart.getLine3DDepth(serie);
        double offset_y = (1.0 - lineDepth) * dy * 0.5;
        double offset_x = (1.0 - lineDepth) * dx * 0.5;
        double x1 = 0.0;
        double y1 = 0.0;
        double y4 = 0.0;
        int[] visibleSamples = this.chart.getVisibleSamples();
        int startIndex = Math.max(visibleSamples[0] - 2, 0);
        int stopIndex = Math.min(startIndex + visibleSamples[1] + 5, this.chart.getSampleCount());
        if (this.chart.isRightToLeftScrollingOn()) {
            startIndex = 0;
            stopIndex = this.getSampleCount();
        }
        for (int sample = startIndex; sample < stopIndex; ++sample) {
            int j;
            boolean sample_valid;
            boolean bl = sample_valid = samples[sample] != null && samples[sample].value != null && !samples[sample].value.isNaN();
            while (!sample_valid && sample < stopIndex - 1) {
                sample_valid = samples[++sample] != null && samples[sample].value != null && !samples[sample].value.isNaN();
            }
            double[][] upperPoints = new double[stopIndex - startIndex][2];
            double[][] lowerPoints = new double[stopIndex - startIndex][2];
            int i = 0;
            while (sample_valid && sample < stopIndex) {
                try {
                    x1 = (double)this.samplePoints[serie][sample][0] - dx + offset_x;
                    y1 = (double)this.samplePoints[serie][sample][1] + offset_y;
                    y4 = (serie > 0 ? (double)this.samplePoints[serie - 1][sample][1] : (double)this.gridRenderer.zeroLine[this.chart.getSeriesRange(serie)] - dy) + offset_y;
                }
                catch (IndexOutOfBoundsException e) {
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                upperPoints[i][0] = x1;
                upperPoints[i][1] = y1;
                lowerPoints[i][0] = x1;
                lowerPoints[i][1] = y4;
                ++i;
                sample_valid = ++sample < samples.length && samples[sample] != null && samples[sample].value != null && !samples[sample].value.isNaN();
            }
            GeneralPath path = new GeneralPath();
            path.moveTo((float)upperPoints[0][0], (float)upperPoints[0][1]);
            for (j = 1; j < i; ++j) {
                path.lineTo((float)upperPoints[j][0], (float)upperPoints[j][1]);
            }
            for (j = i - 1; j >= 0; --j) {
                path.lineTo((float)lowerPoints[j][0], (float)lowerPoints[j][1]);
            }
            path.closePath();
            g.setPaint(paint);
            g.fill(path);
            if (!this.chart.isOutlineOn(serie)) continue;
            g.setPaint(outline);
            g.draw(path);
        }
    }

    private void paintTubeLine(Graphics2D g, ChartSample[] samples, int series, Rectangle gridBounds, Rectangle dataBounds, boolean selected) {
        int line_width;
        Point2D.Float last_p3 = new Point2D.Float();
        Point2D.Float last_p4 = new Point2D.Float();
        Point2D.Float last_con_p1 = new Point2D.Float();
        Point2D.Float last_con_p2 = new Point2D.Float();
        Color color = this.chart.getSampleColor(series);
        Color color2 = this.chart.getSampleColor2(series);
        if (selected) {
            color = LineChartRenderer.getDarker(LineChartRenderer.getDarker(color));
            color2 = LineChartRenderer.getDarker(LineChartRenderer.getDarker(color2));
        }
        if (color.equals(color2)) {
            color2 = LineChartRenderer.getDarker(LineChartRenderer.getDarker(color));
            color = LineChartRenderer.getBrighter(color);
        }
        if ((line_width = this.chart.getLineWidth(series)) == 1) {
            this.paintSimpleLine(g, samples, series, gridBounds, dataBounds, color, selected);
            return;
        }
        BasicStroke bs = new BasicStroke(line_width, 0, 0);
        for (int sample = 0; sample < samples.length; ++sample) {
            boolean next_sample_valid;
            boolean this_sample_valid = samples[sample] != null && samples[sample].value != null && !samples[sample].value.isNaN();
            boolean prev_sample_valid = sample > 0 && samples[sample - 1] != null && samples[sample - 1].value != null && !samples[sample - 1].value.isNaN();
            boolean bl = next_sample_valid = sample < samples.length - 1 && samples[sample + 1] != null && samples[sample + 1].value != null && !samples[sample + 1].value.isNaN();
            if (!this_sample_valid) continue;
            int start_x = 0;
            int start_y = 0;
            int end_x = 0;
            int end_y = 0;
            try {
                start_x = this.getSamplePoint3DX(this.samplePoints[series][sample][0], series) - this.depth3dPoint.x;
                start_y = this.getSamplePoint3DY(this.samplePoints[series][sample][1], series);
                end_x = start_x;
                end_y = start_y;
                if (sample < samples.length - 1) {
                    end_x = this.getSamplePoint3DX(this.samplePoints[series][sample + 1][0], series) - this.depth3dPoint.x;
                    end_y = this.getSamplePoint3DY(this.samplePoints[series][sample + 1][1], series);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
            Line2D.Float line = new Line2D.Float(start_x, start_y, end_x, end_y);
            Shape lineStroke0 = bs.createStrokedShape(line);
            PathIterator pi = lineStroke0.getPathIterator(null);
            float[] coords = new float[2];
            pi.currentSegment(coords);
            Point2D.Float p1 = new Point2D.Float(coords[0], coords[1]);
            pi.next();
            pi.currentSegment(coords);
            Point2D.Float p3 = new Point2D.Float(coords[0], coords[1]);
            pi.next();
            pi.currentSegment(coords);
            Point2D.Float p4 = new Point2D.Float(coords[0], coords[1]);
            pi.next();
            pi.currentSegment(coords);
            Point2D.Float p2 = new Point2D.Float(coords[0], coords[1]);
            Point2D.Float con_p1 = new Point2D.Float(p1.x, p1.y);
            Point2D.Float con_p2 = new Point2D.Float(p2.x, p2.y);
            if (prev_sample_valid) {
                if (!next_sample_valid) {
                    con_p1 = last_p3;
                    con_p2 = last_p4;
                } else {
                    double ab = p1.distance(last_p3);
                    double alpha = Math.acos(ab / (double)line_width);
                    double bc = (double)line_width / (2.0 * Math.tan(alpha));
                    double bf = p3.distance(p1);
                    float eg = p3.x - p1.x;
                    float fg = p3.y - p1.y;
                    double ce = bc * (double)eg / bf;
                    double be = bc * (double)fg / bf;
                    if (!new Double(ce).isNaN() && !new Double(be).isNaN()) {
                        if (p1.x < last_p3.x) {
                            con_p1.x = p1.x + (float)ce;
                            con_p1.y = p1.y + (float)be;
                        } else {
                            con_p1.x = p1.x - (float)ce;
                            con_p1.y = p1.y - (float)be;
                        }
                    }
                    ab = p2.distance(last_p4);
                    alpha = Math.acos(ab / (double)line_width);
                    bc = (double)line_width / (2.0 * Math.tan(alpha));
                    bf = p4.distance(p2);
                    eg = p4.x - p2.x;
                    fg = p4.y - p2.y;
                    ce = bc * (double)eg / bf;
                    be = bc * (double)fg / bf;
                    if (p2.x < last_p4.x) {
                        con_p2.x = p2.x + (float)ce;
                        con_p2.y = p2.y + (float)be;
                    } else {
                        con_p2.x = p2.x - (float)ce;
                        con_p2.y = p2.y - (float)be;
                    }
                }
                float wi = (last_p4.x - last_p3.x) / 3.0f;
                float hi = (last_p3.y - last_p4.y) / 3.0f;
                if (color2 != null) {
                    g.setPaint(new GradientPaint(last_p3.x, last_p3.y, color2, last_p4.x - wi, last_p4.y + hi, color, true));
                } else {
                    g.setPaint(new GradientPaint(last_p3.x, last_p3.y, LineChartRenderer.getDarker(LineChartRenderer.getDarker(color)), last_p4.x - wi, last_p4.y + hi, color, true));
                }
                GeneralPath poly_path = new GeneralPath();
                poly_path.moveTo(last_con_p1.x, last_con_p1.y);
                poly_path.lineTo(last_con_p2.x, last_con_p2.y);
                poly_path.lineTo(con_p2.x, con_p2.y);
                poly_path.lineTo(con_p1.x, con_p1.y);
                poly_path.closePath();
                g.fill(poly_path);
                g.drawLine((int)con_p1.x, (int)con_p1.y - 1, (int)con_p2.x, (int)con_p2.y + 1);
            }
            last_con_p1 = con_p1;
            last_con_p2 = con_p2;
            last_p3 = p3;
            last_p4 = p4;
        }
    }

    private void paintTubeLine_(Graphics2D g, ChartSample[] samples, int series, Rectangle gridBounds, Rectangle dataBounds, boolean selected) {
        int line_width;
        Point2D.Float last_p3 = new Point2D.Float();
        Point2D.Float last_p4 = new Point2D.Float();
        Point2D.Float last_con_p1 = new Point2D.Float();
        Point2D.Float last_con_p2 = new Point2D.Float();
        Color color = this.chart.getSampleColor(series);
        Color color2 = this.chart.getSampleColor2(series);
        if (selected) {
            color = LineChartRenderer.getDarker(LineChartRenderer.getDarker(color));
            color2 = LineChartRenderer.getDarker(LineChartRenderer.getDarker(color2));
        }
        if (color.equals(color2)) {
            color2 = LineChartRenderer.getDarker(LineChartRenderer.getDarker(color));
            color = LineChartRenderer.getBrighter(color);
        }
        if ((line_width = this.chart.getLineWidth(series)) == 1) {
            this.paintSimpleLine(g, samples, series, gridBounds, dataBounds, color, selected);
            return;
        }
        BasicStroke bs = new BasicStroke(line_width, 0, 0);
        for (int sample = 0; sample < samples.length; ++sample) {
            int start_x = 0;
            int start_y = 0;
            int end_x = 0;
            int end_y = 0;
            try {
                start_x = this.getSamplePoint3DX(this.samplePoints[series][sample][0], series) - this.depth3dPoint.x;
                start_y = this.getSamplePoint3DY(this.samplePoints[series][sample][1], series);
                end_x = start_x;
                end_y = start_y;
                if (sample < samples.length - 1) {
                    end_x = this.getSamplePoint3DX(this.samplePoints[series][sample + 1][0], series) - this.depth3dPoint.x;
                    end_y = this.getSamplePoint3DY(this.samplePoints[series][sample + 1][1], series);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
            Line2D.Float line = new Line2D.Float(start_x, start_y, end_x, end_y);
            Shape lineStroke0 = bs.createStrokedShape(line);
            PathIterator pi = lineStroke0.getPathIterator(null);
            float[] coords = new float[2];
            pi.currentSegment(coords);
            Point2D.Float p1 = new Point2D.Float(coords[0], coords[1]);
            pi.next();
            pi.currentSegment(coords);
            Point2D.Float p3 = new Point2D.Float(coords[0], coords[1]);
            pi.next();
            pi.currentSegment(coords);
            Point2D.Float p4 = new Point2D.Float(coords[0], coords[1]);
            pi.next();
            pi.currentSegment(coords);
            Point2D.Float p2 = new Point2D.Float(coords[0], coords[1]);
            Point2D.Float con_p1 = new Point2D.Float(p1.x, p1.y);
            Point2D.Float con_p2 = new Point2D.Float(p2.x, p2.y);
            if (sample > 0) {
                if (sample == samples.length - 1) {
                    con_p1 = last_p3;
                    con_p2 = last_p4;
                } else {
                    double ab = p1.distance(last_p3);
                    double alpha = Math.acos(ab / (double)line_width);
                    double bc = (double)line_width / (2.0 * Math.tan(alpha));
                    double bf = p3.distance(p1);
                    float eg = p3.x - p1.x;
                    float fg = p3.y - p1.y;
                    double ce = bc * (double)eg / bf;
                    double be = bc * (double)fg / bf;
                    if (p1.x < last_p3.x) {
                        con_p1.x = p1.x + (float)ce;
                        con_p1.y = p1.y + (float)be;
                    } else {
                        con_p1.x = p1.x - (float)ce;
                        con_p1.y = p1.y - (float)be;
                    }
                    ab = p2.distance(last_p4);
                    alpha = Math.acos(ab / (double)line_width);
                    bc = (double)line_width / (2.0 * Math.tan(alpha));
                    bf = p4.distance(p2);
                    eg = p4.x - p2.x;
                    fg = p4.y - p2.y;
                    ce = bc * (double)eg / bf;
                    be = bc * (double)fg / bf;
                    if (p2.x < last_p4.x) {
                        con_p2.x = p2.x + (float)ce;
                        con_p2.y = p2.y + (float)be;
                    } else {
                        con_p2.x = p2.x - (float)ce;
                        con_p2.y = p2.y - (float)be;
                    }
                }
                float wi = (last_p4.x - last_p3.x) / 3.0f;
                float hi = (last_p3.y - last_p4.y) / 3.0f;
                if (color2 != null) {
                    g.setPaint(new GradientPaint(last_p3.x, last_p3.y, color2, last_p4.x - wi, last_p4.y + hi, color, true));
                } else {
                    g.setPaint(new GradientPaint(last_p3.x, last_p3.y, LineChartRenderer.getDarker(LineChartRenderer.getDarker(color)), last_p4.x - wi, last_p4.y + hi, color, true));
                }
                GeneralPath poly_path = new GeneralPath();
                poly_path.moveTo(last_con_p1.x, last_con_p1.y);
                poly_path.lineTo(last_con_p2.x, last_con_p2.y);
                poly_path.lineTo(con_p2.x, con_p2.y);
                poly_path.lineTo(con_p1.x, con_p1.y);
                poly_path.closePath();
                g.fill(poly_path);
                g.drawLine((int)con_p1.x, (int)con_p1.y - 1, (int)con_p2.x, (int)con_p2.y + 1);
            }
            last_con_p1 = con_p1;
            last_con_p2 = con_p2;
            last_p3 = p3;
            last_p4 = p4;
        }
    }

    protected void paintArea(Graphics2D g, int index, int serie1, int serie2, Rectangle gridBounds, Rectangle dataBounds, Color color, boolean selected) {
        int y2;
        int x2;
        int size;
        int y;
        int x;
        int sample;
        if (serie1 < 0 || serie1 >= this.samplePoints.length || serie2 < 0 || serie2 >= this.samplePoints.length) {
            return;
        }
        int seriesCount = this.getSeriesCount();
        int sampleCount = Math.min(this.getSampleCount(), Math.min(this.samplePoints[serie1].length, this.samplePoints[serie2].length));
        ChartSample[] samples1 = this.chart.getSamples(serie1);
        ChartSample[] samples2 = this.chart.getSamples(serie2);
        if (samples1 == null || samples1.length == 0 || samples2 == null || samples2.length == 0) {
            return;
        }
        if (this.display3dOn) {
            Polygon poly = new Polygon();
            poly.addPoint(gridBounds.x - this.depth3dPoint.x, gridBounds.y - this.depth3dPoint.y);
            poly.addPoint(gridBounds.x, gridBounds.y);
            poly.addPoint(gridBounds.x + gridBounds.width, gridBounds.y);
            poly.addPoint(gridBounds.x + gridBounds.width, gridBounds.y + gridBounds.height);
            poly.addPoint(gridBounds.x + gridBounds.width - this.depth3dPoint.x, gridBounds.y + gridBounds.height - this.depth3dPoint.y);
            poly.addPoint(gridBounds.x - this.depth3dPoint.x, gridBounds.y + gridBounds.height - this.depth3dPoint.y);
            g.setClip(poly);
        } else {
            g.setClip(gridBounds.x + 1, gridBounds.y, gridBounds.width - 1, gridBounds.height + 1);
        }
        Color color2 = this.chart.getAreaColor2(index);
        if (color2 == null) {
            color2 = color;
        }
        GradientPaint paint = new GradientPaint(dataBounds.x, 0.0f, color, dataBounds.x + dataBounds.width, 0.0f, color2);
        GradientPaint paint_darker = new GradientPaint(dataBounds.x, 0.0f, LineChartRenderer.getDarker(color), dataBounds.x + dataBounds.width, 0.0f, LineChartRenderer.getDarker(color2));
        int depth_x1 = this.depth3dPoint.x;
        int depth_y1 = this.depth3dPoint.y;
        int depth_x2 = this.depth3dPoint.x;
        int depth_y2 = this.depth3dPoint.y;
        if (this.chart.getLine3DLayout() == 0) {
            depth_x1 = (int)Math.round((double)this.depth3dPoint.x / (double)seriesCount);
            depth_y1 = (int)Math.round((double)this.depth3dPoint.y / (double)seriesCount);
            depth_x2 = (int)Math.round((double)this.depth3dPoint.x / (double)seriesCount);
            depth_y2 = (int)Math.round((double)this.depth3dPoint.y / (double)seriesCount);
        }
        depth_x1 = (int)((double)depth_x1 * this.chart.getLine3DDepth(serie1));
        depth_y1 = (int)((double)depth_y1 * this.chart.getLine3DDepth(serie1));
        depth_x2 = (int)((double)depth_x2 * this.chart.getLine3DDepth(serie2));
        depth_y2 = (int)((double)depth_y2 * this.chart.getLine3DDepth(serie2));
        Polygon poly = new Polygon();
        int dx = this.display3dOn ? this.depth3dPoint.x : 0;
        g.setPaint(paint_darker);
        for (sample = 0; sample < sampleCount; ++sample) {
            if (samples1[sample] == null || !samples1[sample].hasValue()) continue;
            x = this.getSamplePoint3DX(this.samplePoints[serie1][sample][0], serie1) - dx;
            y = this.getSamplePoint3DY(this.samplePoints[serie1][sample][1], serie1);
            int n = size = this.chart.isSampleHighlightOn(serie1) ? this.chart.getSampleHighlightSize(serie1) + 2 : 0;
            if (sample != 0) {
                poly.addPoint(x - size / 2, y);
            }
            poly.addPoint(x, y);
            if (sample != sampleCount - 1) {
                poly.addPoint(x + size / 2, y);
            }
            if (this.chart.isSeriesLineOn(serie1) || sample >= sampleCount - 1) continue;
            x2 = this.getSamplePoint3DX(this.samplePoints[serie1][sample + 1][0], serie1) - dx;
            y2 = this.getSamplePoint3DY(this.samplePoints[serie1][sample + 1][1], serie1);
            this.paint3DLine(g, serie1, x + size / 2, y, x2 - size / 2, y2, 0.0, color, true, false, 1, false);
            this.paint3DLine(g, serie1, x + size / 2, y, x2 - size / 2, y2, 0.0, color, true, false, 2, false);
        }
        for (sample = sampleCount - 1; sample >= 0; --sample) {
            if (samples2[sample] == null || !samples1[sample].hasValue()) continue;
            x = this.getSamplePoint3DX(this.samplePoints[serie2][sample][0], serie2) - dx;
            y = this.getSamplePoint3DY(this.samplePoints[serie2][sample][1], serie2);
            int n = size = this.chart.isSampleHighlightOn(serie2) ? this.chart.getSampleHighlightSize(serie2) + 2 : 0;
            if (sample != sampleCount - 1) {
                poly.addPoint(x + size / 2, y);
            }
            poly.addPoint(x, y);
            if (sample != 0) {
                poly.addPoint(x - size / 2, y);
            }
            if (this.chart.isSeriesLineOn(serie2) || sample >= sampleCount - 1) continue;
            x2 = this.getSamplePoint3DX(this.samplePoints[serie2][sample + 1][0], serie2) - dx;
            y2 = this.getSamplePoint3DY(this.samplePoints[serie2][sample + 1][1], serie2);
            this.paint3DLine(g, serie2, x + size / 2, y, x2 - size / 2, y2, 0.0, color, true, false, 1, false);
            this.paint3DLine(g, serie2, x + size / 2, y, x2 - size / 2, y2, 0.0, color, true, false, 2, false);
        }
        g.setPaint(paint);
        g.fillPolygon(poly);
        if (this.display3dOn) {
            int x1 = this.getSamplePoint3DX(this.samplePoints[serie1][sampleCount - 1][0], serie1) - dx;
            int y1 = this.getSamplePoint3DY(this.samplePoints[serie1][sampleCount - 1][1], serie1);
            int x22 = this.getSamplePoint3DX(this.samplePoints[serie2][sampleCount - 1][0], serie2) - dx;
            int y22 = this.getSamplePoint3DY(this.samplePoints[serie2][sampleCount - 1][1], serie2);
            poly = new Polygon();
            poly.addPoint(x1, y1);
            poly.addPoint(x1 + depth_x1, y1 + depth_y1);
            poly.addPoint(x22 + depth_x2, y22 + depth_y2);
            poly.addPoint(x22, y22);
            g.setColor(LineChartRenderer.getDarker(color));
            g.fillPolygon(poly);
            this.display3dOn = false;
            for (int sample2 = 0; sample2 < sampleCount && sample2 < this.samplePoints[serie1].length; ++sample2) {
                if (this.chart.isSampleHighlightOn(serie1)) {
                    this.paintSampleHighlights(g, this.chart.getSamples(serie1), serie1, gridBounds, this.chart.getSampleColor(serie1));
                }
                if (!this.chart.isSampleHighlightOn(serie2)) continue;
                this.paintSampleHighlights(g, this.chart.getSamples(serie2), serie2, gridBounds, this.chart.getSampleColor(serie2));
            }
            this.display3dOn = true;
            if (y1 < y22) {
                if (this.chart.isSampleHighlightOn(serie1)) {
                    this.paintSampleHighlight(g, serie1, sampleCount - 1, x1, y1, this.chart.getSampleColor(serie1));
                }
            } else if (this.chart.isSampleHighlightOn(serie2)) {
                this.paintSampleHighlight(g, serie2, sampleCount - 1, x22, y22, this.chart.getSampleColor(serie2));
            }
        }
        g.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    protected int getSamplePoint3DX(int x, int serie) {
        int seriesCount = this.chart.getSeriesCount();
        double depth_x = this.depth3dPoint.x;
        if (this.chart.getLine3DLayout() == 0 && !this.stackedOn) {
            depth_x /= (double)seriesCount;
        }
        double lineDepth = this.chart.getLine3DDepth(serie);
        int offset_x = (int)((1.0 - lineDepth) * depth_x * 0.5);
        if (this.chart.getLineStyle(serie) == 1) {
            offset_x = (int)(depth_x * 0.5);
        }
        return x + offset_x;
    }

    protected int getSamplePoint3DY(int y, int serie) {
        int seriesCount = this.chart.getSeriesCount();
        double depth_y = this.depth3dPoint.y;
        if (this.chart.getLine3DLayout() == 0 && !this.stackedOn) {
            depth_y /= (double)seriesCount;
        }
        double lineDepth = this.chart.getLine3DDepth(serie);
        int offset_y = (int)((1.0 - lineDepth) * depth_y * 0.5);
        if (this.chart.getLineStyle(serie) == 1) {
            offset_y = (int)(depth_y * 0.5);
        }
        return y + offset_y;
    }

    protected void paint3DLine(Graphics g, int x1, int y1, int x2, int y2, int y3, Color color, boolean top, boolean right, boolean outlined) {
        this.paint3DLine((Graphics2D)g, 0, x1, y1, x2, y2, y3, color, top, right, 1, outlined);
        this.paint3DLine((Graphics2D)g, 0, x1, y1, x2, y2, y3, color, top, right, 2, outlined);
    }

    private void paint3DLine(Graphics2D g, int serie, double x1, double y1, double x2, double y2, double y3, Color color, boolean top, boolean right, int perspective, boolean outlined) {
        float[] pos_x = new float[4];
        float[] pos_y = new float[4];
        int seriesCount = this.stackedOn ? 1 : Math.max(1, this.getSeriesCount());
        float lineDepth = (float)this.chart.getLine3DDepth(serie);
        float depth_x = this.depth3dPoint.x;
        float depth_y = this.depth3dPoint.y;
        if (this.chart.getLine3DLayout() == 0 && !this.stackedOn) {
            depth_x /= (float)seriesCount;
            depth_y /= (float)seriesCount;
        }
        pos_x[0] = (float)x1;
        pos_y[0] = (float)y1;
        pos_x[1] = pos_x[0] + (depth_x *= lineDepth);
        pos_y[1] = pos_y[0] + (depth_y *= lineDepth);
        pos_x[3] = (float)x2;
        pos_y[3] = (float)y2;
        pos_x[2] = pos_x[3] + depth_x;
        pos_y[2] = pos_y[3] + depth_y;
        Rectangle dataBounds = this.chart.getDataBounds(this.chart.getGraphBounds());
        if (top) {
            GradientPaint gp;
            GeneralPath path = new GeneralPath();
            path.moveTo(pos_x[0], pos_y[0]);
            path.lineTo(pos_x[1], pos_y[1]);
            path.lineTo(pos_x[2], pos_y[2]);
            path.lineTo(pos_x[3], pos_y[3]);
            double angle = 0.0;
            if (x2 - x1 != 0.0) {
                angle = (y1 - y2) / (x2 - x1);
            }
            Color color2 = this.chart.getSampleColor2(serie);
            if (this.stackedOn) {
                color = LineChartRenderer.getDarker(color);
                color2 = LineChartRenderer.getDarker(color2);
            }
            if (this.chart.isSelected(serie, -1)) {
                color = LineChartRenderer.getDarker(color);
                color2 = LineChartRenderer.getDarker(color2);
            }
            if (color2 == null) {
                g.setColor(angle > 0.69 ? LineChartRenderer.getDarker(color) : color);
            } else {
                gp = angle > 0.69 ? new GradientPaint(dataBounds.x, 0.0f, LineChartRenderer.getDarker(color), dataBounds.x + dataBounds.width, 0.0f, LineChartRenderer.getDarker(color2)) : new GradientPaint(dataBounds.x, 0.0f, color, dataBounds.x + dataBounds.width, 0.0f, color2);
                g.setPaint(gp);
            }
            if (perspective == 0) {
                g.fill(path);
            } else if (angle > 0.69 && perspective == 2) {
                g.fill(path);
            } else if (angle <= 0.69 && perspective == 1) {
                g.fill(path);
            }
            if (this.chart.isOutlineOn(serie)) {
                path.reset();
                path.moveTo(pos_x[0], pos_y[0]);
                path.lineTo(pos_x[1], pos_y[1]);
                path.lineTo(pos_x[2], pos_y[2]);
                if (!this.stackedOn) {
                    path.lineTo(pos_x[3], pos_y[3]);
                    path.closePath();
                }
                if (color2 == null) {
                    g.setColor(LineChartRenderer.getDarker(color));
                } else {
                    gp = new GradientPaint(dataBounds.x, 0.0f, LineChartRenderer.getDarker(color), dataBounds.x + dataBounds.width, 0.0f, LineChartRenderer.getDarker(color2));
                    g.setPaint(gp);
                }
                g.draw(path);
            }
        }
    }

    private boolean isLabelInside(double sample_xpos, double sample_ypos, double label_bottom, Rectangle gridBounds) {
        boolean inside;
        if (this.display3dOn) {
            if (sample_ypos <= label_bottom) {
                inside = sample_ypos >= (double)(gridBounds.y - 2) && sample_ypos <= (double)(gridBounds.y + gridBounds.height + 2 - this.depth3dPoint.y) && sample_xpos >= (double)(gridBounds.x - 2) && sample_xpos <= (double)(gridBounds.x + gridBounds.width + this.depth3dPoint.x + 2);
            } else {
                double x_change = (double)this.depth3dPoint.x / (double)this.getSeriesCount();
                double y_change = (double)this.depth3dPoint.y / (double)this.getSeriesCount();
                inside = sample_ypos >= (double)gridBounds.y - y_change - 2.0 && sample_ypos <= (double)(gridBounds.y + gridBounds.height - this.depth3dPoint.y) - y_change && sample_xpos >= (double)gridBounds.x - x_change - 2.0 && sample_xpos <= (double)(gridBounds.x + gridBounds.width) - x_change + (double)this.depth3dPoint.x + 2.0;
            }
        } else {
            inside = sample_ypos >= (double)(gridBounds.y - 2) && sample_ypos <= (double)(gridBounds.y + gridBounds.height + 2) && sample_xpos >= (double)(gridBounds.x - 4) && sample_xpos <= (double)(gridBounds.x + gridBounds.width + 2);
        }
        return inside;
    }

    private void paintStaticLabels(Graphics g, Rectangle gridBounds, Rectangle dataBounds) {
        int sampleCount = this.getSampleCount();
        int seriesCount = this.getSeriesCount();
        double delta_x = dataBounds.width;
        if (sampleCount > 2) {
            delta_x = (double)dataBounds.width / (double)(sampleCount - 1);
        }
        Font seriesLabelFont = this.getFont("seriesLabelFont");
        Font valueLabelFont = this.getFont("valueLabelFont");
        FontMetrics fm = this.getFontMetrics(valueLabelFont);
        int valueLabelAngle = this.getLabelAngle("valueLabelAngle");
        Font sampleLabelFont = this.getFont("sampleLabelFont");
        int sampleLabelAngle = this.getLabelAngle("sampleLabelAngle");
        for (int series = 0; series < seriesCount; ++series) {
            String postfix;
            String prefix;
            boolean outside;
            int valueLabelStyle = this.chart.getValueLabelStyle();
            int sampleLabelStyle = this.chart.getSampleLabelStyle();
            int seriesLabelStyle = this.chart.getSeriesLabelStyle();
            boolean valueLabelsOn = this.chart.isValueLabelsOn(series);
            boolean sampleLabelsOn = this.chart.isSampleLabelsOn();
            boolean seriesLabelsOn = this.chart.isSeriesLabelsOn();
            boolean inside = valueLabelStyle == 0 && valueLabelsOn;
            boolean bl = outside = valueLabelStyle == 1 && valueLabelsOn || sampleLabelStyle == 1 && sampleLabelsOn || seriesLabelStyle == 1 && seriesLabelsOn;
            if (this.stackedOn && outside) {
                if (series != 0) break;
                series = seriesCount - 1;
            }
            if ((prefix = this.getLabel("valueLabelPrefix_" + series)) == null) {
                prefix = this.getLabel("valueLabelPrefix");
            }
            if ((postfix = this.getLabel("valueLabelPostfix_" + series)) == null) {
                postfix = this.getLabel("valueLabelPostfix");
            }
            ChartSample[] values = this.chart.getSamples(series);
            int[] visibleSamples = this.chart.getVisibleSamples();
            int startIndex = Math.max(visibleSamples[0] - 1, 0);
            int stopIndex = Math.min(startIndex + visibleSamples[1] + 1, sampleCount);
            if (this.chart.isRightToLeftScrollingOn()) {
                startIndex = 0;
                stopIndex = this.getSampleCount();
            }
            for (int sample = startIndex; sample < stopIndex; ++sample) {
                if (!this.stackedOn && (values[sample] == null || values[sample].value == null || values[sample].value.isNaN())) continue;
                double value = 0.0;
                if (this.stackedOn && outside) {
                    boolean validValue = false;
                    for (int i = 0; i < seriesCount; ++i) {
                        ChartSample s = this.chart.getSample(i, sample);
                        if (s == null || s.value == null || s.value.isNaN()) continue;
                        value += s.value.doubleValue();
                        validValue = true;
                    }
                    if (!validValue) {
                        continue;
                    }
                } else {
                    ChartSample s = this.chart.getSample(series, sample);
                    if (s == null || s.value == null || s.value.isNaN()) continue;
                    value = values[sample].getFloatValue();
                }
                double previous = value;
                if (sample >= 1 && values[sample - 1] != null) {
                    previous = values[sample - 1].getFloatValue();
                }
                double next = value;
                if (sample < values.length - 1 && values[sample + 1] != null) {
                    next = values[sample + 1].getFloatValue();
                }
                double prev_slope = (value - previous) / delta_x;
                double next_slope = (next - value) / delta_x;
                Dimension valueAngledSize = new Dimension();
                int sample_xpos = Integer.MIN_VALUE;
                int sample_ypos = Integer.MIN_VALUE;
                if (this.samplePoints != null && series < this.samplePoints.length && sample < this.samplePoints[series].length) {
                    sample_xpos = this.samplePoints[series][sample][0];
                    sample_ypos = this.samplePoints[series][sample][1] - 1;
                }
                if (inside) {
                    String valueLabel = this.chart.formatSeriesNumber(series, value);
                    valueLabel = prefix != null ? prefix + valueLabel : valueLabel;
                    valueLabel = postfix != null ? valueLabel + postfix : valueLabel;
                    Dimension valueLabelSize = this.getLabelSize(valueLabel, fm);
                    valueAngledSize = this.getAngledLabelSize(valueLabelSize, valueLabelAngle);
                    Color fontColor = this.chart.getValueLabelColor(series);
                    if (fontColor == null) {
                        fontColor = this.chart.getChartForeground();
                    }
                    int label_xpos = Math.round(sample_xpos - valueAngledSize.width / 2) + 1;
                    int label_ypos = sample_ypos;
                    label_ypos = valueLabelAngle % 180 == 0 ? (label_ypos += fm.getAscent() / 2) : sample_ypos - valueAngledSize.height / 2;
                    if (this.display3dOn && !this.stackedOn) {
                        label_xpos -= this.depth3dPoint.x;
                        if (prev_slope >= next_slope) {
                            label_ypos = (int)((double)label_ypos + (double)this.depth3dPoint.y / (double)seriesCount);
                            label_xpos = (int)((double)label_xpos + (double)this.depth3dPoint.x / (double)seriesCount);
                        }
                    } else if (this.display3dOn && this.stackedOn) {
                        label_xpos -= this.depth3dPoint.x;
                    }
                    if (this.isLabelInside(sample_xpos, sample_ypos, label_ypos + valueAngledSize.height, gridBounds)) {
                        g.setColor(fontColor);
                        g.setFont(valueLabelFont);
                        this.paintLabel(g, valueLabel, label_xpos, label_ypos, valueLabelSize, this.chart.getMultilineLabelAlignment(), valueLabelAngle, false);
                    }
                }
                if (outside) {
                    String seriesLabel;
                    boolean sample_on;
                    int angle = 0;
                    Color fontColor = null;
                    Font font = null;
                    if (valueLabelStyle == 1 && valueLabelsOn) {
                        angle = valueLabelAngle;
                        fontColor = this.chart.getValueLabelColor(series);
                        font = valueLabelFont;
                    }
                    if (sampleLabelStyle == 1 && sampleLabelsOn) {
                        angle = sampleLabelAngle;
                        if (this.chart.getSampleLabelColor(sample) != null) {
                            fontColor = this.chart.getSampleLabelColor(sample);
                        }
                        font = sampleLabelFont;
                    }
                    if (seriesLabelStyle == 1 && seriesLabelsOn) {
                        if (font == null) {
                            font = seriesLabelFont;
                        }
                        if (fontColor == null) {
                            fontColor = this.chart.getSeriesLabelColor(series);
                        }
                    }
                    fm = this.getFontMetrics(font);
                    int vertical_offset = fm.getAscent();
                    if (fontColor == null) {
                        fontColor = this.chart.getChartForeground();
                    }
                    String label = "";
                    boolean bl2 = sample_on = sampleLabelsOn && sampleLabelStyle == 1;
                    if (seriesLabelsOn && seriesLabelStyle == 1 && (seriesLabel = this.chart.getSeriesLabel(series)) != null) {
                        label = label + seriesLabel;
                        if (!seriesLabel.endsWith("\n") && (sample_on && this.chart.getSampleLabel(sample) != null || valueLabelsOn && valueLabelStyle == 1)) {
                            label = label + ":";
                        }
                    }
                    String valueLabel = this.chart.formatSeriesNumber(series, value);
                    valueLabel = prefix != null ? prefix + valueLabel : valueLabel;
                    String string = valueLabel = postfix != null ? valueLabel + postfix : valueLabel;
                    if (sample_on) {
                        String sampleLabel = this.chart.getSampleLabel(sample);
                        if (sampleLabel != null && !sampleLabel.endsWith("\n") && valueLabel != null && valueLabelsOn && valueLabelStyle == 1) {
                            sampleLabel = sampleLabel + ":";
                        }
                        if (sampleLabel != null) {
                            label = label + sampleLabel;
                        }
                    }
                    if (valueLabelsOn && valueLabelStyle == 1) {
                        label = label == null ? valueLabel : label + valueLabel;
                    }
                    Dimension labelSize = this.getLabelSize(label, fm);
                    Dimension angledSize = this.getAngledLabelSize(labelSize, angle);
                    int label_xpos = Math.round(sample_xpos - angledSize.width / 2) + 1;
                    if (this.display3dOn) {
                        label_xpos -= this.depth3dPoint.x;
                    }
                    int label_ypos = sample_ypos;
                    if (this.display3dOn && prev_slope >= next_slope) {
                        label_ypos = (int)((double)label_ypos + (double)this.depth3dPoint.y / (double)seriesCount);
                    }
                    int under_ypos = label_ypos;
                    under_ypos = angle % 180 == 0 ? (under_ypos += vertical_offset) : (under_ypos += 6);
                    int over_ypos = label_ypos;
                    if (angle % 180 != 0) {
                        over_ypos -= angledSize.height;
                    }
                    boolean highlight = false;
                    int hsize = 0;
                    try {
                        highlight = this.chart.isSampleHighlightOn(series, sample);
                        hsize = this.chart.getSampleHighlightSize(series);
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.out.println("Internal error with value labels");
                        e.printStackTrace();
                    }
                    if (highlight || valueLabelStyle == 0 && valueLabelsOn) {
                        if (hsize >= valueAngledSize.height) {
                            under_ypos += hsize / 2;
                            over_ypos -= hsize / 2;
                        } else {
                            under_ypos += valueAngledSize.height / 2 - 3;
                            over_ypos -= valueAngledSize.height / 2 - 1;
                        }
                    }
                    if ((label_ypos = prev_slope < next_slope && this.chart.getRange(0) >= this.chart.getLowerRange(0) || prev_slope >= next_slope && this.chart.getLowerRange(0) >= this.chart.getRange(0) ? under_ypos : over_ypos) != under_ypos && this.display3dOn && !this.stackedOn) {
                        label_xpos = (int)((double)label_xpos + (double)this.depth3dPoint.x / (double)seriesCount);
                    }
                    if (this.display3dOn) {
                        label_xpos = Math.max(gridBounds.x - this.depth3dPoint.x + 2, label_xpos);
                        label_ypos = Math.min(label_ypos, gridBounds.y + gridBounds.height - this.depth3dPoint.y);
                    } else {
                        label_xpos = Math.max(gridBounds.x + 2, label_xpos);
                        label_ypos = Math.min(label_ypos, gridBounds.y + gridBounds.height);
                    }
                    label_xpos = Math.min(label_xpos, gridBounds.x + gridBounds.width - angledSize.width - 1);
                    label_ypos = Math.max(label_ypos, gridBounds.y + angledSize.height - 2);
                    if (this.isLabelInside(sample_xpos, sample_ypos, label_ypos + angledSize.height, gridBounds)) {
                        g.setColor(fontColor);
                        g.setFont(font);
                        this.paintLabel(g, label, label_xpos, label_ypos, labelSize, this.chart.getMultilineLabelAlignment(), angle, false);
                    }
                }
                sample_xpos = (int)((double)sample_xpos + delta_x);
            }
        }
    }

    void paintBelowSampleLabels(Graphics g, Rectangle gridBounds) {
        int startIndex;
        Font sampleLabelFont = this.getFont("sampleLabelFont");
        FontMetrics fm = this.getFontMetrics(sampleLabelFont);
        int sampleAngle = this.getLabelAngle("sampleLabelAngle");
        String[] sampleLabels = this.chart.getSampleLabels();
        if (sampleLabels == null || sampleLabels.length == 0) {
            return;
        }
        int[] visibleSamples = this.chart.getVisibleSamples();
        int stopIndex = Math.min(visibleSamples[0] + visibleSamples[1], this.getSampleCount());
        for (startIndex = Math.max(visibleSamples[0], 0); startIndex < this.getSampleCount() && startIndex < sampleLabels.length && sampleLabels[startIndex] == null; ++startIndex) {
        }
        while (stopIndex > startIndex && stopIndex < sampleLabels.length && sampleLabels[stopIndex - 1] == null) {
            --stopIndex;
        }
        if (this.chart.isRightToLeftScrollingOn()) {
            startIndex = 0;
            stopIndex = this.getSampleCount();
        }
        stopIndex = Math.min(stopIndex, this.sampleLabelPos.length);
        stopIndex = Math.max(stopIndex, 1);
        Dimension stopLabelAngledSize = this.getAngledLabelSize(this.getLabelSize(sampleLabels[stopIndex - 1], fm), sampleAngle);
        int stop_label_x = sampleAngle % 180 == 0 ? this.sampleLabelPos[stopIndex - 1] - stopLabelAngledSize.width / 2 : (sampleAngle % 360 > 90 && sampleAngle % 360 < 180 || sampleAngle % 360 > 270 ? this.sampleLabelPos[stopIndex - 1] - stopLabelAngledSize.width + fm.getAscent() / 2 : this.sampleLabelPos[stopIndex - 1] - fm.getAscent() / 2);
        if (this.display3dOn) {
            stop_label_x -= this.depth3dPoint.x;
        }
        double prev_x = 0.0;
        for (int sample = startIndex; sample < stopIndex && sample < sampleLabels.length; ++sample) {
            String sampleLabel = sampleLabels[sample];
            Dimension sampleLabelSize = this.getLabelSize(sampleLabel, fm);
            Dimension sampleAngledSize = this.getAngledLabelSize(sampleLabelSize, sampleAngle);
            if (!this.chart.isSampleLabelsOn() || this.chart.getSampleLabelStyle() != 2 && this.chart.getSampleLabelStyle() != 4) continue;
            int ypos = gridBounds.y + gridBounds.height;
            int left_edge = gridBounds.x;
            int right_edge = gridBounds.x + gridBounds.width;
            if (this.display3dOn) {
                ypos -= this.depth3dPoint.y;
                right_edge -= this.depth3dPoint.x;
                left_edge -= this.depth3dPoint.x;
            }
            if (this.chart.isSampleScrollerOn()) {
                ypos += 10;
            }
            int sample_xpos = 0;
            if (this.sampleLabelPos != null && sample < this.sampleLabelPos.length) {
                sample_xpos = this.sampleLabelPos[sample];
            }
            if (sampleLabel == null || sampleLabel.length() <= 0 || (sample_xpos -= this.display3dOn ? this.depth3dPoint.x : 0) < left_edge || sample_xpos > right_edge + 1) continue;
            int label_ypos = ypos + 8;
            if (sampleAngle % 180 == 0) {
                label_ypos += fm.getMaxAscent() - 4;
            }
            int label_xpos = sampleAngle % 180 == 0 ? sample_xpos - sampleAngledSize.width / 2 : (sampleAngle % 360 > 90 && sampleAngle % 360 < 180 || sampleAngle % 360 > 270 ? sample_xpos - sampleAngledSize.width + fm.getAscent() / 2 : sample_xpos - fm.getAscent() / 2);
            g.setFont(sampleLabelFont);
            Color chartForeground = this.chart.getForeground();
            Color fontColor = this.chart.getSampleLabelColor(sample);
            if (fontColor == null) {
                fontColor = chartForeground;
            }
            g.setColor(chartForeground);
            if (this.chart.isAutoLabelSpacingOn()) {
                if (sampleLabel == null || sampleLabel.trim().length() <= 0 || !((double)label_xpos > prev_x && label_xpos + sampleAngledSize.width <= stop_label_x + 3 || sample == startIndex) && sample != stopIndex - 1) continue;
                g.drawLine(Math.round(sample_xpos), ypos, Math.round(sample_xpos), ypos + 3);
                g.setColor(fontColor);
                this.paintLabel(g, sampleLabel, label_xpos, label_ypos, sampleLabelSize, 0, sampleAngle, false);
                prev_x = label_xpos + sampleAngledSize.width;
                continue;
            }
            if (sampleLabel == null || sampleLabel.trim().length() <= 0) continue;
            g.drawLine(Math.round(sample_xpos), ypos, Math.round(sample_xpos), ypos + 3);
            g.setColor(fontColor);
            this.paintLabel(g, sampleLabel, label_xpos, label_ypos, sampleLabelSize, 0, sampleAngle, false);
        }
    }

    protected void paintFloatingLabel(Graphics g, String label, Rectangle gridBounds, int sample, int series, Font font, FontMetrics fm) {
        if (label == null || this.samplePoints == null || this.samplePoints[series] == null || this.samplePoints[series][sample] == null) {
            return;
        }
        int xpos = this.samplePoints[series][sample][0];
        int ypos = this.samplePoints[series][sample][1];
        if (xpos < gridBounds.x || xpos > gridBounds.x + gridBounds.width + (this.display3dOn ? this.depth3dPoint.x : 0)) {
            return;
        }
        if (ypos < gridBounds.y || ypos > gridBounds.y + gridBounds.height - (this.display3dOn ? this.depth3dPoint.y : 0)) {
            return;
        }
        Dimension labelSize = this.getLabelSize(label, fm);
        int label_x = xpos - labelSize.width / 2 - (this.display3dOn ? this.depth3dPoint.x : 0);
        int label_y = ypos - labelSize.height + fm.getAscent() - 3;
        if (this.mouseOverSampleIndex > -1) {
            label_x = this.mousePosition.x - labelSize.width / 2;
            label_y = this.mousePosition.y - labelSize.height + fm.getAscent() - 3;
        }
        this.paintFloatingLabel(g, label, label_x, label_y, labelSize, LineChartRenderer.getDarker(this.chart.getSampleColor(series)), fm);
    }

    protected void paintSampleHighlight(Graphics g, int serie, int sample, int x, int y, Color color) {
        String imageName;
        Shape clip = g.getClip();
        if (sample != -1 && !this.display3dOn) {
            g.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        }
        if ((imageName = this.chart.getSampleHighlightImage(serie, sample)) == null) {
            imageName = this.chart.getSampleHighlightImage(serie, -1);
        }
        if (imageName == null) {
            imageName = this.chart.getSampleHighlightImage(-1, -1);
        }
        if (imageName == null) {
            imageName = this.chart.getLegendImage(serie);
        }
        Dimension imageSize = this.getImageSize(imageName);
        if (imageName != null && imageSize.width > 0 && imageSize.height > 0) {
            Image image = this.chart.getImage(imageName);
            if (image != null) {
                g.drawImage(image, x - imageSize.width / 2, y - imageSize.height / 2, this.chart);
            }
        } else {
            boolean selected = this.chart.isSelected(serie, -1) && sample != -1;
            int style = 0;
            if (serie >= 0) {
                style = this.chart.getSampleHighlightStyle(serie);
            }
            int size = 7;
            if (sample == -1) {
                switch (style) {
                    case 2: {
                        size = 7;
                        break;
                    }
                    case 0: 
                    case 1: {
                        size = 6;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        size = 5;
                    }
                }
            } else if (serie >= 0) {
                size = this.chart.getSampleHighlightSize(serie);
            }
            g.setColor(color);
            switch (style) {
                case 0: 
                case 1: 
                case 2: {
                    this.paintHighlightCircle(g, serie, x, y, size, style, color, selected);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.paintHighlightSquare(g, serie, x, y, size, style, color, selected);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.paintHighlightDiamond(g, serie, x, y, size, style, color, selected);
                }
            }
        }
        g.setClip(clip);
    }

    private void paintHighlightCircle(Graphics g, int serie, int x, int y, int size, int style, Color color, boolean selected) {
        Color chartBackground = this.chart.getChartBackground();
        if (this.display3dOn) {
            ++x;
            int depth_x = this.depth3dPoint.x;
            int depth_y = this.depth3dPoint.y;
            if (this.chart.getLine3DLayout() == 0) {
                depth_x = this.depth3dPoint.x / this.getSeriesCount();
                depth_y = this.depth3dPoint.y / this.getSeriesCount();
            }
            depth_x = (int)((double)depth_x * this.chart.getLine3DDepth(serie));
            depth_y = (int)((double)depth_y * this.chart.getLine3DDepth(serie));
            int x1 = x + depth_x;
            int y1 = y + depth_y;
            Polygon poly = new Polygon();
            int r = (int)((double)size * 0.35);
            poly.addPoint(x - r, y - r);
            poly.addPoint(x + r, y + r);
            poly.addPoint(x1 + r, y1 + r);
            poly.addPoint(x1 - r, y1 - r);
            Color inside = color;
            Color outside = LineChartRenderer.getDarker(color);
            if (selected) {
                inside = LineChartRenderer.getDarker(color);
                outside = LineChartRenderer.getDarker(LineChartRenderer.getDarker(color));
            }
            if (style != 2) {
                inside = chartBackground;
            }
            g.setColor(outside);
            g.fillOval(x1 - size / 2, y1 - size / 2, size, size);
            g.setColor(inside);
            g.fillOval(x1 - size / 2 + 1, y1 - size / 2 + 1, size - 2, size - 2);
            g.fillPolygon(poly);
            g.setColor(outside);
            g.fillOval(x - size / 2, y - size / 2, size, size);
            g.drawLine(x - r, y - r, x1 - r, y1 - r);
            g.drawLine(x + r, y + r, x1 + r, y1 + r);
            g.setColor(inside);
            g.fillOval(x - size / 2 + 1, y - size / 2 + 1, size - 2, size - 2);
        } else {
            if (style == 0) {
                g.drawOval(x - size / 2, y - size / 2, size, size);
            } else if (style == 2) {
                if (size == 2) {
                    size = 3;
                }
                g.fillOval(x - size / 2, y - size / 2, size, size);
                g.setColor(LineChartRenderer.getDarker(color));
                g.drawOval(x - size / 2, y - size / 2, size, size);
            } else if (style == 1) {
                g.setColor(chartBackground);
                g.fillOval(x - size / 2, y - size / 2, size + 1, size + 1);
                g.setColor(color);
                g.drawOval(x - size / 2, y - size / 2, size, size);
            }
            if (selected) {
                g.setColor(LineChartRenderer.getDarker(LineChartRenderer.getDarker(color)));
                if (style == 2) {
                    g.drawOval(x - size / 2, y - size / 2, size - 1, size - 1);
                } else {
                    g.drawOval(x - size / 2, y - size / 2, size, size);
                }
                if (size == 0 || size == 1) {
                    g.drawLine(x, y, x, y);
                }
            }
        }
    }

    private void paintHighlightSquare(Graphics g, int serie, int x, int y, int size, int style, Color color, boolean selected) {
        Color chartBackground = this.chart.getChartBackground();
        if (this.display3dOn) {
            int depth_x = this.depth3dPoint.x;
            int depth_y = this.depth3dPoint.y;
            if (this.chart.getLine3DLayout() == 0) {
                depth_x = this.depth3dPoint.x / this.getSeriesCount();
                depth_y = this.depth3dPoint.y / this.getSeriesCount();
            }
            depth_x = (int)((double)depth_x * this.chart.getLine3DDepth(serie));
            depth_y = (int)((double)depth_y * this.chart.getLine3DDepth(serie));
            int[] xpoints = new int[4];
            xpoints[0] = xpoints[3] = x - size / 2;
            xpoints[1] = xpoints[2] = x + size / 2;
            int[] ypoints = new int[4];
            ypoints[0] = ypoints[1] = y - size / 2;
            ypoints[2] = ypoints[3] = y + size / 2;
            int[] xpoints1 = new int[4];
            int[] ypoints1 = new int[4];
            for (int i = 0; i < xpoints1.length; ++i) {
                xpoints1[i] = xpoints[i] + depth_x;
                ypoints1[i] = ypoints[i] + depth_y;
            }
            Polygon top = new Polygon();
            top.addPoint(xpoints[0], ypoints[0]);
            top.addPoint(xpoints[1], ypoints[1]);
            top.addPoint(xpoints1[1], ypoints1[1]);
            top.addPoint(xpoints1[0], ypoints1[0]);
            Polygon right = new Polygon();
            right.addPoint(xpoints[1], ypoints[1]);
            right.addPoint(xpoints[2], ypoints[2]);
            right.addPoint(xpoints1[2], ypoints1[2]);
            right.addPoint(xpoints1[1], ypoints1[1]);
            Color inside = color;
            Color outside = LineChartRenderer.getDarker(color);
            if (selected) {
                inside = LineChartRenderer.getDarker(color);
                outside = LineChartRenderer.getDarker(LineChartRenderer.getDarker(color));
            }
            if (style != 5) {
                inside = chartBackground;
            }
            g.setColor(inside);
            g.fillPolygon(xpoints, ypoints, 4);
            g.fillPolygon(top);
            g.fillPolygon(right);
            g.setColor(outside);
            g.drawPolygon(xpoints, ypoints, 4);
            g.drawLine(xpoints[0], ypoints[0], xpoints1[0], ypoints1[0]);
            g.drawLine(xpoints[1], ypoints[1], xpoints1[1], ypoints1[1]);
            g.drawLine(xpoints[2], ypoints[2], xpoints1[2], ypoints1[2]);
            g.drawLine(xpoints1[0], ypoints1[0], xpoints1[1], ypoints1[1]);
            g.drawLine(xpoints1[1], ypoints1[1], xpoints1[2], ypoints1[2]);
        } else {
            if (style == 3) {
                g.drawRect(x - size / 2, y - size / 2, size, size);
            } else if (style == 5) {
                g.fillRect(x - size / 2, y - size / 2, size, size);
                g.setColor(LineChartRenderer.getDarker(color));
                g.drawRect(x - size / 2, y - size / 2, size, size);
            } else if (style == 4) {
                g.setColor(chartBackground);
                g.fillRect(x - size / 2, y - size / 2, size + 1, size + 1);
                g.setColor(color);
                g.drawRect(x - size / 2, y - size / 2, size, size);
            }
            if (selected) {
                g.setColor(LineChartRenderer.getDarker(LineChartRenderer.getDarker(color)));
                g.drawRect(x - size / 2 - 1, y - size / 2 - 1, size + 2, size + 2);
            }
        }
    }

    private void paintHighlightDiamond(Graphics g, int serie, int x, int y, int size, int style, Color color, boolean selected) {
        Color chartBackground = this.chart.getChartBackground();
        int[] xpoints = new int[4];
        xpoints[0] = xpoints[2] = x;
        xpoints[1] = x + size / 2;
        xpoints[3] = x - size / 2;
        int[] ypoints = new int[4];
        ypoints[0] = y - size / 2;
        ypoints[2] = y + size / 2;
        ypoints[1] = ypoints[3] = y;
        if (this.display3dOn) {
            int depth_x = this.depth3dPoint.x;
            int depth_y = this.depth3dPoint.y;
            if (this.chart.getLine3DLayout() == 0 && !this.stackedOn) {
                depth_x = this.depth3dPoint.x / this.getSeriesCount();
                depth_y = this.depth3dPoint.y / this.getSeriesCount();
            }
            depth_x = (int)((double)depth_x * this.chart.getLine3DDepth(serie));
            depth_y = (int)((double)depth_y * this.chart.getLine3DDepth(serie));
            int[] xpoints1 = new int[4];
            int[] ypoints1 = new int[4];
            for (int i = 0; i < xpoints1.length; ++i) {
                xpoints1[i] = xpoints[i] + depth_x;
                ypoints1[i] = ypoints[i] + depth_y;
            }
            Polygon top = new Polygon();
            top.addPoint(xpoints[0], ypoints[0]);
            top.addPoint(xpoints[1], ypoints[1]);
            top.addPoint(xpoints1[1], ypoints1[1]);
            top.addPoint(xpoints1[0], ypoints1[0]);
            Polygon right = new Polygon();
            right.addPoint(xpoints[1], ypoints[1]);
            right.addPoint(xpoints[2], ypoints[2]);
            right.addPoint(xpoints1[2], ypoints1[2]);
            right.addPoint(xpoints1[1], ypoints1[1]);
            Color inside = color;
            Color outside = LineChartRenderer.getDarker(color);
            if (selected) {
                inside = LineChartRenderer.getDarker(color);
                outside = LineChartRenderer.getDarker(LineChartRenderer.getDarker(color));
            }
            if (style != 8) {
                inside = chartBackground;
            }
            g.setColor(inside);
            g.fillPolygon(xpoints, ypoints, 4);
            g.fillPolygon(top);
            g.fillPolygon(right);
            g.setColor(outside);
            g.drawPolygon(xpoints, ypoints, 4);
            g.drawLine(xpoints[0], ypoints[0], xpoints1[0], ypoints1[0]);
            g.drawLine(xpoints[1], ypoints[1], xpoints1[1], ypoints1[1]);
            g.drawLine(xpoints[2], ypoints[2], xpoints1[2], ypoints1[2]);
            g.drawLine(xpoints1[0], ypoints1[0], xpoints1[1], ypoints1[1]);
            g.drawLine(xpoints1[1], ypoints1[1], xpoints1[2], ypoints1[2]);
        } else {
            if (style == 7) {
                g.setColor(chartBackground);
                g.fillPolygon(xpoints, ypoints, 4);
            } else if (style == 8) {
                g.setColor(color);
                g.fillPolygon(xpoints, ypoints, 4);
                g.setColor(LineChartRenderer.getDarker(color));
            }
            g.setColor(color);
            g.drawPolygon(xpoints, ypoints, 4);
            if (selected) {
                xpoints[1] = xpoints[1] + 1;
                xpoints[3] = xpoints[3] - 1;
                ypoints[0] = ypoints[0] - 1;
                ypoints[2] = ypoints[2] + 1;
                g.setColor(LineChartRenderer.getDarker(LineChartRenderer.getDarker(color)));
                g.drawPolygon(xpoints, ypoints, 4);
            }
        }
    }

    protected boolean isAnyFloatingLabelsOn(int serie) {
        int valueLabelStyle = this.chart.getValueLabelStyle();
        int sampleLabelStyle = this.chart.getSampleLabelStyle();
        int seriesLabelStyle = this.chart.getSeriesLabelStyle();
        boolean valueLabelsOn = this.chart.isValueLabelsOn(serie);
        boolean sampleLabelsOn = this.chart.isSampleLabelsOn();
        boolean seriesLabelsOn = this.chart.isSeriesLabelsOn();
        boolean labels_on = valueLabelsOn && valueLabelStyle == 3;
        labels_on |= sampleLabelsOn && (sampleLabelStyle == 3 || sampleLabelStyle == 4);
        return labels_on |= seriesLabelsOn && seriesLabelStyle == 3;
    }

    protected boolean isAnyBelowLabelsOn() {
        int sampleLabelStyle = this.chart.getSampleLabelStyle();
        boolean sampleLabelsOn = this.chart.isSampleLabelsOn();
        boolean labels_on = sampleLabelsOn && (sampleLabelStyle == 2 || sampleLabelStyle == 4);
        return labels_on;
    }
}

