/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk;

import com.vmware.vcloud.sdk.Response;
import com.vmware.vcloud.sdk.RestUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private static ResourceBundle resourceBundle;

    private SdkUtil() {
    }

    public static String getI18nString(SdkMessage sdkMessage) {
        try {
            return resourceBundle.getString(sdkMessage.name());
        }
        catch (MissingResourceException e) {
            logger.error(e.getMessage());
            return e.getMessage();
        }
    }

    public static <T> T get(VcloudClient client, String url, int statusCode) throws VCloudException {
        Response response = RestUtil.get(client, url);
        return SdkUtil.validateResponse(response, statusCode);
    }

    public static <T> T post(VcloudClient client, String url, String requestString, String mediaType, int statusCode) throws VCloudException {
        Response response = RestUtil.post(client, url, requestString, mediaType, "UTF-8");
        return SdkUtil.validateResponse(response, statusCode);
    }

    public static <T> T put(VcloudClient client, String url, String requestString, String mediaType, int statusCode) throws VCloudException {
        Response response = RestUtil.put(client, url, requestString, mediaType, "UTF-8");
        return SdkUtil.validateResponse(response, statusCode);
    }

    public static <T> T delete(VcloudClient client, String url, int statusCode) throws VCloudException {
        Response response = RestUtil.delete(client, url);
        return SdkUtil.validateResponse(response, statusCode);
    }

    private static <T> T validateResponse(Response response, int statusCode) throws VCloudException {
        boolean expectedStatus = response.isExpected(statusCode);
        if (statusCode == 204) {
            if (!expectedStatus) {
                response.handleUnExpectedResponse();
            } else {
                return null;
            }
        }
        if (!expectedStatus) {
            response.handleUnExpectedResponse();
        }
        return response.getResource();
    }

    static {
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle("com.vmware.vcloud.sdk.properties.vCloudJavaSDK", Locale.getDefault());
            }
            catch (MissingResourceException e) {
                logger.error(e.getMessage());
                logger.info("Loading locale en_US properties");
                resourceBundle = ResourceBundle.getBundle("com.vmware.vcloud.sdk.properties.vCloudJavaSDK", Locale.ENGLISH);
            }
        }
    }
}

