/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin;

import com.vmware.vcloud.api.rest.schema.GroupType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Group
extends VcloudEntity<GroupType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private HashMap<String, ReferenceType> userRefsByName;

    Group(VcloudClient client, GroupType groupType_v1_5) {
        super(client, groupType_v1_5);
        this.sortRefs_v1_5();
    }

    public static Group getGroupByReference(VcloudClient client, ReferenceType groupRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + groupRef.getHref());
        return new Group(client, (GroupType)Group.getResourceByReference(client, groupRef));
    }

    public static Group getGroupById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new Group(client, (GroupType)Group.getEntityById(client, vCloudId, "application/vnd.vmware.admin.group+xml"));
    }

    public Group updateGroup(GroupType groupType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        String groupUpdateUrl = this.getReference().getHref();
        String groupUpdateRequestXmlString = JAXBUtil.marshal(of.createGroup(groupType));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + groupUpdateUrl);
        return new Group(this.getVcloudClient(), (GroupType)SdkUtil.put(this.getVcloudClient(), groupUpdateUrl, groupUpdateRequestXmlString, "application/vnd.vmware.admin.group+xml", 200));
    }

    public void delete() throws VCloudException {
        String groupUrl = this.getReference().getHref();
        Group.deleteGroup(this.getVcloudClient(), groupUrl);
    }

    public static void delete(VcloudClient client, ReferenceType groupRef) throws VCloudException {
        Group.deleteGroup(client, groupRef.getHref());
    }

    private static void deleteGroup(VcloudClient client, String groupUrl) throws VCloudException {
        SdkUtil.delete(client, groupUrl, 204);
    }

    private void sortRefs_v1_5() {
        this.userRefsByName = new HashMap();
        if (((GroupType)this.getResource()).getUsersList() != null) {
            for (ReferenceType userRef : ((GroupType)this.getResource()).getUsersList().getUserReference()) {
                this.userRefsByName.put(userRef.getName(), userRef);
            }
        }
    }

    public ReferenceType getRoleReference() throws VCloudException {
        if (((GroupType)this.getResource()).getRole() != null) {
            return ((GroupType)this.getResource()).getRole();
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public HashMap<String, ReferenceType> getUserRefsByName() {
        return this.userRefsByName;
    }

    public Collection<ReferenceType> getUserRefs() {
        return this.userRefsByName.values();
    }

    public ReferenceType getUserRefByName(String userName) {
        return this.userRefsByName.get(userName);
    }
}

