/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin;

import com.vmware.vcloud.api.rest.schema.AdminOrgType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.OrganizationReferenceType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.RoleType;
import com.vmware.vcloud.api.rest.schema.SelectorExtensionType;
import com.vmware.vcloud.api.rest.schema.SelectorExtensionsType;
import com.vmware.vcloud.api.rest.schema.VCloudType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.admin.AdminOrganization;
import com.vmware.vcloud.sdk.admin.AdminQueryService;
import com.vmware.vcloud.sdk.admin.Role;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcloudAdmin {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private VCloudType vcloudResource_v1_5;
    private VcloudClient client;
    private ReferenceType systemAdminOrgReference;
    private HashMap<String, ReferenceType> adminOrganizationRefsByName;
    private HashMap<String, ReferenceType> providerVdcRefsByName;
    private HashMap<String, ReferenceType> rightRefsByName;
    private HashMap<String, ReferenceType> roleRefsByName;
    private HashMap<String, ReferenceType> externalNetworkRefsByName;

    public VcloudAdmin(VcloudClient client) throws VCloudException {
        this.client = client;
        this.vcloudResource_v1_5 = (VCloudType)SdkUtil.get(client, client.getVcloudApiURL() + "/admin/", 200);
        this.sortAdminRefs_v1_5();
    }

    public AdminQueryService getAdminQueryService() {
        return new AdminQueryService(this.client);
    }

    public VCloudType getResource() {
        return this.vcloudResource_v1_5;
    }

    private void sortAdminRefs_v1_5() {
        this.adminOrganizationRefsByName = new HashMap();
        this.providerVdcRefsByName = new HashMap();
        this.rightRefsByName = new HashMap();
        this.roleRefsByName = new HashMap();
        this.externalNetworkRefsByName = new HashMap();
        if (this.getResource().getOrganizationReferences() != null) {
            for (OrganizationReferenceType orgRef : this.getResource().getOrganizationReferences().getOrganizationReference()) {
                this.adminOrganizationRefsByName.put(orgRef.getName(), (ReferenceType)orgRef);
            }
        }
        if (this.getResource().getProviderVdcReferences() != null) {
            for (ReferenceType providerVdcRef : this.getResource().getProviderVdcReferences().getProviderVdcReference()) {
                this.providerVdcRefsByName.put(providerVdcRef.getName(), providerVdcRef);
            }
        }
        if (this.getResource().getRightReferences() != null) {
            for (ReferenceType rightRef : this.getResource().getRightReferences().getRightReference()) {
                this.rightRefsByName.put(rightRef.getName(), rightRef);
            }
        }
        if (this.getResource().getRoleReferences() != null) {
            for (ReferenceType roleRef : this.getResource().getRoleReferences().getRoleReference()) {
                this.roleRefsByName.put(roleRef.getName(), roleRef);
            }
        }
        if (this.getResource().getNetworks() != null) {
            for (ReferenceType networkRef : this.getResource().getNetworks().getNetwork()) {
                this.externalNetworkRefsByName.put(networkRef.getName(), networkRef);
            }
        }
        for (LinkType link : this.getResource().getLink()) {
            if (!link.getRel().equals("down") || !link.getType().equals("application/vnd.vmware.admin.systemOrganization+xml")) continue;
            this.systemAdminOrgReference = new ReferenceType();
            this.systemAdminOrgReference = link;
            break;
        }
    }

    public AdminOrganization getSystemAdminOrg() throws VCloudException {
        if (this.systemAdminOrgReference == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
        }
        return AdminOrganization.getAdminOrgByReference(this.client, this.systemAdminOrgReference);
    }

    public Role createRole(RoleType roleType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement roleParams = of.createRole(roleType);
        String requestBodyXml = JAXBUtil.marshal(roleParams);
        String postURL = this.getResource().getHref() + "roles";
        return new Role(this.client, (RoleType)SdkUtil.post(this.client, postURL, requestBodyXml, "application/vnd.vmware.admin.role+xml", 201));
    }

    public AdminOrganization createAdminOrg(AdminOrgType adminOrgType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        JAXBElement adminOrgParams = of.createAdminOrg(adminOrgType);
        String requestBodyXml = JAXBUtil.marshal(adminOrgParams);
        String postURL = this.getResource().getHref() + "orgs";
        return new AdminOrganization(this.client, (AdminOrgType)SdkUtil.post(this.client, postURL, requestBodyXml, "application/vnd.vmware.admin.organization+xml", 201));
    }

    public HashMap<String, ReferenceType> getAdminOrgRefsByName() {
        return this.adminOrganizationRefsByName;
    }

    public Collection<ReferenceType> getAdminOrgRefs() {
        return this.adminOrganizationRefsByName.values();
    }

    public ReferenceType getAdminOrgRefByName(String name) {
        return this.adminOrganizationRefsByName.get(name);
    }

    public HashMap<String, ReferenceType> getProviderVdcRefsByName() {
        return this.providerVdcRefsByName;
    }

    public Collection<ReferenceType> getProviderVdcRefs() {
        return this.providerVdcRefsByName.values();
    }

    public ReferenceType getProviderVdcRefByName(String name) {
        return this.providerVdcRefsByName.get(name);
    }

    public HashMap<String, ReferenceType> getRightRefsByName() {
        return this.rightRefsByName;
    }

    public Collection<ReferenceType> getRightRefs() {
        return this.rightRefsByName.values();
    }

    public ReferenceType getRightRefByName(String name) {
        return this.rightRefsByName.get(name);
    }

    public HashMap<String, ReferenceType> getRoleRefsByName() {
        return this.roleRefsByName;
    }

    public Collection<ReferenceType> getRoleRefs() {
        return this.roleRefsByName.values();
    }

    public ReferenceType getRoleRefByName(String name) {
        return this.roleRefsByName.get(name);
    }

    public HashMap<String, ReferenceType> getExternalNetworkRefsByName() {
        return this.externalNetworkRefsByName;
    }

    public Collection<ReferenceType> getExternalNetworkRefs() {
        return this.externalNetworkRefsByName.values();
    }

    public ReferenceType getExternalNetworkRefByName(String name) {
        return this.externalNetworkRefsByName.get(name);
    }

    public SelectorExtensionType createOrgsSelectorExtension(SelectorExtensionType selectorExtensionType) throws VCloudException {
        String url = this.getResource().getHref() + "orgs" + "/extension";
        ObjectFactory extensionFactory = new ObjectFactory();
        String createSelectorExtension = JAXBUtil.marshal(extensionFactory.createSelectorExtension(selectorExtensionType));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return (SelectorExtensionType)SdkUtil.post(this.client, url, createSelectorExtension, "application/vnd.vmware.admin.extensibility.selector+xml", 201);
    }

    public List<SelectorExtensionType> getOrgsSelectorExtension() throws VCloudException {
        String url = this.getResource().getHref() + "orgs" + "/extension";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        SelectorExtensionsType objectExtension = (SelectorExtensionsType)SdkUtil.get(this.client, url, 200);
        return objectExtension.getSelectorExtension();
    }

    public SelectorExtensionType getOrgsSelectorExtensionById(String selectorExtensionId) throws VCloudException {
        String url = this.getResource().getHref() + "orgs" + "/extension" + "/" + selectorExtensionId;
        return (SelectorExtensionType)SdkUtil.get(this.client, url, 200);
    }

    public SelectorExtensionType updateOrgsSelectorExtensionById(String selectorExtensionId, SelectorExtensionType selectorExtensionType) throws VCloudException {
        String url = this.getResource().getHref() + "orgs" + "/extension" + "/" + selectorExtensionId;
        ObjectFactory extensionFactory = new ObjectFactory();
        String createSelectorExtension = JAXBUtil.marshal(extensionFactory.createSelectorExtension(selectorExtensionType));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + url);
        return (SelectorExtensionType)SdkUtil.put(this.client, url, createSelectorExtension, "application/vnd.vmware.admin.extensibility.selector+xml", 200);
    }

    public void deleteOrgsSelectorExtensionById(String selectorExtensionId) throws VCloudException {
        String url = this.getResource().getHref() + "orgs" + "/extension" + "/" + selectorExtensionId;
        SdkUtil.delete(this.client, url, 204);
    }

    public SelectorExtensionType createCatalogsSelectorExtension(SelectorExtensionType selectorExtensionType) throws VCloudException {
        String url = this.getResource().getHref() + "catalogs" + "/extension";
        ObjectFactory extensionFactory = new ObjectFactory();
        String createSelectorExtension = JAXBUtil.marshal(extensionFactory.createSelectorExtension(selectorExtensionType));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return (SelectorExtensionType)SdkUtil.post(this.client, url, createSelectorExtension, "application/vnd.vmware.admin.extensibility.selector+xml", 201);
    }

    public List<SelectorExtensionType> getCatalogsSelectorExtension() throws VCloudException {
        String url = this.getResource().getHref() + "catalogs" + "/extension";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        SelectorExtensionsType objectExtension = (SelectorExtensionsType)SdkUtil.get(this.client, url, 200);
        return objectExtension.getSelectorExtension();
    }

    public SelectorExtensionType getCatalogsSelectorExtensionById(String selectorExtensionId) throws VCloudException {
        String url = this.getResource().getHref() + "catalogs" + "/extension" + "/" + selectorExtensionId;
        return (SelectorExtensionType)SdkUtil.get(this.client, url, 200);
    }

    public SelectorExtensionType updateCatalogsSelectorExtensionById(String selectorExtensionId, SelectorExtensionType selectorExtensionType) throws VCloudException {
        String url = this.getResource().getHref() + "catalogs" + "/extension" + "/" + selectorExtensionId;
        ObjectFactory extensionFactory = new ObjectFactory();
        String createSelectorExtension = JAXBUtil.marshal(extensionFactory.createSelectorExtension(selectorExtensionType));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + url);
        return (SelectorExtensionType)SdkUtil.put(this.client, url, createSelectorExtension, "application/vnd.vmware.admin.extensibility.selector+xml", 200);
    }

    public void deleteCatalogsSelectorExtensionById(String selectorExtensionId) throws VCloudException {
        String url = this.getResource().getHref() + "catalogs" + "/extension" + "/" + selectorExtensionId;
        SdkUtil.delete(this.client, url, 204);
    }

    public SelectorExtensionType createProviderVdcsSelectorExtension(SelectorExtensionType selectorExtensionType) throws VCloudException {
        String url = this.getResource().getHref() + "providervdcs/" + "/extension";
        ObjectFactory extensionFactory = new ObjectFactory();
        String createSelectorExtension = JAXBUtil.marshal(extensionFactory.createSelectorExtension(selectorExtensionType));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return (SelectorExtensionType)SdkUtil.post(this.client, url, createSelectorExtension, "application/vnd.vmware.admin.extensibility.selector+xml", 201);
    }

    public List<SelectorExtensionType> getProviderVdcsSelectorExtension() throws VCloudException {
        String url = this.getResource().getHref() + "providervdcs/" + "/extension";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        SelectorExtensionsType objectExtension = (SelectorExtensionsType)SdkUtil.get(this.client, url, 200);
        return objectExtension.getSelectorExtension();
    }

    public SelectorExtensionType getProviderVdcsSelectorExtensionById(String selectorExtensionId) throws VCloudException {
        String url = this.getResource().getHref() + "providervdcs/" + "/extension" + "/" + selectorExtensionId;
        return (SelectorExtensionType)SdkUtil.get(this.client, url, 200);
    }

    public SelectorExtensionType updateProviderVdcsSelectorExtensionById(String selectorExtensionId, SelectorExtensionType selectorExtensionType) throws VCloudException {
        String url = this.getResource().getHref() + "providervdcs/" + "/extension" + "/" + selectorExtensionId;
        ObjectFactory extensionFactory = new ObjectFactory();
        String createSelectorExtension = JAXBUtil.marshal(extensionFactory.createSelectorExtension(selectorExtensionType));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + url);
        return (SelectorExtensionType)SdkUtil.put(this.client, url, createSelectorExtension, "application/vnd.vmware.admin.extensibility.selector+xml", 200);
    }

    public void deleteProviderVdcsSelectorExtensionById(String selectorExtensionId) throws VCloudException {
        String url = this.getResource().getHref() + "providervdcs/" + "/extension" + "/" + selectorExtensionId;
        SdkUtil.delete(this.client, url, 204);
    }

    public SelectorExtensionType createVdcsSelectorExtension(SelectorExtensionType selectorExtensionType) throws VCloudException {
        String url = this.getResource().getHref() + "vdcs" + "/extension";
        ObjectFactory extensionFactory = new ObjectFactory();
        String createSelectorExtension = JAXBUtil.marshal(extensionFactory.createSelectorExtension(selectorExtensionType));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return (SelectorExtensionType)SdkUtil.post(this.client, url, createSelectorExtension, "application/vnd.vmware.admin.extensibility.selector+xml", 201);
    }

    public List<SelectorExtensionType> getVdcsSelectorExtension() throws VCloudException {
        String url = this.getResource().getHref() + "vdcs" + "/extension";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        SelectorExtensionsType objectExtension = (SelectorExtensionsType)SdkUtil.get(this.client, url, 200);
        return objectExtension.getSelectorExtension();
    }

    public SelectorExtensionType getVdcsSelectorExtensionById(String selectorExtensionId) throws VCloudException {
        String url = this.getResource().getHref() + "vdcs" + "/extension" + "/" + selectorExtensionId;
        return (SelectorExtensionType)SdkUtil.get(this.client, url, 200);
    }

    public SelectorExtensionType updateVdcsSelectorExtensionById(String selectorExtensionId, SelectorExtensionType selectorExtensionType) throws VCloudException {
        String url = this.getResource().getHref() + "vdcs" + "/extension" + "/" + selectorExtensionId;
        ObjectFactory extensionFactory = new ObjectFactory();
        String createSelectorExtension = JAXBUtil.marshal(extensionFactory.createSelectorExtension(selectorExtensionType));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + url);
        return (SelectorExtensionType)SdkUtil.put(this.client, url, createSelectorExtension, "application/vnd.vmware.admin.extensibility.selector+xml", 200);
    }

    public void deleteVdcsSelectorExtensionById(String selectorExtensionId) throws VCloudException {
        String url = this.getResource().getHref() + "vdcs" + "/extension" + "/" + selectorExtensionId;
        SdkUtil.delete(this.client, url, 204);
    }
}

