/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Blob;
import com.xensource.xenapi.Connection;
import com.xensource.xenapi.DataSource;
import com.xensource.xenapi.Feature;
import com.xensource.xenapi.HostCpu;
import com.xensource.xenapi.HostCrashdump;
import com.xensource.xenapi.HostMetrics;
import com.xensource.xenapi.HostPatch;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.Network;
import com.xensource.xenapi.PBD;
import com.xensource.xenapi.PCI;
import com.xensource.xenapi.PGPU;
import com.xensource.xenapi.PIF;
import com.xensource.xenapi.PUSB;
import com.xensource.xenapi.PoolUpdate;
import com.xensource.xenapi.SR;
import com.xensource.xenapi.Task;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.VM;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

public class Host
extends XenAPIObject {
    protected final String ref;

    Host(String string) {
        this.ref = string;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Host) {
            Host host = (Host)object;
            return host.ref.equals(this.ref);
        }
        return false;
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public Record getRecord(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_record";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toHostRecord(v);
    }

    public static Host getByUuid(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.get_by_uuid";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toHost(v);
    }

    public static Set<Host> getByNameLabel(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.get_by_name_label";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfHost(v);
    }

    public String getUuid(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_uuid";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getNameLabel(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_name_label";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getNameDescription(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_name_description";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Long getMemoryOverhead(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_memory_overhead";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Set<Types.HostAllowedOperations> getAllowedOperations(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_allowed_operations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfHostAllowedOperations(v);
    }

    public Map<String, Types.HostAllowedOperations> getCurrentOperations(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_current_operations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringHostAllowedOperations(v);
    }

    public Long getAPIVersionMajor(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_API_version_major";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Long getAPIVersionMinor(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_API_version_minor";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public String getAPIVersionVendor(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_API_version_vendor";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Map<String, String> getAPIVersionVendorImplementation(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_API_version_vendor_implementation";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Boolean getEnabled(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_enabled";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public Map<String, String> getSoftwareVersion(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_software_version";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Map<String, String> getOtherConfig(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Set<String> getCapabilities(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_capabilities";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfString(v);
    }

    public Map<String, String> getCpuConfiguration(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_cpu_configuration";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public String getSchedPolicy(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_sched_policy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Set<String> getSupportedBootloaders(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_supported_bootloaders";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfString(v);
    }

    public Set<VM> getResidentVMs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_resident_VMs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVM(v);
    }

    public Map<String, String> getLogging(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_logging";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Set<PIF> getPIFs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_PIFs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfPIF(v);
    }

    public SR getSuspendImageSr(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_suspend_image_sr";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSR(v);
    }

    public SR getCrashDumpSr(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_crash_dump_sr";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSR(v);
    }

    public Set<HostCrashdump> getCrashdumps(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_crashdumps";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfHostCrashdump(v);
    }

    @Deprecated
    public Set<HostPatch> getPatches(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_patches";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfHostPatch(v);
    }

    public Set<PoolUpdate> getUpdates(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_updates";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfPoolUpdate(v);
    }

    public Set<PBD> getPBDs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_PBDs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfPBD(v);
    }

    public Set<HostCpu> getHostCPUs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_host_CPUs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfHostCpu(v);
    }

    public Map<String, String> getCpuInfo(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_cpu_info";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public String getHostname(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_hostname";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getAddress(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_address";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public HostMetrics getMetrics(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_metrics";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toHostMetrics(v);
    }

    public Map<String, String> getLicenseParams(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_license_params";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Set<String> getHaStatefiles(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_ha_statefiles";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfString(v);
    }

    public Set<String> getHaNetworkPeers(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_ha_network_peers";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfString(v);
    }

    public Map<String, Blob> getBlobs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_blobs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringBlob(v);
    }

    public Set<String> getTags(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_tags";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfString(v);
    }

    public String getExternalAuthType(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_external_auth_type";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getExternalAuthServiceName(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_external_auth_service_name";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Map<String, String> getExternalAuthConfiguration(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_external_auth_configuration";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public String getEdition(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_edition";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Map<String, String> getLicenseServer(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_license_server";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Map<String, String> getBiosStrings(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_bios_strings";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public String getPowerOnMode(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_power_on_mode";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Map<String, String> getPowerOnConfig(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_power_on_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public SR getLocalCacheSr(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_local_cache_sr";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSR(v);
    }

    public Map<String, String> getChipsetInfo(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_chipset_info";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Set<PCI> getPCIs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_PCIs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfPCI(v);
    }

    public Set<PGPU> getPGPUs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_PGPUs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfPGPU(v);
    }

    public Set<PUSB> getPUSBs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_PUSBs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfPUSB(v);
    }

    public Boolean getSslLegacy(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_ssl_legacy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public Map<String, String> getGuestVCPUsParams(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_guest_VCPUs_params";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Types.HostDisplay getDisplay(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_display";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toHostDisplay(v);
    }

    public Set<Long> getVirtualHardwarePlatformVersions(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_virtual_hardware_platform_versions";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfLong(v);
    }

    public VM getControlDomain(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_control_domain";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVM(v);
    }

    public Set<PoolUpdate> getUpdatesRequiringReboot(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_updates_requiring_reboot";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfPoolUpdate(v);
    }

    public Set<Feature> getFeatures(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_features";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfFeature(v);
    }

    public void setNameLabel(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.set_name_label";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setNameDescription(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.set_name_description";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setOtherConfig(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.set_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToOtherConfig(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "host.add_to_other_config";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromOtherConfig(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.remove_from_other_config";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setLogging(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.set_logging";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToLogging(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "host.add_to_logging";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromLogging(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.remove_from_logging";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setSuspendImageSr(Connection connection, SR sR) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.set_suspend_image_sr";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(sR)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setCrashDumpSr(Connection connection, SR sR) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.set_crash_dump_sr";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(sR)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setHostname(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.set_hostname";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setAddress(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.set_address";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setTags(Connection connection, Set<String> set) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.set_tags";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(set)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void addTags(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.add_tags";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void removeTags(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.remove_tags";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setLicenseServer(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.set_license_server";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToLicenseServer(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "host.add_to_license_server";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromLicenseServer(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.remove_from_license_server";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setGuestVCPUsParams(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.set_guest_VCPUs_params";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToGuestVCPUsParams(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "host.add_to_guest_VCPUs_params";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromGuestVCPUsParams(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.remove_from_guest_VCPUs_params";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void setDisplay(Connection connection, Types.HostDisplay hostDisplay) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.set_display";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC((Object)hostDisplay)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task disableAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.disable";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void disable(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.disable";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task enableAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.enable";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void enable(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.enable";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task shutdownAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.shutdown";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void shutdown(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.shutdown";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task rebootAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.reboot";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void reboot(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.reboot";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task dmesgAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.dmesg";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public String dmesg(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.dmesg";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Task dmesgClearAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.dmesg_clear";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public String dmesgClear(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.dmesg_clear";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Task getLogAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.get_log";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public String getLog(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_log";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Task sendDebugKeysAsync(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "Async.host.send_debug_keys";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void sendDebugKeys(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.send_debug_keys";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public Task bugreportUploadAsync(Connection connection, String string, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "Async.host.bugreport_upload";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string2, objectArray);
        Object v = map2.get("Value");
        return Types.toTask(v);
    }

    public void bugreportUpload(Connection connection, String string, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.bugreport_upload";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string2, objectArray);
    }

    public static Set<String> listMethods(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.list_methods";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfString(v);
    }

    public Task licenseApplyAsync(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.LicenseProcessingError {
        String string2 = "Async.host.license_apply";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void licenseApply(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.LicenseProcessingError {
        String string2 = "host.license_apply";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public Task licenseAddAsync(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.LicenseProcessingError {
        String string2 = "Async.host.license_add";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void licenseAdd(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.LicenseProcessingError {
        String string2 = "host.license_add";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public Task licenseRemoveAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.license_remove";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void licenseRemove(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.license_remove";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task destroyAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.destroy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void destroy(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.destroy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task powerOnAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.power_on";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void powerOn(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.power_on";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static void emergencyHaDisable(Connection connection, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.emergency_ha_disable";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Set<DataSource.Record> getDataSources(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_data_sources";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfDataSourceRecord(v);
    }

    public void recordDataSource(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.record_data_source";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public Double queryDataSource(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.query_data_source";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toDouble(v);
    }

    public void forgetDataSourceArchives(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.forget_data_source_archives";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public Task assertCanEvacuateAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.assert_can_evacuate";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void assertCanEvacuate(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.assert_can_evacuate";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task getVmsWhichPreventEvacuationAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.get_vms_which_prevent_evacuation";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Map<VM, Set<String>> getVmsWhichPreventEvacuation(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_vms_which_prevent_evacuation";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfVMSetOfString(v);
    }

    @Deprecated
    public Task getUncooperativeResidentVMsAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.get_uncooperative_resident_VMs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    @Deprecated
    public Set<VM> getUncooperativeResidentVMs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_uncooperative_resident_VMs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVM(v);
    }

    public Task evacuateAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.evacuate";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void evacuate(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.evacuate";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task syslogReconfigureAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.syslog_reconfigure";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void syslogReconfigure(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.syslog_reconfigure";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Task managementReconfigureAsync(Connection connection, PIF pIF) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.management_reconfigure";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(pIF)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static void managementReconfigure(Connection connection, PIF pIF) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.management_reconfigure";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(pIF)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static void localManagementReconfigure(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.local_management_reconfigure";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public static void managementDisable(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.management_disable";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task getManagementIfaceAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.get_management_interface";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public PIF getManagementIface(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_management_interface";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toPIF(v);
    }

    public String getSystemStatusCapabilities(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_system_status_capabilities";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Task restartAgentAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.restart_agent";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void restartAgent(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.restart_agent";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static void shutdownAgent(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.shutdown_agent";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void setHostnameLive(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.HostNameInvalid {
        String string2 = "host.set_hostname_live";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public Task computeFreeMemoryAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.compute_free_memory";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Long computeFreeMemory(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.compute_free_memory";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Task computeMemoryOverheadAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.compute_memory_overhead";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Long computeMemoryOverhead(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.compute_memory_overhead";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public void syncData(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.sync_data";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void backupRrds(Connection connection, Double d) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.backup_rrds";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(d)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task createNewBlobAsync(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "Async.host.create_new_blob";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Blob createNewBlob(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "host.create_new_blob";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toBlob(v);
    }

    public Task createNewBlobAsync(Connection connection, String string, String string2, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "Async.host.create_new_blob";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Blob createNewBlob(Connection connection, String string, String string2, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "host.create_new_blob";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toBlob(v);
    }

    public Task callPluginAsync(Connection connection, String string, String string2, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "Async.host.call_plugin";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string3, objectArray);
        Object v = map2.get("Value");
        return Types.toTask(v);
    }

    public String callPlugin(Connection connection, String string, String string2, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "host.call_plugin";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string3, objectArray);
        Object v = map2.get("Value");
        return Types.toString(v);
    }

    public Task hasExtensionAsync(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "Async.host.has_extension";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Boolean hasExtension(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.has_extension";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public String callExtension(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.call_extension";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Date getServertime(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_servertime";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toDate(v);
    }

    public Date getServerLocaltime(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_server_localtime";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toDate(v);
    }

    public void enableExternalAuth(Connection connection, Map<String, String> map, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "host.enable_external_auth";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map2 = connection.dispatch(string3, objectArray);
    }

    public void disableExternalAuth(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.disable_external_auth";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public Task retrieveWlbEvacuateRecommendationsAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.retrieve_wlb_evacuate_recommendations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Map<VM, Set<String>> retrieveWlbEvacuateRecommendations(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.retrieve_wlb_evacuate_recommendations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfVMSetOfString(v);
    }

    public Task getServerCertificateAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.get_server_certificate";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public String getServerCertificate(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_server_certificate";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public void applyEdition(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.apply_edition";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void applyEdition(Connection connection, String string, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.apply_edition";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string2, objectArray);
    }

    @Deprecated
    public Task refreshPackInfoAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.refresh_pack_info";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    @Deprecated
    public void refreshPackInfo(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.refresh_pack_info";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task setPowerOnModeAsync(Connection connection, String string, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "Async.host.set_power_on_mode";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string2, objectArray);
        Object v = map2.get("Value");
        return Types.toTask(v);
    }

    public void setPowerOnMode(Connection connection, String string, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.set_power_on_mode";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string2, objectArray);
    }

    public void setCpuFeatures(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "host.set_cpu_features";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public void resetCpuFeatures(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.reset_cpu_features";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void enableLocalStorageCaching(Connection connection, SR sR) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.enable_local_storage_caching";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(sR)};
        Map map = connection.dispatch(string, objectArray);
    }

    public void disableLocalStorageCaching(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.disable_local_storage_caching";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task migrateReceiveAsync(Connection connection, Network network, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.migrate_receive";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(network), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
        Object v = map2.get("Value");
        return Types.toTask(v);
    }

    public Map<String, String> migrateReceive(Connection connection, Network network, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.migrate_receive";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(network), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
        Object v = map2.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Task declareDeadAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.declare_dead";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void declareDead(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.declare_dead";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task enableDisplayAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.enable_display";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Types.HostDisplay enableDisplay(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.enable_display";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toHostDisplay(v);
    }

    public Task disableDisplayAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.disable_display";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Types.HostDisplay disableDisplay(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.disable_display";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toHostDisplay(v);
    }

    public Task setSslLegacyAsync(Connection connection, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.host.set_ssl_legacy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void setSslLegacy(Connection connection, Boolean bl) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.set_ssl_legacy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(bl)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Set<Host> getAll(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_all";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfHost(v);
    }

    public static Map<Host, Record> getAllRecords(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "host.get_all_records";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfHostHostRecord(v);
    }

    public static class Record
    implements Types.Record {
        public String uuid;
        public String nameLabel;
        public String nameDescription;
        public Long memoryOverhead;
        public Set<Types.HostAllowedOperations> allowedOperations;
        public Map<String, Types.HostAllowedOperations> currentOperations;
        public Long APIVersionMajor;
        public Long APIVersionMinor;
        public String APIVersionVendor;
        public Map<String, String> APIVersionVendorImplementation;
        public Boolean enabled;
        public Map<String, String> softwareVersion;
        public Map<String, String> otherConfig;
        public Set<String> capabilities;
        public Map<String, String> cpuConfiguration;
        public String schedPolicy;
        public Set<String> supportedBootloaders;
        public Set<VM> residentVMs;
        public Map<String, String> logging;
        public Set<PIF> PIFs;
        public SR suspendImageSr;
        public SR crashDumpSr;
        public Set<HostCrashdump> crashdumps;
        public Set<HostPatch> patches;
        public Set<PoolUpdate> updates;
        public Set<PBD> PBDs;
        public Set<HostCpu> hostCPUs;
        public Map<String, String> cpuInfo;
        public String hostname;
        public String address;
        public HostMetrics metrics;
        public Map<String, String> licenseParams;
        public Set<String> haStatefiles;
        public Set<String> haNetworkPeers;
        public Map<String, Blob> blobs;
        public Set<String> tags;
        public String externalAuthType;
        public String externalAuthServiceName;
        public Map<String, String> externalAuthConfiguration;
        public String edition;
        public Map<String, String> licenseServer;
        public Map<String, String> biosStrings;
        public String powerOnMode;
        public Map<String, String> powerOnConfig;
        public SR localCacheSr;
        public Map<String, String> chipsetInfo;
        public Set<PCI> PCIs;
        public Set<PGPU> PGPUs;
        public Set<PUSB> PUSBs;
        public Boolean sslLegacy;
        public Map<String, String> guestVCPUsParams;
        public Types.HostDisplay display;
        public Set<Long> virtualHardwarePlatformVersions;
        public VM controlDomain;
        public Set<PoolUpdate> updatesRequiringReboot;
        public Set<Feature> features;

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            printWriter.printf("%1$20s: %2$s\n", "nameLabel", this.nameLabel);
            printWriter.printf("%1$20s: %2$s\n", "nameDescription", this.nameDescription);
            printWriter.printf("%1$20s: %2$s\n", "memoryOverhead", this.memoryOverhead);
            printWriter.printf("%1$20s: %2$s\n", "allowedOperations", this.allowedOperations);
            printWriter.printf("%1$20s: %2$s\n", "currentOperations", this.currentOperations);
            printWriter.printf("%1$20s: %2$s\n", "APIVersionMajor", this.APIVersionMajor);
            printWriter.printf("%1$20s: %2$s\n", "APIVersionMinor", this.APIVersionMinor);
            printWriter.printf("%1$20s: %2$s\n", "APIVersionVendor", this.APIVersionVendor);
            printWriter.printf("%1$20s: %2$s\n", "APIVersionVendorImplementation", this.APIVersionVendorImplementation);
            printWriter.printf("%1$20s: %2$s\n", "enabled", this.enabled);
            printWriter.printf("%1$20s: %2$s\n", "softwareVersion", this.softwareVersion);
            printWriter.printf("%1$20s: %2$s\n", "otherConfig", this.otherConfig);
            printWriter.printf("%1$20s: %2$s\n", "capabilities", this.capabilities);
            printWriter.printf("%1$20s: %2$s\n", "cpuConfiguration", this.cpuConfiguration);
            printWriter.printf("%1$20s: %2$s\n", "schedPolicy", this.schedPolicy);
            printWriter.printf("%1$20s: %2$s\n", "supportedBootloaders", this.supportedBootloaders);
            printWriter.printf("%1$20s: %2$s\n", "residentVMs", this.residentVMs);
            printWriter.printf("%1$20s: %2$s\n", "logging", this.logging);
            printWriter.printf("%1$20s: %2$s\n", "PIFs", this.PIFs);
            printWriter.printf("%1$20s: %2$s\n", "suspendImageSr", this.suspendImageSr);
            printWriter.printf("%1$20s: %2$s\n", "crashDumpSr", this.crashDumpSr);
            printWriter.printf("%1$20s: %2$s\n", "crashdumps", this.crashdumps);
            printWriter.printf("%1$20s: %2$s\n", "patches", this.patches);
            printWriter.printf("%1$20s: %2$s\n", "updates", this.updates);
            printWriter.printf("%1$20s: %2$s\n", "PBDs", this.PBDs);
            printWriter.printf("%1$20s: %2$s\n", "hostCPUs", this.hostCPUs);
            printWriter.printf("%1$20s: %2$s\n", "cpuInfo", this.cpuInfo);
            printWriter.printf("%1$20s: %2$s\n", "hostname", this.hostname);
            printWriter.printf("%1$20s: %2$s\n", "address", this.address);
            printWriter.printf("%1$20s: %2$s\n", "metrics", this.metrics);
            printWriter.printf("%1$20s: %2$s\n", "licenseParams", this.licenseParams);
            printWriter.printf("%1$20s: %2$s\n", "haStatefiles", this.haStatefiles);
            printWriter.printf("%1$20s: %2$s\n", "haNetworkPeers", this.haNetworkPeers);
            printWriter.printf("%1$20s: %2$s\n", "blobs", this.blobs);
            printWriter.printf("%1$20s: %2$s\n", "tags", this.tags);
            printWriter.printf("%1$20s: %2$s\n", "externalAuthType", this.externalAuthType);
            printWriter.printf("%1$20s: %2$s\n", "externalAuthServiceName", this.externalAuthServiceName);
            printWriter.printf("%1$20s: %2$s\n", "externalAuthConfiguration", this.externalAuthConfiguration);
            printWriter.printf("%1$20s: %2$s\n", "edition", this.edition);
            printWriter.printf("%1$20s: %2$s\n", "licenseServer", this.licenseServer);
            printWriter.printf("%1$20s: %2$s\n", "biosStrings", this.biosStrings);
            printWriter.printf("%1$20s: %2$s\n", "powerOnMode", this.powerOnMode);
            printWriter.printf("%1$20s: %2$s\n", "powerOnConfig", this.powerOnConfig);
            printWriter.printf("%1$20s: %2$s\n", "localCacheSr", this.localCacheSr);
            printWriter.printf("%1$20s: %2$s\n", "chipsetInfo", this.chipsetInfo);
            printWriter.printf("%1$20s: %2$s\n", "PCIs", this.PCIs);
            printWriter.printf("%1$20s: %2$s\n", "PGPUs", this.PGPUs);
            printWriter.printf("%1$20s: %2$s\n", "PUSBs", this.PUSBs);
            printWriter.printf("%1$20s: %2$s\n", "sslLegacy", this.sslLegacy);
            printWriter.printf("%1$20s: %2$s\n", "guestVCPUsParams", this.guestVCPUsParams);
            printWriter.printf("%1$20s: %2$s\n", new Object[]{"display", this.display});
            printWriter.printf("%1$20s: %2$s\n", "virtualHardwarePlatformVersions", this.virtualHardwarePlatformVersions);
            printWriter.printf("%1$20s: %2$s\n", "controlDomain", this.controlDomain);
            printWriter.printf("%1$20s: %2$s\n", "updatesRequiringReboot", this.updatesRequiringReboot);
            printWriter.printf("%1$20s: %2$s\n", "features", this.features);
            return stringWriter.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("uuid", this.uuid == null ? "" : this.uuid);
            hashMap.put("name_label", this.nameLabel == null ? "" : this.nameLabel);
            hashMap.put("name_description", this.nameDescription == null ? "" : this.nameDescription);
            hashMap.put("memory_overhead", this.memoryOverhead == null ? 0L : this.memoryOverhead);
            hashMap.put("allowed_operations", this.allowedOperations == null ? new LinkedHashSet() : this.allowedOperations);
            hashMap.put("current_operations", this.currentOperations == null ? new HashMap() : this.currentOperations);
            hashMap.put("API_version_major", this.APIVersionMajor == null ? 0L : this.APIVersionMajor);
            hashMap.put("API_version_minor", this.APIVersionMinor == null ? 0L : this.APIVersionMinor);
            hashMap.put("API_version_vendor", this.APIVersionVendor == null ? "" : this.APIVersionVendor);
            hashMap.put("API_version_vendor_implementation", this.APIVersionVendorImplementation == null ? new HashMap() : this.APIVersionVendorImplementation);
            hashMap.put("enabled", this.enabled == null ? false : this.enabled);
            hashMap.put("software_version", this.softwareVersion == null ? new HashMap() : this.softwareVersion);
            hashMap.put("other_config", this.otherConfig == null ? new HashMap() : this.otherConfig);
            hashMap.put("capabilities", this.capabilities == null ? new LinkedHashSet() : this.capabilities);
            hashMap.put("cpu_configuration", this.cpuConfiguration == null ? new HashMap() : this.cpuConfiguration);
            hashMap.put("sched_policy", this.schedPolicy == null ? "" : this.schedPolicy);
            hashMap.put("supported_bootloaders", this.supportedBootloaders == null ? new LinkedHashSet() : this.supportedBootloaders);
            hashMap.put("resident_VMs", this.residentVMs == null ? new LinkedHashSet() : this.residentVMs);
            hashMap.put("logging", this.logging == null ? new HashMap() : this.logging);
            hashMap.put("PIFs", this.PIFs == null ? new LinkedHashSet() : this.PIFs);
            hashMap.put("suspend_image_sr", this.suspendImageSr == null ? new SR("OpaqueRef:NULL") : this.suspendImageSr);
            hashMap.put("crash_dump_sr", this.crashDumpSr == null ? new SR("OpaqueRef:NULL") : this.crashDumpSr);
            hashMap.put("crashdumps", this.crashdumps == null ? new LinkedHashSet() : this.crashdumps);
            hashMap.put("patches", this.patches == null ? new LinkedHashSet() : this.patches);
            hashMap.put("updates", this.updates == null ? new LinkedHashSet() : this.updates);
            hashMap.put("PBDs", this.PBDs == null ? new LinkedHashSet() : this.PBDs);
            hashMap.put("host_CPUs", this.hostCPUs == null ? new LinkedHashSet() : this.hostCPUs);
            hashMap.put("cpu_info", this.cpuInfo == null ? new HashMap() : this.cpuInfo);
            hashMap.put("hostname", this.hostname == null ? "" : this.hostname);
            hashMap.put("address", this.address == null ? "" : this.address);
            hashMap.put("metrics", this.metrics == null ? new HostMetrics("OpaqueRef:NULL") : this.metrics);
            hashMap.put("license_params", this.licenseParams == null ? new HashMap() : this.licenseParams);
            hashMap.put("ha_statefiles", this.haStatefiles == null ? new LinkedHashSet() : this.haStatefiles);
            hashMap.put("ha_network_peers", this.haNetworkPeers == null ? new LinkedHashSet() : this.haNetworkPeers);
            hashMap.put("blobs", this.blobs == null ? new HashMap() : this.blobs);
            hashMap.put("tags", this.tags == null ? new LinkedHashSet() : this.tags);
            hashMap.put("external_auth_type", this.externalAuthType == null ? "" : this.externalAuthType);
            hashMap.put("external_auth_service_name", this.externalAuthServiceName == null ? "" : this.externalAuthServiceName);
            hashMap.put("external_auth_configuration", this.externalAuthConfiguration == null ? new HashMap() : this.externalAuthConfiguration);
            hashMap.put("edition", this.edition == null ? "" : this.edition);
            hashMap.put("license_server", this.licenseServer == null ? new HashMap() : this.licenseServer);
            hashMap.put("bios_strings", this.biosStrings == null ? new HashMap() : this.biosStrings);
            hashMap.put("power_on_mode", this.powerOnMode == null ? "" : this.powerOnMode);
            hashMap.put("power_on_config", this.powerOnConfig == null ? new HashMap() : this.powerOnConfig);
            hashMap.put("local_cache_sr", this.localCacheSr == null ? new SR("OpaqueRef:NULL") : this.localCacheSr);
            hashMap.put("chipset_info", this.chipsetInfo == null ? new HashMap() : this.chipsetInfo);
            hashMap.put("PCIs", this.PCIs == null ? new LinkedHashSet() : this.PCIs);
            hashMap.put("PGPUs", this.PGPUs == null ? new LinkedHashSet() : this.PGPUs);
            hashMap.put("PUSBs", this.PUSBs == null ? new LinkedHashSet() : this.PUSBs);
            hashMap.put("ssl_legacy", this.sslLegacy == null ? false : this.sslLegacy);
            hashMap.put("guest_VCPUs_params", this.guestVCPUsParams == null ? new HashMap() : this.guestVCPUsParams);
            hashMap.put("display", (Object)(this.display == null ? Types.HostDisplay.UNRECOGNIZED : this.display));
            hashMap.put("virtual_hardware_platform_versions", this.virtualHardwarePlatformVersions == null ? new LinkedHashSet() : this.virtualHardwarePlatformVersions);
            hashMap.put("control_domain", this.controlDomain == null ? new VM("OpaqueRef:NULL") : this.controlDomain);
            hashMap.put("updates_requiring_reboot", this.updatesRequiringReboot == null ? new LinkedHashSet() : this.updatesRequiringReboot);
            hashMap.put("features", this.features == null ? new LinkedHashSet() : this.features);
            return hashMap;
        }
    }
}

