/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.GPUGroup;
import com.xensource.xenapi.Host;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.PCI;
import com.xensource.xenapi.Task;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.VGPU;
import com.xensource.xenapi.VGPUType;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

public class PGPU
extends XenAPIObject {
    protected final String ref;

    PGPU(String string) {
        this.ref = string;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof PGPU) {
            PGPU pGPU = (PGPU)object;
            return pGPU.ref.equals(this.ref);
        }
        return false;
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public Record getRecord(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.get_record";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toPGPURecord(v);
    }

    public static PGPU getByUuid(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "PGPU.get_by_uuid";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toPGPU(v);
    }

    public String getUuid(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.get_uuid";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public PCI getPCI(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.get_PCI";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toPCI(v);
    }

    public GPUGroup getGPUGroup(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.get_GPU_group";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toGPUGroup(v);
    }

    public Host getHost(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.get_host";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toHost(v);
    }

    public Map<String, String> getOtherConfig(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.get_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Set<VGPUType> getSupportedVGPUTypes(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.get_supported_VGPU_types";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVGPUType(v);
    }

    public Set<VGPUType> getEnabledVGPUTypes(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.get_enabled_VGPU_types";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVGPUType(v);
    }

    public Set<VGPU> getResidentVGPUs(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.get_resident_VGPUs";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfVGPU(v);
    }

    public Map<VGPUType, Long> getSupportedVGPUMaxCapacities(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.get_supported_VGPU_max_capacities";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfVGPUTypeLong(v);
    }

    public Types.PgpuDom0Access getDom0Access(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.get_dom0_access";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toPgpuDom0Access(v);
    }

    public Boolean getIsSystemDisplayDevice(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.get_is_system_display_device";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public Map<String, String> getCompatibilityMetadata(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.get_compatibility_metadata";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public void setOtherConfig(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.set_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToOtherConfig(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "PGPU.add_to_other_config";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromOtherConfig(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "PGPU.remove_from_other_config";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public Task addEnabledVGPUTypesAsync(Connection connection, VGPUType vGPUType) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.PGPU.add_enabled_VGPU_types";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(vGPUType)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void addEnabledVGPUTypes(Connection connection, VGPUType vGPUType) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.add_enabled_VGPU_types";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(vGPUType)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task removeEnabledVGPUTypesAsync(Connection connection, VGPUType vGPUType) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.PGPU.remove_enabled_VGPU_types";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(vGPUType)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void removeEnabledVGPUTypes(Connection connection, VGPUType vGPUType) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.remove_enabled_VGPU_types";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(vGPUType)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task setEnabledVGPUTypesAsync(Connection connection, Set<VGPUType> set) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.PGPU.set_enabled_VGPU_types";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(set)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void setEnabledVGPUTypes(Connection connection, Set<VGPUType> set) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.set_enabled_VGPU_types";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(set)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task setGPUGroupAsync(Connection connection, GPUGroup gPUGroup) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.PGPU.set_GPU_group";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(gPUGroup)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void setGPUGroup(Connection connection, GPUGroup gPUGroup) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.set_GPU_group";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(gPUGroup)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task getRemainingCapacityAsync(Connection connection, VGPUType vGPUType) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.PGPU.get_remaining_capacity";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(vGPUType)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Long getRemainingCapacity(Connection connection, VGPUType vGPUType) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.get_remaining_capacity";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(vGPUType)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Task enableDom0AccessAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.PGPU.enable_dom0_access";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Types.PgpuDom0Access enableDom0Access(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.enable_dom0_access";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toPgpuDom0Access(v);
    }

    public Task disableDom0AccessAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.PGPU.disable_dom0_access";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Types.PgpuDom0Access disableDom0Access(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.disable_dom0_access";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toPgpuDom0Access(v);
    }

    public static Set<PGPU> getAll(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.get_all";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfPGPU(v);
    }

    public static Map<PGPU, Record> getAllRecords(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PGPU.get_all_records";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfPGPUPGPURecord(v);
    }

    public static class Record
    implements Types.Record {
        public String uuid;
        public PCI PCI;
        public GPUGroup GPUGroup;
        public Host host;
        public Map<String, String> otherConfig;
        public Set<VGPUType> supportedVGPUTypes;
        public Set<VGPUType> enabledVGPUTypes;
        public Set<VGPU> residentVGPUs;
        public Map<VGPUType, Long> supportedVGPUMaxCapacities;
        public Types.PgpuDom0Access dom0Access;
        public Boolean isSystemDisplayDevice;
        public Map<String, String> compatibilityMetadata;

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            printWriter.printf("%1$20s: %2$s\n", "PCI", this.PCI);
            printWriter.printf("%1$20s: %2$s\n", "GPUGroup", this.GPUGroup);
            printWriter.printf("%1$20s: %2$s\n", "host", this.host);
            printWriter.printf("%1$20s: %2$s\n", "otherConfig", this.otherConfig);
            printWriter.printf("%1$20s: %2$s\n", "supportedVGPUTypes", this.supportedVGPUTypes);
            printWriter.printf("%1$20s: %2$s\n", "enabledVGPUTypes", this.enabledVGPUTypes);
            printWriter.printf("%1$20s: %2$s\n", "residentVGPUs", this.residentVGPUs);
            printWriter.printf("%1$20s: %2$s\n", "supportedVGPUMaxCapacities", this.supportedVGPUMaxCapacities);
            printWriter.printf("%1$20s: %2$s\n", new Object[]{"dom0Access", this.dom0Access});
            printWriter.printf("%1$20s: %2$s\n", "isSystemDisplayDevice", this.isSystemDisplayDevice);
            printWriter.printf("%1$20s: %2$s\n", "compatibilityMetadata", this.compatibilityMetadata);
            return stringWriter.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("uuid", this.uuid == null ? "" : this.uuid);
            hashMap.put("PCI", this.PCI == null ? new PCI("OpaqueRef:NULL") : this.PCI);
            hashMap.put("GPU_group", this.GPUGroup == null ? new GPUGroup("OpaqueRef:NULL") : this.GPUGroup);
            hashMap.put("host", this.host == null ? new Host("OpaqueRef:NULL") : this.host);
            hashMap.put("other_config", this.otherConfig == null ? new HashMap() : this.otherConfig);
            hashMap.put("supported_VGPU_types", this.supportedVGPUTypes == null ? new LinkedHashSet() : this.supportedVGPUTypes);
            hashMap.put("enabled_VGPU_types", this.enabledVGPUTypes == null ? new LinkedHashSet() : this.enabledVGPUTypes);
            hashMap.put("resident_VGPUs", this.residentVGPUs == null ? new LinkedHashSet() : this.residentVGPUs);
            hashMap.put("supported_VGPU_max_capacities", this.supportedVGPUMaxCapacities == null ? new HashMap() : this.supportedVGPUMaxCapacities);
            hashMap.put("dom0_access", (Object)(this.dom0Access == null ? Types.PgpuDom0Access.UNRECOGNIZED : this.dom0Access));
            hashMap.put("is_system_display_device", this.isSystemDisplayDevice == null ? false : this.isSystemDisplayDevice);
            hashMap.put("compatibility_metadata", this.compatibilityMetadata == null ? new HashMap() : this.compatibilityMetadata);
            return hashMap;
        }
    }
}

