/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.PVSSite;
import com.xensource.xenapi.Task;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

public class PVSServer
extends XenAPIObject {
    protected final String ref;

    PVSServer(String string) {
        this.ref = string;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof PVSServer) {
            PVSServer pVSServer = (PVSServer)object;
            return pVSServer.ref.equals(this.ref);
        }
        return false;
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public Record getRecord(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PVS_server.get_record";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toPVSServerRecord(v);
    }

    public static PVSServer getByUuid(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "PVS_server.get_by_uuid";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toPVSServer(v);
    }

    public String getUuid(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PVS_server.get_uuid";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Set<String> getAddresses(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PVS_server.get_addresses";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfString(v);
    }

    public Long getFirstPort(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PVS_server.get_first_port";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public Long getLastPort(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PVS_server.get_last_port";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toLong(v);
    }

    public PVSSite getSite(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PVS_server.get_site";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toPVSSite(v);
    }

    public static Task introduceAsync(Connection connection, Set<String> set, Long l, Long l2, PVSSite pVSSite) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.PVS_server.introduce";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(set), Marshalling.toXMLRPC(l), Marshalling.toXMLRPC(l2), Marshalling.toXMLRPC(pVSSite)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static PVSServer introduce(Connection connection, Set<String> set, Long l, Long l2, PVSSite pVSSite) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PVS_server.introduce";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(set), Marshalling.toXMLRPC(l), Marshalling.toXMLRPC(l2), Marshalling.toXMLRPC(pVSSite)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toPVSServer(v);
    }

    public Task forgetAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.PVS_server.forget";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void forget(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PVS_server.forget";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Set<PVSServer> getAll(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PVS_server.get_all";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfPVSServer(v);
    }

    public static Map<PVSServer, Record> getAllRecords(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PVS_server.get_all_records";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfPVSServerPVSServerRecord(v);
    }

    public static class Record
    implements Types.Record {
        public String uuid;
        public Set<String> addresses;
        public Long firstPort;
        public Long lastPort;
        public PVSSite site;

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            printWriter.printf("%1$20s: %2$s\n", "addresses", this.addresses);
            printWriter.printf("%1$20s: %2$s\n", "firstPort", this.firstPort);
            printWriter.printf("%1$20s: %2$s\n", "lastPort", this.lastPort);
            printWriter.printf("%1$20s: %2$s\n", "site", this.site);
            return stringWriter.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("uuid", this.uuid == null ? "" : this.uuid);
            hashMap.put("addresses", this.addresses == null ? new LinkedHashSet() : this.addresses);
            hashMap.put("first_port", this.firstPort == null ? 0L : this.firstPort);
            hashMap.put("last_port", this.lastPort == null ? 0L : this.lastPort);
            hashMap.put("site", this.site == null ? new PVSSite("OpaqueRef:NULL") : this.site);
            return hashMap;
        }
    }
}

