# eG Node.js Monitor

## Table of contents

- [Installation](#installation)
  - [With eG Agent](#with-eg-agent)
  - [Without eG Agent](#with-eg-agent)
- [Enabling](#enabling)
  - [Without Modifying the Source Code](#without-modifying-the-source-code)
    - [Using NodeJS Arguments](#using-nodejs-arguments)
    - [For pm2 based application](#for-pm2-based-application)
  - [By Modifying the Source Code](#by-modifying-the-source-code)
- [Native Addons](#native-addons)
  - [Step 1 - Installing Native Addons compiler](#step-1---installing-native-addons-compiler)
  - [Step 2 - Rebuilding Native Addons](#step-2---rebuilding-native-addons)
- [Enabling eG Node Profiler for Kubernetes Environment](#enabling-eg-node-profiler-for-kubernetes-environment)
  - [Step 1 - Build eG NodeJS profiler - Docker Image](#step-1---build-eg-nodejs-profiler---docker-image)
  - [Step 2 - Add NodeJS profiler Docker Image in your YAML file](#step-2---add-nodejs-profiler-docker-image-in-your-yaml-file)
  - [Step 3 - Deploy your application](#step-3---deploy-your-application)

## Installation

### With eG Agent
Install the eG agent on the Node.js application machine/host. Installing the eG Agent will check for the presence of node and npm software packages and will run `npm rebuild` or `npm install` to setup nodejs monitoring on this host. The packages and dependencies will be installed under `<<EGURKHA_HOME>>/lib/apm/Nodejs/default` directory.  

### Without eG Agent
1. Add the NodeJS component via eG Admin and download the zip package that contains the node_modules necessary for NodeJs application monitoring.  

1. Copy the zip file to the target system that needs application monitoring.  

1. Create a folder namely eg-node-monitor inside the node_modules folder and extract the zip file contents on to it.  

1. Go inside the eg-node-monitor folder and run `npm install --production` command to recompile the native addons. 

## Enabling
### **Without Modifying the Source Code**
#### **Using NodeJS Arguments** 
Add an additional `--require`  parameter and some other parameters needed for the eG Node.js profiler when starting the node executable. That is: 

Assuming you would normally start the application by doing something like  node app/index.js, add an additional [--require command line argument](see https://nodejs.org/api/cli.html#cli_r_require_module). 

That is, 

```
node app/index.js 
```
becomes 
```
node --require <<eGurkha home>>/lib/apm/NodeJS/default/start app/index.js --eg_component_id=<<component_id>> --eg_unique_component_id=<<unique_component_id>> --eg_agent_port=<<port no>> --eg_agent_host=<<agent IP/host>> 
```

This will load and initialize the Node.js profiler before the application code is loaded. 

#### **For pm2 based application** 
If you are starting the application using PM2 config file (ecosystem.config.js) then please add the node argument and environment values in the config file (ecosystem.config.js) as shown below. 

```json
  "node_args": "--require <<eGurkha home>>/lib/apm/NodeJS/default/start", 
  "env": { 
    "EG_COMPONENT_ID": "<<component_id>>", 
    "EG_UNIQUE_COMPONENT_ID": "<<unique_component_id>>", 
    "EG_AGENT_PORT": "<<port no>>", 
    "EG_AGENT_HOST": "<<agent IP/host>>" 
} 
```

### By Modifying the Source Code 
Add the snippet code to first statement in your application. All other require statements or code must be done after the profiler is initialized.

**Javascript**
```javascript
require("<<EGURKHA_HOME>>/lib/apm/Nodejs/default").start({
    component_id: "<<component ID>>",
    unique_component_id: "<<unique component ID>>",
    agent_port: "<<port no>>",
    agent_host: "<<agent ip/host>>",
});
```

**Typescript**
```typescript
import egMonitor from '<<EGURKHA_HOME>>/lib/apm/NodeJS/default'

egMonitor.start({
    component_id: "<<component ID>>",
    unique_component_id: "<<unique component ID>>",
    agent_port: "<<port no>>",
    agent_host: "<<agent ip/host>>",
});
```

## Native Addons 
Some monitoring information is not available to Node.js programs without the help of native addons. Specifically, the eG Agent Node.js profiler uses these addons 

- to retrieve information about garbage collection memory reclaimed bytes, 
- to retrieve min, max, avg event loop time, 
- For CPU and memory profiling 

The native addons may be incompatible with the target machine's system architecture or the Node.js version in use, so it neededs to be compiled to the target machine with help of native addon compiler. 
While the profiler works fine without these native addons (technically, they are marked as optional dependencies), we strongly recommend you to support native addon compilation. 

### Step 1 - Installing Native Addons compiler
Native addons are compiled automatically for your system and Node.js version when the eG agent is installed and started first time (as part of the npm install step). In order for the compilation to work, the system needs to have tools like make, g++ and python installed. These tools can often be installed via a bundle called build-essential or similar (depending on your package manager and registry). The following example shows how to do this for a typical Ubuntu setup. 

**On Debian/Ubuntu:** 
```
apt-get install -y g++ make python3 
```
**On RHEL/CentOS/Amazon Linux:** 
```
yum install -y gcc-c++ make python3 
```
**On Windows:** 
While installing the Node.js please select the `Tools for Native Modules` checkbox in the Node.js setup window to install the build tools. 

Below are the other options to install build tools but above is the recommend step.  
```
npm install --global windows-build-tools  
```
If above fails to install then try below 
```
npm install --global --production windows-build-tools@4.0.0 
```
Refer [windows-build-tools](https://www.npmjs.com/package/windows-build-tools) for more details 
If still can’t install build tools then please follow the steps in https://github.com/nodejs/node-gyp#installation 

### Step: 2 – Installing files need for node-gyp

Please ignore this step If you have internet in your environment.
- **Get the node headers file:** 
`curl -O https://nodejs.org/dist/v14.17.3/node-v14.17.3-headers.tar.gz` (make sure you have the correct node version appropriate, and you need a machine with internet)

- **Copy header tarball to offline machine** (approach may vary depending on your situation an example may be to winscp to vm)

- **Create the node-gyp folder that the library looks for if it's not already existing:** `mkdir -p ~/.cache/node-gyp/14.17.3` (PITFALL: in some versions node-gyp folder is under ~/.node-gyp)

- **Tar the file to node-gyp folder:** 
`tar -xf node-v14.17.3-headers.tar.gz --directory ~/.cache/node-gyp/14.17.3/ --strip-components 1` (make sure you have the correct versions here)

- **Create the installVersion manually:** `echo 9 >~/.cache/node-gyp/14.17.3/installVersion` (usually it is created automatically if you have internet access)

 
### Step 3 - Rebuilding Native Addons
After installing the build tools please restart the agent which will rebuild the native addon for your system and for agent less monitoring please delete node_modules inside eg-node-monitor folder and run `npm install --production` in the eg-node-monitor folder.   

**It is important that the installation of the dependencies is happening on the machine which will run the application.** 

This needs to be ensured, because otherwise the native addons may be incompatible with the target machine's system architecture or the Node.js version in use. It is therefore a bad practice to npm install dependencies on a build server and to copy the node modules (including the dependencies) to the target machine. 

If the installation of an optional dependency ends with gyp ERR! not ok, then mentioned features will not work. 

## Enabling eG Node Profiler for Kubernetes Environment 
The profiler image is built separately from the application image and can be reused across multiple Node.js application deployments.
The Node.js and operating system versions of the profiler image should match with the Node.js and operating system versions of the application image to ensure to support native addons.
We can enable the Node.js monitor using init-container feature of Kubernetes and additional techniques
**Note:**
Other than native addon which is used to get GC, event loop and CPU profiling, other functionality will work with eG common Node.js profiler image but we strongly advice you to build your own image based on your application image OS and Node.js version.

### Step 1 - Build eG NodeJS profiler - Docker Image
Skip this step if you already have eG Node.js profiler Docker Image

- Add the NodeJS component via eG Admin and download the zip package that contains the node_modules necessary for NodeJs application monitoring.  
- Extract the Dockerfile alone from the zip file and keep the zip file.
- Edit the base image in the Dockerfile, which is the first line of the Dockerfile, according to your target NodeJS Application Docker Image, so that it would match the NodeJS Version and Operating System The line will look like `FROM node:16-alpine3.14`
- Run the Docker build command (`docker build --tag <<user>>/eg-node-monitor:1.0 .`)
- Push the code into the Docker repository or your own repository.

### Step 2 - Add Node.js profiler Docker Image in your YAML file
Please open your Application YAML file
- Add a volume inside the deployment spec of your application as shown below.
```
  volumes:
  # Make egbtm available as a volume
  - name: egbtm
    emptyDir: {}
```
- Add int containers into the deployment spec of your application above the containers spec as shown below.

```
  initContainers:
  - name: setup-egbtm
    image: <<user>>/eg-node-monitor:1.0
    command: ["/bin/sh","copy.sh"]
    args:
    - /opt/egbtm
    volumeMounts:
    - mountPath: /opt/egbtm
      name: egbtm
```

- Add the environment variable and volume mounts as shown below inside the containers spec
```
  containers:
  - name: nodejsapp
    image: <<Application image>>
    env:
    - name: NODE_OPTIONS
      value: "--require=/opt/egbtm/start"
    - name: EG_AGENT_HOST
      valueFrom:
        fieldRef:
          fieldPath: status.hostIP
    volumeMounts:
    - name: egbtm
      mountPath: /opt/egbtm
```

**Sample YAML**
```
  volumes:
  # Make egbtm available as a volume
  - name: egbtm
    emptyDir: {}
  initContainers:
  - name: setup-egbtm
    image: <<user>>/eg-node-monitor:1.0
    command: ["/bin/sh","copy.sh"]
    args:
    - /opt/egbtm
    volumeMounts:
    - mountPath: /opt/egbtm
      name: egbtm
  containers:
  - name: nodejsapp
    image: nodejsapp:1.3
    env:
    - name: NODE_OPTIONS
      value: "--require=/opt/egbtm/start"
    - name: EG_AGENT_HOST
      valueFrom:
        fieldRef:
          fieldPath: status.hostIP
    volumeMounts:
    - name: egbtm
      mountPath: /opt/egbtm
```

### Step 3 - Deploy your application
While deploying, the Kubernetes will download the mentioned eG Node.js profiler image which is mentioned in the init container section and enable Node.js profiler. 