/*******************************************************************************
 *      File name               :   HomePageRequest.java
 *      Purpose                 :   This class invokes respective Threads for JTM demo
 *      Creation Date           :   27-03-2012
 ******************************************************************************/


package app.com.src;
import com.eg.*;
import com.egurkha.util.*;
import com.eg.EgConMonHelper;
import app.com.src.*;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;
import javax.servlet.ServletContext;
import javax.servlet.ServletConfig;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.Socket;

public class HomePageRequest extends HttpServlet 
{
	ServletContext context;
	public static boolean jspFlag = false;
	public static boolean servletFlag = false;
	public static boolean exceptionFlag = false;
	public static boolean mailFlag = false;
	
	public void init(ServletConfig config) throws ServletException
	{
		super.init(config);
		context = config.getServletContext();
	}
	
	public void service(HttpServletRequest request, HttpServletResponse response) throws IOException,ServletException
	{
		
		String param = request.getParameter("param");
		boolean result = false;

		try
		{
			int i = 0;
			if(param != null && param.length() > 0)
				i = Integer.parseInt(param);


			switch (i)
			{
				case 1:
					result=enterPage("jsp");
					if(result)
						jspFlag = true;
					break;
				case 2:
					result=enterPage("servlet");
					if(result)
						servletFlag = true;
					break;
				case 3:
					result=enterPage("exception");
					if(result)
						exceptionFlag = true;
					break;
				case 4:
					result=enterPage("mail");
					if(result)
						mailFlag = true;
					break;
				case 5:
					result=exitPage("jsp");
					if(result)
						jspFlag = false;
					break;
				case 6:
					result=exitPage("servlet");
					if(result)
						servletFlag = false;
					break;
				case 7:
					result=exitPage("exception");
					if(result)
						exceptionFlag = false;
					break;
				case 8:
					result=exitPage("mail");
					if(result)
						mailFlag = false;
					break;
				
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}

		try
		{
			if(result)
			{
				context.getRequestDispatcher("/admin/EgJtmDemo.jsp?whoami="+EgConMonHelper.whoami+"&pwd="+EgConMonHelper.pwd).forward(request,response);
			}
			else
			{
				return;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}

	private boolean enterPage(String s)
	{
		boolean result1=false;
		if(s != null)
		{
			if(s.equals("jsp"))
			{
				return browseItem("start");
			}
			else if(s.equals("servlet"))
			{
				return purchase("start");
			}
			else if(s.equals("exception"))
			{
				return payment("start");
			}
			else if(s.equals("mail"))
			{
				return sendAck("start");
			}
			else
			{
				boolean b1, b2, b3, b4 = false;
				b1 = browseItem("start");
				b2 = purchase("start");
				b3 = payment("start");
				b4 = sendAck("start");
				if(b1 && b2 && b3 && b4)
					return true;
			}
		}
		return false;
	}

	private boolean exitPage(String s)
	{
		if(s != null)
		{
			if(s.equals("jsp"))
			{
				return browseItem("stop");
			}
			else if(s.equals("servlet"))
			{
				return purchase("stop");
			}
			else if(s.equals("exception"))
			{
				return payment("stop");
			}
			else if(s.equals("mail"))
			{
				return sendAck("stop");
			}
			else
			{
				boolean b1, b2, b3, b4 = false;
				b1 = browseItem("stop");
				b2 = purchase("stop");
				b3 = payment("stop");
				b4 = sendAck("stop");
				return true;
			}
		}
		return false;
	}

	private boolean browseItem(String s)
	{
		JspThread jthread=new JspThread();
		if(s != null && s.equals("start"))
		{
			jthread.finish=true;
			return true;
		}
		else if(s != null && s.equals("stop"))
		{
			jthread.finish=false;
			return true;
		}
		return false;
	}

	private boolean purchase(String s)
	{
		ServletThread sthread=new ServletThread();
		if(s != null && s.equals("start"))
		{
			sthread.finish=true;
			return true;
		}
		else if(s != null && s.equals("stop"))
		{
			sthread.finish=false;
			return true;
		}
		return false;
	}

	private boolean payment(String s)
	{
		ExceptionThread ethread=new ExceptionThread();
		if(s != null && s.equals("start"))
		{
			ethread.finish=true;
			return true;
		}
		else if(s != null && s.equals("stop"))
		{
			ethread.finish=false;
			return true;
		}
		return false;
	}

	private boolean sendAck(String s)
	{
		MailThread mthread=new MailThread();
		if(s != null && s.equals("start"))
		{
			mthread.finish=true;
			return true;
		}
		else if(s != null && s.equals("stop"))
		{
			mthread.finish=false;
			return true;
		}
		return false;
	}
}
