"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var fs = require("fs");
function applyPatch(patch) {
    var fileContents = readTarget(patch.target);
    if (fileContents.indexOf(patch.payload) >= 0) {
        console.log("Skipping patch \"" + patch.name + "\" because it is already applied.");
        return false;
    }
    var injectionLocation = indexOfInjection(fileContents, patch.anchor);
    if (injectionLocation === undefined) {
        throw new Error("Could not locate patch anchor for " + patch.name + "!");
    }
    var updated = fileContents.substr(0, injectionLocation) + patch.payload + fileContents.substr(injectionLocation);
    writeTarget(patch.target, updated);
    return true;
}
exports.applyPatch = applyPatch;
function undoPatch(patch) {
    var fileContents = readTarget(patch.target);
    var index = fileContents.indexOf(patch.payload);
    if (index < 0) {
        throw new Error("Could not find the patch of " + patch.name + "!");
    }
    var updated = fileContents.substr(0, index) + fileContents.substr(index + patch.payload.length);
    writeTarget(patch.target, updated);
}
exports.undoPatch = undoPatch;
function readTarget(target) {
    return fs.readFileSync(target).toString();
}
function writeTarget(target, newContents) {
    return fs.writeFileSync(target, newContents);
}
function indexOfInjection(haystack, anchor) {
    var result = anchor.exec(haystack);
    if (result != null) {
        return anchor.lastIndex;
    }
    return;
}
