var ConnectionManager = /** @class */ (function () {
    function ConnectionManager(path) {
        this.webSocket = new WebSocket(path);
    }
    ConnectionManager.prototype.send = function (payload) {
        if (this.webSocket.readyState === 1) {
            this.webSocket.send(payload);
        }
    };
    ConnectionManager.prototype.on = function (event, callback) {
        console.log(event);
        if (event === "open") {
            this.webSocket.onopen = callback;
        }
        else if (event === "message") {
            this.webSocket.onmessage = function (evt) { return callback(evt.data); };
        }
    };
    ConnectionManager.prototype.close = function () {
        this.webSocket.close();
    };
    return ConnectionManager;
}());
export default ConnectionManager;
