var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { Platform, NativeModules } from "react-native";
import { createClient } from "./eg-core-client";
import getReactNativeVersion from "./helpers/getReactNativeVersion";
import getReactNativeDimensions from "./helpers/getReactNativeDimensions";
import asyncStorage from "./plugins/asyncStorage";
import overlay from "./plugins/overlay";
import openInEditor from "./plugins/openInEditor";
import trackGlobalErrors from "./plugins/trackGlobalErrors";
import networking from "./plugins/networking";
import storybook from "./plugins/storybook";
import devTools from "./plugins/devTools";
import ConnectionManager from "./connection-manager";
var constants = NativeModules.PlatformConstants || {};
var tempClientId = null;
var DEFAULTS = {
    appToken: "",
    createSocket: function (path) { return new ConnectionManager(path); },
    host: "1.1.1.1",
    port: 1,
    name: "React Native App",
    environment: process.env.NODE_ENV || (__DEV__ ? "development" : "production"),
    client: __assign({ eGLibraryName: "@eginnovations/react-native-eg-agent", eGLibraryVersion: "REACT_NATIVE_EG-AGENT_VERSION", platform: Platform.OS, platformVersion: Platform.Version, osRelease: constants.Release, model: constants.Model, serverHost: constants.ServerHost, forceTouch: constants.forceTouchAvailable || false, interfaceIdiom: constants.interfaceIdiom, systemName: constants.systemName, uiMode: constants.uiMode, serial: constants.Serial, androidId: constants.androidID, reactNativeVersion: getReactNativeVersion() }, getReactNativeDimensions()),
    /* eslint-disable @typescript-eslint/no-use-before-define */
    getClientId: function () {
        if (eGAgent.asyncStorageHandler) {
            return eGAgent.asyncStorageHandler.getItem(tempClientId);
        }
        return new Promise(function (resolve) { return resolve(tempClientId); });
    },
    setClientId: function (clientId) {
        if (eGAgent.asyncStorageHandler) {
            return eGAgent.asyncStorageHandler.setItem(tempClientId, clientId);
        }
        tempClientId = clientId;
        return Promise.resolve();
    },
    /* eslint-enable @typescript-eslint/no-use-before-define */
    proxyHack: true,
};
var eGAgent = createClient(DEFAULTS);
function getPluginOptions(options) {
    return typeof options === "object" ? options : null;
}
eGAgent.useReactNative = function (options) {
    if (options === void 0) { options = {}; }
    if (options.errors !== false) {
        eGAgent.use(trackGlobalErrors(getPluginOptions(options.errors)));
    }
    if (options.editor !== false) {
        eGAgent.use(openInEditor(getPluginOptions(options.editor)));
    }
    if (options.overlay !== false) {
        eGAgent.use(overlay());
    }
    if (options.asyncStorage !== false) {
        eGAgent.use(asyncStorage(getPluginOptions(options.asyncStorage)));
    }
    if (options.networking !== false) {
        eGAgent.use(networking(getPluginOptions(options.networking)));
    }
    if (options.storybook !== false) {
        eGAgent.use(storybook());
    }
    if (options.devTools !== false) {
        eGAgent.use(devTools());
    }
    return eGAgent;
};
eGAgent.setAsyncStorageHandler = function (asyncStorage) {
    eGAgent.asyncStorageHandler = asyncStorage;
    return eGAgent;
};
export { asyncStorage, trackGlobalErrors, openInEditor, overlay, networking, storybook, devTools };
export default eGAgent;
