import { getReactNativeDimensionsWithDimensions } from "./getReactNativeDimensions";
describe("getReactNativeDimensions", function () {
    it("should return dimensions", function () {
        var screenDimensions = { width: 10, height: 51, scale: 1, fontScale: 3 };
        var windowDimensions = { width: 10, height: 15, scale: 23, fontScale: 3 };
        var result = getReactNativeDimensionsWithDimensions(screenDimensions, windowDimensions);
        expect(result).toEqual({
            screenWidth: Math.ceil(screenDimensions.width),
            screenHeight: Math.ceil(screenDimensions.height),
            screenScale: screenDimensions.scale,
            screenFontScale: screenDimensions.fontScale,
            windowWidth: Math.ceil(windowDimensions.width),
            windowHeight: Math.ceil(windowDimensions.height),
            windowScale: windowDimensions.scale,
            windowFontScale: windowDimensions.fontScale,
        });
    });
});
