/**
 * Provides a global error handler to report errors..
 */
 import { NativeModules } from "react-native"
 import { eG, eGCore } from "../eg-core-client"
 import { setJSExceptionHandler} from 'react-native-exception-handler';
 import { parseStackTrace } from 'errorstacks';
 
 // a few functions to help source map errors -- these seem to be not available immediately
 // so we're lazy loading.
 //let parseErrorStack
 //let symbolicateStackTrace
 
 export interface TrackGlobalErrorsOptions {
   veto?: (frame: any) => boolean
 }
 
 // defaults
 const PLUGIN_DEFAULTS: TrackGlobalErrorsOptions = {
   veto: null,
 }
 
 // const reactNativeFrameFinder = frame => contains('/node_modules/react-native/', frame.fileName)
 
 // our plugin entry point
 export default <eGSubtype = eGCore>(options: TrackGlobalErrorsOptions) => (eg: eG<eGSubtype> & eGSubtype) => {
   // setup configuration
   const config = Object.assign({}, PLUGIN_DEFAULTS, options || {})
 
   let swizzled = null
   let isSwizzled = false
 
   function eGExceptionHijacker(message, prettyStack, currentExceptionID) {
     // do Facebook's stuff first
     alert('eGExceptionHijacker')
     swizzled(message, prettyStack, currentExceptionID)
 
     // console.log("eGExceptionHijacker:message::"+message)
     // console.log("eGExceptionHijacker:prettyStack::"+prettyStack)
     // console.log("eGExceptionHijacker:currentExceptionID::"+currentExceptionID)
     // then convert & transport it
     try {
       // rewrite the stack frames to be in the format we're expecting
       let stack = prettyStack.map(frame => ({
         functionName: frame.methodName === "<unknown>" ? null : frame.methodName,
         lineNumber: frame.lineNumber,
         columnNumber: frame.column,
         fileName: frame.file,
       }))
 
       // does the dev want us to keep each frame?
       if (config.veto) {
         stack = stack.filter(frame => config.veto(frame))
       }
 
       // throw it over to us
       (eg as any).error(message, stack) // TODO: Fix this.
     } catch (e) {
       console.log("eGExceptionHijacker:e::", e)
       
       // TODO: no one must ever know our dark secrets
     }
   }
 
   // here's how to swizzle
   function trackGlobalErrors() {
     // console.log("trackGlobalErrors:isSwizzled::"+isSwizzled)
     // console.log("trackGlobalErrors:NativeModules.ExceptionsManager::"+NativeModules.ExceptionsManager)
     if (isSwizzled) return
     if (!NativeModules.ExceptionsManager) return
     swizzled = NativeModules.ExceptionsManager.updateExceptionMessage
     NativeModules.ExceptionsManager.updateExceptionMessage = eGExceptionHijacker
     isSwizzled = true
   }
 
   // restore the original
   function untrackGlobalErrors() {
     // console.log("untrackGlobalErrors:isSwizzled::"+isSwizzled)
     // console.log("untrackGlobalErrors:NativeModules.ExceptionsManager::"+NativeModules.ExceptionsManager)
     if (!swizzled) return
     if (!NativeModules.ExceptionsManager) return
     NativeModules.ExceptionsManager.updateExceptionMessage = swizzled
     isSwizzled = false
   }
 
   // auto start this
   trackGlobalErrors()
   const handleError = (error, isFatal) => {
     if(isFatal){
      reportError(error);
     }else{
       console.log(error)
     }
     
   };
   
   setJSExceptionHandler(handleError, true);
   
   // manually fire an error
   function reportError(error) {
     //console.log("reportError:isSwizzled::"+error)
     // console.log("untrackGlobalErrors:NativeModules.ExceptionsManager::"+NativeModules.ExceptionsManager)
     //(eg as any).error(error.message, true) 
     try{
       const parseErrorStack = parseStackTrace(error.stack);
       //console.log('parsed', parseErrorStack)
       if (parseErrorStack) {
         let stack = parseErrorStack.map((stackFrame:any) => ({
           fileName: stackFrame.file,
           functionName: stackFrame.name,
           lineNumber: stackFrame.line,
         }));
 
         //console.log('error.message', error.message);
         if (config.veto) {
           stack = stack.filter(function (frame) { return config.veto(frame); });
         }
         (eg as any).error(error.message, error);
       }
      
     }catch(err){
       //nothing happened. move along.
     }
 
     
   }
 
   // the eg plugin interface
   return {
     // attach these functions to the eg
     features: {
       reportError,
       trackGlobalErrors,
       untrackGlobalErrors,
     },
   }
 }
 