declare module '@capacitor/core' {
    interface PluginRegistry {
        eGCapacitorPlugin: eGCapacitorPluginPlugin;
    }
}
export interface eGCapacitorPluginPlugin {
    isEnabled(): Promise<{
        value: boolean;
    }>;
    getOSVersion(): Promise<{
        value: string;
    }>;
    getDevInfo(): Promise<{
        value: string;
    }>;
    getAppinfo(): Promise<{
        value: string;
    }>;
    getResInfo(): Promise<{
        value: string;
    }>;
    getCurrentActivityName(): Promise<{
        value: string;
    }>;
    getUserCountry(): Promise<{
        value: string;
    }>;
    getDeviceName(): Promise<{
        value: string;
    }>;
    getBaseOs(): Promise<{
        value: string;
    }>;
    getAppName(): Promise<{
        value: string;
    }>;
    start(options: {
        token: string;
        host: string;
        debug: number;
        ssl: boolean;
        unsigned: boolean;
    }): Promise<void>;
    postData(options: {
        data: String;
    }): Promise<void>;
    setUserName(options: {
        userName: string;
    }): Promise<void>;
    setAttribute(options: {
        key: string;
        value: string;
    }): Promise<void>;
    getUserInfo(): Promise<{
        value: string;
    }>;
}
