/*     */ package com.egurkha.jsp.indexer.parser;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.Reader;
/*     */ 
/*     */ 
/*     */ public final class JavaCharStream
/*     */ {
/*     */   public static final boolean staticFlag = false;
/*     */   
/*     */   static final int hexval(char c) throws IOException {
/*  14 */     switch (c) {
/*     */       
/*     */       case '0':
/*  17 */         return 0;
/*     */       case '1':
/*  19 */         return 1;
/*     */       case '2':
/*  21 */         return 2;
/*     */       case '3':
/*  23 */         return 3;
/*     */       case '4':
/*  25 */         return 4;
/*     */       case '5':
/*  27 */         return 5;
/*     */       case '6':
/*  29 */         return 6;
/*     */       case '7':
/*  31 */         return 7;
/*     */       case '8':
/*  33 */         return 8;
/*     */       case '9':
/*  35 */         return 9;
/*     */       
/*     */       case 'A':
/*     */       case 'a':
/*  39 */         return 10;
/*     */       case 'B':
/*     */       case 'b':
/*  42 */         return 11;
/*     */       case 'C':
/*     */       case 'c':
/*  45 */         return 12;
/*     */       case 'D':
/*     */       case 'd':
/*  48 */         return 13;
/*     */       case 'E':
/*     */       case 'e':
/*  51 */         return 14;
/*     */       case 'F':
/*     */       case 'f':
/*  54 */         return 15;
/*     */     } 
/*     */     
/*  57 */     throw new IOException();
/*     */   }
/*     */   
/*  60 */   public int bufpos = -1;
/*     */   
/*     */   public int bufsize;
/*     */   public int available;
/*     */   public int tokenBegin;
/*     */   private int[] bufline;
/*     */   private int[] bufcolumn;
/*  67 */   private int column = 0;
/*  68 */   private int line = 1;
/*     */   
/*     */   private boolean prevCharIsCR = false;
/*     */   
/*     */   private boolean prevCharIsLF = false;
/*     */   
/*     */   private Reader inputStream;
/*     */   private char[] nextCharBuf;
/*     */   private char[] buffer;
/*  77 */   private int maxNextCharInd = 0;
/*  78 */   private int nextCharInd = -1;
/*  79 */   private int inBuf = 0;
/*     */ 
/*     */   
/*     */   public JavaCharStream(InputStream dstream, int startline, int startcolumn, int buffersize) {
/*  83 */     this(new InputStreamReader(dstream), startline, startcolumn, buffersize);
/*     */   }
/*     */ 
/*     */   
/*     */   public JavaCharStream(Reader dstream, int startline, int startcolumn, int buffersize) {
/*  88 */     this.inputStream = dstream;
/*  89 */     this.line = startline;
/*  90 */     this.column = startcolumn - 1;
/*     */     
/*  92 */     this.available = this.bufsize = buffersize;
/*  93 */     this.buffer = new char[buffersize];
/*  94 */     this.bufline = new int[buffersize];
/*  95 */     this.bufcolumn = new int[buffersize];
/*  96 */     this.nextCharBuf = new char[4096];
/*     */   }
/*     */ 
/*     */   
/*     */   public JavaCharStream(Reader dstream, int startline, int startcolumn) {
/* 101 */     this(dstream, startline, startcolumn, 4096);
/*     */   }
/*     */ 
/*     */   
/*     */   public JavaCharStream(Reader dstream) {
/* 106 */     this(dstream, 1, 1, 4096);
/*     */   }
/*     */ 
/*     */   
/*     */   public JavaCharStream(InputStream dstream, int startline, int startcolumn) {
/* 111 */     this(dstream, startline, startcolumn, 4096);
/*     */   }
/*     */ 
/*     */   
/*     */   public JavaCharStream(InputStream dstream) {
/* 116 */     this(dstream, 1, 1, 4096);
/*     */   }
/*     */ 
/*     */   
/*     */   private final void expandBuffer(boolean wrapAround) {
/* 121 */     char[] newbuffer = new char[this.bufsize + 2048];
/* 122 */     int[] newbufline = new int[this.bufsize + 2048];
/* 123 */     int[] newbufcolumn = new int[this.bufsize + 2048];
/*     */ 
/*     */     
/*     */     try {
/* 127 */       if (wrapAround)
/*     */       {
/* 129 */         System.arraycopy(
/* 130 */             this.buffer, 
/* 131 */             this.tokenBegin, 
/* 132 */             newbuffer, 
/* 133 */             0, 
/* 134 */             this.bufsize - this.tokenBegin);
/* 135 */         System.arraycopy(
/* 136 */             this.buffer, 
/* 137 */             0, 
/* 138 */             newbuffer, 
/* 139 */             this.bufsize - this.tokenBegin, 
/* 140 */             this.bufpos);
/* 141 */         this.buffer = newbuffer;
/*     */         
/* 143 */         System.arraycopy(
/* 144 */             this.bufline, 
/* 145 */             this.tokenBegin, 
/* 146 */             newbufline, 
/* 147 */             0, 
/* 148 */             this.bufsize - this.tokenBegin);
/* 149 */         System.arraycopy(
/* 150 */             this.bufline, 
/* 151 */             0, 
/* 152 */             newbufline, 
/* 153 */             this.bufsize - this.tokenBegin, 
/* 154 */             this.bufpos);
/* 155 */         this.bufline = newbufline;
/*     */         
/* 157 */         System.arraycopy(
/* 158 */             this.bufcolumn, 
/* 159 */             this.tokenBegin, 
/* 160 */             newbufcolumn, 
/* 161 */             0, 
/* 162 */             this.bufsize - this.tokenBegin);
/* 163 */         System.arraycopy(
/* 164 */             this.bufcolumn, 
/* 165 */             0, 
/* 166 */             newbufcolumn, 
/* 167 */             this.bufsize - this.tokenBegin, 
/* 168 */             this.bufpos);
/* 169 */         this.bufcolumn = newbufcolumn;
/*     */         
/* 171 */         this.bufpos += this.bufsize - this.tokenBegin;
/*     */       }
/*     */       else
/*     */       {
/* 175 */         System.arraycopy(
/* 176 */             this.buffer, 
/* 177 */             this.tokenBegin, 
/* 178 */             newbuffer, 
/* 179 */             0, 
/* 180 */             this.bufsize - this.tokenBegin);
/* 181 */         this.buffer = newbuffer;
/*     */         
/* 183 */         System.arraycopy(
/* 184 */             this.bufline, 
/* 185 */             this.tokenBegin, 
/* 186 */             newbufline, 
/* 187 */             0, 
/* 188 */             this.bufsize - this.tokenBegin);
/* 189 */         this.bufline = newbufline;
/*     */         
/* 191 */         System.arraycopy(
/* 192 */             this.bufcolumn, 
/* 193 */             this.tokenBegin, 
/* 194 */             newbufcolumn, 
/* 195 */             0, 
/* 196 */             this.bufsize - this.tokenBegin);
/* 197 */         this.bufcolumn = newbufcolumn;
/*     */         
/* 199 */         this.bufpos -= this.tokenBegin;
/*     */       }
/*     */     
/* 202 */     } catch (Throwable t) {
/*     */       
/* 204 */       throw new Error(t.getMessage());
/*     */     } 
/*     */     
/* 207 */     this.available = this.bufsize += 2048;
/* 208 */     this.tokenBegin = 0;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   private final void fillBuffer() throws IOException {
/* 215 */     if (this.maxNextCharInd == 4096)
/*     */     {
/* 217 */       this.maxNextCharInd = this.nextCharInd = 0;
/*     */     }
/*     */     
/*     */     try {
/*     */       int i;
/* 222 */       if ((i = 
/* 223 */         this.inputStream.read(
/* 224 */           this.nextCharBuf, 
/* 225 */           this.maxNextCharInd, 
/* 226 */           4096 - this.maxNextCharInd)) == 
/* 227 */         -1) {
/*     */         
/* 229 */         this.inputStream.close();
/* 230 */         throw new IOException();
/*     */       } 
/*     */ 
/*     */       
/* 234 */       this.maxNextCharInd += i;
/*     */ 
/*     */ 
/*     */       
/*     */       return;
/* 239 */     } catch (IOException e) {
/*     */       
/* 241 */       if (this.bufpos != 0) {
/*     */         
/* 243 */         this.bufpos--;
/* 244 */         backup(0);
/*     */       }
/*     */       else {
/*     */         
/* 248 */         this.bufline[this.bufpos] = this.line;
/* 249 */         this.bufcolumn[this.bufpos] = this.column;
/*     */       } 
/* 251 */       throw e;
/*     */     } 
/*     */   }
/*     */ 
/*     */   
/*     */   private final char readByte() throws IOException {
/* 257 */     if (++this.nextCharInd >= this.maxNextCharInd) {
/* 258 */       fillBuffer();
/*     */     }
/* 260 */     return this.nextCharBuf[this.nextCharInd];
/*     */   }
/*     */ 
/*     */   
/*     */   public final char beginToken() throws IOException {
/* 265 */     if (this.inBuf > 0) {
/*     */       
/* 267 */       this.inBuf--;
/*     */       
/* 269 */       if (++this.bufpos == this.bufsize) {
/* 270 */         this.bufpos = 0;
/*     */       }
/* 272 */       this.tokenBegin = this.bufpos;
/* 273 */       return this.buffer[this.bufpos];
/*     */     } 
/*     */     
/* 276 */     this.tokenBegin = 0;
/* 277 */     this.bufpos = -1;
/*     */     
/* 279 */     return readChar();
/*     */   }
/*     */ 
/*     */   
/*     */   private final void adjustBufferSize() {
/* 284 */     if (this.available == this.bufsize) {
/*     */       
/* 286 */       if (this.tokenBegin > 2048)
/*     */       {
/* 288 */         this.bufpos = 0;
/* 289 */         this.available = this.tokenBegin;
/*     */       }
/*     */       else
/*     */       {
/* 293 */         expandBuffer(false);
/*     */       }
/*     */     
/* 296 */     } else if (this.available > this.tokenBegin) {
/*     */       
/* 298 */       this.available = this.bufsize;
/*     */     }
/* 300 */     else if (this.tokenBegin - this.available < 2048) {
/*     */       
/* 302 */       expandBuffer(true);
/*     */     }
/*     */     else {
/*     */       
/* 306 */       this.available = this.tokenBegin;
/*     */     } 
/*     */   }
/*     */ 
/*     */   
/*     */   private final void updateLineColumn(char c) {
/* 312 */     this.column++;
/*     */     
/* 314 */     if (this.prevCharIsLF) {
/*     */       
/* 316 */       this.prevCharIsLF = false;
/* 317 */       this.line += this.column = 1;
/*     */     }
/* 319 */     else if (this.prevCharIsCR) {
/*     */       
/* 321 */       this.prevCharIsCR = false;
/* 322 */       if (c == '\n') {
/*     */         
/* 324 */         this.prevCharIsLF = true;
/*     */       } else {
/*     */         
/* 327 */         this.line += this.column = 1;
/*     */       } 
/*     */     } 
/* 330 */     switch (c) {
/*     */       
/*     */       case '\r':
/* 333 */         this.prevCharIsCR = true;
/*     */         break;
/*     */       case '\n':
/* 336 */         this.prevCharIsLF = true;
/*     */         break;
/*     */       case '\t':
/* 339 */         this.column--;
/* 340 */         this.column += 8 - (this.column & 0x7);
/*     */         break;
/*     */     } 
/*     */ 
/*     */ 
/*     */     
/* 346 */     this.bufline[this.bufpos] = this.line;
/* 347 */     this.bufcolumn[this.bufpos] = this.column;
/*     */   }
/*     */   
/*     */   public final char readChar() throws IOException {
/*     */     int backSlashCnt;
/* 352 */     if (this.inBuf > 0) {
/*     */       
/* 354 */       this.inBuf--;
/*     */       
/* 356 */       if (++this.bufpos == this.bufsize) {
/* 357 */         this.bufpos = 0;
/*     */       }
/* 359 */       return this.buffer[this.bufpos];
/*     */     } 
/*     */ 
/*     */ 
/*     */     
/* 364 */     if (++this.bufpos == this.available) {
/* 365 */       adjustBufferSize();
/*     */     }
/* 367 */     char c = readByte(); if ((c = readByte()) == '\\') {
/*     */       
/* 369 */       updateLineColumn(c);
/*     */       
/* 371 */       backSlashCnt = 1;
/*     */ 
/*     */       
/*     */       while (true) {
/* 375 */         if (++this.bufpos == this.available) {
/* 376 */           adjustBufferSize();
/*     */         }
/*     */         
/*     */         try {
/* 380 */           this.buffer[this.bufpos] = c = readByte(); if ((c = readByte()) != '\\')
/*     */           {
/* 382 */             updateLineColumn(c);
/*     */             
/* 384 */             if (c == 'u' && (backSlashCnt & 0x1) == 1) {
/*     */               
/* 386 */               if (--this.bufpos < 0) {
/* 387 */                 this.bufpos = this.bufsize - 1;
/*     */               }
/*     */               
/*     */               break;
/*     */             } 
/* 392 */             backup(backSlashCnt);
/* 393 */             return '\\';
/*     */           }
/*     */         
/* 396 */         } catch (IOException e) {
/*     */           
/* 398 */           if (backSlashCnt > 1) {
/* 399 */             backup(backSlashCnt);
/*     */           }
/* 401 */           return '\\';
/*     */         } 
/*     */         
/* 404 */         updateLineColumn(c);
/* 405 */         backSlashCnt++;
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */       
/*     */       }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */     
/*     */     }
/*     */     else {
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */       
/* 443 */       updateLineColumn(c);
/* 444 */       return c;
/*     */     } 
/*     */     while ((c = readByte()) == 'u')
/*     */       this.column++; 
/*     */     this.buffer[this.bufpos] = c = (char)(hexval(c) << 12 | hexval(readByte()) << 8 | hexval(readByte()) << 4 | hexval(readByte()));
/*     */     this.column += 4;
/*     */     if (backSlashCnt == 1)
/*     */       return c; 
/*     */     backup(backSlashCnt - 1);
/*     */     return '\\';
/*     */   } public final int getColumn() {
/* 455 */     return this.bufcolumn[this.bufpos];
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public final int getLine() {
/* 465 */     return this.bufline[this.bufpos];
/*     */   }
/*     */ 
/*     */   
/*     */   public final int getEndColumn() {
/* 470 */     return this.bufcolumn[this.bufpos];
/*     */   }
/*     */ 
/*     */   
/*     */   public final int getEndLine() {
/* 475 */     return this.bufline[this.bufpos];
/*     */   }
/*     */ 
/*     */   
/*     */   public final int getBeginColumn() {
/* 480 */     return this.bufcolumn[this.tokenBegin];
/*     */   }
/*     */ 
/*     */   
/*     */   public final int getBeginLine() {
/* 485 */     return this.bufline[this.tokenBegin];
/*     */   }
/*     */ 
/*     */   
/*     */   public final void backup(int amount) {
/* 490 */     this.inBuf += amount;
/* 491 */     if ((this.bufpos -= amount) < 0)
/*     */     {
/* 493 */       this.bufpos += this.bufsize;
/*     */     }
/*     */   }
/*     */ 
/*     */   
/*     */   public void ReInit(Reader dstream, int startline, int startcolumn, int buffersize) {
/* 499 */     this.inputStream = dstream;
/* 500 */     this.line = startline;
/* 501 */     this.column = startcolumn - 1;
/*     */     
/* 503 */     if (this.buffer == null || buffersize != this.buffer.length) {
/*     */       
/* 505 */       this.available = this.bufsize = buffersize;
/* 506 */       this.buffer = new char[buffersize];
/* 507 */       this.bufline = new int[buffersize];
/* 508 */       this.bufcolumn = new int[buffersize];
/* 509 */       this.nextCharBuf = new char[4096];
/*     */     } 
/* 511 */     this.prevCharIsLF = this.prevCharIsCR = false;
/* 512 */     this.tokenBegin = this.inBuf = this.maxNextCharInd = 0;
/* 513 */     this.nextCharInd = this.bufpos = -1;
/*     */   }
/*     */ 
/*     */   
/*     */   public void ReInit(Reader dstream, int startline, int startcolumn) {
/* 518 */     ReInit(dstream, startline, startcolumn, 4096);
/*     */   }
/*     */ 
/*     */   
/*     */   public void ReInit(Reader dstream) {
/* 523 */     ReInit(dstream, 1, 1, 4096);
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public void reInit(InputStream dstream, int startline, int startcolumn, int buffersize) {
/* 529 */     ReInit(new InputStreamReader(dstream), startline, startcolumn, buffersize);
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public void reInit(InputStream dstream, int startline, int startcolumn) {
/* 535 */     reInit(dstream, startline, startcolumn, 4096);
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public void reInit(InputStream dstream) {
/* 541 */     reInit(dstream, 1, 1, 4096);
/*     */   }
/*     */ 
/*     */   
/*     */   public final String getImage() {
/* 546 */     if (this.bufpos >= this.tokenBegin)
/*     */     {
/* 548 */       return new String(this.buffer, this.tokenBegin, this.bufpos - this.tokenBegin + 1);
/*     */     }
/*     */ 
/*     */     
/* 552 */     return String.valueOf(new String(this.buffer, this.tokenBegin, this.bufsize - this.tokenBegin)) + 
/* 553 */       new String(this.buffer, 0, this.bufpos + 1);
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public final char[] getSuffix(int len) {
/* 559 */     char[] ret = new char[len];
/*     */     
/* 561 */     if (this.bufpos + 1 >= len) {
/* 562 */       System.arraycopy(this.buffer, this.bufpos - len + 1, ret, 0, len);
/*     */     } else {
/*     */       
/* 565 */       System.arraycopy(
/* 566 */           this.buffer, 
/* 567 */           this.bufsize - len - this.bufpos - 1, 
/* 568 */           ret, 
/* 569 */           0, 
/* 570 */           len - this.bufpos - 1);
/* 571 */       System.arraycopy(this.buffer, 0, ret, len - this.bufpos - 1, this.bufpos + 1);
/*     */     } 
/*     */     
/* 574 */     return ret;
/*     */   }
/*     */ 
/*     */ 
/*     */   
/*     */   public void done() {
/* 580 */     this.nextCharBuf = null;
/* 581 */     this.buffer = null;
/* 582 */     this.bufline = null;
/* 583 */     this.bufcolumn = null;
/*     */   }
/*     */ 
/*     */ 
/*     */ 
/*     */ 
/*     */   
/*     */   public void adjustBeginLineColumn(int newLine, int newCol) {
/* 591 */     int len, start = this.tokenBegin;
/*     */ 
/*     */     
/* 594 */     if (this.bufpos >= this.tokenBegin) {
/*     */       
/* 596 */       len = this.bufpos - this.tokenBegin + this.inBuf + 1;
/*     */     }
/*     */     else {
/*     */       
/* 600 */       len = this.bufsize - this.tokenBegin + this.bufpos + 1 + this.inBuf;
/*     */     } 
/*     */     
/* 603 */     int i = 0, j = 0, k = 0;
/* 604 */     int nextColDiff = 0, columnDiff = 0;
/*     */     
/* 606 */     while (i < len) { if (this.bufline[j = 
/* 607 */           start % this.bufsize] != this.bufline[k = ++start % this.bufsize])
/*     */         break; 
/* 609 */       this.bufline[j] = newLine;
/* 610 */       nextColDiff = columnDiff + this.bufcolumn[k] - this.bufcolumn[j];
/* 611 */       this.bufcolumn[j] = newCol + columnDiff;
/* 612 */       columnDiff = nextColDiff;
/* 613 */       i++; }
/*     */ 
/*     */     
/* 616 */     if (i < len) {
/*     */       
/* 618 */       this.bufline[j] = newLine++;
/* 619 */       this.bufcolumn[j] = newCol + columnDiff;
/*     */       
/* 621 */       while (i++ < len) {
/*     */         
/* 623 */         if (this.bufline[j = start % this.bufsize] != this.bufline[++start % this.bufsize]) {
/* 624 */           this.bufline[j] = newLine++; continue;
/*     */         } 
/* 626 */         this.bufline[j] = newLine;
/*     */       } 
/*     */     } 
/*     */     
/* 630 */     this.line = this.bufline[j];
/* 631 */     this.column = this.bufcolumn[j];
/*     */   }
/*     */ }


/* Location:              C:\Users\dhanabal\Desktop\Index\!\com\egurkha\jsp\indexer\parser\JavaCharStream.class
 * Java compiler version: 1 (45.3)
 * JD-Core Version:       1.1.3
 */