'---------------------------------------------------------------------------------------------------
' This function searches a computer for a specified Web Site, and
' displays information about the site.
'
' findweb [--computer|-c COMPUTER]
'         <--website|-w WEBSITE>
'         [--help|-?]
'
'COMPUTER                Computer on which users exists
'WEBSITE1,WEBSITE2       Virtual Web Sites on which directories will be created
'NAME1,PATH1,NAME2,PATH2 Virtual Directories names and paths to create
'
'Example 1		mkwebdir -c MyComputer -w "Default Web Site","Another Web Site"
'                       -v "Virtual Dir1","c:\inetpub\wwwroot\dir1","Virtual Dir2","c:\inetpub\wwwroot\dir2"
'
'---------------------------------------------------------------------------------------------------

' Force explicit declaration of all variables.
Option Explicit

On Error Resume Next

Dim oArgs, ArgNum

Dim ArgComputer, ArgWebSites, ArgVirtualDirs, ArgDirNames(), ArgDirPaths(), DirIndex
Dim ArgComputers, fileName

Set oArgs = WScript.Arguments
ArgComputers = Array("LocalHost")
ArgWebSites = "1"
ArgNum = 0
fileName=oArgs(2)

While ArgNum < oArgs.Count
	Select Case LCase(oArgs(ArgNum))
		Case "--computer","-c":
			ArgNum = ArgNum + 1
			If (ArgNum >= oArgs.Count) Then
				Call DisplayUsage
			End If	
			ArgComputers = Split(oArgs(ArgNum), ",", -1)
		Case "--website","-w":
			ArgNum = ArgNum + 1
			If (ArgNum >= oArgs.Count) Then
				Call DisplayUsage
			End If	
			ArgWebSites = oArgs(ArgNum)
		Case "--virtualdir","-v":
			ArgNum = ArgNum + 1
			If (ArgNum >= oArgs.Count) Then
				Call DisplayUsage
			End If	
			ArgVirtualDirs = Split(oArgs(ArgNum), ",", -1)
		Case "-f":
			ArgNum = ArgNum + 1
			If (ArgNum >= oArgs.Count) Then
				Call DisplayUsage
			End If	
			fileName = Split(oArgs(ArgNum), ",", -1)	
		Case "--help","-?"
			Call DisplayUsage
		Case Else:
			ArgWebSites = oArgs(ArgNum)
	End Select	

	ArgNum = ArgNum + 1
Wend

Dim foundSite
Dim compIndex
Dim bindInfo
Dim aBinding, binding
Dim objFileSystem, objOutputFile
Dim strOutputFile
Dim objFile, objInputFile
Dim strInputFile, inputData, strData
Const OPEN_FILE_FOR_READING = 1
set foundSite = findWeb(ArgComputers(0), ArgWebSites)
'Trace "Inside "&ArgComputers(0)
fileName=oArgs(2)
'Trace "FILENAME "&fileName

	strOutputFile = fileName
	Set objFileSystem = CreateObject("Scripting.fileSystemObject")
	Set objOutputFile = objFileSystem.CreateTextFile(strOutputFile, TRUE)
	objOutputFile.WriteLine(Trim(foundSite.Name))
	objOutputFile.Close
	Set objFileSystem = Nothing
	'WScript.Quit(0)
	
	strOutputFile = fileName
	
	Set objFile = CreateObject("Scripting.fileSystemObject")
	Set objInputFile = objFile.OpenTextFile(strOutputFile, OPEN_FILE_FOR_READING)
	
	' read everything in an array
	inputData = Split(objInputFile.ReadAll, vbNewline)
	
	For each strData In inputData
	    'WScript.Echo strData
	Next
	
	objInputFile.Close
	Set objFile = Nothing
	WScript.Echo "Found website number"
	WScript.Quit(0)
	 
	

	
for compIndex = 0 to UBound(ArgComputers)
	set foundSite = findWeb(ArgComputers(compIndex), ArgWebSites)
	if isObject(foundSite) then
	'Trace foundSite.Name 
	'Trace "  Web Site Number = "&foundSite.Name
	'Trace "  Web Site Description = "&foundSite.ServerComment
		aBinding=foundSite.ServerBindings
		if (IsArray(aBinding)) then
			if aBinding(0) = "" then
				binding = Null
			else
				binding = getBinding(aBinding(0))
			end if
		else 
			if aBinding = "" then
				binding = Null
			else
				binding = getBinding(aBinding)
			end if
		end if
		if (IsArray(binding)) then
			'Trace "    Hostname = "&binding(2)
			'Trace "    Port = "&binding(1)
			'Trace "    IP Address = "&binding(2)
		end if
	else
		Trace "No matching web found."
	end if
next

function getBinding(bindstr)

	Dim one, two, ia, ip, hn
	
	one=Instr(bindstr,":")
	two=Instr((one+1),bindstr,":")
	
	ia=Mid(bindstr,1,(one-1))
	ip=Mid(bindstr,(one+1),((two-one)-1))
	hn=Mid(bindstr,(two+1))
	
	getBinding=Array(ia,ip,hn)
end function

Function findWeb(computer, webname)
	On Error Resume Next

	Dim websvc, site
	dim webinfo
	Dim aBinding, binding

	set websvc = GetObject("IIS://"&computer&"/W3svc")
	if (Err <> 0) then
		exit function
	end if
	' First try to open the webname.
	set site = websvc.GetObject("IIsWebServer", webname)
	if (Err = 0) and (not isNull(site)) then
		if (site.class = "IIsWebServer") then
			' Here we found a site that is a web server.
			set findWeb = site
			exit function
		end if
	end if
	err.clear
	for each site in websvc
		if site.class = "IIsWebServer" then
			'
			' First, check to see if the ServerComment
			' matches
			'
			If site.ServerComment = webname Then
				set findWeb = site
				exit function
			End If
			aBinding=site.ServerBindings
			if (IsArray(aBinding)) then
				if aBinding(0) = "" then
					binding = Null
				else
					binding = getBinding(aBinding(0))
				end if
			else 
				if aBinding = "" then
					binding = Null
				else
					binding = getBinding(aBinding)
				end if
			end if
			if IsArray(binding) then
				if (binding(2) = webname) or (binding(0) = webname) then
					set findWeb = site
					exit function
				End If
			end if 
		end if
	next
End Function

'---------------------------------------------------------------------------------
Sub Display(Msg)
	WScript.Echo Now & ". Error Code: " & Hex(Err) & " - " & Msg
End Sub

Sub Trace(Msg)
	WScript.Echo Msg	
End Sub

Sub DisplayUsage()
	WScript.Echo " findweb [--computer|-c COMPUTER]"
	WScript.Echo "         [WEBSITE] -f file name"
	WScript.Echo "         [--help|-?]"
	WScript.Echo ""
	WScript.Echo "Finds the named web on the specified computer."
	WScript.Echo "Displays the site number, description, host name, port,"
	WScript.Echo "and IP Address"
	WScript.Echo ""
	WScript.Echo "Note, WEBSITE is the Web Site on which the directory will be created."
	WScript.Echo "The name can be specified as one of the following, in the priority specified:"
	WScript.Echo " Server Number (i.e. 1, 2, 10, etc.)"
	WScript.Echo " Server Description (i.e ""My Server"")"
	WScript.Echo " Server Host name (i.e. ""www.domain.com"")"
	WScript.Echo " IP Address (i.e., 127.0.0.1)"
	WScript.Echo ""
	WScript.Echo "Example findweb -c MACHINE www.mycompany.com -f filename"
	WScript.Quit
End Sub
'---------------------------------------------------------------------------------

'' SIG '' Begin signature block
'' SIG '' MIIlSgYJKoZIhvcNAQcCoIIlOzCCJTcCAQExCzAJBgUr
'' SIG '' DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
'' SIG '' gjcCAR4wJAIBAQQQTvApFpkntU2P5azhDxfrqwIBAAIB
'' SIG '' AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFKI3IdrqoBWY
'' SIG '' XPSsR4mjodmNnQmcoIIecjCCBTAwggQYoAMCAQICEAQJ
'' SIG '' GBtf1btmdVNDtW+VUAgwDQYJKoZIhvcNAQELBQAwZTEL
'' SIG '' MAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IElu
'' SIG '' YzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEkMCIG
'' SIG '' A1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENB
'' SIG '' MB4XDTEzMTAyMjEyMDAwMFoXDTI4MTAyMjEyMDAwMFow
'' SIG '' cjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0
'' SIG '' IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEx
'' SIG '' MC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElE
'' SIG '' IENvZGUgU2lnbmluZyBDQTCCASIwDQYJKoZIhvcNAQEB
'' SIG '' BQADggEPADCCAQoCggEBAPjTsxx/DhGvZ3cH0wsxSRnP
'' SIG '' 0PtFmbE620T1f+Wondsy13Hqdp0FLreP+pJDwKX5idQ3
'' SIG '' Gde2qvCchqXYJawOeSg6funRZ9PG+yknx9N7I5TkkSOW
'' SIG '' kHeC+aGEI2YSVDNQdLEoJrskacLCUvIUZ4qJRdQtoaPp
'' SIG '' iCwgla4cSocI3wz14k1gGL6qxLKucDFmM3E+rHCiq85/
'' SIG '' 6XzLkqHlOzEcz+ryCuRXu0q16XTmK/5sy350OTYNkO/k
'' SIG '' tU6kqepqCquE86xnTrXE94zRICUj6whkPlKWwfIPEvTF
'' SIG '' jg/BougsUfdzvL2FsWKDc0GCB+Q4i2pzINAPZHM8np+m
'' SIG '' M6n9Gd8lk9ECAwEAAaOCAc0wggHJMBIGA1UdEwEB/wQI
'' SIG '' MAYBAf8CAQAwDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQM
'' SIG '' MAoGCCsGAQUFBwMDMHkGCCsGAQUFBwEBBG0wazAkBggr
'' SIG '' BgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
'' SIG '' MEMGCCsGAQUFBzAChjdodHRwOi8vY2FjZXJ0cy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
'' SIG '' Y3J0MIGBBgNVHR8EejB4MDqgOKA2hjRodHRwOi8vY3Js
'' SIG '' NC5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURS
'' SIG '' b290Q0EuY3JsMDqgOKA2hjRodHRwOi8vY3JsMy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
'' SIG '' Y3JsME8GA1UdIARIMEYwOAYKYIZIAYb9bAACBDAqMCgG
'' SIG '' CCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdpY2VydC5j
'' SIG '' b20vQ1BTMAoGCGCGSAGG/WwDMB0GA1UdDgQWBBRaxLl7
'' SIG '' KgqjpepxA8Bg+S32ZXUOWDAfBgNVHSMEGDAWgBRF66Kv
'' SIG '' 9JLLgjEtUYunpyGd823IDzANBgkqhkiG9w0BAQsFAAOC
'' SIG '' AQEAPuwNWiSz8yLRFcgsfCUpdqgdXRwtOhrE7zBh134L
'' SIG '' YP3DPQ/Er4v97yrfIFU3sOH20ZJ1D1G0bqWOWuJeJIFO
'' SIG '' EKTuP3GOYw4TS63XX0R58zYUBor3nEZOXP+QsRsHDpEV
'' SIG '' +7qvtVHCjSSuJMbHJyqhKSgaOnEoAjwukaPAJRHinBRH
'' SIG '' oXpoaK+bp1wgXNlxsQyPu6j4xRJon89Ay0BEpRPw5mQM
'' SIG '' JQhCMrI2iiQC/i9yfhzXSUWW6Fkd6fp0ZGuy62ZD2rOw
'' SIG '' jNXpDd32ASDOmTFjPQgaGLOBm0/GkxAG/AeB+ova+YJJ
'' SIG '' 92JuoVP6EpQYhS6SkepobEQysmah5xikmmRR7zCCBY0w
'' SIG '' ggR1oAMCAQICEA6bGI750C3n79tQ4ghAGFowDQYJKoZI
'' SIG '' hvcNAQEMBQAwZTELMAkGA1UEBhMCVVMxFTATBgNVBAoT
'' SIG '' DERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
'' SIG '' ZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJl
'' SIG '' ZCBJRCBSb290IENBMB4XDTIyMDgwMTAwMDAwMFoXDTMx
'' SIG '' MTEwOTIzNTk1OVowYjELMAkGA1UEBhMCVVMxFTATBgNV
'' SIG '' BAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRp
'' SIG '' Z2ljZXJ0LmNvbTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1
'' SIG '' c3RlZCBSb290IEc0MIICIjANBgkqhkiG9w0BAQEFAAOC
'' SIG '' Ag8AMIICCgKCAgEAv+aQc2jeu+RdSjwwIjBpM+zCpyUu
'' SIG '' ySE98orYWcLhKac9WKt2ms2uexuEDcQwH/MbpDgW61bG
'' SIG '' l20dq7J58soR0uRf1gU8Ug9SH8aeFaV+vp+pVxZZVXKv
'' SIG '' aJNwwrK6dZlqczKU0RBEEC7fgvMHhOZ0O21x4i0MG+4g
'' SIG '' 1ckgHWMpLc7sXk7Ik/ghYZs06wXGXuxbGrzryc/NrDRA
'' SIG '' X7F6Zu53yEioZldXn1RYjgwrt0+nMNlW7sp7XeOtyU9e
'' SIG '' 5TXnMcvak17cjo+A2raRmECQecN4x7axxLVqGDgDEI3Y
'' SIG '' 1DekLgV9iPWCPhCRcKtVgkEy19sEcypukQF8IUzUvK4b
'' SIG '' A3VdeGbZOjFEmjNAvwjXWkmkwuapoGfdpCe8oU85tRFY
'' SIG '' F/ckXEaPZPfBaYh2mHY9WV1CdoeJl2l6SPDgohIbZpp0
'' SIG '' yt5LHucOY67m1O+SkjqePdwA5EUlibaaRBkrfsCUtNJh
'' SIG '' besz2cXfSwQAzH0clcOP9yGyshG3u3/y1YxwLEFgqrFj
'' SIG '' GESVGnZifvaAsPvoZKYz0YkH4b235kOkGLimdwHhD5QM
'' SIG '' IR2yVCkliWzlDlJRR3S+Jqy2QXXeeqxfjT/JvNNBERJb
'' SIG '' 5RBQ6zHFynIWIgnffEx1P2PsIV/EIFFrb7GrhotPwtZF
'' SIG '' X50g/KEexcCPorF+CiaZ9eRpL5gdLfXZqbId5RsCAwEA
'' SIG '' AaOCATowggE2MA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0O
'' SIG '' BBYEFOzX44LScV1kTN8uZz/nupiuHA9PMB8GA1UdIwQY
'' SIG '' MBaAFEXroq/0ksuCMS1Ri6enIZ3zbcgPMA4GA1UdDwEB
'' SIG '' /wQEAwIBhjB5BggrBgEFBQcBAQRtMGswJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggr
'' SIG '' BgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDBF
'' SIG '' BgNVHR8EPjA8MDqgOKA2hjRodHRwOi8vY3JsMy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
'' SIG '' Y3JsMBEGA1UdIAQKMAgwBgYEVR0gADANBgkqhkiG9w0B
'' SIG '' AQwFAAOCAQEAcKC/Q1xV5zhfoKN0Gz22Ftf3v1cHvZqs
'' SIG '' oYcs7IVeqRq7IviHGmlUIu2kiHdtvRoU9BNKei8ttzjv
'' SIG '' 9P+Aufih9/Jy3iS8UgPITtAq3votVs/59PesMHqai7Je
'' SIG '' 1M/RQ0SbQyHrlnKhSLSZy51PpwYDE3cnRNTnf+hZqPC/
'' SIG '' Lwum6fI0POz3A8eHqNJMQBk1RmppVLC4oVaO7KTVPeix
'' SIG '' 3P0c2PR3WlxUjG/voVA9/HYJaISfb8rbII01YBwCA8sg
'' SIG '' sKxYoA5AY8WYIsGyWfVVa88nq2x2zm8jLfR+cWojayL/
'' SIG '' ErhULSd+2DrZ8LaHlv1b0VysGMNNn3O3AamfV6peKOK5
'' SIG '' lDCCBjMwggUboAMCAQICEAiadJ64LcPsJ+pl6tv4NTEw
'' SIG '' DQYJKoZIhvcNAQELBQAwcjELMAkGA1UEBhMCVVMxFTAT
'' SIG '' BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
'' SIG '' LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQg
'' SIG '' U0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBDQTAe
'' SIG '' Fw0yMTA1MjUwMDAwMDBaFw0yNDA1MjkyMzU5NTlaMHEx
'' SIG '' CzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpOZXcgSmVyc2V5
'' SIG '' MQ8wDQYDVQQHEwZJc2VsaW4xHTAbBgNVBAoTFGVHIElu
'' SIG '' bm92YXRpb25zLCBJbmMuMR0wGwYDVQQDExRlRyBJbm5v
'' SIG '' dmF0aW9ucywgSW5jLjCCAiIwDQYJKoZIhvcNAQEBBQAD
'' SIG '' ggIPADCCAgoCggIBAMRlCdKa4238XJoGRo3eyQ8TrO7M
'' SIG '' kh72kN8Bkdimw92mWoHkhPpBtLSpBLEOJ2vG5zVYmP8x
'' SIG '' eD26NGZGLTMySJNAGVw0zL16/5hL5isQm4iRUwqSpJme
'' SIG '' LGuQWXzu4oCL3DUmtMyCNmuY4kCRcvOY/n/SOBIE6PTn
'' SIG '' HVXiDV4YENsWek4xCvqW4aplV76/AwduiXJTmnndC+Vb
'' SIG '' O/gmxs2bion4MS9ovHeRQ85IWUmX3QrRrRLxOaS3rF0l
'' SIG '' n6c1HXbwjUYrCDxge5oPkZZ9l71GcsmkVEbZcddaWHyf
'' SIG '' yjWAJFAi9t654d/P5msbUr3XoqGAY+MS8re6aEARvm9L
'' SIG '' swo4EQA3t/5NDbYlcCSKNGRLFMgwDaeySCIzHj87DjGM
'' SIG '' 3zD8ovHJQMHwWHNl4UrlHF98in+JKURZgpWHyuS7LRkE
'' SIG '' TWzjY6bAgUxIGbsBH5HTlNK5mjMsGRVSxxKZqWGXj8+z
'' SIG '' N1YTfmleepEf3n6PHg/NROVQ0KpiYhliqv7PY4W5GB+4
'' SIG '' NroS9jF2/7kbIVQ0jpBUbyCA/5fsgyaIAwaWnt8dqL+W
'' SIG '' L42PGaPERdLV78ktK37A7wDWcO5qbcx59AZZsOZboNxd
'' SIG '' glSaTW829R5gB+pNMhR5lmAqFADWwQdGEf5OCb4GNm8r
'' SIG '' bRe3EDycpe1CPQruCkwIO0TphpMHS4Zl6DwgXKNBAgMB
'' SIG '' AAGjggHEMIIBwDAfBgNVHSMEGDAWgBRaxLl7Kgqjpepx
'' SIG '' A8Bg+S32ZXUOWDAdBgNVHQ4EFgQU+chEms/YE0kvGgTW
'' SIG '' ta9+DDAONkowDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQM
'' SIG '' MAoGCCsGAQUFBwMDMHcGA1UdHwRwMG4wNaAzoDGGL2h0
'' SIG '' dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
'' SIG '' ZWQtY3MtZzEuY3JsMDWgM6Axhi9odHRwOi8vY3JsNC5k
'' SIG '' aWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcxLmNy
'' SIG '' bDBLBgNVHSAERDBCMDYGCWCGSAGG/WwDATApMCcGCCsG
'' SIG '' AQUFBwIBFhtodHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9D
'' SIG '' UFMwCAYGZ4EMAQQBMIGEBggrBgEFBQcBAQR4MHYwJAYI
'' SIG '' KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNv
'' SIG '' bTBOBggrBgEFBQcwAoZCaHR0cDovL2NhY2VydHMuZGln
'' SIG '' aWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3VyZWRJRENv
'' SIG '' ZGVTaWduaW5nQ0EuY3J0MAwGA1UdEwEB/wQCMAAwDQYJ
'' SIG '' KoZIhvcNAQELBQADggEBAJQI53BT7yyssE/+AxAhu2x2
'' SIG '' 7YlZfrrpn0Y9mKxbgobIJL9T5kKYH8qcQt4PhK1fckVf
'' SIG '' Pl10gsDmiid7+kS536YS4RMGHNvtELPzZYm+TQMQxriH
'' SIG '' MwCHlznOZEUabxbENl0jbTO1y9bSw5uqf1RuwaFAMqkV
'' SIG '' 7DD3Vm05Df/Z3QphkrKnMYxtrnfDulYbXvSeS2hwVZN5
'' SIG '' SGQDLR+gAnaOUE6zOPZ2yFPEBrkWDV2SkSwFLuiIA+li
'' SIG '' SjFX2V1pcnw/HWdq93o+kNbgDvzW7Xd/e0/gVUKw1jDh
'' SIG '' vPhnkYicKHr8WyFodEnp2TlKwKvb0yWkrxTEr3LZCZv6
'' SIG '' MS1HFHRBkt8wggauMIIElqADAgECAhAHNje3JFR82Ees
'' SIG '' /ShmKl5bMA0GCSqGSIb3DQEBCwUAMGIxCzAJBgNVBAYT
'' SIG '' AlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNV
'' SIG '' BAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERp
'' SIG '' Z2lDZXJ0IFRydXN0ZWQgUm9vdCBHNDAeFw0yMjAzMjMw
'' SIG '' MDAwMDBaFw0zNzAzMjIyMzU5NTlaMGMxCzAJBgNVBAYT
'' SIG '' AlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7MDkG
'' SIG '' A1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
'' SIG '' IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwggIiMA0GCSqG
'' SIG '' SIb3DQEBAQUAA4ICDwAwggIKAoICAQDGhjUGSbPBPXJJ
'' SIG '' UVXHJQPE8pE3qZdRodbSg9GeTKJtoLDMg/la9hGhRBVC
'' SIG '' X6SI82j6ffOciQt/nR+eDzMfUBMLJnOWbfhXqAJ9/UO0
'' SIG '' hNoR8XOxs+4rgISKIhjf69o9xBd/qxkrPkLcZ47qUT3w
'' SIG '' 1lbU5ygt69OxtXXnHwZljZQp09nsad/ZkIdGAHvbREGJ
'' SIG '' 3HxqV3rwN3mfXazL6IRktFLydkf3YYMZ3V+0VAshaG43
'' SIG '' IbtArF+y3kp9zvU5EmfvDqVjbOSmxR3NNg1c1eYbqMFk
'' SIG '' dECnwHLFuk4fsbVYTXn+149zk6wsOeKlSNbwsDETqVcp
'' SIG '' licu9Yemj052FVUmcJgmf6AaRyBD40NjgHt1biclkJg6
'' SIG '' OBGz9vae5jtb7IHeIhTZgirHkr+g3uM+onP65x9abJTy
'' SIG '' UpURK1h0QCirc0PO30qhHGs4xSnzyqqWc0Jon7ZGs506
'' SIG '' o9UD4L/wojzKQtwYSH8UNM/STKvvmz3+DrhkKvp1KCRB
'' SIG '' 7UK/BZxmSVJQ9FHzNklNiyDSLFc1eSuo80VgvCONWPfc
'' SIG '' Yd6T/jnA+bIwpUzX6ZhKWD7TA4j+s4/TXkt2ElGTyYwM
'' SIG '' O1uKIqjBJgj5FBASA31fI7tk42PgpuE+9sJ0sj8eCXbs
'' SIG '' q11GdeJgo1gJASgADoRU7s7pXcheMBK9Rp6103a50g5r
'' SIG '' mQzSM7TNsQIDAQABo4IBXTCCAVkwEgYDVR0TAQH/BAgw
'' SIG '' BgEB/wIBADAdBgNVHQ4EFgQUuhbZbU2FL3MpdpovdYxq
'' SIG '' II+eyG8wHwYDVR0jBBgwFoAU7NfjgtJxXWRM3y5nP+e6
'' SIG '' mK4cD08wDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoG
'' SIG '' CCsGAQUFBwMIMHcGCCsGAQUFBwEBBGswaTAkBggrBgEF
'' SIG '' BQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEEG
'' SIG '' CCsGAQUFBzAChjVodHRwOi8vY2FjZXJ0cy5kaWdpY2Vy
'' SIG '' dC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNydDBD
'' SIG '' BgNVHR8EPDA6MDigNqA0hjJodHRwOi8vY3JsMy5kaWdp
'' SIG '' Y2VydC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNy
'' SIG '' bDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1s
'' SIG '' BwEwDQYJKoZIhvcNAQELBQADggIBAH1ZjsCTtm+YqUQi
'' SIG '' AX5m1tghQuGwGC4QTRPPMFPOvxj7x1Bd4ksp+3CKDaop
'' SIG '' afxpwc8dB+k+YMjYC+VcW9dth/qEICU0MWfNthKWb8RQ
'' SIG '' TGIdDAiCqBa9qVbPFXONASIlzpVpP0d3+3J0FNf/q0+K
'' SIG '' LHqrhc1DX+1gtqpPkWaeLJ7giqzl/Yy8ZCaHbJK9nXzQ
'' SIG '' cAp876i8dU+6WvepELJd6f8oVInw1YpxdmXazPByoyP6
'' SIG '' wCeCRK6ZJxurJB4mwbfeKuv2nrF5mYGjVoarCkXJ38SN
'' SIG '' oOeY+/umnXKvxMfBwWpx2cYTgAnEtp/Nh4cku0+jSbl3
'' SIG '' ZpHxcpzpSwJSpzd+k1OsOx0ISQ+UzTl63f8lY5knLD0/
'' SIG '' a6fxZsNBzU+2QJshIUDQtxMkzdwdeDrknq3lNHGS1yZr
'' SIG '' 5Dhzq6YBT70/O3itTK37xJV77QpfMzmHQXh6OOmc4d0j
'' SIG '' /R0o08f56PGYX/sr2H7yRp11LB4nLCbbbxV7HhmLNriT
'' SIG '' 1ObyF5lZynDwN7+YAN8gFk8n+2BnFqFmut1VwDophrCY
'' SIG '' oCvtlUG3OtUVmDG0YgkPCr2B2RP+v6TR81fZvAT6gt4y
'' SIG '' 3wSJ8ADNXcL50CN/AAvkdgIm2fBldkKmKYcJRyvmfxqk
'' SIG '' hQ/8mJb2VVQrH4D6wPIOK+XW+6kvRBVK5xMOHds3OBqh
'' SIG '' K/bt1nz8MIIGwDCCBKigAwIBAgIQDE1pckuU+jwqSj0p
'' SIG '' B4A9WjANBgkqhkiG9w0BAQsFADBjMQswCQYDVQQGEwJV
'' SIG '' UzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNV
'' SIG '' BAMTMkRpZ2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBT
'' SIG '' SEEyNTYgVGltZVN0YW1waW5nIENBMB4XDTIyMDkyMTAw
'' SIG '' MDAwMFoXDTMzMTEyMTIzNTk1OVowRjELMAkGA1UEBhMC
'' SIG '' VVMxETAPBgNVBAoTCERpZ2lDZXJ0MSQwIgYDVQQDExtE
'' SIG '' aWdpQ2VydCBUaW1lc3RhbXAgMjAyMiAtIDIwggIiMA0G
'' SIG '' CSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDP7KUmOsap
'' SIG '' 8mu7jcENmtuh6BSFdDMaJqzQHFUeHjZtvJJVDGH0nQl3
'' SIG '' PRWWCC9rZKT9BoMW15GSOBwxApb7crGXOlWvM+xhiumm
'' SIG '' KNuQY1y9iVPgOi2Mh0KuJqTku3h4uXoW4VbGwLpkU7sq
'' SIG '' FudQSLuIaQyIxvG+4C99O7HKU41Agx7ny3JJKB5MgB6F
'' SIG '' VueF7fJhvKo6B332q27lZt3iXPUv7Y3UTZWEaOOAy2p5
'' SIG '' 0dIQkUYp6z4m8rSMzUy5Zsi7qlA4DeWMlF0ZWr/1e0Bu
'' SIG '' bxaompyVR4aFeT4MXmaMGgokvpyq0py2909ueMQoP6Mc
'' SIG '' D1AGN7oI2TWmtR7aeFgdOej4TJEQln5N4d3CraV++C0b
'' SIG '' H+wrRhijGfY59/XBT3EuiQMRoku7mL/6T+R7Nu8GRORV
'' SIG '' /zbq5Xwx5/PCUsTmFntafqUlc9vAapkhLWPlWfVNL5Af
'' SIG '' J7fSqxTlOGaHUQhr+1NDOdBk+lbP4PQK5hRtZHi7mP2U
'' SIG '' w3Mh8y/CLiDXgazT8QfU4b3ZXUtuMZQpi+ZBpGWUwFjl
'' SIG '' 5S4pkKa3YWT62SBsGFFguqaBDwklU/G/O+mrBw5qBzli
'' SIG '' GcnWhX8T2Y15z2LF7OF7ucxnEweawXjtxojIsG4yeccL
'' SIG '' WYONxu71LHx7jstkifGxxLjnU15fVdJ9GSlZA076XepF
'' SIG '' cxyEftfO4tQ6dwIDAQABo4IBizCCAYcwDgYDVR0PAQH/
'' SIG '' BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0lAQH/BAww
'' SIG '' CgYIKwYBBQUHAwgwIAYDVR0gBBkwFzAIBgZngQwBBAIw
'' SIG '' CwYJYIZIAYb9bAcBMB8GA1UdIwQYMBaAFLoW2W1NhS9z
'' SIG '' KXaaL3WMaiCPnshvMB0GA1UdDgQWBBRiit7QYfyPMRTt
'' SIG '' lwvNPSqUFN9SnDBaBgNVHR8EUzBRME+gTaBLhklodHRw
'' SIG '' Oi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVz
'' SIG '' dGVkRzRSU0E0MDk2U0hBMjU2VGltZVN0YW1waW5nQ0Eu
'' SIG '' Y3JsMIGQBggrBgEFBQcBAQSBgzCBgDAkBggrBgEFBQcw
'' SIG '' AYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMFgGCCsG
'' SIG '' AQUFBzAChkxodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5j
'' SIG '' b20vRGlnaUNlcnRUcnVzdGVkRzRSU0E0MDk2U0hBMjU2
'' SIG '' VGltZVN0YW1waW5nQ0EuY3J0MA0GCSqGSIb3DQEBCwUA
'' SIG '' A4ICAQBVqioa80bzeFc3MPx140/WhSPx/PmVOZsl5vdy
'' SIG '' ipjDd9Rk/BX7NsJJUSx4iGNVCUY5APxp1MqbKfujP8DJ
'' SIG '' AJsTHbCYidx48s18hc1Tna9i4mFmoxQqRYdKmEIrUPwb
'' SIG '' tZ4IMAn65C3XCYl5+QnmiM59G7hqopvBU2AJ6KO4ndet
'' SIG '' Hxy47JhB8PYOgPvk/9+dEKfrALpfSo8aOlK06r8JSRU1
'' SIG '' NlmaD1TSsht/fl4JrXZUinRtytIFZyt26/+YsiaVOBmI
'' SIG '' RBTlClmia+ciPkQh0j8cwJvtfEiy2JIMkU88ZpSvXQJT
'' SIG '' 657inuTTH4YBZJwAwuladHUNPeF5iL8cAZfJGSOA1zZa
'' SIG '' X5YWsWMMxkZAO85dNdRZPkOaGK7DycvD+5sTX2q1x+Dz
'' SIG '' BcNZ3ydiK95ByVO5/zQQZ/YmMph7/lxClIGUgp2sCovG
'' SIG '' SxVK05iQRWAzgOAj3vgDpPZFR+XOuANCR+hBNnF3rf2i
'' SIG '' 6Jd0Ti7aHh2MWsgemtXC8MYiqE+bvdgcmlHEL5r2X6cn
'' SIG '' l7qWLoVXwGDneFZ/au/ClZpLEQLIgpzJGgV8unG1TnqZ
'' SIG '' bPTontRamMifv427GFxD9dAq6OJi7ngE273R+1sKqHB+
'' SIG '' 8JeEeOMIA11HLGOoJTiXAdI/Otrl5fbmm9x+LMz/F0xN
'' SIG '' AKLY1gEOuIvu5uByVYksJxlh9ncBjDGCBkQwggZAAgEB
'' SIG '' MIGGMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xMTAvBgNVBAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJl
'' SIG '' ZCBJRCBDb2RlIFNpZ25pbmcgQ0ECEAiadJ64LcPsJ+pl
'' SIG '' 6tv4NTEwCQYFKw4DAhoFAKBwMBAGCisGAQQBgjcCAQwx
'' SIG '' AjAAMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwG
'' SIG '' CisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEVMCMGCSqG
'' SIG '' SIb3DQEJBDEWBBS6ZI8UgldTPXO72L7gKy4kX6Qo+DAN
'' SIG '' BgkqhkiG9w0BAQEFAASCAgBkb4GRbO3XgTSy/sIusoiY
'' SIG '' 33s8xQ0L0lhRY/KYIntnkLHcWJWADOjUzSwc/vVbhRRA
'' SIG '' 8wSSkeAnuFBnCojlvN78fvq08xg94ZNRMpeJ7noU/LLz
'' SIG '' dMIflBxPf/Ipw07hfFsDKUYfNhdIrYjugzOLtb2mxH7/
'' SIG '' RpVZ4hkzeARkZ35taVdOGrEfoMyFFVO0QS8aMyR4sa6+
'' SIG '' JblR4KMa5Dd6ncrYm6FkkIpyzfbijBvxbLUnlmtFpTt/
'' SIG '' Sdqo33LtoB0q7ObQYaHvi8/MF2zxR969ZwpqibzAGjFN
'' SIG '' qsE5fjwiRnPl3EIs4cI/1N0ZuMwJ4PKKBf87gjvUUyUx
'' SIG '' NWGvlaGLjMmJHN9Yo8mM825e9KUc9WJeesiugwxRMgZW
'' SIG '' HuLC7CILlpPk2ETpjPfFpUnqXsKPRQ8vU5+mlo1uL/gu
'' SIG '' ggXdetizYwbFD6ERDi8R6RJWvP04xEXZLqrRW9rY2fXb
'' SIG '' RzqSnL1mYWAlrhyQRHcOxOsdsbtboI6AM3j1nBVmX7Nw
'' SIG '' vsCanhtl8upa9L31HAyU4y6NHPw5xi6hAOLmwRxr9rmr
'' SIG '' 68tl++rt5X8oLDtUw6NZHRG6+RotDacVLT29CPmJBZ5i
'' SIG '' mz4ObewSDRXqxs+85d7q+axOwQUiILdirNYn4pKNAztl
'' SIG '' cLzigbXD9ZMnGYpOrxsdQtiK1N+hdQgVZPttE2Mr251i
'' SIG '' W6GCAyAwggMcBgkqhkiG9w0BCQYxggMNMIIDCQIBATB3
'' SIG '' MGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2Vy
'' SIG '' dCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3Rl
'' SIG '' ZCBHNCBSU0E0MDk2IFNIQTI1NiBUaW1lU3RhbXBpbmcg
'' SIG '' Q0ECEAxNaXJLlPo8Kko9KQeAPVowDQYJYIZIAWUDBAIB
'' SIG '' BQCgaTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwG
'' SIG '' CSqGSIb3DQEJBTEPFw0yMjEyMjAwNzI0NDRaMC8GCSqG
'' SIG '' SIb3DQEJBDEiBCDDu82Wz0AkYruOkwJnv2WB2ri9LxxW
'' SIG '' wNxR338zsiN70TANBgkqhkiG9w0BAQEFAASCAgAn03FC
'' SIG '' ZLl+FKcFDt+dT6YDwV3KrQmCUglrpQ23YA8WwvfOzwS5
'' SIG '' kkCscgb0oieIvc05Bpm4p4pom2pMT03vZNZWoLe/zSUM
'' SIG '' 3XCFBlZXRTl59he64E1sR1s2qa7HXgdVUGtGQAo9mI7o
'' SIG '' eT5GJR7hUlfA2PifljypHBNDuANCqvo3y5rbU++z960G
'' SIG '' N08RhN+EXOm/ikEasWE2wsdGUCKANEhitq15aTqcIgaJ
'' SIG '' ckfVpuDTvAz8uDsfrGd0YYjxw5n+pAya0qwoWSM5ZA1z
'' SIG '' AMRbvRn+6H4QfzH0pmFw9/JG7o9+NV8sJRHQFVvGYSea
'' SIG '' WwEX2lZNOekn3POeZ3hujWEAa8A489oC6oxjxQHcpp32
'' SIG '' S+k6VfJuvz0ZAKb98FuUd2Qga9AifCS0uIof3xEUWr+d
'' SIG '' muNUQYgVca9C/q7M44ZsEkSFI+qXdmJovekjDwoUdKzc
'' SIG '' RkiDkX5pnqUotZFzErH8Ga4V63shcQnUSoVs9AqmOGXK
'' SIG '' BHAcB5IKOOY1Lqi1WU+PbZxwnN/hfFSjNaxH6t7wUWsm
'' SIG '' /CDSbolMA2A208sdlTRxManRJT6RbD8yynYX7kof9iix
'' SIG '' GyHNVDqXL6Kv63DqBj5vRkn2WrRveJHBcIBvJUlMBEnI
'' SIG '' 9bIQd/nMpwGkEDQLIfQ8+PGR6PAFkLmL9iCkUDvna1qe
'' SIG '' hgN6n57tqtG6+/8YSg==
'' SIG '' End signature block
