#!/bin/sh

if [ -f /usr/ucb/whoami ]
then
currentUser=`/usr/ucb/whoami`
if [ "$currentUser" != "root" ]
then
        echo "******************************************************************************"
        echo "This script can only be run by the root user. Exiting ..."
        echo "******************************************************************************"
        exit
fi
fi

if [ -f "/opt/egurkha/lib/eg_agent.jar" ]
then
        echo "******************************************************************************"
        echo "The eG Agent is already installed. Exiting..."
        echo "******************************************************************************"
        exit
fi

if [ -z "$1" ] 
then
    eGuser=egurkha
else
    eGuser=$1
fi

if [ -z "$2" ] 
then
    eGgroup=egurkha
else
    eGgroup=$2
fi

#eGuser=egurkha
#eG user - please make sure that the user account exists

#eGgroup=egurkha
#eG user's group

eGInstallDir=/opt
#eG install directory

autoRestart=y
#whether the agent should auto-restart

licenseAcceptance=y
#licenseAcceptance the license

eGManager=$MANAGER_IP
#eG manager host

eGManagerPort=$MANAGER_PORT
#eG manager port

useProxy=$useProxy
#use Proxy?

proxyHost=$proxyHost
#proxy server

proxtPort=$proxtPort
#proxy port

setAuthentication=$setAuthentication
#use auhentication for proxy?

proxyUsername=$proxyUsername
#user name for proxy access - none

proxyPassword=$proxyPassword
#password for proxy access

useSSL=y
#use SSL for communication with the manager? y/n

trustedCertificates=n
#use trusted certificates for SSL communication with the manager? y/n

setNickName=n
#set the nickname for the agent - y/n

nickNameToUse=`hostname`
#the nick name to set for this agent

count=`grep "^$eGgroup:" /etc/group | wc -l`
if [ $count -eq 0 ]
then
	groupadd $eGgroup
fi

count=`grep "^$eGuser:" /etc/passwd | wc -l`
if [ $count -eq 0 ]
then
	useradd -G $eGgroup -g $eGgroup -d $eGInstallDir/egurkha $eGuser 
fi

#run iAgent first
chmod +x iAgent_solaris
`pwd`/iAgent_solaris $eGuser $eGgroup $eGInstallDir $autoRestart >/dev/null 

if [ -f "eg_uaid.ini" ]
then
mkdir -p $eGInstallDir/egurkha/agent/config && cp eg_uaid.ini $eGInstallDir/egurkha/agent/config
fi

chown $eGuser $eGInstallDir/egurkha/agent/config/eg_uaid.ini

monitorColdfusion=n
#monitor coldfusion servers?
monitorSybase=n
#monitor sybase servers?
# silent install for coldfusion and sybase is not handled here - pls manually configure these servers

#run setup_agent next
chmod +x $eGInstallDir/egurkha/bin/setup_agent
su - $eGuser -c "$eGInstallDir/egurkha/bin/setup_agent $licenseAcceptance $eGManager $eGManagerPort $useProxy $proxyHost $proxtPort $setAuthentication $proxyUsername $proxyPassword $useSSL $trustedCertificates $setNickName $monitorColdfusion $monitorSybase $eGuser $eGgroup $nickNameToUse" > /dev/null


isGoldenImageServer=$GoldenImage

if [ "$isGoldenImageServer" = "Yes" ]
then
	if [ -f $eGInstallDir/egurkha/agent/config/eg_nick.ini ]
	then
		rm -f $eGInstallDir/egurkha/agent/config/eg_nick.ini
	fi
	echo "eG Agent installation completed."
else
	#now start the agent
	su - $eGuser -c $eGInstallDir/egurkha/bin/start_agent
	echo "eG Agent installation and start-up completed."
fi



