<%
/*****************************************************************************
*	Name			:	Egagentsinfop.jsp
*	Purpose			:	Process page for agents configuration
*	Version         :   1.0
*	CreationDate	:	27/5/2003
*	Last Modified	:	
*	Author			:	Saravanan K
******************************************************************************/
%>
<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import="com.eg.AgentConfig" %>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="com.egurkha.admin.AuditLogThread"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
%>

<%
try
{
	String agentIp = request.getParameter("agentIp");
	AgentConfig agentConfig = AgentConfig.getAgentConfig();
	agentConfig.resetLastUpgradedPackageID(agentIp); 

	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Agent Status");
	auditLogThread.setCurrentValue("Agent IP/Nickname",agentIp);
	auditLogThread.setValue("Activity","Reset Agent Upgrade");
	auditLogThread.setValue("Description","Upgraded agent has been reset");
	auditLogThread.sendItToDB();

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("ResultAlert",true);
	rootJSON.put("ResultTitle",_mapping.getTextDescription("admin.upgrade.Agents Configuration"));
	rootJSON.put("ResultMsg",_mapping.getTextDescription("admin.upgrade.The current configurations have been saved successfully")+".");
	out.println(rootJSON);
}
catch(Exception e)
{
	e.printStackTrace();
}
%>







