<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@	taglib prefix =	"egui" uri = "../../../WEB-INF/eg-taglib.tld"	%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.admin.EgAssetManagementDAO"%>
<%@ page import="net.sf.json.*"%>
<%@ page import="java.util.Hashtable"%>
<%@ page import="com.eg.IniFile"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
try
{

	EgMappingInfo mappingInfo=new EgMappingInfo(trackerLanguage);
	IniFile eg_serverdashboard = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_serverdashboard.ini");
	EgAssetManagementDAO egAssetManagementDashboardDAO = new EgAssetManagementDAO();
	egAssetManagementDashboardDAO.setUser(_user);
	
	JSONObject dataObj = new JSONObject();
	JSONArray dataArray = new JSONArray();
	JSONArray legendArray = new JSONArray();
	JSONObject dataSetObj = new JSONObject();
	JSONObject legendObj = new JSONObject();
	JSONArray dataSetArray = new JSONArray();
	JSONArray category = new JSONArray();
	JSONObject valueObj = new JSONObject();

	JSONObject rootJson = new JSONObject();
	JSONArray rootJsonArray1 = new JSONArray();
	JSONArray rootJsonArray2 = new JSONArray();
	JSONArray rootJsonArray3 = new JSONArray();
	JSONObject rootJsonArrayObject = new JSONObject();
	
	String[] barGraphColors = eg_serverdashboard.getValue("Dashboard_Graph_colors","Asset_Col_colors").split(",");
	String[] pieGraphColors = eg_serverdashboard.getValue("Dashboard_Graph_colors","Asset_Pie_colors").split(",");

	Hashtable assetDashboardData = egAssetManagementDashboardDAO.getAssetDashboardData();
	Set<String> assetDatas = assetDashboardData.keySet();
	for(String assetData : assetDatas){
		if(assetData.equals("pieChartData")){
			Hashtable pieChartJsonData = (Hashtable)assetDashboardData.get("pieChartData");
			Set<String> pieChartDatas = pieChartJsonData.keySet();
			for(String pieChartData : pieChartDatas){
				Hashtable pieChartDataTable = (Hashtable)pieChartJsonData.get(pieChartData);
				Set<String> dataTables = pieChartDataTable.keySet();
				rootJson = new JSONObject();
				dataArray = new JSONArray();
				dataSetObj = new JSONObject();
				dataSetArray = new JSONArray();
				valueObj = new JSONObject();

				if(pieChartData.equalsIgnoreCase("assetsByLocation")){
					rootJson.put("Name", mappingInfo.getTextDescription("monitor.common.Assets by Location"));
					this.colorGetMode = "forward";
					this.i = 0;
				} else if(pieChartData.equalsIgnoreCase("assetsByVendors")){
					rootJson.put("Name", mappingInfo.getTextDescription("monitor.common.Assets by Vendors"));
					this.colorGetMode = "reverse";
					this.i = pieGraphColors.length - 1;
				} else if(pieChartData.equalsIgnoreCase("assetsByBusinessImpact")){
					rootJson.put("Name", mappingInfo.getTextDescription("monitor.common.Assets by Business Impact"));
					this.colorGetMode = "constant";
				}

				for(String key: dataTables){
					dataObj = new JSONObject();
					dataObj.put("name",key);
					dataObj.put("y",pieChartDataTable.get(key));
					dataObj.put("color",this.getColor(pieGraphColors,key));
					dataArray.add(dataObj);
				}
				dataSetObj.put("data",dataArray);
				dataSetArray.add(dataSetObj);
				valueObj.put("DataSet",dataSetArray);
				valueObj.put("From", "AssetDashboard");
				rootJson.put("Value", valueObj);
				rootJson.put("Legend", dataSetObj);
				rootJsonArray2.add(rootJson);
			}
		} else if(assetData.equals("barChartData")){
			Hashtable barChartJsonData = (Hashtable)assetDashboardData.get("barChartData");
			Set<String> barChartDatas = barChartJsonData.keySet();
			for(String barChartData : barChartDatas){
				Hashtable barChartDataTable = (Hashtable)barChartJsonData.get(barChartData);
				Set<String> dataTables = barChartDataTable.keySet();
				rootJson = new JSONObject();
				dataSetArray = new JSONArray();
				valueObj = new JSONObject();
				legendArray = new JSONArray();
				category = new JSONArray();
				dataSetObj = new JSONObject();
				dataArray = new JSONArray();

				if(barChartData.equalsIgnoreCase("assetsByOS")){
					rootJson.put("Name", mappingInfo.getTextDescription("monitor.common.Assets by OS"));
					this.colorGetMode = "forward";
					this.i=0;
				} else if(barChartData.equalsIgnoreCase("assetsByBusinessService")){
					rootJson.put("Name", mappingInfo.getTextDescription("monitor.common.Assets by Business Services"));
					this.colorGetMode = "forward";
					this.i=0;
				} else if(barChartData.equalsIgnoreCase("assetsByTypes")){
					rootJson.put("Name", mappingInfo.getTextDescription("monitor.common.Assets by Types"));
					this.colorGetMode = "forward";
					this.i=0;
				} else if(barChartData.equalsIgnoreCase("assetsByStates")){
					rootJson.put("Name", mappingInfo.getTextDescription("monitor.common.Assets by State"));
					this.colorGetMode = "forward";
					this.i=0;
				} else if(barChartData.equalsIgnoreCase("assetsByComponents")){
					rootJson.put("Name", mappingInfo.getTextDescription("monitor.common.Assets by Components"));
					this.colorGetMode = "forward";
					this.i=0;
				} else if(barChartData.equalsIgnoreCase("assetsByOverAllComponentsCost")){
					rootJson.put("Name", mappingInfo.getTextDescription("monitor.common.Assets by Overall Components Cost"));
					this.colorGetMode = "forward";
					this.i=0;
				}

				for(String key: dataTables){
					String color = this.getColor(barGraphColors,key);
					legendObj = new JSONObject();
					dataObj = new JSONObject();
					legendObj.put("name",key);
					legendObj.put("color",color);
					legendArray.add(legendObj);
					category.add(key);
					dataObj.put("name",key);
					dataObj.put("y",barChartDataTable.get(key));
					dataObj.put("color",color);
					dataArray.add(dataObj);

				}
				dataSetObj.put("data",dataArray);
				dataSetArray.add(dataSetObj);
				valueObj.put("DataSet",dataSetArray);
				valueObj.put("xAxisLabel",category);
				rootJson.put("Value", valueObj);
				rootJson.put("Legend", legendArray);
				rootJsonArray3.add(rootJson);
			}
		}
	}

	Hashtable availabilityJsonData = (Hashtable)assetDashboardData.get("availabilityData");
	
	rootJson = new JSONObject();
	rootJson.put("icon","totalAsset");
	rootJson.put("name", mappingInfo.getTextDescription("monitor.common.Total Assets"));
	rootJson.put("value",availabilityJsonData.get("TotalAssets"));
	rootJsonArray1.add(rootJson);
	
	rootJson = new JSONObject();
	rootJson.put("icon","inUse");
	rootJson.put("name", mappingInfo.getTextDescription("monitor.common.In Use"));
	rootJson.put("value",availabilityJsonData.get("InUse"));
	rootJsonArray1.add(rootJson);
	
	rootJson = new JSONObject();
	rootJson.put("icon","license");
	rootJson.put("name", mappingInfo.getTextDescription("monitor.common.Near License Expires"));
	rootJson.put("value",availabilityJsonData.get("NearLicenseExpires"));
	rootJsonArray1.add(rootJson);
	
	rootJson = new JSONObject();
	rootJson.put("icon","repair");
	rootJson.put("name",mappingInfo.getTextDescription("monitor.common.Repair"));
	rootJson.put("value",availabilityJsonData.get("Repair"));
	rootJsonArray1.add(rootJson);
	
	rootJson = new JSONObject();
	rootJson.put("icon","asm");
	rootJson.put("name", mappingInfo.getTextDescription("monitor.common.Near ASM Expires"));
	rootJson.put("value",availabilityJsonData.get("NearASMExpires"));
	rootJsonArray1.add(rootJson);
	
	rootJson = new JSONObject();
	rootJson.put("icon","cost");
	rootJson.put("name", mappingInfo.getTextDescription("monitor.common.Overall Cost"));
	rootJson.put("value",availabilityJsonData.get("OverallCost"));
	rootJson.put("url","./AssetManagement/app/controller/DashboardHyperLink.js?action=OverallCost");
	rootJsonArray1.add(rootJson);
	
	rootJson = new JSONObject();
	rootJson.put("icon","maintenance");
	rootJson.put("name", mappingInfo.getTextDescription("monitor.common.Maintenance"));
	rootJson.put("value",availabilityJsonData.get("Maintenance"));
	rootJsonArray1.add(rootJson);
	
	rootJson = new JSONObject();
	rootJson.put("icon","decommissioned");
	rootJson.put("name", mappingInfo.getTextDescription("monitor.common.Decommissioned"));
	rootJson.put("value",availabilityJsonData.get("Decommissioned"));
	rootJsonArray1.add(rootJson);

	rootJsonArrayObject.put("DashboardName",mappingInfo.getTextDescription("monitor.common.Assets Dashboard"));
	rootJsonArrayObject.put("assetAvailability",rootJsonArray1);
	rootJsonArrayObject.put("piechart",rootJsonArray2);
	rootJsonArrayObject.put("barchart",rootJsonArray3);
	rootJsonArrayObject.put("skin",admin_Skin);


	out.println(rootJsonArrayObject.toString());
}
catch(Throwable ex)
{	
	ex.printStackTrace();
}
%>
<%!
int i = 0;
String colorGetMode = "";
public String getColor(String[] GraphColors, String key){
	String color = "";
	if(colorGetMode.equals("forward")){
		if(this.i == GraphColors.length)
			this.i=0;
		color = GraphColors[this.i];
		this.i = this.i + 1;
	}else if(colorGetMode.equals("reverse")){
		if(this.i == 0)
			this.i=GraphColors.length-1;
		color = GraphColors[this.i];
		this.i = this.i - 1;
	}else if(colorGetMode.equals("constant")){
		
		if(key.equalsIgnoreCase("Low"))
			color = "#39cfac";
		else if(key.equalsIgnoreCase("medium"))
			color = "#f8b477";
		else if(key.equalsIgnoreCase("High"))
			color = "#ff7f7e";
		

	}
	return color;
}

%>
