<%
/*
 *	Name			:	EgchangeippJson.jsp
 *	Purpose			:	Process page for the EgChangeIP.jsp.
 *	CreationDate	:	06/06/08
 */
%>
<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import = "com.eg.AgentConfig"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgServicesInfo" %>
<%@ page import = "com.eg.EgCertUsage"%>
<%@ page import = "com.eg.UpdateIP"%>
<%@ page import = "com.eg.UnmanagedAgentsInfo" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>

<%@ page import = "java.util.List"%>
<%@ page import = "java.util.ArrayList"%>
<%@ page import = "java.util.StringTokenizer"%>
<%@ page import = "java.util.Collections"%>

<%@ page import="net.sf.json.JSONObject"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
%>

<%
	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");

	String hostIP = request.getParameter("hostip");
	String hostName = request.getParameter("hostname");
	String port = request.getParameter("port");
	String newHostIP = request.getParameter("newhostip");
	String serverType = request.getParameter("servertype");
	String hostList = request.getParameter("hostlist");
	hostIP = (hostIP != null)?hostIP:"";
	hostName = (hostName != null)?hostName:"";
	newHostIP = (newHostIP != null)?newHostIP:"";
	serverType = (serverType != null)?serverType:"";
	hostList = (hostList != null)?hostList:"";
	AgentConfig agentConfig = AgentConfig.getAgentConfig();
	String user_id = _user.getLoginID();
	EgRoleInfo egRoleInfo = EgRoleInfo.getInstance(session.getId(),user_id);
	boolean isLimitedAdmin = !egRoleInfo.hasAllComponentAccess();
	IniFile discIni = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_discover.ini");
	EgCertUsage user = new EgCertUsage();
	ArrayList usersList = user.getAllLimitedCompAccessUsers();

	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	boolean isAllowHostName = servicesInfo.isAllowHostNames();
	rootJSON.put("serverType",serverType);

	/********Audit Log*******/
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Add/Modify Servers");
	auditLogThread.setValue("Activity","Modify Component");
	if(isAllowHostName)
	{
		auditLogThread.setCurrentValue("01~~Old host IP/Name", hostIP);
		auditLogThread.setCurrentValue("02~~New host IP/Name", newHostIP);
		auditLogThread.setValue("Description","Host IP/Name has been modified");
	}
	else
	{
		auditLogThread.setCurrentValue("01~~Old host IP", hostIP);
		auditLogThread.setCurrentValue("02~~New host IP", newHostIP);
		auditLogThread.setValue("Description","Host IP has been modified");
	}
	
	boolean statusFlag = true;
	String hostNames = hostName;
	String modexternalHosts = "";
	String modremoteHosts = "";
	if (hostList.length() > 0)
	{
		hostNames += ":"+hostList;
	}
	UpdateIP updateIP = new UpdateIP();
	
	// eg_discover.ini and eg_agents.ini are to be modified for IP changes
	statusFlag = updateIP.changeHostIP(hostNames,hostIP,newHostIP);

	if(statusFlag)
	{
		//if(isLimitedAdmin)
		{
			ArrayList allServers = egRoleInfo.getAllServers();
			//IniFile userCompMapWrite = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_usercompmapping.ini");
			String[] variables = (String[])allServers.toArray(new String[0]);
			if(variables != null && variables.length > 0)
			{
				for(int i=0; i<variables.length; i++)
				{
					String _srvr = "";
					String _comp = "";
					String _ip = "";
					String _port = "";
					String _sid = "";
					String _isPassive = "";
					String hostAndIp = "";
					String srvrType = variables[i].substring(0,variables[i].indexOf(":"));
					String value = discIni.getValue(srvrType,variables[i]);
					StringTokenizer temp = new StringTokenizer(value,",");
					if(temp.countTokens() >= 5)
					{
						_srvr = temp.nextToken();
						_ip = temp.nextToken();
						_comp = temp.nextToken();
						_port = temp.nextToken();
						_isPassive = temp.nextToken();
						if(_srvr.equalsIgnoreCase("Oracle_Server"))
							_sid = temp.nextToken();
					}
					String compWithIp = _comp + ":" + _ip;
					hostAndIp = hostName + ":" + hostIP;
					if(compWithIp.equals(hostAndIp))
					{
						String val = _srvr+","+ newHostIP+","+ _comp+","+ _port+","+_isPassive;
						if(_srvr.equalsIgnoreCase("Oracle_Server"))
							val += ","+ _sid;
						//if(isLimitedAdmin)
						//{
							//userCompMapWrite.setValue(user_id,variables[i],val);
						//}
						//else
						//{
							//String userID = getUserId(usersList,variables[i]);
							//if(!userID.equals("fullAdmin"))
								//userCompMapWrite.setValue(userID,variables[i],val);
						//}
					}

					if(hostList != null & hostList.length() > 0)
					{
						StringTokenizer stTknzr = new StringTokenizer(hostList,":");
						while(stTknzr.hasMoreTokens())
						{
							String tmp = stTknzr.nextToken();
							int index = tmp.indexOf("|");
							if(index > 0)
							{
								String compNick = tmp.substring(0,index);
								String compTypes = tmp.substring(index+1);
								hostAndIp = compNick + ":" + hostIP;
								if(compTypes.indexOf(",") > 0)
								{
									StringTokenizer strTkns = new StringTokenizer(compTypes,",");
									while(strTkns.hasMoreTokens())
									{
										String compType = strTkns.nextToken();										
										if(compWithIp.equals(hostAndIp) && compType.equalsIgnoreCase(_srvr))
										{
											String val = _srvr+","+ newHostIP+","+ _comp+","+ _port+","+_isPassive;
											if(_srvr.equalsIgnoreCase("Oracle_Server"))
												val += ","+ _sid;
											//if(isLimitedAdmin)
											//{
												//userCompMapWrite.setValue(user_id,variables[i],val);
											//}
											//else
											//{
												//String userID = getUserId(usersList,variables[i]);
												//if(!userID.equals("fullAdmin"))
													//userCompMapWrite.setValue(userID,variables[i],val);
											//}
										}
									}
								}
								else
								{
									if(compWithIp.equals(hostAndIp) && compTypes.equalsIgnoreCase(_srvr))
									{
										String val = _srvr+","+ newHostIP+","+ _comp+","+ _port+","+_isPassive;
										if(_srvr.equalsIgnoreCase("Oracle_Server"))
											val += ","+ _sid;
										//if(isLimitedAdmin)
										//{
											//userCompMapWrite.setValue(user_id,variables[i],val);
										//}
										//else
										//{
											//String userID = getUserId(usersList,variables[i]);
											//if(!userID.equals("fullAdmin"))
												//userCompMapWrite.setValue(userID,variables[i],val);
										//}
									}
								}
							}
						}
					}
				}
			}
			//userCompMapWrite.saveFile();
			//EgConfigFilesSync.releaseInstance(userCompMapWrite);
		}
	}
	
	hostNames = updateIP.getModifiedComponents(hostName,serverType);
	modexternalHosts = updateIP.getModifiedExternalHosts();
	modremoteHosts = updateIP.getModifiedRemoteHosts();
	Vector sess_vec = new Vector();
	String url = "";
	List resultList = new ArrayList();
	StringTokenizer stt = new StringTokenizer(hostNames,":");
	while(stt.hasMoreTokens())
	{
		String tmpHost = stt.nextToken();
		int idx = tmpHost.indexOf("|");
		if (idx > 0)
		{
			String modCompTypes = tmpHost.substring(idx+1);
			if(modCompTypes.indexOf(",") > 0)
			{
				StringTokenizer strToken = new StringTokenizer(modCompTypes,",");
				while(strToken.hasMoreTokens())
				{
					resultList.add(tmpHost.substring(0,idx)+" ("+_mapping.getComponentTypeDescription(strToken.nextToken())+")");
				}
			}
			else
			{
				resultList.add(tmpHost.substring(0,idx)+" ("+_mapping.getComponentTypeDescription(modCompTypes)+")");
			}
		}
		else
		{
			resultList.add(tmpHost+" ("+_mapping.getComponentTypeDescription(serverType)+")");
		}
	}
	Collections.sort(resultList);
	/*****Audit Log*********/
	if (resultList.size()>0)
	{		
		for(int i=0;i<resultList.size();i++)
		{
			auditLogThread.setCurrentValue("03~~Modified host(s)", (String)resultList.get(i));
		}
	
	}
	/*********************/

	String sessResult = resultList.toString();
	sessResult = sessResult.substring(1,sessResult.length() -1);

	boolean allExternalTests = true;
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	String[] testsForServer = specsInfo.getTestsForServer(serverType);
	if (testsForServer != null)
	{
		for (int a=0; a<testsForServer.length; a++)
		{
			if (!specsInfo.isTestExternal(testsForServer[a]))
			{
				allExternalTests = false;
				break;
			}
		}
	}

	if (statusFlag)
	{
		//Vmware ESX/VDI '-virtual_center' entries in eg_agents.ini
		if (serverType.equals("Virtual_center"))
		{
			UpdateVcConfig updateVcConfig = new UpdateVcConfig();
			updateVcConfig.changeVcConfig(newHostIP,hostIP);
		}
		//Vmware Vcenter eg_services.ini entries
		IniFile externalWrite = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_services.ini");
		ArrayList extIniEntries = new ArrayList();
		String Ssl = "True";
		String uName = "$unconfigured";
		String uPass = "$unconfigured";
		String isDiscovery = "No";
		String webPort = "443";
		String domainVal = "internal";
		String pSeriesHostName = "$unconfigured";

		if (!com.egurkha.util.StringUtils.isNull(serverType) && serverType.equals("Virtual_center"))
		{
			ArrayList vCValList = new ArrayList();
			String vCVal = externalWrite.getValue("VIRTUAL_CENTER",hostIP);
			StringTokenizer stTok = new StringTokenizer(vCVal,"#");
			while (stTok.hasMoreTokens())
			{
				vCValList.add(stTok.nextToken());
			}
			if (vCValList.size() > 0 && !vCValList.contains("$unconfigured"))
			{
				String SslMod = (String)vCValList.get(0);
				String uNameMod = (String)vCValList.get(1);
				String uPassMod = (String)vCValList.get(2);
				String isDiscoveryMod = (String)vCValList.get(3);
				String webPortMod = (String)vCValList.get(4);
				String domainMod = (String)vCValList.get(4);

				extIniEntries.add(new IniHelper(IniHelper.DELETE,"VIRTUAL_CENTER", hostIP, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+webPort));
				extIniEntries.add(new IniHelper(IniHelper.SET,"VIRTUAL_CENTER", newHostIP, SslMod+"#"+uNameMod+"#"+uPassMod+"#"+isDiscoveryMod+"#"+webPortMod));
			}
			else
			{
				extIniEntries.add(new IniHelper(IniHelper.DELETE,"VIRTUAL_CENTER", hostIP, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+webPort));
				extIniEntries.add(new IniHelper(IniHelper.SET,"VIRTUAL_CENTER", newHostIP, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+webPort));
			}
		}
		else if (!com.egurkha.util.StringUtils.isNull(serverType) && serverType.equals("Redhat_linux_mgr"))
		{
			ArrayList rhevValList = new ArrayList();
			String rhevVal = externalWrite.getValue("RHEV",hostIP);
			StringTokenizer rhevTok = new StringTokenizer(rhevVal,"#");
			while (rhevTok.hasMoreTokens())
			{
				rhevValList.add(rhevTok.nextToken());
			}
			if (rhevValList.size() > 0 && !rhevValList.contains("$unconfigured"))
			{
				String SslMod = (String)rhevValList.get(0);
				String uNameMod = (String)rhevValList.get(1);
				String uPassMod = (String)rhevValList.get(2);
				String isDiscoveryMod = (String)rhevValList.get(3);
				String webPortMod = (String)rhevValList.get(4);
				String domainMod = (String)rhevValList.get(5);

				extIniEntries.add(new IniHelper(IniHelper.DELETE,"RHEV", hostIP, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+webPort+"#"+domainVal));
				extIniEntries.add(new IniHelper(IniHelper.SET,"RHEV", newHostIP, SslMod+"#"+uNameMod+"#"+uPassMod+"#"+isDiscoveryMod+"#"+webPortMod+"#"+domainMod));
			}
			else
			{
				extIniEntries.add(new IniHelper(IniHelper.DELETE,"RHEV", hostIP, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+webPort+"#"+domainVal));
				extIniEntries.add(new IniHelper(IniHelper.SET,"RHEV", newHostIP, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+webPort+"#"+domainVal));
			}
		}
		else if (!com.egurkha.util.StringUtils.isNull(serverType) && serverType.equals("hmc_server"))
		{
			ArrayList pSeriesValList = new ArrayList();
			String rhevVal = externalWrite.getValue("HMC",hostIP);
			StringTokenizer pserTok = new StringTokenizer(rhevVal,"#");
			while (pserTok.hasMoreTokens())
			{
				pSeriesValList.add(pserTok.nextToken());
			}
			if (pSeriesValList.size() > 0 && !pSeriesValList.contains("$unconfigured"))
			{
				String SslMod = (String)pSeriesValList.get(0);
				String uNameMod = (String)pSeriesValList.get(1);
				String uPassMod = (String)pSeriesValList.get(2);
				String isDiscoveryMod = (String)pSeriesValList.get(3);
				String hostNameMod = (String)pSeriesValList.get(4);

				extIniEntries.add(new IniHelper(IniHelper.DELETE,"HMC", hostIP, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+pSeriesHostName));
				extIniEntries.add(new IniHelper(IniHelper.SET,"HMC", newHostIP, SslMod+"#"+uNameMod+"#"+uPassMod+"#"+isDiscoveryMod+"#"+hostNameMod));
			}
			else
			{
				extIniEntries.add(new IniHelper(IniHelper.DELETE,"HMC", hostIP, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+pSeriesHostName));
				extIniEntries.add(new IniHelper(IniHelper.SET,"HMC", newHostIP, Ssl+"#"+uName+"#"+uPass+"#"+isDiscovery+"#"+pSeriesHostName));
			}
		}
		if (extIniEntries.size() > 0)
		{
			for (int n=0; n<extIniEntries.size(); n++)
			{
				IniHelper iniHelper = (IniHelper)extIniEntries.get(n);
				String iniAction = iniHelper.getAction();
				String subject = iniHelper.getSubject();
				String key = iniHelper.getVariable();
				String value = iniHelper.getValue();
				if(iniAction != null)
				{
					if (iniAction.equals(IniHelper.SET))
					{
						externalWrite.setValue(subject,key,value);
					}
					else if (iniAction.equals(IniHelper.DELETE))
					{
						externalWrite.deleteValue(subject,key);
					}
				}
			}
			externalWrite.saveFile();
			//EgConfigFilesSync.releaseInstance(externalWrite);
		}
		EgConfigFilesSync.releaseInstance(externalWrite);

		agentConfig.removeAgentElement(hostName);
		
		rootJSON.put("AlertType","result");
		rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.server.Modify components"));
		String msg = _mapping.getTextDescription("admin.server.The following component(s) is/are updated with the new host IP")+" "+newHostIP+"<br><b>"+sessResult+"</b>";
		
		if(modexternalHosts!=null && modexternalHosts.length() > 0)
		{
			msg += "<br><br>";
			msg += _mapping.getTextDescription("admin.server.The following external host(s) is/are updated with the new host IP")+" "+newHostIP+"<br><b>"+modexternalHosts+"</b>";
			auditLogThread.setCurrentValue("04~~Modified External agent(s)", modexternalHosts);
		}
		if(modremoteHosts!=null && modremoteHosts.length() > 0)
		{
			msg += "<br><br>";
			msg += _mapping.getTextDescription("admin.server.The following remote host(s) is/are updated with the new host IP")+" "+newHostIP+"<br><b>"+modremoteHosts+"</b>";
			auditLogThread.setCurrentValue("05~~Modified Remote agent(s)", modremoteHosts);
		}
		rootJSON.put("AlertMsg",msg);
		auditLogThread.sendItToDB();
		UnmanagedAgentsInfo uai = new UnmanagedAgentsInfo();
		uai.updateAgentDetail(newHostIP);
	}
	else
	{
		rootJSON.put("AlertType","error");
		rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.server.Modify components"));
		rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.server.Not properly updated with the new host IP")+", "+newHostIP);
	}
	out.println(rootJSON);
%>

<%!
	//public String getUserId(ArrayList limitedUserList, String givenVariable)
	//{
		//String userId = "";
		//IniFile userCompMapIni = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_usercompmapping.ini");
		//String[] subjects = userCompMapIni.getSubjects();
		//if(subjects != null && subjects.length > 0)
		//{
			//for(int s=0; s<subjects.length; s++)
			//{
				//if(limitedUserList.contains(subjects[s]))
				//{
					//String[] variables = userCompMapIni.getVariables(subjects[s]);
					//if(variables != null && variables.length > 0)
					//{
						//ArrayList varsList = new ArrayList(Arrays.asList(variables));
						//if(!varsList.contains(givenVariable))
						//{
							//continue;
						//}
						//else
						//{
							//userId = subjects[s];
						//}
					//}
				//}
			//}
		//}
		//userId = userId.equals("") ? "fullAdmin" : userId;
		//return userId;
	//}
%>

