<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page import="java.io.File" %>
<%@ page import="egurkha.*" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import="com.eg.EgCompositeInfo"%>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
%>

<%
	session.removeAttribute("compTestDetails");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	ServiceBean serviceBean =  new ServiceBean();

	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Performance Rating Test");
	auditLogThread.setValue("Activity","Delete Performance Rating Test");

	String test = request.getParameter("test");
	TestBean testBean = new TestBean(true);
	IniFile compInfo = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_composite.ini");

	compInfo.deleteValue("USER_DEFINED_COMPOSITE_TESTS",test);
	compInfo.deleteValue("TEST_COMP_TYPE_LAYER_MAPPING",test);
	compInfo.deleteValue("WEIGHTAGE",test);
	compInfo.deleteValue("MEASURES",test);
	compInfo.deleteValue("USER_DEFINED_COMPOSITE_TESTS",test);
	compInfo.deleteValue("TEST_COMP_TYPE_LAYER_MAPPING",test);
	compInfo.deleteValue("DESCRIPTOR_BASED",test);
	compInfo.deleteValue("MASTER_INFOS_TEST",test);
	compInfo.deleteValue("TEST_INFO_STATUS",test);

	String variables[] = compInfo.getVariables("TEST_MEASURES");
	if(variables != null)
	{
		String key = test + ":";
		for(int i=0;i<variables.length;i++)
		{
			String var = variables[i];
			if(var.startsWith(key))
			{
				compInfo.deleteValue("TEST_MEASURES",var);
				compInfo.deleteValue("INCLUDE_DESCRIPTORS",var);
				compInfo.deleteValue("EXCLUDE_DESCRIPTORS",var);
			}
		}
	}
	String variables2[] = compInfo.getVariables("COMPOSITE_TEST_INFOS_EXCLUDED");
	if(variables2 != null)
	{
		Vector delCompositeVec = new Vector();
		String key = test + ":";
		for(int i=0;i<variables2.length;i++)
		{
			String var = variables2[i];
			if(var.startsWith(key))
			{
				delCompositeVec.add(var);
				//compInfo.deleteValue("COMPOSITE_TEST_INFOS_EXCLUDED",var);
			}
		}
		compInfo.deleteValues("COMPOSITE_TEST_INFOS_EXCLUDED",delCompositeVec);
	}
	
	compInfo.saveFile();
	EgConfigFilesSync.releaseInstance(compInfo);


	IniFile egtests = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_tests.ini");
	egtests.deleteValue("GLOBAL_THRESHOLDS",test);
	egtests.deleteValue("TREND_TESTS",test);
	egtests.saveFile();
	EgConfigFilesSync.releaseInstance(egtests);

	IniFile complang = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_composite_lang_en_US.ini");
	complang.deleteValue("TEST_NAME_MAPPING",test);
	complang.deleteValue("TEXT_NAME_MAPPING","admin.composite."+test);
	complang.deleteValue("PURPOSE_OF_TEST",test);

	String variable_[] = complang.getVariables("MEASURE_NAME_MAPPING");
	if(variable_ != null)
	{
		Vector delMeasure = new Vector();
		for(int i=0;i<variable_.length;i++)
		{
			if(variable_[i].startsWith(test+":"))
			{
				delMeasure.add(variable_[i]);
				//complang.deleteValue("MEASURE_NAME_MAPPING",variable_[i]);
				//complang.deleteValue("ALARM_DISPLAY_STRING",variable_[i]);
			}
		}
		complang.deleteValues("MEASURE_NAME_MAPPING",delMeasure);
		complang.deleteValues("ALARM_DISPLAY_STRING",delMeasure);
	}
	complang.saveFile();
	EgConfigFilesSync.releaseInstance(complang);

	testBean.removeDdEntries(test);
	testBean.deleteTest(test);

	DbBean dbBean = new DbBean(true);
	//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
	IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
	serviceBean.stopDiscovery();

	dbBean.removeTest(test);

	UpdateAndTransmitICInfo updateICInfo = new UpdateAndTransmitICInfo();
	updateICInfo.deleteTestFromDb(test);
	serviceBean.startDiscovery("1");
	EgConfigFilesSync.releaseInstance(infraIni);

	auditLogThread.setValue("Description","Test "+"$test$:"+test+" has been deleted");
	auditLogThread.sendItToDB();

	String sep = System.getProperty("file.separator");
	String dbServType = new EgDbInfo("manager").checkDBType();
	if(dbServType != null && dbServType.equals("EgMsSqlAdapter"))
	{
		String queryDir = EgInstallInfo.getInstallDir()+sep+"bin"+sep+"database"+sep+"mssql"+sep+"Composite_Test_Query";
		File dir = new File(queryDir);
		if(dir.isDirectory())
		{
			File queryFile = new File(queryDir+sep+test+".txt");
			if(queryFile.exists())
			{
				queryFile.delete();
			}
		}
	}
	else
	{
		String queryDir = EgInstallInfo.getInstallDir()+sep+"bin"+sep+"database"+sep+"Composite_Test_Query";
		File dir = new File(queryDir);
		if(dir.isDirectory())
		{
			File queryFile = new File(queryDir+sep+test+".txt");
			if(queryFile.exists())
			{
				queryFile.delete();
			}
		}
	}
	rootJSON.put("AlertType","Result");
	rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Delete Performance Rating Test"));
	rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.ic.Performance rating test has been deleted successfully"));
	out.println(rootJSON);

%>