
<%@ include file = "../../EgTrackerAJSON.jsp" %>

<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "net.sf.json.JSONObject"%>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.eg.EgExternalInfo"%>
<%@ page import = "com.eg.EgCorrectiveScripts"%>
<%@ page import = "com.eg.EgServicesInfo"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>

<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	JSONObject rootJson = new JSONObject();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
	
	String csEnable = request.getParameter("associatedTests");
	String csDisable = request.getParameter("availableTests");
	String componentType = request.getParameter("componentType");
	ArrayList allCsEnabledTests = new ArrayList();
	ArrayList allCsDisabledTests = new ArrayList();
	if (!StringUtils.isNull(csEnable))
	{
		StringTokenizer strCsEnabledTests = new StringTokenizer(csEnable, ",");
		while (strCsEnabledTests.hasMoreTokens())
		{
			allCsEnabledTests.add(strCsEnabledTests.nextToken());
		}
	}
	if (!StringUtils.isNull(csDisable))
	{
		StringTokenizer strCsDisabledTests = new StringTokenizer(csDisable, ",");
		while (strCsDisabledTests.hasMoreTokens())
		{
			allCsDisabledTests.add(strCsDisabledTests.nextToken());
		}
	}

	if (componentType != null && !componentType.equals("") && !componentType.equals("-1"))
	{
		
		EgServicesInfo egServicesInfo = new EgServicesInfo("manager");
		boolean isAuditLogEnabled = egServicesInfo.isAuditlogEnabled();
		
		EgCorrectiveScripts correctiveScripts = new EgCorrectiveScripts();
		if (allCsEnabledTests != null && allCsEnabledTests.size() > 0)
		{
			AuditLogThread auditLogThread = new AuditLogThread();
			if (isAuditLogEnabled)
			{
				auditLogThread.setValue("Category","Admin");
				auditLogThread.setValue("User_id",_user.getLoginID());
				auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
				auditLogThread.setValue("Session_id",session.getId());
				auditLogThread.setValue("Module","Corrective Scripts");
				auditLogThread.setValue("Activity","Enable Corrective Script");
				auditLogThread.setValue("Description","Corrective Script have been Enabled");
				String testNameStr = "";
				for (int i=0; i<allCsEnabledTests.size(); i++)
				{
					String testName = (String) allCsEnabledTests.get(i);
					String displayTestName = _mapping.getTestDescription(testName);
					testNameStr = testNameStr+","+displayTestName;
				}
				String displayNameTestStr = testNameStr.substring(1);
				auditLogThread.setCurrentValue("Enabled Tests",displayNameTestStr);
				auditLogThread.sendItToDB();
			}
			correctiveScripts.enableCorrectiveScript(componentType, allCsEnabledTests);
		}
		if (allCsDisabledTests != null && allCsDisabledTests.size() > 0)
		{
			AuditLogThread auditLogThread = new AuditLogThread();
			if (isAuditLogEnabled)
			{
				auditLogThread.setValue("Category","Admin");
				auditLogThread.setValue("User_id",_user.getLoginID());
				auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
				auditLogThread.setValue("Session_id",session.getId());
				auditLogThread.setValue("Module","Corrective Scripts");
				auditLogThread.setValue("Activity","Disable Corrective Script");
				auditLogThread.setValue("Description","Corrective Script have been Disabled");
				String testNameStr = "";
				for (int i=0; i<allCsDisabledTests.size(); i++)
				{
					String testName = (String) allCsDisabledTests.get(i);
					String displayTestName = _mapping.getTestDescription(testName);
					testNameStr = testNameStr +","+ displayTestName;
				}
				String displayNameTestStr = testNameStr.substring(1);
				auditLogThread.setCurrentValue("Disabled Tests",displayNameTestStr);
				auditLogThread.sendItToDB();
			}
			correctiveScripts.disableCorrectiveScript(componentType, allCsDisabledTests);
		}
	}

	rootJson.put("requestStatus","success");
	JSONObject resultMsg = new JSONObject();
	resultMsg.put("title",_mapping.getTextDescription("admin.title.ENABLE/DISABLE CORRECTIVE SCRIPTS"));
	resultMsg.put("message1",_mapping.getTextDescription("admin.test.Tests have been enabled/disabled with corrective scripts successfully")+".");
	rootJson.put("result",resultMsg);
	out.println(rootJson.toString());
%>



