<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import="java.util.*" %>
<%@ page import="java.io.File" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="com.eg.EgThresholdInfo" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="com.eg.EgName" %>
<%@ page import="com.egurkha.ini.IniUI" %>
<%@ page import="com.eg.MappingNameSorter" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "net.sf.json.*"%>
<%@ page import="com.eg.EgCorrectiveScripts" %>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject hiddenParams = new JSONObject();

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	//tells information about the corresponding authenticated user
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	// removing external and aggregate component types
	String[] allExtCompTypeArr = egSpecs.getAllExternalServerTypes();
	HashSet allExtCompTypeSet = new HashSet(Arrays.asList(allExtCompTypeArr));
	List serverList = Arrays.asList(ri.getServerTypes());
	ArrayList listComponentTypes = new ArrayList();
	for (int m=0; m<serverList.size(); m++)
	{
		String strComponentType = (String) serverList.get(m);
		if (strComponentType.startsWith("Agg_"))
		{
			continue;
		}
		if (allExtCompTypeSet.contains(strComponentType))
		{
			continue;
		}
		listComponentTypes.add(strComponentType);
	}

	listComponentTypes = sorter.getSortedCompTypeList(listComponentTypes);

	String mode = request.getParameter("mode");
	if (StringUtils.isNull(mode))
	{
		mode = "upload";
	}

	String compType = request.getParameter("compType");
	String testName = request.getParameter("testName");
	String strOSName = request.getParameter("osName");
	if (compType == null)
	{
		compType = "";
	}

	if (testName == null)
	{
		testName = "";
	}

	JSONArray compTypeArr = new JSONArray();
	JSONObject compTypeObj = new JSONObject();

	if (listComponentTypes.size() > 0)
	{
		compTypeObj.put("valueField","-1");
		compTypeObj.put("displayField",_mapping.getTextDescription("admin.common.Choose a component type"));
		compTypeArr.add(compTypeObj);
	}
	else
	{
		compTypeObj.put("valueField","-1");
		compTypeObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
		compTypeArr.add(compTypeObj);
	}

	//EgName class is used to hold name and its localised name.
	for (int j=0; j<listComponentTypes.size(); j++)
	{
		EgName nameObj = (EgName)listComponentTypes.get(j);
		String actualname = nameObj.getActualName();
		String localname = nameObj.getLocalName();
		compTypeObj.put("valueField",actualname);
		compTypeObj.put("displayField",localname);
		compTypeArr.add(compTypeObj);
		if (actualname.equals(compType))
		{
			rootJson.put("selectedCompType",actualname);
		}
		
	}
	rootJson.put("compTypeArr",compTypeArr);

	//intimate to user - no enabled tests found for a component type - starts
	boolean isAtleastOneTestEnabled = true;
	//intimate to user - no enabled tests found for a component type - ends
	if (compType!=null)
	{

		JSONArray testNameArr = new JSONArray();
		JSONObject testNameObj = new JSONObject();

		if (!compType.equals("-1"))
		{
			//contains enabled test for a component type
			ArrayList aListEnabledTestForCompType = new ArrayList();
			aListEnabledTestForCompType = egSpecs.getEnabledTests(compType,false);
			aListEnabledTestForCompType = sorter.getSortedTestList(aListEnabledTestForCompType);

			if (egSpecs.getTestsForServer(compType) == null || aListEnabledTestForCompType.isEmpty())
			{
				isAtleastOneTestEnabled = false;
			}
			
			if (aListEnabledTestForCompType != null )
			{
				if (aListEnabledTestForCompType.size() > 0)
				{
					testNameObj.put("valueField","-1");
					testNameObj.put("displayField",_mapping.getTextDescription("admin.common.Choose a test name"));
					testNameArr.add(testNameObj);
				}
				else
				{
					testNameObj.put("valueField","-1");
					testNameObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
					testNameArr.add(testNameObj);
				}

				for (int i=0; i<aListEnabledTestForCompType.size(); i++)
				{
					testNameObj = new JSONObject();
					EgName nameObj = (EgName)aListEnabledTestForCompType.get(i);
					String strTestName = nameObj.getActualName();
					String strTestDisplayValue = nameObj.getLocalName();
					// removing external tests in upload new corrective script 
					boolean isExternalTest = egSpecs.isExternalTest(strTestName, compType);
					if (!isExternalTest)
					{
						testNameObj.put("valueField",strTestName);
						testNameObj.put("displayField",strTestDisplayValue);
						testNameArr.add(testNameObj);
						if (testName != null && strTestName.equals(testName))
						{
							rootJson.put("selectedTestName",strTestName);
							rootJson.put("displayTestName",strTestDisplayValue);
						}
					}
				}
			}
		}
		else
		{
			testNameObj.put("valueField","-1");
			testNameObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
			testNameArr.add(testNameObj);
		}

		rootJson.put("testNameArr",testNameArr);
	}
	rootJson.put("isAtleastOneTestEnabled",isAtleastOneTestEnabled);

	ArrayList osNameList = new ArrayList();
	try
	{
		String installDir = EgInstallInfo.getInstallDir() + "/bin/AutoCorrect";
		File directoryPath = new File(installDir);
		if (directoryPath.exists())
		{
			String[] folderList = directoryPath.list();
			if (folderList != null && folderList.length > 0)
			{
				for (int f=0;f<folderList.length;f++)
				{
					String strOSfolder = folderList[f];
					if (!StringUtils.isNull(strOSfolder) && (strOSfolder.equals("Windows2000") || strOSfolder.equals("Windows2003") || strOSfolder.equals("WindowsNT")))
					{
						continue;
					}
					osNameList.add(strOSfolder);
				}
			}
		}
	}
	catch(Exception ex)
	{
		ex.printStackTrace();
	}

	if (osNameList != null && osNameList.size() > 0)
	{
		JSONArray osNameArr = new JSONArray();
		JSONObject osNameObj = new JSONObject();
		osNameObj.put("displayField",_mapping.getTestDescription("admin.test.Choose an Operating system"));
		osNameObj.put("valueField","-1");
		osNameArr.add(osNameObj);
		for (int os=0;os <osNameList.size();os++)
		{
			osNameObj = new JSONObject();
			String OSName = (String)osNameList.get(os);
			String dispOSName = OSName;
			if (!StringUtils.isNull(strOSName) && strOSName.equals(OSName))
			{
				rootJson.put("selectedOSName",strOSName);
			}

			if (!StringUtils.isNull(OSName) && OSName.startsWith("Windows"))
			{
				dispOSName = "Windows "+OSName.substring(OSName.indexOf("Windows")+7);
			}
			osNameObj.put("displayField",dispOSName);
			osNameObj.put("valueField",OSName);
			osNameArr.add(osNameObj);
		}
		rootJson.put("osNameArr",osNameArr);
	}
	
	JSONArray measNameArr = new JSONArray();
	JSONObject measureObj = new JSONObject();

	if(!StringUtils.isNull(testName) && !testName.equals("-1"))
	{
		EgThresholdInfo threshInfo = new EgThresholdInfo("manager");
		String measures[] = threshInfo.getMeasurementsForTest(testName);
		ArrayList measureList = new ArrayList(Arrays.asList(measures));
		measureList = sorter.getSortedMeasureList(testName, measureList);
		measureObj.put("displayField","All measures");
		measureObj.put("valueField",testName);
		measNameArr.add(measureObj);
		if(measureList != null && measureList.size() > 0)
		{
			measureObj = new JSONObject();
			for(int i=0;i<measureList.size();i++)
			{
				EgName nameObj = (EgName)measureList.get(i);
				String meas = (String)nameObj.getActualName();
				String disp_Measure = (String)nameObj.getLocalName();
				String underScore="_";
				String colon=":";
				String disptestName = _mapping.getTestDescription(testName);

				measureObj.put("displayField",disp_Measure);
				measureObj.put("valueField",testName+underScore+meas);
				measNameArr.add(measureObj);
			}
		}
	}
	else
	{
		measureObj = new JSONObject();
		measureObj.put("valueField","-1");
		measureObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
		measNameArr.add(measureObj);
	}

	rootJson.put("measNameArr",measNameArr);

	if (mode.equals("reupload"))
	{
		String scriptName = request.getParameter("scriptName");
		if (!StringUtils.isNull(strOSName))
		{
			rootJson.put("selectedOSName",strOSName);
		}

		if (!StringUtils.isNull(scriptName))
		{
			String scriptNameNoExt = scriptName;
			if (scriptName.indexOf(".") != -1)
			{
				scriptNameNoExt = scriptNameNoExt.substring(0,scriptNameNoExt.lastIndexOf("."));
			}

			String showTestAndMeasure = scriptNameNoExt;
			String showTestName = "";
			rootJson.put("internalMeasName",scriptNameNoExt);

			if (scriptNameNoExt.indexOf("_") != -1)
			{
				String internalMeasureName = scriptNameNoExt.substring(scriptNameNoExt.indexOf("_")+1);
				String internalTestName = scriptNameNoExt.substring(0,scriptNameNoExt.indexOf("_"));

				String strDispTestName = _mapping.getTestDescription(internalTestName);
				String strDispMeasureName = _mapping.getMeasureDescription(internalTestName,internalMeasureName);

				showTestAndMeasure = strDispMeasureName;
				showTestName = strDispTestName;
			}
			else
			{
				showTestName = _mapping.getTestDescription(showTestAndMeasure);
				showTestAndMeasure = "All measures";
			}

			rootJson.put("measureName",showTestAndMeasure);
			rootJson.put("existScriptName",scriptName);
			rootJson.put("existTestName",showTestName);
		}

	}
	// specific tests for component type
	String componentType  = request.getParameter("componentType");
	String tName  = request.getParameter("tName");
	if (!StringUtils.isNull(componentType) && !StringUtils.isNull(tName))
	{
		
		JSONArray componentTypeArr = new JSONArray();
		JSONObject componentTypeObj = new JSONObject();
		JSONArray tNameArr = new JSONArray();
		JSONObject tNameObj = new JSONObject();
		tNameObj.put("valueField",tName);
		tNameObj.put("displayField",_mapping.getTestDescription(tName));
		tNameArr.add(tNameObj);
		rootJson.put("tNameArr",tNameArr);
		if (componentType == "All")
		{
			componentTypeObj.put("valueField",componentType);
			componentTypeObj.put("displayField",_mapping.getTextDescription("admin.common.All"));
			componentTypeArr.add(componentTypeObj);
		}
		else
		{
			componentTypeObj.put("valueField",componentType);
			componentTypeObj.put("displayField",_mapping.getComponentTypeDescription(componentType));
			componentTypeArr.add(componentTypeObj);
		}
		rootJson.put("componentTypeArr",componentTypeArr);
	}
	hiddenParams.put("comeFrom","ExtJsAdmin");
	hiddenParams.put("correctiveActions","true");
	rootJson.put("hiddenParams",hiddenParams);
	out.println(rootJson.toString());
%>



