<%
/*************************************************************************************************/
/*                 Name          : EgAutoTopologyGroup.jsp                                       */
/*                 Purpose       : This page is used to list components under a group            */
/*                 Version       : 5.7                                                           */
/*                 Created On    : 10-05-2012                                                    */
/*************************************************************************************************/
%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgGroupInfo"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgComponentType"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<html>
<head>
<title>Group Details</title>
<egui:skin ui="admin"/>
<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
<script  src="/final/jquery/jquery.js"></script>
<script  src="/final/jquery/ui/jquery.ui.core.js"></script>

<script type="text/javascript">
var $j = jQuery.noConflict();

$j(document).ready(function(){
	checkNull();
});

function checkNull()
{
	var rowValues = document.getElementById("rowValues");
	if(rowValues==null)
	{
		//$j("#segRow").show();
		$j("#add").hide();
		$j("#assignMore").hide();
		$j("#hostRow").hide();
		//$j("#newCompRow").show();

		var noGrp = document.getElementById("noGroup");
		var option = $j("input[name='changeGroup']:checked").val();
		if(option=="oldgroup" && noGrp!=null)
		{
			$j(".rowClass").hide();
		}
		else if(option=="newgroup")
			$j(".rowClass").show();
	}
	else
	{
		$j("#segRow").hide();
		$j("#add").show();
		$j("#assignMore").show();
		$j("#hostRow").show();
		$j(".rowClass").show();
		
	}
	var newCompValues = document.getElementById("newCompValues");
	var segRow = document.getElementById("segRow");
	if(newCompValues==null)
	{
		$j("#newCompRow").hide();
		$j("#newCompHeaderRow").hide();
		$j("#manageButton").hide();
		$j("#groupNew").attr('disabled',false);
		//$j("#Modifygroup").attr('disabled',false);
		//$j("#Addgroup").attr('disabled',false);
		var noGrp = document.getElementById("noGroup");
		var option = $j("input[name='changeGroup']:checked").val();
		if(option=="oldgroup" && noGrp!=null)
		{
			$j(".rowClass").hide();
		}
		//if(segRow!=null)
			//$j('#segRow').show();
	}
	else
	{
		$j("#newCompRow").show();
		$j("#newCompHeaderRow").show();
		$j("#manageButton").show();
		$j("#groupNew").attr('disabled',true);
		//$j("#Modifygroup").attr('disabled',true);
		//$j("#Addgroup").attr('disabled',true);
		$j(".rowClass").show();
		$j('#segRow').hide();
	}
	if(rowValues==null && newCompValues==null)
	{
		$j("#add").hide();
		$j("#assignMore").hide();
		$j("#hostRow").hide();
		$j("#rowValues").hide();
		$j("#newCompHeaderRow").hide();
		$j("#manageButton").hide();
		if(segRow!=null)
			$j('#segRow').show();
	}
	if(rowValues!=null && newCompValues!=null)
	{
		$j("#groupNew").attr('disabled',false);
		$j("#add").show();
		$j("#assignMore").show();
		$j("#hostRow").show();
		$j("#rowValues").show();
		$j("#newCompHeaderRow").hide();
		$j("#newCompValues").show();
		$j("#manageButton").hide();
		$j("input[name='newchkbox']").attr("disabled",true);
		$j(".optiontd").show();
		$j(".porttd").hide();
	}
}
</script>
</head>
<%
	String segment = request.getParameter("segment");
	String zone = request.getParameter("zone");
	String src = request.getParameter("src"); //componentType
	String comp = request.getParameter("comp"); //componentName
	String option = request.getParameter("option");
	String selectedComponent = request.getParameter("selectedComponent");
	String status = request.getParameter("compStatus");
	String compStatus="";
	if(status!=null && status.length()>0)
	{
		compStatus=status;
	}
	boolean newStatus=false;
	if(compStatus.equals("NEW") || compStatus.equals("UNMANAGE"))
	{
		newStatus=true;
	}

	Hashtable grpElementTable = (Hashtable)session.getAttribute("autoTopoGroupTable");
	boolean otherSegment=false;
	IniFile egTopoIni =  new IniFile(EgInstallInfo.getInstallDir() + 
															"/manager/config/eg_topology.ini");
	String segmentNames[] = egTopoIni.getVariables("TOPOLOGY_SEGMENTS");
	
	boolean isNewGroup = false;
	EgGroupInfo groupInfo = new EgGroupInfo();
	String[] allGroupNames=null;
	ArrayList myList = new ArrayList();
	ArrayList tempList = new ArrayList();

	ArrayList disabledList = new ArrayList();
	IniFile autoIniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini");
	
	if(zone!=null && !zone.equals("-1"))
	{
		TreeSet mySet =  groupInfo.getAllGroupsUnderZone(zone, true);
		if(mySet!=null && mySet.size() > 0)
		{
			myList.addAll(mySet);
			for(int m=0;m<myList.size();m++)
			{
				String fullName = (String)myList.get(m);
				fullName=fullName.substring(fullName.indexOf(":")+1,fullName.lastIndexOf(":"));
				tempList.add(fullName);
			}
			allGroupNames = new String[tempList.size()];
			for (int a = 0; a < tempList.size(); a++) 
			{
				allGroupNames[a] = tempList.get(a).toString();
			}
		}
	}
	else
	{
		allGroupNames = groupInfo.getGroupNames();
	}
	if(option!=null && option.equals("newgroup"))
		isNewGroup = true;
%>
<input type="hidden" id="isNewGroup" name="isNewGroup" value="<%=isNewGroup%>">
<input type="hidden" id="src" name="src" value="<%=src%>">
<input type="hidden" id="comp" name="comp" value="<%=comp%>">
<input type="hidden" id="segment" name="segment" value="<%=segment%>">
<input type="hidden" id="zone" name="zone" value="<%=zone%>">

<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" class="white_bg">
<div id ="loading_image" style = "position:absolute;top:100px;left:150px;visibility:visible;display:none;border:0px solid #ff0000;"> 
	<table height="100%">
		<tr>
			<td height="100%" valign="middle"> 
				<img src='/final/admin/eg_images/indicator_medium.gif'>
			</td>
		</tr>
	</table>
</div>
<table border="0" cellspacing="0" cellpadding="0" align="center" width="100%">
<%
	ArrayList managedCompList = new ArrayList();
	managedCompList = getManagedComponents(segment);
	//ArrayList newCompList = getNewComponents(segment);

	boolean isNewCompExists = false;
	boolean isUnManageExists = false;
	ArrayList newCompList = new ArrayList();
	ArrayList unManageList = new ArrayList();
	Hashtable myTable = getUnmanageAndNewComponents(segment);
	newCompList = (ArrayList) myTable.get("NEW");
	unManageList = (ArrayList) myTable.get("UNMANAGE");
	//if(unManageList!=null && unManageList.size() > 0)
		//isUnManageExists = true;

	for(int n=0;n<unManageList.size();n++)
	{
		String unManageComp = (String)unManageList.get(n);
		if(!newCompList.contains(unManageComp))
			newCompList.add(unManageComp);
	}
	if(newCompList!=null && newCompList.size() > 0)
		isNewCompExists = true;

	boolean groupFound=false;
	if(isNewGroup)
	{
		groupFound = true;
	}
	else
	{
		if(allGroupNames!=null && allGroupNames.length > 0)
		{
			groupFound=true;
		}
		else
		{
			groupFound=false;
%>		
		<tr id="noGroup">
			<td width="100%" height="100%" >
				<table  cellspacing="0" cellpadding="0" width="100%" border="0" align="center">
					<tr>
						<td width="100%" height="100%" align="center" valign="middle"> <img src="eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br><egui:intnl text="No group(s) are found!"/>
						</td>
					</tr>
				</table>
			</td>
		</tr>
<%
		}
	}
	if(groupFound)
	{
%>		
	<tr>
		<td>
			<div id="scrollDiv" style="width:100%;border:0px solid #ff0000;">
				<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table-layout:fixed;" id="tb1"><col width="7%"><col width="50%"><col width="30%">
					<tr id="hostRow">
						<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px">
						<input type="checkbox" class="chk" id="checkbx" name="checkbx" onclick="javascript:selectAll();"/></td>
						<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><b><egui:intnl text="admin.servers.Host / Nick Name"/></b></td>
						<td class="porttd" id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><b><egui:intnl text="admin.servers.Port"/></b></td>
						<td class="optiontd" id="eg_subheadbg" style="display:none" height="22" align="center" style="border-left-width:1px"><b><egui:intnl text="admin.servers.Port/Option"/></b></td>
					</tr>
<%
				Hashtable segmentHash = new Hashtable();
				ArrayList otherSegCompList = new ArrayList();
				
				//  to make elements checked 
				ArrayList newList=new ArrayList();
				ArrayList keyList1=new ArrayList();
				if(grpElementTable!=null && grpElementTable.size()>0)
				{
					Enumeration allKeys1 = grpElementTable.keys();
					while(allKeys1.hasMoreElements())
					{
						String groupKey1 = (String)allKeys1.nextElement();
						if(!keyList1.contains(groupKey1))
							keyList1.add(groupKey1);
					}
					for(int k=0;k<keyList1.size();k++)
					{
						String key1 = (String)keyList1.get(k);
						ArrayList groupList1 = (ArrayList)grpElementTable.get(key1);
						for(int l=0;l<groupList1.size();l++)
						{
							String gg = (String)groupList1.get(l);
							newList.add(gg);
						}
					}
				}
				//end
				for(int k=0;k<managedCompList.size();k++)
				{
					String otherSegName="";
					String disabled="";
					String checked ="";
					String element = (String) managedCompList.get(k);
					if(segmentNames!=null){
						for(int s=0;s<segmentNames.length;s++)
						{
							String allSegments = (String)segmentNames[s];
							if(!allSegments.equals(segment))
							{
								String[] aLines = egTopoIni.getLinesUnderSubject(allSegments);
								if(aLines!=null){
									for(int a=0;a<aLines.length;a++)
									{
										String line = (String)aLines[a];
										if(line.indexOf(element)>-1)
										{
											otherSegName = allSegments;
											if(segmentHash.containsKey(otherSegName))
											{
												ArrayList list = (ArrayList) segmentHash.get(otherSegName);
												list.add(element);
												segmentHash.put(otherSegName,(ArrayList)list);
											}
											else
											{
												ArrayList list = new ArrayList();
												list.add(element);
												segmentHash.put(otherSegName,(ArrayList)list);
											}
											if(!otherSegCompList.contains(element))
												otherSegCompList.add(element);
										}
									}
								}
							}
						}
					}
					StringTokenizer st = new StringTokenizer(element,":");
					int count = st.countTokens();
					String compType = "";
					String hostName = "";
					String portNo = "";
					String sid = "-";
					boolean isOraServer = false;
					if(count == 3)
					{
						compType = st.nextToken();
						hostName = st.nextToken();
						portNo = st.nextToken();
					}
					else if(count == 4)	// Only for Oracle_Database Component
					{
						compType = st.nextToken();
						hostName = st.nextToken();
						portNo = st.nextToken();
						sid = st.nextToken();
						isOraServer = true;
					}
					if(newList!=null && newList.contains(element))
					{
						checked="checked";
					}
					if(portNo.equals("NULL"))
						portNo ="-";

					if(!otherSegCompList.contains(element))
					{
						if(selectedComponent!=null && !selectedComponent.equals(""))
						{
							if(compType.equals(selectedComponent))
							{
								//checked="checked";
%>				
						<tr id="rowValues">
							<td id="cell_border4" align="center" class="head_padding3" style="border-left-width:0px"><input type="checkbox" class="eg_input" name="chkbox" id="chkbox" class="case" value="<%=element%>" onclick="javascript:checkRows();" <%=checked%> ></td>
							<td id="cell_border4" align="left" class="left_space10"><b><%=hostName%>&nbsp;<%=isOraServer?"("+sid+")":""%></b></td>
							<td id="cell_border4" align="center"><%=portNo%></td>
						</tr>
<%							}
						}
					}
				}
%>
				</table>
			
<%		if(segmentHash!=null && segmentHash.size()>0)
		{
			Enumeration keys = segmentHash.keys();
			while(keys.hasMoreElements())
			{
				String seg = (String)keys.nextElement();
				ArrayList componentList = (ArrayList)segmentHash.get(seg);
				for(int s=0;s<componentList.size();s++)
				{
					String compList = (String)componentList.get(s);
					if(compList.indexOf(selectedComponent)!=-1)
					{
%>				
				<table cellspacing="0" cellpadding="0" width="100%" border="0">
					<tr id="segRow" style="display:none">
						<td width="100%" height="100%" >
							<table  cellspacing="0" cellpadding="0" width="100%" border="0" align="center">
								<tr>
									<td width="100%" height="100%" align="center" valign="middle" style="padding:0px"> <img src="eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br><egui:intnl text="admin.error.The selected component(s) is associated to the "/>
									<egui:intnl text="admin.common.Segment" />&nbsp;
									<%=seg%>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>

<%					}
				}
			}
		}
		//to display new components
		if(!managedCompList.contains(selectedComponent) && isNewCompExists)
		{
%>			
				<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" 								style="table-layout:fixed;">
					<tr>
						<td>
							<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" 								style="table-layout:fixed;">
								<col width="7%"><col width="50%"><col width="30%">
								<tr id="newCompHeaderRow" style="display:none">
									<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><input type="checkbox" name="newcheckbx" onclick="javascript:newCompSelect();"/></td>
									<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><b><egui:intnl text="admin.common.Component name"/></b></td>
									<td id="eg_subheadbg" height="22" align="center" style="border-left-width:1px"><b><egui:intnl text="admin.common.Option"/></b></td>
								</tr>
<%	
						for(int k=0;k<newCompList.size();k++)
						{
							String element = (String) newCompList.get(k);
							StringTokenizer st = new StringTokenizer(element,":");
							int count = st.countTokens();
							String compType = "";
							String hostName = "";
							String portNo = "";
							String sid = "-";
							boolean isOraServer = false;
							if(count == 3)
							{
								compType = st.nextToken();
								hostName = st.nextToken();
								portNo = st.nextToken();
							}
							else if(count == 4)	// Only for Oracle_Database Component
							{
								compType = st.nextToken();
								hostName = st.nextToken();
								portNo = st.nextToken();
								sid = st.nextToken();
								isOraServer = true;
							}
							String title=hostName+":"+portNo;
							if(compType.equals(selectedComponent))
							{
%>							
								<tr id="newCompValues" style="diplay:none">
									<td id="cell_border4" align="center" class="head_padding3" style="border-left-width:0px"><input type="checkbox" class="eg_input" id="newchkbox" name="newchkbox" class="case" value="<%=element%>"  onclick="javascript:checkRowsNew();"></td>
									<td id="cell_border4" align="left" class="left_space10" height="25px"><b><%=hostName%>&nbsp;<%=isOraServer?"("+sid+")":""%>:<%=portNo%></b></td>
									<td id="cell_border4" align="center"class="head_padding3" height="25px">
									<input type="button" align="center" style="height: 18px;position:relative;z-Index:100;" name="updateImg" class="eg_back" value='<egui:intnl text="admin.servers.Add / Manage"/>' onClick="javascript:openManageComp('<%=element%>');">
									</td>
								</tr>

<%							}
						}
%>							</table>
						</td>
					</tr>
				</table>
<%		}
%>
			</div>
		</td>
	</tr>
<%		
	}
	
%>
</table>
</body>
</html>


<%!
	/*
		This method returns, list of managed components form the given segment name
	*/
	private ArrayList getManagedComponents(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		String disIniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		IniFile disIniFile = new IniFile(disIniFilePath);
		ArrayList result = new ArrayList();
		Set thisSet = new TreeSet();
		String[] varArray = iniFile.getVariables(segmentName);

		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String thisCompName = varName.substring(0,varName.indexOf(":"));
			String checkValue = disIniFile.getValue(thisCompName,varName);
			if(checkValue!=null && checkValue.length() > 0){
				thisSet.add(varName);
			}
			
			String valName = iniFile.getValue(segmentName,varName);
			if(valName!=null && valName.equals("null"))
				continue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens()){
				String tok = st.nextToken();
				String tmpcompname = tok.substring(0,tok.indexOf(":"));
				String tmpvar = tok.substring(0,tok.lastIndexOf(":"));
				String chkval = disIniFile.getValue(tmpcompname,tmpvar);
				if(chkval!=null && chkval.length() > 0){
					thisSet.add(tmpvar);
				}
			}
		}
		if(thisSet!=null && thisSet.size() > 0){
			result = new ArrayList(thisSet);
		}
		return result;
	}

	private Hashtable getUnmanageAndNewComponents(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		String disIniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		IniFile disIniFile = new IniFile(disIniFilePath);
		String newstr = "#New|";
		String unmanagestr = "#Unmanage|";
		
		Hashtable result = new Hashtable();
		ArrayList newList = new ArrayList();
		ArrayList unmanageList = new ArrayList();
		Set newSet = new TreeSet();
		Set unmanageSet = new TreeSet();

		String[] varArray = iniFile.getVariables(segmentName);

		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String thisCompName = varName.substring(0,varName.indexOf(":"));
			String newValue = disIniFile.getValue(thisCompName,newstr+varName);
			if(newValue!=null && newValue.length() > 0)	// Check for new component
			{
				newSet.add(varName);
			}
			else	// Check for unmanage component
			{
				String unmanageValue = disIniFile.getValue(thisCompName,unmanagestr+varName);
				if(unmanageValue!=null && unmanageValue.length() > 0)
				{
					unmanageSet.add(varName);
				}
			}

			String valName = iniFile.getValue(segmentName,varName);
			if(valName!=null && valName.equals("null"))
				continue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();
				String tmpcompname = tok.substring(0,tok.indexOf(":"));
				String tmpvar = tok.substring(0,tok.lastIndexOf(":"));
				String newval = disIniFile.getValue(tmpcompname,newstr+tmpvar);
				if(newval!=null && newval.length() > 0)
				{
					newSet.add(tmpvar);
				}
				else
				{
					String unmanageValue = disIniFile.getValue(tmpcompname,unmanagestr+tmpvar);
					if(unmanageValue!=null && unmanageValue.length() > 0)
					{
						unmanageSet.add(tmpvar);
					}
				}
			}
		}

		if(newSet!=null && newSet.size() > 0)
			newList = new ArrayList(newSet);
		if(unmanageSet!=null && unmanageSet.size() > 0)
			unmanageList = new ArrayList(unmanageSet);
		result.put("NEW" , newList);
		result.put("UNMANAGE" , unmanageList);
		return result;
	}
%>