<%
/*******************************************************************************
 *	Name		:	EgConfigTest.jsp
 *	Purpose	:	Configure Test Topology
 *	Version	:	0.1
 *	CreationDate :	24/08/2000
 *	Last Modified:
			8/07/2008	rameshkb	To configure value for specific Descriptor
 *			28/07/2004	Arun		Oracle-specific tests could not be configured because of an incorrect
 *									indexOf(":"). Add support for isCitrix.
 *			15/07/2004	Arun		Tests can be excluded without configuring them first.
 *			14/07/2004	Arun		HOST field was not displayed as it satifies condition for
 *									indexOf("os") and was included as a hidden field.
 *			09/07/2004	Arun		Moved javascript validation to /final/eg_scripts/eg_configtest.js
 *			22/06/2004	Arun		Weblogic tests have use a "server" parameter which is also used by
 *									the JSP to send the server type. Change the query parameter to
 *									typeOfServer to remove ambiguity.
			06/02/2004 //Saravanan Validation change for ProcessTest.
			14/01/2004	Arun	Removes :NULL from server names while including/excluding servers
			12/01/2004 //Saravanan AlarmType display for corrective actions changed.
			09/01/2004 //Saravanan + allowed for eventsrc in EventLogTest
			03/01/2004 //Saravanan URL Decoded before showing in textarea
			29/12/2003	Arun	Removes :NULL from server names
			6/08/2003 //gopi & saravanan apply confign to similar servers
			24/07/2003 Allowing DD Disable by checking normal and bad frequencies of DD
							and hyphen check for textfield
			20/07/2003 //gopi - DD disable test option
			01/07/2003 //saravanan - Textarea pop-up
			01/07/2003 //saravanan - Applying common configurations for similar servers
			15/05/2003 //saravanan - Common password policy
			14/03/2003 //sandhya - Call EJB tests dynamically
			14/01/2003 //sandhya - Nickname change
			06/12/2002 //sandhya - Allow comma
			08/11/2002 //sandhya - Validation for search
			15/10/2002 //sandhya - Validation for mCount,SNMP Port(WebLogicTest) and EventSrc/EventHost(EventLogTest)
			18/09/2002 //kk - Validation for ProcessPoolTest
			20/08/2002 //sandhya - Validation for sendUser,receiveUser,fromId and toId
			01/08/2002 //sandhya - To allow '&' and '.' in WinServiceTest
			13/07/2002 //Additional features for HttpTest
			11/07/2002 //sandhya - Fixed SID not configured bug for DiskTest
			08/07/2002 //sandhya - To allow multiple urls separated by comma and allow '&' as a part of url. DnsTest(Targets and Recursive)
			28/05/2002 //sandhya - Password validation
			07/05/2002 //kk - Modified version
			27/03/2002 //sandhya - Encrypt/Decrypt
			26/03/2002 //sandhya - Enable SSl
			28/02/2002 //sandhya - Validation for url
			19/02/2002 //sandhya - Validation for HOST
			18/10/2001 //sandhya - postarguments can have '&'.
			12/10/2001 //sandhya - to check for SID in oracle_server. if sid is not given, give an alert message saying "SID not configured" postarguments can have '='. '=' removed from special characters list.
			28/09/2001 //sandhya - added a parameter(version=null) to be passed to EgDbUserCreation.This parameter is used to check the different versions of Oracle
			24/08/2001 //sandhya - To display '*' for fields which have $sign.
			20/08/2001 //sandhya - To allow '~' for FtpTest(remotefile) and HttpTest(cookiefile).
			11/08/2001 //sandhya - validation for space(hostname and password)
			20/06/2001 //Sandhya - To allow "\" and ":" in remotefile & localfile
						- validation for FtpTest(-cmd to accept only get or put values).
			19/06/2001 //Sandhya - ip address validation for host.
			18/06/2001 //Sandhya - To allow multiple serviceNames.
			12/06/2001 //Sandhya - To retrieve $serviceName with space from eg_agents.ini
			04/06/2001 //Sandhya - To check for ',' in serviceName in WinServiceTest
			18/05/2001 //Sandhya.K - To enter $serviceName of WinServiceTest with space i.e. $serviceName = World Wide Web
			17/05/2001 //Bala - To fix WinServiceTest
			16:05:2001 //Bala - Check if eg_agents.ini is not populated due to license
			22/03/2001 //Sandhya.K - To add protocol parameter in MailTest
						- To change pop3Host to receiveHost
						- To change pop3Port to receivePort
			19/03/2001 //Sandhya.K - Validations for MailTest
			03/03/2001 //Sandhya.K
			21/02/2001 //Sandhya.K - Validations
			15/11/2000  Modified by Bala & Sandhya
 *	Author		:	Sridevi.T & Sandhya.K

 *	Design Changes		:		Jaiwin
 ******************************************************************************/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.egurkha.*" %>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="com.eg.AgentConfig" %>
<%@ page import="com.eg.EgAgentInfo" %>
<%@ page import ="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.EgCrypt" %>
<%@ page import="com.eg.EgUtils" %>
<%@ page import="com.eg.EgDiscInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgExternalInfo" %>
<%@ page import="com.eg.EgURLDecoder" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="java.net.URLDecoder" %>
<%@ page import="java.net.URLEncoder" %>
<%@ page import="java.sql.*" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgServicesInfo" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ taglib prefix = "egui" uri ="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<!-- skm -->
<%@ page import = "com.eg.EgAggregateInfo" %>
<%@ page import = "com.egurkha.admin.AuditLogHashtable"%>
<%@ page buffer="32kb"%>
<jsp:useBean id="prgBean" scope="page" class="egurkha.EgTestParamBean"/>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	session.removeAttribute("auditLogHashtable");
	AuditLogHashtable auditLogHashtable = new AuditLogHashtable();
	com.eg.IniFile testIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
	List listMultipleUserSupportTest = Arrays.asList(testIniFile.getVariables("MULTIPLE_USERS"));
	// To configure value for specific Descriptor - 8/7/2008 - Ramesh KB - Start
	com.eg.IniFile specIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_specs.ini");
	String sub = "DESCRIPTOR_DETAILS";
	String tName = request.getParameter("t_name");
	String iniValue = specIniFile.getValue(sub,tName);
	ArrayList testList = new ArrayList();
	StringTokenizer sti = new StringTokenizer(iniValue,",");
	while (sti.hasMoreTokens())
	{
		testList.add(sti.nextToken());
	}
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	boolean flagValue = egSpecs.isInfoRelevantForTest(tName);
	// To configure value for specific Descriptor - 8/7/2008 - Ramesh KB - End

	// To configure value for virtual centers - Ramesh KB - Start
	String sub1 = "VIRTUAL_CENTER";
	String uiFile = "eg_services.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";
	IniFile testIniFile1 = new IniFile(s_iniFile_dir + uiFile);
	String[] allVCs = testIniFile1.getVariables(sub1);
	String[] allValues = testIniFile1.getLinesUnderSubject(sub1);
	ArrayList vCenter = new ArrayList();
	StringTokenizer stz = null;
	StringTokenizer stz1 = null;
	Hashtable allData = new Hashtable();
	Vector UName = new Vector();
	Vector UPass = new Vector();
	Vector SSL = new Vector();
	Vector isDis = new Vector();
	String un = "";
	String pw = "";
	String ssl = "";
	String isdis = "";
	String web = "";
	if (allValues!=null&&allValues.length>0)
	{
		for (int i=0;i<allValues.length;i++)
		{
			String str = allValues[i];
			stz = new StringTokenizer(str,"=");
			String s1 = stz.nextToken();
			String s2 = stz.nextToken();
			ArrayList up = new ArrayList();
			if (s2 != null)
			{
				stz1 = new StringTokenizer(s2,"#");
				ssl = stz1.nextToken();
				un = stz1.nextToken();
				pw = stz1.nextToken();
				isdis = stz1.nextToken();
				web = stz1.nextToken();
			}
			pw = EgCrypt.decrypt(pw);
			up.add(un);
			up.add(pw);
			up.add(ssl);
			up.add(web);
			allData.put(s1,up);
		}
	}
	String vc = "";
	vc = request.getParameter("vcIP");
	String uName = "";
	String uPass = "";
	String isSSlForEsx = "";
	String webPort = "";
	if (vc != null && !vc.equalsIgnoreCase("none"))
	{
		ArrayList content = (ArrayList)allData.get(vc);
		uName = (String)content.get(0);
		uPass = (String)content.get(1);
		isSSlForEsx = (String)content.get(2);
		webPort = (String)content.get(3);
	}
	if (allVCs != null && allVCs.length > 0)
	{
		vCenter = new ArrayList(Arrays.asList(allVCs));
	}
	// To configure value for virtual centers - Ramesh KB - End
%>

<html>
<head>

<script name="javascript">
var updationInProgress = "false";
var policyNameCheckFlag="true";
var policyName="";
var chan="";
var dup="true";
var plusButtonClicked="false";

function dailchange(qval,valins)
{
	if(qval.indexOf("&showtimemin=")>-1)
	qval=qval.substring(0,qval.indexOf("&showtimemin="));

	var dis="";
	if(valins=='hourly')
		dis="3600";
	else
		dis="86400";

	var dailyhour = window.location.href="EgConfigTest.jsp?"+qval+"&showtimemin="+valins+"&testperiod="+dis;
}

function viewbutton()
{
	chan="true";
}

function opp(queryinnng,striVal,from)
{
	chan = "true";
	var thisForm = document.topology;
	valu=thisForm.url.value;
	if(queryinnng.indexOf("&blur=")>0)
	{
		queryinnng=queryinnng.substring(0,queryinnng.indexOf("&blur="));
	}
	var a=thisForm.url.value;
	var b=new Array();
	if(a.indexOf(",")>0)
		b=a.split(",");
	else
		b[0] = a;
	for(var i=0;i<b.length;i++)
	{
		var c=b[i];
		dup="false";
		var cIndex = c.indexOf(":");
		if(cIndex <= 0)
		{
			alert('<egui:intnl text="admin.test.Please enter in this format name:url"/>');
			thisForm.url.focus();
			return;
		}
		c=c.substring(0,c.indexOf(":"));
		for(var j=i+1;j<b.length;j++)
		{
			var dupch=b[j];
			dupch=dupch.substring(0,dupch.indexOf(":"));
			if(c.toUpperCase() == dupch.toUpperCase())
			{
				chan = "false";
				alert('<egui:intnl text="admin.test.Please enter different name"/>');
				thisForm.url.focus();
				return;
			}
			else
			{
				dup="false";
			}
		}
	}
	if(chan=="true" && dup=="false")
	{
		if(valu!= striVal)
		{
			thisForm.method = "post";
			thisForm.action = "EgConfigTest.jsp?"+encodeURI(queryinnng)+"&blur=true";
			thisForm.submit();
		}
		/*
		else
		{
			if(queryinnng.indexOf("&home=")>0)
				queryinnng=queryinnng.substring(0,queryinnng.indexOf("&home="));
			var well1 = window.location.href="EgConfigTest.jsp?"+encodeURI(queryinnng)+"&blur=true&url="+valu+"&home="+valu;
		}
		*/
	}
	chan="false";
}

function error(name)
{
	if(name!="displayMesPopup")
	{
		if(policyName=="")
			policyName=name;
		else
			policyName=policyName+","+name;
	}
	else
		alert('<egui:intnl text="admin.test.This Policy is not available! Please create the policy before you update"/>');
}

function PolicyFilterEnabled(value,query)
{
	var testPeriod = document.topology.testperiod.value;
	var useWmi = "";
	if (document.topology.useWmi != null && document.topology.useWmi != undefined)
	{
		if (document.topology.useWmi[0].checked)
		{
			useWmi = document.topology.useWmi[0].value
		}
		else if(document.topology.useWmi[1].checked)
		{
			useWmi = document.topology.useWmi[1].value
		}
	}
	var query1;
	if(query.indexOf("&policyFlag=")>0)
		query1=query.substring(0,query.indexOf("&policyFlag="));
	else
		query1=query;
	window.location.href="EgConfigTest.jsp?"+encodeURI(query1)+"&policyFlag="+value+"&testperiod=" + testPeriod+"&useWmi=" + useWmi;
}

function Policyadd()
{
	document.topology.filter.value="";
	for(i=0; i<document.topology.polic.options.length; i++)
	{
		if(document.topology.polic.options[i].selected)
		{
			if(document.topology.filter.value=="")
				document.topology.filter.value=document.topology.polic.options[i].value;
			else
				document.topology.filter.value=document.topology.filter.value+";"+document.topology.polic.options[i].value;
		}
	}
}

function config_popup(theURL,winName,features)
{
	plusButtonClicked = "true";
	if(!window.vmgWindow)
	{
		vmgWindow=open(theURL,winName,features);
	}
	else
	{
		if(!vmgWindow.closed)
		{
			vmgWindow.close();
			vmgWindow = open(theURL,winName,features);
			vmgWindow.focus();
		}
		else
		{
			vmgWindow=open(theURL,winName,features);
		}
	}
}

function checkMode(value,query)
{
	var strQuery = query;
	if (query.indexOf("&mode=") > 0)
	{
		strQuery = query.substring(0,query.indexOf("&mode="));
	}
	strQuery = strQuery + "&mode=" + value;
	window.location.href = "EgConfigTest.jsp?" + encodeURI(strQuery);
}

function checkProfiler(value,query)
{
	var strQuery = query;
	if (query.indexOf("&profiler=") > 0)
	{
		strQuery = query.substring(0,query.indexOf("&profiler="));
	}

	var mode = "";
	if (document.topology.mode[0].checked)
	{
		mode = document.topology.mode[0].value
	}
	else if(document.topology.mode[1].checked)
	{
		mode = document.topology.mode[1].value
	}

	var testPeriod = document.topology.testperiod.value;
	var host = document.topology.host.value;
	var port = document.topology.port.value;
	strQuery = strQuery + "&profiler=" + value + "&testperiod=" + testPeriod + "&host=" + host +"&port=" + port;
	if (mode=="false")
	{
		var Jmx_Remote_Port = document.topology.Jmx_Remote_Port.value;
		var user = document.topology.user.value;
		var password = document.topology.password.value;
		var cpwd = document.topology.cpwd.value;
		strQuery = strQuery + "&Jmx_Remote_Port=" + Jmx_Remote_Port + "&user=" + user + "&password=" + password + "&cpwd=" + cpwd;
	}
	else if (mode=="true")
	{
		var snmpversion = document.topology.snmpversion.value;
		var snmpPort = document.topology.snmpPort.value;
		var timeout = document.topology.timeout.value;
		strQuery = strQuery + "&version=" + snmpversion + "&snmpPort=" + snmpPort + "&timeout=" + timeout;
		if (snmpversion=="v1" || snmpversion=="v2")
		{
			var snmpCommunity = document.topology.snmpCommunity.value;
			strQuery = strQuery + "&snmpCommunity=" + snmpCommunity;
		}

		if (snmpversion=="v3")
		{
			var username = document.topology.username.value;
			var authpass = document.topology.authpass.value;
			//confirm password for authpass.
			var aucon = document.topology.aucon.value;
			var authtype = document.topology.authtype.value;
			if (document.topology.encryptflag[0].checked)
			{
				var encryptpassword = document.topology.encryptpassword.value;
				var encryptconfirmpassword = document.topology.encon.value;
				strQuery = strQuery + "&username=" + username + "&authPwd=" + authpass + "&con_pwd=" + aucon +
				"&authType=" + authtype + "&encryptFlag=yes&encryptpassword=" + encryptpassword + "&encon=" + encryptconfirmpassword;
			}
			else if(document.topology.encryptflag[1].checked)
			{
				strQuery = strQuery + "&username=" + username + "&authPwd=" + authpass + "&con_pwd=" + aucon +
				"&authType=" + authtype + "&encryptFlag=no";
			}
		}
	}

	window.location.href = "EgConfigTest.jsp?" + encodeURI(strQuery);
}

function checkHeap(value,query)
{
	var strQuery = query;
	if (query.indexOf("&javahome=") > 0)
	{
		strQuery = query.substring(0,query.indexOf("&javahome="));
	}

	var mode = "";
	if (document.topology.mode[0].checked)
	{
		mode = document.topology.mode[0].value
	}
	else if(document.topology.mode[1].checked)
	{
		mode = document.topology.mode[1].value
	}

	var testPeriod = document.topology.testperiod.value;
	var host = document.topology.host.value;
	var port = document.topology.port.value;
	strQuery = strQuery + "&javahome=" + value + "&testperiod=" + testPeriod + "&host=" + host +"&port=" + port;
	if (mode=="false")
	{
		var Jmx_Remote_Port = document.topology.Jmx_Remote_Port.value;
		var Jndi_Name = "";
		if (document.topology.Jndi_Name != null && document.topology.Jndi_Name != undefined)
		{
			Jndi_Name = document.topology.Jndi_Name.value;
		}
		var user = document.topology.user.value;
		var password = document.topology.password.value;
		var cpwd = document.topology.cpwd.value;
		strQuery = strQuery + "&Jmx_Remote_Port=" + Jmx_Remote_Port + "&Jndi_Name=" + Jndi_Name + "&user=" + user + "&password=" + password + "&cpwd=" + cpwd;
	}
	else if (mode=="true")
	{
		var snmpversion = document.topology.snmpversion.value;
		var snmpPort = document.topology.snmpPort.value;
		var timeout = document.topology.timeout.value;
		strQuery = strQuery + "&version=" + snmpversion + "&snmpPort=" + snmpPort + "&timeout=" + timeout;
		if (snmpversion=="v1" || snmpversion=="v2")
		{
			var snmpCommunity = document.topology.snmpCommunity.value;
			strQuery = strQuery + "&snmpCommunity=" + snmpCommunity;
		}

		if (snmpversion=="v3")
		{
			var username = document.topology.username.value;
			var authpass = document.topology.authpass.value;
			//confirm password for authpass.
			var aucon = document.topology.aucon.value;
			var authtype = document.topology.authtype.value;
			if (document.topology.encryptflag[0].checked)
			{
				var encryptpassword = document.topology.encryptpassword.value;
				var encryptconfirmpassword = document.topology.encon.value;
				strQuery = strQuery + "&username=" + username + "&authPwd=" + authpass + "&con_pwd=" + aucon +
				"&authType=" + authtype + "&encryptFlag=yes&encryptpassword=" + encryptpassword + "&encon=" + encryptconfirmpassword;
			}
			else if(document.topology.encryptflag[1].checked)
			{
				strQuery = strQuery + "&username=" + username + "&authPwd=" + authpass + "&con_pwd=" + aucon +
				"&authType=" + authtype + "&encryptFlag=no";
			}
		}
	}

	window.location.href = "EgConfigTest.jsp?" + encodeURI(strQuery);
}

var value = "";
function vc_onChange(qval)
{
	var testPeriod=document.topology.testperiod.value;
	if (qval.indexOf("&vcIP=") > 0)
	{
		qval=qval.substring(0,qval.indexOf("&vcIP="));
	}
	value=document.topology.virtual_center.options[document.topology.virtual_center.selectedIndex].value;
	if (value == 'Other')
	{
		openVCDetails(this.event,'<%=urlField%>');
	}
	else
	{
		window.location.href = "EgConfigTest.jsp?"+qval+"&vcIP="+value+"&testperiod="+testPeriod;
	}
}

var newDomainValue = "";
//for MultiUserSupportTest
var newAdminUserValue = "";
//for CtxAuthTest,TermAuthTest,WinAuthTest
var newUserValue = "";
function getUserValue(paramName)
{
	var thisForm = document.topology;
	if (paramName.toLowerCase() == "domain")
	{
		newDomainValue = thisForm.domain.value;
	}
	else if (paramName.toLowerCase() == "admin_user")
	{
		newAdminUserValue = thisForm.admin_user.value;
	}
	else if (paramName.toLowerCase() == "user")
	{
		newUserValue = thisForm.user.value;
	}
}

var changedDomainValue = "";
var changedAdminUserValue = "";
var changedUserValue = "";
function getUserChangedValue(paramName)
{
	var thisForm = document.topology;
	if (paramName.toLowerCase() == "domain")
	{
		changedDomainValue = thisForm.domain.value;
	}
	else if (paramName.toLowerCase() == "admin_user")
	{
		changedAdminUserValue = thisForm.admin_user.value;
	}
	else if (paramName.toLowerCase() == "user")
	{
		changedUserValue = thisForm.user.value;
	}
}

function checkMultipleUser(paramName,paramValue)
{
	var thisForm = document.topology;
	var multiUser = "false";
	if (paramName.toLowerCase() == "domain")
	{
		var domainValue = thisForm.domain.value;
		if (domainValue.indexOf(",") > -1)
		{
			multiUser = "true";
		}
	}
	else if (paramName.toLowerCase() == "admin_user")
	{
		var adminUserValue = thisForm.admin_user.value;
		if (adminUserValue.indexOf(",") > -1)
		{
			multiUser = "true";
		}
	}
	else if (paramName.toLowerCase() == "user")
	{
		var userValue = thisForm.user.value;
		if (userValue.indexOf(",") > -1)
		{
			multiUser = "true";
		}
	}

	if (multiUser == "true")
	{
		var orginalDomainValue = "";
		var orginalUserValue = "";
		if (plusButtonClicked == "true")
		{
			if (paramName.toLowerCase() == "domain")
			{
				var domainValue = thisForm.domain.value;
				if (domainValue != newDomainValue && domainValue.indexOf(",") > -1)
				{
					orginalDomainValue = newDomainValue;
				}
			}
			else if (paramName.toLowerCase() == "admin_user")
			{
				var adminUserValue = thisForm.admin_user.value;
				if (adminUserValue != newAdminUserValue && adminUserValue.indexOf(",") > -1)
				{
					orginalUserValue = newAdminUserValue;
				}
			}
			else if (paramName.toLowerCase() == "user")
			{
				var userValue = thisForm.user.value;
				if (userValue != newUserValue && userValue.indexOf(",") > -1)
				{
					orginalUserValue = newUserValue;
				}
			}
		}
		else
		{
			if (paramName.toLowerCase() == "domain")
			{
				var domainValue = thisForm.domain.value;
				if (domainValue != paramValue && domainValue.indexOf(",") > -1)
				{
					orginalDomainValue = paramValue;
				}
			}
			else if (paramName.toLowerCase() == "admin_user")
			{
				var adminUserValue = thisForm.admin_user.value;
				if (adminUserValue != paramValue && adminUserValue.indexOf(",") > -1)
				{
					orginalUserValue = paramValue;
				}
			}
			else if (paramName.toLowerCase() == "user")
			{
				var userValue = thisForm.user.value;
				if (userValue != paramValue && userValue.indexOf(",") > -1)
				{
					orginalUserValue = paramValue;
				}
			}
		}

		if (paramName.toLowerCase() == "domain")
		{
			var domainValue = thisForm.domain.value;
			if (domainValue != newDomainValue && domainValue.indexOf(",") > -1)
			{
				if (thisForm.testname != null && thisForm.testname.value != undefined)
				{
					if (thisForm.testname.value == "CtxAuthTest" || 
						thisForm.testname.value == "WinAuthTest" || 
						thisForm.testname.value == "TermAuthTest")
					{
						alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the USER text box or the \'Click here\' link above the test parameters to configure multiple domains and users'/>.");
					}
					else
					{
						alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the ADMIN USER text box or the \'Click here\' link above the test parameters to configure multiple domains and admin users'/>.");
					}
				}
				else
				{
					alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the USER text box or the \'Click here\' link above the test parameters to configure multiple domains and users'/>.");
				}
				if (changedDomainValue.indexOf(",") > -1)
				{
					thisForm.domain.value = changedDomainValue.substring(0,changedDomainValue.indexOf(","));
				}
				else
				{
					thisForm.domain.value = changedDomainValue;
				}
				tempField = thisForm.domain;
				setTimeout("tempField.focus()",0);
				return false;
			}
		}
		else if (paramName.toLowerCase() == "admin_user")
		{
			var adminUserValue = thisForm.admin_user.value;
			if (adminUserValue != newAdminUserValue && adminUserValue.indexOf(",") > -1)
			{
				alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the ADMIN USER text box or the \'Click here\' link above the test parameters to configure multiple domains and admin users'/>.");
				if (changedAdminUserValue.indexOf(",") > -1)
				{
					thisForm.admin_user.value = changedAdminUserValue.substring(0,changedAdminUserValue.indexOf(","));
				}
				else
				{
					thisForm.admin_user.value = changedAdminUserValue;
				}
				tempField = thisForm.admin_user;
				setTimeout("tempField.focus()",0);
				return false;
			}
		}
		else if (paramName.toLowerCase() == "user")
		{
			var userValue = thisForm.user.value;
			if (userValue != newUserValue && userValue.indexOf(",") > -1)
			{
				alert("<egui:intnl text='admin.test.Please use the encircled'/> '+' <egui:intnl text='admin.test.button adjacent to the USER text box or the \'Click here\' link above the test parameters to configure multiple domains and users'/>.");
				if (changedUserValue.indexOf(",") > -1)
				{
					thisForm.user.value = changedUserValue.substring(0,changedUserValue.indexOf(","));
				}
				else
				{
					thisForm.user.value = changedUserValue;
				}
				tempField = thisForm.user;
				setTimeout("tempField.focus()",0);
				return false;
			}
		}
	}
}

function checkHashTildeHash()
{
	var thisForm = document.topology;
	var multiUser = "false";

	if (thisForm.admin_user != null && thisForm.admin_user.value != undefined)
	{
		var adminUserValue = thisForm.admin_user.value;
		if (adminUserValue.indexOf(",") > -1)
		{
			multiUser = "true";
		}

		if (multiUser == "false")
		{
			var admin_passwordValue = thisForm.admin_password.value;

			if (!checkspecialnomess(admin_passwordValue,"\"|"))
			{
				alert("<egui:intnl text='admin.test.Password data should not contain pipe and double quotes' />");
				tempField = thisForm.admin_password;
				setTimeout("tempField.focus()",1);
				return false;
			}

			for(var k=0;k < admin_passwordValue.length;k++)
			{
				if(admin_passwordValue.charAt(k) == '#' && 
					admin_passwordValue.charAt(k + 1) == '~' && 
					admin_passwordValue.charAt(k + 2) == '#')
				{
					alert(_checkHashTildeHash);
					tempField = thisForm.admin_password;
					setTimeout("tempField.focus()",1);
					return false;
				}
			}
		}
	}
	else if (thisForm.user != null && thisForm.user.value != undefined)
	{
		var userValue = thisForm.user.value;
		if (userValue.indexOf(",") > -1)
		{
			multiUser = "true";
		}

		if (multiUser == "false")
		{
			var passwordValue = thisForm.password.value;

			if (!checkspecialnomess(passwordValue,"\",|"))
			{
				alert("<egui:intnl text='admin.test.Password data should not contain pipe, comma and double quotes' />");
				tempField = thisForm.password;
				setTimeout("tempField.focus()",1);
				return false;
			}

			for(var k=0;k < passwordValue.length;k++)
			{
				if (passwordValue.charAt(k) == '#' && 
					passwordValue.charAt(k + 1) == '~' && 
					passwordValue.charAt(k + 2) == '#')
				{
					alert(_checkHashTildeHash);
					tempField = thisForm.password;
					setTimeout("tempField.focus()",1);
					return false;
				}
			}
		}
	}
}

function InsideViewChange(value)
{
	var thisForm = document.topology;
	var domainValue = "";

	if (thisForm.domain != null && 
		thisForm.domain != undefined)
	{
		domainValue = thisForm.domain.value;
	}

	if (value == "tcp")
	{
		if (thisForm.domain != null && 
			thisForm.domain != undefined && 
			thisForm.domain.value == "$unconfigured")
		{
			thisForm.domain.value = "none";
		}

		if (thisForm.admin_user != null && 
			thisForm.admin_user != undefined && 
			thisForm.admin_user.value == "$unconfigured")
		{
			thisForm.admin_user.value = "none";
		}

		if (thisForm.admin_password != null && 
			thisForm.admin_password != undefined && 
			thisForm.admin_password.value == "$unconfigured")
		{
			thisForm.admin_password.value = "none";
		}

		if (thisForm.Admincpwd != null && 
			thisForm.Admincpwd != undefined && 
			thisForm.Admincpwd.value == "$unconfigured")
		{
			thisForm.Admincpwd.value = "none";
		}
	}
	else
	{
		if (thisForm.domain != null && 
			thisForm.domain != undefined && 
			thisForm.domain.value == "none")
		{
			thisForm.domain.value = "$unconfigured";
		}

		if (thisForm.admin_user != null && 
			thisForm.admin_user != undefined && 
			thisForm.admin_user.value == "none")
		{
			thisForm.admin_user.value = "$unconfigured";
		}

		if (thisForm.admin_password != null && 
			thisForm.admin_password != undefined && 
			thisForm.admin_password.value == "none")
		{
			thisForm.admin_password.value = "$unconfigured";
		}

		if (thisForm.Admincpwd != null && 
			thisForm.Admincpwd != undefined && 
			thisForm.Admincpwd.value == "none")
		{
			thisForm.Admincpwd.value = "$unconfigured";
		}
	}
}

function scrollWindow()
{
	window.scroll(0,500); // horizontal and vertical scroll targets
}
</script>
<script language="javascript" src="/final/admin/eg_scripts/ajaxutils.js" type="text/javascript"></script>
<title>Configure Tests</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<egui:skin ui = "admin"/>
<!-- <link rel="stylesheet" href="eg_styles/eg_adminstyle.css" /> -->

<%!
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	EgDiscInfo egDisc = new EgDiscInfo("manager");
	String strCheck = "";
	IniFile iniobj;
	IniFile testparamIni;
	Vector vecurl;
	int urlcount =0;
	int i;
	String count;
%>

<script language="JavaScript" src="eg_scripts/validate.js"></script>
<script language="JavaScript" src="eg_scripts/testvalidate.js"></script>
<script language="JavaScript" src="eg_scripts/eg_configtest.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
</head>

<body style="overflow:auto" id="space6" scroll="auto" onload="scrollWindow();" onunload="closeUploadWin();">

<%!String log=null;%>

<%
	IniFile  uiIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String[] testFormatPeriod = uiIni.getVariables("TEST_FREQUENCY");
	TreeMap periodMap = new TreeMap();
	if(!EgUtils.isNull((Object) testFormatPeriod))
	{
		for (int i=0;i<testFormatPeriod.length;i++)
		{
			String prdStr = uiIni.getValue("TEST_FREQUENCY", testFormatPeriod[i]);
			long lngVal = Long.parseLong(prdStr);
			periodMap.put(new Long(lngVal), testFormatPeriod[i]);
		}
	}

	//by anand - starts
	String hostEditableMode = uiIni.getValue("TEST_CONFIG_CONTROLS","hostEditable");
	String portEditableMode = uiIni.getValue("TEST_CONFIG_CONTROLS","portEditable");
	//by anand - ends

	EgRoleInfo ri=EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));//by JJ

	// int declarations
	int stCount = 0;
	String showAll=request.getParameter("showAll");
	String testinfo=request.getParameter("testinfo");
	//String Tokenizer declarations
	StringTokenizer st = null;

	//String Array declarations
	String homeval=request.getQueryString();
	String stringforurl="";
	String strIniVar[];
	String strSub[];
	String arrSubject[];
	String strVar[];

	//Vector declarations
	Vector vecThrow = new Vector();
	Vector vecFilter = new Vector();

	//For db optimization
	EgServicesInfo egserInfo = new EgServicesInfo("manager");
	Vector hostSysTests = new Vector();
	boolean uniqueHostSystemData = egserInfo.isUniqueHostSystemData();

	Hashtable hash = extInfo.getInternalAgentMap();

	//String declarations
	String previousUrl = "";
	String str_comp_type = "";
	String str_comp_name = "";
	String q_ctr = "";
	String r_ctr = "";
	String temp = "";
	String ss_tmp = "";
	String selected = "";
	String strIniVal = null;
	String strTemp = null;
	String strValue = null;
	String strVariable = null;
	String strServer = "";
	String serverName = "";
	String strTok = "";
	String strVal = "";
	String strExServer = "";
	String stringTemp = "";
	String stringVar = "";
	String stringVal = "";
	String junk = "";
	String s_painhost = "";
	String str_host_name = "";
	String strPars = "";
	String encodedValue = "";
	Vector vecVarPair = null;
	Vector vecValPair = null;
	Vector vecFilterVal=new Vector();
	Vector vecPolicyName=new Vector();

	//for tests which is mutiple user enabled
	boolean multiUserMode = false;

	//included for auditlog
	ArrayList ArrListPolicyName=new ArrayList();
	boolean isServerAgentless=false;
	int z;
	String policyName;
	StringTokenizer con_ston;
	String query=request.getQueryString();
	String authType=request.getParameter("authType");
	String snmpPort=request.getParameter("snmp_port");
	String u_name=request.getParameter("u_name");
	String authPwd=request.getParameter("authPwd");
	String conPwd=request.getParameter("con_pwd");
	String host=request.getParameter("host");
	String port=request.getParameter("port");
	String encryptFlag=request.getParameter("encryptFlag");
	String snmpVersion=request.getParameter("version");
	String borderfortd="formtop_border";
	String Evtflag="";
	String compNameForSelect = request.getParameter("compname");
	compNameForSelect = (compNameForSelect!=null?compNameForSelect:"");
	//This is made to be used in EgResults.jsp------Stlain 06/06/07-----------------
	session.setAttribute("qctr",request.getParameter("qctr"));
	session.setAttribute("rctr",request.getParameter("rctr"));
	session.setAttribute("showAll",request.getParameter("showAll"));
	session.setAttribute("compname",request.getParameter("compname"));
	session.setAttribute("comptype",request.getParameter("comptype"));
	session.setAttribute("from","configTests");
	//------------------------------------------------------------------------------
	q_ctr=request.getParameter("qctr");
	r_ctr=request.getParameter("rctr");
	if(request.getParameter("policyFlag")!=null)
		Evtflag=request.getParameter("policyFlag");

	encryptFlag=(encryptFlag != null && encryptFlag.length()>0)?encryptFlag:""; 
	snmpVersion=(snmpVersion != null && snmpVersion.length()>0)?snmpVersion:""; 

	if(query.indexOf("version")>-1)
		query=query.substring(0,query.indexOf("version")-1);
	String blur=request.getParameter("blur");
	if(blur==null)
		blur="false";
	String testName = request.getParameter("t_name");
	testName = (testName != null && testName.length()>0)?testName.trim():"";

	//boolean declarations.
	boolean b_isPortRelevantForTest = egSpecs.isPortRelevantForTest(testName);
	Enumeration e = request.getParameterNames();
	String qryString = request.getQueryString();
	String _str = "";
	String show="";
	if(request.getParameter("showAll")!=null)
		show=request.getParameter("showAll");
	else
		show="no";

	EgAgentInfo egagent = new EgAgentInfo("manager");
	AgentConfig agentconfig =  AgentConfig.getAgentConfig();

	if(e.hasMoreElements())
	{
		q_ctr = request.getParameter("qctr");
		r_ctr = request.getParameter("rctr");
		serverName=request.getParameter("typeOfServer");
		str_comp_type = serverName;
		_str = str_comp_type;
		strCheck = request.getParameter("t_name");

		if(q_ctr.equals("1"))
		{
			if(str_comp_type==null&&str_comp_type.equals(""))
			{
				str_comp_type=request.getParameter("comptype");
			}
			str_comp_name=request.getParameter("compname");
			strServer= request.getParameter("comptype");
		}

		//to get hostname if either reconfigure or exclude flags become 1
		if( r_ctr.equals("1") && q_ctr.equals("1"))
		{
			str_host_name = request.getParameter("hostname");
			strServer= request.getParameter("comptype");
		}
	}

	//Code to find if any other managed servers of same type as the host is present....Starts
	Vector v_servers = new Vector();
	
	prgBean.createFile("eg_discover.ini");
	String[] s_variables = prgBean.getVariables(strServer);
	String[] componentsList = ri.getAllServersOfType(serverName);
	boolean b_isotherserverspresent = false;

	if(str_host_name != null && !str_host_name.trim().equals(""))
	{
		for(int i=0;i<s_variables.length;i++)
		{
			if ((s_variables[i] != null) &&
				!(s_variables[i].trim().equals("")) &&
				!(s_variables[i].indexOf(str_host_name) > -1) &&
				!(s_variables[i].equals("Format:name")) &&
				!(s_variables[i].indexOf("#Unmanage") == 0) &&
				!(s_variables[i].indexOf("#New") == 0))
			{
				v_servers.addElement(s_variables[i]);
			}
		}

		if(v_servers.size() >0)
			b_isotherserverspresent = true;
	}

	//if(homeval.indexOf("&home=")>-1)
	//{
	//	homeval = StringUtils.replace(homeval.trim(),"~egHash~","#");
	//	homeval=homeval.substring(homeval.indexOf("&home=")+6);
	//	if(homeval.indexOf("&blur=")>-1)
	//	{
	//		homeval= homeval.substring(0,homeval.lastIndexOf("&blur="));
			//if(homeval.indexOf("&")>-1)
			//homeval= homeval.substring(0,homeval.lastIndexOf("&"));
	//	}
	//	stringforurl=homeval;
	//}

	String tempUrl = request.getParameter("url");
	tempUrl = (tempUrl == null)?"":tempUrl;
	if (tempUrl.length() > 0)
	{
		stringforurl = tempUrl;
	}
	//Code to find if any other managed servers of same type as the host is present....ends

	String remoteScript = request.getParameter("script");

	//skm
	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	Vector aggTypes = aggregateInfo.getAggregateTypes();
	List AggregateComponent=(ArrayList)aggregateInfo.getAssociatedComponent();

	String fromDashboard = request.getParameter("fromDashboard");
	String searchString = request.getParameter("searchString");
	boolean fromAdminDashboard = (fromDashboard!=null && fromDashboard.equals("true"));
	boolean isSearchResult = (searchString!=null && !searchString.equals("null") && !searchString.equals(""));
	if (!fromAdminDashboard && isSearchResult)
	{
		session.setAttribute("searchString",searchString);
	}

	String compname = "";
	if(r_ctr.equals("0"))
	{
		compname = request.getParameter("compname");
	}
	else if(r_ctr.equals("1"))
	{
		compname = request.getParameter("hostname");
	}

	prgBean.createFile("eg_agents.ini");
	strSub = prgBean.getSubject();
	boolean gotMatch = false;
	boolean isAutoConfiguration = false;
	for(int i=0; i<strSub.length; i++)
	{
		strIniVar = prgBean.getVariables(strSub[i]);
		String resultantPattern = "";
		List listAgentIniVariables = Arrays.asList(strIniVar);
		String specificPattern = testName+":"+serverName+":"+compname;
		String defaultPattern = testName+"::"+compname;
		if (listAgentIniVariables.contains(specificPattern))
		{
			resultantPattern = specificPattern;
			gotMatch = true;
		}
		else if (listAgentIniVariables.contains(defaultPattern))
		{
			resultantPattern = defaultPattern;
			gotMatch = true;
		}

		if(gotMatch)
		{
			strIniVal = prgBean.getStrValue(strSub[i],resultantPattern);
			String tempTestConfiguration = strIniVal.substring(0,strIniVal.indexOf(","));
			tempTestConfiguration = tempTestConfiguration.trim();
			if (tempTestConfiguration.equalsIgnoreCase("-auto"))
			{
				isAutoConfiguration = true;
			}
			Object obj[]=getIniVarValues(strIniVal);
			vecVarPair = (Vector)obj[0];
			vecValPair = (Vector)obj[1];
			break;
		}
	}

	if((!(str_comp_name.equals("undefined")) && q_ctr.equals("1")) || r_ctr.equals("1"))
	{
		if(r_ctr != null && r_ctr.equals("0"))
		{
			//Latest addition to check whether a section for this host exists in the eg_agents.
			//eg_agents violate integrity for the purpose of licensing...
			//If the number of components discovered by discovery exceeds the number of agents in the
			//license ... discovery will only write sections for the allowed number of servers.
			//To counter this we check if the section for that component exists in eg_agents... if not
			//display a message saying license problem

			String s_tmp_compname = compname;
			if(compname.indexOf(":") > 0)
			{
				s_tmp_compname = compname.substring(0,compname.indexOf(":"));
			}

			int jj = ArrayUtils.indexOf(strSub, s_tmp_compname);
			if (jj==strSub.length
				&& egSpecs.isTestInternal(testName, str_comp_type)
				&& !egSpecs.isAgentlessTest(testName, strServer))
			{
				Vector sess_vec = new Vector();
				sess_vec.addElement(_mapping.getTextDescription("admin.test.Configure Agents!"));
				sess_vec.addElement("EgStypeTlist.jsp?qctr=1&server=" + str_comp_type+"&showAll="+showAll);
				sess_vec.addElement(_mapping.getTextDescription("admin.test.Too many Agents!"));
				sess_vec.addElement(_mapping.getTextDescription("admin.test.You are exceeding the total number of agents permitted by your license!"));
				sess_vec.addElement(_mapping.getTextDescription("admin.test.To upgrade your license to support additional agents")+" ,");
				sess_vec.addElement(_mapping.getTextDescription("admin.error.please contact <b>license@eginnovations*com</b>"));
				session.setAttribute("vec_Errors",sess_vec);
%>
				<jsp:forward page="EgErrors.jsp"/>
<%
				return;
			}
		}

		if (StringUtils.isNull(strIniVal))
		{
			//This test is not enabled for execution at this point of time.
			//So trap it here and take the user to the tests list page.

			Vector sess_vec = new Vector();
			sess_vec.addElement(_mapping.getTextDescription("admin.test.Configure Agents!"));
			sess_vec.addElement("EgStypeTlist.jsp?qctr=1&server=" + serverName+"&showAll="+showAll);
			sess_vec.addElement(_mapping.getTextDescription("admin.test.Test not enabled!"));
			sess_vec.addElement(_mapping.getTextDescription("admin.test.This test is currently not available for configuration")+". ");
			sess_vec.addElement(_mapping.getTextDescription("admin.test.Please wait for the system configurations to be updated and try again after a few minutes")+".");
			session.setAttribute("vec_Errors",sess_vec);
%>
			<jsp:forward page="EgErrors.jsp"/>
<%
		}
	}

	/* code for ComponentsUnder ie. excluded servers listing */
	prgBean.createFile("eg_disable.ini");
	Vector vecExServ = new Vector();
	strTok = "";
	String subTestParam = null;
	if(b_isPortRelevantForTest)
	{
		subTestParam = str_comp_type;
	}
	else
	{
		subTestParam = "Default_server";
	}
	strVar = prgBean.getVariables(subTestParam);
	Vector allServersForGivenType1=ri.getServersForType(serverName); //lists the comptype:compname:port
	if(allServersForGivenType1 != null || !allServersForGivenType1.equals(""))
	{
		session.setAttribute("setw", allServersForGivenType1); //To get from EgResults.jsp
	}
	for(int j=0; j<strVar.length; j++)
	{
		if(strVar[j].startsWith(subTestParam+":")) // Change -- Srinivas
		{
			strVal = prgBean.getStrValue(subTestParam, strVar[j]);
			if(strVal.indexOf(strCheck)>=0)
			{
				// bug fix starts - dont rely on indexOf - go in and 
				// see if it is really strCheck thats in there -- Srinivas
				// Oct 19, 2004
				boolean found = false;
				st = new StringTokenizer(strVal,",");
				while (st.hasMoreTokens())
				{
					if (st.nextToken().trim().equalsIgnoreCase(strCheck))
					{
						found = true;
						break;
					}
				}
				if (found)
				// end bug fix -- Srinivas Oct 19, 2004
				{
					st = new StringTokenizer(strVar[j],":");
					stCount = st.countTokens();
					for(int m=0; m<stCount; m++)
					{
						stringTemp = st.nextToken();
						if(b_isPortRelevantForTest)
						{
							if(m==1 || m==2 || m==3)
							{
								strTok = strTok + stringTemp.trim() + ":";
							}
						}
						else
						{
							if(m==1)
							{
								// This fix is to avoid calling isPortRelevantForTest method - kk.
								strTok = stringTemp.trim() + ":";
							}
						}
					}
					strTok = strTok.substring(0,strTok.lastIndexOf(":"));
					if(vecExServ.contains(strTok)==false)
					{
						vecExServ.addElement(strTok);
					}
					/*// JJ
					for(int k=0;k<allServersForGivenType.size();k++)
					{
						String str=(String)allServersForGivenType.get(k);
						if(str.indexOf(strTok)!=-1)
						{
							vecExServ.addElement(strTok);
						}
					}
					//JJ*/
				}
			}
		}
		strTok = "";
	}

	Vector tempv=new Vector();
	String[] allServers = ri.getAllServersOfType(serverName);
	for(int j=0;j<allServers.length;j++)
	{
		String temps=allServers[j];
		StringTokenizer tempstt=new StringTokenizer(temps,":");
		if(tempstt.hasMoreTokens())
		{
			String sType = tempstt.nextToken();
			String tempto=tempstt.nextToken();
			if(b_isPortRelevantForTest)
			{
				if (sType.equalsIgnoreCase("Oracle_server"))
				{
					tempto=tempto+":"+tempstt.nextToken()+":"+tempstt.nextToken();
				}
				else
				{
					tempto=tempto+":"+tempstt.nextToken();
				}
			}
			else
			{
				tempstt.nextToken();
			}
			for(int k=0;k<vecExServ.size();k++)
			{
				if (tempto.equals(vecExServ.get(k)) && !tempv.contains(tempto))
				{
					tempv.add(tempto);
				}
			}
		}
	}
	vecExServ.clear();
	vecExServ.addAll(tempv);

	/* code for componentsunderegurkha i.e Configured Servers listing*/
	Vector vecConfigServ = new Vector();

	//Call EJB tests dynamically
	//prgBean.createFile("eg_specs.ini");
	//String testInfoPattern = prgBean.getStrValue("TEST_INFO_PATTERN", testName);
	//String testInfoDelimiter = prgBean.getStrValue("TEST_INFO_DELIMITER", testName);

	String testInfoPattern = egSpecs.getTestInfoPattern(testName);
	String testInfoDelimiter = egSpecs.getTestInfoDelimiter(testName);

	//String ejbValues = prgBean.getStrValue("CONFIG_FGENERIC_TESTS","EgConfigInfos.jsp");
	String ejbValues = egSpecs.getTestsInGroup("EgConfigInfos.jsp");
	Vector v_ejb_tests = new Vector();
	String[] values = StringUtils.getTokens(ejbValues, EgConstants.COMMA);
	for (int a=0; a<values.length; a++)
	{
		if (strCheck.equals(values[a]))
		{
			v_ejb_tests.add(values[a]);
			v_ejb_tests.add("EgConfigInfos.jsp");
		}
	}

	//if(ejbValues.indexOf(",") > -1)
	//{
	//	st = new StringTokenizer(ejbValues,",");
	//	while(st.hasMoreTokens())
	//	{
	//		strTok = st.nextToken();
	//		if(strTok.equals(strCheck))
	//		{
	//			v_ejb_tests.add(strTok);
	//			v_ejb_tests.add("EgConfigInfos.jsp");
	//		}
	//	}
	//}
	//else
	//{
	//	if(ejbValues.equals(strCheck))
	//	{
	//		v_ejb_tests.add(ejbValues);
	//		v_ejb_tests.add("EgConfigInfos.jsp");
	//	}
	//}

	//ejbValues = prgBean.getStrValue("CONFIG_FGENERIC_TESTS", "EgConfigEjb.jsp");
	ejbValues = egSpecs.getTestsInGroup("EgConfigEjb.jsp");
	values = StringUtils.getTokens(ejbValues, EgConstants.COMMA);
	for (int a=0; a<values.length; a++)
	{
		if (strCheck.equals(values[a]))
		{
			v_ejb_tests.add(values[a]);
			v_ejb_tests.add("EgConfigEjb.jsp");
		}
	}
	//End of new code

	//skm
	//String aggregateTests = egSpecs.getTestsInGroup("EgConfigAggregate.jsp");
	Vector v_agg_tests = new Vector();
	//String[] agg_Tests = StringUtils.getTokens(aggregateTests, EgConstants.COMMA);
	String[] agg_Tests = egSpecs.getTestsFromAggTestsSection();// thiru Wednesday, August 09, 2006	
	for (int i=0; agg_Tests !=null && i<agg_Tests.length; i++)
	{
		if (strCheck.equals(agg_Tests[i]))
		{
			v_agg_tests.add(agg_Tests[i]);
			v_agg_tests.add("EgConfigAggregate.jsp");
		}
	}
	//skm
	//String[] componentsType=EgConfigTopo.getAllSubjects();

	prgBean.createFile("eg_agents.ini");
	for(int j=0; j<componentsList.length; j++)
	{
		String s_serv = componentsList[j];
		String serverType=s_serv.substring(0,s_serv.indexOf(':'));
		if(testName!=null && testName.endsWith("_cf"))
		{
			if(AggregateComponent!=null && AggregateComponent.contains(serverType))
				continue;
		}

		if(s_serv.startsWith("Format:") || s_serv.startsWith("#")) continue;

		String tempComponent = s_serv.substring(s_serv.indexOf(":")+1,s_serv.length());
		String tempAgentName = getAgentNickName(serverName,tempComponent,strCheck);
		if (tempAgentName == null) continue;

		String[] testVariables = prgBean.getVariables(tempAgentName);
		String resultantPattern = getResultantPattern(serverName,tempComponent,strCheck,testVariables);
		if (resultantPattern == null) continue;

		String tempTestValue = prgBean.getStrValue(tempAgentName,resultantPattern);
		String tempTestConfigurationStatus = tempTestValue.substring(0,tempTestValue.indexOf(","));
		tempTestConfigurationStatus = tempTestConfigurationStatus.trim();

		int colonIndex = s_serv.indexOf(":");
		if(b_isPortRelevantForTest)
		{
			tempComponent = s_serv.substring(colonIndex+1);
		}
		else
		{
			if(serverName.equals("Oracle_server"))
			{
				tempComponent = s_serv.substring(colonIndex + 1);
				tempComponent = tempComponent.substring(0, tempComponent.indexOf(":"));
			}
			else
			{
				tempComponent = s_serv.substring(colonIndex + 1, s_serv.lastIndexOf(":"));
			}
		}
		tempComponent = tempComponent.trim();

		if (tempTestConfigurationStatus.equalsIgnoreCase("-auto"))
		{
			if(!vecFilter.contains(tempComponent) && !vecExServ.contains(tempComponent))
			{
				vecFilter.addElement(tempComponent);
			}
		}
		else
		{
			if(!vecConfigServ.contains(tempComponent) && !vecExServ.contains(tempComponent))
			{
				vecConfigServ.add(tempComponent);
			}
		}
	}

	//************* For DB Optimization**************************
	String testForServer[] = egSpecs.getTestsForServer ("Host_system");
	if (testForServer != null)
	{
		for (int i=0; i<testForServer.length; i++)
		hostSysTests.add(testForServer[i]);
	}
	if(uniqueHostSystemData &&  hostSysTests.contains(testName))
	{
		if(vecFilter != null && vecFilter.size() > 0)
		{
			for (int x=0;x<vecFilter.size();x++)
			{
				String st_comp = (String) vecFilter.get(x);
				String CompName = Server.getServerNameWithoutPort(st_comp, false);
				if (hash.containsKey(CompName))
				{
					vecFilter.removeElementAt(x);
					x--;
				}
			}
		}
	}

	//**********************************************************
	/* To remove similar configured servers records from component list*/
	vecFilter.removeAll(vecConfigServ);

	/* To remove similar excluded server records from component list*/
	vecFilter.removeAll(vecExServ);

	/* To remove similar configured servers records from excluded servers*/
	vecExServ.removeAll(vecConfigServ);

	if ((vecFilter != null && vecFilter.isEmpty()) &&
		(vecConfigServ != null && vecConfigServ.isEmpty()) &&
		(vecExServ != null && vecExServ.isEmpty()))
	{
		Vector sess_vec = new Vector();
		sess_vec.addElement(_mapping.getTextDescription("admin.test.Configure Agents!"));
		sess_vec.addElement("EgStypeTlist.jsp?qctr=1&server=" + serverName+"&showAll="+showAll);
		sess_vec.addElement(_mapping.getTextDescription("admin.test.TEST NOT AVAILABLE FOR CONFIGURATION"));
		sess_vec.addElement("<b>"+_mapping.getTestDescription(tName)+"</b> "+_mapping.getTextDescription("admin.test.for")+" <b>"+_mapping.getComponentTypeDescription(serverName)+"</b> "+_mapping.getTextDescription("admin.test.is currently not available for configuration")+". ");
		sess_vec.addElement("<br><b>"+_mapping.getTextDescription("admin.test.Possible reason")+"</b> : "+_mapping.getTextDescription("admin.test.This test is an agent-based test")+". "+_mapping.getTextDescription("admin.test.As all")+" <b>"+_mapping.getComponentTypeDescription(serverName)+"</b> "+_mapping.getTextDescription("admin.test.components are currently managed in an agentless manner, this test cannot be configured")+".");
		session.setAttribute("vec_Errors",sess_vec);
%>
		<jsp:forward page="EgErrors.jsp" />
<%
	}
%>

<form name="topology" method="post" action="EgApplyDefaults.jsp" style="margin:0px">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<jsp:include page="listSearch.jsp?title=AGENT - TEST&leftString=Add User&backButton=true&subtitle=false"/>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<table align="center" cellspacing="0" cellpadding="0" width="90%" border="0" id="eg_subcontentbg">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" ></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%" colspan="3">
<%
	String compNameDisplay = "";
	if(q_ctr.equals("1"))
	{
		str_comp_name = request.getParameter("compname");
		if(!(str_comp_name.equals("undefined")) && r_ctr.equals("0"))
		{
			if(str_comp_name.startsWith("undefined"))
			{
				str_comp_name = str_comp_name.substring(str_comp_name.indexOf("undefined")+9);
			}
			session.setAttribute("serverLists",str_comp_name);
			s_painhost = str_comp_name;
			compNameDisplay = Server.getServerNameWithoutPort(str_comp_name, false);
		}
		else if(str_comp_name.equals("undefined") && r_ctr.equals("1"))
		{
			session.setAttribute("serverLists", request.getParameter("hostname"));
			s_painhost = request.getParameter("hostname");
		}
		//-------------------modified--on 25/07/07---for display selected comp  for Reconfigure selection-
		else if(!str_comp_name.equals("undefined") && r_ctr.equals("1"))
		{
			session.setAttribute("serverLists", request.getParameter("hostname"));//got nullpointer in egtestparamp
			compNameDisplay = Server.getServerNameWithoutPort(str_comp_name, false);

		}//-----------------------------------------------------------------------------------------------
	}
	
	if(s_painhost.equals(""))
		s_painhost = str_comp_name;
%>
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0"><col width="40px"><col width="260px"><col width="500px">
							<tr>
								<th align="left" id="head_padding4" style="padding-left:4px"><egui:intnl text="admin.test.Test"/></th>
								<td class="eg_subcontent" align="left" nowrap>&nbsp;<b>:</b>&nbsp;&nbsp;&nbsp;<egui:intnl test="<%=testName%>" /></td>
<%
	if(compNameDisplay != null && !compNameDisplay.equals(""))
	{
%>
								<td align="right" style="padding-right:4px">
									<table  cellpadding="0" cellspacing="0" border="0">
										<tr>
											<th align="left" id="head_padding4" width="60px" style="padding-left:4px"><egui:intnl text="admin.test.Component"/></th>
											<td class="eg_subcontent" align="left" nowrap>&nbsp;<b>:</b>&nbsp;&nbsp;<%=compNameDisplay%></td>
										</tr>
									</table>
								</td>
<%
	}
	else
	{
%>
								<td>&nbsp;</td>
<%
	}
%>
							</tr>
						</table>
					</td>
					<td width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td id="eg_subcontentbg" width="7">&nbsp;</td>
					<td nowrap valign="top" width="100%" colspan="3">
						<table align="right" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td nowrap valign="top" id="space1">
									<table align="right" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td align="center" id="eg_subheadbg" nowrap="nowrap" class="head_padding4" style="border-left-width:1px;border-right-width:1px"><b><egui:intnl text="admin.test.Components with Default Configuration"/></b></td>
										</tr>
										<tr>
											<td id="eg_subcontentbg"  valign="top" nowrap class="cell_border1">
												<select name="ComponentsList" size="13" style="width:355px;" multiple>
<%
	Collections.sort(vecFilter,String.CASE_INSENSITIVE_ORDER);
	for(int j=0; j<vecFilter.size(); j++)
	{
		String server = (String)vecFilter.elementAt(j);
		String displayName = Server.getServerNameWithoutPort(server, false);
		if(server.equalsIgnoreCase(compNameForSelect))
		{
%>
												<option value="<%=server%>" selected><%=displayName%></option>
<%
		}
		else
		{
%>
												<option value="<%=server%>"><%=displayName%></option>
<%
		}
	}
%>
												</select>
											</td>
										</tr>
										<tr>
											<td>
												<table align="center" width="100%" cellspacing="2" cellpadding="2" border="0">
													<tr>
														<td align="right" width="50%"><input type="button" value='<egui:intnl text="admin.test.Configure"/>' onClick="javascript:listselect('<%=serverName +",showAll="+request.getParameter("showAll")%>', '<%=b_isPortRelevantForTest%>', '<%=testName%>')" name="start" class="eg_back" onClick="javascript:populate();" style="width: 85px;"></td>
														<td align="left" width="50%"><input type="button" value='<egui:intnl text="admin.test.Exclude"/>' onClick="javascript:updatemanage('<%=b_isPortRelevantForTest%>', '<%=serverName+",showAll="+request.getParameter("showAll")%>', '<%=testName%>', 'ComponentsList')" class="eg_back" style="width: 85px;"></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
								<td nowrap valign="top" id="space1">
									<table align="center" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subheadbg" align="center" class="head_padding4" style="border-left-width:1px;border-right-width:1px" ><b><egui:intnl text="admin.test.Configured Components"/></b></td>
										</tr>
										<tr>
											<td id="eg_subcontentbg"  valign="top" nowrap class="cell_border1">
												<select name="ComponentsUnderEgurkha" size="13"   style="width:262px;" multiple>
<%
	Collections.sort(vecConfigServ,String.CASE_INSENSITIVE_ORDER);
	//for db Optimization
	//*******************************
	if(uniqueHostSystemData &&  hostSysTests.contains(testName))
	{
		if(vecConfigServ != null && vecConfigServ.size() > 0)
		{
			for (int x=0;x<vecConfigServ.size();x++)
			{
				String st_comp = (String) vecConfigServ.get(x);
				if (hash.containsKey(st_comp.trim()))
				{
					vecConfigServ.removeElementAt(x);
					x--;
				}
			}
		}
	}
	//******************************

	for(int i=0; i < vecConfigServ.size(); i++)
	{
		strExServer = (String)vecConfigServ.elementAt(i);
		String displayStr = Server.getServerNameWithoutPort(strExServer, false);
		if(strExServer.equalsIgnoreCase(compNameForSelect))
		{
%>
												<option value='<%=strExServer%>' selected ><%=displayStr%></option>
<%
		}
		else
		{
%>
												<option value=<%=strExServer%>><%=displayStr%></option>
<%
		}
	}
%>
												</select>
											</td>
										</tr>
										<tr>
											<td>
												<table align="center" width="100%" cellspacing="2" cellpadding="2" border="0">
													<tr>
														<td align="right" width="50%"><input type="button" value='<egui:intnl text="admin.test.Reconfigure"/>' onClick="javascript:addtounmanage('<%=b_isPortRelevantForTest%>', '<%=serverName+",showAll="+request.getParameter("showAll")%>', '<%=testName%>','<%=testinfo%>')" class="eg_back" style="width: 85px;"></td>
														<td align="left" width="50%"><input type="button" value='<egui:intnl text="admin.test.Exclude"/>' onClick="javascript:updatemanage('<%=b_isPortRelevantForTest%>', '<%=serverName+",showAll="+request.getParameter("showAll")%>', '<%=testName%>', 'ComponentsUnderEgurkha')" class="eg_back" style="width: 85px;"></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
								<td nowrap valign="top" id="space1">
									<table align="center" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subheadbg" align="center" class="head_padding4" style="border-left-width:1px;border-right-width:1px"><b><egui:intnl text="admin.test.Excluded Components"/></b></td>
										</tr>
										<tr>
											<td id="eg_subcontentbg" valign="top" nowrap class="cell_border1">
												<select name="ComponentsUnder" size="13"   style="width:262px;" multiple>
<%
	Collections.sort(vecExServ,String.CASE_INSENSITIVE_ORDER);
	allServers =egDisc.getAllServersOfType(str_comp_type);
	ArrayList als=new ArrayList();
	if (allServers!=null)
	{
		for (int i=0;i<allServers.length;i++)
		{
			int ind=allServers[i].indexOf(":");
			if (ind<0)
				continue;
			als.add(allServers[i].substring(ind+1));
		}
	}
	int size=allServers.length;
	for(int i=0; i<vecExServ.size(); i++)
	{
		strExServer = (String)vecExServ.elementAt(i);
		String display = Server.getServerNameWithoutPort(strExServer, false);
		if (b_isPortRelevantForTest)
		{
			if (!als.contains(strExServer))
				continue;
		}
		else
		{
			boolean b=false;
			String search=display+":";
			for (int j=0;j<size;j++)
			{
				String s=(String)als.get(j);
				if (s.startsWith(search))
				{
					b=true;
					break;
				}
			}
			if (!b)
				continue;
		}
%>
												<option value=<%=strExServer%>><%=display%></option>
<%
	}
	//new code for apply to all servers starts
	if((vecFilter!= null && vecFilter.size()>0 )||( vecConfigServ!=null && vecConfigServ.size()>0))
	{
		int no_ofcomps = vecFilter.size() + vecConfigServ.size();
		if(no_ofcomps > 1)
			b_isotherserverspresent = true;
		else
			b_isotherserverspresent = false;
	}
	//new code for apply to all servers ends
%>
												</select>
											</td>
										</tr>
										<tr>
											<td>
												<table align="center" width="100%" cellspacing="2" cellpadding="2" border="0">
													<tr>
<%
	if(b_isPortRelevantForTest)
	{
%>
														<td id="eg_subcontentbg" align="center"><input type="button" value='<egui:intnl text="admin.test.Include"/>' onClick="javascript:includemanage('true', '<%=serverName+",showAll="+request.getParameter("showAll")%>', '<%=testName%>')" class="eg_back" style="width: 85px;"></td>
<%
	}
	else
	{
%>
														<td id="eg_subcontentbg" align="center"><input type="button" value='<egui:intnl text="admin.test.Include"/>' onClick="javascript:includemanage('false', '<%=serverName+",showAll="+request.getParameter("showAll")%>', '<%=testName%>')" class="eg_back" style="width: 85px;">&nbsp;</td>
<%
	}
%>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
					<td id="eg_subcontentbg" width="7">&nbsp;</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%" colspan="3" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0" ></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
<%
	if((!(str_comp_name.equals("undefined")) && q_ctr.equals("1")) || r_ctr.equals("1"))
	{
		testparamIni=new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_testparam.ini");
		String[] tcKeywords=testparamIni.getVariables("TEST_CONFIGURATION_PARAM_VALUE_KEYWORDS");
		List listTcKeywords = Arrays.asList(tcKeywords);
		ArrayList aListTcKeywordsLowerCase = new ArrayList();
		for (int i=0;i<listTcKeywords.size();i++)
		{
			String strKeyword = (String)listTcKeywords.get(i);
			strKeyword = strKeyword.trim();
			strKeyword = strKeyword.toLowerCase();
			aListTcKeywordsLowerCase.add(strKeyword);
		}
%>
			<br><br>
			<table align="center" cellspacing="0" cellpadding="0" width="85%" border="0">
				<tr>
					<td align="center" valign="top">
<%
		boolean compflag = false;

		if(!str_comp_type.equals("Default_server"))
		{
			compflag = true ;
		}

		if(compflag==true)
		{
			str_comp_type = str_comp_type;
		}
		else
		{
			str_comp_type = "";
		}
%>
						<table align="center" cellspacing="0" cellpadding="2" width="100%" border="0">
							<tr>
								<td nowrap height="24" align="left">
<%
		if(str_comp_type.equals("Oracle_server") && b_isPortRelevantForTest && egSpecs.isInfoRelevantForTest(testName))
		{
			//Nickname change
			String c_name = s_painhost;

			String name = "";
			if(str_comp_name.equals("undefined"))
				name = str_comp_type + ":" + str_host_name;
			else
				name = str_comp_type + ":" + str_comp_name;

			name = name.trim();
			String[] valArr = egDisc.getFieldValuesForServer(str_comp_type,name);
			s_painhost = valArr[1] + ":" + valArr[3] + ":" + valArr[5];
			s_painhost = s_painhost.trim();

			if(s_painhost == null)
				s_painhost = c_name;
%>
									<a name="conf"><b><egui:intnl test="<%=strCheck%>"/></b>&nbsp;<egui:intnl text="admin.test.parameters to be configured for"/>&nbsp;<%=removeNull(str_comp_name)%></b>&nbsp;<b>(<egui:intnl type="<%=str_comp_type%>"/>)</a> &nbsp;&nbsp; <a name="conf"><br><br>&nbsp;<egui:intnl text="admin.test.To create a new database user"/></a>,&nbsp;<a href="EgDbUserCreation.jsp?comptype=<%=str_comp_type%>&compname=<%=s_painhost%>&qctr=1&rctr=0&t_name=<%=strCheck%>&server=<%=serverName%>&c_name=<%=c_name%>&version=null"><b><egui:intnl text="admin.common.Click here"/></b></a>
<%
		}
		else if(v_ejb_tests.contains(strCheck))
		{
			int autoDiscIdx=-1;
			if(vecVarPair!=null)
			{
				autoDiscIdx = vecVarPair.indexOf("-autoDiscovery");
			}
			boolean isAutoDisc = false;
			if(autoDiscIdx!=-1)
			{
				isAutoDisc = (((String)vecValPair.elementAt(autoDiscIdx)).trim()).equalsIgnoreCase("true");
			}
%>
									<a name="conf"><b><egui:intnl test="<%=strCheck%>"/></b>&nbsp;<egui:intnl text="admin.test.parameters to be configured for"/><b>&nbsp;<%=removeNull(str_comp_name)%></b>&nbsp;<b>(<egui:intnl type="<%=str_comp_type%>"/>)</b></a><br><br>
<%
			
			if(!isAutoDisc)
			{

%>
									<a name="conf">&nbsp;&nbsp;<egui:intnl text="admin.test.To add/modify Groups"/></a>,&nbsp; <a href="<%=(String)v_ejb_tests.get(1)%>?comp=<%=EgURLEncoder.encode(s_painhost,"UTF-8")%>&test=<%=strCheck%>&server=<%=EgURLEncoder.encode(str_comp_type,"UTF-8")%>"><b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a>
<%
			}
		}
		else if(v_agg_tests.contains(strCheck)) //skm
		{
%>
									<a name="conf"><b><egui:intnl test="<%=strCheck%>"/></b>&nbsp;<egui:intnl text="admin.test.parameters to be configured for"/><b>&nbsp;<%=removeNull(str_comp_name)%></b>&nbsp;<b>(<egui:intnl type="<%=str_comp_type%>"/>)</b></a>
									<br><br>&nbsp;&nbsp;<egui:intnl text="admin.test.To add/modify Aggregate Groups"/>,&nbsp;
									<a class="eg_monlink" href="<%=(String)v_agg_tests.get(1)%>?comp=<%=s_painhost%>&test=<%=strCheck%>&server=<%=serverName%>"><b><egui:intnl text="admin.common.Click Here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a>
<%
		} //skm
		else
		{
%>
									<a name="conf"><b><egui:intnl test="<%=strCheck%>"/></b>&nbsp;<egui:intnl text="admin.test.parameters to be configured for"/><b>&nbsp;<%=removeNull(str_comp_name)%></b>&nbsp;<b>(<egui:intnl type="<%=str_comp_type%>"/>)</b></a>
<%
		}
%>
								</td>
							</tr>
<%
		if(vecVarPair!=null && vecVarPair.contains("-policyFilter"))
		{
			int lognum=vecVarPair.indexOf("-logType");
			log=((String)vecValPair.get(lognum)).trim();
			lognum=vecVarPair.indexOf("-policyFilter");
			session.setAttribute("BackQuery",request.getQueryString().replace('&',','));
			if((((String)vecValPair.get(lognum)).trim().equals("true")&& Evtflag=="")|| Evtflag.equalsIgnoreCase("true"))
			{
%>
							<tr>
								<th nowrap height="24" align="left"><a name="conf"><egui:intnl text="admin.test.To add/modify Policy"/></a>,&nbsp; <a href = "ViewPolicy.jsp?server=<%=str_comp_type%>&test=<%=testName%>&port=<%=b_isPortRelevantForTest%>&showAll=<%=showAll%>&q=<%=request.getQueryString().replace('&',',')%>&logtype=<%=log%>&requestFrom=EgConfigTest.jsp"> <b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"> </a></th>
							</tr>
<%
			}
		}
		else if (listMultipleUserSupportTest != null && listMultipleUserSupportTest.contains(testName))
		{
			multiUserMode = true;
%>
							<tr>
								<th nowrap height="24" align="left"><a name="conf"><egui:intnl text="admin.test.To configure users for this test" /></a>,&nbsp; <a href = "javascript:void(0)" onClick="config_popup('./VmgUsers.jsp?server=<%=str_comp_type%>&test=<%=testName%>&port=<%=b_isPortRelevantForTest%>&compname=<%=EgURLEncoder.encode(removeNull(str_comp_name),"UTF-8")%>&showAll=<%=showAll%>&logtype=<%=log%>','','width=900,height=380,top=150,left=50')"> <b ><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"> </a></th>
							</tr>
<%
		}
		else if (testName.equalsIgnoreCase("CtxAuthTest") || testName.equalsIgnoreCase("WinAuthTest") || testName.equalsIgnoreCase("TermAuthTest"))
		{
			multiUserMode = true;
%>
							<tr>
								<th nowrap height="24" align="left"><a name="conf"><egui:intnl text="admin.test.To configure users for this test" /></a>,&nbsp;<a href = "javascript:void(0)" onClick="config_popup('./EgConfigureMultipleUsers.jsp?server=<%=str_comp_type%>&test=<%=testName%>&port=<%=b_isPortRelevantForTest%>&compname=<%=EgURLEncoder.encode(removeNull(str_comp_name),"UTF-8")%>&showAll=<%=showAll%>&logtype=<%=log%>','','width=900,height=380,top=150,left=50')"><b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"> </a></th>
							</tr>
<%
		}
		else if (testName.equalsIgnoreCase("VCTaskEvtTest"))
		{
%>
							<tr>
								<th nowrap height="24" align="left"><a name="conf"><egui:intnl text="admin.test.To configure tasks for this test" /></a>,&nbsp;<a href="/final/admin/EgConfigureVCTasks.jsp?fromPage=TestConfiguration"><b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></th>
							</tr>
<%
		}
		else if (testName.equalsIgnoreCase("VCEventsTest"))
		{
%>
							<tr>
								<th nowrap height="24" align="left"><a name="conf"><egui:intnl text="admin.test.To configure events for this test" /></a>,&nbsp;<a href="/final/admin/EgConfigureVCEvents.jsp?fromPage=TestConfiguration"><b><egui:intnl text="admin.common.Click here"/></b>&nbsp;<img src="/final/admin/eg_images/icon_click.gif" border="0"></a></th>
							</tr>
<%
		}
%>
							<tr>
								<td align="center" valign="top">
<%
		if(q_ctr.equals("1"))
		{
			if(!(str_comp_name.equals("undefined")) && r_ctr.equals("0"))
			{
				if(str_comp_name.startsWith("undefined"))
				{
					str_comp_name = str_comp_name.substring(str_comp_name.indexOf("undefined")+9);
				}
%>
									<input type="hidden" name="hostname" value='<%=Server.getServerNameWithoutPort(str_comp_name)%>'>
<%
			}
			else if(str_comp_name.equals("undefined") && r_ctr.equals("1"))
			{
%>
									<input type="hidden" name="hostname" value='<%=Server.getServerNameWithoutPort(request.getParameter("hostname"))%>'>
<%
			}
		}

		vecThrow.removeAllElements();
		String enablessl = "";
		String disablessl = "";
		String check = "";
%>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
<%
		String selectedComponentName = null;
		if(q_ctr.equals("1"))
		{
			if(!(str_comp_name.equals("undefined")) && (r_ctr.equals("0") || r_ctr.equals("1"))) //To handle display of component name during reconfiguration (r_ctr = 1) - Krishnamurthi (04/01/2008)
			{
				if(str_comp_name.startsWith("undefined"))
				{
					str_comp_name = str_comp_name.substring(str_comp_name.indexOf("undefined")+9);
				}
				selectedComponentName = Server.getServerNameWithoutPort(str_comp_name);
%>
										<tr>
											<td colspan="5" align="center">
												<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
													<tr>
														<td id="subhead_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
														</td>
														<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
														<%=Server.getServerNameWithoutPort(str_comp_name)%>
														</td>
														<td id="subhead_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
														</td>
													</tr>
												</table>
											</td>
										</tr>
<%
			}
			else if(str_comp_name.equals("undefined") && r_ctr.equals("1"))
			{
				selectedComponentName = Server.getServerNameWithoutPort(request.getParameter("hostname"));
%>
										<tr>
											<td colspan="5" align="center">
												<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" height="22">
													<tr>
														<td id="subhead_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
														</td>
														<td class="eg_darktextbold" width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
														<%=Server.getServerNameWithoutPort(request.getParameter("hostname"))%>
														</td>
														<td id="subhead_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
														</td>
													</tr>
												</table>
											</td>
										</tr>
<%
			}
			if(selectedComponentName==null)
				selectedComponentName=Server.getServerNameWithoutPort(str_comp_name);
			session.setAttribute("selectedComponent",selectedComponentName);
		}
%>
										<tr>
											<td width="100%" colspan="5" class="eg_subcontentbg">
												<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="eg_subcontentbg">
<%
		String testper = request.getParameter("testperiod");
		if(testper != null && !testper.equals(""))
			strTemp = testper;
		else
			strTemp = strIniVal.substring(strIniVal.lastIndexOf(EgConstants.COMMA)+1).trim();
%>
													<tr>
														<td id="form_spacing" width="10">&nbsp;</td>
														<td id="form_spacing" class="eg_subcontent" nowrap width="210">&nbsp;&nbsp;<egui:intnl text="admin.test.TEST PERIOD"/></td>
														<td id="form_spacing" class="eg_subcontent" align="center" nowrap width="20" height="22">:</td>
														<td id="form_spacing" class="eg_subcontent">
															<select name="testperiod" class="list">
<%
		vecThrow.addElement("testperiod");
		vecThrow.addElement("null");
		vecThrow.addElement(strTemp);
		auditLogHashtable.put("testperiod",strTemp);
		Iterator itr = periodMap.keySet().iterator();
		for(int i=0; i<periodMap.size(); i++)
		{
			Long lngperiod=(Long) itr.next();
			String periodVal =lngperiod.toString();
			String periodStr = (String) periodMap.get(lngperiod);
			if(periodVal.equals(strTemp))
			{
				out.println("<option value = '" + periodVal + "' selected>" + periodStr + "</option>");
			}
			else
			{
				out.println("<option value = '" + periodVal + "'>" + periodStr + "</option>");
			}
		}
%>
															</select>
														</td>
														<td id="form_spacing" width="10">&nbsp;</td>
														<input type="hidden" name="testPeriodHdn" value=''>
													</tr>
<%
		EgServicesInfo servicesInfo = new EgServicesInfo("manager");
		boolean autoIpNameCheck = servicesInfo.autoIpNameCheck();
		//..................................SNMP Modification starts here........................//
		Vector tmpVarPair = new Vector();
		for (int i=0;i<vecVarPair.size();i++)
		{
			tmpVarPair.add(vecVarPair.get(i).toString().toLowerCase());
		}

		boolean isSnmp=false;
		isSnmp = tmpVarPair.contains("-snmpport");

		//by anand - Start
		boolean isModeParamExist =false;
		isModeParamExist = (isSnmp && tmpVarPair.contains("-mode") && tmpVarPair.contains("-jmx_remote_port"));
		//by anand - End

		String flag="";
		String selection="";
		String[] versions={"v1","v2","v3"};
		String[] authTypes={"MD5","SHA"};
		String[] encryptTypes={"DES","AES"};
		String[] group={""};
		boolean comm_show=false;
		boolean isOlderSnmp = false;
		if(isSnmp)
		{
			int portIdx = tmpVarPair.indexOf("-port");
			String portCase = null;
			if (portIdx != -1)
			{
				portCase = (String)vecVarPair.get(portIdx);
			}

			int timeOutIdx = tmpVarPair.indexOf("-timeout");
			String timeOutCase = null;
			if (timeOutIdx != -1)
			{
				timeOutCase = (String)vecVarPair.get(timeOutIdx);
			}

			int modeIdx = tmpVarPair.indexOf("-mode");
			String modeCase = null;
			if (modeIdx != -1)
			{
				modeCase = (String)vecVarPair.get(modeIdx);
			}

			int comm_index=tmpVarPair.indexOf("-snmpcommunity");
			if (!tmpVarPair.contains("-snmpversion"))
			{
				vecVarPair.add(comm_index+1,"-snmpversion");
				vecValPair.add(comm_index+1,"v1");
				tmpVarPair.add(comm_index+1,"-snmpversion");
				isOlderSnmp = true;
				if(vecVarPair.indexOf("-encrypttype") < 0)
				{
					String[] tmpVersions = {"v1","v2"};
					versions = tmpVersions;
				}
			}
			int ver_index=tmpVarPair.indexOf("-snmpversion");
			String tempSnmpVersionCase = (String)vecVarPair.get(ver_index);
			String version  = ((String)vecValPair.get(ver_index)).trim();
			if (version.equalsIgnoreCase("v1") || version.equalsIgnoreCase("v2"))
			{
				comm_show=true;
			}
			if (snmpVersion != null && snmpVersion.length()>0)
			{
				if(snmpVersion.equalsIgnoreCase("v1") || snmpVersion.equalsIgnoreCase("v2"))
				{
					comm_show=true;
				}
				else
				{
					comm_show=false;
				}
			}
			String move=(String)vecVarPair.remove(comm_index);
			String move1=(String)vecValPair.remove(comm_index);
			ver_index=vecVarPair.indexOf(tempSnmpVersionCase);
			vecVarPair.add(ver_index+1,move);
			vecValPair.add(ver_index+1,move1);

			//by anand - starts
			if (isModeParamExist)
			{
				if (timeOutIdx == -1)
				{
					//put mode after port
					//-host,-port,-mode
					int tempModeIdx = vecVarPair.indexOf(modeCase);
					String moveModeParam = (String)vecVarPair.remove(tempModeIdx);
					String moveModeValue = (String)vecValPair.remove(tempModeIdx);

					int tempPortIdx = vecVarPair.indexOf(portCase);
					vecVarPair.add(tempPortIdx+1,moveModeParam);
					vecValPair.add(tempPortIdx+1,moveModeValue);
				}
				else
				{
					int tempTimeOutCaseIdx = vecVarPair.indexOf(timeOutCase);
					String moveTimeOutParam = (String)vecVarPair.remove(tempTimeOutCaseIdx);
					String moveTimeOutValue = (String)vecValPair.remove(tempTimeOutCaseIdx);

					//-host,-port,-timeout,-mode
					//put timeout after port
					int tempPortIdx = vecVarPair.indexOf(portCase);
					vecVarPair.add(tempPortIdx+1,moveTimeOutParam);
					vecValPair.add(tempPortIdx+1,moveTimeOutValue);

					int tempModeCaseIdx = vecVarPair.indexOf(modeCase);
					String moveModeParam = (String)vecVarPair.remove(tempModeCaseIdx);
					String moveModeValue = (String)vecValPair.remove(tempModeCaseIdx);

					//put mode after timeout
					int tempTimeOutCaseIdx1 = vecVarPair.indexOf(timeOutCase);
					vecVarPair.add(tempTimeOutCaseIdx1+1,moveModeParam);
					vecValPair.add(tempTimeOutCaseIdx1+1,moveModeValue);
				}
			}
			//by anand - ends
		}

		if (tmpVarPair.contains("-virtual_center"))
		{
			int virtual_centerIdx = tmpVarPair.indexOf("-virtual_center");
			String virtual_centerValue = ((String)vecValPair.get(virtual_centerIdx)).trim();
			if (vc != null && vc.equalsIgnoreCase("none") && !virtual_centerValue.equalsIgnoreCase("none"))
			{
				uName = "$unconfigured";
				uPass = "$unconfigured";
				isSSlForEsx = "Yes";
				webPort = "443";
			}
		}

		String tempWebPort = "";
		if (tmpVarPair.contains("-ssl"))
		{
			int sslIdx = tmpVarPair.indexOf("-ssl");
			String sslValue = ((String)vecValPair.get(sslIdx)).trim();
			if (sslValue.equalsIgnoreCase("true") || sslValue.equalsIgnoreCase("yes"))
			{
				tempWebPort = "443";
			}
			else
			{
				tempWebPort = "80";
			}
		}

		Vector lowerCaseVecVarPair = new Vector();
		for (int i=0;i<vecVarPair.size();i++)
		{
			lowerCaseVecVarPair.add(vecVarPair.get(i).toString().toLowerCase());
		}
		boolean others_show=false;
		boolean encr_info=true;
		String optvalue = request.getParameter("correctValue");

		boolean isCorrectParamExist = lowerCaseVecVarPair.contains("-correct");
		for(int g=0; g<vecVarPair.size(); g++)
		{
			boolean combo=false;
			stringVar = (String)vecVarPair.elementAt(g);
			stringVar = stringVar.substring(1).trim();

			if(stringVar.equalsIgnoreCase("mCount") || 
				stringVar.equalsIgnoreCase("rptName") || 
				stringVar.equalsIgnoreCase("Hyperv") || 
				stringVar.equalsIgnoreCase("isLdoms"))
			{
				continue;
			}

			if(testName.equalsIgnoreCase("securitylogtest") && stringVar.equalsIgnoreCase("users") || stringVar.equalsIgnoreCase("eventids"))
				continue;

			if(!str_comp_type.equals("Oracle_cluster_service") && stringVar.equalsIgnoreCase("INFO"))
				continue;

			stringVal = (String)vecValPair.elementAt(g);
			stringVal = stringVal.trim();

			if (stringVar.equalsIgnoreCase("process"))
			{
				if (stringVal.indexOf("eGSpHyGe") != -1)
				{
					stringVal = StringUtils.replace(stringVal,"eGSpHyGe"," -");
				}
			}

			if(isSnmp)
			{
				//By Anand - Start
				if (isModeParamExist)
				{
					int modeIdx = vecVarPair.indexOf("-mode");
					String modeValue = ((String)vecValPair.elementAt(modeIdx)).trim();
					String requestModeValue = request.getParameter("mode");
					requestModeValue = (requestModeValue==null)?"":requestModeValue;
					if (!requestModeValue.equals("")) modeValue = requestModeValue;

					if (modeValue.equalsIgnoreCase("true"))
					{
						if (stringVar.equalsIgnoreCase("Jmx_Remote_Port") ||
							stringVar.equalsIgnoreCase("Jndi_Name") ||
							stringVar.equalsIgnoreCase("user") ||
							stringVar.equalsIgnoreCase("password"))
						{
							continue;
						}
					}
					else
					{
						if (stringVar.equalsIgnoreCase("snmpversion") ||
							stringVar.equalsIgnoreCase("snmpcommunity") ||
							stringVar.equalsIgnoreCase("snmpPort") ||
							stringVar.equalsIgnoreCase("authtype") ||
							stringVar.equalsIgnoreCase("authpass") ||
							//stringVar.equalsIgnoreCase("timeout") ||
							stringVar.equalsIgnoreCase("username") ||
							stringVar.equalsIgnoreCase("encryptflag") ||
							stringVar.equalsIgnoreCase("encryptpassword") ||
							stringVar.equalsIgnoreCase("encrypttype"))
						{
							continue;
						}
					}

					if (vecVarPair.contains("-Profiler"))
					{
						int profilerIdx = vecVarPair.indexOf("-Profiler");
						String profilerValue = ((String)vecValPair.elementAt(profilerIdx)).trim();
						String requestProfilerValue = request.getParameter("profiler");
						requestProfilerValue = (requestProfilerValue==null)?"":requestProfilerValue;
						if (!requestProfilerValue.equals("")) profilerValue = requestProfilerValue;
						if (profilerValue.equalsIgnoreCase("false"))
						{
							if (stringVar.equalsIgnoreCase("Profiler_home"))
							{
								continue;
							}
						}
					}
					if (vecVarPair.contains("-Heap_Analysis"))
					{
						int heapIdx = vecVarPair.indexOf("-Heap_Analysis");
						String heapValue = ((String)vecValPair.elementAt(heapIdx)).trim();
						String requestHeapValue = request.getParameter("javahome");
						requestHeapValue = (requestHeapValue==null)?"":requestHeapValue;
						if (!requestHeapValue.equals("")) heapValue = requestHeapValue;
						if (heapValue.equalsIgnoreCase("false"))
						{
							if (stringVar.equalsIgnoreCase("Java_Home"))
							{
								continue;
							}
						}
					}

				}
				//By Anand - End

				if(stringVar.equalsIgnoreCase("snmpversion") || stringVar.equalsIgnoreCase("authtype") || stringVar.equalsIgnoreCase("encrypttype"))
				{
					combo=true;
				}
				if(stringVar.equalsIgnoreCase("snmpversion") && (snmpVersion.equalsIgnoreCase("v1") || snmpVersion.equalsIgnoreCase("v2")))
				{
					comm_show=true;
				}
				else
				{
					if(snmpVersion.length()==0 && (stringVal.equalsIgnoreCase("v1") || stringVal.equalsIgnoreCase("v2")))
					{
						comm_show=true;
					}
				}
				if(!comm_show && stringVar.equalsIgnoreCase("snmpcommunity"))
				{
					continue;
				}
				if(isOlderSnmp && stringVar.equalsIgnoreCase("snmpversion"))
				{
					continue;
				}
				if(stringVar.equalsIgnoreCase("snmpversion"))
				{
					selection=stringVal;
					if(snmpVersion!=null && snmpVersion.length()>0)
					{
						selection=snmpVersion;
					}
				}
				if(stringVar.equalsIgnoreCase("authtype"))
				{
					selection=stringVal;
					if(authType!=null && (authType.length()>0))
					{
						selection=authType;
					}
				}
				if(stringVar.equalsIgnoreCase("encryptflag"))
				{
					if(stringVal.equalsIgnoreCase("false"))
					{
						encr_info=false;
					}
				}
				if(encryptFlag.equalsIgnoreCase("yes"))
				{
					encr_info=true;
				}
				else if(encryptFlag.equalsIgnoreCase("no"))
				{
					encr_info=false;
				}
				if(!encr_info)
				{
					if(stringVar.equalsIgnoreCase("encrypttype") || stringVar.equalsIgnoreCase("encryptpassword"))
						continue;
				}
				if(stringVar.equalsIgnoreCase("snmpPort") && snmpPort!=null && snmpPort.length()>0)
				{
					stringVal=snmpPort;
				}
				if(stringVar.equalsIgnoreCase("username") && u_name!=null && u_name.length()>0)
				{
					stringVal=u_name;
				}
				if(stringVar.equalsIgnoreCase("authpass") && authPwd!=null && authPwd.length()>0)
				{
					stringVal=authPwd;
				}
				if(stringVar.equalsIgnoreCase("host") && host!=null && host.length()>0)
				{
					stringVal=host;
				}
				if(stringVar.equalsIgnoreCase("port") && port!=null && port.length()>0)
				{
					stringVal=port;
				}
				if(others_show && (stringVar.equalsIgnoreCase("username") ||stringVar.equalsIgnoreCase("authpass")||stringVar.equalsIgnoreCase("authtype")
				||stringVar.equalsIgnoreCase("encryptflag") ||stringVar.equalsIgnoreCase("encrypttype") ||stringVar.equalsIgnoreCase("encryptpassword")))
				{
					continue;
				}
			}

			if (isCorrectParamExist)
			{
				if (optvalue != null && optvalue.length() > 0)
				{
					if (optvalue.equalsIgnoreCase("false"))
					{
						if (stringVar.equalsIgnoreCase("alarmtype") || 
							stringVar.equalsIgnoreCase("userparams") || 
							stringVar.equalsIgnoreCase("correctivescript"))
						{
							continue;
						}
					}
				}
				else
				{
					String tempCorrectValue = "";
					if (stringVar.equalsIgnoreCase("correct"))
					{
						tempCorrectValue = stringVal;
					}

					if (tempCorrectValue.equalsIgnoreCase("false"))
					{
						if (stringVar.equalsIgnoreCase("alarmtype") || 
							stringVar.equalsIgnoreCase("userparams") || 
							stringVar.equalsIgnoreCase("correctivescript"))
						{
							continue;
						}
					}
				}
			}

			if(stringVal!=null && stringVal.indexOf(testInfoDelimiter)>0)
			{
				auditLogHashtable.put(stringVar,StringUtils.replace(stringVal, testInfoDelimiter, EgConstants.COMMA));
			}
			else
			{
				auditLogHashtable.put(stringVar,stringVal);
			}
			vecThrow.addElement(stringVar);
			String strConv = "-" + stringVar;
			vecThrow.addElement(strConv);

			//vecThrow.addElement(stringVal);
			if (((stringVar.indexOf("host")) > -1) || (stringVar.indexOf("HOST")) > -1)
			{
				//new one start
				String requestComponentName="";
				String onlyNickName="";
				if(r_ctr.equals("0"))
					requestComponentName=request.getParameter("compname");
				else
					requestComponentName=request.getParameter("hostname");

				boolean testStatus=egSpecs.isTestInternal(testName, str_comp_type);

				if(requestComponentName.indexOf(':')>-1)
					onlyNickName=requestComponentName.substring(0,requestComponentName.indexOf(':'));
				else
					onlyNickName=requestComponentName;

				isServerAgentless=egagent.isAgentlessServer(onlyNickName,str_comp_type);
				String tempVar="";
				if(testStatus)
				{
					String interAgentMappingName=(String)hash.get(onlyNickName);
					if(interAgentMappingName==null)
						tempVar=onlyNickName;
					else
						tempVar=interAgentMappingName;
				}
				else
				{
					String mappingName[]=extInfo.getExternalAgentsForHost(onlyNickName);
					String agentExternalName=mappingName[0];
					tempVar=agentExternalName;
				}
				String agentOS = agentconfig.getAgentOS(tempVar.trim());
				//new one end
				/*String agentOS = agentconfig.getAgentOS(stringVal.trim());
				if (agentOS==null && !autoIpNameCheck)
				{
					String tmp_str = request.getParameter("compname");
					if (tmp_str.indexOf(":")>-1)
						tmp_str=tmp_str.substring(0,tmp_str.indexOf(":"));
					agentOS = agentconfig.getAgentOS(tmp_str);
				}*/
%>
														<input type="hidden" name="agentOS" value="<%=agentOS%>" >
<%
			}

			String capStringVar = stringVar.toUpperCase();
			String lowStringVar = stringVar;
			//			if((stringVar.indexOf("password") > -1)
			//				|| (stringVar.indexOf("Password") > -1)
			//				|| (stringVar.indexOf("PASSWORD") > -1))
			if (capStringVar.indexOf("PASSWORD") > -1 || capStringVar.indexOf("AUTHPASS")>-1)
			{
				if(stringVal.indexOf("|") > -1)
				{
					String tempStr = "";
					StringTokenizer st1 = new StringTokenizer(stringVal,"|");
					while(st1.hasMoreTokens())
					{
						tempStr += EgCrypt.decrypt(st1.nextToken()) + "#~#";
					}
					stringVal = tempStr.substring(0, tempStr.length()-3);
				}
				else
				{
					stringVal = EgCrypt.decrypt(stringVal);
				}
				vecThrow.addElement(stringVal);
			}
			else if(stringVar.equals("url"))
			{
				vecurl=new Vector();
				stringVal = EgURLDecoder.decode(stringVal,"UTF-8");
				vecThrow.addElement(stringVal);
				StringTokenizer urltok=new StringTokenizer(stringVal,"|");
				while(urltok.hasMoreTokens())
				{
					String urlstr=urltok.nextToken();
					if(urlstr.indexOf(":")>-1)
					{
						vecurl.add(urlstr.substring(0,urlstr.indexOf(":")));
						urlcount=urltok.countTokens();
					}
				}

				if(stringVal.indexOf("|") > -1)
				{
					previousUrl = stringVal.replace('|',',');
				}
				else
				{
					previousUrl = stringVal;
				}
			}
			else
			{
				vecThrow.addElement(stringVal);
			}

			//display of text box if there is no #
			if(stringVar.equalsIgnoreCase("url")|| stringVar.equalsIgnoreCase("credentials") || stringVar.equalsIgnoreCase("filter") || (stringVal.indexOf("#") < 0 )&& stringVal.indexOf("|") < 0 )
			{
				//				if (((stringVar.indexOf("password") > -1)
				//					|| (stringVar.indexOf("Password") > -1)
				//					|| (stringVar.indexOf("PASSWORD") > -1))
				//					&& (stringVar.indexOf("alpassword") < 0))

				String readOnly = "";

				//By default both the fields (host,port) are expected to be read-only - anand - starts
				if (stringVar.equalsIgnoreCase("host") && hostEditableMode.equals("false"))
				{
					readOnly = "readOnly";
				}
				if (stringVar.equalsIgnoreCase("port") && portEditableMode.equals("false"))
				{
					readOnly = "readOnly";
				}
				//By default both the fields(host,port) are expected to be read-only - ends

				//providing pop-up window adjacent to user parameter to configure user for muti-user enabled test - starts
				//also set user parameter to readOnly mode
				String plusButton = "";
				if (listMultipleUserSupportTest != null && listMultipleUserSupportTest.contains(testName))
				{
					if (multiUserMode && (stringVar.equalsIgnoreCase("admin_user") || stringVar.equalsIgnoreCase("admin_password")|| stringVar.equalsIgnoreCase("domain")))
					{
						if (stringVar.equalsIgnoreCase("admin_user"))
						{
							plusButton = "<img src=\"/final/admin/eg_images/plus.gif\" title=\"Click here to configure user(s)\" class=\"leftmouse\" onClick=\"config_popup(\'./VmgUsers.jsp?server="+str_comp_type+"&test="+testName+"&port="+b_isPortRelevantForTest+"&compname="+EgURLEncoder.encode(removeNull(str_comp_name),"UTF-8")+"&showAll="+showAll+"&logtype="+log+"\',\'\',\'width=900,height=380,top=150,left=50\')\">";
						}
					}
				}
				if (testName.equalsIgnoreCase("CtxAuthTest")||
					testName.equalsIgnoreCase("WinAuthTest") || testName.equalsIgnoreCase("TermAuthTest"))
				{
					if (multiUserMode && (stringVar.equalsIgnoreCase("user") || stringVar.equalsIgnoreCase("password") || stringVar.equalsIgnoreCase("domain")))
					{
						if (stringVar.equalsIgnoreCase("user"))
						{
							plusButton = "<img src=\"/final/admin/eg_images/plus.gif\" title=\"Click here to configure user(s)\" class=\"leftmouse\" onClick=\"config_popup(\'./EgConfigureMultipleUsers.jsp?server="+str_comp_type+"&test="+testName+"&port="+b_isPortRelevantForTest+"&compname="+EgURLEncoder.encode(removeNull(str_comp_name),"UTF-8")+"&showAll="+showAll+"&logtype="+log+"\',\'\',\'width=900,height=380,top=150,left=50\')\">";
						}
					}
				}
				//providing pop-up window adjacent to user parameter to configure user  to  for muti-user enabled test - ends
				if (capStringVar.indexOf("ENCRYPTPASSWORD")>-1)
				{
					if(request.getParameter(stringVar) != null && !(request.getParameter(stringVar).equals("")))
					{
						stringVal = request.getParameter(stringVar);
					}
					boolean showStar = false;
					if (isAutoConfiguration && stringVal.startsWith("$") && aListTcKeywordsLowerCase.contains(stringVal.toLowerCase()))
					{
						showStar = true;
					}
%>
													<tr>
														<td id="<%=borderfortd%>">&nbsp;</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" width="210">&nbsp;
															<egui:intnl text='<%="admin.test."+capStringVar%>'/>
														</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" align="center" nowrap width="20" height="22">:</td>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" value="<%=stringVal%>" class="list">
<%
					if (showStar)
					{
%>
						<font color='black'>&nbsp;*</font>
<%
					}
%>
														</td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
													<!--Coding for confirm password field-->

													<tr>
														<td id="<%=borderfortd%>">&nbsp;</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" nowrap width="210">&nbsp;
															<egui:intnl text="admin.test.CONFIRM PASSWORD"/>
														</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" align="center" nowrap width="20" height="22">:</td>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="encon" value="<%=stringVal%>" class="list">
<%
					if (showStar)
					{
%>
						<font color='black'>&nbsp;*</font>
<%
					}
%>
														</td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
				}
				else if (capStringVar.indexOf("AUTHPASS")>-1)
				{
					String val=stringVal;
					if(conPwd!=null && conPwd.length()>0 )
						val=conPwd;
					boolean showStar = false;
					if (isAutoConfiguration && stringVal.startsWith("$") && aListTcKeywordsLowerCase.contains(stringVal.toLowerCase()))
					{
						showStar = true;
					}
%>
													<tr>
														<td id="<%=borderfortd%>">&nbsp;</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" width="210">&nbsp;
															<egui:intnl text='<%="admin.test."+capStringVar%>'/>
														</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" align="center" nowrap width="20" height="22">:</td>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" value="<%=stringVal%>" class="list">
<%
					if (showStar)
					{
%>
						<font color='black'>&nbsp;*</font>
<%
					}
%>
														</td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
													<!--Coding for confirm password field-->
													
													<tr>
														<td id="<%=borderfortd%>">&nbsp;</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" nowrap width="210">&nbsp;
															<egui:intnl text="admin.test.CONFIRM PASSWORD"/>
														</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" align="center" nowrap width="20" height="22">:</td>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="aucon" value="<%=val%>" class="list">
<%
					if (showStar)
					{
%>
						<font color='black'>&nbsp;*</font>
<%
					}
%>
														</td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
				}
				else if ((capStringVar.indexOf("PASSWORD") > -1) && stringVar.indexOf("alpassword") < 0)
				{
					if(request.getParameter(stringVar) != null && !(request.getParameter(stringVar).equals("")))
					{
						stringVal = request.getParameter(stringVar);
					}
%>
													<tr>
														<td id="<%=borderfortd%>">&nbsp;</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" nowrap width="210">&nbsp;
															<egui:intnl text='<%="admin.test."+capStringVar%>'/>
														</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" align="center" nowrap width="20" height="22">:</td>
<%
					if(stringVal.indexOf("$") == 0)
					{
						boolean showStar = false;
						if (isAutoConfiguration && stringVal.startsWith("$") && aListTcKeywordsLowerCase.contains(stringVal.toLowerCase()))
						{
							showStar = true;
						}

						//configure esxpassword
						if (stringVar.equals("Esx_password"))
						{
							if (uPass.equals("")) uPass = stringVal;
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" id="<%=stringVar%>" value="<%=uPass%>" class="list" <%=readOnly%>>
<%
							if (showStar)
							{
%>
								<font color='black'>&nbsp;*</font>
<%
							}
%>
														</td>
<%
						}
						else
						{
							if (stringVar.equals("admin_password"))
							{
								if (listMultipleUserSupportTest != null && 
									listMultipleUserSupportTest.contains(testName))
								{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" id="<%=stringVar%>" value="<%=stringVal%>" class="list" onblur="javascript:checkHashTildeHash()">
<%
									if (showStar)
									{
%>
										<font color='black'>&nbsp;*</font>
<%
									}
%>
														</td>
<%
								}
								else
								{

%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" id="<%=stringVar%>" value="<%=stringVal%>" class="list">
<%
									if (showStar)
									{
%>
										<font color='black'>&nbsp;*</font>
<%
									}
%>
														</td>
<%
								}
							}
							else
							{
								if (stringVar.equalsIgnoreCase("password"))
								{
									if (testName.equalsIgnoreCase("CtxAuthTest") || 
										testName.equalsIgnoreCase("WinAuthTest") || 
										testName.equalsIgnoreCase("TermAuthTest"))
									{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" value="<%=stringVal%>" class="list" onblur="javascript:checkHashTildeHash()">
<%
										if (showStar)
										{
%>
											<font color='black'>&nbsp;*</font>
<%
										}
%>
														</td>
<%
									}
									else
									{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" value="<%=stringVal%>" class="list">
<%
										if (showStar)
										{
%>
											<font color='black'>&nbsp;*</font>
<%
										}
%>
														</td>
<%
									}
								}
								else
								{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" value="<%=stringVal%>" class="list" <%=readOnly%>>
<%
									if (showStar)
									{
%>
										<font color='black'>&nbsp;*</font>
<%
									}
%>
														</td>
<%
								}
							}
						}
					}
					else
					{
						if (stringVar.equals("Esx_password"))
						{
							if(!uPass.equals("")) stringVal = uPass;
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" value="<%=stringVal%>" class="list" <%=readOnly%>></td>
<%
						}
						else
						{
							if (stringVar.equals("admin_password"))
							{
								if (listMultipleUserSupportTest != null && 
									listMultipleUserSupportTest.contains(testName))
								{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" id="<%=stringVar%>" value="<%=stringVal%>" class="list"<%=readOnly%> onblur="javascript:checkHashTildeHash()">
														</td>
<%
								}
								else
								{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" id="<%=stringVar%>" value="<%=stringVal%>" class="list">
														</td>
<%
								}
							}
							else
							{
								if (stringVar.equalsIgnoreCase("password"))
								{
									if (testName.equalsIgnoreCase("CtxAuthTest") || 
										testName.equalsIgnoreCase("WinAuthTest") || 
										testName.equalsIgnoreCase("TermAuthTest"))
									{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" value="<%=stringVal%>" class="list" <%=readOnly%> onblur="javascript:checkHashTildeHash()">
														</td>
<%
									}
									else
									{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" value="<%=stringVal%>" class="list">
														</td>
<%
									}
								}
								else
								{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" value="<%=stringVal%>" class="list"<%=readOnly%>>
														</td>
<%
								}
							}
						}
					}
%>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
					if (!readOnly.equals("readOnly"))
					{
%>
													<!--Coding added for confirm password field -->
													<tr>
														<td id="<%=borderfortd%>">&nbsp;</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" nowrap width="210">&nbsp;
															<egui:intnl text="admin.test.CONFIRM PASSWORD"/>
														</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" align="center" nowrap width="20" height="22">:</td>
<%
						if(stringVal.indexOf("$") == 0)
						{
							boolean showStar = false;
							if (isAutoConfiguration && stringVal.startsWith("$") && aListTcKeywordsLowerCase.contains(stringVal.toLowerCase()))
							{
								showStar = true;
							}

							if (listMultipleUserSupportTest != null && 
								listMultipleUserSupportTest.contains(testName) && 
								capStringVar.equals("ADMIN_PASSWORD"))
							{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="Admincpwd" value="<%=stringVal%>" class="list" <%=readOnly%>>
<%
								if (showStar)
								{
%>
									<font color='black'>&nbsp;*</font>
<%
								}
%>
														</td>
<%
							}
							else
							{
								//configure the confirm esxpassword
								if (stringVar.equals("Esx_password"))
								{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="cpwd" value="<%=uPass%>" class="list" <%=readOnly%>>
<%
									if (showStar)
									{
%>
										<font color='black'>&nbsp;*</font>
<%
									}
%>
														</td>
<%
								}
								else
								{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="cpwd" value="<%=stringVal%>" class="list" <%=readOnly%>>
<%
									if (showStar)
									{
%>
										<font color='black'>&nbsp;*</font>
<%
									}
%>
														</td>
<%
								}
							}
						}
						else
						{
							if (listMultipleUserSupportTest != null && 
								listMultipleUserSupportTest.contains(testName) && 
								capStringVar.equals("ADMIN_PASSWORD"))
							{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="Admincpwd" value="<%=stringVal%>" class="list" <%=readOnly%>></td>
<%
							}
							else
							{
								//reconfigure the confirm esx password
								if(stringVar.equals("Esx_password"))
								{
									if(!uPass.equals("")) stringVal = uPass;
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="cpwd" value="<%=stringVal%>" class="list" <%=readOnly%>></td>
<%
								}
								else
								{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="cpwd" value="<%=stringVal%>" class="list"<%=readOnly%>></td>
<%
								}
							}
						}
%>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
					}
				}
				else if(stringVal.equals("noteditable"))
				{
					if(request.getParameter(stringVar) != null && !(request.getParameter(stringVar).equals("")))
					{
						stringVal = request.getParameter(stringVar);
					}
%>
														<input type="hidden" name="<%= stringVar%>" value="<%=stringVal%>">
<%
				}
				else if((stringVar.indexOf("alpassword") < 0)
					&& (stringVar.indexOf("aluser") < 0)
					&& (stringVar.indexOf("agentless") < 0)
					&& (stringVar.indexOf("almode") < 0)
					/*
					 * Why are other stringVar checked for a contains? Why not equalsIgnoreCase?
					 * equalsIgnoreCase used with OS so that HOST field is displayed, but OS
					 *(for agentless) is not.
					 */
					&& (!stringVar.equalsIgnoreCase("os"))
					&& (stringVar.indexOf("sshPort") < 0)
					&& (stringVar.indexOf("remotePort") < 0))
				{
					if(request.getParameter(stringVar) != null && !(request.getParameter(stringVar).equals("")))
					{
						stringVal = request.getParameter(stringVar);
					}

					//String optvalue = request.getParameter("correctValue");
					if(stringVar !=null && stringVar.equalsIgnoreCase("correct"))
					{
						if(optvalue == null)
						{
							optvalue = stringVal.trim();
							request.setAttribute("cvalue" , optvalue);
						}
					}

					//Left Side - 1 <tr> (Open);3 <td>'s (Closed)
					if(stringVar !=null
						&& (stringVar.equalsIgnoreCase("USERPARAMS")
						|| stringVar.equalsIgnoreCase("correctivescript")
						|| stringVar.equalsIgnoreCase("ALARMTYPE")))
					{
						//optvalue = request.getParameter("correctValue");
						if(optvalue == null)
							optvalue = (String)request.getAttribute("cvalue");

						if(optvalue != null && optvalue.equalsIgnoreCase("true"))
						{
%>
													<tr>
														<td id="<%=borderfortd%>">&nbsp;</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" nowrap width="210">&nbsp;
															<egui:intnl text='<%="admin.test."+capStringVar%>'/>
														</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" align="center" nowrap width="20" height="22">:</td>
<%
						}
					}
					else if (stringVar.equalsIgnoreCase("port"))
					{
						if (!aggTypes.contains(_str)) //skm ...PORT...
						{
%>
													<tr>
														<td id="<%=borderfortd%>">&nbsp;</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" nowrap width="210">&nbsp;
															<egui:intnl text='<%="admin.test."+capStringVar%>'/>
														</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" align="center" nowrap width="20" height="22">:</td>
<%
						} //skm
					}
					else
					{
						if (!aggTypes.contains(_str)) //skm ...HOST... also
						{
							if(combo)
							{
%>
													<tr>
														<td id="<%=borderfortd%>">&nbsp;</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" nowrap width="210">&nbsp;
															<egui:intnl text='<%="admin.test."+capStringVar%>'/>
														</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" align="center" nowrap width="20" height="22">:</td>
<%
							}
							else
							{
%>
													<tr>
<%
								if(capStringVar.equals("POLICYFILTER"))
								{
%>
														<td id="<%=borderfortd%>">&nbsp;</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" nowrap width="210">&nbsp;<%//="POLICY BASED FILTER"%>
															<egui:intnl text="admin.test.POLICY BASED FILTER"/>
														</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" align="center" nowrap width="20" height="22">:</td></span>
<%
								}
								else if(capStringVar!=null && capStringVar.equalsIgnoreCase("CORRECT"))
								{
									if(!isServerAgentless)
									{
%>
														<td id="<%=borderfortd%>">&nbsp;</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" nowrap width="210">&nbsp;
															<egui:intnl text='<%="admin.test."+capStringVar%>'/>
														</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" align="center" nowrap width="20" height="22">:</td>
<%
									}
								}
								else if(capStringVar!=null && capStringVar.equalsIgnoreCase("CREDENTIALS"))
								{
%>
														<td id="<%=borderfortd%>">&nbsp;</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" nowrap width="210" valign="top">&nbsp;
															<egui:intnl text='<%="admin.test."+capStringVar%>'/>
														</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" align="center" nowrap width="20" height="22" valign="top">:</td>
<%
								}
								else
								{
									if(!capStringVar.equalsIgnoreCase("ISCLUSTER") && !capStringVar.equalsIgnoreCase("ISEXTERNAL"))
									{
%>
														<td id="<%=borderfortd%>">&nbsp;</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" nowrap width="210">&nbsp;
															<egui:intnl text='<%="admin.test."+capStringVar%>'/>
														</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" align="center" nowrap width="20" height="22">:</td>
<%
									}
								}
							}
						} //skm
						else //skm
						{
							if(!capStringVar.equals("HOST") && !capStringVar.equals("PORT"))  //...to display EXCLUDEINFO...
							{
%>
													<tr>
														<td id="<%=borderfortd%>">&nbsp;</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" nowrap width="210">&nbsp;
															<egui:intnl text='<%="admin.test."+capStringVar%>'/>
														</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" align="center" nowrap width="20" height="22">:</td>
<%
							}
						} //skm
					}

					//Right side - 2 <td>'s (Closed); 1 </tr> (Closed)
					if(stringVal.indexOf("$") == 0  && !strIniVal.startsWith("-manual") && !stringVar.equalsIgnoreCase("executiontime"))
					{
						if(stringVar.equals("url")
						|| stringVar.equals("content")
						|| stringVar.equals("credentials"))
						{
							String qryString1 = request.getQueryString();
							if(request.getParameter(stringVar) != null && !(request.getParameter(stringVar).equals("")))
							{
								stringVal = request.getParameter(stringVar);
							}
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><textarea name="<%=stringVar%>" rows="5" cols="35" onBlur="javascript:opp('<%=EgURLDecoder.decode(qryString1,"UTF-8")%>','<%=stringVal%>');"> <%=stringVal.trim()%></textarea></td>
<%
						}
						else
						{
							if(request.getParameter(stringVar) != null && !(request.getParameter(stringVar).equals("")))
							{
								stringVal = request.getParameter(stringVar);
							}
							boolean showStar = false;
							if (isAutoConfiguration && stringVal.startsWith("$") && aListTcKeywordsLowerCase.contains(stringVal.toLowerCase()))
							{
								showStar = true;
							}
							if (plusButton.length()==0)
							{
								//configure esxuser
								if (stringVar.equals("Esx_user"))
								{
									if(uName.equals("")) uName = "$unconfigured";
									boolean tempShowStar = false;
									if (isAutoConfiguration && uName.startsWith("$") && aListTcKeywordsLowerCase.contains(stringVal.toLowerCase()))
									{
										tempShowStar = true;
									}
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="text" name="<%=stringVar%>" value='<%=uName%>'<%=readOnly%> >
<%
									if (tempShowStar)
									{
%>
										<font color='black'>&nbsp;*</font>
<%
									}
%>
														</td>
<%
								}
								else if (stringVar.equalsIgnoreCase("domain"))
								{
									if (listMultipleUserSupportTest != null && 
										listMultipleUserSupportTest.contains(testName))
									{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="text" name="<%=stringVar%>" value='<%=stringVal%>'<%=readOnly%> onblur="javascript:checkMultipleUser('<%=stringVar%>','<%=stringVal%>')" onfocus="javascript:getUserValue('<%=stringVar%>')" onchange="javascript:getUserChangedValue('<%=stringVar%>')">
<%
										if (showStar)
										{
%>
											<font color='black'>&nbsp;*</font>
<%
										}
%>
														</td>
<%
									}
									else if (testName.equalsIgnoreCase("CtxAuthTest") || 
										testName.equalsIgnoreCase("WinAuthTest") || 
										testName.equalsIgnoreCase("TermAuthTest"))
									{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="text" name="<%=stringVar%>" value='<%=stringVal%>'<%=readOnly%> onblur="javascript:checkMultipleUser('<%=stringVar%>','<%=stringVal%>')" onfocus="javascript:getUserValue('<%=stringVar%>')" onchange="javascript:getUserChangedValue('<%=stringVar%>')">
<%
										if (showStar)
										{
%>
											<font color='black'>&nbsp;*</font>
<%
										}
%>
														</td>
<%
									}
									else
									{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="text" name="<%=stringVar%>" value='<%=stringVal%>'>
<%
										if (showStar)
										{
%>
											<font color='black'>&nbsp;*</font>
<%
										}
%>
														</td>
<%
									}
								}
								else
								{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="text" name="<%=stringVar%>" value="<%=StringUtils.replace(stringVal .trim(),"'","&#8217;")%>" <%=readOnly%>>
<%
									if (showStar)
									{
%>
										<font color='black'>&nbsp;*</font>
<%
									}
%>
														</td>

<%
								}
							}
							else
							{
								if (stringVar.equalsIgnoreCase("user"))
								{
									if (testName.equalsIgnoreCase("CtxAuthTest") || 
										testName.equalsIgnoreCase("WinAuthTest") || 
										testName.equalsIgnoreCase("TermAuthTest"))
									{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent">
															<table cellpadding="0" cellspacing="0" border="0">
																<tr>
																	<td><input type="text" name="<%=stringVar%>" value='<%=StringUtils.replace(stringVal .trim(),"'","&#8217;")%>' onblur="javascript:checkMultipleUser('<%=stringVar%>','<%=StringUtils.replace(stringVal .trim(),"'","&#8217;")%>')" onfocus="javascript:getUserValue('<%=stringVar%>')" onchange="javascript:getUserChangedValue('<%=stringVar%>')" <%=readOnly%>>
<%
										if (showStar)
										{
%>
											<font color='black'>&nbsp;*</font>
<%
										}
%>
																	</td>
																	<td>&nbsp;<%=plusButton%></td>
																</tr>
															</table>
														</td>
<%
									}
									else
									{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent">
															<table cellpadding="0" cellspacing="0" border="0">
																<tr>
																	<td><input type="text" name="<%=stringVar%>" value='<%=StringUtils.replace(stringVal .trim(),"'","&#8217;")%>'>
<%
										if (showStar)
										{
%>
											<font color='black'>&nbsp;*</font>
<%
										}
%>
																	</td>
																	<td>&nbsp;</td>
																</tr>
															</table>
														</td>
<%
									}
								}
								else
								{
									if (stringVar.equalsIgnoreCase("admin_user"))
									{
										if (listMultipleUserSupportTest != null && 
											listMultipleUserSupportTest.contains(testName))
										{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent">
															<table cellpadding="0" cellspacing="0" border="0">
																<tr>
																	<td><input type="text" name="<%=stringVar%>" value='<%=StringUtils.replace(stringVal .trim(),"'","&#8217;")%>' <%=readOnly%> onblur="javascript:checkMultipleUser('<%=stringVar%>','<%=StringUtils.replace(stringVal .trim(),"'","&#8217;")%>')" onfocus="javascript:getUserValue('<%=stringVar%>')" onchange="javascript:getUserChangedValue('<%=stringVar%>')">
<%
											if (showStar)
											{
%>
												<font color='black'>&nbsp;*</font>
<%
											}
%>
																	</td>
																	<td>&nbsp;<%=plusButton%></td>
																</tr>
															</table>
														</td>
<%
										}
										else
										{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent">
															<table cellpadding="0" cellspacing="0" border="0">
																<tr>
																	<td><input type="text" name="<%=stringVar%>" value='<%=StringUtils.replace(stringVal .trim(),"'","&#8217;")%>'>
<%
											if (showStar)
											{
%>
												<font color='black'>&nbsp;*</font>
<%
											}
%>
																	</td>
																	<td>&nbsp;</td>
																</tr>
															</table>
														</td>
<%
										}
									}
									else
									{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent">
															<table cellpadding="0" cellspacing="0" border="0">
																<tr>
																	<td><input type="text" name="<%=stringVar%>" value='<%=StringUtils.replace(stringVal .trim(),"'","&#8217;")%>'>
<%
										if (showStar)
										{
%>
											<font color='black'>&nbsp;*</font>
<%
										}
%>
																	</td>
																	<td>&nbsp;</td>
																</tr>
															</table>
														</td>
<%
									}
								}
							}
						}
%>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
					}
					else if (stringVar.equals("ssl")
							|| stringVar.equals("recursive")
							|| stringVar.equals("isPassive")
							|| stringVar.equals("isCitrix")
							|| stringVar.equals("showServerName")
							|| stringVar.equalsIgnoreCase("fullduplex")
							|| stringVar.equalsIgnoreCase("onlyup")
							|| stringVar.equalsIgnoreCase("encryptPass")
							|| stringVar.equalsIgnoreCase("includepath")
							|| stringVar.equalsIgnoreCase("autoDiscovery")
							|| stringVar.equalsIgnoreCase("aggregateDescriptor")
						//	|| stringVar.equalsIgnoreCase("encryptFlag")
							|| stringVar.equalsIgnoreCase("Report_By_User")
							|| stringVar.equalsIgnoreCase("Report_Powered_Os")
							|| stringVar.equalsIgnoreCase("Report_Powered_On")
							|| stringVar.equalsIgnoreCase("IsVdiServer")
							|| stringVar.equalsIgnoreCase("useMgrTime")
							|| stringVar.equalsIgnoreCase("ddforinformation")
							|| stringVar.equalsIgnoreCase("ddforwarning")
							|| stringVar.equalsIgnoreCase("ddforsuccess")
							|| stringVar.equalsIgnoreCase("usewmi")
							|| stringVar.equalsIgnoreCase("restart")
							|| stringVar.equalsIgnoreCase("eventsduringrestart")
							|| stringVar.equalsIgnoreCase("showFinishedDD")
							|| stringVar.equalsIgnoreCase("useSudo")
							|| stringVar.equalsIgnoreCase("list_all_pools")
							|| stringVar.equalsIgnoreCase("Report_Cluster_ResourcePools")
							|| stringVar.equalsIgnoreCase("Show_information_DD")
							|| stringVar.equalsIgnoreCase("useWarFile")
							|| stringVar.equalsIgnoreCase("rereadLicense")
							|| stringVar.equalsIgnoreCase("Aggregate_user_sessions")
							|| stringVar.equalsIgnoreCase("ignore_winNT")
							|| stringVar.equalsIgnoreCase("discoverByState")
							|| stringVar.equalsIgnoreCase("useAlias")
							|| stringVar.equalsIgnoreCase("useexe")
							|| stringVar.equalsIgnoreCase("Is_XenFarm_server")
							|| stringVar.equalsIgnoreCase("Report_by_groupname")
							|| stringVar.equalsIgnoreCase("Only_PoweredOn_VMs")
							|| stringVar.equalsIgnoreCase("wide"))
					{
						if (request.getParameter(stringVar) != null && !(request.getParameter(stringVar).equals("")))
							stringVal = request.getParameter(stringVar);

						if(stringVal.equalsIgnoreCase("false") || stringVal.equalsIgnoreCase("no") || encryptFlag.equalsIgnoreCase("no"))
						{
							disablessl = "checked";
							enablessl = "";
						}
						else
						{
							enablessl = "checked";
							disablessl = "";
						}
						if(encryptFlag.equalsIgnoreCase("yes"))
						{
							enablessl = "checked";
							disablessl = "";
						}

						if (stringVar.equals("ssl") && (isSSlForEsx.equalsIgnoreCase("true") || isSSlForEsx.equalsIgnoreCase("yes"))) //For ESX's VC
						{
							enablessl = "checked";
							disablessl = "";
						}
						else if (stringVar.equals("ssl") && (isSSlForEsx.equalsIgnoreCase("false") || isSSlForEsx.equalsIgnoreCase("no")))
						{
							disablessl = "checked";
							enablessl = "";
						}
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="radio" class="eg_input"name="<%=stringVar%>" value="true" <%=enablessl%> ><egui:intnl text="admin.common.Yes"/>&nbsp; &nbsp; &nbsp; <input type="radio" class="eg_input"name="<%=stringVar%>" value="false" class="list" <%=disablessl%>>&nbsp; <egui:intnl text="admin.common.No"/></td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
					}
					else if(stringVar.equalsIgnoreCase("mode")) //By Anand - Start
					{
						if (testName.equalsIgnoreCase("OraTablespacesTest"))
						{
							String readOnlySelected = "";
							String rwSelected = "";
							String allSelected = "";
							if (stringVal.equalsIgnoreCase("ReadOnly"))
							{
								readOnlySelected = "selected";
							}
							else if (stringVal.equalsIgnoreCase("Read/Write"))
							{
								rwSelected = "selected";
							}
							else if (stringVal.equalsIgnoreCase("All"))
							{
								allSelected = "selected";
							}
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent">
															<select name='<%=stringVar%>'>
															<option value="All" <%=allSelected%>><egui:intnl text="admin.test.All"/></option>
															<option value="ReadOnly" <%=readOnlySelected%>><egui:intnl text="admin.test.ReadOnly"/></option>
															<option value="Read/Write" <%=rwSelected%>><egui:intnl text="admin.test.Read/Write"/></option>
															</select>
														</td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
						}
						else
						{
							String snmpSelected = "";
							String jmxSelected = "";
							String modeTempVal = new String(stringVal);
							String requestModeValue = request.getParameter("mode");
							requestModeValue = (requestModeValue==null)?"":requestModeValue;
							if (!requestModeValue.equals("")) modeTempVal = requestModeValue;
							if (modeTempVal.equalsIgnoreCase("true"))
							{
								snmpSelected = "checked";
							}
							else
							{
								jmxSelected = "checked";
							}
							query = EgURLDecoder.decode(query,"UTF-8");
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="radio" class="eg_input" name="<%=stringVar%>" value="true" <%=snmpSelected%> class="list" onclick="javascript:checkMode(this.value,'<%=query%>')"><egui:intnl text="admin.common.SNMP"/>&nbsp;&nbsp;&nbsp;<input type="radio" class="eg_input" name="<%=stringVar%>" value="false" <%=jmxSelected%> class="list"onclick="javascript:checkMode(this.value,'<%=query%>')"><egui:intnl text="admin.common.JMX"/></td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
						}
					} //By Anand - End
					else if (stringVar.equalsIgnoreCase("Profiler"))
					{
						String profilerOn = "";
						String profilerOff = "";
						String profilerValue = request.getParameter("profiler");
						profilerValue = profilerValue!=null?profilerValue:"";
						if (profilerValue.equals(""))
						{
							if (stringVal.equalsIgnoreCase("true"))
							{
								profilerOn = "checked";
							}
							else if(stringVal.equalsIgnoreCase("false"))
							{
								profilerOff = "checked";
							}
						}
						else
						{
							if (profilerValue.equalsIgnoreCase("true"))
							{
								profilerOn = "checked";
							}
							else
							{
								profilerOff = "checked";
							}
						}
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="radio"class="eg_input" name="<%=stringVar%>" value="true" <%=profilerOn%> onclick="javascript:checkProfiler(this.value,'<%=query%>')"><egui:intnl text="admin.common.On" />&nbsp;&nbsp;<input type="radio" class="eg_input" name="<%=stringVar%>" value="false" <%=profilerOff%> onclick="javascript:checkProfiler(this.value,'<%=query%>')"><egui:intnl text="admin.common.Off"/></td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
					}
					else if (stringVar.equalsIgnoreCase("Heap_Analysis"))
					{
						String heapOn = "";
						String heapOff = "";
						String heapValue = request.getParameter("javahome");
						heapValue = heapValue!=null?heapValue:"";
						if (heapValue.equals(""))
						{
							if (stringVal.equalsIgnoreCase("true"))
							{
								heapOn = "checked";
							}
							else if(stringVal.equalsIgnoreCase("false"))
							{
								heapOff = "checked";
							}
						}
						else
						{
							if (heapValue.equalsIgnoreCase("true"))
							{
								heapOn = "checked";
							}
							else
							{
								heapOff = "checked";
							}
						}
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="radio"class="eg_input" name="<%=stringVar%>" value="true" <%=heapOn%> onclick="javascript:checkHeap(this.value,'<%=query%>')"><egui:intnl text="admin.common.On" />&nbsp;&nbsp;<input type="radio" class="eg_input" name="<%=stringVar%>" value="false" <%=heapOff%> onclick="javascript:checkHeap(this.value,'<%=query%>')"><egui:intnl text="admin.common.Off"/></td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
					}
					else if(stringVar.equalsIgnoreCase("encryptflag"))
					{
						//For handling "-snmpversion" in case insensitive manner - Anand
						String originalParam = "";
						if (vecVarPair != null)
						{
							originalParam = (String)vecVarPair.get(lowerCaseVecVarPair.indexOf("-snmpcommunity")-1);
							originalParam = originalParam.substring(1);
						}

						if (request.getParameter(stringVar) != null && !(request.getParameter(stringVar).equals("")))
							stringVal = request.getParameter(stringVar);
						if(stringVal.equalsIgnoreCase("false") || stringVal.equalsIgnoreCase("no") || encryptFlag.equalsIgnoreCase("no"))
						{
							disablessl = "checked";
							enablessl = "";
						}
						else
						{
							enablessl = "checked";
							disablessl = "";
						}
						if(encryptFlag.equalsIgnoreCase("yes"))
						{
							enablessl = "checked";
							disablessl = "";
						}
						query = EgURLDecoder.decode(query,"UTF-8");
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="radio" class="eg_input"name="<%=stringVar%>" value="true" <%=enablessl%> onClick="javaScript:encryptFlagChange('yes','<%=query%>','<%=originalParam%>')"><egui:intnl text="admin.common.Yes"/>&nbsp; &nbsp; &nbsp; <input type="radio" class="eg_input"name="<%=stringVar%>" value="false" class="list" <%=disablessl%> onClick="javaScript:encryptFlagChange('no','<%=query%>','<%=originalParam%>')">&nbsp; <egui:intnl text="admin.common.No"/></td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
					}
					else if(stringVar.equalsIgnoreCase("policyFilter"))
					{
						if(Evtflag==null || Evtflag=="")
							Evtflag=stringVal;
						
						if(Evtflag.equalsIgnoreCase("true"))
						{
							disablessl ="";
							enablessl ="checked";

						}
						else
						{
							disablessl = "checked";
							enablessl = "";
						}
						query = EgURLDecoder.decode(query,"UTF-8");
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="radio" class="eg_input"name="<%=stringVar%>" value="true" <%=enablessl%> onClick="javaScript:PolicyFilterEnabled('true','<%=query%>')"><egui:intnl text="admin.common.Yes"/>&nbsp; &nbsp; &nbsp; <input type="radio" class="eg_input"name="<%=stringVar%>" value="false" class="list" <%=disablessl%> onClick="javaScript:PolicyFilterEnabled('false','<%=query%>')">&nbsp; <egui:intnl text="admin.common.No"/></td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
					}
					else if(stringVar.equals("url")
						|| stringVar.equals("targets")
						|| stringVar.equals("content")
						|| stringVar.equals("credentials"))
						
					{
						if(request.getParameter(stringVar) != null && !(request.getParameter(stringVar).equals("")))
						{
							stringVal = request.getParameter(stringVar);
						}

						if(stringVal.indexOf("!") > -1)
						{
							if(stringVar.equals("content"))
								stringVal = stringVal.replace('!',' ');
							//else
							//	stringVal = stringVal.replace('!','&');
						}

						if(stringVal.indexOf("|") > -1)
						{
							stringVal = stringVal.replace('|',',');
						}

						//display textarea
						if (stringVar.equals("url")
							|| stringVar.equals("content")
							|| stringVar.equals("credentials"))
						{
							int val=0;
%>
														<!-- <td height="30" id="<%=borderfortd%>" class="eg_subcontent" valign="top">
															<table cellspacing="0" cellpadding="0" border="0"> -->
																<!-- <tr> -->
<%
							int countcre=0;
							if(stringVar.equalsIgnoreCase("credentials"))
							{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent" valign="top">
															<table cellspacing="0" cellpadding="3" border="0" id="cell_border4" style="border-left-width:1px" width="100%">
<%
								Vector collect=new Vector();
								String uname="";
								String upass="";
								String iniurl="";
								
								if(blur.equalsIgnoreCase("true"))
								{
									//homeval=request.getParameter("home");
									iniurl=vecurl.toString();
									StringTokenizer toki=new StringTokenizer(stringforurl,",");
									while(toki.hasMoreTokens())
									{
										String blurstr =toki.nextToken(); 
										collect.add(blurstr.substring(0,blurstr.indexOf(":")));
									}
								}
								else
									collect=vecurl;

								String stricren="";
								StringTokenizer stok =new StringTokenizer(stringVal,",");
								ArrayList al_credentials=StringUtils.myTokenizer(stringVal,",");
								countcre =stok.countTokens();
								String cretanval="";
								for(int i=0;i<collect.size();i++)
								{
									String creval="";
									
									if(blur.equalsIgnoreCase("true")&&!vecurl.contains((String)collect.get(i)))  //iniurl.indexOf((String)collect.get(i))<=-1)
									{
										uname="none";
										upass="none";
									}
									else if(blur.equalsIgnoreCase("true")&& vecurl.contains((String)collect.get(i))) //iniurl.indexOf((String)collect.get(i))>-1) //collect.contains(iniurl))//
									{
										int infoindex=vecurl.indexOf((String)collect.get(i));
										creval=(String)al_credentials.get(infoindex);
										//StringTokenizer stokcre =new StringTokenizer(creval,":");
										//uname=stokcre.nextToken();
										//upass=stokcre.nextToken("");
										int idx = creval.indexOf(":");
										if(idx != -1)
										{
											uname = creval.substring(0,idx);
											upass = creval.substring(idx+1);
										}
										else
										{
											uname = "none";
											upass = "none";
										}
										creval="";
									}
									else
									{
										if(stok.hasMoreTokens())
											creval=stok.nextToken();
										//StringTokenizer stokcre =new StringTokenizer(creval,":");
										//uname=stokcre.nextToken();
										//upass=stokcre.nextToken();
										int idx = creval.indexOf(":");
										if(idx != -1)
										{
											uname = creval.substring(0,idx);
											upass = creval.substring(idx+1);
										}
										else
										{
											uname = "none";
											upass = "none";
										}
										creval="";
									}
									upass = EgCrypt.decrypt(upass);
%>
																<tr>
																	<td colspan="4" id ="eg_cellbgmedium">
													<%=EgURLDecoder.decode((String)collect.get(i),"UTF-8")%>
																	</td>
																</tr>
																<tr>
																	<td id ="eg_cellbglight" width="100" align="right"><egui:intnl text="admin.test.Username"/> : </td>
																	<td valign="top"><input type="text" name="user" value='<%=uname.trim()%>'></td>
																	<td width="100" align="right"><egui:intnl text="admin.test.Password"/> : </td>
																	<td valign="top"><input type="password" name="passw" value='<%=upass%>'></td>
																</tr>
<%
									cretanval=uname+":"+upass;
									if(!stricren.equals(""))
									stricren+=","+cretanval;
									else
									stricren=cretanval;
								}
								stringVal+=stricren;
%>
															</table>
														</td>
														<input type="hidden" name="<%=stringVar%>" value='<%=stricren%>'>
<%
								collect=new Vector();
							}
							else if (stringVar.equals("url"))
							{
								String qryString1 = request.getQueryString();
								//if(request.getParameter("home")!=null)
									//stringVal=request.getParameter("home");
								if(!stringforurl.equals(""))
									stringVal=stringforurl;

								if (!previousUrl.equals(stringVal))
								{
									stringVal = EgURLDecoder.decode(stringVal.trim(),"UTF-8");
								}

%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent" valign="top">
															<input type="text" name="<%=stringVar%>" value='<%=stringVal.trim()%>'
															onBlur="javascript:opp('<%=EgURLDecoder.decode(qryString1,"UTF-8")%>','<%=stringVal%>');"
															onChange="javascript:viewbutton();">
<%
								if(stringVal.length() > 20)
								{
									encodedValue = EgURLEncoder.encode(stringVal.trim(),"UTF-8");
%>
															&nbsp;<input type="button" name ="viewurl" class="eg_lightbutton" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%= stringVar %>')" style="width:60px;">
<%
								}
%>
														</td>
<%
							}
							else
							{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent" valign="top">
															<input type="text" name="<%=stringVar%>" value='<%=EgURLDecoder.decode(stringVal.trim(),"UTF-8")%>'>
<%
								if(stringVal.length() > 20)
								{
									encodedValue = EgURLEncoder.encode(stringVal.trim(),"UTF-8");
%>
															&nbsp;<input type="button" name ="viewurl" class="eg_lightbutton" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%= stringVar %>')" style="width:60px;">
<%
								}
%>
														</td>
<%
							}
%>
														<td id="<%=borderfortd%>">&nbsp;</td>
<%
						}
						else
						{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent">
															<input type=text name="<%=stringVar%>" value= '<%=StringUtils.replace(stringVal.trim(),"'","&#8217;")%>' >
														</td>
														<td id="<%=borderfortd%>">&nbsp;</td>
<%
						}
%>
													</tr>
<%
					}
					else if(combo)
					{
						if(stringVar.equalsIgnoreCase("snmpversion"))
						{
							group=versions;
						}
						if(stringVar.equalsIgnoreCase("authtype"))
						{
							group=authTypes;
						}
						if(stringVar.equalsIgnoreCase("encrypttype"))
						{
							group=encryptTypes;
							selection=stringVal;
						}
						String select = "";
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent">
															<select name="<%=stringVar%>" id="<%=stringVar%>" class="list" onChange='javaScript:comboChange("<%=stringVar%>","<%=query%>")'>
<%
						for(int i=0;i<group.length;i++)
						{
							if(group[i].equalsIgnoreCase(selection))
							{
								select="selected";
							}
%>
																<option value="<%=group[i]%>" <%=select%>><%=group[i]%></option>
<%
							select="";
						}
%>
															</select>
														</td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
					}
					else
					{
						if((stringVar.equals("userparams") || (stringVar.equals("recordpattern"))) && (stringVal.indexOf("^") > -1))
						{
							stringVal = stringVal.replace('^','-');
						}
						if(stringVal.trim().length() > 20 || stringVar.equals("filter"))
						{
							if(stringVar.equalsIgnoreCase("correctivescript"))
							{
								if(optvalue != null && optvalue.equalsIgnoreCase("true"))
								{
									if(!(remoteScript==null
										|| remoteScript.equalsIgnoreCase("null")
										|| remoteScript.equalsIgnoreCase("")))
									{
										stringVal = remoteScript.trim();
									}
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent">
															<input type="text" name="<%=stringVar%>" id="<%=stringVar%>" value= '<%=StringUtils.replace(stringVal.trim(),"'","&#8217;")%>'/> &nbsp;&nbsp; <input type="button" value="Choose" class = "eg_lightbutton" onClick='Javascript:openwindow1("<%=qryString%>")'>&nbsp;&nbsp;
															<input type="button" value="Clear" class = "eg_lightbutton" onClick="Javascript:clearFun('<%=stringVar%>')">
														</td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
								}
							}
							else if(stringVar.equalsIgnoreCase("filter"))
							{
								if(Evtflag==null || Evtflag=="")
									Evtflag="false";
								iniobj=new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
								if(stringVar.equals("filter") && Evtflag.equalsIgnoreCase("false"))
								{
									String FilterString="";
									String tempPolicyName;
									String tempCheck;

									if(stringVal.indexOf(":")<0)
									{
										StringTokenizer filterToken=new StringTokenizer(stringVal,";");
										while(filterToken.hasMoreElements())
										{
											tempPolicyName=filterToken.nextToken();
											FilterString=FilterString+tempPolicyName+":";
											tempCheck=testName+":"+log+":"+tempPolicyName;
											FilterString=FilterString+iniobj.getValue("EVENTLOG_POLICIES",tempCheck.trim());
											FilterString=FilterString+";";
										}
										FilterString=FilterString.substring(0,FilterString.lastIndexOf(";"));
									}
									else if(stringVal.indexOf(";")<0)
										FilterString=stringVal;
									else
									{
										FilterString="";
										String tempFilter="";
										StringTokenizer tempToken=new StringTokenizer(stringVal,":");
										while(tempToken.hasMoreElements())
											vecFilterVal.add(tempToken.nextToken());
										if(tempToken.countTokens()%6!=1)
										{
											FilterString=stringVal;
										}
									}
									FilterString=FilterString.replace('|',',');
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent" valign="top">
															<table cellspacing="0" cellpadding="0" border="0">
																<tr>
																	<td valign="top"><textarea name="<%=stringVar%>" rows="5" cols="28"><%=FilterString.trim()%></textarea></td>
<%
									encodedValue = EgURLEncoder.encode(FilterString.trim(),"UTF-8");
%>
																	<td  nowrap> &nbsp; <input type="button" class="eg_lightbutton" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%=stringVar%>')" style="width:60px;">
																	</td>
																</tr>
															</table>
														</td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
								}
								else if(stringVar.equals("filter") && Evtflag.equalsIgnoreCase("true"))
								{
									String parmTestName=request.getParameter("t_name");
									Vector var_vec=new Vector();
									var_vec=iniobj.getVariables("EVENTLOG_POLICIES",true);
									for(int i=0; i<var_vec.size(); i++)
									{
										String varCheck=(String)var_vec.elementAt(i);
										if(varCheck.indexOf(":")>0)
										{
											StringTokenizer var_st=new StringTokenizer(varCheck,":");
											String testName1=var_st.nextToken();
											if(testName1.equals(parmTestName))
											{
												var_st.nextToken();
												vecPolicyName.add(var_st.nextToken());
											}
										}
									}
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent">
<%
									String tempHidden="";
									if(stringVal.indexOf(":")>0)
									{
										StringTokenizer hiddenst=new StringTokenizer(stringVal,":");
										while(hiddenst.hasMoreElements())
										{
											vecFilterVal.add(hiddenst.nextToken());
										}
										z=0;
										policyName="";
										while(z<vecFilterVal.size())
										{
											String con=(String)vecFilterVal.get(z);
											if(con.indexOf(";")>0)
											{
												StringTokenizer tempToken=new StringTokenizer(con,";");
												tempToken.nextToken();
												policyName=tempToken.nextToken();
												policyName=policyName.trim();
												if(vecPolicyName!=null && vecPolicyName.contains(policyName))
												{
													tempHidden=tempHidden+policyName;
													tempHidden=tempHidden+";";
													tempHidden=tempHidden.trim();
												}
											}
											else
											{
												if(z==0)
												{
													if(tempHidden=="")
													{
														if(vecPolicyName!=null && vecPolicyName.contains(con))
														{
															tempHidden=con+";";
														}
													}
													else
													{
														if(vecPolicyName!=null && vecPolicyName.contains(policyName))
														{
															tempHidden=tempHidden+policyName+";";	
														}
													}
												}
											}
											z=z+6;
										}
										if(tempHidden.lastIndexOf(";")>0)
											tempHidden=tempHidden.substring(0,tempHidden.lastIndexOf(";"));
										tempHidden.trim();
									}
									else
										tempHidden=stringVal;
%>
															<input type="hidden" name="filter" value="<%=tempHidden.trim()%>"/>
															<select name="polic" size="5" width="160" style="width:160px;" onchange="javaScript:Policyadd();" multiple>
<%
									StringTokenizer tempToken;
									boolean checkFlag=true;
									/*for(int i=0; i<var_vec.size(); i++)
									{
										String varCheck=(String)var_vec.elementAt(i);
										if(varCheck.indexOf(":")>0)
										{
											StringTokenizer var_st=new StringTokenizer(varCheck,":");
											String testName1=var_st.nextToken();
											if(testName1.equals(parmTestName))
											{
												var_st.nextToken();
												vecPolicyName.add(var_st.nextToken());
											}
										}
									}*/
									String stringCon=StringUtils.replace(stringVal,"'","&#8217;");
									if(Evtflag.equalsIgnoreCase("true"))
									{
										if(stringCon.indexOf(":")>0)
										{
											con_ston=new StringTokenizer(stringCon,":");
											vecFilterVal.clear();
											while(con_ston.hasMoreElements())
												vecFilterVal.add(con_ston.nextToken());
											z=0;
											policyName="";
											while(z<vecFilterVal.size())
											{
												String con=(String)vecFilterVal.get(z);
												if(con.indexOf(";")>0)
												{
													tempToken=new StringTokenizer(con,";");
													policyName="";
													tempToken.nextToken();
													policyName=tempToken.nextToken();
													ArrListPolicyName.add(policyName);
												}
												else
												{
													if(z==0)
													{
														policyName=con;
														ArrListPolicyName.add(policyName);
													}
												}
												z=z+6;
											}
										}
										else if(stringCon.indexOf(":")<0)
										{
											con_ston=new StringTokenizer(stringCon,";");
											if(stringCon.indexOf(":")<0 && stringCon.indexOf(";")>0 )
											{
												while(con_ston.hasMoreElements())
												{
													String con=con_ston.nextToken();
													ArrListPolicyName.add(con);
												}
											}
											else
												ArrListPolicyName.add(stringVal);
										}
									}

									if (vecPolicyName.contains("all"))
									{
										vecPolicyName.remove("all");
										Collections.sort(vecPolicyName,String.CASE_INSENSITIVE_ORDER);
										vecPolicyName.add(0,"all");
									}
									else
									{
										Collections.sort(vecPolicyName,String.CASE_INSENSITIVE_ORDER);
									}

									for(int k=0; k<vecPolicyName.size(); k++)
									{
										checkFlag=true;
										String disPol=(String)vecPolicyName.get(k);
										policyName="";
										for(int x=0; x<ArrListPolicyName.size();x++)
										{
											policyName=(String)ArrListPolicyName.get(x);
											if(disPol.equals(policyName))
											{
												checkFlag=false;
%>
															<option value='<%=disPol%>' selected><%=disPol%>
															</option>
<%
											}
										}
										if(checkFlag)
										{
%>
															<option value='<%=disPol%>'><%=disPol%>
															</option>
<%
										}
									}
%>
															</select>
														</td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
								}
							}//Change for Policy
							else
							{
								if(!(stringVar.equalsIgnoreCase("USERPARAMS") && optvalue.equalsIgnoreCase("false")))
								{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent" valign="top">
															<table cellspacing="0" cellpadding="0" border="0">
																<tr>
<%
									if (stringVar.equalsIgnoreCase("domain"))
									{
										if (listMultipleUserSupportTest != null && 
											listMultipleUserSupportTest.contains(testName))
										{
%>
																	<td valign="top"><textarea name="<%=stringVar%>" rows="5" cols="28" onblur="javascript:checkMultipleUser('<%=stringVar%>','<%=StringUtils.replace(stringVal .trim(),"'","&#8217;")%>')" onfocus="javascript:getUserValue('<%=stringVar%>')" onchange="javascript:getUserChangedValue('<%=stringVar%>')"><%=stringVal.trim()%></textarea>
<%
										}
										else if (testName.equalsIgnoreCase("CtxAuthTest") || 
												testName.equalsIgnoreCase("WinAuthTest") || 
												testName.equalsIgnoreCase("TermAuthTest"))
										{
%>
																	<td valign="top"><textarea name="<%=stringVar%>" rows="5" cols="28" onblur="javascript:checkMultipleUser('<%=stringVar%>','<%=StringUtils.replace(stringVal .trim(),"'","&#8217;")%>')" onfocus="javascript:getUserValue('<%=stringVar%>')" onchange="javascript:getUserChangedValue('<%=stringVar%>')"><%=stringVal.trim()%></textarea>
<%
										}
										else
										{
%>
																	<td valign="top"><textarea name="<%=stringVar%>" rows="5" cols="28"><%=stringVal.trim()%></textarea>
<%
										}
									}
									else if (stringVar.equalsIgnoreCase("admin_user"))
									{
										if (listMultipleUserSupportTest != null && 
											listMultipleUserSupportTest.contains(testName))
										{
%>
																	<td valign="top"><textarea name="<%=stringVar%>" rows="5" cols="28" onblur="javascript:checkMultipleUser('<%=stringVar%>','<%=StringUtils.replace(stringVal .trim(),"'","&#8217;")%>')" onfocus="javascript:getUserValue('<%=stringVar%>')" onchange="javascript:getUserChangedValue('<%=stringVar%>')"><%=stringVal.trim()%></textarea>
<%
										}
										else
										{
%>
																	<td valign="top"><textarea name="<%=stringVar%>" rows="5" cols="28"><%=stringVal.trim()%></textarea>
<%
										}
									}
									else if (stringVar.equalsIgnoreCase("user"))
									{
										if (testName.equalsIgnoreCase("CtxAuthTest") || 
											testName.equalsIgnoreCase("WinAuthTest") || 
											testName.equalsIgnoreCase("TermAuthTest"))
										{
%>
																	<td valign="top"><textarea name="<%=stringVar%>" rows="5" cols="28" onblur="javascript:checkMultipleUser('<%=stringVar%>','<%=StringUtils.replace(stringVal .trim(),"'","&#8217;")%>')" onfocus="javascript:getUserValue('<%=stringVar%>')" onchange="javascript:getUserChangedValue('<%=stringVar%>')"><%=stringVal.trim()%></textarea>
<%
										}
										else
										{
%>
																	<td valign="top"><textarea name="<%=stringVar%>" rows="5" cols="28"><%=stringVal.trim()%></textarea>
<%
										}
									}
									else
									{
										if (stringVar.equals("Esx_user"))
										{
											if(!uName.equals("")) stringVal = uName;
										}
%>
																	<td valign="top"><textarea name="<%=stringVar%>" rows="5" cols="28"><%=stringVal.trim()%></textarea>
<%
										if(stringVal.length() >20)
										{
											encodedValue = EgURLEncoder.encode(stringVal.trim(),"UTF-8");
%>
																	&nbsp;<input type="button" class="eg_lightbutton" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%= stringVar %>')" style="width:60px;">
<%
										}
									}
%>
																	<td>&nbsp;<%=plusButton%></td>
																	</td>
																</tr>
															</table>
														</td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
								}
							}
						}
						else
						{
							//optvalue = request.getParameter("correctValue");
							if(stringVar !=null && stringVar.equalsIgnoreCase("correct"))
							{
								if(!isServerAgentless)
								{
									if (optvalue == null
									|| optvalue.equalsIgnoreCase("null")
									|| optvalue.equals(""))
									{
										optvalue=stringVal.trim();
										request.setAttribute("cvalue" , optvalue);
									}

									if(optvalue !=null && optvalue.equalsIgnoreCase("true"))
									{
%>
														<td id="<%=borderfortd%>" class="eg_subcontent">
														<input type = "radio"class="eg_input" name="correct" value="true" checked onClick='javascript:goTo("<%=qryString%>","true");'> <egui:intnl text="admin.common.True"/>&nbsp;&nbsp;<input type="radio"class="eg_input" name="correct" value="false" onClick='javascript:goTo("<%=qryString%>","false");'><egui:intnl text="admin.common.False"/></td>
<%
									}
									else if(optvalue !=null &&  optvalue.equalsIgnoreCase("false"))
									{
%>
														<td id="<%=borderfortd%>" class="eg_subcontent">
														<input type = "radio"class="eg_input" name="correct" value="true" onClick='javascript:goTo("<%=qryString%>","true");'> <egui:intnl text="admin.common.True"/>&nbsp;&nbsp;<input type="radio"class="eg_input" name="correct" value="false" checked onClick='javascript:goTo("<%=qryString%>","false");'><egui:intnl text="admin.common.False"/></td>
<%
									}
%>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
								}
							}
							else if(stringVar !=null && stringVar.equalsIgnoreCase("USERPARAMS"))
							{
								//optvalue = request.getParameter("correctValue");
								if(optvalue == null)
									optvalue = (String)request.getAttribute("cvalue");

								if(optvalue !=null && optvalue.equalsIgnoreCase("true"))
								{
									String paramValue = request.getParameter("userparam");
									if (paramValue == null
										|| paramValue.equalsIgnoreCase("null")
										|| paramValue.equals(""))
										paramValue=stringVal.trim();
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="text" name="<%=stringVar%>" value='<%=StringUtils.replace(paramValue,"'","&#8217;")%>' ></td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
								}
							}
							else if(stringVar != null && stringVar.equalsIgnoreCase("correctivescript"))
							{
								//optvalue = request.getParameter("correctValue");
								if(optvalue == null)
									optvalue = (String)request.getAttribute("cvalue");

								if(optvalue !=null && optvalue.equalsIgnoreCase("true"))
								{
									if(!(remoteScript==null || remoteScript.equalsIgnoreCase("null") || remoteScript.equalsIgnoreCase("")))
										stringVal = remoteScript.trim();
%>
														<td id="<%=borderfortd%>" class="eg_subcontent" >
															<input type="text" name="<%=stringVar%>"   id="<%=stringVar%>" value='<%=StringUtils.replace(stringVal,"'","&#8217;")%>' />&nbsp;&nbsp;
															<input type="button" value="Choose" class="eg_lightbutton" onClick='Javascript:openwindow1("<%=qryString%>")' />&nbsp;&nbsp;
															<input type="button" value="Clear" class = "eg_lightbutton" onClick="Javascript:clearFun('<%=stringVar%>')">
														</td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
								}
							}
							else if(stringVar !=null && stringVar.equalsIgnoreCase("ALARMTYPE"))
							{
								//optvalue = request.getParameter("correctValue");
								if(optvalue == null)
									optvalue = (String)request.getAttribute("cvalue");
								if(optvalue !=null && optvalue.equalsIgnoreCase("true"))
								{
									String paramValue = request.getParameter("userparams");
									if(paramValue == null || paramValue.equalsIgnoreCase("null") || paramValue.equals(""))
										paramValue=stringVal.trim();

									IniUI iniui = IniUI.getInstance();
									String high = iniui.getStateDisplayLabel("HIGH");
									String medium = iniui.getStateDisplayLabel("INTERMEDIATE");
									String low = iniui.getStateDisplayLabel("LOW");

									String[] options = {high, high+"/"+medium, high+"/"+medium+"/"+low};
									String[] optValues = {"H", "M", "L"};
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent">
														<!--<input type=text name=<%=stringVar%> value="<%=paramValue%>" >-->
															<select name='<%=stringVar%>' size="1" width="140" style="width:140px;"><%=HtmlUtils.setSelectOptions(options, optValues, paramValue)%></select>
														</td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
								}
							}
							else
							{
								if(stringVar.equalsIgnoreCase("executionTime"))
								{
									String qstring=request.getQueryString();
									String reqval=request.getParameter("showtimemin");
									String hourselect="";
									String dayselect="";
									String[]  optionhour={"00","01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","20","21","22","23"};
									String[] optionmin={"00","01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","20","21","22","23","24","25","26","27","28","29","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59"};

									if(reqval==null && stringVal!=null && stringVal.equalsIgnoreCase("hourly"))
										hourselect="selected";
									else if(reqval!=null && reqval.equalsIgnoreCase("hourly"))
										hourselect="selected";
									else
										dayselect="selected";
%>
														<td id="<%=borderfortd%>" class="eg_subcontentbg" >
															<select name="<%=stringVar%>" size="1" style="width:70px;" onchange="javascript:dailchange('<%=qstring%>',this.value);">
															<option value="hourly"<%=hourselect%>>
															<egui:intnl text="admin.test.Hourly"/>
															</option>
															<option value="daily" <%=dayselect%>><egui:intnl text="admin.test.Daily"/>
															</option>
															</select>&nbsp;&nbsp;
<%
									if(hourselect.equalsIgnoreCase(""))
									{
										if(!(stringVal.indexOf(":")>-1))
											stringVal="00:00";
%>
																Hrs :&nbsp;
															<select name="agenthour" size="1"  width="100" style="width:40px;">
															<%=HtmlUtils.setSelectOptions(optionhour, optionhour, stringVal.substring(0,stringVal.indexOf(":")))%>
															</select>&nbsp;&nbsp;&nbsp;</b>
															Mins :&nbsp;
															<select name="agentmin" size="1"  width="100" style="width:40px;">
																<%=HtmlUtils.setSelectOptions(optionmin, optionmin, stringVal.substring(stringVal.indexOf(":")+1))%>
															</select>
<%
									}
%>
														</td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
								}
								else
								{
									if (aggTypes.contains(_str) && (stringVar.equals("host") || stringVar.equals("port")))
									//skm ...For Hiding Textbox for host and port... ...Display excludeInfo tbox
									{
%>
													<!-- <tr> -->
														<input type="hidden" name='<%=stringVar%>' value='<%=StringUtils.replace(stringVal,"'","&#8217;")%>'>
<%
									}
									else
									{ //skm 
										if(!combo)
										{
											if(!stringVar.equalsIgnoreCase("isCluster") && !stringVar.equalsIgnoreCase("isExternal"))
											{
%>
														<!-- For Displaying Textbox -->
<%
												/*if (stringVar.equalsIgnoreCase("port")|| (stringVar.equalsIgnoreCase("host") &&  !egSpecs.isTestExternal(testName)))
												{
													out.print(" readonly ");
												*/

												// Siva Anand - Code for avoiding EG_RUNTIME to be shown to the user - Start
												if ((stringVar.equalsIgnoreCase("process") || stringVar.equalsIgnoreCase("serviceName")) && stringVal.equalsIgnoreCase("(EG_RUNTIME)"))
												{
													serverName = request.getParameter("comptype");

													String server_Nickname = "";
													if(q_ctr.equals("1"))
													{
														server_Nickname = request.getParameter("compname");
													}
													//to get hostname if either reconfigure or exclude flags become 1
													if(r_ctr.equals("1") && q_ctr.equals("1"))
													{
														server_Nickname = request.getParameter("hostname");
													}
													server_Nickname = server_Nickname.substring(0,server_Nickname.indexOf(":"));

													String host_OS = "";
													isServerAgentless = egagent.isAgentlessServer(server_Nickname,serverName);
													if (isServerAgentless)
													{
														int idx = vecVarPair.indexOf("-os");
														host_OS = (String)vecValPair.get(idx);
														host_OS = host_OS.trim();
														if (host_OS.equalsIgnoreCase("w2k"))
														{
															host_OS = "Windows2000";
														}
														else if (host_OS.equalsIgnoreCase("nt"))
														{
															host_OS = "WindowsNT";
														}
														else if (host_OS.equalsIgnoreCase("2003") || host_OS.equalsIgnoreCase("xp"))
														{
															host_OS = "Windows2003";
														}
														else if (host_OS.equalsIgnoreCase("2008") || host_OS.equalsIgnoreCase("Vista"))
														{
															host_OS = "Windows2008";
														}
														else if (host_OS.equalsIgnoreCase("solaris"))
														{
															host_OS = "Solaris";
														}
														else if (host_OS.equalsIgnoreCase("linux"))
														{
															host_OS = "Linux";
														}
														else if (host_OS.equalsIgnoreCase("aix"))
														{
															host_OS = "AIX";
														}
														else if (host_OS.equalsIgnoreCase("hpux"))
														{
															host_OS = "HPUX";
														}
														else if (host_OS.equalsIgnoreCase("tru64"))
														{
															host_OS = "Tru64";
														}
														else if (host_OS.equalsIgnoreCase("other"))
														{
															host_OS = "Other";
														}
													}
													else
													{
														String internalAgentMappingName = (String)hash.get(server_Nickname);
														if (internalAgentMappingName != null)
														{
															server_Nickname = internalAgentMappingName;
														}
														host_OS = agentconfig.getAgentOS(server_Nickname);
													}

													if(host_OS != null && !host_OS.equals("null") && !host_OS.equals(""))
													{
														String process_data = host_OS+":"+serverName+":"+testName;
														stringVal = testIniFile.getValue("OS_PROCESSPATTERN",process_data);
														if (stringVal.equals(""))
														{
															stringVal = "(EG_RUNTIME)";
														}
														stringVal = StringUtils.replace(stringVal,"#",EgConstants.COMMA);
													}
												}
												// Siva Anand - Code for avoiding EG_RUNTIME to be shown to the user - End
												//Siva Anand - Code segment to display plus sign for multiple users - Start
												if (plusButton.length() == 0)
												{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent">
<%
													if (stringVar.equalsIgnoreCase("Inside_view_using"))
													{
														String exeSelected = "";
														String tcpSelected = "";
														if (stringVal.equals("exe"))
														{
															exeSelected = "selected";
														}
														else if(stringVal.equals("tcp"))
														{
															tcpSelected = "selected";
														}
%>
															<select name='<%=stringVar%>' onchange="javascript:InsideViewChange(this.value);">
															<option value="exe" <%=exeSelected%>><egui:intnl text="admin.test.Netbios (Windows)"/></option>
															<option value="tcp" <%=tcpSelected%>><egui:intnl text="admin.test.TCP/WMI (Windows)"/></option>
															</select>
<%
													}
													else if(stringVar.equalsIgnoreCase("Using"))
													{
														String exeSelected = "";
														String apiSelected = "";
														if (stringVal.equals("exe"))
														{
															exeSelected = "selected";
														}
														else if(stringVal.equals("api"))
														{
															apiSelected = "selected";
														}
%>
															<select name='<%=stringVar%>'>
															<option value="api" <%=apiSelected%>><egui:intnl text="admin.test.Web services API"/></option>
															<option value="exe" <%=exeSelected%>><egui:intnl text="admin.test.Command Line Interface"/></option>
															</select>
<%
													}
													else
													{
														if (testList.contains(stringVar))
														{
%>
															<input type="text" name='<%=stringVar%>' readonly value='<%=StringUtils.replace(stringVal,"'","&#8217;")%>' class="list">
<%
														}
														else
														{
															if (stringVar.equalsIgnoreCase("VIRTUAL_CENTER"))
															{
																if (vc == null) vc = stringVal;
																String qstring=request.getQueryString();
%>
															<select name="virtual_center" id="virtual_center"  style="width:150px;" onChange="javascript:vc_onChange('<%=qstring%>')">
															<option value='None'><egui:intnl text="admin.test.None"/></option>
<%
															if (vCenter != null && !vCenter.isEmpty())
															{
																for (int i=0;i<vCenter.size();i++)
																{
																	String s=(String)vCenter.get(i);
%>
															<option value="<%=s%>" <%=s.equals(vc)?"selected":""%>><%=s%></option>
<%
																}
															}
															else
															{
																if (!vc.equalsIgnoreCase("none"))
																{
%>
															<option value='<%=vc%>' selected><%=vc%></option>
<%
																}
															}
%>
															<option value='Other'><egui:intnl text="admin.test.Other"/></option>
															</select>
<%
															}
															else
															{
																//recofigure the esxusername
																if(stringVar.equals("Esx_user"))
																{
																	if (!uName.equals("")) stringVal = uName;
%>
															<input type="text" name='<%=stringVar%>' value='<%=StringUtils.replace(stringVal,"'","&#8217;")%>' class="list">
<%
																}
																else
																{
																	if(stringVar.equalsIgnoreCase("domain"))
																	{
																		if (listMultipleUserSupportTest != null && 
																			listMultipleUserSupportTest.contains(testName))
																		{
%>
															<input type="text" name='<%=stringVar%>' value='<%=StringUtils.replace(stringVal,"'","&#8217;")%>' onblur="javascript:checkMultipleUser('<%=stringVar%>','<%=stringVal%>')" onfocus="javascript:getUserValue('<%=stringVar%>')" onchange="javascript:getUserChangedValue('<%=stringVar%>')" class="list" <%=readOnly%>>
<%
																		}
																		else if (testName.equalsIgnoreCase("CtxAuthTest")|| 
																				testName.equalsIgnoreCase("WinAuthTest") || 
																				testName.equalsIgnoreCase("TermAuthTest"))
																		{
%>
															<input type="text" name='<%=stringVar%>' value='<%=StringUtils.replace(stringVal,"'","&#8217;")%>' onblur="javascript:checkMultipleUser('<%=stringVar%>','<%=stringVal%>')" onfocus="javascript:getUserValue('<%=stringVar%>')" onchange="javascript:getUserChangedValue('<%=stringVar%>')" class="list" <%=readOnly%>>
<%
																		}
																		else
																		{
%>
															<input type="text" name='<%=stringVar%>' value='<%=StringUtils.replace(stringVal,"'","&#8217;")%>' class="list">
<%
																		}
																	}
																	else
																	{
																		if (testName.equals("RadiusServiceTest") && stringVar.equalsIgnoreCase("AuthType"))
																		{
																			String chapSelected = "";
																			String papSelected = "";
																			if (stringVal.equals("chap"))
																			{
																				chapSelected = "selected";
																			}
																			else
																			{
																				papSelected = "selected";
																			}
%>
															<select name='<%=stringVar%>'>
															<option value="chap" <%=chapSelected%>>CHAP</option>
															<option value="pap" <%=papSelected%>>PAP</option>
															</select>
<%
																		}
																		else if (stringVar.equalsIgnoreCase("webPort"))
																		{
																			if (stringVal.equalsIgnoreCase("default"))
																			{
																				if (vc == null || vc.equalsIgnoreCase("none"))
																				{
%>
															<input type="text" name='<%=stringVar%>' value='<%=tempWebPort%>' class="list">
<%
																				}
																				else
																				{
%>
															<input type="text" name='<%=stringVar%>' value='<%=webPort%>' class="list">
<%
																				}
																			}
																			else
																			{
																				if (!webPort.equals("")) stringVal = webPort;
%>
															<input type="text" name='<%=stringVar%>' value='<%=stringVal%>' class="list">
<%
																			}
																		}
																		else if (stringVar.equalsIgnoreCase("report_by_file_system"))
																		{
																			String remoteSelected = "";
																			String localSelected = "";
																			String bothSelected = "";
																			if (stringVal.equals("remote"))
																			{
																				remoteSelected = "selected";
																			}
																			else if (stringVal.equals("local"))
																			{
																				localSelected = "selected";
																			}
																			else
																			{
																				bothSelected = "selected";
																			}
%>
															<select name='<%=stringVar%>'>
															<option value="remote" <%=remoteSelected%>>Remote Filesystem</option>
															<option value="local" <%=localSelected%>>Local Filesystem</option>
															<option value="both" <%=bothSelected%>>Both</option>
															</select>
<%
																		}
																		else
																		{
%>
															<input type="text" name='<%=stringVar%>' value="<%=StringUtils.replace(stringVal,"'","&#8217;")%>" class="list" <%=readOnly%>>
<%
																		}
																	}
																}
															}
														}
													}
%>
														</td>
<%
												}
												else
												{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent" align="left">
															<table cellpadding="0" cellspacing="0" border="0">
																<tr>
<%
													if (stringVar.equalsIgnoreCase("admin_user"))
													{
														if (listMultipleUserSupportTest != null && 
															listMultipleUserSupportTest.contains(testName))
														{
%>
																	<td><input type="text" name="<%=stringVar%>" value='<%=StringUtils.replace(stringVal .trim(),"'","&#8217;")%>' <%=readOnly%> onblur="javascript:checkMultipleUser('<%=stringVar%>','<%=StringUtils.replace(stringVal .trim(),"'","&#8217;")%>')" onfocus="javascript:getUserValue('<%=stringVar%>')" onchange="javascript:getUserChangedValue('<%=stringVar%>')">&nbsp;</td>
																	<td>&nbsp;&nbsp;<%=plusButton%></td>
<%
														}
														else
														{
%>
																	<td><input type="text" name="<%=stringVar%>" value='<%=StringUtils.replace(stringVal .trim(),"'","&#8217;")%>'>&nbsp;</td>
																	<td>&nbsp;&nbsp;</td>
<%
														}
													}
													else if (stringVar.equalsIgnoreCase("user"))
													{
														if (testName.equalsIgnoreCase("CtxAuthTest") || 
															testName.equalsIgnoreCase("WinAuthTest") || 
															testName.equalsIgnoreCase("TermAuthTest"))
														{
%>
																	<td><input type="text" name="<%=stringVar%>" value='<%=StringUtils.replace(stringVal .trim(),"'","&#8217;")%>' onblur="javascript:checkMultipleUser('<%=stringVar%>','<%=StringUtils.replace(stringVal .trim(),"'","&#8217;")%>')" onfocus="javascript:getUserValue('<%=stringVar%>')" onchange="javascript:getUserChangedValue('<%=stringVar%>')" <%=readOnly%>>&nbsp;</td>
																	<td>&nbsp;&nbsp;<%=plusButton%></td>
<%
														}
														else
														{
%>
																	<td><input type="text" name="<%=stringVar%>" value='<%=StringUtils.replace(stringVal .trim(),"'","&#8217;")%>'>&nbsp;</td>
																	<td>&nbsp;&nbsp;</td>
<%
														}
													}
													else
													{
%>
																	<td><input type="text" name="<%=stringVar%>" value='<%=StringUtils.replace(stringVal .trim(),"'","&#8217;")%>' <%=readOnly%>>&nbsp;</td>
																	<td>&nbsp;&nbsp;</td>
<%
													}
%>
																</tr>
															</table>
														</td>
<%
												}
												//Siva Anand - Code segment to display plus sign for multiple users - End

												//To configure value for specific Descriptor - 8/7/2008 - Ramesh KB 
												String test_name = request.getParameter("t_name");
												String component_name = request.getParameter("compname");
												String paramValue=StringUtils.replace(stringVal,"'","&#8217;");
												if (testList.contains(stringVar))
												{
													String url = "EgDetailsTest.jsp?t_name="+test_name+"&c_name="+component_name+"&p_value="+paramValue+"&p_name="+stringVar+"";
%>
														<td width="50%"id="<%=borderfortd%>">
															<table cellpadding="0" cellspacing="0" border="0">
																<tr>
																	<td>
																		<img class="mouse" src= "../admin/eg_images/descriptor-1.gif" border="0" onClick="javascript:openDescriptorDetails(this.event,'<%=url%>');"title='<egui:intnl text="configmgmt.common.Click here to configure value for specific Descriptor" />'>&nbsp;
																	</td>
																</tr>
															</table>
														</td>
<%
												}
												else
												{
%>
														
														<td id="<%=borderfortd%>">&nbsp;</td>
<%
												}
%>
													</tr>
<%
											}
										}
									}
								}
							}
						}
					}
				}
				else if ((stringVar.indexOf("alpassword") > -1)
					|| (stringVar.indexOf("aluser") > -1)
					|| (stringVar.indexOf("agentless") > -1)
					|| (stringVar.indexOf("almode") > -1)
					/*
					 * Why are other stringVar checked for a contains? Why not equalsIgnoreCase?
					 * equalsIgnoreCase used with OS so that HOST field is displayed, but OS
					 *(for agentless) is not.
					 */
					|| (stringVar.equalsIgnoreCase("os"))
					|| (stringVar.indexOf("sshPort") > -1)
					|| (stringVar.indexOf("remotePort") > -1))
				{
					if(request.getParameter(stringVar) != null && !(request.getParameter(stringVar).equals("")))
					{
						stringVal = request.getParameter(stringVar);
					}
%>
														<input type="hidden" name="<%=stringVar%>" value="<%=stringVal%>">
<%
						auditLogHashtable.remove(stringVar);
				}
			}
			else
			{
				/*
				 * Will come here if stringVal contains a # or a | in it. These characters should
				 * be replaced with commas (,).
				 *
				 * eg_specs.ini defines separators in TEST_INFO_DELIMITERS. If stringVar matches
				 * the value for TEST_INFO_PATTERN, use the separator defined for the test in
				 * TEST_INFO_DELIMITERS. Otherwise, replace | with a comma.
				 *
				 */
				String strReplace = "";
				if ((stringVar.equals(testInfoPattern) && stringVal.indexOf(testInfoDelimiter) > -1) ||
					(stringVar.equalsIgnoreCase("userparams") && stringVal.indexOf(testInfoDelimiter) > -1))
				{
					if (testInfoDelimiter.trim().length()==0)
						testInfoDelimiter = "#";
					strReplace = StringUtils.replace(stringVal, testInfoDelimiter, EgConstants.COMMA);
				}
				else if (stringVal.indexOf(EgConstants.PIPE) > -1)
				{
					strReplace = StringUtils.replace(stringVal, EgConstants.PIPE, EgConstants.COMMA);
				}
				//---Replaced by the block above
				//				if(stringVal.indexOf("#") > -1)
				//				{
				//					strReplace = stringVal.replace('#', ',');
				//				}
				//				else if(stringVal.indexOf("|") > -1)
				//				{
				//					strReplace = stringVal.replace('|', ',');
				//				}
				if(strReplace.indexOf("!") > -1)
				{
					if(stringVar.equals("content"))
					{
						strReplace = strReplace.replace('!', ' ');
					}
					else
					{
						//if(!stringVar.equals("searchpattern") && !stringVar.equalsIgnoreCase("process"))
						//{
						//	strReplace = strReplace.replace('!', '&');
						//}
					}
				}
				//providing pop-up window adjacent to user parameter to configure user  to  for muti-user enabled test - starts
				//also set user parameter to readOnly mode
				String readOnly = "";
				String plusButton = "";
				if (listMultipleUserSupportTest != null && listMultipleUserSupportTest.contains(testName))
				{
					if (((stringVar.equalsIgnoreCase("domain") || stringVar.equalsIgnoreCase("admin_user")) && strReplace.indexOf(",")>-1) || 
						((stringVar.equalsIgnoreCase("admin_password")) && stringVal.indexOf("#~#")>-1))
					{
						readOnly = "readOnly";
					}

					if (multiUserMode && (stringVar.equalsIgnoreCase("admin_user")))
					{
						plusButton = "<img src=\"/final/admin/eg_images/plus.gif\" title=\"Click here to configure user(s)\" class=\"leftmouse\" onClick=\"config_popup(\'./VmgUsers.jsp?server="+str_comp_type+"&test="+testName+"&port="+b_isPortRelevantForTest+"&compname="+EgURLEncoder.encode(removeNull(str_comp_name),"UTF-8")+"&showAll="+showAll+"&logtype="+log+"\',\'\',\'width=900,height=380,top=150,left=50\')\">";
					}
				}
				if (testName.equalsIgnoreCase("CtxAuthTest") || 
					testName.equalsIgnoreCase("WinAuthTest") || 
					testName.equalsIgnoreCase("TermAuthTest"))
				{
					if (((stringVar.equalsIgnoreCase("domain") || stringVar.equalsIgnoreCase("user")) && strReplace.indexOf(",")>-1) || 
						((stringVar.equalsIgnoreCase("password")) && stringVal.indexOf("#~#")>-1))
					{
						readOnly = "readOnly";
					}
					if (multiUserMode && (stringVar.equalsIgnoreCase("user")))
					{
						plusButton = "<img src=\"/final/admin/eg_images/plus.gif\" title=\"Click here to configure user(s)\" class=\"leftmouse\" onClick=\"config_popup(\'./EgConfigureMultipleUsers.jsp?server="+str_comp_type+"&test="+testName+"&port="+b_isPortRelevantForTest+"&compname="+EgURLEncoder.encode(removeNull(str_comp_name),"UTF-8")+"&showAll="+showAll+"&logtype="+log+"\',\'\',\'width=900,height=380,top=150,left=50\')\">";

					}
				}
				//providing pop-up window adjacent to user parameter to configure user  to  for muti-user enabled test - ends

				if (!stringVar.equalsIgnoreCase("aluser") && !stringVar.equalsIgnoreCase("alpassword"))
				{
%>
													<tr>
														<td id="<%=borderfortd%>">&nbsp;</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" nowrap width="210">&nbsp;
															<egui:intnl text='<%="admin.test."+capStringVar%>'/>
														</td>
														<td id="<%=borderfortd%>" class="eg_subcontent" align="center" nowrap width="20" height="22">:</td>
<%
				}

				if(stringVal.indexOf("$") == 0)
				{
					if (stringVar.equalsIgnoreCase("password") || 
						stringVar.equalsIgnoreCase("admin_password") || 
						stringVar.equalsIgnoreCase("Esx_password") || 
						stringVar.equalsIgnoreCase("authpass") || 
						stringVar.equalsIgnoreCase("encryptpassword") || 
						stringVar.equalsIgnoreCase("proxyPassword") || 
						stringVar.equalsIgnoreCase("Vc_password") || 
						stringVar.equalsIgnoreCase("sendpassword") || 
						stringVar.equalsIgnoreCase("receivepassword") || 
						stringVar.equalsIgnoreCase("xen_password") || 
						stringVar.equalsIgnoreCase("From_User_Password"))
					{
						if (stringVar.equalsIgnoreCase("admin_password"))
						{
							if (listMultipleUserSupportTest != null && 
								listMultipleUserSupportTest.contains(testName))
							{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" value="<%=stringVal.trim()%>" class="list" onblur="javascript:checkHashTildeHash()" <%=readOnly%>>
<%
							}
							else
							{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" value="<%=stringVal.trim()%>" class="list">
<%
							}
						}
						else
						{
							if (stringVar.equalsIgnoreCase("password"))
							{
								if (testName.equalsIgnoreCase("CtxAuthTest") || 
									testName.equalsIgnoreCase("WinAuthTest") || 
									testName.equalsIgnoreCase("TermAuthTest"))
								{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" value="<%=stringVal.trim()%>" class="list" <%=readOnly%> onblur="javascript:checkHashTildeHash()">
<%
								}
								else
								{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" value="<%=stringVal.trim()%>" class="list">
<%
								}
							}
							else
							{
								if (stringVar.equalsIgnoreCase("Esx_password") && uPass.length() > 0)
								{
									stringVal = uPass;
								}
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" value="<%=stringVal.trim()%>" class="list" <%=readOnly%>>
<%
							}
						}
					}
					else
					{
						if (strReplace.length() == 0)
						{
							strReplace = stringVal;
						}
						boolean showStar = false;
						if (stringVal.equalsIgnoreCase("$unconfigured"))
						{
							showStar = true;
						}
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><textarea name="<%=stringVar%>" rows="5" cols="28" ><%=strReplace.trim()%></textarea>
<%
						if (showStar)
						{
%>
							<font color='black'>&nbsp;*</font>
<%
						}
						if(strReplace.length() > 20)
						{
							encodedValue = EgURLEncoder.encode(strReplace.trim(),"UTF-8");
%>
															<input type="button" class="eg_lightbutton" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%= stringVar %>')" >
<%
						}
					}
				}
				else
				{
					if (stringVar.equalsIgnoreCase("password") || 
						stringVar.equalsIgnoreCase("admin_password") || 
						stringVar.equalsIgnoreCase("Esx_password") || 
						stringVar.equalsIgnoreCase("authpass") || 
						stringVar.equalsIgnoreCase("encryptpassword") || 
						stringVar.equalsIgnoreCase("proxyPassword") || 
						stringVar.equalsIgnoreCase("Vc_password") || 
						stringVar.equalsIgnoreCase("sendpassword") || 
						stringVar.equalsIgnoreCase("receivepassword") || 
						stringVar.equalsIgnoreCase("xen_password") || 
						stringVar.equalsIgnoreCase("From_User_Password"))
					{
						if (stringVar.equalsIgnoreCase("admin_password"))
						{
							if (listMultipleUserSupportTest != null && 
								listMultipleUserSupportTest.contains(testName))
							{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" value="<%=stringVal.trim()%>" class="list" onblur="javascript:checkHashTildeHash()" <%=readOnly%>>
<%
							}
							else
							{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" value="<%=stringVal.trim()%>" class="list">
<%
							}
						}
						else
						{
							if (stringVar.equalsIgnoreCase("password"))
							{
								if (testName.equalsIgnoreCase("CtxAuthTest") || 
									testName.equalsIgnoreCase("WinAuthTest") || 
									testName.equalsIgnoreCase("TermAuthTest"))
								{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" value="<%=stringVal.trim()%>" class="list" <%=readOnly%> onblur="javascript:checkHashTildeHash()" >
<%
								}
								else
								{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" value="<%=stringVal.trim()%>" class="list">
<%
								}
							}
							else
							{
								if (stringVar.equalsIgnoreCase("Esx_password") && uPass.length() > 0)
								{
									stringVal = uPass;
								}
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="<%=stringVar%>" value="<%=stringVal.trim()%>" class="list" <%=readOnly%>>
<%
							}
						}
					}
					else if(stringVar.equalsIgnoreCase("correctivescript"))
					{
						if(strReplace != null && strReplace.length() > 0)
						{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent">
														<textarea name="<%=stringVar%>" rows="5" cols="27" id="<%=stringVar%>" class="list" ><%=strReplace.trim()%></textarea>
<%
							if(strReplace.length() > 20)
							{
%>
															<input type="button" value="Choose" class="eg_lightbutton" onClick='Javascript:openwindow1("<%=qryString%>")' />&nbsp;&nbsp;
															<input type="button" value="Clear" class = "eg_lightbutton" onClick="Javascript:clearFun('<%=stringVar%>')">
<%
							}
						}
					}
					else
					{
						if (stringVar.equalsIgnoreCase("userparams") && strReplace.indexOf("^")>-1)
						{
							strReplace = strReplace.replace('^','-');
						}
						if(strReplace != null && strReplace.length() > 0)
						{
							if (plusButton.length() == 0)
							{
								if (stringVar.equalsIgnoreCase("domain"))
								{
									if (listMultipleUserSupportTest != null && 
										listMultipleUserSupportTest.contains(testName))
									{
%>
														<td height="30" id="<%=borderfortd%>"class="eg_subcontent"><textarea name="<%=stringVar%>" rows="5" cols="27" class="list" <%=readOnly%> onblur="javascript:checkMultipleUser('<%=stringVar%>','<%=strReplace%>')" onfocus="javascript:getUserValue('<%=stringVar%>')"
														onchange="javascript:getUserChangedValue('<%=stringVar%>')"><%=strReplace.trim()%></textarea>
<%
									}
									else if (testName.equalsIgnoreCase("CtxAuthTest") || 
											testName.equalsIgnoreCase("WinAuthTest") || 
											testName.equalsIgnoreCase("TermAuthTest"))
									{
%>
														<td height="30" id="<%=borderfortd%>"class="eg_subcontent"><textarea name="<%=stringVar%>" rows="5" cols="27" class="list" <%=readOnly%> onblur="javascript:checkMultipleUser('<%=stringVar%>','<%=strReplace%>')" onfocus="javascript:getUserValue('<%=stringVar%>')" onchange="javascript:getUserChangedValue('<%=stringVar%>')"><%=strReplace.trim()%></textarea>
<%
									}
									else
									{
%>
														<td height="30" id="<%=borderfortd%>"class="eg_subcontent"><textarea name="<%=stringVar%>" rows="5" cols="27" class="list"><%=strReplace.trim()%></textarea>
<%
									}
								}
								else
								{
%>
														<td height="30" id="<%=borderfortd%>"class="eg_subcontent"><textarea name="<%=stringVar%>" rows="5" cols="27" class="list" <%=readOnly%>><%=strReplace.trim()%></textarea>
<%
								}
							}
							else
							{
								if (stringVar.equalsIgnoreCase("admin_user"))
								{
									if (listMultipleUserSupportTest != null && 
										listMultipleUserSupportTest.contains(testName))
									{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent" align="left">
															<table cellpadding="0" cellspacing="0" border="0">
																<tr>
																	<td><textarea name="<%=stringVar%>" rows="5" cols="27" class="list" <%=readOnly%> onblur="javascript:checkMultipleUser('<%=stringVar%>','<%=strReplace.trim()%>')" onfocus="javascript:getUserValue('<%=stringVar%>')" onchange="javascript:getUserChangedValue('<%=stringVar%>')"
																	><%=strReplace.trim()%></textarea></td>
																	<td valign="top">&nbsp;&nbsp;<%=plusButton%></td>
																</tr>
															</table>
<%
									}
									else
									{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent" align="left">
															<table cellpadding="0" cellspacing="0" border="0">
																<tr>
																	<td><textarea name="<%=stringVar%>" rows="5" cols="27" class="list"
																	><%=strReplace.trim()%></textarea></td>
																	<td valign="top">&nbsp;&nbsp;</td>
																</tr>
															</table>
<%
									}
								}
								else
								{
									if (stringVar.equalsIgnoreCase("user"))
									{
										if (testName.equalsIgnoreCase("CtxAuthTest") || 
											testName.equalsIgnoreCase("WinAuthTest") || 
											testName.equalsIgnoreCase("TermAuthTest"))
										{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent" align="left">
															<table cellpadding="0" cellspacing="0" border="0">
																<tr>
																	<td><textarea name="<%=stringVar%>" rows="5" cols="27" class="list" <%=readOnly%> onblur="javascript:checkMultipleUser('<%=stringVar%>','<%=strReplace.trim()%>')" onfocus="javascript:getUserValue('<%=stringVar%>')" onchange="javascript:getUserChangedValue('<%=stringVar%>')"><%=strReplace.trim()%></textarea></td>
																	<td valign="top">&nbsp;&nbsp;<%=plusButton%></td>
																</tr>
															</table>
<%
										}
										else
										{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent" align="left">
															<table cellpadding="0" cellspacing="0" border="0">
																<tr>
																	<td><textarea name="<%=stringVar%>" rows="5" cols="27" class="list"><%=strReplace.trim()%></textarea></td>
																	<td valign="top">&nbsp;&nbsp;</td>
																</tr>
															</table>
<%
										}
									}
									else
									{
%>
														<td height="30" id="<%=borderfortd%>" class="eg_subcontent" align="left">
															<table cellpadding="0" cellspacing="0" border="0">
																<tr>
																	<td><textarea name="<%=stringVar%>" rows="5" cols="27" class="list" <%=readOnly%>><%=strReplace.trim()%></textarea></td>
																	<td valign="top">&nbsp;&nbsp;<%=plusButton%></td>
																</tr>
															</table>
<%
									}
								}
							}

							if (strReplace.length() > 20 && !readOnly.equals("readOnly"))
							{
								encodedValue = EgURLEncoder.encode(strReplace.trim(),"UTF-8");
%>
															&nbsp;<input type="button" class="eg_lightbutton" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%= stringVar %>')" >
<%
							}
						}
						else
						{
							if (!stringVar.equalsIgnoreCase("aluser") && !stringVar.equalsIgnoreCase("alpassword"))
							{
								if (stringVar.equals("Esx_user"))
								{
									if(!uName.equals("")) stringVal = uName;
								}
%>
															<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><textarea name="<%=stringVar%>" rows="5" cols="27" class="list"><%=stringVal%></textarea>
<%
								if(strReplace.length() > 20)
								{
									encodedValue = EgURLEncoder.encode(stringVal.trim(),"UTF-8");
%>
																&nbsp;<input type="button" class="eg_lightbutton" value='<egui:intnl text="admin.common.View"/>' onClick="javascript:openSmallWindow('<%= stringVar %>')" >
<%
								}
							}
						}
					}
				}

				if(!stringVar.equalsIgnoreCase("aluser") && !stringVar.equalsIgnoreCase("alpassword"))
				{
%>
														</td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
				}

				if ((listMultipleUserSupportTest != null && listMultipleUserSupportTest.contains(testName)) || 
					testName.equalsIgnoreCase("CtxAuthTest") || 
					testName.equalsIgnoreCase("WinAuthTest") || 
					testName.equalsIgnoreCase("TermAuthTest"))
				{
					if ((stringVar.equalsIgnoreCase("password") && stringVal.indexOf("#~#") == -1) || stringVar.equalsIgnoreCase("Esx_password") || stringVar.equalsIgnoreCase("xen_password"))
					{
%>
														<tr>
															<td id="<%=borderfortd%>">&nbsp;</td>
															<td id="<%=borderfortd%>" class="eg_subcontent" nowrap width="210">&nbsp;
																<egui:intnl text="admin.test.CONFIRM PASSWORD"/>
															</td>
															<td id="<%=borderfortd%>" class="eg_subcontent" align="center" nowrap width="20" height="22">:</td>
<%
						if(stringVal.indexOf("$") == 0)
						{
							boolean showStar = false;
							if (isAutoConfiguration && stringVal.startsWith("$") && aListTcKeywordsLowerCase.contains(stringVal.toLowerCase()))
							{
								showStar = true;
							}
%>
															<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="cpwd" value="<%=stringVal%>" class="list">
<%
							if (showStar)
							{
%>
								<font color='black'>&nbsp;*</font>
<%
							}
%>
															</td>
<%
						}
						else
						{
%>
															<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="cpwd" value="<%=stringVal%>" class="list"></td>
<%
						}
%>
															<td id="<%=borderfortd%>">&nbsp;</td>
														</tr>
<%
					}
					else if (stringVar.equalsIgnoreCase("admin_password") && readOnly != null && !readOnly.equals("readOnly"))
					{
%>
														<tr>
															<td id="<%=borderfortd%>">&nbsp;</td>
															<td id="<%=borderfortd%>" class="eg_subcontent" nowrap width="210">&nbsp;
																<egui:intnl text="admin.test.CONFIRM PASSWORD"/>
															</td>
															<td id="<%=borderfortd%>" class="eg_subcontent" align="center" nowrap width="20" height="22">:</td>
															<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="Admincpwd" value="<%=stringVal%>" class="list"></td>
															<td id="<%=borderfortd%>">&nbsp;</td>
														</tr>
<%
					}
				}
				else
				{
					if (stringVar.equalsIgnoreCase("password") || 
						stringVar.equalsIgnoreCase("authpass") || 
						stringVar.equalsIgnoreCase("encryptpassword") || 
						stringVar.equalsIgnoreCase("proxyPassword") || 
						stringVar.equalsIgnoreCase("Vc_password") || 
						stringVar.equalsIgnoreCase("sendpassword") || 
						stringVar.equalsIgnoreCase("receivepassword") || 
						stringVar.equalsIgnoreCase("xen_password") || 
						stringVar.equalsIgnoreCase("From_User_Password"))
					{
%>
														<tr>
															<td id="<%=borderfortd%>">&nbsp;</td>
															<td id="<%=borderfortd%>" class="eg_subcontent" nowrap width="210">&nbsp;
																<egui:intnl text="admin.test.CONFIRM PASSWORD"/>
															</td>
															<td id="<%=borderfortd%>" class="eg_subcontent" align="center" nowrap width="20" height="22">:</td>
<%
						if(stringVal.indexOf("$") == 0)
						{
							boolean showStar = false;
							if (stringVal.equalsIgnoreCase("$unconfigured"))
							{
								showStar = true;
							}
%>
															<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="cpwd" value="<%=stringVal%>" class="list">
<%
							if (showStar)
							{
%>
								<font color='black'>&nbsp;*</font>
<%
							}
%>
															</td>
<%
						}
						else
						{
%>
															<td height="30" id="<%=borderfortd%>" class="eg_subcontent"><input type="password" name="cpwd" value="<%=stringVal%>" class="list"></td>
<%
						}
%>
															<td id="<%=borderfortd%>">&nbsp;</td>
														</tr>
<%
					}
				}
			} // end of else if
			if(comm_show && stringVar.equalsIgnoreCase("snmpcommunity"))
			{
				others_show=true;
			}
		} // end of for g
%>
			<!--NEW CODE FOR DD DISABLE STARTS-->
<%
		/*
		 *	CODE FOR DISABLE DD WRITES INTO eg_testinfo.ini  ---Gopi(Option setting for DD)
		 */
		//Initial check for DD frequency from eg_tests.ini [FREQUENCY_MAPPING] if normal and bad = 0 no dd option
		boolean b_DDOption = true ;
		prgBean.createFile("eg_tests.ini");
		String[] s_freqVars = prgBean.getVariables("FREQUENCY_MAPPING");
		for(int i=0; i<s_freqVars.length; i+=2)
		{
			String normal = s_freqVars[i];
			String bad = s_freqVars[i+1];

			if(prgBean.getStrValue("FREQUENCY_MAPPING", normal).equalsIgnoreCase("0")
				&& prgBean.getStrValue("FREQUENCY_MAPPING", bad).equalsIgnoreCase("0"))
			{
				b_DDOption = false ;
			}
		}

		if(b_DDOption)
		{
			prgBean.createFile("eg_format.ini");
			String[] s_ddVars = prgBean.getVariables("FORMAT");
			Vector v_ddtest = new Vector();
			for(int i=0;i<s_ddVars.length ;i++)
			{
				String s_ddtest = s_ddVars[i].substring(0,s_ddVars[i].indexOf(":"));
				if(!v_ddtest.contains(s_ddtest))
					v_ddtest.addElement(s_ddtest);
			}

			String addNull="";
			if(str_host_name.indexOf(":")==-1)
				addNull = ":NULL";

			Vector v_disableDD = new Vector();
			if(testName != null && v_ddtest.contains(testName))
			{
				prgBean.createFile("eg_testinfo.ini");
				String[] s_disable_vars = prgBean.getVariables("Disable_DD");
				for(int i=0;i<s_disable_vars.length;i++)
				{
					if(!v_disableDD.contains(s_disable_vars[i]))
						v_disableDD.addElement(s_disable_vars[i]);
				}

				//for specific server disable dd
				Vector v_specificVars = new Vector();
				String[] s_specificVars = prgBean.getVariables("Disable_Specific_DD");
				for(int i=0;i<s_specificVars.length;i++)
				{
					if(s_specificVars[i] != null)
					{
						v_specificVars.add(s_specificVars[i]);
						v_specificVars.add(prgBean.getStrValue("Disable_Specific_DD", s_specificVars[i]));
					}
				}

				boolean specificDDCheck = false;
				if(v_specificVars != null && v_specificVars.size()>1)
				{
					for(int i=0;i<v_specificVars.size();i+=2)
					{
						String ser_name = v_specificVars.get(i).toString();
						String s_values = v_specificVars.get(i+1).toString();
						String s_dd_hostname = str_host_name+addNull;

						if(s_dd_hostname.equalsIgnoreCase(ser_name))
						{
							Vector v_spec_DDTests = new Vector();
							StringTokenizer st1 = new StringTokenizer(s_values, EgConstants.COMMA);
							while(st1.hasMoreTokens())
							{
								String t = st1.nextToken();
								if(!v_spec_DDTests.contains(t))
									v_spec_DDTests.addElement(t);
							}
							if(v_spec_DDTests.contains(testName))
							{
								specificDDCheck = true;
								break;
							}
						}
					}
				}

				String ddon ="",ddoff="";
				boolean hardCode = false;
				if(v_disableDD.contains(testName))
					hardCode = true;
				if(v_disableDD.contains(testName) || specificDDCheck)
					ddoff = "checked";
				else
					ddon = "checked";
				if(ddon!=null && !ddon.equals(""))
				{
					auditLogHashtable.put("detaileddiagnosis","On");
				}
				if(ddoff!=null && !ddoff.equals(""))
				{
					auditLogHashtable.put("detaileddiagnosis","Off");
				}
%>
													<tr>
														<td id="<%=borderfortd%>">&nbsp;</td>
														<td width="210" id="<%=borderfortd%>" class="eg_subcontent" nowrap>&nbsp;
															<egui:intnl text="admin.test.DETAILED DIAGNOSIS"/>
														</td>
														<td width="20" id="<%=borderfortd%>" class="eg_subcontent" height="22" align="center">:</td>
<%
				if(hardCode)
				{
%>
														<td id="<%=borderfortd%>" class="eg_subcontent"><b><egui:intnl text="admin.common.Off"/></b></td>
															<input type="hidden" name="detaileddiagnosis" value="Off">
<%
				}
				else
				{
%>
														<td id="<%=borderfortd%>" class="eg_subcontent"><input type="radio"class="eg_input" name="detaileddiagnosis" value="On" <%=ddon%>><egui:intnl text="admin.common.On"/>&nbsp;&nbsp;<input type="radio" class="eg_input"name="detaileddiagnosis" value="Off"  <%=ddoff%>><egui:intnl text="admin.common.Off"/></td>
<%
				}
%>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
				vecThrow.addElement("detaileddiagnosis");
				vecThrow.addElement("-detaileddiagnosis");
				vecThrow.addElement(request.getParameter("detaileddiagnosis"));
			}
		}

		/*
		 *	Show update other similar servers option here
		 */
		if (b_isotherserverspresent)
		{
%>
													<tr>
														<td id="<%=borderfortd%>">&nbsp;</td>
														<td width="210" id="<%=borderfortd%>" class="eg_subcontent" nowrap>&nbsp;
															<egui:intnl text="admin.test.APPLY TO OTHER COMPONENTS"/>
														</td>
														<td width="20" id="<%=borderfortd%>" class="eg_subcontent" height="22" align="center">:</td>
														<td align="left" id="<%=borderfortd%>" class="eg_subcontent"><input type="checkbox"class="eg_input" name="applyAll" /></td>
														<td id="<%=borderfortd%>">&nbsp;</td>
													</tr>
<%
		}
%>
			<!--NEW CODE FOR DD DISABLE ENDS-->
<%
		int a=vecThrow.indexOf("-filter");
		String sess_manipulation="";
		String s1=(String)request.getAttribute("cvalue");
		String s2=request.getParameter("correctValue");

		if((s1==null ||
			s1.equalsIgnoreCase("null") ||
			s1.equalsIgnoreCase("false")) &&
			(s2 != null && !s2.equals("true")))
			sess_manipulation ="false";

		if(sess_manipulation.equalsIgnoreCase("false"))
		{
			if(vecThrow.contains("userparams"))
			{
				int index = vecThrow.indexOf("userparams");
				vecThrow.remove(index);
				vecThrow.remove(index);
				vecThrow.remove(index);
			}
			if(vecThrow.contains("correctivescript"))
			{
				int index1 = vecThrow.indexOf("correctivescript");
				vecThrow.remove(index1);
				vecThrow.remove(index1);
				vecThrow.remove(index1);
			}
			if(vecThrow.contains("alarmtype"))
			{
				int index1 = vecThrow.indexOf("alarmtype");
				vecThrow.remove(index1);
				vecThrow.remove(index1);
				vecThrow.remove(index1);
			}
		}
		session.setAttribute("tName",testName);
		session.setAttribute("vec_Return",vecThrow);
		session.setAttribute("sName",serverName);
		session.setAttribute("show",request.getParameter("showAll"));
		session.setAttribute("excludedServers",vecExServ);
%>
												</table>
											</td>
										</tr>
										<tr>
											<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
											<td id="eg_subcontentbg"  colspan="3" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
											<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
										</tr>
										<tr>
											<td colspan="5" id="eg_blankspace" height="10" class="eg_whitebg">&nbsp;
											</td>
										</tr>

										<tr>
											<td colspan="5" align="center" id="eg_whitebg">
<%
		if ((q_ctr.equals("1")
			&& (str_comp_name.equals("undefined")==false))
			|| (q_ctr.equals("1") && r_ctr.equals("1")
			&& (str_host_name.equals("null")==false)))
		{
			String allowedParams=testparamIni.getValue("SPECIAL_CHARACTERS","Parameters");
			session.setAttribute("specialCharactersAllowedParameter",allowedParams);
			String strTcKeywords = listTcKeywords.toString();
			strTcKeywords = strTcKeywords.substring(1,strTcKeywords.length()-1);
			strTcKeywords = StringUtils.replace(strTcKeywords,", ",",");
			session.setAttribute("tcKeywords",tcKeywords);
%>
												<input type="hidden" name="allowedParams" value="<%=allowedParams%>">
												<input type="hidden" name="tcKeywords" value="<%=strTcKeywords%>">
												<input type="button" value='<egui:intnl text="admin.common.Update"/>' name="update" onClick="javascript:populate1('<%= request.getParameter("t_name") %>','<%=multiUserMode%>')" class="eg_back"> &nbsp;
<%
		}
		else
		{
%>
												<a href="#" onMouseOver="ad.src=imgon4.src" onMouseOut="ad.src=imgoff4.src">
												<img src="images/updat.gif" width="85" height="21" name="ad" border=0></a>&nbsp;
<%
		}
%>
											</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
<%
	}
	String compportsid=request.getParameter("compname")+":"+request.getParameter("portNumber")+":"+request.getParameter("sidNumber");
%>
						<input type="hidden" name="comptype" value="<%=request.getParameter("typeOfServer")%>">
						<input type="hidden" name="server" value="<%=request.getParameter("typeOfServer")%>">
						<input type="hidden" name="compname" value="<%=request.getParameter("compname")%>">
						<input type="hidden" name="portRelevant" value="<%=b_isPortRelevantForTest%>">
						<input type="hidden" name="compportsid" value="<%=compportsid%>">
						<input type="hidden" name="testname" value="<%=testName%>">
						<input type="hidden" name="from" value="configTests">
						<input type="hidden" name="ComponentsForExclusion" value="">
						<input type="hidden" name="ComponentsForInclusion" value="">
						<!-- inner most table ends here -->
					</td>
				</tr>
			</table><br><br>
<%
	String qctr1 = request.getParameter("qctr");
	String rctr1 = request.getParameter("rctr");
	if(qctr1 != null && rctr1 != null && qctr1.equals("1") && rctr1.equals("1"))
	{
%>
		<input type="hidden" name="isReconfigured" value="true">
<%
	}
%>
		</td>
	</tr>
</table>
</form>
</body>
</html>

<%!
	//regarding -virtual_center parameter(maintaining the ini value for the option "none") - starts
	String tempEsxUserValue = "";
	String tempEsxPassword = "";
	String tempSslValue = "";
	String tempWebPortValue = "";
	//regarding -virtual_center parameter(maintaining the ini value for the option "none") - ends
	String urlField = "EgVcConfig.jsp";

	public String removeNull(String compName)
	{
		if (compName != null && compName.length()>0)
		{
			return (compName.endsWith(":NULL"))?compName.substring(0,compName.indexOf(":NULL")):compName;
		}
		else
		{
			return "";
		}
	}
	
	public final boolean isParameter (String s2)
	{
		String ss = EgCrypt.decrypt(s2);
		if (ss.equals(s2)) // not password
		{
			if (s2.length() > 1)
			{
				return (true);
			}
		}
		return false;
	}
	
	private Object[] getIniVarValues(String strIniVal)
	{
		/* to get remaining variable value pairs  */
		StringTokenizer st = new StringTokenizer(strIniVal, EgConstants.COMMA);
		int stCount = st.countTokens();
		String strValue= "";
		for(int g=0; g<stCount; g++)
		{
			String strTemp = st.nextToken();
			if(g==1)
			{
				strValue = strTemp;
			}
		}

		Vector vecVarPair1 = new Vector();
		Vector vecValPair1 = new Vector();

		st = new StringTokenizer(strValue," ");
		stCount = st.countTokens();
		String ss_tmp = "";

		/* To retrieve $serviceName of WinServiceTest with space($serviceName = World Wide Web */

		for(int g=0; g<stCount; g++)
		{
			String strTemp = st.nextToken();
			strTemp = strTemp.trim();

			if(strTemp.startsWith("-") && isParameter(strTemp))
			{
				vecVarPair1.addElement(strTemp);
				if(ss_tmp != null && !ss_tmp.equals(""))
				{
					vecValPair1.addElement(ss_tmp);
					ss_tmp = "";
				}
			}
			else
			{
				ss_tmp = ss_tmp + strTemp + " ";
			}
		}

		if(ss_tmp != null && !ss_tmp.equals(""))
		{
			vecValPair1.addElement(ss_tmp);
			ss_tmp = null;
		}

		Object obj[]= new Object[2];
		obj[0]=vecVarPair1;
		obj[1]=vecValPair1;
		return obj;
	
	}
%>

<%
	if(!vecPolicyName.containsAll(ArrListPolicyName))
	{
		for(int k=0; k<ArrListPolicyName.size(); k++)
		{
			policyName=(String)ArrListPolicyName.get(k);
			if(!vecPolicyName.contains(policyName))
			{
%>
				<script>
					error('<%=policyName%>');
				</script>
<%
			}
		}
%>
		<script>
			error('displayMesPopup1');
		</script>
<%
	}

	/*
	if(vecValPair!=null && vecVarPair!=null)
	{
		for(int varCount=0; varCount<vecVarPair.size(); varCount++)
		{
			ht_curVal.put(vecVarPair.get(varCount),vecValPair.get(varCount));
		}
	}*/
	
	session.setAttribute("configFrom","component");
	session.setAttribute("auditLogHashtable",auditLogHashtable);

	session.setAttribute("adminLastAccessedURL","/final/admin/EgConfigTest.jsp?"+request.getQueryString());
%>

<%!
	EgExternalInfo extInfo = new EgExternalInfo("manager");

	//Will provide the right agent (subject) for a component and its test
	private String getAgentNickName(String componentType,String compName,String testName)
	{
		boolean isExternalTest = egSpecs.isExternalTest(testName,componentType);
		List aListTempAgentsForComponent = getAgents(compName);
		String agentName = null;
		if (isExternalTest)
		{
			//external agent for external test
			agentName = (String)aListTempAgentsForComponent.get(1);
		}
		else
		{
			//internal agent or remote agent for host level test and application level test.
			agentName = (String)aListTempAgentsForComponent.get(0);
		}

		return agentName;
	}

	//provide a set of agents(internal or remote agent,external agent(s)) for a component
	private List getAgents(String componentName)
	{
		List agentsList = new ArrayList();

		Hashtable internalAgentMap = extInfo.getInternalAgentMap();
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));
		String agentNickName = "";
		boolean isRemote = false;

		// To fetch the exact agent for the selected component - start
		isRemote = extInfo.isRemoteBased(componentNickName);
		if (isRemote)
		{
			//Agentless
			agentNickName = extInfo.getRemoteAgentForHost(componentNickName);
		}
		else
		{
			//Auto or Manual
			String agentName = extInfo.getAgentFor(componentNickName);
			if (agentName != null) //Manual
			{
				if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
				{
					agentNickName = (String)internalAgentMap.get(agentName);
				}
				else
				{
					agentNickName = agentName;
				}
			}
			else //Auto
			{
				agentNickName = componentNickName;
			}
		}

		//adding an internal agent (or) a remote agent
		agentsList.add(agentNickName);
		// To fetch the exact agent for the selected component - end

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = extInfo.hasExternalAgent(componentNickName);
		if (hasExternalAgent)
		{
			String extAgents[] = extInfo.getExternalAgentsForHost(componentNickName);
			//adding one or more external agent(s)
			agentsList.addAll(Arrays.asList(extAgents));
		}
		//To fetch the external agent for the selected component type - ends

		return agentsList;
	}

	//Will provide the right pattern (variable) for a component
	private String getResultantPattern(String componentType,String componentName,String testName,String[] testVariables)
	{
		String tempResultantPattern = null;
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));
		String specificPattern_A = testName + ":" + componentType + ":" + componentName;
		String specificPattern_B = testName + ":" + componentType + ":" + componentNickName;
		String defaultPattern_A = testName + "::" + componentName;
		String defaultPattern_B = testName + "::" + componentNickName;

		List listTestVariables = Arrays.asList(testVariables);
		if (listTestVariables.contains(specificPattern_A))
		{
			tempResultantPattern = specificPattern_A;
		}
		else if (listTestVariables.contains(specificPattern_B))
		{
			tempResultantPattern = specificPattern_B;
		}
		else if (listTestVariables.contains(defaultPattern_A))
		{
			tempResultantPattern = defaultPattern_A;
		}
		else if (listTestVariables.contains(defaultPattern_B))
		{
			tempResultantPattern = defaultPattern_B;
		}

		return tempResultantPattern;
	}
%>



