<%
/**
 *	Name            :	EgDDDPurge.jsp
 *	Purpose         :	To configure Detailed Diagnosis data purge periods.
 *	Version         :	5.0
 *	CreationDate    :	15/3/2010
 *	Author          :	vaathsalya
 *	Design          :	vaathsalya
 *	Modified        :	Rekha
 */
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgMemInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgDiscInfo"%> 
<%@ page import="com.eg.EgRoleInfo" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	String egTitleSearchStr = request.getParameter("egTitleSearchStr");
	boolean isSearchResult = (egTitleSearchStr != null && !egTitleSearchStr.equals(""));
	ArrayList searchList = new ArrayList();
	boolean searchItemFound = false;
%>

<jsp:useBean id="dddcleanup" class="egurkha.TransactionBean" scope="page" />
<jsp:useBean id="disabledd" class="egurkha.TransactionBean" scope="page" />

<%!
	String licenseCheck = new String("license");
%>

<%
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	
	String componentType = request.getParameter("componentType");
	componentType = (componentType != null)?componentType:"allTests";
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	dddcleanup.createFile("eg_format.ini");
	disabledd.createFile("eg_testinfo.ini");

	String dddTests[] = dddcleanup.getVariables("DDD_CLEANUP");
	String disableDDTests[] = disabledd.getVariables("Disable_DD");
	ArrayList aListDDDisabledTests = new ArrayList(Arrays.asList(disableDDTests));
	ArrayList aListDDDTest = new ArrayList(Arrays.asList(dddTests));
	ArrayList aListResultantCtype = new ArrayList();
	ArrayList aListTests = new ArrayList();
	ArrayList aListTempDDDTest = new ArrayList();

	IniFile egSpecsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_specs.ini");

	//EgDiscInfo egDisc = new EgDiscInfo("manager");	
	//List listComponentTypes = Arrays.asList(egDisc.getComponentTypes());
	
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	List listComponentTypes = Arrays.asList(ri.getServerTypes());


	// To list those component types only which has associated tests with it in eg_format.ini - Rekha
	for(int i=0;i<listComponentTypes.size();i++)
	{
		String strComponentType = (String)listComponentTypes.get(i);
		//EgSpecsInfo egspecsInfo = new EgSpecsInfo("manager");
		//String strTests []= egspecsInfo.getDefaultTestsForServer(strComponentType);
		String strTests = egSpecsIni.getValue("DEFAULT_TEST_MAPPING",strComponentType);
		
		if (strTests != null)
		{
			//ArrayList aListTempTests = new ArrayList(Arrays.asList(strTests.toArray()));
			ArrayList aListTempTests = new ArrayList();
			StringTokenizer strTokens = new StringTokenizer(strTests,",");
			while (strTokens.hasMoreTokens())
			{
				String strToken = strTokens.nextToken().trim();
				aListTempTests.add(strToken);
			}

			for (int j=0;j<aListTempTests.size();j++)
			{
				String strTest = (String)aListTempTests.get(j);
				if (aListDDDTest.contains(strTest)) 
				{
					if(!aListResultantCtype.contains(strComponentType))
					{
						aListResultantCtype.add(strComponentType);
					}
					if(!aListTempDDDTest.contains(strTest))
					{
						aListTempDDDTest.add(strTest);
					}
				}
			}
		}
	}
	
	aListDDDTest = aListTempDDDTest; // Assigns Clubbed Tests of Managed Comp Types
	listComponentTypes = sorter.getSortedCompTypeList(aListResultantCtype);
	// Ends

	// To list the tests for the selected component type - Rekha
	ArrayList aListShowTests = new ArrayList();
	if (!componentType.equals("") && !componentType.equalsIgnoreCase("allTests"))
	{
		String strTests = egSpecsIni.getValue("DEFAULT_TEST_MAPPING",componentType);
		StringTokenizer strTokens = new StringTokenizer(strTests,",");
		while (strTokens.hasMoreTokens())
		{
			String strToken = strTokens.nextToken().trim();
			aListTests.add(strToken);
		}
		for (int i=0;i<aListDDDTest.size();i++)
		{
			String strTest = (String)aListDDDTest.get(i);
			if (aListTests.contains(strTest)) 
			{
				aListShowTests.add(strTest);
			}
		}
		aListDDDTest = aListShowTests;
	}
	// Ends
		
	// Added for search button - Rekha
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
		ArrayList searchList_final=new ArrayList();
		for (int i=0;i<aListDDDTest.size();i++)
		{
			String dddDisplay_test=(String)aListDDDTest.get(i);
			String label=_mapping.getTestDescription(dddDisplay_test);
			for (int j=0;j<searchList.size();j++)
			{
				String search_String=(String)searchList.get(j);
				if (label != null && label.toLowerCase().indexOf(search_String.toLowerCase()) != -1)
				{
					if (!searchList_final.contains(dddDisplay_test))
					{
						searchList_final.add(dddDisplay_test);
					}
				}
			}
		}
		if (searchList_final != null && searchList_final.size() > 0)
		{
			aListDDDTest=searchList_final;
			searchItemFound = true;
		}
		else
		{
			searchItemFound = false;
		}
	}
	// Ends

	aListDDDTest.removeAll(aListDDDisabledTests);
	aListDDDTest = sorter.getSortedTestList(aListDDDTest);

	boolean ddEnabled = false;
	synchronized(licenseCheck)
	{
		ddEnabled = EgMemInfo.ddEnabled;
	}
%>

<html>
<head>
<title>Database Configuration</title>
<meta name="created" content="27/12/2k">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<egui:skin ui="admin"/>
<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language="JavaScript">
function showComponents()
{
	var thisForm = document.dbconfig;
	var egTitleSearchStr = thisForm.egTitleSearchStr.value;
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	thisForm.method = "post";
	thisForm.action = "EgDDDPurge.jsp?egTitleSearchStr=";
	thisForm.submit();
}

function populate()
{
	var thisForm = document.dbconfig;
	for (l=0;l<thisForm.elements.length;l++)
	{
		if (thisForm[l].type == "text")
		{
			var name = thisForm[l].name;
			if(name=="egTitleSearchStr")
			{
				continue;
			}
			var value = thisForm[l].value;
			var regExp = (/^([1-9])+([0-9]*)$/).test(thisForm[l].value);
			if (regExp)
			{
				continue;
			}
			else
			{
				
				alert('<egui:intnl text="admin.db.Please enter non-zero whole number "/>');
				thisForm[l].focus();
				return;
			}
		}
	}
	if (isNetscape()) targetObj = document.dbconfig.update;
	if (isIE()) targetObj = document.dbconfig.update;
	targetObj.disabled = true;
	targetObj.value = '<egui:intnl text="admin.common.Updating"/>...';
	targetObj.style.color = "#B2B2B2";
	thisForm.action = "EgDDDPurgep.jsp";
	thisForm.submit();
}

function isNetscape()
{
	// get browser info. 
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0,1);

	// check for Navigator ver 4+.
	if ((appName == "Netscape") && (appVer >= 4)) return true;
	return false;
}

function isIE()
{
	// get browser info. 
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0,1);

	// check for IE ver 4+. 
	if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
	return false;
}

function submitMe(e)
{
	var thisForm = document.dbconfig;
	if ((e.which && e.which == 13) || (e.keyCode && e.keyCode == 13))
	{
		thisForm.submit();
	}
}

function egTitleSearch()
{
	var thisForm = document.dbconfig;
	var egTitleSearchStr = document.dbconfig.egTitleSearchStr.value;
	var componentType = "";
	if (thisForm.componentType != null && thisForm.componentType != undefined)
	{
		componentType = thisForm.componentType.value;
	}
	if(egTitleSearchStr==null || egTitleSearchStr=="")
	{
		window.location.href = "/final/admin/EgDDDPurge.jsp?componentType=";
	}
	else
	{
		window.location.href = "/final/admin/EgDDDPurge.jsp?egTitleSearchStr="+encodeURI(egTitleSearchStr)+"&componentType="+componentType;
	}
}

function goTo(testName)
{
	var testName1 = testName.substring(0,testName.indexOf("_"));
	var testValue = document.getElementById(testName).value;
	var thisForm = document.dbconfig;
	thisForm.action = "EgApplyToOtherTests.jsp?testName="+testName1+"&testValue="+testValue+"&strFromPage=EgDDDPurge.jsp";
	thisForm.submit();
}

function showImg(imgname,testname)
{
	var c = imgname+"inner";
	var q = imgname+"div";
	var texttitle = '<egui:intnl text="admin.common.Apply to other tests" />';
	var childCount = document.getElementById(imgname).childNodes.length;

	if(isIE()) 
	{
		if(childCount==0) 
			{
				var imgElement = document.createElement('img');
				imgElement.setAttribute("id",c);
				imgElement.setAttribute("class","mouse");
				imgElement.setAttribute("title",texttitle);
				imgElement.setAttribute("src","/final/admin/eg_images/<%=admin_Skin%>/icon_nextpage.png");
				imgElement.setAttribute("onmousedown","javascript:goTo(\'"+testname+"\')");
				document.getElementById(imgname).appendChild(imgElement);

				document.getElementById(c).onmouseover = function () 
				{ 
					document.getElementById(imgname).style.cursor = "pointer";
				}

				document.getElementById(c).onmousedown = function () 
				{ 
					document.getElementById(imgname).style.cursor = "pointer";
					goTo(testname); 
				}
			}
	}
	else 
	{
		if(childCount==1) 
			{
				var imgElement = document.createElement('img');
				imgElement.setAttribute("id",c);
				imgElement.setAttribute("class","mouse");
				imgElement.setAttribute("title",texttitle);
				imgElement.setAttribute("src","/final/admin/eg_images/<%=admin_Skin%>/icon_nextpage.png");
				imgElement.setAttribute("onmousedown","javascript:goTo(\'"+testname+"\')");
				imgElement.setAttribute("onmouseout","javascript:hideImgInside(this,event,\'"+imgname+"\')");
				document.getElementById(imgname).appendChild(imgElement);
			}
	}
	
}

function is_child_of(parent, child) 
{
	if( child != null ) 
	{			
		while( child.parentNode ) 
			{
				if( (child = child.parentNode) == parent ) 
				{
					return true;
				}
			}
	}
	return false;
}

function showImgInside(imgname)
{
	var c = imgname+"inner";
	document.getElementById(c).title = "Apply to other tests";
	document.getElementById(c).tooltip = "Apply to other tests";
}

function hideImgInside(element,event,imgname1)
{
	var d = imgname1+"inner";
	var p = imgname1+"div";
	var current_mouse_target = null;
		if( event.toElement ) 
		{				
			current_mouse_target 			 = event.toElement;
		}
		else if( event.relatedTarget ) 
		{				
			current_mouse_target 			 = event.relatedTarget;
		}
		if( !is_child_of(element, current_mouse_target) && element != current_mouse_target ) 
		{
			document.getElementById(p).style.visibility = "hidden";
		}
}

function hideImg(element,event,imgname)
{
	var d = imgname+"inner";
	var p = imgname+"div";
	var current_mouse_target = null;
	if( event.toElement ) 
	{				
		current_mouse_target 			 = event.toElement;
	} 
	else if( event.relatedTarget ) 
	{				
		current_mouse_target 			 = event.relatedTarget;
	}
	if( !is_child_of(element, current_mouse_target) && element != current_mouse_target ) 
	{
		document.getElementById(imgname).innerHTML = " ";
	}
}
</script>
</head>

<body style="overflow:auto" id="space6">

<%
	if (ddEnabled)
	{
%>
<form name="dbconfig" method="post" action="javascript:egTitleSearch();" style="margin:0px" onkeypress="javascript:submitMe(event);">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<jsp:include page="listSearch.jsp?title=DATA MANAGEMENT - Detailed Diagnosis Data Purge Periods&subtitle=true&backButton=true&searchBox=true"/>

	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="middle">
<%
		//if (listComponentTypes != null && listComponentTypes.size() > 0)
		if (listComponentTypes != null)
		{
%>
			<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0" class="eg_subcontentbg">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>

				<tr>
					<td width="47%" align="right" nowrap> <egui:intnl text="admin.server.Component type"/>&nbsp;&nbsp;&nbsp;:&nbsp;&nbsp;&nbsp;</td>
					<td align="left" class="paddingright">
						<select name="componentType" id ="componentType" style="width:150px" onchange="javascript:showComponents()">
<%

			if(componentType != null && componentType.equalsIgnoreCase("allTests"))
			{
%>
				<option value="<%=componentType%>" selected><egui:intnl text="admin.common.All"/></option>
<%
			}
			else
			{
%>
				<option value="allTests"><egui:intnl text="admin.common.All"/></option>
<%
			}
			for (int j=0; j<listComponentTypes.size(); j++)
			{
				EgName nameObj = (EgName)listComponentTypes.get(j);
				String actualname = nameObj.getActualName();
				String localname = nameObj.getLocalName();
				if (actualname.equals(componentType))
				{
%>
					<option value="<%=actualname%>" selected><%=localname%></option>
<%
				}
				else
				{
%>
					<option value="<%=actualname%>"><%=localname%></option>
<%
				}
			}
%>
						</select>
					</td>
					<td height="6" width="7" class="eg_subcontentbg" class="form_spacing">&nbsp;</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg" valign="top" colspan="3"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
			</table>
<%
		}

		if (!searchItemFound && egTitleSearchStr != null && !egTitleSearchStr.equals(""))
		{
%>
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
				<tr>
					<td colspan="3" height="400">
						<table border="0" cellspacing="0" cellpadding="4" width="100%" >
							<tr>
								<td width="100%" align="center">
								<img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif">
								</td>
							</tr>
							<tr>
								<td width="100%" align="center">
								<b><egui:intnl text="admin.db.No result(s) found for your current search"/></b><br>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
<%
		}
		else if(aListDDDTest.size() == 0)
		{
%>			
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
			<tr>
				<td colspan="3" height="400">
					<table border="0" cellspacing="0" cellpadding="4" width="100%" >
						<tr>
							<td width="100%" align="center">
							<img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif">
							</td>
						</tr>
						<tr>
							<td width="100%" align="center">
							<b><egui:intnl text="admin.db.No managed components"/></b><br>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>	
<%
		}
		else
		{
%>
			<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="10"></td>
				</tr>
				<tr>
					<td valign="top">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
							<tr>
								<td>
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
										<tr>
											<td id="subhead_left" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
											<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;" align="center" width="100%"><strong><egui:intnl text="admin.db.Detailed Diagnosis Data Purge Periods"/> (<egui:intnl text="admin.db.in days"/>)</strong></td>
											<td id="subhead_right" width="7"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7"></td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td>
									<table cellspacing="0" cellpadding="0" width="100%" border="0" height="22">
<%
			int aListDDDTestSize = aListDDDTest.size();
			for (int j=0;j<aListDDDTestSize;j++)
			{
				EgName name = (EgName)aListDDDTest.get(j);
				String dddValue = name.getActualName();
				String dddDisplay = name.getLocalName();
				String strVal = dddcleanup.getStrValue("DDD_CLEANUP",dddValue);
				if (j != aListDDDTestSize-1)
				{
%>
							
										<tr onmouseover="javascript:showImg('<%=dddValue+"_DDDI"%>','<%=dddValue+"_DDD"%>')" 
										onmouseout="javascript:hideImg(this,event,'<%=dddValue+"_DDDI"%>')"
										>
											<td height="6" width="7" class="eg_subcontentbg" id="form_border">&nbsp;</td>
											<td width="200"class="form_border" id="eg_subcontentbg" nowrap><egui:intnl text="<%=dddDisplay%>"/></td>
											<td class="form_border" id="eg_subcontentbg" align="center" nowrap>:</td>
											<td class="form_border" id="eg_subcontentbg" width="50%" >
												<table cellspacing="0" cellpadding="0" border="0" >
													<tr >
														<td > <input type="text" style="width:150px;" id='<%=dddValue+"_DDD"%>' name='<%=dddValue+"_DDD"%>' maxlength="5" value="<%=strVal%>"
														onfocus="javascript:showImg('<%=dddValue+"_DDDI"%>','<%=dddValue+"_DDD"%>')"
														onblur="javascript:hideImg(this,event,'<%=dddValue+"_DDDI"%>')"
														>
														</td>
														<td>&nbsp;
														<span 
														id="<%=dddValue+"_DDDI"%>">
														</span>
														</td>
													</tr>
												</table>
											</td>
											<td class="eg_subcontentbg" id="form_border">&nbsp;</td>
											<td height="6" width="7" class="eg_subcontentbg" id="form_border">&nbsp;</td>
										</tr>
<%
				}
				else
				{
%>
										<tr onmouseover="javascript:showImg('<%=dddValue+"_DDDI"%>','<%=dddValue+"_DDD"%>')"
										onmouseout="javascript:hideImg(this,event,'<%=dddValue+"_DDDI"%>')" >
											<td height="6" width="7" class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
											<td width="200" class="form_spacing" id="eg_subcontentbg" nowrap><egui:intnl text="<%=dddDisplay%>"/></td>
											<td class="form_spacing" id="eg_subcontentbg" align="center" nowrap>:</td>
											<td class="form_spacing" id="eg_subcontentbg">
												<table cellspacing="0" cellpadding="0" border="0" >
													<tr>
														<td><input type="text" style="width: 150px;" id='<%=dddValue+"_DDD"%>' name='<%=dddValue+"_DDD"%>' maxlength="5" value="<%=strVal%>" onfocus="javascript:showImg('<%=dddValue+"_DDDI"%>','<%=dddValue+"_DDD"%>')"
														onblur="javascript:hideImg(this,event,'<%=dddValue+"_DDDI"%>')">
														</td>
														<td height="0">&nbsp;
														<span 
														id="<%=dddValue+"_DDDI"%>">
														</span>
														</td>
													</tr>
												</table>
											</td>
											<td class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
											<td height="6" width="7" class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
										</tr>
<%
				}
%>
										<input type='hidden' name='<%="$_"+dddValue+"_DDD"%>' value='<%=dddDisplay+"_DDD"+"$"+strVal%>'>
<%
			}
%>

										<tr>
											<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
											<td id="eg_subcontentbg"  width="100%"  valign="top" colspan="4"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td> 
											<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td width="7" ><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
							<tr>
								<td width="100%" align="center" class="eg_whitebg"><input type="button" name="update" value='<egui:intnl text="admin.common.Update"/>' style="width: 85px;" class="eg_back" onClick="javascript:populate()" >	
								</td>
							</tr>
							<tr>
								<td width="7" ><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
<%
		}
%>
		</td>
	</tr>
</table>
</form>
<%
	}
	else
	{
		EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
		Vector errors = new Vector();
		errors.addElement(mappingInfo.getTextDescription("admin.error.Admin Home"));
		errors.addElement("EgAdminOperations.jsp");
		errors.addElement(mappingInfo.getTextDescription("admin.error.Possible Reason"));
		errors.addElement(mappingInfo.getTextDescription("admin.error.Your license does not allow you to use this feature")+".");
		errors.addElement(mappingInfo.getTextDescription("admin.error.Please contact") + " <a href='mailTo:license@eginnovations.com' target='_parent' class='dash_link'><b>license@eginnovations.com</b></a> " + mappingInfo.getTextDescription("admin.error.for more details")+".");
		session.putValue("vec_Errors", errors);
%>
		<jsp:forward page="EgErrors.jsp" />
<%
	}

	if (request.getQueryString() != null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgDDDPurge.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgDDDPurge.jsp");
	}
%>

</body>
</html>



