<%
/**
 *  File			:	Egmailsettingsp.jsp
 *  Author			:	Sandhya.K
 *  Purpose			:	To update the configured values in eg_services.ini file.
 *  Version			:	0.1
 *  Creation Date	:	23/12/2000
 *  Last Modified	:
 *			22/07/2004	Arun		Writes to MailPasswd instead of MailPassword.
 *			14/07/2004	Arun		Clears mail authentication info in eg_services.ini if set to No
 *			08/07/2004	Arun		Included option for mail authentication
 *			01/07/2004	Arun		Uses StringUtils.removeISOControlChar() to remove Ctrl-M
 *			18/02/2003	sandhya		SmsFormat
 *			03/02/2003	sandhya		Configure Subject
 *			05/06/2001	Bala		IniFile save
 */
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "com.eg.EgCrypt" %>
<%@ page import = "com.eg.EgMemInfo" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Mail Settings");
	auditLogThread.setValue("Activity","Mail Configuration");
	Enumeration en = request.getParameterNames();
	while(en.hasMoreElements())
	{
		String name = ((String) en.nextElement()).toString().trim();
		String mailFormat = "";
		if(name.equals("$_password") || name.equals("$_MailReceiverPasswd"))
			continue;
		if(name != null && !name.equalsIgnoreCase("null") && name.length()>0 && name.startsWith("$_"))
		{
			String value = request.getParameter(name);
			if(value != null && !value.equalsIgnoreCase("null") && value.length()>0 && value.indexOf("$") !=-1)
			{
				String label = null;
				String labelValue = null;
				StringTokenizer stokens = new StringTokenizer(value,"$");
				if(stokens.countTokens()==2)
				{
					label = stokens.nextToken().toString();
					labelValue = stokens.nextToken();
				}
				else
				{
					label = stokens.nextToken();
					labelValue = "";
				}
				if(label != null && labelValue != null && !labelValue.equalsIgnoreCase("null") && labelValue.trim().length()>0)
				{
					String val = labelValue.startsWith("_")?labelValue.substring(1):labelValue;
					if(val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes"))
						val = "Yes";
					else if(val.equalsIgnoreCase("false") || val.equalsIgnoreCase("no"))
						val = "No";
					auditLogThread.setPreviousValue(label, val);
				}
				String currentValue = request.getParameter(name.substring(2));
				if(currentValue == null || currentValue.equalsIgnoreCase("null") && currentValue.trim().length()==0)
					continue;
				currentValue = currentValue.trim();
				if(currentValue.length()>0)
				{
					if(currentValue.equalsIgnoreCase("true") || currentValue.equalsIgnoreCase("yes"))
						currentValue = "Yes";
					else if(currentValue.equalsIgnoreCase("false") || currentValue.equalsIgnoreCase("no"))
						currentValue = "No";
					auditLogThread.setCurrentValue(label, currentValue);
				}
			}
		}
	}
	String currentPassword = request.getParameter("authpassword");
	String previousPassword = request.getParameter("$_password");
	if(currentPassword != null && previousPassword != null && previousPassword.indexOf("$")!=-1)
	{
		String label = previousPassword.substring(0,previousPassword.indexOf("$"));
		previousPassword = previousPassword.substring(previousPassword.indexOf("$")+1);

		if(previousPassword.length() == 0 && currentPassword.length()>0)
		{
			auditLogThread.setCurrentValue(label,"******");
		}
		else if(!previousPassword.equals(currentPassword))
		{
			auditLogThread.setPreviousValue(label,"*****");
			auditLogThread.setCurrentValue(label,"******");
		}
	}
	
	String curReceiverPwd = request.getParameter("MailReceiverPasswd");
	String preReceivePwd = request.getParameter("$_MailReceiverPasswd");
	if(curReceiverPwd != null && preReceivePwd != null && preReceivePwd.indexOf("$")!=-1)
	{
		String label = preReceivePwd.substring(0,preReceivePwd.indexOf("$"));
		preReceivePwd = preReceivePwd.substring(preReceivePwd.indexOf("$")+1);

		if(preReceivePwd.length() == 0 && curReceiverPwd.length()>0)
		{
			auditLogThread.setCurrentValue(label,"******");
		}
		else if(!preReceivePwd.equals(curReceiverPwd))
		{
			auditLogThread.setPreviousValue(label,"*****");
			auditLogThread.setCurrentValue(label,"******");
		}
	}
	auditLogThread.setValue("Description","Mail settings have been configured");
	auditLogThread.sendItToDB();
	/* code for auditlog ends */
%>

<jsp:useBean id="mailconfig" class="egurkha.TransactionBean" scope="page" />

<%!
	String licenseCheck = "me";
	String subject = "MISC_ARGS";
	String strHost = "";
	String strPort = "";
	String strProtocol = "";
	String strSender = "";
	String strmSub = "";
	String strsSub ="";
%>

<%
	strHost = request.getParameter("mailhost");
	strPort = request.getParameter("mailport");
	strProtocol = request.getParameter("mailprotocol");
	strSender = request.getParameter("mailsender");
	String mailSenders = request.getParameter("mailsenders");
	String mailRevSetting=request.getParameter("revSetConfig");
	String mailReceiverId=request.getParameter("MailReceiver");
	String mailReceiverPasswd=request.getParameter("MailReceiverPasswd");
	String mailRcvPort=request.getParameter("MailRcvPort");
	String mailRcvProtocol=request.getParameter("MailRcvProtocol");
	String mailRcvServer=request.getParameter("MailRcvServer");
	mailconfig.createFile("eg_services.ini", "save");
	mailconfig.setValue(subject,"MailHost", strHost);
	mailconfig.setValue(subject,"MailPort", strPort);
	mailconfig.setValue(subject,"MailHostProtocol", strProtocol);
	mailconfig.setValue(subject,"MailSender", strSender);
	mailconfig.setValue(subject,"receiverSettingConfig", mailRevSetting);
	if(mailRevSetting != null && mailRevSetting.equalsIgnoreCase("false"))
	{
		mailReceiverId = "";
		mailReceiverPasswd = "";
		mailRcvServer = "";
	}
	mailconfig.setValue(subject,"MailReceiver", mailReceiverId);
	if(mailReceiverPasswd!=null && mailReceiverPasswd.length() > 0)
	{
		mailReceiverPasswd = EgCrypt.encrypt(mailReceiverPasswd);
	}
	mailconfig.setValue(subject,"MailReceiverPasswd", mailReceiverPasswd);
	mailconfig.setValue(subject,"MailRcvPort", mailRcvPort);
	mailconfig.setValue(subject,"MailRcvProtocol", mailRcvProtocol);
	mailconfig.setValue(subject,"MailRcvServer", mailRcvServer);
	String[] mailIds = null;
	mailconfig.delSubject("MAIL_SENDERS");
	if (mailSenders!=null && mailSenders.length()>0)
	{
		StringTokenizer mailIdTokens = new StringTokenizer(mailSenders,"\n");
		mailIds = new String[mailIdTokens.countTokens()];
		for(int i=0;mailIdTokens.hasMoreElements();i++)
		{
			mailIds[i] = mailIdTokens.nextToken();
		}
	}
	if (mailIds!=null && mailIds.length>0)
	{
		for (int i=0;i<mailIds.length;i++)
		{
			mailconfig.setValue("MAIL_SENDERS", mailIds[i],"1");
		}
	}

	String authenticate = request.getParameter("authenticate");
	if (!StringUtils.isNull(authenticate) && authenticate.equalsIgnoreCase(EgConstants.TRUE))
	{
		mailconfig.setValue(subject,"MailUser", request.getParameter("user"));
		mailconfig.setValue(subject,"MailPasswd", EgCrypt.encrypt(request.getParameter("authpassword")));
	}
	else
	{
		mailconfig.setValue(subject,"MailUser", "");
		mailconfig.setValue(subject,"MailPasswd", "");
	}
	mailconfig.saveFile();
	Vector sess_vec = new Vector();
	sess_vec.addElement(_mapping.getTextDescription("admin.mail.Configure mail server settings"));
	sess_vec.addElement("EgMailServerSettings.jsp");
	sess_vec.addElement(_mapping.getTextDescription("admin.mail.Configure mail server settings")+".");
	sess_vec.addElement(_mapping.getTextDescription("admin.mail.Mail server settings have been configured successfully")+"...");
	session.setAttribute("vec_Results",sess_vec);
%>
<jsp:forward page="EgResults.jsp" />



