<%
/*******************************************************************************
 *	Name            :	EgModifyMeasures.jsp
 *	Purpose         :   To modify test measures in IC
 *	Version         :   2.3
 *	CreationDate    :   04/10/2002
 *	LastModified	:   05/05/2004	Adjusted max length of Alarm Display String from 24 to 75
 *						16/10/2003	Alarm Display String addn and allowing mutiple class -gopi
 *						15/10/2002
 *	Author          :   Sandhya K
 *	Design Changes	:	Jaiwin
 */
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page import="java.util.*" %>
<%@ page import="egurkha.*" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.IniFile"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page errorPage="EgProbs.jsp"%>
<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<!-- skm -->
<%@ page import="com.eg.EgThresholdInfo" %>
<%@ page import="com.eg.EgTablesInfo" %>
<%@ page import="com.eg.EgAggregateInfo"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%!
	private String [] processes = {	"UNALTERED",
					"PERCENT_INCREASE",
					"PERCENT_DECREASE",
					"PERCENT_CHANGE",
					"RATIO",
					"RATE",
					"DIFFERENCE"
					};
	private boolean isFirst = true;
	private Hashtable factorsMapping = new Hashtable();
	IniFile iniUI = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String factors [] = iniUI.getVariables("CONVERSION_FACTORS");
%>

<%
	boolean isDouble=EgDbInfo.doubleByteEnabled;
	if(isFirst)
	{
		if(factors != null && factors.length > 0)
		{
			for (int i=0;i<factors.length;i++)
			{
				String var = (String) factors[i];
				String val = iniUI.getValue("CONVERSION_FACTORS", var);
				factorsMapping.put(val, var);
			}
			isFirst = false;
		}
	}

	IniFile iniFile=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_udtests.ini");
	TestBean testBean = new TestBean(true);
	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	String test = request.getParameter("test");
	String testType = testBean.getTestType(test);

	String mname = request.getParameter("measure");
	if(mname == null || mname.length() == 0)
		mname = "";

	session.setAttribute("factorsMapping", factorsMapping);

	String unitValue = request.getParameter("unit");

	String index = request.getParameter("index");
	String org_measure = request.getParameter("org_measure");
	boolean isConfigTest = EgInstallInfo.isConfigTest(test);
	String alarm_msg = request.getParameter("alarmdescription");
	String org_process = "";
	String org_factor = "";
	String org_counter = "";
	String org_oid = "";
	String process = "";
	String counter = "";
	String oid = "";
	String  fileName=request.getParameter("fileName");
	if((fileName==null || fileName.equals("")) && (mname!=null && mname.length()!=0))
		 fileName=iniFile.getValue("TEST_MIBFILE_MAPPING",test+"#"+mname+":ObjectOID");

	//skm
	String testname = null;
	String aggregate_measure = null;
	String fname = null;
	List listOfMeasures = null;
	String[] listOfUnits = null;
	String[] tmpAggregateMeasures = null;
	String[] tmpFunctionNames = null;
	String[] function_names = null;
	String factor = null;
	String mfactor = "1";
//	String[] factors = {"1","MP"};
	List lst = aggregateInfo.getMeasurePeriod();
	String[] tmpFactors = null;
	String factor1 = null;
	//skm

	if(testType != null)
	{
		factor = request.getParameter("factor");
		if(factor == null || factor.length() == 0 || factor.equals("null") || factor.equals("none"))
			factor = "1";

		org_factor = request.getParameter("org_factor");
			if(org_factor == null || org_factor.length() == 0)
				org_factor = "";

		if(!testType.equalsIgnoreCase("Custom"))
		{
			org_process = request.getParameter("org_process");
			if(org_process == null || org_process.length() == 0)
				org_process = "";

			process = request.getParameter("process");
			if(process == null || process.length() == 0)
				process = "";

		}
		if(testType.equalsIgnoreCase("Perfmon") || testType.equalsIgnoreCase("Jmx"))
		{
			org_counter = request.getParameter("org_counter");
			if(org_counter == null || org_counter.length() == 0)
				org_counter = "";
			else
			{
				org_counter = org_counter.replace('*',' ');
				org_counter = org_counter.replace('|','%');
				org_counter = org_counter.trim();
			}

			counter = request.getParameter("counter");
			if(counter == null || counter.length() == 0)
				counter = "";
			else
			{
				counter = counter.replace('*',' ');
				counter = counter.replace('|','%');
				counter = counter.trim();
			}
		}
		if(testType.equalsIgnoreCase("Snmp"))
		{
			org_oid = request.getParameter("org_oid");
			if(org_oid == null || org_oid.length() == 0)
				org_oid = "";

			oid = request.getParameter("oid");
			if(oid == null || oid.length() == 0)
				oid = "";
		}
		if(testType.equalsIgnoreCase("Aggregate")) //skm
		{
			process = request.getParameter("process");
			aggregate_measure = request.getParameter("aggregate_measure");

			fname = request.getParameter("fname");

//			EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
			testname = aggregateInfo.getValue("AGGREGATE_TEST",test);

			EgThresholdInfo threshConfig = new EgThresholdInfo("manager");
			EgTablesInfo tableConfig = new EgTablesInfo("manager");
			
			String[] strTestMeasures = threshConfig.getMeasurementsForTest(testname);
			listOfMeasures = Arrays.asList(strTestMeasures);
			Collections.sort(listOfMeasures);

			listOfUnits = new String[listOfMeasures.size()];

			for(int i=0;i<listOfMeasures.size();i++)
			{
				listOfUnits[i] = tableConfig.getUnitForMeasure(testname,(String)listOfMeasures.get(i));
			}

			tmpAggregateMeasures = new String[listOfMeasures.size()];

			function_names = aggregateInfo.getGroupFunctions();
			
			tmpFunctionNames = new String[function_names.length];

			for(int i=0; i<listOfMeasures.size(); i++)
				if(((String)listOfMeasures.get(i)).equals(aggregate_measure))
					tmpAggregateMeasures[i] = "selected";
				else
					tmpAggregateMeasures[i] = "";

			for(int j=0; j<function_names.length; j++)
				if(function_names[j].equals(fname))
					tmpFunctionNames[j] = "selected";
				else
					tmpFunctionNames[j] = "";

			mfactor = request.getParameter("mfactor");
//			tmpFactors = new String[lst.size()];		 // thiru
/*			for(int k=0; k<factors.length; k++)
				if(factors[k].equals(factor))
					tmpFactors[k] = "selected";
				else
					tmpFactors[k] = "";
*/
			factor1 = request.getParameter("factor1");
		}//skm
	}

	String from = request.getParameter("from");
	String callPage = from + "?test=" + test + "&testtype=" + testType;

	ArrayList units = testBean.getAllUnits();
	Collections.sort(units);

	boolean otherUnit = false;
	if(units != null && units.size() > 0)
	{
		if(!units.contains(unitValue))
				otherUnit = true;

		if(unitValue.equals("|"))
		{
			unitValue = unitValue.replace('|','%');
			if(org_measure.indexOf("|") > -1)
				org_measure = org_measure.replace('|','%'); 
		}
		else
		{
			if(org_measure.indexOf("|") > -1)
				org_measure = org_measure.replace('|','%'); 
		}
	}

	String size1 = "";
	String size2 = "";
	String size3 = "";
	String size4 = "";
	String size5 = "";

	String dbsize = request.getParameter("dbsize");
	if(dbsize != null && dbsize.length() != 0)
	{
		if(dbsize.equals("Number(7,4)"))
			size1 = "selected";
		else if(dbsize.equals("Number(20,4)"))
			size2 = "selected";
		else if(dbsize.equals("Number(16)"))
			size3 = "selected";
	}

	String originalFactor = "";
	String [] factorSel = new String[factors.length];
	for(int i=0; i<factorSel.length; i++)
	{
		if(iniUI.getValue("CONVERSION_FACTORS",(String)factors[i]).equals(factor))
		{
			factorSel[i] = "selected";
			originalFactor = (String) factor;
		}
		else
			factorSel[i] = "";
	}
	boolean isFactorEnabled = false;
	if(process == null)
	{
		isFactorEnabled = true;
	}
	else if(process.equals("UNALTERED") || process.equals("DIFFERENCE"))
	{
		isFactorEnabled = true;
	}
	
	String originalProcess = "";
	String [] procSel = new String[processes.length];
	for(int i=0; i<procSel.length; i++)
	{
		if(processes[i].equals(process))
		{
			procSel[i] = "selected";
			originalProcess = processes[i];
		}
		else
			procSel[i] = "";
	}

	Hashtable procVals = testBean.getProcesses(test);
	Hashtable factVals = testBean.getFactors(test);

%>

<html>
<head>
<title>Modify Measures</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<!-- <link rel="stylesheet" href="eg_styles/eg_adminstyle.css" /> -->
<egui:skin ui="adminindex"/>
<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language="JavaScript">

function modifyMeasure(val)
{

	var thisForm = document.addMeasure;
	var testType = thisForm.testtype.value;
	var isConfigTest=new Boolean(thisForm.configtestflag.value).valueOf();
	var flag = "true";
	var disp_Name=true;
	var agg_unit = true;
	var meas = thisForm.s_measure.value;
	var keyArr = new Array("other","none","null","all");
	meas = meas.toUpperCase();
	if(meas == "TRGT_HOST" || meas == "PORT_NO"
		|| meas == "SITE_NAME" || meas == "INFO"
		|| meas == "MSMT_HOST" || meas == "MSMT_TIME")
	{
		alert("Database keyword(s) cannot be entered as measure name(s)");
		return;
	}
	ch = meas.charAt(0);


	if('<%=isDouble%>'=="false")
	{
		if(thisForm.alarmdescription != null)
			disp_Name = validateSingleByte(thisForm.alarmdescription.value);
		if(thisForm.unit!=null)
			agg_unit = validateSingleByte(thisForm.unit.value);
	}

	if(!checkblank(thisForm.s_measure))
	{
		alert("Please enter a measure");
		thisForm.s_measure.focus();
		if(val == "formsubmit")
		{
			return false;
		}
		else
		{
			flag = "false";
		}
	}
	else if(!checkspace(thisForm.s_measure))
	{
		thisForm.s_measure.focus();
		if(val == "formsubmit")
		{
			return false;
		}
		else
		{
			flag = "false";
		}
	}
	else if(!checkspecialnomess(document.addMeasure.s_measure, "`~!@#$%^&*()+=-/?'\"]{}[\\|;:.,><"))
	{
		alert("No special characters allowed");
		thisForm.s_measure.focus();
		if(val == "formsubmit")
		{
			return false;
		}
		else
		{
			flag = "false";
		}
	}
	else if(ch >= '0' && ch <= '9')
	{
		alert("Number not allowed as the first character");
		thisForm.s_measure.focus();
		if(val == "formsubmit")
		{
			return false;
		}
		else
		{
			flag = "false";
		}
    }
	else if(ch == '_')
	{
		alert("Underscore not allowed as the first character");
		thisForm.s_measure.focus();
		if(val == "formsubmit")
		{
			return false;
		}
		else
		{
			flag = "false";
		}
    }
	else if(!validateSingleByte(meas))
	{
		alert('<egui:intnl text="admin.ic.Measure name is not allowed in DBL(Chinese,Korean,Japanese)"/>');
		thisForm.s_measure.focus();
		return false;
	}
	else if(!disp_Name)
	{
		alert('<egui:intnl text="admin.ic.Alarm display string is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
		thisForm.alarmdescription.focus();
		return false;
	}
	else if (testType == "Aggregate") //skm
	{
		var unit_value = thisForm.unit.value;
		if (unit_value == "")
		{
			alert("Please specify unit");
			thisForm.unit.focus();
			if(val == "formsubmit")
			{	
				return false;
			}
			else
			{
				flag = "false";
			}
		}
		if(!agg_unit)
		{
			alert('<egui:intnl text="admin.ic.Unit is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"/>');
			thisForm.unit.focus();
			return false;
		}
	} //skm
	else
	{
		var un; 
		if(!isConfigTest)
			un=thisForm.s_un.options[thisForm.s_un.selectedIndex].value;
		else
			un="NONE";

		if(un == "-1")
		{
			alert("Please select a unit");
			if(val == "formsubmit")
			{
				return false;
			}
			else
			{
				flag = "false";
			}
		}
		else if(un == "other")
		{
			if(!checkblank(thisForm.s_otherunit))
       		{
				alert("Please enter a unit");
				thisForm.s_otherunit.focus();
				if(val == "formsubmit")
				{
					return false;
				}
				else
				{
					flag = "false";
				}
			}
			else if(!checkspace(thisForm.s_otherunit))
			{
				thisForm.s_otherunit.focus();
				if(val == "formsubmit")
				{
					return false;
				}
				else
				{
					flag = "false";
				}
			}
			else if(!checkspecialnomess(thisForm.s_otherunit,"`~!@#^&*()+=-?'\"]{}[\\|;:.,><"))
			{
				alert("No Special Characters allowed");
				thisForm.s_otherunit.focus();
				if(val == "formsubmit")
				{
					return false;
				}
				else
				{
					flag = "false";
				}
			}
			else if (!checkKeywords(thisForm.s_otherunit,keyArr))
			{
				alert('<egui:intnl text ="admin.ic.Please enter a valid unit"/>');
				thisForm.s_otherunit.focus();
				if(val == "formsubmit")
				{
					return false;
				}
				else
				{
					flag = "false";
				}
			}
		}
	}

	if(testType == "Perfmon" || testType == "Jmx")
	{
		if(!checkblank(thisForm.s_counter))
		{
			alert("Please enter a counter name");
			thisForm.s_counter.focus();
			if(val == "formsubmit")
			{
				return false;
			}
			else
			{
				flag = "false";
			}
		}
		if(!validateSingleByte(thisForm.s_counter.value))
		{
			alert('<egui:intnl text="admin.ic.Counter name is not allowed in DBL(Chinese,Korean,Japanese)"/>');
			thisForm.s_counter.focus();
			return false;
		}
	}

	if(testType == "Snmp")
	{
		if(!checkblank(thisForm.s_oid))
		{
			alert("Please enter an object oid");
			thisForm.s_oid.focus();
			if(val == "formsubmit")
			{
				return false;
			}
			else
			{
				flag = "false";
			}
        	}
		else if(!checkspecialnomess(thisForm.s_oid,
                    	"`~!@#$%^&*()+=-_?\'\"]{}[\\|;:,><"))
        	{
                	alert("No Special Characters allowed");
                	thisForm.s_oid.focus();
                	if(val == "formsubmit")
                	{
                        	return false;
                	}
                	else
                	{
                        	flag = "false";
                	}
        	}
			else if (un != "-1")
			{
        	//else if(checkAlpha(thisForm.s_oid.value))
				if (checkAlpha(thisForm.s_oid.value))
				{
						alert("Alphabets are not allowed");
						thisForm.oid.focus();
						if (val == "formsubmit")
						{
							return false;
						}
						else
						{
							flag = "false";
						}
				}
			}
		else if(!validateSingleByte(thisForm.s_oid.value))
		{
			alert('<egui:intnl text="admin.ic.Object OID is not allowed in DBL(Chinese,Korean,Japanese)"/>');
			thisForm.s_oid.focus();
			return false;
		}
	}
	if(flag == "true")
	{
		thisForm.submit();
	}
}

function factorSelect()
{
	var thisForm = document.addMeasure;
	if(document.getElementById("s_factor") != null)
	{
		document.getElementById("s_factor").value = thisForm.cFactor.options[thisForm.cFactor.selectedIndex].value;
	}
}

function listSelect(callFrom)
{
	var thisForm = document.addMeasure;
    var isConfigTest=new Boolean(thisForm.configtestflag.value).valueOf();
	var mname = thisForm.s_measure.value;
	var dbsize = !isConfigTest?thisForm.s_dbsize.value:null;
	
	var testType = thisForm.testtype.value;
	var process = "";
	var counter = "";
	var oid = "";
	var unit = "";
	var factor = null;

	if (testType == "Aggregate") //skm
	{
		unit = thisForm.unit.value; 		
	}	//skm
	else 
	{
		unit = thisForm.s_un.options[thisForm.s_un.selectedIndex].value;
	}
	
	if(testType != "Custom")
	{
		process = thisForm.s_process.options[thisForm.s_process.selectedIndex].value;
		if(thisForm.cFactor != null)
		{
			factor = thisForm.cFactor.options[thisForm.cFactor.selectedIndex].value;
		}
	}

	if(testType == "Perfmon" || testType == "Jmx")
	{
		counter = thisForm.s_counter.value;
		for(var x=0;x<counter.length;x++)
		{
			if(counter.charAt(x) == ' ')
				counter = counter.replace(' ','*');
			else if(counter.charAt(x) == '%')
				counter = counter.replace('%','|');
			else
				continue;
		}
	}

	if(testType == "Snmp")
		oid = thisForm.s_oid.value;

	var test = thisForm.test.value;
	var org_measure = thisForm.org_measure.value;
	for(var x=0;x<org_measure.length;x++)
	{
	    	if(org_measure.charAt(x) == '%')
	        	org_measure = org_measure.replace('%','|');
	    	else
	    		continue;
    	}
	var org_process = thisForm.org_process.value;
	var org_factor = thisForm.org_factor.value;
	var org_counter = thisForm.org_counter.value;
	for(var x=0;x<org_counter.length;x++)
	{
		if(org_counter.charAt(x) == ' ')
	      		org_counter = org_counter.replace(' ','*');
	    	else if(org_counter.charAt(x) == '%')
	        	org_counter = org_counter.replace('%','|');
	    	else
	    		continue;
    	}

	var org_oid = thisForm.org_oid.value;
	var from = thisForm.from.value;
	if(thisForm.alarmdescription != null)
	alarm_msg = thisForm.alarmdescription.value;
	else
		alarm_msg="";
	
	if(unit == "-1" && callFrom == "unit")
	{
		alert('<egui:intnl text ="admin.ic.Please select a unit"/>');
	}
    else if(testType != "Aggregate")  //skm (Only if statement, Block existed earlier)
	{

		var tmp = org_measure;
		
		originalMeasure = tmp.substring(0,tmp.indexOf(":"));
		tmp = tmp.substring(tmp.indexOf(":")+1);
		
		originalDB = tmp.substring(0,tmp.indexOf(":"));
		tmp = tmp.substring(tmp.indexOf(":")+1);

		originalUnit = tmp.substring(0,tmp.indexOf(":"));
		tmp = tmp.substring(tmp.indexOf(":")+1);

		originalAlarm = tmp.substring(0,tmp.indexOf(":"));
		tmp = tmp.substring(tmp.indexOf(":")+1);

		var index = thisForm.index.value;
		var fileName=document.addMeasure.fileName.value;
		
		if(fileName=="")
		{
			fileName='<%=fileName%>';
		}
		var str = "EgModifyMeasures.jsp?org_measure="
		+ org_measure + "&org_process="
		+ org_process + "&org_factor="
		+ org_factor + "&org_counter="
		+ encodeURIComponent(org_counter) + "&org_oid="
		+ org_oid + "&test=" + test + "&unit="
		+ unit + "&measure=" + mname + "&dbsize="
		+ dbsize + "&index=" + index + "&process=" + process+ "&factor=" + factor
		+ "&counter=" + encodeURIComponent(counter) + "&oid=" + oid +"&from=" + from+"&alarmdescription="+alarm_msg+'&name=jamesthomas&originalUnit='+originalUnit+' &originalProcess=<%=originalProcess%>&originalFactor=<%=originalFactor%>&originalMeasure='+originalMeasure+'&originalAlarm='+originalAlarm+'&originalDB='+originalDB+"&fileName="+fileName;
		window.location.href = str;
	}
}

//skm
function displayUnit()
{
	var thisForm = document.addMeasure;
	var mname = thisForm.mname.value;
	thisForm.unit.value = mname.substring(mname.indexOf(',')+1,mname.length)
}

function displayFactor()
{
	var thisForm = document.addMeasure;

	document.getElementById("fact").style.display = "block";
	document.getElementById("fact1").style.display = "block";
	thisForm.factor.selectedIndex = "0";
}
//skm

function openWin(event,from,fieldName,oid)
{
		var oid=document.addMeasure.s_oid.value;
		var fileName=document.addMeasure.fileName.value;
		
		if(fileName=="")
		{
			fileName='<%=fileName%>';
		}
		if(oid=="")
		{
			oid='<%=oid%>'
		}
		var url="/final/admin/showMibFiles.jsp?from="+from+"&fieldName="+fieldName+"&OID="+oid+"&fileList="+fileName;
		event=event?event:window.event;

	
		if(document.getElementById("s_dbsize")!=null)
		{
			document.getElementById("s_dbsize").style.visibility = 'hidden';
		}		
		if(document.getElementById("s_un")!=null)
		{
			document.getElementById("s_un").style.visibility = 'hidden';
		}
		if(document.getElementById("s_process")!=null)
		{
			document.getElementById("s_process").style.visibility = 'hidden';
		}

		openMapWindow('EgMap',event,url);
		
}
var isMinNS4;
var isMinIE4;
var isMinIE5;
var mapW;
var mapH;

function openMapWindow(screenname, event,url,fileName)
{
		mapW = 800;
		mapH = 460;
		event=event?event:window.event;
		if (event==null)
		{
			event=window.event;
		}
		var s;
		// Set global flags based on browser type and version.
		isMinNS4 = (navigator.appName.indexOf("Netscape") >= 0 &&
		parseFloat(navigator.appVersion) >= 4) ? (browser="netscape") : 0;
		isMinIE4 = (document.all) ? 1 : 0;
		if (isMinIE4)
		{
				s = navigator.appVersion;
				s = s.substr(s.indexOf("MSIE")).substr(5);
				isMinIE5 = parseFloat(s) >= 5 ? (browser="ie") : 0;
		}
		destroyMapWindow('egmap');
		var mapDiv = document.createElement("div");
		if (mapDiv!=null)
		{
			mapDiv.setAttribute("id", "egmap");
			mapDiv.id="egmap";
			mapDiv.name="egmap";
			//mapDiv.style.background="white";
			mapDiv.style.position="absolute";
			mapDiv.style.zIndex="100";
			mapDiv.style.visibility="visible";
			if(screenname=='EgMap')
			{
				var scrW = document.body.clientWidth;
				var scrH = document.body.clientHeight;
				mapX = ((scrW/2)-(mapW/2))+10;
				mapY = ((scrH/2)-(mapH/2))+10;
				mapDiv.style.pixelLeft=	mapX;
				mapDiv.style.left=mapX+"px";
				mapDiv.style.pixelTop=mapY;
				mapDiv.style.top=mapY+"px";
			}
				mapDiv.style.pixelWidth=mapW;
				mapDiv.style.pixelHeight=mapH;
				document.forms[0].appendChild(mapDiv);
				execute(url,fileName);
		}
		else
		{
			alert("Could not open TimeFilter window");
		}
	return;
}

var httpRequest=false;
function  execute(url)
{
	if (window.XMLHttpRequest)
	{
		httpRequest = new XMLHttpRequest();
		if (httpRequest.overrideMimeType)
		{
			httpRequest.overrideMimeType('text');
		}
	}
	else if (window.ActiveXObject)
	{
		try
		{
			httpRequest = new ActiveXObject("Msxml2.XMLHTTP");
		}
		catch (e)
		{
			try
			{
				httpRequest = new ActiveXObject("Microsoft.XMLHTTP");
			}
			catch (e)
			{
			}
		}
	}
	if (!httpRequest)
	{
		alert('<egui:intnl text="monitor.home.Giving up -Cannot create an XMLHTTP instance"/>');
		return false;
	}
	httpRequest.onreadystatechange = writeResponse;
	httpRequest.open('GET',url, true);
	httpRequest.send(null);
}

function writeResponse()
{
	if (httpRequest.readyState == 4 || httpRequest.readyState=="complete")
	{
		if (httpRequest.status == 200)
		{
			document.getElementById("egmap").innerHTML=httpRequest.responseText;
			showTree("");
		}
		
	}
		
}

function destroyMapWindow(elementId)
{
	var thisEle  = document.getElementById(elementId);
	var thisEle2 = window.parent.document.getElementById(elementId);
	if(thisEle2!=null)
	{
		try
		{
			window.parent.document.forms[0].removeChild(thisEle2);
		}
		catch (error)
		{			
			var thisDiv = window.parent.document.getElementById("egmap");
			var thisDivParent = thisDiv.parentElement;
			if (thisDiv!=null & thisDivParent!=null)
			{
				//IE should close here
				thisDivParent.removeChild(thisDiv);
			}
		}
	}
	if(thisEle!=null)
	{
		try
		{
			document.forms[0].removeChild(thisEle);
		}
		catch (error)
		{			
			try
			{
				var thisDiv = document.getElementById("egmap");
				var thisDivParent = thisDiv.parentElement;
				if (thisDiv!=null & thisDivParent!=null)
				{
					thisDivParent.removeChild(thisDiv);
				}
			}
			catch(e)
			{
			}
		}
	}
	else
	{
		return;
	}
}

function loading()
{
	var log1=document.getElementById("Tree");
	var myhtml = "<table border='0' height='100%'><tr><td align='center' valign='middle'><img src='/final/admin/eg_images/loading1.gif'></td><td align='center'>loading....</td></tr></table>";
	log1.innerHTML=myhtml;
}

function openWindow()
{
	var remoteWin = window.open("EgRemoteUpload.jsp?page=EgUploadMIB&mibBrowser=true","DataWindow","width=400,height=150,left=320,top=300,screenX=320,screenY=300,scrollbars=no,scrollbars=0,resizable=no");
	remoteWin.focus();
}

function sortAvailable(selectbox,fileName)
{
	var ai = document.getElementById(selectbox);
	var tmp = "",val="";
	// first we create an string from all of the text and
	// values of the list box.  In this example I use the
	// tilde (~) symbol to seperate the text and value and
	// use a comma to seperate the options from each other.
	for (i=0;i<ai.options.length;i++)
	{
		if(ai.options[i].text!=null && ai.options[i].value!=null && ai.options[i].text!="null" && ai.options[i].value!="null" && ai.options[i].text!="" && ai.options[i].value!="" && ai.options[i].text!="Please Choose a MIB File" && ai.options[i].value!="-1")
		{
			if (tmp > "") tmp +=",";
			tmp += ai.options[i].text;
			if(val>"") val+=",";
			val+=ai.options[i].value;
		}
	}
	// now we split the string into an array using the Javascript
	// split function.
	var atmp = tmp.split(",");
	var valarr=val.split(",");
	// sort the array
	atmp = atmp.sort();
	valarr=valarr.sort();
	// Clear the list box
	ai.options.length = 0;
	// Add the sorted options to the list box.
	ai.options[0]=new Option("Please Choose a MIB File","-1");
	for (i=0;i<atmp.length;i++) 
	{
		var opt = atmp[i];
		var valu=valarr[i];
		ai.options[i+1] = new Option(opt,valu);
		if(valu==fileName)
		{
			ai.options[i+1].selected = true;
		}		
	}
}

function openUploadedMibFile(fileName)
{
	if(fileName!=null && fileName!="null" && fileName!="")
	{
		var mibFileList=document.addMeasure.fileList;
		var mibFileListLength=mibFileList.options.length;
		var fname="";
		var flag=0;
		var mibFileListIndex=mibFileListLength;
		for(var i=0;i<mibFileList.options.length;i++)
		{
			fname=document.addMeasure.fileList.options[i].value;
			if(fname==fileName)
			{
				mibFileListIndex=i;
				flag=1;
			}

		}
		if(flag==0)
		{
			mibFileList.options[mibFileListIndex]=new Option(fileName,fileName);
		}
		sortAvailable("fileList",fileName);
		showTree('select');
	}
}

var httpReq=false;
function  showTree(opt)
{
	var fileName=document.addMeasure.fileList.options[document.addMeasure.fileList.selectedIndex].value;
	if(fileName!="" || fileName!="")
	{
			 loading();
	}
	var fieldName=document.addMeasure.fieldName.value;
	var from=document.addMeasure.from.value;
	var oid=document.addMeasure.s_oid.value;
	if(oid=="")
	{
		oid='<%=oid%>';
	}
	
	var refreshURL = 'mibTree.jsp?MibFileName='+fileName+"&fieldName="+fieldName+"&from="+from+"&oid="+oid;
	
	if(opt=="select")
	{
		refreshURL = 'mibTree.jsp?MibFileName='+fileName+"&fieldName="+fieldName+"&from="+from;
	}
	


	if (window.XMLHttpRequest)
	{
		httpReq = new XMLHttpRequest();
		if (httpReq.overrideMimeType)
		{
			httpReq.overrideMimeType('text');
		}
	}
	else if (window.ActiveXObject)
	{
		try
		{
			httpReq = new ActiveXObject("Msxml2.XMLHTTP");
		}
		catch (e)
		{
			try
			{
				httpReq = new ActiveXObject("Microsoft.XMLHTTP");
			}
			catch (e)
			{
			}
		}
	}
	if (!httpReq)
	{
		alert('<egui:intnl text="monitor.home.Giving up -Cannot create an XMLHTTP instance"/>');
		return false;
	}
	httpReq.onreadystatechange = writeRes;
	httpReq.open('GET',refreshURL, true);
	httpReq.send(null);
}

function writeRes()
{
	if (httpReq.readyState == 4 || httpReq.readyState=="complete")
	{
		if (httpReq.status == 200)
		{
			document.getElementById("Tree").innerHTML=httpReq.responseText;
		}
	}
}

function setOIDField(oidValue,from,fieldName,fileName)
{
	if(oidValue!=null && (oidValue=="null" || oidValue==""))
	{
		if(fieldName=="ObjectOID")
		{
			alert("<egui:intnl text='admin.ic.Please select an Object OID'/>");
		}
		return;
	}
		
		document.addMeasure.fileName.value=fileName;
		document.getElementById("s_oid").value=oidValue;
		closeWindow();
}
function closeWindow()
{
	
		if(document.getElementById("s_dbsize")!=null)
		{
			document.getElementById("s_dbsize").style.visibility = 'visible';
		}	
		if(document.getElementById("s_un")!=null)
		{
			document.getElementById("s_un").style.visibility = 'visible';
		}
		if(document.getElementById("s_process")!=null)
		{
			document.getElementById("s_process").style.visibility = 'visible';
		}
			destroyMapWindow('egmap');
}

 function destroyMapWindow(elementId)
{
	var thisEle  = document.getElementById(elementId);
	var thisEle2 = window.parent.document.getElementById(elementId);
	if(thisEle2!=null)
	{
		try
		{
			window.parent.document.forms[0].removeChild(thisEle2);
		}
		catch (error)
		{			
			var thisDiv = window.parent.document.getElementById("egmap");
			var thisDivParent = thisDiv.parentElement;
			if (thisDiv!=null & thisDivParent!=null)
			{
				//IE should close here
				thisDivParent.removeChild(thisDiv);
			}
		}
		
	}
	if(thisEle!=null)
	{
		try
		{
			//firefox closes the window here!
			document.forms[0].removeChild(thisEle);
			
		}
		catch (error)
		{			
			
			try
			{
				var thisDiv = document.getElementById("egmap");
				var thisDivParent = thisDiv.parentElement;
				if (thisDiv!=null & thisDivParent!=null)
				{
					thisDivParent.removeChild(thisDiv);
				}
			}
			catch(e)
			{
			}
		}
	}
	else
	{
		return;
	}
}
</script>
</head>
<body style="overflow:auto" id="space6" >
<form name="addMeasure" method="get" action="Egmodifymeasuresp.jsp" onSubmit="return modifyMeasure('formsubmit')" style="margin:0px">
<input type="hidden" name="fileName"  value="<%=fileName%>">
<input type=hidden name=configtestflag value=<%= isConfigTest?"true":"" %>>
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<jsp:include page="listSearch.jsp?title=MODIFY MEASURES&leftString=Add User&backButton=true&subtitle=false"/>

	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
		<br>
			<table cellspacing='0' border='0' cellpadding='0' width='85%' height='24' >
			<tr>
<%
if (testType.equalsIgnoreCase("Aggregate")) //skm
{
%>
			<th id="eg_subheadbg" height="24" align="center" width='100%'>
			<%=test%> ( <%=testname%> )
			</th>
<%
}
else
{
%>
			<th id="eg_subheadbg"  nowrap   height="24" align="center" width='100%'><%= test %></th>
<%
}
%>
			</tr>
			<tr>
			<td width="100%" id="cell_border1">

	<table width="90%" cellspacing="0" cellpadding="3" name="Add Transaction Table" align='center' border="0" >
	<tr>
		<td width="100%" height="10" id="eg_blankspace" colspan="3">&nbsp;</td>
	</tr>
	<tr>
		<td width="250" align="left" nowrap  nowrap height="20" align='center'><egui:intnl text="admin.ic.Measure name"/></td>
		<td  nowrap width="20" align="center">:</td>
		<td width="250"  nowrap  height="20" valign="bottom"  >
		<input type="text" name="s_measure" value="<%= mname %>" size="20" maxlength="25" style='width:180;'></td>
	  </tr>
<%
	String reloaded = request.getParameter("name");
	if(reloaded != null && reloaded.equalsIgnoreCase("jamesthomas"))
	{
%>
		<input type="hidden" name="$_s_measure" value='Measure name$<%=request.getParameter("originalMeasure")%>'>
<%
	}
	else
	{
	%>
		<input type="hidden" name="$_s_measure" value='Measure name$<%=mname%>'>
	<%
	}
%>		
	<tr>
		<td width="100%" height="10" id="eg_blankspace" colspan="3">&nbsp;</td>
	</tr>

<%
if (testType.equalsIgnoreCase("Aggregate")) //skm
{
	String temp = "";
%>
	<tr>
		<td width="250" align="left"  nowrap  height="20"><egui:intnl text="admin.ic.Aggregate measure name"/></td>
		<td  nowrap width="20" align="center">:</td>
		<td width="250"   height="20" valign="bottom" height="20" >
			<select name="mname" style='width:180;' onChange="javascript:displayUnit()">
<%

	for(int i=0;i<listOfMeasures.size();i++) //skm
	{
		/* code for auditlog starts */
		if(tmpAggregateMeasures[i].equalsIgnoreCase("selected"))
			temp = listOfMeasures.get(i).toString();
		/* code for auditlog starts */
%>
				<option value='<%= (String)listOfMeasures.get(i) %>,<%= listOfUnits[i]%>' <%= tmpAggregateMeasures[i]%>>
				<%= (String)listOfMeasures.get(i) %>
				</option>
<%
	}
%>
			</select>
		</td>
	</tr>
	<input type='hidden' name='$_mname' value="Aggregate measure name$<%=temp%>">	
<%
}
%>
<% 
		if(!isConfigTest)
		{

			String temp = "";
			if(size1.equalsIgnoreCase("selected"))
				temp = "Number(7,4)";
			if(size2.equalsIgnoreCase("selected"))
				temp = "Number(20,4)";
			if(size3.equalsIgnoreCase("selected"))
				temp = "Number(16)";
%>
	  <tr>
		<td width="250" valign="middle" height="22" align='left'  nowrap >
			<egui:intnl text="admin.ic.Database column size"/>
		</td>
		<td  nowrap width="20" align="center">:</td>
		<td width="250" align="left" valign="middle" height="22"  nowrap >
			    <select name="s_dbsize" style='width:180;'>
				<option value="Number(7,4)" <%= size1 %>><egui:intnl text="admin.ic.Number"/>(7,4)</option>
				<option value="Number(20,4)" <%= size2 %>><egui:intnl text="admin.ic.Number"/>(20,4)</option>
				<option value="Number(16)" <%= size3 %>><egui:intnl text="admin.ic.Number"/>(16)</option>
			    </select>
			</td>
	  </tr>

<%
	if(reloaded != null && reloaded.equalsIgnoreCase("jamesthomas"))
	{%>
	<input type="hidden" name="$_s_dbsize" value='Database column size$<%=request.getParameter("originalDB")%>'>
	<%}
	else
	{%>
	<input type='hidden' name='$_s_dbsize' value="Database column size$<%=temp%>">	
	<%}
%>		
<%
		}
%>
<%
if (testType.equalsIgnoreCase("Aggregate")) //skm
{
%>
	<tr>
		<td width="250" align="left"  nowrap height="20"><egui:intnl text="admin.ic.Unit"/></td>
		<td  nowrap width="20" align="center">:</td>
		<td width="250"  height="20" valign="bottom">
		<input type="text" name="unit" value="<%=unitValue%>" style="width:180px" readonly>
		</td>
	</tr>
		<input type='hidden' name='$_unit' value="Unit$<%=unitValue%>">	
	<tr>
		<td id="eg_blankspace" nowrap height="10" colspan="3">&nbsp;</td>
	</tr>
	<tr>
		<td width="250" align="left"  nowrap height="20"><egui:intnl text="admin.ic.Function"/></td>
		<td  nowrap width="20" align="center">:</td>
		<td width="250"  valign="bottom" height="20" >
			<table cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td>
						<select name="fnt" style='width:80;' onChange="javascript:displayFactor()">

<%
	String temp="";
	for(int i=0;i<function_names.length;i++) 
	{
		if(tmpFunctionNames[i].equals("selected"))
			temp = function_names[i];
%>
							<option value='<%=function_names[i]%>' <%=tmpFunctionNames[i]%>>
							<%=function_names[i]%>
							</option>
<%
	}
%>
						</select>
					</td>

					<td nowrap>
						<span id="fact" style="display:block">&nbsp;*
						&nbsp;<select name="mfactor" style='width:80;'>
<%
			// Tuesday, June 27, 2006 thiru
			Iterator itr = lst.iterator();
			while (itr.hasNext())
			{
				String s_factor = (String) itr.next();
				if (s_factor.equals(mfactor))
				{
%>
					<option value="<%=s_factor%>" selected ><%=s_factor%></option>
<%
				}
				else
				{
%>
					<option value="<%=s_factor%>"><%=s_factor%></option>
<%
				}
			}

%>
							</select>
						</span>
					</td>
					<td nowrap>
						<span id="fact1" style="display:block">&nbsp;*
						&nbsp;<input type="text" name="factor1" value="<%=factor1%>" style='width:80;'>
						</span>
					</td>

				</tr>
			</table>	
		</td>
	</tr>
	<input type="hidden" name="$_fnt" value="Aggregate function$<%=temp%>">
	<input type="hidden" name="$_mfactor" value="<%=mfactor%>">
	<input type="hidden" name="$_factor1" value="<%=factor1%>">
	<tr>
		<td id="eg_blankspace" nowrap height="10" colspan="3">&nbsp;</td>
	</tr>

	<tr>
		<td width="250" align="left"  nowrap  height="20"><egui:intnl text="admin.ic.Conversion Factor"/></td>
		<td  nowrap width="20" align="center">:</td>
		<td width="250" height="20" valign="bottom">
			<select name="cFactor" style='width:180;' onchange="Javascript:factorSelect()">
<%
							String tmpFact = "none";
							for(int i=0; i<factors.length; i++)
							{
								String fact = iniUI.getValue("CONVERSION_FACTORS", factors[i].toString());
								String tmpSel = factorSel[i];
								if(tmpSel.equals("selected"))
								{
									tmpFact = fact;
								}
%>
									<option  value="<%= fact %>" <%= tmpSel %>><%= factors[i].toString() %>
<%
							}
%>
			</select>
 							<input type="hidden" name="s_factor" id="s_factor" value="<%=request.getParameter("factor")%>"/> 
		</td>
	</tr>
							<input type="hidden" name="$_cFactor" value='Conversion Factor$<%=request.getParameter("factor")%>'>

<%
}
else
{
	if(!isConfigTest)
	{
		String temp = "";
%>
		 <tr>
			<td width="100%" height="10" id="eg_blankspace" colspan="3">&nbsp;</td>
		</tr>
	  <tr>
		<td width="250" align="left"  height="20" nowrap><egui:intnl text="admin.ic.Unit"/></td>
		<td  nowrap width="20" align="center">:</td>
		<td width="250" align="left" valign="bottom" height="20"  nowrap> 
		<select name="s_un" onchange='Javascript:listSelect("unit")' style='width:180;'>
		    <option value="-1"><egui:intnl text="admin.ic.Please select a unit"/></option>
<%
					String selected = "";
					if(units != null && units.size() > 0)
					{
						for(int i=0; i<units.size(); i++)
						{
							selected = "";
							String un = (String) units.get(i);
							if(un.equals("%"))
								continue;
							if(un.equals(unitValue))
							{
								temp = un;
								selected = "selected";
							}
%>
		    <option <%= selected %> value="<%= un %>"><%= un %></option>
<%
						}
					}

					if(otherUnit)
						selected = "selected";
					else
						selected = "";
%>
                   <option <%= selected %> value="other"><egui:intnl text="admin.ic.Other"/></option>
			</select>
			</td>
		</tr>
<%
	if(reloaded != null && reloaded.equalsIgnoreCase("jamesthomas"))
	{%>
	<input type="hidden" name="$_s_un" value='Unit$<%=request.getParameter("originalUnit")%>'>
	<%}
	else
	{%>
	<input type="hidden" name="$_s_un" value='Unit$<%=unitValue%>'>
	<%}
%>		
<%
			if(otherUnit)
			{
%>
		<tr>
			<td width="100%" height="10" id="eg_blankspace" colspan="3">&nbsp;</td>
		</tr>
		<tr>
			<td width="250" align="left"  height="20"  nowrap>
			<egui:intnl text="admin.ic.Other"/>
			</td>
<%
			}
			else
			{
%>

				<td id="eg_blankspace" nowrap height="10" colspan="3">&nbsp;</td>
<%		
			}

			if(otherUnit)
			{
				if(unitValue.equalsIgnoreCase("other"))
					unitValue = ""; 
%>
		<td nowrap width="20" align="center">:</td>
		<td width="250" align="left"  height="20" nowrap>
			<input type="text" name="s_otherunit" size="20" maxlength="64" style='width:180;' value="<%=unitValue%>">
		</td>
		</tr>
			<input type="hidden" name="$_s_otherunit" value="Other$<%=unitValue%>">

		<tr>
					<td width="100%" height="10" id="eg_blankspace" colspan="3">&nbsp;</td>
		</tr>
<%
			}
	}	
}
	if(testType.equalsIgnoreCase("Custom"))
	{
%>
					<tr>
						<td width="250" align="left"  height="20" nowrap><egui:intnl text="admin.ic.Conversion Factor"/></td>
						<td  nowrap width="20" align="center">:</td>
						<td width="250" align="left" valign="bottom" height="20"  nowrap><select name="cFactor" style='width:180;' onchange="Javascript:factorSelect()">
<%
							String tmpFact = "none";
							for(int i=0; i<factors.length; i++)
							{
								String fact = iniUI.getValue("CONVERSION_FACTORS", factors[i].toString());
								String tmpSel = factorSel[i];
								if(tmpSel.equals("selected"))
								{
									tmpFact = fact;
								}
%>
									<option  value="<%= fact %>" <%= tmpSel %>><%= factors[i].toString() %>
<%
							}
%>
							</select>
							<input type="hidden" name="s_factor" id="s_factor" value="<%= tmpFact %>"/>
						</td>
					</tr>
					<tr>
						<td width="100%" height="10" id="eg_blankspace" colspan="3">&nbsp;</td>
					</tr>
					<input type="hidden" name="$_cFactor" value='Conversion Factor$<%=request.getParameter("originalFactor")%>'>
<%
	}
			if((alarm_msg != null) && !(alarm_msg.equalsIgnoreCase("null")))
			{
%>
			<tr>
				<td width="250" align="left"  height="20"  nowrap><egui:intnl text="admin.ic.Alarm display string"/></td>
				<td  nowrap width="20" align="center">:</td>
				<td width="250" valign="bottom" height="20"  nowrap >
					<input type="text" name="alarmdescription" style='width:180;' maxlength="75" value="<%=alarm_msg%>">
				</td>
			</tr>

<%
	if(reloaded != null && reloaded.equalsIgnoreCase("jamesthomas"))
	{%>
	<input type="hidden" name="$_alarmdescription" value='Alarm display string$<%=request.getParameter("originalAlarm")%>'>
	<%}
	else
	{%>
	<input type="hidden" name="$_alarmdescription" value="Alarm display string$<%=alarm_msg%>">
	<%}
%>	
			<tr>
				<td width="100%" height="10" id="eg_blankspace" colspan="3">&nbsp;</td>
			</tr>
<%
			}
%>
	  <!--Alarm display string code ends-->
<%
			if(testType != null && !testType.equalsIgnoreCase("Custom"))
			{
				if(testType.equalsIgnoreCase("Aggregate"))
				{
%>
					<input type="hidden" name="s_process" value="<%=process%>">
<%
				}
				else
				{
%>
					<tr>
						<td width="250" align="left"  height="20" nowrap><egui:intnl text="admin.ic.Process method"/></td>
						<td  nowrap width="20" align="center">:</td>
						<td width="250" align="left" valign="bottom" height="20"  nowrap><select name="s_process" onchange='Javascript:listSelect("process")' style='width:180;'>
<%
							String temp = "";
							for(int i=0; i<processes.length; i++)
							{
								String tmpProc = processes[i];
								String tmpSel = procSel[i];

								if(tmpSel.equalsIgnoreCase("selected"))
									temp = tmpProc;
%>
								<option value="<%= tmpProc %>" <%= tmpSel %>><%= tmpProc %>
<%
							}
%>
							</select>
						</td>
					</tr>
					<tr>
						<td width="100%" height="10" id="eg_blankspace" colspan="3">&nbsp;</td>
					</tr>
<%
	if(isFactorEnabled)
	{
%>
					<tr>
						<td width="250" align="left"  height="20" nowrap><egui:intnl text="admin.ic.Conversion Factor"/></td>
						<td  nowrap width="20" align="center">:</td>
						<td width="250" align="left" valign="bottom" height="20"  nowrap><select name="cFactor" style='width:180;' onchange="Javascript:factorSelect()">
<%
							String tmpFact = "none";
							for(int i=0; i<factors.length; i++)
							{
								String fact = iniUI.getValue("CONVERSION_FACTORS", factors[i].toString());
								String tmpSel = factorSel[i];
								if(tmpSel.equals("selected"))
								{
									tmpFact = fact;
								}
%>
									<option  value="<%= fact %>" <%= tmpSel %>><%= factors[i].toString() %>
<%
							}
%>
							</select>
							<input type="hidden" name="s_factor" id="s_factor" value="<%= tmpFact %>"/>
						</td>
					</tr>
					<tr>
						<td width="100%" height="10" id="eg_blankspace" colspan="3">&nbsp;</td>
					</tr>
					<input type="hidden" name="$_cFactor" value='Conversion Factor$<%=request.getParameter("originalFactor")%>'>
<%
	}
	if(reloaded != null && reloaded.equalsIgnoreCase("jamesthomas"))
	{%>
	<input type="hidden" name="$_s_process" value='Process method$<%=request.getParameter("originalProcess")%>'>
	<%}
	else
	{%>
	<input type="hidden" name="$_s_process" value='Process method$<%=temp%>'>
	<%}
%>		
<%
				}
				if(testType != null)
				{
					if(testType.equalsIgnoreCase("Perfmon"))
					{
%>						
					<tr>
						<td width="250" align="left" valign="top" height="20"  nowrap><egui:intnl text="admin.ic.Counter name"/>
<%
					}
					else if(testType.equalsIgnoreCase("Jmx"))
					{
%>						
						<td width="250" align="left" valign="top" height="20"  nowrap> <egui:intnl text="admin.ic.Attribute Name"/>
<%
					}
					else if(testType.equalsIgnoreCase("Snmp"))
					{
%>						
						<td width="250" align="left" valign="top" height="20"  nowrap> <egui:intnl text="admin.ic.Object ID"/>
<%
					}
				}
%>
						</td>
		
<%
				if(testType != null)
				{
					if(testType.equalsIgnoreCase("Perfmon") || testType.equalsIgnoreCase("Jmx"))
					{
%>
						<td  nowrap width="20" align="center">:</td>
						<td width="250" align="left" valign="bottom" height="20"  nowrap>
						<input type="text" name="s_counter" value="<%= counter %>" size="20" maxlength="100" style='width:180;'>
<%
					}
					else
					{
						if(testType.equalsIgnoreCase("Snmp"))
						{
%>
							<td  nowrap width="20" align="center">:</td>
							<td width="250" align="left" valign="bottom" height="20"  nowrap>
								<table border="0" cellpadding="0" cellspacing="0">
									<tr>
										<td> <input type="text" name="s_oid" value="<%= oid %>"  id="s_oid" size="20" maxlength="100" style='width:180;'>&nbsp;</td>
										<td><img id='mouse' border="0" onclick="openWin(event,'modify','ObjectOID','<%=oid%>')"   title="Tree" src="/final/admin/eg_images/<%=admin_Skin%>/tree.gif"  width="16" height="14"/>
									</tr>
								</table>
							</td>
<%
						}
					}
				}
%>
							</td>
							</tr>
<%
	if(testType.equalsIgnoreCase("Snmp"))
	{
		if(reloaded != null && reloaded.equalsIgnoreCase("jamesthomas"))
		{
			String tempOid = request.getParameter("org_oid");
			if(tempOid != null && tempOid.indexOf(":") !=-1)
				tempOid = tempOid.substring(tempOid.indexOf(":")+1);
		%>
		<input type="hidden" name="$_s_oid" value='Object ID$<%=tempOid%>'>
		<%}		
		else
		{
			String tempOid = oid;
			if(tempOid != null && tempOid.indexOf(":") !=-1)
				tempOid = tempOid.substring(tempOid.indexOf(":")+1);
		%>
		<input type="hidden" name="$_s_oid" value='Object ID$<%=tempOid%>'>
		<%}
	}	
%>
<%
	if(testType.equalsIgnoreCase("Perfmon") || testType.equalsIgnoreCase("Jmx"))
	{
		if(reloaded != null && reloaded.equalsIgnoreCase("jamesthomas"))
		{
			String tempCounter = request.getParameter("org_counter");
			if(tempCounter != null && tempCounter.indexOf(":") !=-1)
				tempCounter = tempCounter.substring(tempCounter.indexOf(":")+1);
		%>
		<input type="hidden" name="$_s_counter" value='Counter name$<%=tempCounter%>'>
		<%}
		else
		{
			String tempCounter = counter;
			if(tempCounter != null && tempCounter.indexOf(":") !=-1)
				tempCounter = tempCounter.substring(tempCounter.indexOf(":")+1);
		%>
		<input type="hidden" name="$_s_counter" value='Counter name$<%=tempCounter%>'>
		<%}
	}	
%>
			<tr>
		<td width="100%" height="10" id="eg_blankspace" colspan="3">&nbsp;</td>
		</tr>
<%
			}
%>
		</table>
		</td>
		</tr>
		 <tr>
                <td width="100%" align="center" valign="bottom" height="30"  colspan="3"  nowrap>
					<input type="button" name="ad" class="eg_back" value='<egui:intnl text="admin.ic.Modify"/>' onClick="JavaScript:modifyMeasure('buttonsubmit');" style="width: 80px;">
				</td>
          </tr>
	</table>
</td>
</tr>
</table>
<input type="hidden" name="test" value="<%= test %>">
<input type="hidden" name="testtype" value="<%= testType %>">
<input type="hidden" name="org_measure" value="<%= org_measure %>">
<input type="hidden" name="org_process" value="<%= org_process %>">
<input type="hidden" name="org_factor" value="<%= org_factor %>">
<input type="hidden" name="org_counter" value="<%= org_counter %>">
<input type="hidden" name="org_oid" value="<%= org_oid %>">
<input type="hidden" name="index" value="<%= index %>">
<input type="hidden" name="from" value="<%= from %>">
<input type="hidden" name="callPage" value="<%= callPage %>">
</form>
<%
if(request.getQueryString()!=null)
session.setAttribute("adminLastAccessedURL","/final/admin/EgModifyMeasures.jsp?"+request.getQueryString());
else session.setAttribute("adminLastAccessedURL","/final/admin/EgModifyMeasures.jsp");
%>
</body>
</html>
