<!DOCTYPE html>

<%@ include file="EgTrackerA.jsp" %>
<%@ page import = "com.eg.EgMemInfo" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>


<%
	if(request.getQueryString()!=null)
		session.setAttribute("adminLastAccessedURL","/final/admin/EgSuperMgr.jsp?"+request.getQueryString());
	else session.setAttribute("adminLastAccessedURL","/final/admin/EgSuperMgr.jsp");

	String mode = "";
	String managerFrom = "";
	if(request.getQueryString()!=null)
	{
		mode = (String) request.getParameter("mode");
		managerFrom = (String) request.getParameter("from");
	}
	String licenseCheck = "me";
	String notAllowedAlert = "";

	boolean superMgrEnabled = false;
	boolean egSuperManagerEnabled = false;
	synchronized(licenseCheck)
	{
		superMgrEnabled = EgMemInfo.superMgrEnabled;
		egSuperManagerEnabled = EgInstallInfo.isSMSupported; // SM
	}
	if(!superMgrEnabled && !egSuperManagerEnabled)
	{
		notAllowedAlert = "Your license does not allow you to use this feature";
	}
%>

<html>
<head>
	<meta charset="utf-8">
	<title>SUPERMANAGER - ADD/DELETE</title>

	<!--Skin color--------->
	<egui:skin ui = "admin"/>

	<!---Components, icons, skin and Core ext script--->
	<script type="text/javascript" src="../extjs/ext-all.js"></script>

	<!-- Fancy Scroll-->
	<script src="/final/jquery/jquery.js"></script>
	<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
	<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
	<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
	<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>

	<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
	<script language="JavaScript1.2" src="eg_scripts/validate.js"></script>

	<script language="JavaScript">
		var csrfToken = '<%=strCsrfToken%>';

		var alertForNotAllowed = '<%=notAllowedAlert%>';
		var alertForSingleDeleteConfirmation = '<egui:intnl text="admin.egsm.Are you sure you want to delete the supermanager"/>';
		var alertForDeleteConfirmation = '<egui:intnl text="admin.egsm.Are you sure you want to delete the selected supermanagers"/>?';
		var alertForAdded = '<egui:intnl text="admin.egsm.Supermanager added successfully"/>.';
		var alertForDeleted = '<egui:intnl text="admin.egsm.Supermanager deleted successfully"/>.';
		var alertForModified = '<egui:intnl text="admin.egsm.Supermanager modified successfully"/>.';
		var superMgrConfigTitle = '<egui:intnl text="admin.egsm.SUPERMANAGER - ADD/DELETE "/>';
		var superMgrConfigDesc = '<egui:intnl text="admin.egsm.This page enables the administrator to add/delete supermanager(s)"/>' + '.';
		var superMgrNameLabel = '<egui:intnl text="admin.egsm.ID of supermanager"/>';
		var superMgrAltIPLabel = '<egui:intnl text="admin.egsm.IP(s) of supermanager for access validation"/>';
		var superMgrAltIPTooltipLabel = '<egui:intnl text="admin.egsm.IP addresses should be separated by comma(,)"/>';
		var superMgrURLLabel = '<egui:intnl text="admin.egsm.URL to connect to the supermanager"/>';
		var supermanagerLabel = '<egui:intnl text="admin.egsm.URL to connect to the supermanager"/>';
		var superMgrUpdateBtnText = '<egui:intnl text="admin.egsm.Update"/>';
		var superMgrAddText = '<egui:intnl text="admin.egsm.Add"/>';
		var superMgrConfig = '<egui:intnl text="admin.egsm.SuperManager Configuration"/>';
		var superMgrDelete = '<egui:intnl text="admin.egsm.DELETE SUPERMANAGER"/>';
		var addSuperMgrTitle = '<egui:intnl text="admin.egsm.ADD SUPERMANAGER"/>';
		var modifySuperMgrTitle = '<egui:intnl text="admin.egsm.MODIFY SUPERMANAGER"/>';
		var noSuperMgr = '<egui:intnl text="admin.egsm.No supermanagers have been configured"/>';
		var id_space = '<egui:intnl text="admin.egsm.ID of supermanager cannot contain space"/>';
		var id_reserved = '<egui:intnl text="admin.egsm.ID of supermanager cannot be eG reserved word"/>';
		var id_splchar = '<egui:intnl text="admin.egsm.ID of supermanager cannot contain special character"/>';
		var url_blank = '<egui:intnl text="admin.egsm.URL to connect to the supermanager cannot be blank"/>';
		var url_space = '<egui:intnl text="admin.egsm.URL to connect to the supermanager cannot contain space"/>';
		var url_invalid = '<egui:intnl text="admin.egsm.URL to connect to the supermanager is invalid"/>';
		var alt_blank = '<egui:intnl text="admin.egsm.IP(s) of supermanager for access validation cannot be blank"/>';
		var alt_space = '<egui:intnl text="admin.egsm.IP(s) of supermanager for access validation cannot contain space"/>';
		var alt_invalid = '<egui:intnl text="admin.egsm.IP(s) of supermanager for access validation is invalid"/>';

		var smid_blank = '<egui:intnl text="admin.egsm.ID of supermanager cannot be blank"/>';
		var alertForNoDeleteSelected = '<egui:intnl text="admin.egsm.Please choose a SuperManager"/>';
		var addSuperMgr = '<egui:intnl text="admin.egsm.Add SuperManager"/>';

		var probsErrorMessage = '<egui:intnl text="admin.error.Problem encountered while loading the user interface"/>.';
		var requestTimeOut = '<egui:intnl text="admin.error.Response timed out"/>.';
		var errorTitle = '<egui:intnl text="admin.user.Error"/>';
	</script>

	<!-- Application folder -->
	<script type="text/javascript" src="EgSuperMgr/app/app.js"></script>

	<script language="javascript">
		Ext.onReady(function(){
			Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};

			Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
				else
				{
					if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : requestTimeOut,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
					else
					{
						console.log(response.responseText);
						Ext.Msg.show({
							title : errorTitle,
							msg : probsErrorMessage,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
				}
			});
		});
	</script>
</head>
<body>
	<div id="loadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;"><div class="x-mask-loading" style="position:relative">Loading...</div></div>
</body>
</html>



