<%
/**
 *  File         : EgTestParamp.jsp
 *  Purpose      : Process page for EgConfigTest.jsp
 *  Version      : 0.0
 *  Creation Date: 23/08/2000
 *  Last Modified:
 *			22/06/2004	Arun		Weblogic tests have use a "server" parameter which is also used by
 *									the JSP to send the server type. Change the query parameter to
 *									typeOfServer to remove ambiguity.

			03/01/2004	Saravanan - URL encoded before writing to ini file.
						Saravanan -Password encryption bug fix when processed thro Apply Defaults
		  6/08/2003 //gopi & saravanan apply confign to similar servers
		  20/07/2003 //gopi - DD disable tests for server writes into eg_testinfo.ini
		  21/03/2003 // KK - Fixed a bug when multiple URL patterns (4 patterns) for the HttpTest are given
		  10/02/2003 //gopi - Test Period formatting in secs,mins,hrs
		  21/01/2003 //sandhya - Nickname change
		  06/12/2002 //sandhya - Validation for IC tests
		  08/11/2002 //sandhya - Validation for search
		  18/09/2002 //kk - Validation for ProcessPoolTest
				13/07/2002 //Bala - Changed "@" to "!" in httptest params

	          8/07/2002 //sandhya - To allow multiple urls separated by comma and allow '&' as a part of url.
						 DnsTest(Targets and Recursive)
		  27/03/2002 //sandhya - Encrypt/Decrypt
		  26/03/2002 //sandhya - Enable SSL
		  03/11/2001 //bala - to fix display of redundant 'process'.
		  21/09/2001 //sandhya - to comment the code updating CONFIGURED SERVERS in eg_testparam.ini
                  05/06/2001 //Bala - To stop discovery before writing to agents and start discovery
				after completion
		  22/03/2001 //Sandhya.K - To change password parameter & protocol parameter in MailTest
		  03/03/2001 //Sandhya.K
		  29/09/2000 // Sandhya.K
 *  Author       : Sridevi.T & Sandhya.K
 */
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import="com.eg.EgCrypt" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="com.egurkha.ini.*" %>
<%@ page import="java.net.URLEncoder" %>
<%@ page import="java.util.*" %>
<%@ page import="java.io.File" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.EgExternalInfo" %>
<%@ page import="com.eg.UploadCorrectiveScript" %>
<%@ page import="com.eg.EgServicesInfo" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgDiscInfo" %>
<%@ page import="com.eg.EgDateInfo"%>
<%@ page import="com.eg.EgUtils"%>
<%@ page import="com.egurkha.util.*" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.admin.AuditLogHashtable"%>
<%@ page import = "com.eg.EgAggregateInfo"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<jsp:useBean id="tryIni" class="egurkha.EgTestParamBean" scope="page" />
<jsp:useBean id="servicer" class="egurkha.ServiceBean" scope="page" />

<%!
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
%>

<%
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Tests");
	auditLogThread.setValue("Activity","Configure Test");
	/* code for auditlog ends */

	IniUI iniui = IniUI.getInstance();
	String high = iniui.getStateDisplayLabel("HIGH");
	String medium = iniui.getStateDisplayLabel("INTERMEDIATE");
	String low = iniui.getStateDisplayLabel("LOW");

	int j = 0;
	boolean flag = false;
	Hashtable ht_revValue=new Hashtable();
	String entity="";
	String recTest=(String)session.getAttribute("tName");
	String recTestName = (String)session.getAttribute("tName");
	String specialCharactersAllowedParameter = (String)session.getAttribute("specialCharactersAllowedParameter");
	StringTokenizer stParams = new StringTokenizer(specialCharactersAllowedParameter,",");
	ArrayList aListSpecialCharacterAllowedParam = new ArrayList();
	while(stParams.hasMoreTokens())
	{
		String specialParam = (stParams.nextToken()).toLowerCase();
		aListSpecialCharacterAllowedParam.add(specialParam);
	}

	String[] tcKeywords = (String[])session.getAttribute("tcKeywords");
	ArrayList aListEgKeyWords = new ArrayList(Arrays.asList(tcKeywords));

	// for DB Optimization
	EgServicesInfo egserInfo = new EgServicesInfo("manager");
	EgExternalInfo extInfo =new EgExternalInfo("manager");
	Hashtable hash = extInfo.getInternalAgentMap();
	Vector hostSysTests = new Vector();
	boolean uniqueHostSystemData = egserInfo.isUniqueHostSystemData();
	String from = request.getParameter("from");
	String tstName[] = egSpecs.getTestsForServer ("Host_system");
	if (tstName != null)
	{
		for (int k=0; k<tstName.length;k++)
		hostSysTests.add(tstName[k]);
	}

	//for DD Disabling var declaration
	String s_recTestName = recTestName;
	String ddset ="";

	String tName = recTestName;
	String show=(String)session.getAttribute("show");
	String serverName = (String)session.getAttribute("sName");
	String serverList = (String)session.getAttribute("serverLists");
	String otherServers = (String)session.getAttribute("otherServers"); //New 1.0

	Vector sess_vec = new Vector();

	Vector tests = new Vector();
	String s_var[] = egSpecs.getTestInfosWithDelimiters();
	for(int i=0; i<s_var.length; i++)
	{
		String s_val = egSpecs.getTestInfoDelimiter(s_var[i]);
		if(s_val.equals("#"))
		{
			if(!tests.contains(s_var[i]))
			{
				tests.add(s_var[i]);
			}
		}
	}

	sess_vec.addElement(_mapping.getTextDescription("admin.test.Parameters configuration for test"));
	sess_vec.addElement("EgConfigTest.jsp?qctr=1&compname=undefined&rctr=0&t_name="+ recTestName +"&comptype="+ serverName + "&typeOfServer=" +serverName+"&showAll="+show );
	sess_vec.addElement(_mapping.getTextDescription("admin.test.parameters configuration for tests"));
	String strComp=(String)session.getAttribute("selectedComponent");
	sess_vec.addElement(_mapping.getTestDescription(recTestName)+" "+_mapping.getTextDescription("admin.test.parameters configured for")+" "+strComp+" ("+_mapping.getComponentTypeDescription(serverName)+")");

	Vector vecReceive = (Vector)session.getAttribute("vec_Return");
	int vectorSize = vecReceive.size();
	String tempServerList = "";
	if(serverList != null)
	{
		int idx = serverList.indexOf(":");
		if(idx > 0)
			tempServerList = serverList.substring(0,idx);
		else
			tempServerList = serverList;
	}
	boolean isSSHPort = EgExternalInfo.isSSHModeSelected(tempServerList);
	//To replace default values in vector with parameters passed

	for (int i=0; i<vectorSize; i=i+3)
	{
		String name = ((String)vecReceive.elementAt(i)).trim();
		j = i+2;

		String reqParam = request.getParameter(name);
		if(reqParam == null || reqParam.equals("null"))
			continue;

		if(reqParam.equalsIgnoreCase("IMAP") || reqParam.equalsIgnoreCase("POP3"))
		{
			reqParam = reqParam.toLowerCase();
		}

		if (name.equalsIgnoreCase("process"))
		{
			if (reqParam.indexOf(" -") != -1)
			{
				reqParam = StringUtils.replace(reqParam," -","eGSpHyGe");
			}
		}
		if (name.equalsIgnoreCase("filter"))
		{
			String[] filterValue = request.getParameterValues("filter");
			ArrayList aListFilterValue = new ArrayList(Arrays.asList(filterValue));
			reqParam = aListFilterValue.toString();
			reqParam = reqParam.substring(1,reqParam.length()-1);
			if (reqParam.indexOf(",") > -1)
			{
				if (reqParam.indexOf(";") == -1)
				{
					if (reqParam.indexOf(":") > -1)
					{
						reqParam = StringUtils.replace(reqParam,",","|");
					}
					else
					{
						reqParam = StringUtils.replace(reqParam,",",";");
						reqParam = StringUtils.replace(reqParam," ","");
					}
				}
				else
				{
					reqParam = StringUtils.replace(reqParam,",","|");
				}
			}
		}
		if ((name.indexOf("password") > -1)
			|| (name.indexOf("Password") > -1)
			|| (name.indexOf("PASSWORD") > -1)
			|| (name.indexOf("authpass") >-1)
			|| (name.indexOf("credentials") >-1))
		{
			//reqParam = EgCrypt.encrypt(reqParam);
			// This change was done to encrypt properly whether request passes through
			// EgApplyDefaults or not...
			String credUser = "";
			String credPass = "";
			StringBuffer credBuff = new StringBuffer();
			if(name.indexOf("credentials") >-1)
			{
				StringTokenizer stc = new StringTokenizer(reqParam,",");
				int stcCount = stc.countTokens();
				int thisCount = 0;
				while(stc.hasMoreTokens())
				{
					thisCount++;
					String myToken = stc.nextToken();
					StringTokenizer stc1 = new StringTokenizer(myToken,":");
					int tokenCount = 0;
					while(stc1.hasMoreTokens())
					{
						String thisToken = stc1.nextToken();
						switch(tokenCount)
						{
							case 0:
								credUser = thisToken;
							break;
							case 1:
								if(egserInfo.isAesEncryptForTestConfig())
									credPass = EgCrypt.encrypt(thisToken);
								else
									credPass = EgCrypt.encrypt(thisToken, true);
							break;
						}
						tokenCount++;
					}
					credBuff.append(credUser+":"+credPass);
					if(thisCount != stcCount)
						credBuff.append("|");
				}
				vecReceive.set(j,credBuff.toString());
				ht_revValue.put(name,credBuff.toString());
			}
			else
			{
				reqParam = EgCrypt.decrypt(reqParam);
				String passList = "";
				if ((tName.equals("CtxAuthTest") || tName.equals("WinAuthTest") || tName.equals("TermAuthTest")) && reqParam.indexOf("#~#") > -1)
				{
					ArrayList aListTokens = StringUtils.myTokenizer(reqParam,"#~#");
					for(int m=0;m<aListTokens.size();m++)
					{
						passList += EgCrypt.encrypt((String)aListTokens.get(m)) + "|";
					}
					passList = passList.substring(0, passList.length()-1);
				}
				else
				{
					passList = EgCrypt.encrypt(reqParam);
				}
				reqParam = passList;
				vecReceive.set(j,reqParam);
				ht_revValue.put(name,reqParam);
			}
		}
		else
		{
			vecReceive.set(j,reqParam);
			ht_revValue.put(name,reqParam);
		}
		
		if (! ((name.indexOf("password") > -1)
				|| (name.indexOf("Password") > -1)
				|| (name.indexOf("PASSWORD") > -1)
				|| (name.indexOf("authpass")>-1))
			&& !reqParam.equals("noteditable"))
		{
			if (name.equalsIgnoreCase("mode"))
			{
				if (!recTestName.equalsIgnoreCase("OraTablespacesTest"))
				{
					if (reqParam.equals("true"))
					{
						reqParam = "SNMP";
					}
					else
					{
						reqParam = "JMX";
					}
				}
				sess_vec.addElement(_mapping.getTextDescription("admin.test."+name.toUpperCase()) +" :: "+ reqParam);
				ht_revValue.put(name,reqParam);
			}
			else if (name.equalsIgnoreCase("Profiler"))
			{
				if (reqParam.equals("true"))
				{
					reqParam = "On";
				}
				else
				{
					reqParam = "Off";
				}
				sess_vec.addElement(_mapping.getTextDescription("admin.test."+name.toUpperCase()) +" :: "+ reqParam);
				ht_revValue.put(name,reqParam);
			}
			else if(reqParam.equals("false"))
			{
				sess_vec.addElement(_mapping.getTextDescription("admin.test."+name.toUpperCase())+" :: "+ _mapping.getTextDescription("admin.common.No"));
				ht_revValue.put(name,"no");
			}
			else if(reqParam.equals("true"))
			{
				sess_vec.addElement(_mapping.getTextDescription("admin.test."+name.toUpperCase())+" :: "+ _mapping.getTextDescription("admin.common.Yes"));
				ht_revValue.put(name,"yes");
			}
			else
			{
				String field = name.toUpperCase();
				String value = request.getParameter(name);
				if(field.equalsIgnoreCase("ALARMTYPE"))
				{
					if(value.equals("H"))
						value = high;
					else if(value.equals("M"))
						value = high+"/"+medium;
					else if(value.equals("L"))
						value = high+"/"+medium+"/"+low;
				}

				if(field.equals("URL") || field.equals("CONTENT"))
				{
					String tok = "";
					if(value.indexOf(",") > -1)
					{
						tok = value.substring(0,value.indexOf(","));
						ht_revValue.put(field,tok);
					}
					else
					{
						ht_revValue.put(field,value);
					}
					sess_vec.addElement(_mapping.getTextDescription("admin.test."+field) +" :: "+value);
				}
				//TestPeriod Format coding in sec,min,hrs
				else if(field.equals("TESTPERIOD"))
				{
					String tp=value.trim();
					if (Integer.parseInt(tp) <= 60)
					{
						tp+=" secs";
					}
					else if (Integer.parseInt(tp) <= 3599)
					{
						int tpmin=Integer.parseInt(tp)/60;
						tp=""+tpmin+" mins";
					}
					else if (tp.equals("3600"))
					{
						tp="1 hr";
					}
					else
					{
						int tphr=Integer.parseInt(tp)/3600;
						tp=""+tphr+" hrs";
					}
					value=tp;
					ht_revValue.put(field,value);
					sess_vec.addElement(_mapping.getTextDescription("admin.test."+field)+" :: "+value);
				}
				else
				{
					if(name.equalsIgnoreCase("detaileddiagnosis"))
					{
						ddset = request.getParameter("detaileddiagnosis");
						ht_revValue.put(name,ddset);
					}

					if(!((name.indexOf("almode") > -1)
						|| (name.indexOf("aluser") > -1)
						|| (name.indexOf("alpassword") > -1)
						|| (name.indexOf("agentless") > -1)))
					{
						String tempVal = value;
						if (field.equalsIgnoreCase("os"))
						{
							if (value.equalsIgnoreCase("xp"))
							{
								tempVal = "Window XP";
							}
							else if (value.equalsIgnoreCase("2003"))
							{
								tempVal = "Windows 2003";
							}
							else if (value.equalsIgnoreCase("2008"))
							{
								tempVal = "Windows 2008";
							}
							else if (value.equalsIgnoreCase("w2k"))
							{
								tempVal = "Windows 2000";
							}
							else if (value.equalsIgnoreCase("nt"))
							{
								tempVal = "Windows NT";
							}
							else if (value.equalsIgnoreCase("hpux") || value.equalsIgnoreCase("aix"))
							{
								tempVal = value.toUpperCase();
							}
							else if (value.equalsIgnoreCase("tru64"))
							{
								tempVal = "Tru64";
							}
							else if (value.equalsIgnoreCase("linux"))
							{
								tempVal = "Linux";
							}
							else if (value.equalsIgnoreCase("solaris"))
							{
								tempVal = "Solaris";
							}
							else if (value.equalsIgnoreCase("other"))
							{
								tempVal = "Other";
							}
						}
						if (field.equalsIgnoreCase("Inside_view_using"))
						{
							if (value.equalsIgnoreCase("tcp"))
							{
								tempVal = _mapping.getTextDescription("admin.test.TCP/WMI (Windows)");
							}
							else
							{
								tempVal = _mapping.getTextDescription("admin.test.Netbios (Windows)");
							}
						}
						if (field.equalsIgnoreCase("Using"))
						{
							if (value.equals("exe"))
							{
								tempVal = "Command Line Interface";
							}
							else
							{
								tempVal = "Web services API";
							}
						}
						if (recTestName.equals("RadiusServiceTest") && field.equalsIgnoreCase("AuthType"))
						{
							if (value.equals("chap"))
							{
								tempVal = "CHAP";
							}
							else
							{
								tempVal = "PAP";
							}
						}
						if (field.equalsIgnoreCase("report_by_file_system"))
						{
							if (value.equals("remote"))
							{
								tempVal = "Remote Filesystem";
							}
							else if (value.equals("local"))
							{
								tempVal = "Local Filesystem";
							}
							else
							{
								tempVal = "Both";
							}
						}
						if(!(field.equalsIgnoreCase("sshPort") && !isSSHPort)) // Fix for sshPort removal from results page
						{
							if (field.equalsIgnoreCase("credentials")) // Fix for password removal from results page for HTTP Post test
							{
								StringTokenizer stt = new StringTokenizer(tempVal,",");
								tempVal="";
								while(stt.hasMoreTokens())
								{
									String token = stt.nextToken();
									tempVal += token.substring(0,token.indexOf(":"))+",";
								}
								tempVal = tempVal.substring(0,tempVal.length()-1);
							}
							sess_vec.addElement(_mapping.getTextDescription("admin.test."+field) +" :: "+ tempVal);
						}

						ht_revValue.put(field,value);
					}
				}
				ht_revValue.put(name,reqParam);
			}
		}
	}

	//Stopping discovery
	servicer.stopDiscovery();
	/* new code */
	String iniVal = null;
	String strFinal = "";
	String strTemp = "";
	String strVecVar = "";
	String strVecVal = "";

	//code specific to apply similar servers starts
	List otherServersList;
	String[] otherTokens = StringUtils.getTokens(otherServers, EgConstants.COMMA);
	if (otherTokens != null)
	{
		otherServersList = Arrays.asList(otherTokens);
	}
	else
	{
		otherServersList = new LinkedList();
	}
	//code specific to apply similar servers ends

	tryIni.createFile("eg_services.ini");
	String strSubject = "NOPORT_SERVERS";
	String strVariables[] = tryIni.getVariables(strSubject);
	List listNoPortServers = Arrays.asList(strVariables);

	//code to get test relations from eg_testparam.ini
	tryIni.createFile("eg_testparam.ini");
	String subject1 = "TEST_RELATIONS";
	String iniVars1[] = tryIni.getVariables(subject1);
	ArrayList al_common=new ArrayList();
	String subjectc="COMMON_TEST_RELATIONS";
	String arrlist[]=tryIni.getVariables(subjectc);
	List list = Arrays.asList(arrlist);
	al_common = new ArrayList(list);
	Vector v_commom=new Vector();
	for(int l=0;l<al_common.size();l++)
	{
		String strcom=(String)al_common.get(l);
		StringTokenizer strok= new StringTokenizer(strcom,",");
		while(strok.hasMoreTokens())
		{
			v_commom.add(strok.nextElement());
		}
	}

	List testRelList = null;
	if (iniVars1 == null)
	{
		testRelList = new LinkedList();
	}
	else
	{
		testRelList = Arrays.asList(iniVars1);
	}

	List vecTestVal = new LinkedList();
	StringTokenizer stTest = null;
	int stTestCount = 0;

	if(testRelList.indexOf(recTestName) > -1)
	{
		vecTestVal.add(recTestName);
		String iniVal1 = tryIni.getStrValue(subject1,recTestName);
		stTest = new StringTokenizer(iniVal1, ",");
		stTestCount = stTest.countTokens();
		for(int i=0; i<stTestCount; i++)
		{
			vecTestVal.add((stTest.nextToken()).trim());
		}
	}
	else
	{
		vecTestVal.add(recTestName);
	}

	//auditlog by ahamed (adding auto configured tests)
	boolean auto = true;
	ArrayList auditLogList = new ArrayList();
	String configuredTest = recTestName;
	//end

	//tryIni.createFile("eg_agents.ini","save");
	tryIni.createSyncFile("eg_agents.ini","save");
	String subject[] = tryIni.getSubject();
	List v_var = new LinkedList();
	for(int i=0; i<subject.length; i++)
	{
		String iniVars[] = tryIni.getVariables(subject[i]);
		v_var.addAll(Arrays.asList(iniVars));
	}

	recTestName = recTestName.trim() + ":" + serverName + ":" + serverList;
	recTestName = recTestName.trim();
	if(v_var.indexOf(recTestName) == -1)
	{
		flag = true;
	}
	String tmpOldStr = "";

	//By Anand - Start (24-01-2009)
	String componentType = new String(serverName);
	String componentName = new String(serverList); //componentName can be in the following format : nickname or nickname:NULL or nickname:8080 or nickname:1521:sid
	List aListAgents = getAgents(componentName);
	//By Anand - End (24-01-2009)

	EgDiscInfo egDiscInfo = new EgDiscInfo("manager");
	String tempComponentName = new String(serverList);
	if (tempComponentName.indexOf(":") > -1)
	{
		tempComponentName = tempComponentName.substring(0,tempComponentName.indexOf(":"));
	}
	ArrayList aListPorts = egDiscInfo.getPort(componentType,tempComponentName);

	for (int m=0; m<vecTestVal.size(); m++)
	{
		String tempTestName = ((String)vecTestVal.get(m)).trim();

		boolean isExternalTest = egSpecs.isExternalTest(tempTestName,componentType);
		List aListTempAgents = null;
		if (isExternalTest)
		{
			aListTempAgents = aListAgents.subList(1,aListAgents.size());
		}
		else
		{
			aListTempAgents = aListAgents.subList(0,1);
		}

		recTestName = tempTestName + ":";
		boolean isDoneWithDefaultPattern = false;
		ArrayList aListSearchPatterns = new ArrayList();

		boolean b_isPortRelevantForTest = egSpecs.isPortRelevantForTest(tempTestName);

		String specificPattern = recTestName + componentType + ":";
		if (componentName.indexOf(":") == -1)
		{
			if (listNoPortServers.contains(componentType))
			{
				if (b_isPortRelevantForTest)
				{
					specificPattern = specificPattern + componentName + ":NULL";
				}
				else
				{
					specificPattern = specificPattern + componentName;
				}
				aListSearchPatterns.add(specificPattern);
			}
			else
			{
				isDoneWithDefaultPattern = true;
				for (int i=0;i<aListPorts.size();i++)
				{
					String strPort = (String)aListPorts.get(i);
					String tempSpecificPattern = specificPattern + componentName + ":" + strPort;
					aListSearchPatterns.add(tempSpecificPattern);

					String tempDefaultPattern = recTestName + ":";
					if (b_isPortRelevantForTest)
					{
						tempDefaultPattern = tempDefaultPattern + componentName + ":" + strPort;
					}
					else
					{
						if (componentName.indexOf(":") == -1)
						{
							tempDefaultPattern = tempDefaultPattern + componentName;
						}
						else
						{
							tempDefaultPattern = tempDefaultPattern + componentName.substring(0,componentName.indexOf(":"));
						}
					}
					aListSearchPatterns.add(tempDefaultPattern);
				}
			}
		}
		else
		{
			specificPattern = specificPattern + componentName;
			aListSearchPatterns.add(specificPattern);
		}

		String defaultPattern = recTestName + ":";
		if (!isDoneWithDefaultPattern)
		{
			if (b_isPortRelevantForTest)
			{
				if (listNoPortServers.contains(componentType))
				{
					if (componentName.indexOf(":") == -1)
					{
						defaultPattern = defaultPattern + componentName + ":NULL";
					}
					else
					{
						defaultPattern = defaultPattern + componentName;
					}
				}
				else
				{
					defaultPattern = defaultPattern + componentName;
				}
			}
			else
			{
				if (componentName.indexOf(":") == -1)
				{
					defaultPattern = defaultPattern + componentName;
				}
				else
				{
					defaultPattern = defaultPattern + componentName.substring(0,componentName.indexOf(":"));
				}
			}
			aListSearchPatterns.add(defaultPattern);
		}

		for (int p=0; p<aListTempAgents.size(); p++)
		{
			String tempAgentNickName = ((String)aListTempAgents.get(p)).trim();
			String iniVars[] = tryIni.getVariables(tempAgentNickName);
			List listAgentIniVariables = Arrays.asList(iniVars);

			for (int d=0;d<aListSearchPatterns.size();d=d+2)
			{
				boolean isIntialConfig = false;
				String resultantPattern = "";
				if (listAgentIniVariables.contains((String)aListSearchPatterns.get(d)))
				{
					resultantPattern = (String)aListSearchPatterns.get(d);
				}
				else if (listAgentIniVariables.contains((String)aListSearchPatterns.get(d+1)))
				{
					resultantPattern = (String)aListSearchPatterns.get(d+1);
				}

				if (resultantPattern.equals("")) continue;

				String myName = tempTestName;
				if (!auditLogList.contains(myName)) auditLogList.add(myName);
				iniVal = tryIni.getStrValue(tempAgentNickName,resultantPattern);

				//replace auto to manual
				if(iniVal.indexOf("-auto")>=0)
				{
					iniVal = "-manual" + iniVal.substring(iniVal.indexOf(","),iniVal.length());
					tmpOldStr = iniVal;
					isIntialConfig = true;
				}

				//replace old time period with the new period
				//Modified by Alagu on 16/11/2006
				String measPeriod = iniVal.substring(iniVal.lastIndexOf(",")+1);
				if (recTestName.indexOf(tName)>-1 || v_commom.contains(tName))
					measPeriod = (String)vecReceive.elementAt(2);

				iniVal = iniVal.substring(0,iniVal.lastIndexOf(","));
				int ind = iniVal.indexOf(",");
				strFinal = iniVal.substring(0,ind);
				strTemp = iniVal.substring(ind+1,iniVal.length());
				String strTempLowerCase = strTemp.toLowerCase();

				String encodedUrl = "";
				for(int k=4; k<vecReceive.size(); k=k+3)
				{
					strVecVar = (String)vecReceive.elementAt(k) + " ";
					strVecVal = (String)vecReceive.elementAt(k+1);
					strVecVar = strVecVar.trim();

					if(strVecVar.equals("-url"))
					{
						if(strVecVal.indexOf(",") > -1)
						{
							StringTokenizer st12 = new StringTokenizer(strVecVal, ",");
							String tempUrl = "";
							while(st12.hasMoreTokens())
							{
								tempUrl = st12.nextToken();
								if(tempUrl.indexOf("?") > -1)
								{
									int urlIndex = tempUrl.indexOf("?");
									tempUrl = tempUrl.substring(0, urlIndex) + "?" + URLEncoder.encode(tempUrl.substring(urlIndex + 1));
								}

								if(encodedUrl != null && !encodedUrl.equals(""))
									encodedUrl = encodedUrl + "|" + tempUrl;
								else
									encodedUrl = tempUrl;
							}
							strVecVal = encodedUrl;
						}
						else
						{
							if(strVecVal.indexOf("?") > -1)
							{
								int vecValIndex = strVecVal.indexOf("?");
								strVecVal = strVecVal.substring(0, vecValIndex) + "?" + URLEncoder.encode(strVecVal.substring(vecValIndex + 1));
							}
						}
					}

					if (strVecVar.equals("-targets")
						|| strVecVar.equals("-search")
						|| strVecVar.equals("-content")
						|| strVecVar.equals("-credentials")
						|| strVecVar.equals("-correctivescript"))
					{
						if(strVecVal.indexOf(",") > -1)
						{
							strVecVal = strVecVal.replace(',','|');
						}

						if(strVecVal.indexOf("&") > -1)
						{
							strVecVal = strVecVal.replace('&','!');
						}

						if(strVecVar.equals("-content"))
						{
							if(strVecVal.indexOf(" ") > -1)
							{
								strVecVal = strVecVal.replace(' ','!');
							}
						}
					}
					else if (strVecVar.equals("-userparams") || strVecVar.equals("-recordpattern"))
					{
						if(strVecVal.indexOf("-") > -1)
						{
							strVecVal = strVecVal.replace('-','^');
						}
						if (strVecVar.equals("-userparams") && strVecVal.indexOf(",") > -1)
						{
							strVecVal = strVecVal.replace(',','#');
						}
					}
					//For tests added thru IC, convert comma to pipe
					else if(tName.endsWith("_ex"))
					{
						if(strVecVal.indexOf(",") > -1)
						{
							strVecVal = strVecVal.replace(',','|');
						}
					}
					//For tests added thru IC and checked into VSS as standalone tests, convert comma to pipe
					else if(!tests.contains(tName))
					{
						if(strVecVal.indexOf(",") > -1)
						{
							strVecVal = strVecVal.replace(',','|');
						}
					}
					//For tests like ProcessTest,ProcessPoolTest,MtsProcessTest and OraProcessTest, convert comma to hash(old tests)
					else if(tests.contains(tName))
					{
						if(strVecVal.indexOf(",") > -1)
						{
							strVecVal = strVecVal.replace(',','#');
						}
					}
					String search = strVecVar + " ";

					if(strTemp.indexOf(search)>0)
					{
						int strVecVarIndex = strTemp.indexOf(search);
						String temp0 = strTemp.substring(0, strVecVarIndex);
						String temp1 = temp0.trim() + " " + strTemp.substring(strVecVarIndex, strVecVarIndex+search.length());
						String temp2 = strTemp.substring(strVecVarIndex+search.length(), strTemp.length());
						//see for "-" or ","
						String val = "";
						StringTokenizer st2 = new StringTokenizer (temp2);
						String rest = "";
						while (st2.hasMoreTokens())
						{
							String s = st2.nextToken();
							if (isParameter(s))
							{
								rest = " "+s;
								while (st2.hasMoreTokens())
									rest += " "+ st2.nextToken();
								break;
							}
							else
							{
								val += s + " ";
							}
						}

						val = val.trim();
						if (strVecVar.equalsIgnoreCase("-ddFreq") && m != 0)
						{
							strVecVal = val;
						}
						if(temp2.indexOf(",")>=0)
						{
							temp2 = " " + strVecVal.replace(',','#').trim() + rest;
						}
						else
						{
							temp2 = " "+strVecVal + rest;
						}
						strTemp = temp1 + temp2;
					}
					else
					{
						strTemp = strTemp;
					}
				}

				strFinal = strFinal + ", " + strTemp + ", "+measPeriod;
				while(strFinal.indexOf("\n")!=-1)
				{
					int idx = strFinal.indexOf("\n");
					strFinal = strFinal.substring(0,idx-1)+" "+strFinal.substring(idx+1,strFinal.length()).trim();
				}
				String st_test = resultantPattern.substring(0,resultantPattern.indexOf(":"));
				if (uniqueHostSystemData && hostSysTests.contains(st_test))
				{
					Vector v_val = new Vector();
					Iterator itr = hash.keySet().iterator();
					while(itr.hasNext())
					{
						String s_key = (String) itr.next();
						if(s_key.trim().length() == 0)
							continue;
						String val = (String) hash.get(s_key);
						v_val.add(val);
						v_val.add(s_key);
					}
					StringTokenizer comp = new StringTokenizer(resultantPattern,":");
					int countTok = comp.countTokens();
					if (countTok < 2)
						continue;
					comp.nextToken();
					String Compnt = comp.nextToken();
					if(v_val != null && v_val.size() > 0)
					{
						for (int x=0;x<v_val.size();x+=2)
						{
							String coreAgnt = (String) v_val.get(x);
							String mappedAgnt = (String) v_val.get(x+1);
							if(Compnt.equalsIgnoreCase(coreAgnt))
							{
								if(isIntialConfig)
									strFinal = doProperUpdate(tmpOldStr,strFinal,aListSpecialCharacterAllowedParam,aListEgKeyWords);
								boolean boolRet = tryIni.setValues(tempAgentNickName,resultantPattern,strFinal);
								String var = StringUtils.replace(resultantPattern,Compnt,mappedAgnt);
								tryIni.setValues(tempAgentNickName,var,strFinal);
							}
						}
					}
					else
					{
						if(isIntialConfig)
							strFinal = doProperUpdate(tmpOldStr,strFinal,aListSpecialCharacterAllowedParam,aListEgKeyWords);
						tryIni.setValues(tempAgentNickName,resultantPattern,strFinal);
					}
				}
				else
				{
					String strFinalTemp = strFinal.toUpperCase();
					if (isIntialConfig)
					{
						if (strFinalTemp.indexOf("-MODE") > -1 && strFinalTemp.indexOf("-JMX_REMOTE_PORT") > -1)
						{
							strFinal = doProperUpdateForJVMComponent(tmpOldStr,strFinal,aListSpecialCharacterAllowedParam,aListEgKeyWords);
						}
						else if(strFinalTemp.indexOf("-SNMPPORT") > -1)
						{
							strFinal = doProperUpdateForSNMPComponent(tmpOldStr,strFinal,aListSpecialCharacterAllowedParam,aListEgKeyWords);
						}
						else
						{
							strFinal = doProperUpdate(tmpOldStr,strFinal,aListSpecialCharacterAllowedParam,aListEgKeyWords);
						}
					}
					tryIni.setValues(tempAgentNickName,resultantPattern,strFinal);
				}
			}
		}
	}

	//CODE SPECIFIC TO APPLY TO SIMILAR SERVER STARTS
	//Start of new code -- 1.0

	// for discovery changes - Ramesh KB - Start
	String sub1 = "VIRTUAL_CENTER";
	String eIniFile = "eg_vcmapping.ini";
	String sIniFile = "eg_services.ini";
	String exIniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";
	//IniFile exIniFile = new IniFile(exIniFile_dir +eIniFile,true);
	IniFile svIniFile = new IniFile(exIniFile_dir +sIniFile);
	String disIniFile = "eg_discover.ini";
	String disIniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";
	IniFile disIni = new IniFile(disIniFile_dir +disIniFile);
	String sVar = request.getParameter("host");
	String sVal = request.getParameter("virtual_center");
	String pass = "";
	String strWebPort = "0"; //zero
	StringTokenizer sst =null;
	if (sVal != null && !sVal.equalsIgnoreCase("Other") && !sVal.equalsIgnoreCase("None"))
	{
		pass = request.getParameter("Esx_password");
		pass = EgCrypt.decrypt(pass);
		pass = EgCrypt.encrypt(pass);
		String user = request.getParameter("Esx_user");
		String ssl = request.getParameter("ssl");
		String webPort = request.getParameter("webPort");
		String isDiscovery = "No";
		String line = svIniFile.getValue(sub1,sVal);
		sst = new StringTokenizer(line,"#");
		if(sst.hasMoreTokens())
		{
			String s = sst.nextToken();
			s = sst.nextToken();
			s = sst.nextToken();
			isDiscovery = sst.nextToken();
		}
		if (ssl != null)
		{
			if (ssl.equalsIgnoreCase("true"))
			{
				if (webPort != null)
				{
					if (webPort.equalsIgnoreCase("default"))
					{
						strWebPort = "443";
					}
					else
					{
						strWebPort = webPort;
					}
				}
				else
				{
					strWebPort = "443";
				}
			}
			else
			{
				if (webPort != null)
				{
					if (webPort.equalsIgnoreCase("default"))
					{
						strWebPort = "80";
					}
					else
					{
						strWebPort = webPort;
					}
				}
				else
				{
					strWebPort = "80";
				}
			}
		}
		String append = ssl+"#"+user+"#"+pass+"#"+isDiscovery+"#"+strWebPort;
		IniFile svIniFileWr = EgConfigFilesSync.getInstance(exIniFile_dir +sIniFile);
		svIniFileWr.setValue(sub1,sVal,append);
		svIniFileWr.saveFile();
		EgConfigFilesSync.releaseInstance(svIniFileWr);
		String Var = serverName+":"+sVar+":NULL";
		String Val = serverName+","+sVar+","+sVar+",NULL";
		IniFile exIniFile = EgConfigFilesSync.getInstance(exIniFile_dir +eIniFile);
		exIniFile.setValue(sVal,Var,Val);
		exIniFile.saveFile();
		EgConfigFilesSync.releaseInstance(exIniFile);
	}
	// for discovery changes - Ramesh KB - End

	// Ahamed works again for audit log
	if(auditLogList.size() == 1 && auditLogList.indexOf(configuredTest) > -1)
	{
		auto = false;
	}
	if(auto)
	{
		for(int i=0; i<auditLogList.size(); i++)
		{
			String testTmp = (String) auditLogList.get(i);
			if(testTmp != null && testTmp.equals(configuredTest))
				continue;
			if(testTmp.endsWith("_ex"))
				auditLogThread.setCurrentValue("Other auto configured test(s)",testTmp);
			else
				auditLogThread.setCurrentValue("Other auto configured test(s)","$test$:"+testTmp);
		}
	}
	// Ahamed ends
	IniFile exIniFileWr = EgConfigFilesSync.getInstance(exIniFile_dir +eIniFile);
	Vector v_applyServers = new Vector();
	v_applyServers.addElement(serverList);
	for(int x=0; x<otherServersList.size(); x++)
	{
		serverList = ((String)otherServersList.get(x)).trim();
		if (request.getParameter(serverList+"_server") != null)
		{
			String eachComponentName = new String(serverList);
			String tempCompName = new String(serverList);
			if (request.getParameter("virtual_center_param") != null)
			{
				String[] allServers = disIni.getVariables(serverName);
				List listallServers = Arrays.asList(allServers);
				String check = serverName+":"+tempCompName;
				if (listallServers != null && 
					listallServers.contains(check))
				{
					String val = disIni.getValue(serverName,check);
					StringTokenizer stDD = null;
					stDD = new StringTokenizer(val,",");
					if(stDD != null)
					{
						if(stDD.hasMoreTokens() && stDD.countTokens() >= 2)
						{
							serverName = stDD.nextToken();
							sVar = stDD.nextToken();
							String Var = serverName+":"+sVar+":NULL";
							String Val = serverName+","+sVar+","+sVar+",NULL";
							exIniFileWr.setValue(sVal,Var,Val);
						}
					}
				}
			}
			if (tempCompName.indexOf(":") > -1)
			{
				tempCompName = tempCompName.substring(0,tempCompName.indexOf(":"));
			}
			ArrayList aListTempPorts = egDiscInfo.getPort(componentType,tempCompName);

			List aListCompAgents = getAgents(eachComponentName);
			auditLogThread.setCurrentValue("Test configured for other components",serverList);
			for(int m=0; m<vecTestVal.size(); m++)
			{
				recTestName = ((String)vecTestVal.get(m)).trim();

				boolean isExternalTest = egSpecs.isExternalTest(recTestName,componentType);
				List aListTempAgents = null;
				if (isExternalTest)
				{
					aListTempAgents = aListCompAgents.subList(1,aListCompAgents.size());
				}
				else
				{
					aListTempAgents = aListCompAgents.subList(0,1);
				}

				boolean isDoneWithDefaultPattern = false;
				ArrayList aListSearchPatterns = new ArrayList();

				boolean b_isPortRelevantForTest = egSpecs.isPortRelevantForTest(recTestName);
				String specificPattern = recTestName + ":" + componentType + ":";
				if (serverList.indexOf(":") == -1)
				{
					if (listNoPortServers.contains(componentType))
					{
						if (b_isPortRelevantForTest)
						{
							specificPattern = specificPattern + serverList + ":NULL";
						}
						else
						{
							specificPattern = specificPattern + serverList;
						}
						aListSearchPatterns.add(specificPattern);
					}
					else
					{
						isDoneWithDefaultPattern = true;
						for (int i=0;i<aListTempPorts.size();i++)
						{
							String strPort = (String)aListTempPorts.get(i);
							String tempSpecificPattern = specificPattern + serverList + ":" + strPort;
							aListSearchPatterns.add(tempSpecificPattern);

							String tempDefaultPattern = recTestName + "::";
							if (b_isPortRelevantForTest)
							{
								tempDefaultPattern = tempDefaultPattern + serverList + ":" + strPort;
							}
							else
							{
								if (serverList.indexOf(":") == -1)
								{
									tempDefaultPattern = tempDefaultPattern + serverList;
								}
								else
								{
									tempDefaultPattern = tempDefaultPattern + serverList.substring(0,serverList.indexOf(":"));
								}
							}
							aListSearchPatterns.add(tempDefaultPattern);
						}
					}
				}
				else
				{
					specificPattern = specificPattern + serverList;
					aListSearchPatterns.add(specificPattern);
				}

				String defaultPattern = recTestName + "::";
				if (!isDoneWithDefaultPattern)
				{
					if (b_isPortRelevantForTest)
					{
						if (listNoPortServers.contains(componentType))
						{
							if (serverList.indexOf(":") == -1)
							{
								defaultPattern = defaultPattern + serverList + ":NULL";
							}
							else
							{
								defaultPattern = defaultPattern + serverList;
							}
						}
						else
						{
							defaultPattern = defaultPattern + serverList;
						}
					}
					else
					{
						if (serverList.indexOf(":") == -1)
						{
							defaultPattern = defaultPattern + serverList;
						}
						else
						{
							defaultPattern = defaultPattern + serverList.substring(0,serverList.indexOf(":"));
						}
					}
					aListSearchPatterns.add(defaultPattern);
				}

				for (int p=0; p<aListTempAgents.size(); p++)
				{
					String tempAgentNickName = ((String)aListTempAgents.get(p)).trim();
					String iniVars[] = tryIni.getVariables(tempAgentNickName);
					List listAgentIniVariables = Arrays.asList(iniVars);
					for (int d=0;d<aListSearchPatterns.size();d=d+2)
					{
						boolean isIntialConfig = false;
						String resultantPattern = "";
						if (listAgentIniVariables.contains((String)aListSearchPatterns.get(d)))
						{
							resultantPattern = (String)aListSearchPatterns.get(d);
						}
						else if (listAgentIniVariables.contains((String)aListSearchPatterns.get(d+1)))
						{
							resultantPattern = (String)aListSearchPatterns.get(d+1);
						}

						if (resultantPattern.equals("")) continue;

						iniVal = tryIni.getStrValue(tempAgentNickName,resultantPattern);
						//replace auto to manual
						if(iniVal.indexOf("-auto")>=0)
						{
							iniVal = "-manual" + iniVal.substring(iniVal.indexOf(","),iniVal.length());
							tmpOldStr = iniVal;
							isIntialConfig = true;
						}

						//replace old time period with the new period
						String s_testPeriod = request.getParameter("testperiod_param");
						if(s_testPeriod != null && !s_testPeriod.trim().equals(""))
						{
							iniVal = iniVal.substring(0,iniVal.lastIndexOf(","))+", "+(String)vecReceive.elementAt(2);
							strFinal = iniVal.substring(0,iniVal.indexOf(","));
							strTemp = iniVal.substring(iniVal.indexOf(",")+1,iniVal.length());
						}
						else
						{
							strFinal = iniVal.substring(0,iniVal.indexOf(","));
							strTemp = iniVal.substring(iniVal.indexOf(",")+1,iniVal.length());
						}

						String s_tempVar = "";
						String s_tempVal = "";
						for(int k=4; k<vecReceive.size(); k=k+3)
						{
							strVecVar = (String)vecReceive.elementAt(k) + " ";
							strVecVal = (String)vecReceive.elementAt(k+1);
							strVecVar = strVecVar.trim();

							s_tempVar = strVecVar.substring(strVecVar.indexOf("-")+1);
							s_tempVal = request.getParameter(s_tempVar+"_param");
							if(s_tempVar.equalsIgnoreCase("detaileddiagnosis") && s_tempVal != null)
							{
								if(!v_applyServers.contains(serverList))
								{
									v_applyServers.addElement(serverList);
								}
							}

							if(s_tempVal != null && !s_tempVal.trim().equals(""))
							{
								if (strVecVar.equals("-targets")
									|| strVecVar.equals("-search")
									|| strVecVar.equals("-content")
									|| strVecVar.equals("-correctivescript")
									|| strVecVar.equals("-credentials"))
								{
									if(strVecVal.indexOf(",") > -1)
									{
										strVecVal = strVecVal.replace(',','|');
									}
									if(strVecVal.indexOf("&") > -1)
									{
										strVecVal = strVecVal.replace('&','!');
									}
									if(strVecVar.equals("-content"))
									{
										if(strVecVal.indexOf(" ") > -1)
										{
											strVecVal = strVecVal.replace(' ','!');
										}
									}
								}
								else if(strVecVar.equals("-url"))
								{
									String encodedUrl = "";
									if(strVecVal.indexOf(",") > -1)
									{
										StringTokenizer st12 = new StringTokenizer(strVecVal, ",");
										String tempUrl = "";
										while(st12.hasMoreTokens())
										{
											tempUrl = st12.nextToken();
											if(tempUrl.indexOf("?") > -1)
											{
												int urlIndex = tempUrl.indexOf("?");
												tempUrl = tempUrl.substring(0, urlIndex) + "?" + URLEncoder.encode(tempUrl.substring(urlIndex + 1));
											}

											if(encodedUrl != null && !encodedUrl.equals(""))
												encodedUrl = encodedUrl + "|" + tempUrl;
											else
												encodedUrl = tempUrl;
										}
										strVecVal = encodedUrl;
									}
									else
									{
										if(strVecVal.indexOf("?") > -1)
										{
											int vecValIndex = strVecVal.indexOf("?");
											strVecVal = strVecVal.substring(0, vecValIndex) + "?" + URLEncoder.encode(strVecVal.substring(vecValIndex + 1));
										}
									}
								}
								//For tests added thru IC, convert comma to pipe
								else if(tName.endsWith("_ex"))
								{
									if(strVecVal.indexOf(",") > -1)
									{
										strVecVal = strVecVal.replace(',','|');
									}
								}
								//For tests added thru IC and checked into VSS as standalone tests, convert comma to pipe
								else if(!tests.contains(tName))
								{
									if(strVecVal.indexOf(",") > -1)
									{
										strVecVal = strVecVal.replace(',','|');
									}
								}
								//For tests like ProcessTest,ProcessPoolTest,MtsProcessTest and OraProcessTest, convert comma to hash(old tests)
								else if(tests.contains(tName))
								{
									if(strVecVal.indexOf(",") > -1)
									{
										strVecVal = strVecVal.replace(',','#');
									}
								}
								String search = strVecVar + ' ';
								if(strTemp.indexOf(search)>0)
								{
									int index = strTemp.indexOf(search);
									String temp0 = strTemp.substring(0, index);
									String temp1 = temp0.trim() + ' ' + strTemp.substring(index, index+search.length());
									String temp2 = strTemp.substring(index+search.length(),strTemp.length());

									if (strVecVar.equalsIgnoreCase("-ddFreq") && m != 0)
									{
										if (temp2.indexOf(" -") > -1)
										{
											strVecVal = temp2.substring(0,temp2.indexOf("-"));
										}
										else if (temp2.indexOf(',') > -1)
										{
											strVecVal = temp2.substring(0,temp2.indexOf(","));
										}
										strVecVal = strVecVal.trim();
									}

									//see for "-" or ","
									if(temp2.indexOf(" -")>0)
									{
										temp2 = " " + strVecVal + temp2.substring(temp2.indexOf(" -"),temp2.length());
									}
									else if(temp2.indexOf(',')>0)
									{
										temp2 = ' ' + strVecVal.replace(',','#').trim() + temp2.substring(temp2.indexOf(','),temp2.length());
									}
									strTemp = temp1 + temp2;
								}
								else
								{
									strTemp = strTemp;
								}
							}
						}
						strFinal = strFinal + ", " + strTemp + ", ";
						strFinal = strFinal.substring(0,strFinal.lastIndexOf(","));
						while(strFinal.indexOf("\n")!=-1)
						{
							int idx = strFinal.indexOf("\n");
							strFinal = strFinal.substring(0,idx-1)+" "+strFinal.substring(idx+1,strFinal.length()).trim();
						}
						String strFinalTemp = strFinal.toUpperCase();
						if (isIntialConfig)
						{
							if (strFinalTemp.indexOf("-MODE") > -1 && strFinalTemp.indexOf("-JMX_REMOTE_PORT") > -1)
							{
								strFinal = doProperUpdateForJVMComponent(tmpOldStr,strFinal,aListSpecialCharacterAllowedParam,aListEgKeyWords);
							}
							else if(strFinalTemp.indexOf("-SNMPPORT") > -1)
							{
								strFinal = doProperUpdateForSNMPComponent(tmpOldStr,strFinal,aListSpecialCharacterAllowedParam,aListEgKeyWords);
							}
							else
							{
								strFinal = doProperUpdate(tmpOldStr,strFinal,aListSpecialCharacterAllowedParam,aListEgKeyWords);
							}
						}

						boolean boolRet = tryIni.setValues(tempAgentNickName,resultantPattern,strFinal);

					}
				}
			}
		}
	}
	exIniFileWr.saveFile();
	EgConfigFilesSync.releaseInstance(exIniFileWr);
	//End of new code -- 1.0
	tryIni.saveFile();
	tryIni.releaseInstance();
	/***********************************************************************************/

	//CODE SPECIFIC TO APPLY TO SIMILAR SERVER ENDS

	/********************************************************************************
	*	CODE FOR DISABLE DD WRITES INTO eg_testinfo.ini  ---Gopi
	********************************************************************************/
	//new code to update eg_testinfo.ini for dd disabled test for Specific Server starts

	if(request.getParameter("detaileddiagnosis")!= null)
		ddset = request.getParameter("detaileddiagnosis");

	String s_tname = s_recTestName;
	String s_hostname = "";
	//tryIni.createFile("eg_testinfo.ini", "save");
	tryIni.createSyncFile("eg_testinfo.ini", "save");
	for(int ii =0 ;ii < v_applyServers.size();ii++)
	{
		s_hostname = (String)v_applyServers.get(ii);

		if(s_hostname.indexOf(":")==-1)
			s_hostname = s_hostname + ":NULL";

		Vector v_defaultDD = new Vector();
		String s_defaultDDVars [] = tryIni.getVariables("Disable_DD");
		for(int i=0;i<s_defaultDDVars.length ; i++)
		{
			if(!v_defaultDD.contains(s_defaultDDVars[i]))
				v_defaultDD.addElement(s_defaultDDVars[i]);
		}

		boolean ddupdate = false;
		if(ddset != null && ddset.length()>0)
		{
			Vector v_specificVars = new Vector();
			String s_specificVars [] = tryIni.getVariables("Disable_Specific_DD");
			for(int i=0;i<s_specificVars.length;i++)
			{
				if(s_specificVars[i] != null)
				{
					v_specificVars.addElement(s_specificVars[i]);
					v_specificVars.addElement(tryIni.getStrValue("Disable_Specific_DD",s_specificVars[i]));
				}
			}
			synchronized(this)
			{
				String dd_recTestName = s_tname;
				if(!v_defaultDD.contains(s_tname))
				{
					if(v_specificVars != null && v_specificVars.size()>1)
					{
						for(int i=0;i<v_specificVars.size();i+=2)
						{
							String ser_name = v_specificVars.get(i).toString();
							String s_values = v_specificVars.get(i+1).toString();

							if(s_hostname.equalsIgnoreCase(ser_name))
							{
								StringTokenizer stDD= null;
								Vector v_spec_DDTests = new Vector();
								stDD = new StringTokenizer(s_values,",");
								if(stDD != null)
								{
									while(stDD.hasMoreTokens())
									{
										String temp = stDD.nextToken();
										if(!v_spec_DDTests.contains(temp))
											v_spec_DDTests.addElement(temp);
									}
								}

								if (ddset != null
									&& ddset.equalsIgnoreCase("Off")
									&& v_spec_DDTests.size() > 0
									&& !v_spec_DDTests.contains(s_tname))
								{
									if(s_values != null)
									s_values += ","+s_tname;
									else
										s_values += s_tname;

									ddupdate = tryIni.setValues("Disable_Specific_DD",s_hostname,s_values);
								}
								else
								{
									if (ddset.equalsIgnoreCase("On")
										&& v_spec_DDTests.size() > 0
										&& v_spec_DDTests.contains(s_tname))
									{
										v_spec_DDTests.remove(s_tname);
										String s_newval="";
										for(int jj=0;jj<v_spec_DDTests.size();jj++)
										{
											String s = v_spec_DDTests.get(jj).toString();
											s_newval += s+",";
										}
										if(s_newval != null && s_newval.length() >0)
										{
											s_newval = s_newval.substring(0,s_newval.length()-1);
											ddupdate = tryIni.setValues("Disable_Specific_DD",ser_name,s_newval);
										}
										else
										{
											tryIni.deleteValues("Disable_Specific_DD",s_hostname);
										}
									}
								}
							}
							else
							{
								if(!v_specificVars.contains(s_hostname) && ddset.equalsIgnoreCase("Off"))
								{
									tryIni.setValues("Disable_Specific_DD",s_hostname,s_tname);
								}
							}
						}
					}
					else
					{
						//new entry into specific section
						if(ddset.equalsIgnoreCase("Off"))
							tryIni.setValues("Disable_Specific_DD", s_hostname, s_tname);
					}
				}
			}
		}
	}//FOR ENDS
	tryIni.saveFile();
	tryIni.releaseInstance();

	/* code for auditlog starts */
	AuditLogHashtable auditLogHashtable = (AuditLogHashtable) session.getAttribute("auditLogHashtable");	
	Iterator itr = auditLogHashtable.iterator();
	int i=0;
	while(itr.hasNext())
	{
		i++;
		String key = (String) itr.next();
		if(key.equalsIgnoreCase("agentless") || key.equalsIgnoreCase("ispassive"))
			continue;

		String currentValue = request.getParameter(key);
		if(key.equalsIgnoreCase("testperiod"))
		{
			currentValue = request.getParameter("testPeriodHdn");
		}

		if(currentValue != null && !currentValue.equals("null") && currentValue.trim().length()>0)
		{
			currentValue = currentValue.trim();
			//for audit
			if(key.equalsIgnoreCase("ALARMTYPE"))
			{
				if(currentValue.equals("H"))
					currentValue = high;
				else if(currentValue.equals("M"))
					currentValue = high+"/"+medium;
				else if(currentValue.equals("L"))
					currentValue = high+"/"+medium+"/"+low;
			}
			//end
			if (key.equalsIgnoreCase("password") || 
				key.equalsIgnoreCase("alpassword") || 
				key.equalsIgnoreCase("authpass") || 
				key.equalsIgnoreCase("receivepassword") || 
				key.equalsIgnoreCase("sendpassword") || 
				key.equalsIgnoreCase("proxypassword ") || 
				key.equalsIgnoreCase("Esx_password") || 
				key.equalsIgnoreCase("Admin_password") || 
				key.equalsIgnoreCase("Xen_password") || 
				key.equalsIgnoreCase("Vc_password") || 
				key.equalsIgnoreCase("Encryptpassword") || 
				key.equalsIgnoreCase("From_User_Password"))
			{
				auditLogThread.setCurrentValue(key.substring(0,1).toUpperCase()+ key.substring(1).toLowerCase(),"******");
			}
			else
			{
				String auditKey = key.substring(0,1).toUpperCase()+ key.substring(1).toLowerCase();
				if(auditKey.equalsIgnoreCase("Testperiod"))
					auditKey = "01~~"+auditKey;
				else if(auditKey.equalsIgnoreCase("host"))
				{
					if(recTest.endsWith("_ag") || recTest.endsWith("_agx"))
						continue;
					auditKey = "02~~"+auditKey;
				}
				else if(auditKey.equalsIgnoreCase("credentials"))
				{
					if(currentValue.indexOf(":") !=-1)
					{
						currentValue = currentValue.substring(0,currentValue.indexOf(":")+1)+"******";
					}
				}
				auditLogThread.setCurrentValue(auditKey,currentValue);
			}
		}
	}
	session.removeAttribute("auditLogHashtable");
	String host_audit = s_hostname;
	if(host_audit != null && host_audit.endsWith(":NULL"))
	{
		host_audit = host_audit.substring(0,host_audit.lastIndexOf(":"));
	}
	if(request.getParameter("isReconfigured") != null && request.getParameter("isReconfigured").equals("true"))
		auditLogThread.setValue("Description","Test " + "$test$:"+recTest +" of component "+ "$ctype$:"+serverName+":"+host_audit +  " has been reconfigured");
	else
		auditLogThread.setValue("Description","Test "+ "$test$:"+recTest +" of component "+"$ctype$:" + serverName + ":" + host_audit + " has been configured");
	auditLogThread.sendItToDB();
	/* code for auditlog ends */
	//new code to update eg_testinfo.ini for dd disabled test for Specific Server ends

	//CODE SPECIFIC TO APPLY TO SIMILAR SERVER STARTS
	int i_temp = 0;
	String s_tempIps = "";
	String s_tempStr = "";
	if(sess_vec != null && sess_vec.size() > 0)
	{
		i_temp = sess_vec.indexOf(_mapping.getTextDescription("admin.test.HOST")+" :: "+request.getParameter("host"));
		s_tempIps = (String)sess_vec.elementAt(i_temp);
	}

	for(int yr=0;yr<otherServersList.size();yr++)
	{
		s_tempStr = (String)otherServersList.get(yr);
		if(request.getParameter(s_tempStr+"_server") != null)
		{
			if(s_tempStr.indexOf(":") > -1 && s_tempStr !=null && !s_tempStr.equals(""))
				s_tempStr = s_tempStr.substring(0, s_tempStr.indexOf(":"));
			s_tempIps = s_tempIps +":"+ s_tempStr;
		}
	}

	sess_vec.removeElementAt(i_temp);
	sess_vec.insertElementAt(s_tempIps, i_temp);
	//CODE SPECIFIC TO APPLY TO SIMILAR SERVER ENDS

	session.setAttribute("vec_Results",sess_vec);
	servicer.startDiscovery("1");

	// Corrective script won't be uploaded to the respective directory
	// if the path is directly given in the textfield rather than using the
	// EgUploadServlet.java - this code is just to fix it!
	String correctiveScriptAdded = request.getParameter("correct");
	if(correctiveScriptAdded != null && correctiveScriptAdded.equals("true"))
	{
		// Copy the file to the destination dir if needed
		// inform other managers about this script if
		// this manager is part of a cluster

		String agentOS = request.getParameter("agentOS");
		String file = request.getParameter("correctivescript");
		uploadScript(agentOS, file);
	}
%>

<jsp:forward page='<%="EgResults.jsp?from="+from%>'/>

<%!
	private void uploadScript(String agentOS, String file)
	{
		File scriptFile = new File(file);

		if(scriptFile == null || !scriptFile.exists())
		{
			return;
		}
		else
		{
			//Here we would need just the script file's name for a
			// SM to download it. Not the file name with path.
			if(file.indexOf("/") > -1)
			{
				file = file.substring(file.lastIndexOf("/"));
			}
			else if(file.indexOf("\\") > -1)
			{
				file = file.substring(file.lastIndexOf("\\"));
			}
		}

		if(EgInstallInfo.isClusterSupported)
		{
			//If clustering is supported intimate other managers about the new script.
			UploadCorrectiveScript uploadCorrectiveScript = new UploadCorrectiveScript();
			uploadCorrectiveScript.getCorrectiveScript(agentOS, file);
			uploadCorrectiveScript = null;
		}

		String os = System.getProperty("os.name");
		Runtime r=null;
		Process p = null;

		String destinationStr = EgInstallInfo.getInstallDir() + "/bin/AutoCorrect/" + agentOS;
		File destinationDir = new File(destinationStr);

		try
		{
			if( os.indexOf("Windows")!= -1)
			{
				r = Runtime.getRuntime();
				String cmd ="cmd.exe /c copy " + file +" "+ destinationDir.getAbsolutePath();
				p = r.exec(cmd);

			}
			else
			{
				r = Runtime.getRuntime();
				String cmd ="cp "+ file +" "+ destinationDir.getAbsolutePath();
				try
				{
					p = r.exec(cmd);
				}
				catch(Exception eee)
				{
				}
			}
		}
		catch(Exception x){}

		try
		{
			if(p != null)
			{
				int processExecuted = p.waitFor();
			}
		}catch(Exception e){e.printStackTrace();}

		if(p!=null)
			p.destroy();
	}

	public final boolean isParameter (String s2)
	{
		if (!s2.startsWith("-"))
			return false;
		String ss = EgCrypt.decrypt(s2);
		if (ss.equals(s2)) // not password
		{
			if (s2.length() > 1)
			{
				return (true);
			}
		}
		return false;
	}

	public String changeTrueToYesAndFalseToNo(String value)
	{
		if(value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"))
			value = "Yes";
		else if(value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no"))
			value = "No";
		return value;
	}

	private String doProperUpdate(String oldStr,String newStr,ArrayList aListSpecialCharacterAllowedParam,ArrayList aListEgKeyWords)
	{
		HashMap oldUnConPairs = new HashMap();
		HashMap newUnConPairs = new HashMap();
		String tmpStr = "";
		String tmpVar = "";
		String tmpVal = "";
		String result = newStr;

		oldStr = oldStr.substring(oldStr.indexOf(",")+1);
		newStr = newStr.substring(newStr.indexOf(",")+1);

		StringTokenizer stt = new StringTokenizer(newStr,"-");
		while(stt.hasMoreTokens())
		{
			tmpStr = stt.nextToken().trim();
			if (tmpStr.length() > 0 && tmpStr.indexOf(" ") > -1)
			{
				tmpVar = (tmpStr.substring(0,tmpStr.indexOf(" "))).trim();
				if ((tmpVar.toLowerCase()).indexOf("password") > -1 || 
					(tmpVar.toLowerCase()).equals("authpass"))
				{
					continue;
				}
				tmpVal = (tmpStr.substring(tmpStr.indexOf(" ")+1)).trim();
			}

			if (tmpVal.startsWith("$"))
			{
				if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
				{
					String tmpValLowerCase = tmpVal.toLowerCase();
					tmpValLowerCase = tmpValLowerCase.trim();
					if (aListEgKeyWords.contains(tmpValLowerCase))
					{
						newUnConPairs.put(tmpVar,tmpVal);
					}
				}
				else
				{
					newUnConPairs.put(tmpVar,tmpVal);
				}
			}
		}
		if (newUnConPairs.size() > 0)
		{
			stt = new StringTokenizer(oldStr,"-");
			while(stt.hasMoreTokens())
			{
				tmpStr = stt.nextToken().trim();
				if (tmpStr.length() > 0 && tmpStr.indexOf(" ") > -1)
				{
					tmpVar = (tmpStr.substring(0,tmpStr.indexOf(" "))).trim();
					if ((tmpVar.toLowerCase()).indexOf("password") > -1 || 
						(tmpVar.toLowerCase()).equals("authpass"))
					{
						continue;
					}
					tmpVal = (tmpStr.substring(tmpStr.indexOf(" ")+1)).trim();
				}

				if (tmpVal.startsWith("$"))
				{
					if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
					{
						String tmpValLowerCase = tmpVal.toLowerCase();
						tmpValLowerCase = tmpValLowerCase.trim();
						if (aListEgKeyWords.contains(tmpValLowerCase))
						{
							oldUnConPairs.put(tmpVar,tmpVal);
						}
					}
					else
					{
						oldUnConPairs.put(tmpVar,tmpVal);
					}
				}
			}
			Iterator it = newUnConPairs.keySet().iterator();
			while(it.hasNext())
			{
				Object key = it.next();
				String valNew =  (String)newUnConPairs.get(key);
				String valOld =  (String)oldUnConPairs.get(key);
				if (valNew.equals(valOld))
				{
					result =  "-auto, "+newStr;
					break;
				}
			}
		}
		return result;
	}

	private List getAgents(String componentName)
	{
		List agentsList = new ArrayList();

		EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String tempCompName = new String(componentName);
		String agentNickName = "";

		boolean isRemote = false;
		if (tempCompName.indexOf(":") > -1)
		{
			tempCompName = tempCompName.substring(0,tempCompName.indexOf(":"));
		}

		// To fetch the exact agent for the selected component - start
		isRemote = egExternalInfo.isRemoteBased(tempCompName);
		if (isRemote)
		{
			//Agentless
			agentNickName = egExternalInfo.getRemoteAgentForHost(tempCompName);
		}
		else
		{
			//Auto or Manual
			String agentName = egExternalInfo.getAgentFor(tempCompName);
			if (agentName != null) //Manual
			{
				if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
				{
					agentNickName = (String)internalAgentMap.get(agentName);
				}
				else
				{
					agentNickName = agentName;
				}
			}
			else //Auto
			{
				agentNickName = tempCompName;
			}
		}

		//adding an internal agent (or) a remote agent
		agentsList.add(agentNickName);
		// To fetch the exact agent for the selected component - end

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = egExternalInfo.hasExternalAgent(tempCompName);
		if (hasExternalAgent)
		{
			String extAgents[] = egExternalInfo.getExternalAgentsForHost(tempCompName);
			//adding one or more external agent(s)
			agentsList.addAll(Arrays.asList(extAgents));
		}
		//To fetch the external agent for the selected component type - ends

		return agentsList;
	}

	private String doProperUpdateForJVMComponent(String oldStr,String newStr,ArrayList aListSpecialCharacterAllowedParam,ArrayList aListEgKeyWords)
	{
		//newStr : User updated value
		//oldStr : Ini value

		HashMap oldUnConPairs = new HashMap();
		HashMap newUnConPairs = new HashMap();
		String tmpStr = "";
		String tmpVar = "";
		String tmpVarLowerCase = "";
		String tmpVal = "";
		String result = newStr;

		oldStr = oldStr.substring(oldStr.indexOf(",")+1);
		newStr = newStr.substring(newStr.indexOf(",")+1);

		String oldStrLowerCase = oldStr.toLowerCase();
		String newStrLowerCase = newStr.toLowerCase();

		ArrayList aListJvmParam = new ArrayList();
		//The RadioParams "mode" and "profiler" are not added.because we know that these params will not have $unconfigured value.
		aListJvmParam.add("jmx_remote_port");
		aListJvmParam.add("user");
		aListJvmParam.add("password");
		aListJvmParam.add("pct_low_cpu_util_threads");
		aListJvmParam.add("pct_medium_cpu_util_threads");
		aListJvmParam.add("pct_high_cpu_util_threads");

		ArrayList aListJvmSnmpV1V2Param = new ArrayList();
		aListJvmSnmpV1V2Param.add("snmpcommunity");

		ArrayList aListJvmSnmpV3Param = new ArrayList();
		aListJvmSnmpV3Param.add("username");
		aListJvmSnmpV3Param.add("authpass");
		aListJvmSnmpV3Param.add("authtype");
		aListJvmSnmpV3Param.add("encryptflag");
		aListJvmSnmpV3Param.add("encrypttype");
		aListJvmSnmpV3Param.add("encryptpassword");

		ArrayList aListCommonParams = new ArrayList();
		//param applicable to both jmx and snmp
		aListCommonParams.add("profiler_home");

		//retreving the mode value
		int tempIdx = newStrLowerCase.indexOf("-mode")+1;
		String tempValue = newStr.substring(tempIdx);
		String newModeValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
		newModeValue = newModeValue.trim();

		//retreving the snmpversion value
		String newSnmpVersion = "";
		tempIdx = newStrLowerCase.indexOf("-snmpversion")+1;
		tempValue = newStr.substring(tempIdx);
		newSnmpVersion = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
		newSnmpVersion = newSnmpVersion.trim();

		//retreving the profiler value if exist
		String newProfilerValue = "";
		if (newStrLowerCase.indexOf(" -profiler ") > -1)
		{
			tempIdx = newStrLowerCase.indexOf(" -profiler ")+1;
			tempValue = newStr.substring(tempIdx);
			newProfilerValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf(" -"));
			newProfilerValue = newProfilerValue.trim();
		}

		String oldModeValue = "";
		String oldSnmpVersion = "";
		String oldProfilerValue = "";
		if (!oldStr.equals(""))
		{
			//retreving the mode value
			tempIdx = oldStrLowerCase.indexOf("-mode")+1;
			tempValue = oldStr.substring(tempIdx);
			oldModeValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			oldModeValue = oldModeValue.trim();

			//retreving the snmpversion value
			tempIdx = oldStrLowerCase.indexOf("-snmpversion")+1;
			tempValue = oldStr.substring(tempIdx);
			oldSnmpVersion = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			oldSnmpVersion = oldSnmpVersion.trim();

			//retreving the profiler value if exist
			if (oldStrLowerCase.indexOf(" -profiler ") > -1)
			{
				tempIdx = oldStrLowerCase.indexOf(" -profiler ")+1;
				tempValue = oldStr.substring(tempIdx);
				oldProfilerValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf(" -"));
				oldProfilerValue = oldProfilerValue.trim();
			}
		}

		StringTokenizer stt = new StringTokenizer(newStr,"-");
		while(stt.hasMoreTokens())
		{
			tmpStr = stt.nextToken().trim();
			if (tmpStr.length() > 0 && tmpStr.indexOf(" ") > -1)
			{
				tmpVar = (tmpStr.substring(0,tmpStr.indexOf(" "))).trim();
				tmpVarLowerCase = tmpVar.toLowerCase();
				if (tmpVarLowerCase.indexOf("password") > -1 || 
					tmpVarLowerCase.equals("authpass"))
				{
					continue;
				}
				tmpVal = (tmpStr.substring(tmpStr.indexOf(" ")+1)).trim();
			}

			if (tmpVal.startsWith("$"))
			{
				if (newModeValue.equalsIgnoreCase("false"))//jmx
				{
					if (!aListJvmParam.contains(tmpVarLowerCase) && !aListCommonParams.contains(tmpVarLowerCase)) continue;
				}
				else//snmp
				{
					if (aListJvmParam.contains(tmpVarLowerCase) && !aListCommonParams.contains(tmpVarLowerCase)) continue;

					if (newSnmpVersion.equalsIgnoreCase("v1") || newSnmpVersion.equalsIgnoreCase("v2"))
					{
						if (aListJvmSnmpV3Param.contains(tmpVarLowerCase)) continue;
					}
					else//v3
					{
						if (aListJvmSnmpV1V2Param.contains(tmpVarLowerCase)) continue;
					}
				}

				if (newProfilerValue.equalsIgnoreCase("false") && tmpVarLowerCase.equalsIgnoreCase("profiler_home"))
					continue;

				if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
				{
					String tmpValLowerCase = tmpVal.toLowerCase();
					tmpValLowerCase = tmpValLowerCase.trim();
					if (aListEgKeyWords.contains(tmpValLowerCase))
					{
						newUnConPairs.put(tmpVar,tmpVal);
					}
				}
				else
				{
					newUnConPairs.put(tmpVar,tmpVal);
				}
			}
		}

		if (newUnConPairs.size() > 0)
		{
			stt = new StringTokenizer(oldStr,"-");
			while(stt.hasMoreTokens())
			{
				tmpStr = stt.nextToken().trim();
				if (tmpStr.length() > 0 && tmpStr.indexOf(" ") > -1)
				{
					tmpVar = (tmpStr.substring(0,tmpStr.indexOf(" "))).trim();
					tmpVarLowerCase = tmpVar.toLowerCase();
					if (tmpVarLowerCase.indexOf("password") > -1 || 
						tmpVarLowerCase.equals("authpass"))
					{
						continue;
					}
					tmpVal = (tmpStr.substring(tmpStr.indexOf(" ")+1)).trim();
				}
				

				if (tmpVal.startsWith("$"))
				{
					if (oldModeValue.equalsIgnoreCase("false"))//jmx
					{
						if (!aListJvmParam.contains(tmpVarLowerCase) && !aListCommonParams.contains(tmpVarLowerCase)) continue;
					}
					else//snmp
					{
						if (aListJvmParam.contains(tmpVarLowerCase) && !aListCommonParams.contains(tmpVarLowerCase)) continue;

						if (oldSnmpVersion.equalsIgnoreCase("v1") || oldSnmpVersion.equalsIgnoreCase("v2"))
						{
							if (aListJvmSnmpV3Param.contains(tmpVarLowerCase)) continue;
						}
						else//v3
						{
							if (aListJvmSnmpV1V2Param.contains(tmpVarLowerCase)) continue;
						}
					}

					if (oldProfilerValue.equalsIgnoreCase("false") && tmpVarLowerCase.equalsIgnoreCase("profiler_home"))
						continue;

					if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
					{
						String tmpValLowerCase = tmpVal.toLowerCase();
						tmpValLowerCase = tmpValLowerCase.trim();
						if (aListEgKeyWords.contains(tmpValLowerCase))
						{
							oldUnConPairs.put(tmpVar,tmpVal);
						}
					}
					else
					{
						oldUnConPairs.put(tmpVar,tmpVal);
					}
				}
			}

			Iterator it = newUnConPairs.keySet().iterator();
			while(it.hasNext())
			{
				Object key = it.next();
				String valNew =  (String)newUnConPairs.get(key);
				String valOld =  (String)oldUnConPairs.get(key);
				if (valNew.equals(valOld))
				{
					result =  "-auto, "+newStr;
					break;
				}
			}
		}

		return result;
	}

	private String doProperUpdateForSNMPComponent(String oldStr,String newStr,ArrayList aListSpecialCharacterAllowedParam,ArrayList aListEgKeyWords)
	{
		HashMap oldUnConPairs = new HashMap();
		HashMap newUnConPairs = new HashMap();
		String tmpStr = "";
		String tmpVar = "";
		String tmpVarLowerCase = "";
		String tmpVal = "";
		String result = newStr;

		oldStr = oldStr.substring(oldStr.indexOf(",")+1);
		newStr = newStr.substring(newStr.indexOf(",")+1);

		String oldStrLowerCase = oldStr.toLowerCase();
		String newStrLowerCase = newStr.toLowerCase();

		ArrayList aListSnmpV1V2Param = new ArrayList();
		aListSnmpV1V2Param.add("snmpcommunity");

		ArrayList aListSnmpV3Param = new ArrayList();
		aListSnmpV3Param.add("username");
		aListSnmpV3Param.add("authpass");
		aListSnmpV3Param.add("authtype");
		aListSnmpV3Param.add("encryptflag");
		aListSnmpV3Param.add("encrypttype");
		aListSnmpV3Param.add("encryptpassword");

		int tempIdx = newStrLowerCase.indexOf("-snmpversion")+1;
		String tempValue = newStr.substring(tempIdx);
		String newSnmpVersion = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
		newSnmpVersion = newSnmpVersion.trim();

		String oldSnmpVersion = "";
		if (!oldStr.equals(""))
		{
			tempIdx = oldStrLowerCase.indexOf("-snmpversion")+1;
			tempValue = oldStr.substring(tempIdx);
			oldSnmpVersion = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			oldSnmpVersion = oldSnmpVersion.trim();
		}

		StringTokenizer stt = new StringTokenizer(newStr,"-");
		while(stt.hasMoreTokens())
		{
			tmpStr = stt.nextToken().trim();
			if (tmpStr.length() > 0 && tmpStr.indexOf(" ") > -1)
			{
				tmpVar = (tmpStr.substring(0,tmpStr.indexOf(" "))).trim();
				tmpVarLowerCase = tmpVar.toLowerCase();
				if (tmpVarLowerCase.indexOf("password") > -1 || 
					tmpVarLowerCase.equals("authpass"))
				{
					continue;
				}
				tmpVal = (tmpStr.substring(tmpStr.indexOf(" ")+1)).trim();
			}

			if (tmpVal.startsWith("$"))
			{
				if (newSnmpVersion.equalsIgnoreCase("v3"))
				{
					if (aListSnmpV1V2Param.contains(tmpVarLowerCase)) continue;
				}
				else//v1,v2
				{
					if (aListSnmpV3Param.contains(tmpVarLowerCase)) continue;
				}

				if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
				{
					String tmpValLowerCase = tmpVal.toLowerCase();
					tmpValLowerCase = tmpValLowerCase.trim();
					if (aListEgKeyWords.contains(tmpValLowerCase))
					{
						newUnConPairs.put(tmpVar,tmpVal);
					}
				}
				else
				{
					newUnConPairs.put(tmpVar,tmpVal);
				}
			}
		}

		if (newUnConPairs.size() > 0)
		{
			stt = new StringTokenizer(oldStr,"-");
			while(stt.hasMoreTokens())
			{
				tmpStr = stt.nextToken().trim();
				if (tmpStr.length() > 0 && tmpStr.indexOf(" ") > -1)
				{
					tmpVar = (tmpStr.substring(0,tmpStr.indexOf(" "))).trim();
					tmpVarLowerCase = tmpVar.toLowerCase();
					if (tmpVarLowerCase.indexOf("password") > -1 || 
						tmpVarLowerCase.equals("authpass"))
					{
						continue;
					}
					tmpVal = (tmpStr.substring(tmpStr.indexOf(" ")+1)).trim();
				}

				if (tmpVal.startsWith("$"))
				{
					if (oldSnmpVersion.equalsIgnoreCase("v3"))
					{
						if (aListSnmpV1V2Param.contains(tmpVarLowerCase)) continue;
					}
					else //v1,v2
					{
						if (aListSnmpV3Param.contains(tmpVarLowerCase)) continue;
					}

					if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
					{
						String tmpValLowerCase = tmpVal.toLowerCase();
						tmpValLowerCase = tmpValLowerCase.trim();
						if (aListEgKeyWords.contains(tmpValLowerCase))
						{
							oldUnConPairs.put(tmpVar,tmpVal);
						}
					}
					else
					{
						oldUnConPairs.put(tmpVar,tmpVal);
					}
				}
			}

			Iterator it = newUnConPairs.keySet().iterator();
			while(it.hasNext())
			{
				Object key = it.next();
				String valNew =  (String)newUnConPairs.get(key);
				String valOld =  (String)oldUnConPairs.get(key);
				if (valNew.equals(valOld))
				{
					result =  "-auto, "+newStr;
					break;
				}
			}
		}

		return result;
	}
%>
