<%
/**********************************************************************************
*	Name			:	EgUploadMIB.jsp
*	Purpose			:	Upload the MIB file and Delete the MIb file.
*	Last Modified	:	May-23-2008
***********************************************************************************/
%>
<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.EgMibUtil" %>
<%@ page import="com.eg.UploadMIBFile" %>
<%@ page import="java.util.ArrayList" %>
<%@ page import="java.util.Collections" %>
<%@ page import="java.io.File"%>
<%@ taglib prefix = "egui" uri ="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>


<%
	session.setAttribute("egPageDesc","EgUploadMIB.jsp");
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
try
{
	File deleteFileObj = null;
	String dirPath = EgInstallInfo.getInstallDir()+"/.snmp";
	String deleteMIBFile = request.getParameter("deleteMIBFile");
	String deletedMIBFileNames[] = request.getParameterValues("MIBfiles");
	//out.println(deleteMIBFile);
	if(deleteMIBFile != null && deleteMIBFile.equals("true"))
	{
		if(deletedMIBFileNames!=null && deletedMIBFileNames.length > 0)
		{
			//out.println(Arrays.asList(deletedMIBFileNames));
			for(int j=0;j<deletedMIBFileNames.length;j++)
			{
				String del_file = deletedMIBFileNames[j].trim();
				deleteFileObj = new File(dirPath+"/"+del_file);
				if(deleteFileObj != null && deleteFileObj.exists())
					deleteFileObj.delete();
				if(EgInstallInfo.isClusterSupported)
				{
					UploadMIBFile uploadMib = new UploadMIBFile();
					uploadMib.deleteMIBFile(del_file);
				}
			}
		}
	}
	EgMibUtil.reload();
%>
<script language="JavaScript">
function valform()
{
	var thisForm = document.uploadMIB;
	if(thisForm.MIBfiles.options.selectedIndex == -1)
	{
		alert('<egui:intnl text="admin.mib.Please select the MIB file need to be deleted"/>')
	}
	else if(confirm('<egui:intnl text="admin.user.Are you sure you want to delete"/>'+'?'))
	{
		thisForm.deleteMIBFile.value = "true";
		thisForm.action="EgUploadMIB.jsp";
		thisForm.submit();
	}
}
function openWindow()
{
	var remoteWin = window.open("EgRemoteUpload.jsp?page=EgUploadMIB","DataWindow","width=400,height=150,left=100,top=300,screenX=250,screenY=200;scrollbars=no,scrollbars=0,resizable=no");
	remoteWin.focus();
}
function egTitleSearch()
{
	var thisForm = document.uploadMIB;
	var searchStr = thisForm.egTitleSearchStr.value;
	searchStr = searchStr.toLowerCase();
	var searchKeys = searchStr.split(' ');
	var emptyString = true;
	
	for (var i=0;i<searchKeys.length;i++)
	{
		if(searchKeys[i].length > 0)
			emptyString = false
	}

	if(searchStr == null || searchStr == "" || emptyString)
	{
		alert('<egui:intnl text="admin.user.Please enter a Search String"/>');
		thisForm.egTitleSearchStr.focus();
		return;
	}
	
	var len = thisForm.MIBfiles.options.length;
	var flag = true;
	for(var i=0;i<len;i++)
	{
		thisForm.MIBfiles.options[i].selected = false;
		value = thisForm.MIBfiles.options[i].value;
		value = value.toLowerCase();
		for (var j=0;j < searchKeys.length;j++)
		{
			var key = searchKeys[j];
			if (key.length  > 0)
			{
				if(value.indexOf(key) > -1)
				{
					thisForm.MIBfiles.options[i].selected = true;
					flag = false;
					break;
				}
			}
		}
	}
	if(flag)
	{
		alert('<egui:intnl text="admin.mib.No MIB files found for your search"/>');
		thisForm.egTitleSearchStr.focus();
		return;
	}
}
</script>

<html>
<head>
<title>Upload MIB Files</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<egui:skin ui = "admin"/>
</head>
<body style="overflow:auto" scroll="yes" id="space6" >
<form name="uploadMIB" method="get" style="margin:0px" action="javascript:egTitleSearch();">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" >
<%
	ArrayList fileNameList = new ArrayList();	
	File uploadMIBDir = new File(dirPath);
	if(uploadMIBDir.exists())
	{
		File uploadMIBFiles[] = uploadMIBDir.listFiles();
		if(uploadMIBFiles != null)
		{
			for(int i=0;i<uploadMIBFiles.length;i++)
			{
				File temp = (File)uploadMIBFiles[i];
				if(!temp.isDirectory())
				{
					String fileName = temp.getName();
					fileNameList.add(fileName);
				}
			}
		}
	}
	if(fileNameList.size() > 0)
	{
%>
		<jsp:include page="listSearch.jsp?title=Delete and Upload MIB Files&leftString=UploadMIBPage&searchBox=true"/>
<%
		Collections.sort(fileNameList,String.CASE_INSENSITIVE_ORDER);
%>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<table align="center" cellspacing="0" cellpadding="0" width="85%" border="0">
				<tr>
					<td colspan="5" width="100%" height="22">
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" id="eg_subcontentbg" height="22">
							<tr>
								<td id="subhead_left" width="7">
								<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
								<td width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
								<strong><egui:intnl text="admin.user.Select the MIB files to be deleted" /></strong>
								</td>
								<td id="subhead_right" width="7">
								<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td id="eg_subcontentbg"  width="100%" align="center" valign="top" colspan="3" class="eg_blankspace" height="10px">&nbsp;&nbsp;</td>
				</tr>
				<tr>
					<td id="eg_subcontentbg"  width="100%" align="center" valign="top" colspan="3" class="form_spacing">&nbsp;&nbsp;
					<select name="MIBfiles" multiple size="28" style="width:350px" >

<%
		for(int k=0;k<fileNameList.size();k++)
		{
			String fileName = (String)fileNameList.get(k);
%>
						<option name='<%="fileName"+k%>' value='<%=fileName%>'><%=fileName%></option>
<%
		}
%>
					</select>
					</td>
				</tr>
				<tr>
					<td id="eg_blankspace" height="10" nowrap colspan="3" class="eg_subcontentbg">&nbsp;</td>
				</tr>
				<tr>
					<td height="6" class="inner_bott_left" width="7" > <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" class="inner_bott_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>

				<tr>
					<td id="eg_blankspace" height="10" nowrap colspan="4">&nbsp;</td>
				</tr>
				<tr>
					<td width="100%" align="center" colspan="4">
					<input type="button" name="deleteuser" value='<egui:intnl text="admin.common.Delete" />' style="width: 80px;" class="eg_darkbutton" onClick="javascript:valform()" />
					</td>
				</tr>
				<input type='hidden' name='deleteMIBFile' value="false">
<%
	}
	else
	{
%>
				<jsp:include page="listSearch.jsp?title=Delete and Upload MIB Files&leftString=UploadMIBPage&searchBox=false"/>
				<tr>
					<td id="eg_whitebg" colspan="3" height="400">
						<table border="0" cellspacing="0" cellpadding="4" width="100%" >
							<tr> 
								<td width="100%" align="center">
								<img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif"><br>
								</td>
							</tr>
							<tr>
								<td width="100%" align="center" id="eg_errorsmall">
								<egui:intnl text="admin.mib.No MIB files available !"/>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
	}
%>

			</table>
		</td>
	</tr>
</table>
	</form>
</body>
</html>



<%
}
catch(Exception e)
{
	e.printStackTrace();
}
%>
<%
if(request.getQueryString()!=null)
	session.setAttribute("adminLastAccessedURL","/final/admin/EgUploadMIB.jsp?"+request.getQueryString());
	else session.setAttribute("adminLastAccessedURL","/final/admin/EgUploadMIB.jsp");
%>
