<%@ include file="../../EgTrackerAJSON.jsp" %>

<%@ page import = "java.io.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgCrypt"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.admin.ComponentAdd"%>
<%@ page import = "com.egurkha.admin.UserAssociateComponent"%>
<%@ page import = "egurkha.ServiceBean" %>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"  autoFlush="true"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	JSONObject rootJson = new JSONObject();

	UserRegistry ur = UserRegistry.getInstance();
	User user = ur.getUser(sessionID);
	String username = user.getLoginID();

	String compType = request.getParameter("compType");
	String hostname = request.getParameter("hostname");
	String hostip = request.getParameter("hostip");
	String port = request.getParameter("port");
	if (hostip == null || hostip.trim().length() == 0)
	{
		hostip = hostname;
	}
	String extAgent = request.getParameter("extAgent");

	rootJson.put("compTypeDisplay",_mapping.getComponentTypeDescription(compType));

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Discover/Monitor");
	/* code for auditlog ends */

	ComponentAdd addcomp = new ComponentAdd(username,_user.getUserIP(sessionID),sessionID);
	UserAssociateComponent addcomptouser = new UserAssociateComponent(username,_user.getUserIP(sessionID),sessionID);

	Hashtable compdata = new Hashtable();
	compdata.put("componenttype",compType);
	compdata.put("hostip",hostip);
	compdata.put("componentname",hostname);
	compdata.put("externalagent",extAgent);
	compdata.put("CompUserMapping","yes");
	compdata.put("uuiduser",username); 
	if (port != null && port.trim().length() > 0)
	{
		compdata.put("port",port);
	}
	String compStatus = addcomp.compValidation(compdata);

	if (compStatus != null && compStatus.equalsIgnoreCase("eG_CLI_0030"))
	{
		ServiceBean serbean = new ServiceBean();
		serbean.stopDiscovery();

		String compResult = addcomp.add(compdata);

		if (compResult != null && compResult.equalsIgnoreCase("eG_CLI_0030"))
		{
			/* code for auditlog starts */
			auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Module","Discover/Monitor");
			
			auditLogThread.setValue("Description","Component "+hostname + " of type " +"$ctype$:"+compType + " has been created");
			auditLogThread.setValue("Activity","Add Component");

			auditLogThread.setCurrentValue("01~~Component Type","$ctype$:"+compType);
			auditLogThread.setCurrentValue("02~~Nick Name",hostname);
			auditLogThread.setCurrentValue("External Agents",extAgent);
			auditLogThread.sendItToDB();
			/* code for auditlog ends */

			String compName = hostname + ":" + "NULL";

			Hashtable usercompdata = new Hashtable();
			usercompdata.put("userid",username);
			usercompdata.put("componenttype",compType);
			usercompdata.put("components",compName);
			String userCompStatus = addcomptouser.AssociateComponent(usercompdata);

			boolean autoCreateZoneForUser = EgUuidInfo.autoCreateZone();
			if (autoCreateZoneForUser && userCompStatus != null && userCompStatus.equalsIgnoreCase("eG_CLI_Res_0286"))
			{
				Hashtable argsMap = new Hashtable();
				argsMap.put("userid",username);
				argsMap.put("stype",compType);
				argsMap.put("compname",compName);
				Hashtable resultMap = addcomptouser.AutoAssociateComponentToZone(argsMap);

				//associate zones to user and for zone audit log
				if (resultMap != null && !resultMap.isEmpty())
				{
					IniFile mgrMiscIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini");
					String associatedUsers = "";
					String associaedZones = "", disAssociatedZones = "";
					Enumeration enMapKeys = resultMap.keys();
					while (enMapKeys.hasMoreElements())
					{
						String userName = (String)enMapKeys.nextElement();
						String zoneName = mgrMiscIni.getValue("Auto_Created_Zone_User_Map",userName);
						if (zoneName == null || zoneName.trim().length() == 0)
						{
							zoneName = userName;
						}
						String resultStr2 = (String)resultMap.get(userName);
						if (!resultStr2.startsWith("eG_CLI_Err"))
						{
							associaedZones += zoneName + ",";
							associatedUsers += userName + ",";
						}
						else
						{
							disAssociatedZones += zoneName + ",";
						}
					}
					String descMsg = "";
					AuditLogThread auditLogThread2 = new AuditLogThread();
					auditLogThread2.setValue("Category","Admin");
					auditLogThread2.setValue("User_id",_user.getLoginID());
					auditLogThread2.setValue("Host_ip",_user.getUserIP(session.getId()));
					auditLogThread2.setValue("Session_id",session.getId());
					auditLogThread2.setValue("Module","Zones");
					auditLogThread2.setValue("Activity","Auto Zone Configuration");
					if (associaedZones != null && associaedZones.length()>0)
					{
						associaedZones = associaedZones.substring(0,associaedZones.length()-1);
						associatedUsers = associatedUsers.substring(0,associatedUsers.length()-1);
						if (associaedZones.indexOf(",") > -1)
						{
							descMsg = "Zones "+ associaedZones +" have been added/modified and associated to the users "+associatedUsers+" successfully";
						}
						else
						{
							descMsg = "Zone "+ associaedZones +" has been added/modified and associated to the user "+associatedUsers+" successfully";
						}
					}
					if (disAssociatedZones != null && disAssociatedZones.length()>0)
					{
						disAssociatedZones = disAssociatedZones.substring(0,disAssociatedZones.length()-1);
						if (disAssociatedZones.indexOf(",") > -1)
						{
							descMsg += "Zones "+ disAssociatedZones +" have not been added/modified";
						}
						else
						{
							descMsg += "Zone "+ disAssociatedZones +" has not been added/modified";
						}
					}
					auditLogThread2.setValue("Description", descMsg);
					auditLogThread2.sendItToDB();
				}
			}
			
			String testConfigParamsEntry = "";
			if (compType.equalsIgnoreCase("Xchg_Logon_Emulation"))
			{
				String[] testConfigParams = {"Exchange_server_type","Exchange_site_url","Email_id","Email_password"};
				ArrayList testConfigParamsList = new ArrayList(Arrays.asList(testConfigParams));

				Enumeration ep = request.getParameterNames();
				while(ep.hasMoreElements())
				{
					String name = (String) ep.nextElement();
					String value = request.getParameter(name);

					if (name.equalsIgnoreCase("Email_password"))
					{
						value = StringUtils.decodeSecurityChar(value);
						value = EgCrypt.encrypt(value);
					}
					else
					{
						if (value.indexOf(" -") > -1)
						{
							if (!value.startsWith("\"") && !value.endsWith("\""))
							{
								value = "\"" + value + "\"";
							}
						}
					}

					if (testConfigParamsList.contains(name))
					{
						testConfigParamsEntry +=" -"+name+" "+value;
					}
				}
			}
			else if (compType.equalsIgnoreCase("Amazon_Logon_Emulation"))
			{
				String[] testConfigParams = {"Site_url","Published_resources","Registration_code","Username","Password","Domain"};
				ArrayList testConfigParamsList = new ArrayList(Arrays.asList(testConfigParams));

				Enumeration ep = request.getParameterNames();
				while(ep.hasMoreElements())
				{
					String name = (String) ep.nextElement();
					String value = request.getParameter(name);

					if (name.equalsIgnoreCase("Password") || name.equalsIgnoreCase("Registration_code"))
					{
						value = StringUtils.decodeSecurityChar(value);
						value = EgCrypt.encrypt(value);
					}
					else
					{
						if (value.indexOf(" -") > -1)
						{
							if (!value.startsWith("\"") && !value.endsWith("\""))
							{
								value = "\"" + value + "\"";
							}
						}
					}

					if (testConfigParamsList.contains(name))
					{
						testConfigParamsEntry +=" -"+name+" "+value;
					}
				}
			}
			else if (compType.equalsIgnoreCase("Hrzn_Web_Logon_Emulation"))
			{
				String[] testConfigParams = {"Site_url","Published_resources","User_id","Password","Two_factor_auth_password","Disclaimer"};
				ArrayList testConfigParamsList = new ArrayList(Arrays.asList(testConfigParams));

				Enumeration ep = request.getParameterNames();
				while(ep.hasMoreElements())
				{
					String name = (String) ep.nextElement();
					String value = request.getParameter(name);

					if (name.equalsIgnoreCase("Password") || name.equalsIgnoreCase("Two_factor_auth_password"))
					{
						value = StringUtils.decodeSecurityChar(value);
						value = EgCrypt.encrypt(value);
					}
					else
					{
						if (value.indexOf(" -") > -1)
						{
							if (!value.startsWith("\"") && !value.endsWith("\""))
							{
								value = "\"" + value + "\"";
							}
						}
					}

					if (testConfigParamsList.contains(name))
					{
						testConfigParamsEntry +=" -"+name+" "+value;
					}
				}
			}
			else if (compType.equalsIgnoreCase("WVD_Logon_Emulation"))
			{
				String[] testConfigParams = {"Site_url","Username","Password","Published_resources","Resource_username","Resource_password","Resource_domain","Two_factor_auth_password","Disclaimer"};
				ArrayList testConfigParamsList = new ArrayList(Arrays.asList(testConfigParams));
				
				Enumeration ep = request.getParameterNames();
				while(ep.hasMoreElements())
				{
					String name = (String) ep.nextElement();
					String value = request.getParameter(name);

					if (name.equalsIgnoreCase("Password") || name.equalsIgnoreCase("Two_factor_auth_password") || name.equalsIgnoreCase("Resource_password"))
					{
						value = StringUtils.decodeSecurityChar(value);
						value = EgCrypt.encrypt(value);
					}
					else
					{
						if (value.indexOf(" -") > -1)
						{
							if (!value.startsWith("\"") && !value.endsWith("\""))
							{
								value = "\"" + value + "\"";
							}
						}
					}

					if (testConfigParamsList.contains(name))
					{
						testConfigParamsEntry +=" -"+name+" "+value;
					}
				}
			}
			else if (compType.equalsIgnoreCase("AppStream_Simulator"))
			{
				String[] testConfigParams = {"Site_url","Username","Password","Published_resources","Domain"};
				ArrayList testConfigParamsList = new ArrayList(Arrays.asList(testConfigParams));
				
				Enumeration ep = request.getParameterNames();
				while(ep.hasMoreElements())
				{
					String name = (String) ep.nextElement();
					String value = request.getParameter(name);

					if (name.equalsIgnoreCase("Password"))
					{
						value = StringUtils.decodeSecurityChar(value);
						value = EgCrypt.encrypt(value);
					}
					else
					{
						if (value.indexOf(" -") > -1)
						{
							if (!value.startsWith("\"") && !value.endsWith("\""))
							{
								value = "\"" + value + "\"";
							}
						}
					}

					if (testConfigParamsList.contains(name))
					{
						testConfigParamsEntry +=" -"+name+" "+value;
					}
				}
			}
			else
			{
				String[] testConfigParams = {"Site_url","Published_resources","Username","Password","Domain","Two_factor_auth_password","Disclaimer"};
				ArrayList testConfigParamsList = new ArrayList(Arrays.asList(testConfigParams));
				if (compType.equalsIgnoreCase("Citrix_XcLogon_Emulation"))
				{
					testConfigParamsList.add("Citrix_cloud_workspace");
				}
				
				Enumeration ep = request.getParameterNames();
				while(ep.hasMoreElements())
				{
					String name = (String) ep.nextElement();
					String value = request.getParameter(name);

					if (name.equalsIgnoreCase("Password") || name.equalsIgnoreCase("Two_factor_auth_password"))
					{
						value = StringUtils.decodeSecurityChar(value);
						value = EgCrypt.encrypt(value);
					}
					else
					{
						if (value.indexOf(" -") > -1)
						{
							if (!value.startsWith("\"") && !value.endsWith("\""))
							{
								value = "\"" + value + "\"";
							}
						}
					}

					if (testConfigParamsList.contains(name))
					{
						testConfigParamsEntry +=" -"+name+" "+value;
					}
				}
			}

			IniFile discoverParamObj = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_discoveryParams.ini");
			String key = compType+":"+hostname ;
			if (port != null && port.trim().length() > 0)
			{
				key += ":"+port;
			}
			else
			{
				key += ":NULL";
			}
			discoverParamObj.setValue(compType,key,testConfigParamsEntry);
			discoverParamObj.saveFile();
			EgConfigFilesSync.releaseInstance(discoverParamObj);

			rootJson.put("success","true");
		}
		else if (compResult.equalsIgnoreCase("eG_CLI_Err_0344"))
		{
			rootJson.put("errorMsg","The component could not be created. You are exceeding the total monitors permitted for the User. Please contact the eG administrator.");
			rootJson.put("success","false");
		}
		else if (compResult.equalsIgnoreCase("eG_CLI_Err_0345"))
		{
			rootJson.put("errorMsg","The component could not be created. You are exceeding the premium monitors permitted for the User. Please contact the eG administrator.");
			rootJson.put("success","false");
		}
		else if (compResult.equalsIgnoreCase("eG_CLI_Err_0346"))
		{
			rootJson.put("errorMsg","The component could not be created. You are exceeding the network devices permitted for the User. Please contact the eG administrator.");
			rootJson.put("success","false");
		}
		else if (compResult.equalsIgnoreCase("eG_CLI_Err_0347"))
		{
			rootJson.put("errorMsg","The component could not be created. You are exceeding the named/concurrent users/machines permitted for the User. Please contact the eG administrator.");
			rootJson.put("success","false");
		}
		else
		{
			rootJson.put("success","false");
			rootJson.put("errorMsg","The component could not be created. Please contact the eG administrator.");
		}
		serbean.startDiscovery("1",true);
	}
	else if (compStatus.equalsIgnoreCase("eG_CLI_0014"))
	{
		rootJson.put("errorMsg","The component could not be created. The nick name you are trying to add already exists. Please use another nick name");
		rootJson.put("success","false");
	}
	else if (compStatus.equalsIgnoreCase("eG_CLI_0015"))
	{
		rootJson.put("errorMsg","The component could not be created. The nick name you are trying to add already exists in some other case. As the nick name is case insensitive, please use the old nick name.");
		rootJson.put("success","false");
	}
	else if (compStatus.equalsIgnoreCase("eG_CLI_0036"))
	{
		rootJson.put("errorMsg","The component could not be created. You are exceeding the total number of applications permitted by your license. Please contact the eG administrator.");
		rootJson.put("success","false");
	}
	else if (compStatus.equalsIgnoreCase("eG_CLI_0035"))
	{
		rootJson.put("errorMsg","The component could not be created. You are exceeding the total number of agents permitted by your license. Please contact the eG administrator.");
		rootJson.put("success","false");
	}
	else if (compStatus.equalsIgnoreCase("eG_CLI_Err_0336"))
	{
		rootJson.put("errorMsg","The component could not be created. You are exceeding the number of Total/Basic license. Please contact the eG administrator.");
		rootJson.put("success","false");
	}
	else if (compStatus.equalsIgnoreCase("eG_CLI_Err_0337"))
	{
		rootJson.put("errorMsg","The component could not be created. You are exceeding the number of Premium license. Please contact the eG administrator.");
		rootJson.put("success","false");
	}
	else if (compStatus.equalsIgnoreCase("eG_CLI_Err_0338"))
	{
		rootJson.put("errorMsg","The component could not be created. You are exceeding the number of User based license for named user/machines. Please contact the eG administrator.");
		rootJson.put("success","false");
	}
	else if (compStatus.equalsIgnoreCase("eG_CLI_Err_0339"))
	{
		rootJson.put("errorMsg","The component could not be created. You are exceeding the number of User based license for concurrent user/machines. Please contact the eG administrator.");
		rootJson.put("success","false");
	}

	out.println(rootJson.toString());
%>



