<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="org.json.simple.*"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="java.io.*"%>
<%@ page import="java.util.*"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%
	JSONObject rootJson = new JSONObject();
	JSONArray jsonArr = new JSONArray();
	String[] installMethodArr = new String[]{"Command Line (One-liner)","ZIP/TAR Package"};
	String[] vmTypeDispArr = new String[]{"Manager","Remote Agent"};
	String[] vmTypeValArr = new String[]{"mgr","rmta"};
	
	String agentType = request.getParameter("agentType");
	if (StringUtils.isNull(agentType))
	{
		agentType = "VM";
	}
	
	String osType = request.getParameter("osType");
	if (StringUtils.isNull(osType))
	{
		osType = "vm";
	}
	
	String installMethod = request.getParameter("installMethod");
	
	String vmType = request.getParameter("vmType");
	if (StringUtils.isNull(vmType))
	{
		vmType = "mgr";
	}
	
	String folderNameStr = "VM";
	
	String versionName = request.getParameter("agentVersion");
	if (StringUtils.isNull(versionName))
	{
		versionName = "Latest";
	}
	
	IniFile mgrIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini");
	String enableOneLinerCommand = mgrIni.getValue("MISC_ARGS","enableOneLinerCommand");
	if (StringUtils.isNull(enableOneLinerCommand))
	{
		enableOneLinerCommand = "true";
	}
	
	JSONArray installArr = new JSONArray();
	for (int x=0; x<installMethodArr.length; x++)
	{
		String installStr = installMethodArr[x];
		if (enableOneLinerCommand.equalsIgnoreCase("false") && installStr.equals("Command Line (One-liner)"))
		{
			continue;
		}
		
		if (vmType.equals("rmta") && installStr.equals("Command Line (One-liner)"))
		{
			continue;
		}
		
		JSONObject installObj = new JSONObject();
		installObj.put("displayField",installStr);
		installObj.put("valueField",installStr);
		if (!StringUtils.isNull(installMethod) && installMethod.equalsIgnoreCase(installStr))
		{
			rootJson.put("selectedInstallMethods",installMethod);
		}
		installArr.add(installObj);
	}
	rootJson.put("installMethods",installArr);
	
	JSONArray vmTypeArr = new JSONArray();
	for (int x=0; x<vmTypeDispArr.length; x++)
	{
		String vmTypeDisp = vmTypeDispArr[x];
		String vmTypeVal = vmTypeValArr[x];
		
		if (installMethod.equals("Command Line") && vmTypeVal.equals("rmta"))
		{
			continue;
		}
		
		JSONObject vmTypeObj = new JSONObject();
		vmTypeObj.put("displayField",vmTypeDisp);
		vmTypeObj.put("valueField",vmTypeVal);
		if (!StringUtils.isNull(vmType) && vmType.equalsIgnoreCase(vmTypeVal))
		{
			rootJson.put("selectedVMType",vmType);
		}
		vmTypeArr.add(vmTypeObj);
	}
	rootJson.put("vmTypes",vmTypeArr);
	
	String sep = System.getProperty("file.separator");
	
	String selectedOSType = "";
	ArrayList osTypeList = new ArrayList();
	JSONArray osArr = new JSONArray();
	
	File folderStr = new File(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"agents"+sep+folderNameStr+sep+versionName);
	File[] fileList = folderStr.listFiles();
	
	if (fileList != null && fileList.length > 0)
	{
		for (int k = 0; k < fileList.length; k++)
		{
			String osNameStr = fileList[k].getName();
			if (osNameStr.endsWith(".tar.gz"))
			{
				if (osTypeList !=null && !osTypeList.contains("lvm"))
				{
					osTypeList.add("lvm");
					JSONObject osObj = new JSONObject();
					osObj.put("displayField","Linux");
					osObj.put("valueField","lvm");
					if (!StringUtils.isNull(osType) && osType.equalsIgnoreCase("lvm"))
					{
						selectedOSType = osType;
						rootJson.put("selectedOSType",osType);
					}
					osArr.add(osObj);
				}
			}
			else if (osNameStr.endsWith(".zip"))
			{
				if (osTypeList !=null && !osTypeList.contains("vm"))
				{
					osTypeList.add("vm");
					JSONObject osObj = new JSONObject();
					osObj.put("displayField","Windows");
					osObj.put("valueField","vm");
					if (!StringUtils.isNull(osType) && osType.equalsIgnoreCase("vm"))
					{
						selectedOSType = osType;
						rootJson.put("selectedOSType",osType);
					}
					osArr.add(osObj);
				}
			}
		}
	}
	rootJson.put("osTypes",osArr);

	if (osArr != null && !osArr.isEmpty() && StringUtils.isNull(selectedOSType))
	{
		JSONObject jsonObject = (JSONObject) osArr.get(0);
		osType = (String)jsonObject.get("valueField");
		rootJson.put("selectedOSType",osType);
	}
	rootJson.put("selectedAgentVersion",versionName);
	
	ArrayList finalAgentList = new ArrayList();
	if(osType != null)
	{
		String agentNames = mgrIni.getValue("OS_AGENT_MAPPING",osType.toLowerCase());
		if (agentNames != null && agentNames.trim().length() > 0)
		{
			if (agentNames.indexOf(",") != -1)
			{
				ArrayList valueList = new ArrayList(Arrays.asList(StringUtils.getTokens(agentNames,",")));
				finalAgentList.addAll(valueList);
			}
			else
			{
				finalAgentList.add(agentNames);
			}
		}
	}
	
	ArrayList unixList = new ArrayList();
	ArrayList winList = new ArrayList();
	String unix [] = mgrIni.getVariables("UNIX_AGENT_FOLDER_NAMES");
	String win [] = mgrIni.getVariables("WINDOWS_AGENT_FOLDER_NAMES");

	if (finalAgentList != null && finalAgentList.size() > 0)
	{
		if (unix != null && unix.length > 0)
		{
			for (int i=0;i<unix.length;i++)
			{
				String unixAgent = unix[i];
				if (finalAgentList.contains(unixAgent))
				{
					unixList.add(unixAgent);
				}
			}
		}
		if (win != null && win.length > 0)
		{
			for (int i=0;i<win.length;i++)
			{
				String winAgent = win[i];
				if (finalAgentList.contains(winAgent))
				{
					winList.add(winAgent);
				}
			}
		}
	}
	
	ArrayList versionList = new ArrayList();
	String ShowVersionSpecificAgents = mgrIni.getValue("MISC_ARGS","ShowVersionSpecificAgents");
	if (!StringUtils.isNull(ShowVersionSpecificAgents) && ShowVersionSpecificAgents.equalsIgnoreCase("true"))
	{
		File folder = new File(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"agents"+sep+folderNameStr);
		File[] listOfFiles = folder.listFiles();
		
		if (listOfFiles != null && listOfFiles.length > 0)
		{
			for (int k = 0; k < listOfFiles.length; k++)
			{
				JSONObject jsonObj = new JSONObject();
				String dirName = listOfFiles[k].getName();
				File folderStr1 = new File(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"agents"+sep+folderNameStr+sep+dirName);
				File[] fileArr = folderStr1.listFiles();
				if (fileArr != null && fileArr.length > 0)
				{
					for (int l = 0; l < fileArr.length; l++)
					{
						String agentName = fileArr[l].getName();
						if (agentName.equalsIgnoreCase("SilentScripts"))
						{
							continue;
						}
						
						if (!versionList.contains(dirName))
						{
							versionList.add(dirName);
						}
					}
				}
			}
		}
	}

	versionList = com.egurkha.util.ListUtils.removeDuplicates(versionList,1);
	Collections.reverse(versionList);

	JSONArray verArr = new JSONArray();
	JSONObject verObj = new JSONObject();
	if(versionList != null)
	{
		for (int i=0;i<versionList.size();i++)
		{
			String versionFolder = (String) versionList.get(i);
			verObj = new JSONObject();
			verObj.put("displayField",versionFolder);
			verObj.put("valueField",versionFolder);
			verArr.add(verObj);
		}
	}
	rootJson.put("agentVersion",verArr);
	
	if (!StringUtils.isNull(installMethod) && installMethod.equalsIgnoreCase("ZIP/TAR Package"))
	{
		File folder = new File(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"agents"+sep+folderNameStr+sep+versionName);
		File[] listOfFiles = folder.listFiles();
		
		String vmPack = "";
		if (listOfFiles != null && listOfFiles.length > 0)
		{
			for (int k = 0; k < listOfFiles.length; k++)
			{
				JSONObject jsonObj = new JSONObject();
				String dirName = listOfFiles[k].getName();
				String imageName = mgrIni.getValue("AGENT_IMAGE_CLASS",dirName);
				if (winList.contains(dirName))
				{
					String displayName = mgrIni.getValue("WINDOWS_AGENT_FOLDER_NAMES",dirName);
					if (displayName == null || displayName.length() <= 0)
					{
						displayName = dirName;
					}
					jsonObj.put("displayField",displayName);
					jsonObj.put("valueField",dirName);
					jsonObj.put("className",imageName);
					jsonObj.put("folder",folderNameStr);
					jsonObj.put("agentVersion",versionName);
					jsonObj.put("category","Windows");

					if (dirName.indexOf("x64")!= -1)
					{
						jsonObj.put("bit","64-bit");
					}
					else
					{
						jsonObj.put("bit","32-bit");
					}

					String version = mgrIni.getValue("WINDOWS_AGENT_VERSION",displayName);
					if (version != null && version.length() > 0)
					{
						jsonObj.put("version",version);
					}
					else
					{
						jsonObj.put("version",displayName);
					}

					jsonArr.add(jsonObj);
				
				}
				else if (unixList.contains(dirName))
				{
					String displayName = mgrIni.getValue("UNIX_AGENT_FOLDER_NAMES",dirName);
					if (displayName == null || displayName.length() <= 0)
					{
						displayName = dirName;
					}
					jsonObj.put("displayField",displayName);
					jsonObj.put("valueField",dirName);
					jsonObj.put("className",imageName);
					jsonObj.put("folder",folderNameStr);
					jsonObj.put("agentVersion",versionName);
					jsonObj.put("category","Unix");

					if (dirName.indexOf("Linux") != -1)
					{
						if (dirName.indexOf("x64") != -1 || dirName.indexOf("ppc") != -1)
						{
							jsonObj.put("bit","64-bit");
						}
						else
						{
							jsonObj.put("bit","32-bit");
						}
					}
					
					String packName = dirName.substring(0,dirName.indexOf("."));
							
					if (dirName.startsWith("VmAgent_Linux"))
					{
						vmPack += ", eG"+packName;
					}

					jsonObj.put("version",displayName);

					jsonArr.add(jsonObj);
				}
			}
		}
		
		if (osType.equalsIgnoreCase("lvm"))
		{
			if (!StringUtils.isNull(vmPack))
			{
				vmPack = vmPack.substring(2);
			}
			rootJson.put("lvm",vmPack);
		}
		rootJson.put("listOfOS",jsonArr);
	}
	else
	{
		String osVersion = request.getParameter("osVersion");
		String compName = request.getParameter("compName");
		if (StringUtils.isNull(osVersion))
		{
			if (osType.equalsIgnoreCase("vm"))
			{
				osVersion = "vm_64";
			}
			else if (osType.equalsIgnoreCase("lvm"))
			{
				osVersion = "lvm_64";
			}
		}
		String selectedOSVersion = "";
		JSONArray osVerArr = new JSONArray();
		
		File folder = new File(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"agents"+sep+folderNameStr+sep+versionName);
		File[] listOfFiles = folder.listFiles();
		if (listOfFiles != null && listOfFiles.length > 0)
		{
			for (int k = 0; k < listOfFiles.length; k++)
			{
				JSONObject jsonObj = new JSONObject();
				String displayNameStr = "";
				String dirName = listOfFiles[k].getName();
				if (winList.contains(dirName))
				{
					String displayName = mgrIni.getValue("WINDOWS_AGENT_FOLDER_NAMES",dirName);
					if (displayName == null || displayName.length() <= 0)
					{
						displayName = dirName;
					}

					if (dirName.indexOf("x64")!= -1)
					{
						displayNameStr = displayName+" (64-bit)";
					}
					else
					{
						displayNameStr = displayName+" (32-bit)";
					}
					String osValField = mgrIni.getValue("All_OS_Version",displayNameStr.trim());
					jsonObj.put("displayField",displayNameStr);
					jsonObj.put("valueField",osValField);
					if (!StringUtils.isNull(osVersion) && osValField.equalsIgnoreCase(osVersion))
					{
						rootJson.put("selectedOSVersion",osVersion);
						selectedOSVersion = osVersion;
					}
					osVerArr.add(jsonObj);
				}
				else if (unixList.contains(dirName))
				{
					String displayName = mgrIni.getValue("UNIX_AGENT_FOLDER_NAMES",dirName);
					if (displayName == null || displayName.length() <= 0)
					{
						displayName = dirName;
					}

					if (dirName.indexOf("Linux") != -1)
					{
						if (dirName.indexOf("x64") != -1 || dirName.indexOf("ppc") != -1)
						{
							displayNameStr = displayName+" (64-bit)";
						}
						else
						{
							displayNameStr = displayName+" (32-bit)";
						}
					}
					String osValField = mgrIni.getValue("All_OS_Version",displayNameStr);
					jsonObj.put("displayField",displayNameStr);
					jsonObj.put("valueField",osValField);
					if (!StringUtils.isNull(osVersion) && osValField.equalsIgnoreCase(osVersion))
					{
						rootJson.put("selectedOSVersion",osVersion);
						selectedOSVersion = osVersion;
					}
					osVerArr.add(jsonObj);
				}
			}
		}

		StringBuffer cmdBuff = new StringBuffer();
		String installCmd = "";
		String installCmdAI = "";
		if (osVerArr != null && !osVerArr.isEmpty())
		{
			if (StringUtils.isNull(selectedOSVersion))
			{
				JSONObject jsonObject = (JSONObject) osVerArr.get(0);
				osVersion = (String)jsonObject.get("valueField");
				rootJson.put("selectedOSVersion",osVersion);
			}
			
			if (osVersion.equalsIgnoreCase("hpux_os"))
			{
				osVersion = osVersion.substring(0,osVersion.indexOf("_"));
			}
			
			IniFile egSerIni =  new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_services.ini");
			String mgrUrl = egSerIni.getValue("MISC_ARGS","MailHomeUrl");
			String mgrReferrer = mgrIni.getValue("AGT_DLD_DEF_PARAMS","rf");
			String userName = _user.getLoginID();
			String akValue = "";
			String atValue = "";
			String dwdFileName = "";
			if (StringUtils.isNull(agentType))
			{
				atValue = "va";
				dwdFileName = "eG_VMAgent_Installer";
			}
			else
			{
				atValue = "va";
				dwdFileName = "eG_VMAgent_Installer";
			}

			String avValue ="";
			if (versionName.equalsIgnoreCase("7.1.4"))
			{
				avValue = "714";
			}
			else if (versionName.equalsIgnoreCase("7.1.2"))
			{
				avValue = "712";
			}
			else
			{
				avValue = "lat";
			}
			
			String giValue ="n";
			String ceValue ="n";

			if (osType.equalsIgnoreCase("VM"))
			{
				cmdBuff.append("cd /; mkdir -Force eGVMMAgent; cd eGVMMAgent; Remove-Item ./* -Force; ");
				
				cmdBuff.append("Invoke-WebRequest -Uri \"");
				cmdBuff.append(mgrUrl+"/final/ega?");
				cmdBuff.append("rf="+mgrReferrer);
				cmdBuff.append("&gp="+EgCrypt.encrypt(userName));

				String bitStr = "";
				int idx = osVersion.indexOf("_");
				if (idx != -1)
				{
					String osStr = osVersion.substring(0,idx);
					akValue = akValue+"os="+osStr;
					String bit = osVersion.substring(idx+1);
					osVersion=osStr;
					if (bit.equals("32"))
					{
						bitStr = "";
						akValue = akValue+"&bt=32";
					}
					else
					{
						bitStr = "_x64";
					}
				}
				else
				{
					bitStr = "_x64";
					akValue = akValue+"os="+osVersion;
				}
				akValue = akValue+"&at="+atValue;
				akValue = akValue+"&gi="+giValue;
				akValue = akValue+"&ce="+ceValue;
				akValue = akValue+"&av="+avValue;
				akValue = akValue+"&nn="+compName;
				akValue = akValue+"&vt=mgr";
				cmdBuff.append("&ak="+EgCrypt.encrypt(akValue));
				
				String fileName = "eGVmAgent"+bitStr+".zip";
				cmdBuff.append("\" -OutFile .\\"+fileName);
				installCmd = "; Expand-Archive -Path "+fileName+" -DestinationPath .; .\\setup.bat";
			}
			else
			{
				String fileNameStr = "";
				String bitStr = "";
				String osStr = "";
				String bit = "";
				
				int idx = osVersion.indexOf("_");
				if (idx != -1)
				{
					osStr = osVersion.substring(0,idx);
					bit = osVersion.substring(idx+1);
					osVersion=osStr;
					if (bit.equals("32"))
					{
						bitStr = "";
						bit = "32";
					}
					else
					{
						bit = "";
						bitStr = "_x64";
					}
				}
				else
				{
					osStr = osVersion;
					bitStr = "_x64";
					bit = "";
				}
				
				fileNameStr = "eGVmAgent_Linux"+bitStr+".tar.gz";
					
				cmdBuff.append("cd / && mkdir -p eGVMAgent && cd eGVMAgent && rm -f ./* && ");
				cmdBuff.append("curl -o "+fileNameStr+" \"");
				cmdBuff.append(mgrUrl+"/final/ega?");
				cmdBuff.append("rf="+mgrReferrer);
				cmdBuff.append("&gp="+EgCrypt.encrypt(userName));
				akValue = akValue+"os="+osStr;
				if (!StringUtils.isNull(bit))
				{
					akValue = akValue+"&bt="+bit;
				}
				akValue = akValue+"&at="+atValue;
				akValue = akValue+"&gi="+giValue;
				akValue = akValue+"&ce="+ceValue;
				akValue = akValue+"&av="+avValue;
				akValue = akValue+"&nn="+compName;
				akValue = akValue+"&vt=mgr";
				cmdBuff.append("&ak="+EgCrypt.encrypt(akValue));
				cmdBuff.append("\"");
				String fileNameTar = fileNameStr.substring(0,fileNameStr.indexOf(".gz"));
				installCmd = " && chmod 750 "+fileNameStr+" && gunzip "+fileNameStr+" && tar -xvf "+fileNameTar+" && chmod 750 ./setup.sh && ./setup.sh";
			}
		}
		String downloadUrlStr = cmdBuff.toString();
		if (downloadUrlStr.indexOf("curl ") != -1)
		{
			String wgetDwdUrlStr = downloadUrlStr.replace("curl -o ","wget -O ");
			rootJson.put("wgetDownloadUrlStr",wgetDwdUrlStr+installCmd);
		}
		
		rootJson.put("downloadUrlStr",downloadUrlStr+installCmd);
		rootJson.put("osVersions",osVerArr);
	}
	out.println(rootJson);
%>



