<%
/**
 *	File		:	EgMailServerSettingspJson.jsp
 *	Purpose 	:	Enables the administrator to configure eG's mail settings process page.
 */
%>

<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.EgCrypt" %>
<%@ page import = "com.eg.EgMemInfo" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.eg.UpdateAndTransmitUserInfo"%>
<%@ page import = "net.sf.json.*"%>

<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	JSONObject rootJson = new JSONObject();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
%>
<%
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Mail Settings");
	auditLogThread.setValue("Activity","Mail Configuration");
	Enumeration en = request.getParameterNames();
	while(en.hasMoreElements())
	{
		String name = ((String) en.nextElement()).toString().trim();
		String mailFormat = "";
		if(name.equals("$_password") || name.equals("$_MailReceiverPasswd"))
			continue;
		if(name != null && !name.equalsIgnoreCase("null") && name.length()>0 && name.startsWith("$_"))
		{
			String value = request.getParameter(name);
			value = egurkha.EgUIUtils.decodeSecurityChar(value);

			if(value != null && !value.equalsIgnoreCase("null") && value.length()>0 && value.indexOf("$") !=-1)
			{
				String label = null;
				String labelValue = null;
				StringTokenizer stokens = new StringTokenizer(value,"$");
				if(stokens.countTokens()==2)
				{
					label = stokens.nextToken().toString();
					labelValue = stokens.nextToken();
				}
				else
				{
					label = stokens.nextToken();
					labelValue = "";
				}
				if(label != null && labelValue != null && !labelValue.equalsIgnoreCase("null") && labelValue.trim().length()>0)
				{
					String val = labelValue.startsWith("_")?labelValue.substring(1):labelValue;
					if(val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes"))
						val = "Yes";
					else if(val.equalsIgnoreCase("false") || val.equalsIgnoreCase("no"))
						val = "No";
					auditLogThread.setPreviousValue(label, val);
				}
				String currentValue = request.getParameter(name.substring(2));
				currentValue = egurkha.EgUIUtils.decodeSecurityChar(currentValue);

				if(currentValue == null || currentValue.equalsIgnoreCase("null") && currentValue.trim().length()==0)
					continue;
				currentValue = currentValue.trim();
				if(currentValue.length()>0)
				{
					if(currentValue.equalsIgnoreCase("true") || currentValue.equalsIgnoreCase("yes"))
						currentValue = "Yes";
					else if(currentValue.equalsIgnoreCase("false") || currentValue.equalsIgnoreCase("no"))
						currentValue = "No";
					auditLogThread.setCurrentValue(label, currentValue);
				}
			}
		}
	}
	String currentPassword = request.getParameter("authpassword");
	currentPassword = egurkha.EgUIUtils.decodeSecurityChar(currentPassword);

	String previousPassword = request.getParameter("$_password");
	previousPassword = egurkha.EgUIUtils.decodeSecurityChar(previousPassword);

	if(currentPassword != null && previousPassword != null && previousPassword.indexOf("$")!=-1)
	{
		String label = previousPassword.substring(0,previousPassword.indexOf("$"));
		previousPassword = previousPassword.substring(previousPassword.indexOf("$")+1);

		if(previousPassword.length() == 0 && currentPassword.length()>0)
		{
			auditLogThread.setCurrentValue(label,"******");
		}
		else if(!previousPassword.equals(currentPassword))
		{
			auditLogThread.setPreviousValue(label,"*****");
			auditLogThread.setCurrentValue(label,"******");
		}
	}
	
	String curReceiverPwd = request.getParameter("MailReceiverPasswd");
	curReceiverPwd = egurkha.EgUIUtils.decodeSecurityChar(curReceiverPwd);

	String preReceivePwd = request.getParameter("$_MailReceiverPasswd");
	preReceivePwd = egurkha.EgUIUtils.decodeSecurityChar(preReceivePwd);

	if(curReceiverPwd != null && preReceivePwd != null && preReceivePwd.indexOf("$")!=-1)
	{
		String label = preReceivePwd.substring(0,preReceivePwd.indexOf("$"));
		preReceivePwd = preReceivePwd.substring(preReceivePwd.indexOf("$")+1);

		if(preReceivePwd.length() == 0 && curReceiverPwd.length()>0)
		{
			auditLogThread.setCurrentValue(label,"******");
		}
		else if(!preReceivePwd.equals(curReceiverPwd))
		{
			auditLogThread.setPreviousValue(label,"*****");
			auditLogThread.setCurrentValue(label,"******");
		}
	}
	auditLogThread.setValue("Description","Mail settings have been configured");
	auditLogThread.sendItToDB();
	/* code for auditlog ends */
%>


<%!
	String licenseCheck = "me";
	String subject = "MISC_ARGS";
	String strHost = "";
	String strPort = "";
	String strProtocol = "";
	String strSender = "";
	String strmSub = "";
	String strsSub ="";
%>

<%
	UpdateAndTransmitUserInfo updateAndTransmitUserInfo =   new UpdateAndTransmitUserInfo();
	strHost = request.getParameter("mailhost");
	strHost = egurkha.EgUIUtils.decodeSecurityChar(strHost);

	strPort = request.getParameter("mailport");
	strPort = egurkha.EgUIUtils.decodeSecurityChar(strPort);

	strProtocol = request.getParameter("mailprotocol");
	strProtocol = egurkha.EgUIUtils.decodeSecurityChar(strProtocol);

	strSender = request.getParameter("mailsender");
	strSender = egurkha.EgUIUtils.decodeSecurityChar(strSender);

	String mailSenders = request.getParameter("mailsenders");
	mailSenders = egurkha.EgUIUtils.decodeSecurityChar(mailSenders);

	IniFile mailconfig = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini",true);
	String autheticationType = request.getParameter("autheticationType");
	autheticationType = egurkha.EgUIUtils.decodeSecurityChar(autheticationType);

	autheticationType = (autheticationType !=null && autheticationType.trim().length()>0)?autheticationType.trim():"";
	String clearSet = request.getParameter("clearSet");
	clearSet = egurkha.EgUIUtils.decodeSecurityChar(clearSet);

	if (clearSet == null)
		clearSet = "";
	String oAuthSubject = "OAUTH2_DETAILS";
	mailconfig.setValue(oAuthSubject,"AuthenticationType", autheticationType);
	if(autheticationType.equalsIgnoreCase("Basic")){
		//Raji
		String finalVal = "";
		ArrayList alternateMailList = new ArrayList();
		StringTokenizer alterMailStr = new StringTokenizer(mailSenders);
		while(alterMailStr.hasMoreTokens())
		{
			String mailToken = alterMailStr.nextToken();
			alternateMailList.add(mailToken);
		}
		String[] mailIDsIni =  mailconfig.getVariables("MAIL_SENDERS");
		//Raji
		String mailRevSetting=request.getParameter("revSetConfig");
		mailRevSetting = egurkha.EgUIUtils.decodeSecurityChar(mailRevSetting);

		String mailReceiverId=request.getParameter("MailReceiver");
		mailReceiverId = egurkha.EgUIUtils.decodeSecurityChar(mailReceiverId);

		String mailReceiverPasswd=request.getParameter("MailReceiverPasswd");
		mailReceiverPasswd = egurkha.EgUIUtils.decodeSecurityChar(mailReceiverPasswd);

		String mailRcvPort=request.getParameter("MailRcvPort");
		mailRcvPort = egurkha.EgUIUtils.decodeSecurityChar(mailRcvPort);

		String mailRcvProtocol=request.getParameter("MailRcvProtocol");
		mailRcvProtocol = egurkha.EgUIUtils.decodeSecurityChar(mailRcvProtocol);

		String mailRcvServer=request.getParameter("MailRcvServer");
		mailRcvServer = egurkha.EgUIUtils.decodeSecurityChar(mailRcvServer);

		mailconfig.setValue(subject,"MailHost", strHost);
		mailconfig.setValue(subject,"MailPort", strPort);
		mailconfig.setValue(subject,"MailHostProtocol", strProtocol);
		mailconfig.setValue(subject,"MailSender", strSender);
		mailconfig.setValue(subject,"receiverSettingConfig", mailRevSetting);
		if(mailRevSetting != null && mailRevSetting.equalsIgnoreCase("false"))
		{
			mailReceiverId = "";
			mailReceiverPasswd = "";
			mailRcvServer = "";
		}
		mailconfig.setValue(subject,"MailReceiver", mailReceiverId);
		if(mailReceiverPasswd!=null && mailReceiverPasswd.length() > 0)
		{
			mailReceiverPasswd = EgCrypt.encrypt(mailReceiverPasswd);
		}
		mailconfig.setValue(subject,"MailReceiverPasswd", mailReceiverPasswd);
		mailconfig.setValue(subject,"MailRcvPort", mailRcvPort);
		mailconfig.setValue(subject,"MailRcvProtocol", mailRcvProtocol);
		mailconfig.setValue(subject,"MailRcvServer", mailRcvServer);
		String[] mailIds = null;
		mailconfig.deleteSubject("MAIL_SENDERS");
		if (mailSenders!=null && mailSenders.length()>0)
		{
			StringTokenizer mailIdTokens = new StringTokenizer(mailSenders,"\n");
			mailIds = new String[mailIdTokens.countTokens()];
			for(int i=0;mailIdTokens.hasMoreElements();i++)
			{
				mailIds[i] = mailIdTokens.nextToken();
			}
		}
		if (mailIds!=null && mailIds.length>0)
		{
			for (int i=0;i<mailIds.length;i++)
			{
				mailconfig.setValue("MAIL_SENDERS", mailIds[i],"1");
			}
		}
		String authenticate = request.getParameter("authenticate");
		authenticate = egurkha.EgUIUtils.decodeSecurityChar(authenticate);

		if (!StringUtils.isNull(authenticate) && authenticate.equalsIgnoreCase(EgConstants.TRUE))
		{
			String muser = request.getParameter("user");
			muser = egurkha.EgUIUtils.decodeSecurityChar(muser);

			String mpass = request.getParameter("authpassword");
			mpass = egurkha.EgUIUtils.decodeSecurityChar(mpass);

			mailconfig.setValue(subject,"MailUser", muser);
			mailconfig.setValue(subject,"MailPasswd", EgCrypt.encrypt(mpass));
		}
		else
		{
			mailconfig.setValue(subject,"MailUser", "");
			mailconfig.setValue(subject,"MailPasswd", "");
		}
		/* Raji 
			The variable finalVal contains the maild ids that are removed in Mail Server Settings.Before it is saved to the services.ini the user who are mapped to that removed mail ids will be assigned to dafault mail id.
		*/
		ArrayList removeList = new ArrayList();
		if (mailIDsIni != null)
		{
			removeList = new ArrayList(Arrays.asList(mailIDsIni));
		}
		if(!removeList.isEmpty())
		{
			removeList.removeAll(alternateMailList);
		}
		if (removeList != null && !removeList.isEmpty())
		{
			for(int p=0;p<removeList.size();p++)
			{
				String removedMailId = (String)removeList.get(p);
				finalVal = finalVal+"'"+removedMailId+"'"+",";
			}
			if (finalVal.endsWith(","))
			{
				finalVal = finalVal.substring(0,finalVal.length()-1);
			}
			String updateMailQuery = "UPDATE user_pref SET mail_sender='default' where mail_sender in ("+finalVal+")";
			updateAndTransmitUserInfo.dbupdate(updateMailQuery);
		}
	}
	else if(autheticationType.equalsIgnoreCase("oAuth2")){
		String oauthUser = request.getParameter("oauthUser");
		oauthUser = egurkha.EgUIUtils.decodeSecurityChar(oauthUser);

		String clientId = request.getParameter("clientId");
		clientId = egurkha.EgUIUtils.decodeSecurityChar(clientId);

		String clientSecret = request.getParameter("clientSecret");
		clientSecret = egurkha.EgUIUtils.decodeSecurityChar(clientSecret);

		String tenantId = request.getParameter("tenantId");
		tenantId = egurkha.EgUIUtils.decodeSecurityChar(tenantId);

		if(clientId != null && clientId.trim().length()>0){
			clientId = EgCrypt.encrypt(clientId);
		}
		if(clientSecret != null && clientSecret.trim().length()>0){
			clientSecret = EgCrypt.encrypt(clientSecret);
		}
		if(tenantId != null && tenantId.trim().length()>0){
			tenantId = EgCrypt.encrypt(tenantId);
		}
		if(clearSet.equalsIgnoreCase("true")){
			oauthUser ="";
			clientId="";
			clientSecret="";
			tenantId="";
			autheticationType ="";
		}
		mailconfig.setValue(oAuthSubject,"oauthUser", oauthUser);
		mailconfig.setValue(oAuthSubject,"clientId", clientId);
		mailconfig.setValue(oAuthSubject,"clientSecret", clientSecret);
		mailconfig.setValue(oAuthSubject,"tenantId", tenantId);
	}
	mailconfig.saveFile();
	EgConfigFilesSync.releaseInstance(mailconfig);
	rootJson.put("success","true");
	rootJson.put("requestStatus","success");
	JSONObject resultMsg = new JSONObject();
	resultMsg.put("title",_mapping.getTextDescription("admin.title.Mail server settings"));
	if (clearSet.equals("true"))
	{
		resultMsg.put("message1",_mapping.getTextDescription("admin.title.Mail server and Backup mail server settings have been cleared successfully")+".");
	}
	else
	{
		resultMsg.put("message1",_mapping.getTextDescription("admin.title.Mail server settings have been configured successfully")+".");
	}
	rootJson.put("result",resultMsg);

	//System.out.println("rootJson_____"+rootJson);
	out.println(rootJson.toString());
%>



