<%@ include file="EgTrackerA.jsp" %>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String queryStringForApp = ErUtils.prepareQueryString(request.getParameterMap());
	String agentType = request.getParameter("agent_type");
	agentType = (agentType != null && agentType.trim().length()>0)?agentType:"PremiumAgents";
	String agentState = request.getParameter("agentStatus");
%>

<html>
<head>
	<meta charset="utf-8">
	<egui:skin ui="admin"/>
	<script type="text/javascript" src="../extjs/ext-all.js"></script>
	<!-- Fancy Scroll-->
	<script src="/final/jquery/jquery.js"></script>
	<script src="/final/styles/jscrollpane/jquery.jscrollpane.min.js" ></script>
	<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
	<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
	<script src="/final/scripts/utilities/EncodeDecodeParams.js"></script>
	<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>
	<script language="JavaScript1.2">
		var csrfToken = '<%=strCsrfToken%>';
		var defaultParams = '<%=queryStringForApp%>';
		var publicJson;
		var agent_type = '<%=agentType%>';
		var agent_State = '<%=agentState%>';
		var commandAlert = '<egui:intnl text="monitor.remotecontrol.Please select a command"/>';
		var timeoutInpAlert = '<egui:intnl text="monitor.remotecontrol.Enter the valid seconds"/>';
		var back_label = '<egui:intnl text="monitor.remotecontrol.Back"/>';
		var agent_ip_nickname_label = '<egui:intnl text="monitor.remotecontrol.Agent IP"/> / <egui:intnl text="monitor.remotecontrol.Nick name"/>';
		var mode_of_operation_label = '<egui:intnl text="monitor.remotecontrol.Mode of operation"/>';
		var command_label = '<egui:intnl text="monitor.remotecontrol.Command"/>';
		var arguments_label = '<egui:intnl text="monitor.remotecontrol.Arguments"/>';
		var command_syntax_label = '<egui:intnl text="monitor.remotecontrol.Command syntax"/>';
		var output_required_label = '<egui:intnl text="monitor.remotecontrol.Output required"/>';
		var timtout_in_secs_label = '<egui:intnl text="monitor.remotecontrol.Timeout"/> (<egui:intnl text="monitor.remotecontrol.in secs"/>)';
		var execute_label = '<egui:intnl text="monitor.remotecontrol.Execute"/>';
		var dangerousCommands = '<egui:intnl text="monitor.remotecontrol.This is invalid command"/>';

		var probsErrorMessage = '<egui:intnl text="admin.error.Problem encountered while loading the user interface"/>';
		var requestTimeOut = '<egui:intnl text="admin.error.Response timed out"/>';
		var errorTitle = '<egui:intnl text="admin.user.Error"/>';
		var isSmallScreen = window.innerWidth <= 1300;

	</script>
	<!-- Application folder -->
	<script type="text/javascript" src="RemoteControl/app/app.js"></script>
	<script language="javascript" src="/final/admin/eg_scripts/common.js"></script>
	<script language="JavaScript1.2" src="/final/admin/eg_scripts/validate.js"></script>
	<script language="javascript">
		Ext.onReady(function(){
			Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};

			Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
				else
				{
					if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : requestTimeOut,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
					else
					{
						console.log(response.responseText);
						Ext.Msg.show({
							title : errorTitle,
							msg : probsErrorMessage,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
				}
			});
		});
	</script>

</head>

<body>
<div id="loadmask" name="loadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;">
	<div class="x-mask-loading" style="position:relative">
		Loading...
	</div>
</div>
</body>
</html>

<%
	if(request.getQueryString()!= null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/remoteControl.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/remoteControl.jsp");
	}
%>



