<!DOCTYPE html>

<%@ include file="EcTracker.jsp" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String queryString = EcUtils.prepareQueryString(request.getParameterMap());
%>

<html>
<head>
	<meta charset="utf-8">

	<!--Skin color--------->
	<egui:skin ui = "configindex"/>

	<script type="text/javascript" src="../extjs/ext-all.js"></script>

	<!-- Fancy Scroll-->
	<script src="/final/jquery/jquery.js"></script>
	<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
	<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
	<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
	<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>

	<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
	<style type="text/css">
		td.wrap-text div {
			white-space: normal;
			word-wrap : break-word;
		}
	</style>
	<script language="Javascript1.2" src="/final/config/scripts/ec_validate.js"></script>

	<script language="JavaScript1.2">
		var csrfToken = '<%=strCsrfToken%>';
		var publicJSON = "";
		var eachRec = '';
		var probsErrorMessage = '<egui:intnl text="config.error.Problem encountered while loading the user interface"/>';
		var requestTimeOut = '<egui:intnl text="config.error.Response timed out"/>';
		var errorTitle = '<egui:intnl text="config.user.Error"/>';
		var config = {
			title : {
				pageTitle:'<egui:intnl text="config.booklet.REPORT BOOKLET" />',
				gridCol1: '<egui:intnl text="config.booklet.BOOKLET NAME" />',
				gridCol2: '<egui:intnl text="config.booklet.DESCRIPTION" />',
				gridCol3: '<egui:intnl text="config.booklet.REPORTS IN BOOKLET" />',
				gridCol4: '<egui:intnl text="config.booklet.STATUS" />'
			},
			urls : {
				servletURL : "../servlet/com.eg.EcConfigurationServletNew",
			},
			msgs : {
				emptyMsg1: '<egui:intnl text="config.booklet.Booklets Not Available" />',
				emptyMsg2: '<egui:intnl text="config.booklet.Booklets Not Available" />',
				noDataMsg: '<egui:intnl text="config.booklet.You do not have any Booklets configured currently " />',
				alertMsg1: '<egui:intnl text="config.booklet.Please enter Booklet name " />',
				alertMsg2: '<egui:intnl text="config.booklet.Special characters are not allowed in Booklet name " />',
				alertMsg3: '<egui:intnl text="config.booklet.Special characters are not allowed in Description " />',
				alertMsg4: '<egui:intnl text="config.booklet.Duplicate Booklet names are not allowed " />',
				alertMsg5: '<egui:intnl text="config.booklet.Duplicate Report names are not allowed " />',
				alertMsg6: '<egui:intnl text="config.booklet.Special characters are not allowed in Report name " />',
				alertMsg7: '<egui:intnl text="config.booklet.Booklet has been added successfuly " />',
				alertMsg8: '<egui:intnl text="config.booklet.Are you sure you want to delete the selected Booklets? " />',
				alertMsg9: '<egui:intnl text="config.booklet.Are you sure you want to delete the selected Reports? " />',
				alertMsg10: '<egui:intnl text="config.booklet.Cannot delete all the reports! " />',
				alertMsg11: '<egui:intnl text="config.booklet.Booklets are deleted successfuly " />',
				alertMsg12: '<egui:intnl text="config.booklet.Please select a Report! " />',
				alertMsg13: '<egui:intnl text="config.booklet.Please select a Booklet! " />',
				alertMsg14: '<egui:intnl text="config.booklet.Are you sure you want to delete the Report? " />',
				alertMsg15: '<egui:intnl text="config.booklet.Are you sure you want to delete the Booklet? " />',
				alertMsg16: '<egui:intnl text="config.booklet.Report is deleted successfuly " />',
				alertMsg17: '<egui:intnl text="config.booklet.Booklet is deleted successfuly " />',
				btnMsg1: '<egui:intnl text="config.booklet.Bind Reports" />',
				btnMsg2: '<egui:intnl text="config.booklet.Update" />'
			}
		};

	</script>
	<script src="../config/ReportBooklet/app/app.js"></script>
	<script language="javascript">
		Ext.onReady(function(){
			Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};

			Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
				else
				{
					if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : requestTimeOut,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
					else
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : probsErrorMessage,
							buttons : Ext.Msg.OK,
							icon : 'iconError'
						});
					}
				}
			});
		});
	</script>
</head>

<body>
<div id="loadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;">
	<div class="x-mask-loading" style="position:relative">
		Loading...
	</div>
</div>
</body>
</html>



