<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EcTracker.jsp"%>
<%@ page import = "egurkha.config.EcScheduleTask" %>
<%@ page import = "egurkha.config.EcReportParam" %>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	String user_id = user.getLoginID();
	EcScheduleTask[] task = EcScheduleTask.getScheduleListForUser(user_id);
	
	//date format
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String userDateFormat = user.getUserDateFormat();
	if (userDateFormat != null && userDateFormat.equalsIgnoreCase("Default"))
	{
		userDateFormat = currentDateFormat;
	}

	// If user date format is set, assign it to current date format.
	if (userDateFormat != null)
	{
		currentDateFormat = userDateFormat;
	}
	//end here

	int page1=1;

	double total_num_records=0;
	double total_num_records_per_page=0;
	int total_num_page=1;

	if((task!=null) && (task.length>0))
	{
		total_num_records=task.length;
		total_num_records_per_page=15.00;

		if(task.length<=10)
		{
			total_num_page=1;
		}
		else
		{
			total_num_page=(int)Math.round(Math.ceil(total_num_records/total_num_records_per_page));
		}
	}
%>

<html>
<head>

<title>
</title>
	<meta charset="utf-8">
	<!--Skin color--------->
	<egui:skin ui = "configindex"/>

	<script type="text/javascript" src="../extjs/ext-all.js"></script>

	<!-- Fancy Scroll-->
	<script src="/final/jquery/jquery.js"></script>
	<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
	<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
	<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
	<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>

	<script src="/final/Highcharts/js/highcharts.js"></script>
	<script src="/final/Highcharts/js/modules/exporting.js"></script>
	<script src="../config/scripts/EcHighCharts.js"></script>

	<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>

	<script language="JavaScript1.2" src="/final/scripts/eg_DateUtil.js"></script>
	<script language="Javascript1.2" src="/final/config/scripts/ec_validate.js"></script>
	<script language="Javascript1.2" src="/final/config/scripts/ec_date.js"></script>

	<script language="javascript">
		var publicJSON = '';
		var csrfToken = '<%=strCsrfToken%>';
		var total_num_records_per_page = "<%=total_num_records_per_page%>";
	var config = {
		title : {
			mainPageTitle : '<egui:intnl text="configmgmt.schedule.SCHEDULES" />',
			schGridColLabel1 : '<egui:intnl text="configmgmt.schedule.Schedule Name" />',
			schGridColLabel2 : '<egui:intnl text="configmgmt.schedule.Report Type" />',
			schGridColLabel3 : '<egui:intnl text="configmgmt.schedule.Mail" />',
			schGridColLabel4 : '<egui:intnl text="configmgmt.schedule.Print" />',
			schGridColLabel5 : '<egui:intnl text="configmgmt.schedule.Creation Time" />',
			delBtn : '<egui:intnl text="configmgmt.common.DELETE" />',
			schTitle : '<egui:intnl text="configmgmt.schedule.Configured Schedules" />'
		},
		urls : {
			initialURL : "../config/ViewSchedule/data/ViewScheduleJSON.jsp",
			servletURL : "../servlet/com.eg.EcConfigurationServletNew",
			scheduleURL : "/final/servlet/com.eg.EcSchedulerCNew"
		},
		msgs : {
			noDataMsg : '<egui:intnl text="configmgmt.common.You do not have any schedules configured currently"/>',
			scheduleAlertMsg : '<egui:intnl text="configmgmt.common.Please select a schedule" />',
			scheduleDeleteMsg : '<egui:intnl text="configmgmt.common.Are you sure to delete the selected item(s)" />',
			scheduleMsg : '<egui:intnl text="configmgmt.common.Schedule delete successfully" />'
		}
	};
	var probsErrorMessage = '<egui:intnl text="config.error.Problem encountered while loading he user interface"/>';
	var requestTimeOut = '<egui:intnl text="config.error.Response timed out"/>';
	var errorTitle = '<egui:intnl text="config.user.Error"/>';
	Ext.onReady(function(){
		Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
		Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
		Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};

		Ext.Ajax.on('requestexception', function (conn, response, options) {
			var errorStr = response.responseText;
			if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
			{
				if (errorStr.indexOf("user-session-invalid") != -1)
				{
					callWindow(1);
				}
				else if (errorStr.indexOf("user-deleted") != -1)
				{
					callWindow(2);
				}
				else if (errorStr.indexOf("user-timedout") != -1)
				{
					callWindow(3);
				}
			}
			else
			{
				if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
				{
					Ext.Msg.show({
						title : errorTitle,
						msg : requestTimeOut,
						buttons : Ext.Msg.OK,
						icon : 'iconError'
					});
				}
				else
				{
					Ext.Msg.show({
						title : errorTitle,
						msg : probsErrorMessage,
						buttons : Ext.Msg.OK,
						icon : 'iconError'
					});
				}
			}
		});
	});
</script>
<script src="/final/config/ViewSchedule/app/app.js"></script>

<style type="text/css">
b {
	font-weight : bold;
}
</style>
</head>

<body>
	<div id="loadmask" class="x-mask-msg x-layer x-mask-msg-default" style="z-index: 19001;left:45%;top:35%;"><div class="x-mask-loading" style="position:relative">Loading..</div></div>
</body>
</html>



