<%@ page import="com.eg.*" %>
<%@ page import="java.util.*" %>
<%@ page import="java.text.*" %>
<%@ page import="java.lang.management.*"%>
<%@ page import="com.sun.management.*"%>
<%@ page import="com.egurkha.util.EgSorter"%>
<%@ page import="com.eg.EgConMonHelper"%>
<%@ page import="java.io.*" %>
<%@ page import="org.w3c.dom.*" %>
<%@ page import="javax.xml.parsers.*" %>
<%@ page import="javax.xml.transform.*" %>
<%@ page import="javax.xml.transform.dom.DOMSource" %>
<%@ page import="javax.xml.transform.stream.StreamResult" %>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	private long lastuptime=0L;
	private long prevUpTime = 0L;
	private long lastProcessCpuTime = 0L;
	private Hashtable ht_liveThreads = null;
	private Hashtable ht_blockedTime = null;
	private Hashtable ht_waitedTime = null;
	StringBuffer sb = new StringBuffer();
	Date xmlFileDate = null;
	String manager_label = EgInstallInfo.isSuperManager ? "SuperManager" : "Manager";

	private long getJVMUpTimeDiff()
	{
		long uptime = 0L;
		long uptimeDiff = 0L;
		try
		{
			RuntimeMXBean rmxbean = ManagementFactory.getRuntimeMXBean();
			uptime = rmxbean.getUptime();
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			return -1;
		}
		if(uptime < 0)
		{
			lastuptime = 0;
			return -1;
		}

		uptimeDiff= uptime - lastuptime;
		lastuptime = uptime;
		return uptimeDiff;
	}

	public ArrayList sortPercentageCPUTime(ArrayList arrList, int totalCols, int column)
	{
		ArrayList result = new ArrayList();
		if (arrList==null || arrList.size()==0)
			return result;
		for(int k=0;k<arrList.size();k++)
		{
			String tmpLine = (String)arrList.get(k);
			StringTokenizer st = new StringTokenizer(tmpLine,"~");
			while(st.hasMoreTokens())
				result.add(st.nextToken());
		}
		EgSorter egSort = new EgSorter(result,totalCols);
		ArrayList sortList= new ArrayList();
		if(column <= 0)
			column = 5;
		String checkCol = (String)result.get(column-1);
		//int sortCol = 5;			// col 5 %cputime 
		//sortCol = 10;			// col 10 is Waited 
		if(checkCol.equals("Not Available"))
			column = 10;
		if(column == 5 || column == 10)
			sortList = (ArrayList)egSort.sort(column,"Double","desc");
		else 
			sortList = (ArrayList)egSort.sort(column,"String","asc");
		return sortList;
	}

	private static String getTagValue(String sTag, Element eElement)
	{
		NodeList nlList = eElement.getElementsByTagName(sTag).item(0).getChildNodes();
		Node nValue = (Node) nlList.item(0); 
		return nValue.getNodeValue();
	}
%>
<%
	String enableXMLDld = request.getParameter("enableXMLDld");
	if(enableXMLDld != null && enableXMLDld.equalsIgnoreCase("true"))
	{
		session.setAttribute("dldXMLFileFromTk","true");
		out.print("success");
		return;
	}
	
	// XML File Download (Begin)
	String fileDownload = request.getParameter("fileDownload");
	if(fileDownload != null && fileDownload.length() > 0 && fileDownload.equalsIgnoreCase("true"))
	{
		String dldXMLFileFromTk = (String)session.getAttribute("dldXMLFileFromTk");
		if(dldXMLFileFromTk != null && dldXMLFileFromTk.equalsIgnoreCase("true"))
		{
			session.removeAttribute("dldXMLFileFromTk");
			String myServerName = request.getServerName();
			SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
			String date_format = sdf.format(xmlFileDate);
			String filename = ("Stack_"+date_format+"_"+myServerName+".xml");
			String filepath = EgInstallInfo.getInstallDir()+"/tmp/stackXml.xml";
			BufferedInputStream buf=null;
			ServletOutputStream myOut=null;
			try
			{
				myOut = response.getOutputStream( );
				File myfile = new File(filepath );
				//set response headers
				//response.setContentType("application/xml");
				response.setHeader("Content-Type", "text/xml; charset=ISO-8859-1");
				response.setHeader("Content-Disposition","attachment; filename="+filename );
				response.setContentLength((int) myfile.length());
				FileInputStream input = new FileInputStream(myfile);
				buf = new BufferedInputStream(input);
				int readBytes = 0;

				//read from the file; write to the ServletOutputStream
				while((readBytes = buf.read( )) != -1)
				myOut.write(readBytes);
			}
			catch (IOException ioe)
			{
				throw new ServletException(ioe.getMessage());
			}
			finally
			{
				//close the input/output streams
				if (myOut != null)
					myOut.close();
				if (buf != null)
					buf.close();
			}
			return;
		}
	}
	//XML File Download (End)

	String sortColumn = request.getParameter("sortColumn");
	if(sortColumn == null )
		sortColumn = "5";
	int clm = 0;
	try {
		clm = Integer.parseInt(sortColumn);
	}
	catch (Exception e)  {}

	if(clm <= 0 && clm > 12)
		clm = 5;
	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE6 = ( ua != null && ua.indexOf( "MSIE 6.0" ) != -1 );
	boolean isMSIE7 = ( ua != null && ua.indexOf( "MSIE 7.0" ) != -1 );

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	String sessionInUse = request.getParameter("sessionInUse");
	String pwd = request.getParameter("pwd");
	String authenticated = (String)session.getAttribute("authenticated");

	if (authenticated == null)
	{
		// Direct access from the browser address bar or from inside the toolkit via the tool
		if (pwd == null)
		{
			if (sessionInUse == null)
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom=StackTrace");
			}
			else
			{
%>
				<script>
					window.parent.location.href ="/final/toolkitlogin";
				</script>
<%
			}
		}
		else
		{
			// Direct access from the browser address bar
			if (!pwd.equals(EgConMonHelper.executePwd))
			{
				response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom=StackTrace");
			}
			else
			{
				session.setAttribute("reqFromForTk","StackTrace");
				String redirectURL = request.getContextPath()+"/toolkit";
				response.sendRedirect(redirectURL);
			}
		}
	}
	else
	{ 
		// Direct access from the browser address bar and session in use
		if (sessionInUse == null)
		{
			response.sendRedirect(request.getContextPath()+"/toolkit");
		}
	}

	session.setAttribute("reqFromForTk","StackTrace");
	String comeFrom = request.getParameter("comeFrom");
	if (!StringUtils.isNull(comeFrom) && comeFrom.equals("Stack"))
	{
		session.setAttribute("treeViewSrc","StackTrace");
	}
	String from = request.getParameter("from");
	String xml = request.getParameter("xml");
	boolean stackSupported = false;
	String javaVersion = System.getProperty("java.version");
	Date date = new java.util.Date();
	xmlFileDate = date;
	if(javaVersion != null && javaVersion.length() > 0)
	{
		if(javaVersion.startsWith("1.")){
			String version = String.valueOf(javaVersion.charAt(2));
			int i = Integer.parseInt(version);
			if(i > 4)
			{
				stackSupported = true;
			}
		}
		else {
			String majorVersion = javaVersion;
			if(javaVersion.indexOf(".") > 0){
				majorVersion = javaVersion.substring(0,javaVersion.indexOf("."));
			}
			else if(javaVersion.indexOf("-") > 0){
				majorVersion = javaVersion.substring(0,javaVersion.indexOf("-"));
			}
			try{
				int i = Integer.parseInt(majorVersion);	
				if(i > 9){
					stackSupported = true;
				}
			}
			catch(Exception e){
				e.printStackTrace();
			}
		}
	}
	
	boolean realTime = false;
	if(from!=null && from.equals("file"))
		realTime = false;
	else
		realTime = true;

	boolean testFile = false;
	boolean xmlTag = false;
	String xmlFileName="";

	if(xml!=null && xml.length() > 0)
	{
		xmlFileName = xml;
		testFile = true;
	}

	String isTable="";
	isTable = isFirefox ? "Auto" : "Fixed";
	String wd = isFirefox?"657px":"720px";
	String wdtd = isFirefox?"659px":"660px";

	//xml file delet....(start)
	File tmpFile = new File(EgInstallInfo.getInstallDir()+"/tmp/");
	if(from == null)
	{
		File[] listOfFiles = tmpFile.listFiles();
		int fileLength = listOfFiles.length; 
		for(int i=0;i<fileLength;i++)
		{
			String fileName = listOfFiles[i].getName();
			if(fileName.endsWith(".xml") && !fileName.equalsIgnoreCase("stackXml.xml"))
				listOfFiles[i].delete();
		}
	}
	//xml file delete...(End)
%>

<html>
<head>
<title>eG Manager Threads </title>
<link REL = "StyleSheet" href = "/final/admin/eg_styles/adminstyle_blue.css"/>
<script language="javascript" src="/final/admin/eg_scripts/timeout.js"></script>
<script type="text/javascript">

	function getRequest()  
	{       
		var xmlhttp;
		if (window.XMLHttpRequest) 
		{
			xmlhttp = new XMLHttpRequest();
		}
		else 
		{
			xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
		}
		return xmlhttp;
	}

	function fillTabs(id,url)
	{
		var request = getRequest();
		var params;
		var tempurl;
		if (url.indexOf("?")>-1)
		{
			params = url.substring(url.indexOf("?")+1);
			tempurl = url.substring(0,url.indexOf("?"));
		}
		request.open('POST',tempurl,true);
		request.setRequestHeader('Content-type','application/x-www-form-urlencoded');
		request.onreadystatechange = function ()
		{
			if(request.readyState == 4)
			{
				var response = request.responseText;
				document.getElementById(id).innerHTML = response;
			}
		}
		request.send(params);
	}

	document.onscroll = function()
	{
		clearTimeout(time);
		time = setTimeout(logout,timeoutTime);
	}
	var str = '';
	window.name = "oldwin";
	function setSorted(val, testFile , xmlfile)
	{
		var url = "/final/misc/EgStack.jsp?sessionInUse=true&sortColumn="+val;
		if(testFile == 'true')
		{
			url = url + "&from=file&xml="+xmlfile;
		}
		window.location.href = url;
	}

	function setFile(value)
	{
		var url = "/final/misc/EgStack.jsp?sessionInUse=true&from=file&xml="+encodeURIComponent(value);
		window.location.href = url;
	}

	function showDetails(tname,details)
	{
		str = details;
		var data = new Array();
		var tokens = new Array();
		var flag=new Boolean();
		flag=false;
		var threadname = tname.substring(0,tname.indexOf("*:*"));
		var tid = tname.substring(tname.indexOf("*:*")+3);
		data = str.split(', ');
		if(threadname=="Nil")
		{
			fillTabs('ThreadDiv','../misc/jvmThreads.jsp?details=Nil');
		}
		else
		{
			for(var i=0;i<data.length;i=i+12)
			{
				var val = data[i];
				var id = data[i+1];
				if(val.charAt(0)=="[")
					val = val.substr(1);
				if(val==threadname && id == tid)
				{
					var totalData = val;
					for(var k=i+1;k<i+12;k++)
					{
						totalData = totalData+","+data[k];
					}
					fillTabs('ThreadDiv','../misc/jvmThreads.jsp?details='+encodeURIComponent(totalData));
					flag=true;
				}
				if(flag)
					break;
			}
		}
		hideDivs('linkDiv');
	}

	function showLinkDiv(tname)
	{
		var linkDiv = document.getElementById("linkDiv");
		var headTd = document.getElementById("headTd");
		linkDiv.style.textAlign = 'right';
		linkDiv.style.padding = '0px';
		linkDiv.style.padding = '0px';
		linkDiv.style.background="white";
		var heading = tname.substring(0,tname.indexOf("("));
		headTd.innerHTML = '<strong>'+heading+'<strong>';
		showInnerDiv(tname);
		showDivs('linkDiv');
	}

	function showInnerDiv(tname)
	{
		var data = new Array();
		var tokens = new Array();
		var flag=new Boolean();
		var threadname = tname.substring(0,tname.indexOf("("));
		var tid = tname.substring(tname.indexOf("(")+1,tname.lastIndexOf(")"));
		flag=false;
		data = str.split(', ');
		for(var i=0;i<data.length;i=i+12)
		{
			var val = data[i];
			var id = data[i+1];
			if(val.charAt(0)=="[")
				val = val.substr(1);
			if(val==threadname && id == tid)
			{
				var totalData = val;
				for(var k=i+1;k<i+12;k++)
				{
					totalData = totalData+","+data[k];
				}
				fillTabs('linkInnerDiv','<%=response.encodeURL("../misc/jvmThreads.jsp?details=")%>'+encodeURIComponent(totalData));
					flag=true;
			}
			if(flag)
				break;
		}
	}

	function showDivs(divId)
	{
		var show_div = document.getElementById(divId);
		if(show_div!=null)
		{
			show_div.style.display = 'block';
			show_div.style.position = 'absolute';
			bringToFront(show_div);
		}
	}

	function bringToFront(obj)
	{
		if (!document.getElementsByTagName)
			return;
		var divs = getAbsoluteDivs();  
		var max_index = 0;  
		var cur_index;  
		for (i = 0; i < divs.length; i++)
		{
			var item = divs[i];
			if (item == obj || item.style.zIndex == '')
				continue;
			cur_index = parseInt(item.style.zIndex);
			if (max_index < cur_index)
			{
				max_index = cur_index;
			}
		}
			obj.style.zIndex = max_index + 1;
	}

	function getAbsoluteDivs()  
	{
		var arr = new Array();
		var all_divs = document.body.getElementsByTagName("DIV");
		var j = 0;
		for (i = 0; i < all_divs.length; i++)
			if (all_divs.item(i).style.position=='absolute')
			{
				arr[j] = all_divs.item(i);
				j++;
		}
		return arr;
	}

	function hideDivs(divId)
	{
		var show_div = document.getElementById(divId);
		if(show_div!=null)
		{
			show_div.style.display="none";
		}
	}

	function save()
	{
		var response = sendRequest("/final/misc/EgStack.jsp?enableXMLDld=true");
		if(response == 'error')
		{
			return;
		}
		window.location.href = "/final/misc/EgStack.jsp?sessionInUse=true&fileDownload=true";
	}
	
	function sendRequest(url, params) 
	{
		var request;
		var response = 'error';
		if (window.XMLHttpRequest) 
		{
			request = new XMLHttpRequest();
		}
		else 
		{
			request = new ActiveXObject("Microsoft.XMLHTTP");
		}
		request.open("POST", url, false);
		request.setRequestHeader('Content-type','application/x-www-form-urlencoded');
		request.onreadystatechange = function()
		{
			if (request.readyState==4 && request.status==200)
		
	{
				try
				{
					response = request.responseText;
				}
				catch(error)
				{}
			}
		}
		request.send(params);
		return response;
	}
	
	function openUploadWin(url)
	{
		uploadWin = window.open(url,"FileUpload","width=450,height=160,scrollbars=no,resizable=yes");
		uploadWin.focus();
	}

</script>
</head>
<body>
	<div id="linkDiv" name="linkDiv" style="display:none;left:225px;top:290px;width:680px;height:290px;border:0px solid #ff0000; position:absolute;">
		<table  border="0" cellspacing="0" cellpadding="0" width="100%">
			<tr>
				<td class="pop2_lefttop_curve"><img src="/final/monitor/eg_images/spacer.gif" width="11" height="11"></td>
				<td class="pop2_top_bg" width="100%"><img src="/final/monitor/eg_images/spacer.gif" width="2" height="11"></td>
				<td class="pop2_righttop_curve" ><img src="/final/monitor/eg_images/spacer.gif" width="11" height="11"></td>
			</tr>
			<tr>
				<td class="pop2_left_bg"><img src="/final/monitor/eg_images/spacer.gif" width="11" height="2"></td>
				<td class="eg_whitebg">
					<table cellspacing="0" cellpadding="3" border="0" width="100%">
						<tr>
							<td> 
								<table cellpadding="4" cellspacing="0" border="0">
									<tr>
										<td width="100%" align="center" class="eg_75bold cell_border1" style="border-right-width:0px" id="headTd" ></td>
										<td style="width:20px" class="cell_border1" style="border-left-width:0px">
											<div style="display:block;text-align:right"><a id="closeLink" class="mouse" onclick="hideDivs('linkDiv');"><img src="/final/monitor/eg_images/winclose.gif" border="0" class="mouse" title="close"></a>
											</div>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
				<td class="pop2_right_bg"><img src="/final/monitor/eg_images/spacer.gif" width="11" height="2"></td>
			</tr>
			<tr>
				<td class="pop2_left_bg"><img src="/final/monitor/eg_images/spacer.gif" width="11" height="250px"></td>
				<td class="eg_whitebg"><div class="div_scroll" id='linkInnerDiv' name='linkInnerDiv' style="height:246px;border:0px solid #ff0000;"> </div></td>
				<td class="pop2_right_bg"><img src="/final/monitor/eg_images/spacer.gif" width="11" height="250px"></td>
			</tr>
			<tr>
				<td class="pop2_leftbottom_curve"><img src="/final/monitor/eg_images/spacer.gif" width="11" height="11"></td>
				<td class="pop2_bottom_bg"><img src="/final/monitor/eg_images/spacer.gif" width="2" height="11"></td>
				<td class="pop2_rightbottom_curve"><img src="/final/monitor/eg_images/spacer.gif" width="11" height="11"></td>
			</tr>
		</table>
	</div>
<%
	if(!realTime)
	{
		File file = new File(EgInstallInfo.getInstallDir()+"/tmp/");
		File[] listOfFiles = file.listFiles();
		int fileLength = listOfFiles.length; 
		for(int i=0;i<fileLength;i++)
		{
			String fileName = listOfFiles[i].getName();
			if(fileName.endsWith(".xml"))
			{
				if(!fileName.equalsIgnoreCase("stackXml.xml"))
				{
					xmlTag = true;
				}
			}
		}
		if(xmlTag)
		{
%>
	<div id="saveDiv" name="saveDiv" style="display:block;left:700px;top:67px;width:100px;height:20px;border:0px solid #ff0000; position:absolute;">
		<table border="0" cellspacing="0" cellpadding="0" width="100%">
			<tr>
				<td>
					<input type="hidden" name = "XML:"id="sortOption"align = "left" onchange="setFile(this.value)">
<%
			for (int x = 0; x < fileLength; x++)
			{
				String fileName = listOfFiles[x].getName();
				String selected="";
				if(fileName.endsWith(".xml") && !fileName.equalsIgnoreCase("stackXml.xml"))
				{
					if(!testFile)
					{
						xmlFileName = fileName;
						testFile = true;
					}
					if(xmlFileName.equals(fileName))
					{
						selected = "selected";
						if(! xmlFileName.equals("stackXml.xml") && xmlFileName.startsWith("Stack_"))
						{
							String time = "";
							SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
							try{
								if(fileName.startsWith("Stack"))
									time = fileName.substring(6,fileName.lastIndexOf("_"));
								else
									time = fileName.substring(0,fileName.indexOf("_" ));
							}
							catch(Exception e){}
							if(time != null && time.length() > 0)
								date = (Date)sdf.parse(time);
							else
								date = new java.util.Date();
						}
					}
				}
			}
%>
				</td>
			</tr>
		</table>
	</div>
<%
		}
	}
%>
		<table cellspacing="0" id="eg_subcontentbg" cellpadding="0" width="100%" border="0">
<%
	if(!stackSupported)
	{
%>
			<tr>
				<td height="20" align="center" width="100%"> 
					<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0">
						<tr>
							<td  height="100%" nowrap align="center"><img src="/final/admin/eg_images/info2.gif">&nbsp;
						Stack is not supported for this version of java</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
<%
	return;
	}

	if(!realTime && !xmlTag)
	{
%>
		<table cellspacing="0"  cellpadding="0" width="100%" border="0" height="100%">
			<tr>
				<td height="20" align="center" width="100%" id="eg_subcontentbg"> 
					<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0">
						<tr>
							<td  height="100%" nowrap align="center"><img src="/final/admin/eg_images/info2.gif">&nbsp;
							This page enables the administrator to view live threads running in eG <%=manager_label%></td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td height="100%">
					<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0"	height="100%">
						<tr>
							<td nowrap align="center" valign ="middle"><img src="/final/admin/eg_images/blue/exclamation-icon.gif"><br>
							<b>No XML file(s) in the  <%=EgInstallInfo.getInstallDir()+"\\tmp"%> directory</b></td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
<%
		return;
	}
%>
		<table cellspacing="0" id="eg_subcontentbg" cellpadding="0" width="100%" border="0">
			<tr>
				<td width="100%" height="24" id="eg_title" align="center">eG <%=manager_label%> Threads</td>
			</tr>
			<tr>
				<td height="20" align="center" width="100%"> 
					<table align="center" width="90%" cellspacing="0" cellpadding="0" border="0">
						<tr>
							<td  height="24" nowrap align="center"> <img src="/final/admin/eg_images/info2.gif">&nbsp;
							This page enables the administrator to view live threads running in eG <%=manager_label%> </td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td height="10px">&nbsp;</td>
			</tr>
		</table>
<%
	if(from != null && from.equals("file"))
	{
%>
		<table cellspacing="0" id="eg_subcontentbg" cellpadding="0" width="100%" border="0">
			<tr>
				<td style="padding-bottom:6px">
					<table cellspacing="0" cellpadding="0" width="90%" border="0" align="center">
						<tr>
							<td nowrap align="left">File in use&nbsp;:&nbsp;<%=xmlFileName%></td>
							<td><input disabled type="button" align="center" name="download" value='Export' id="eg_back" onclick="save()"/></td>
							<td ><input disabled type="button" align="center"name="upload" value='Import' id="eg_back" onClick="javascript:openUploadWin('/final/admin/EgFileUploadForStack.jsp?title=Uploading Xml Files&dispCaption=Stack xml&requestFrom=EgStack.jsp&uploadFor=save&uploadDir=/tmp/&fileExt=xml')"/></td>
							<td nowrap align="right">
								<a class="eg_monlink" href="EgStack.jsp?sessionInUse=true">
									<b>Click here</b>
									<img border="0" src="/final/admin/eg_images/icon_click.gif">
								</a>
								to view the current stack page
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
<%
	}
	else
	{
%>
		<table cellspacing="0" id="eg_subcontentbg" cellpadding="0" width="100%" border="0">
			<tr>
				<td style="padding-bottom:6px">
					<table cellspacing="0" cellpadding="0" width = "16%" border="0" align="center">
						<tr>
							<td style="padding-bottom:6px"><input type="button" align="center" name="download" value='Export' id="eg_back" title="Export thread details to an xml file" onclick="save()"/></td>
							<td style="padding-bottom:6px"><input type="button" align="center"name="upload" value='Import' id="eg_back" title="Import an xml file to view thread details" onClick="javascript:openUploadWin('/final/admin/EgFileUploadForStack.jsp?title=Uploading Xml Files&dispCaption=Stack xml&requestFrom=EgStack.jsp&uploadFor=save&uploadDir=/tmp/&fileExt=xml')"/></td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
<%
	}

try
{
	ArrayList deadockThreads = new ArrayList();
	ArrayList runnable_info = new ArrayList();
	ArrayList blocked_info = new ArrayList();
	ArrayList waiting_info = new ArrayList();
	ArrayList timedWaiting_info  = new ArrayList();
	ArrayList allthreads_info = new ArrayList();
	ArrayList threadNamesList = new ArrayList();
	Hashtable ht = new Hashtable();
	DecimalFormat df = new DecimalFormat("#.####");
	int numLive=0;
	int numBlocked=0;
	int numWaiting=0;
	int numTimedWaiting=0;
	int totalNum=0;
	long numPeakCount = 0;
	long totalStarted = 0; 
	int deadLockThreads =0;
	double cpuUsage=0.0;

	if(realTime)
	{
		java.lang.management.ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
		com.sun.management.OperatingSystemMXBean osBean = (com.sun.management.OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
		boolean isCpuTimeEnabled=false;
		boolean isContentionMonitoringEnabled=false;


		if(ht_liveThreads==null)
			ht_liveThreads = new Hashtable();
		if(ht_blockedTime == null)
			ht_blockedTime = new Hashtable();
		if(ht_waitedTime ==null)
			ht_waitedTime = new Hashtable();

		long[] ids = threadBean.getAllThreadIds();
		numPeakCount = threadBean.getPeakThreadCount();
		totalStarted = threadBean.getTotalStartedThreadCount(); 
		//long totalDaemon = threadBean.getDaemonThreadCount();
		deadLockThreads =0;
		long[] deadLockThreadIds = threadBean.findMonitorDeadlockedThreads();
		if(deadLockThreadIds!=null && deadLockThreadIds.length>0)
		{
			sb = new StringBuffer();
			for(int k=0;k<deadLockThreadIds.length;k++)
			{
				sb.append(Long.toString(deadLockThreadIds[k]));
				if(k != deadLockThreadIds.length - 1)
				{
					sb.append(",");
				}
			}
		}
		else
		{
			sb = new StringBuffer();
			sb.append(0);
		}
		if(deadLockThreadIds!=null && deadLockThreadIds.length>0)
		{
			deadLockThreads = deadLockThreadIds.length;
			Arrays.sort(deadLockThreadIds);
		}

		long uptimeDiff=0L;
		uptimeDiff = getJVMUpTimeDiff();
		if(uptimeDiff < 0)
			return; 

		// CPU Usage.......(Begin)
		long processCpuTimeDiff=0;
		long processCpuTime = osBean.getProcessCpuTime() ;
		int noOfProcessors = osBean.getAvailableProcessors();

		if(processCpuTime < lastProcessCpuTime)
			processCpuTimeDiff = processCpuTime;
		else
			processCpuTimeDiff= processCpuTime - lastProcessCpuTime;

		lastProcessCpuTime = processCpuTime;

		if((uptimeDiff <=0)|| (noOfProcessors==0))
		{
			cpuUsage=-5.0;
			lastProcessCpuTime = 0;
		}
		else
		{
			cpuUsage=Math.min(99.9, (double)processCpuTimeDiff / ((double)uptimeDiff * 10000D * (double)noOfProcessors));
		}
		// CPU Usage.......(End)

		try
		{
			if(threadBean.isThreadCpuTimeSupported())
			{
				if(!threadBean.isThreadCpuTimeEnabled())
				{
					threadBean.setThreadCpuTimeEnabled(true);
				}
				isCpuTimeEnabled=true;
			}
		}
		catch(Exception e)
		{
			isCpuTimeEnabled=false;
		}

		try
		{
			if(threadBean.isThreadContentionMonitoringSupported())
			{
				if(!threadBean.isThreadContentionMonitoringEnabled())
				{
					threadBean.setThreadContentionMonitoringEnabled(true);
				}
				isContentionMonitoringEnabled=true;
			}
		}
		catch(Exception e)
		{
			isContentionMonitoringEnabled=false;
		}

		if(ids == null || ids.length == 0)
			return ;
		
		for(int i=0;i<ids.length;i++)
		{
			try
			{
				ThreadInfo threadInfo = threadBean.getThreadInfo(ids[i],10000);
				if(threadInfo==null)
					continue;

				String threadName = threadInfo.getThreadName();
				Thread.State threadState = threadInfo.getThreadState();
				long blockedCount = threadInfo.getBlockedCount();
				long waitedCount  = threadInfo.getWaitedCount();

				long blockedTime=0L;
				long waitedTime=0L;

				long threadCpuTime =0L;
				long prevThreadCpuTime=0L;
				long prevBlockedTime=0L;
				long prevWaitedTime=0L;

				long threadCpuDiff=0L;
				long blockedDiff = 0L;
				long waitedDiff = 0L;

				double cpupercent=0.0;
				double blockedPercent=0.0;
				double waitedPercent=0.0;

				String cpuTime="Not_Supported";
				String waittime="Not_Supported";
				String blocktime="Not_Supported";
				
				if(isCpuTimeEnabled)
				{
					threadCpuTime = threadBean.getThreadCpuTime(ids[i]);			// this time is in nanoseconds......

					if((ht_liveThreads !=null)&&(!ht_liveThreads.isEmpty()))
					{
						if(ht_liveThreads.containsKey(ids[i]))
						{
							prevThreadCpuTime =((Long)ht_liveThreads.get(ids[i])).longValue();
						}
					}
					if(threadCpuTime < prevThreadCpuTime)
					{
						threadCpuDiff = threadCpuTime;
					}
					else
					{
						threadCpuDiff=threadCpuTime - prevThreadCpuTime;
					}
					
					cpupercent=((double) threadCpuDiff / (double) uptimeDiff)/10000.0;
					if(noOfProcessors > 1)
					{
						cpupercent = cpupercent / (double) noOfProcessors ;
					}

					if(cpupercent > 100)
						cpupercent=100.0000;

						cpuTime = df.format((threadCpuDiff/1000000)/1000.0)+"~"+df.format(cpupercent);

					ht_liveThreads.put(ids[i],threadCpuTime);
				}
				else
				{
					cpuTime=cpuTime+"~"+0;
				}


				if(isContentionMonitoringEnabled)
				{
					blockedTime = threadInfo.getBlockedTime();				//This time is in milliseconds...
					// Calculation for percentage blocked time
					if((ht_blockedTime !=null)&&(!ht_blockedTime.isEmpty()))
					{
						if(ht_blockedTime.containsKey(ids[i]))
						{
							prevBlockedTime =((Long)ht_blockedTime.get(ids[i])).longValue();
						}
					}

					if(blockedTime < prevBlockedTime)
					{
						blockedDiff = blockedTime;
					}
					else
					{
						blockedDiff=blockedTime - prevBlockedTime;
					}

					blockedPercent = ((double) (blockedDiff / 1000) / (double) (uptimeDiff / 1000))* 100.0;

					if(blockedPercent > 100)
						blockedPercent=100.0000;

					if (Double.isNaN(blockedPercent))
						blockedPercent = 0.0;
					
					blocktime = df.format((double) blockedDiff/1000.0)+"~"+df.format(blockedPercent);

					ht_blockedTime.put(ids[i],blockedTime);

					//calculation for percentage waitedTime
					waitedTime = threadInfo.getWaitedTime();			//This time is in milliseconds...

					if((ht_waitedTime !=null)&&(!ht_waitedTime.isEmpty()))
					{
						if(ht_waitedTime.containsKey(ids[i]))
						{
							prevWaitedTime =((Long)ht_waitedTime.get(ids[i])).longValue();
						}
					}
					
					if(waitedTime < prevWaitedTime)
					{
						waitedDiff = waitedTime;
					}
					else
					{
						waitedDiff=waitedTime - prevWaitedTime;
					}

					waitedPercent=((double) (waitedDiff / 1000) / (double) (uptimeDiff / 1000 )) * 100.0;

					if(waitedPercent > 100)
						waitedPercent=100.0000;

					if (Double.isNaN(waitedPercent))
						waitedPercent = 0.0;
					waittime = df.format((double) waitedDiff / 1000.0) +"~"+df.format(waitedPercent);

					ht_waitedTime.put(ids[i],waitedTime);
				}
				else
				{
					blocktime=blocktime+"~"+0.0;
					waittime=waittime+"~"+0.0;
				}

				StackTraceElement[] ste=threadInfo.getStackTrace();
				String stacktrace="";
				if(ste != null && ste.length > 0)
				{
					if(ste.length >= 4)
					{
						String fileName = ste[3].toString();
						if(fileName.indexOf("EgStack_jsp.java") > -1)
							continue;
					}
					for(int j=0;j<ste.length;j++)
					{
						stacktrace +=(ste[j].toString()+";")+"  ";
					}
				}
				if(stacktrace.trim().length() <= 3)
					stacktrace = "-";

				String lockName = threadInfo.getLockName();
				long lockOwnerId = threadInfo.getLockOwnerId();
				String lockOwnerName = threadInfo.getLockOwnerName();
				StringBuffer threadStateBuffer = new StringBuffer(threadState.toString());
				if(lockName!=null && lockName.length()>0 )
					threadStateBuffer.append(" on "+lockName.toString());
				if(lockOwnerName!=null && lockOwnerName.length()>0)
				{
					threadStateBuffer.append(" owned by: "+lockOwnerName.toString());
					if(lockOwnerId >=0)
						threadStateBuffer.append("("+lockOwnerId+")");
				}

				String thread_info = threadName+"~"+ids[i]+"~"+threadStateBuffer.toString()+"~"+cpuTime+"~"+blockedCount+"~"+blocktime+"~"+waitedCount+"~"+waittime+"~"+stacktrace;

				allthreads_info.add(thread_info);

				if(threadState.toString().compareToIgnoreCase("RUNNABLE")==0)
				{
					numLive++;
					runnable_info.add(thread_info);
				}
				else if(threadState.toString().compareToIgnoreCase("BLOCKED")==0)
				{
					numBlocked++;
					blocked_info.add(thread_info);

					if(deadLockThreadIds!=null && deadLockThreadIds.length>0)
					{
						if(Arrays.binarySearch(deadLockThreadIds,ids[i]) >= 0)
							deadockThreads.add(thread_info);
					}
				}
				else if(threadState.toString().compareToIgnoreCase("WAITING")==0)
				{
					numWaiting++;
					waiting_info.add(thread_info);
				}
				else if(threadState.toString().compareToIgnoreCase("TIMED_WAITING")==0)
				{
					numTimedWaiting++;
					timedWaiting_info.add(thread_info);
				}
			}
			catch (Exception e)
			{
			
			}
			totalNum=numLive+numBlocked+numWaiting+numTimedWaiting;
		}
	}
	else if(testFile)
	{
		ArrayList deadLockIdList = new ArrayList();
		File xmlFile = new File(EgInstallInfo.getInstallDir()+"/tmp/"+xmlFileName);
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		DocumentBuilder db = dbf.newDocumentBuilder();
		Document doc = db.parse(xmlFile);
		doc.getDocumentElement().normalize();
		String rootNodeName = doc.getDocumentElement().getNodeName();
		NodeList threadSummaryLst = doc.getElementsByTagName("ThreadSummary");
		for(int i = 0;i<threadSummaryLst.getLength();i++)
		{
			Node threadSummaryNode = threadSummaryLst.item(i);
			if(threadSummaryNode.getNodeType() == Node.ELEMENT_NODE)
			{
				Element threadSummaryElement = (Element) threadSummaryNode;
				String totThreads = getTagValue("Totalthreads", threadSummaryElement);
				totalNum = Integer.parseInt(totThreads);
				String  runThreads = getTagValue("RunnableThreads", threadSummaryElement);
				numLive = Integer.parseInt(runThreads);
				String  blockThreads = getTagValue("Blockedthreads", threadSummaryElement);
				numBlocked = Integer.parseInt(blockThreads);
				String  wtngThreads = getTagValue("Waitingthreads", threadSummaryElement);
				numWaiting = Integer.parseInt(wtngThreads);
				String  twtngThreads = getTagValue("Timedwaitingthreads", threadSummaryElement);
				numTimedWaiting = Integer.parseInt(twtngThreads);
				String  peakThreads = getTagValue("Peakthreads", threadSummaryElement);
				numPeakCount = Long.parseLong(peakThreads);
				String totStrtThreads = getTagValue("Totalstartedthreads", threadSummaryElement);
				totalStarted = Long.parseLong(totStrtThreads);
				String  dedlocThreads = getTagValue("Deadlockthreads", threadSummaryElement);
				deadLockThreads = Integer.parseInt(dedlocThreads);
				String DedLockIds = getTagValue("DeadlockIds", threadSummaryElement);
				String  jvmThreads = getTagValue("JVMCPU", threadSummaryElement);
				cpuUsage = Double.parseDouble(jvmThreads);
				if(DedLockIds != null && DedLockIds.length() > 0)
				{
					StringTokenizer st = new StringTokenizer(DedLockIds,",");
					while(st.hasMoreTokens())
					{
						String dedLockToken = st.nextToken();
						deadLockIdList.add(dedLockToken);
					}
				}
			}
		}
		NodeList threadInfoLst = doc.getElementsByTagName("ThreadsInfoNode");
		int length = threadInfoLst.getLength();
		for(int i=0;i<threadInfoLst.getLength();i++)
		{
			Node threadInfoNode = threadInfoLst.item(i);
			if(threadInfoNode.getNodeType() == Node.ELEMENT_NODE)
			{
				Element threadInfoElement = (Element) threadInfoNode;
				String thread_name = getTagValue("ThreadName", threadInfoElement);
				String  thread_id = getTagValue("ThreadId", threadInfoElement);
				String  thread_state = getTagValue("ThreadState", threadInfoElement);
				String  thread_cpu = getTagValue("CpuTime", threadInfoElement);
				String thread_perc = getTagValue("PercentageCpuTime", threadInfoElement);
				String  blocked_count = getTagValue("BlockedCount", threadInfoElement);
				String  block_time = getTagValue("BlockedTime", threadInfoElement);
				String perc_block_time = getTagValue("PercentageBlockedTime", threadInfoElement);
				String  waiting_count = getTagValue("WaitedCount", threadInfoElement);
				String waiting_time = getTagValue("WaitedTime", threadInfoElement);
				String perc_waiting_time = getTagValue("PercentageWaitedTime", threadInfoElement);
				String  stack_trace = getTagValue("StackTrace", threadInfoElement);

				String thread_info = thread_name+"~"+thread_id+"~"+thread_state+"~"+thread_cpu+"~"+thread_perc+"~"+blocked_count+"~"+block_time+"~"+perc_block_time+"~"+waiting_count+"~"+waiting_time+"~"+perc_waiting_time+"~"+stack_trace;

				allthreads_info.add(thread_info);

				if(thread_state.startsWith("RUNNABLE"))
				{
					runnable_info.add(thread_info);
				}
				else if(thread_state.startsWith("BLOCKED"))
				{
					blocked_info.add(thread_info);
					if(deadLockIdList!=null && deadLockIdList.contains(thread_id))
					{
						deadockThreads.add(thread_info);
					}
				}
				else if(thread_state.startsWith("WAITING"))
				{
					waiting_info.add(thread_info);
				}
				else if(thread_state.startsWith("TIMED_WAITING"))
				{
					timedWaiting_info.add(thread_info);
				}
			}
		}
	}

	ArrayList sortedList = sortPercentageCPUTime(allthreads_info,12,clm);
	ArrayList sortedRunnableList = sortPercentageCPUTime(runnable_info,12,clm);
	ArrayList sortedBlockedList = sortPercentageCPUTime(blocked_info,12,clm);
	ArrayList sortedWaitingList = sortPercentageCPUTime(waiting_info,12,clm);
	ArrayList sortedTimedWaitingList = sortPercentageCPUTime(timedWaiting_info,12,clm);
	ArrayList sortedDeadLockList = sortPercentageCPUTime(deadockThreads,12,clm);

	for(int i=0;i<sortedList.size();i=i+12)
	{
		String tmpStr = (String)sortedList.get(i);
		String tId = (String) sortedList.get(i+1);
		threadNamesList.add(tmpStr+"*:*"+tId);
	}
	if(threadNamesList.size() == 0)
	{
		threadNamesList.add("Nil:*:Nil");
	}

	ht.put("Runnable threads",sortedRunnableList);
	ht.put("Blocked threads",sortedBlockedList);
	ht.put("Timed Waiting threads",sortedTimedWaitingList);
	ht.put("Waiting threads",sortedWaitingList);
	ht.put("Deadlock threads",sortedDeadLockList);

	//XML file creation....(Start)
	if(realTime)
	{
		try
		{
			DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder docBuilder = builderFactory.newDocumentBuilder();
			//creating a new instance of a DOM to build a DOM tree.
			Document doc = docBuilder.newDocument();	

			ArrayList summayList = new ArrayList();
			Hashtable summayTable = new Hashtable();
			summayList.add("Totalthreads"); 
			summayTable.put("Totalthreads",Integer.toString(totalNum));
			summayList.add("RunnableThreads"); 
			summayTable.put("RunnableThreads",Integer.toString(numLive));
			summayList.add("Blockedthreads"); 
			summayTable.put("Blockedthreads",Integer.toString(numBlocked));
			summayList.add("Waitingthreads");
			summayTable.put("Waitingthreads",Integer.toString(numWaiting));
			summayList.add("Timedwaitingthreads");	summayTable.put("Timedwaitingthreads",Long.toString(numTimedWaiting));
			summayList.add("Peakthreads"); 
			summayTable.put("Peakthreads",Long.toString(numPeakCount));
			summayList.add("Totalstartedthreads"); 
			summayTable.put("Totalstartedthreads",Long.toString(totalStarted));
			summayList.add("Deadlockthreads");
			summayTable.put("Deadlockthreads",Integer.toString(deadLockThreads));
			summayList.add("DeadlockIds");
			summayTable.put("DeadlockIds",sb.toString());
			summayList.add("JVMCPU");
			summayTable.put("JVMCPU",Double.toString(cpuUsage));

			Element rootElement  = doc.createElement("ThreadDetails");
			doc.appendChild(rootElement );
			Element summaryElement  = doc.createElement("ThreadSummary");
			rootElement.appendChild(summaryElement);
			for(int k=0;k<summayList.size();k++)
			{
				String childElement = (String) summayList.get(k);
				String childValue = (String) summayTable.get(childElement);

				Element subChild = doc.createElement(childElement);
				Text textNode = doc.createTextNode(childValue);
				subChild.appendChild(textNode);
				summaryElement.appendChild(subChild);
			}

			Element InfoElement = doc.createElement("ThreadInfo");
			rootElement.appendChild(InfoElement);

			ArrayList infoList = new ArrayList();
			infoList.add("ThreadName");
			infoList.add("ThreadId");
			infoList.add("ThreadState");
			infoList.add("CpuTime");
			infoList.add("PercentageCpuTime");
			infoList.add("BlockedCount");
			infoList.add("BlockedTime");
			infoList.add("PercentageBlockedTime");
			infoList.add("WaitedCount");
			infoList.add("WaitedTime");
			infoList.add("PercentageWaitedTime");
			infoList.add("StackTrace");

			for(int k=0;k<sortedList.size();k=k+12)
			{
				String t_name = (String) sortedList.get(k);
				String t_id = (String) sortedList.get(k+1);
				String t_state = (String) sortedList.get(k+2);
				String t_cpu = (String) sortedList.get(k+3);
				String t_per_cpu = (String) sortedList.get(k+4);
				String t_block = (String) sortedList.get(k+5);
				String t_block_time = (String) sortedList.get(k+6);
				String t_per_block = (String) sortedList.get(k+7);
				String t_wait = (String) sortedList.get(k+8);
				String t_wait_time = (String) sortedList.get(k+9);
				String t_per_wait = (String) sortedList.get(k+10);
				String t_stack = (String) sortedList.get(k+11);

				Hashtable InfoTable = new Hashtable();
				InfoTable.put("ThreadName",t_name);
				InfoTable.put("ThreadId",t_id);
				InfoTable.put("ThreadState",t_state);
				InfoTable.put("CpuTime",t_cpu);
				InfoTable.put("PercentageCpuTime",t_per_cpu);
				InfoTable.put("BlockedCount",t_block);
				InfoTable.put("BlockedTime",t_block_time);
				InfoTable.put("PercentageBlockedTime",t_per_block);
				InfoTable.put("WaitedCount",t_wait);
				InfoTable.put("WaitedTime",t_wait_time);
				InfoTable.put("PercentageWaitedTime",t_per_wait);
				InfoTable.put("StackTrace",t_stack);
				Element threadElement = doc.createElement("ThreadsInfoNode");
				for(int y=0;y<infoList.size();y++)
				{
					String infoString = (String) infoList.get(y);
					String infoValue = (String) InfoTable.get(infoString);

					Element thisElement = doc.createElement(infoString);
					Text thisText = doc.createTextNode(infoValue);
					thisElement.appendChild(thisText);
					threadElement.appendChild(thisElement);
				}
				InfoElement.appendChild(threadElement);
			}
			//TransformerFactory instance is used to create Transformer objects. 
			TransformerFactory factory = TransformerFactory.newInstance();
			Transformer transformer = factory.newTransformer(); 
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");
			transformer.setOutputProperty(OutputKeys.ENCODING, "ISO-8859-1");
			// create string from xml tree
			StringWriter sw = new StringWriter();
			StreamResult result = new StreamResult(sw);
			DOMSource source = new DOMSource(doc);
			transformer.transform(source, result);
			String xmlString = sw.toString();
			String fileName = EgInstallInfo.getInstallDir() + "/tmp/stackXml.xml";
			File file = new File(fileName);
			BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
			bw.write(xmlString);
			bw.flush();
			bw.close();
		}
		catch(Exception e)
		{
			System.out.println("Exception Occured in XML.......");
			e.printStackTrace();
		}
	}
	//XML file creation ....(End)
%>
		<table cellspacing="0" id="eg_subcontentbg" cellpadding="0" width="100%" border="0">
			<tr>
				<td width="100%" align="center">
					<table cellspacing="0" cellpadding="0" width="90%" border="0">
						<tr>
							<td colspan="3" width="100%">
								<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
									<tr>
										<td id="subhead_left" width="7"><img border="0" width="7" src="/final/admin/eg_images/spacer.gif"></td>
										<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;padding:4px" align="center" width="100%"><b>eG Manager Threads</b></td>
										<td id="subhead_right" width="7"><img border="0" width="7" src="/final/admin/eg_images/spacer.gif" ></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td colspan="3" width="100%">
								<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" id="cell_border1" style="border-bottom-width:0px">
								<col width="3%"><col width="30%"><col width="10%"><col width="3%"><col width="30%"><col width="10%">
									<tr>
										<td id="linebottomright"><img src="/final/admin/eg_images/right.gif"></td>
										<td id="linebottomright">Total threads (Number)</td>
										<td id="linebottomright"><%=totalNum%></td>
										<td id="linebottomright"><img src="/final/admin/eg_images/right.gif"> </td>
										<td id="linebottomright">Runnable threads (Number)</td>
										<td id="linebottom"><%=numLive%></td>
									</tr>
									<tr>
										<td id="linebottomright"><img src="/final/admin/eg_images/right.gif"></td>
										<td id="linebottomright">Blocked threads (Number)</td>
										<td id="linebottomright"><%=numBlocked%></td>
										<td id="linebottomright"><img src="/final/admin/eg_images/right.gif"></td>
										<td id="linebottomright">Waiting threads (Number)</td>
										<td id="linebottom"><%=numWaiting%></td>
									</tr>
									<tr>
										<td id="linebottomright"><img src="/final/admin/eg_images/right.gif"></td>
										<td id="linebottomright">Timed waiting threads (Number)</td>
										<td id="linebottomright"><%=numTimedWaiting%></td>
										<td id="linebottomright"><img src="/final/admin/eg_images/right.gif"></td>
										<td id="linebottomright">Peak threads (Number) </td>
										<td id="linebottom"><%=numPeakCount%></td>
									</tr>
									<tr>
										<td id="linebottomright"><img src="/final/admin/eg_images/right.gif"></td>
										<td id="linebottomright">Total started threads (Number) </td>
										<td id="linebottomright"><%=totalStarted%></td>
										<td id="linebottomright"><img src="/final/admin/eg_images/right.gif"></td>
										<td id="linebottomright">Deadlock threads (Number)  </td>
										<td id="linebottom"><%=deadLockThreads%></td>
									</tr>
									<tr>
										<td id="linebottomright"><img src="/final/admin/eg_images/right.gif"></td>
										<td id="linebottomright">Cpu utilization of JVM (Percent) </td>
										<td id="linebottomright"><%=df.format(cpuUsage)%></td>
										<td id="linebottomright">&nbsp;</td>
										<td id="linebottomright">&nbsp;</td>
										<td id="linebottom">&nbsp;</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td colspan="3" class="eg_blankspace" height="10">&nbsp;</td>
						</tr>
						<tr>
							<td width="100%" align="center" colspan="3">
								<table align="center" cellspacing="0" cellpadding="0" width="100%"border="0">
									<tr>
										<td id="subhead_left" width="7"><img  border="0" width="7" src="/final/admin/eg_images/spacer.gif"></td>
										<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;padding:1px" align="center" width="100%"><b>Thread Details </b>&nbsp;&nbsp;&nbsp; @ &nbsp; <%=date%>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Sort By :<SELECT name="sortOption" id="sortOption" onchange="setSorted(this.value,'<%=testFile%>','<%=xmlFileName%>')">
<%
	String tdName = "";
	String tdState = "";
	String tdCpu = "";
	if(clm == 1)
		tdName = "selected";
	else if(clm ==3)
		tdState = "selected";
	else
		tdCpu = "selected";
%>
												<option value="1" <%=tdName%>>Thread Name</option>
												<option value="3" <%=tdState%>>Thread State</option>
												<option value="5" <%=tdCpu%>>Thread CPU</option>
											</select>
										</td>
										<input type="hidden" name="sortColumn" id="sortColumn" value="<%=clm%>">
										<td id="subhead_right" width="7"><img border="0" width="7" src="/final/admin/eg_images/spacer.gif"></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td colspan="3" height="100%" valign="top">
								<table align="left" cellspacing="0" cellpadding="4" border="0"  width="100%">
									<tr>
										<td height="100%" valign="top" class="linesquare space6 eg_whitebg" >
											<SELECT NAME="threadname" id="threadname" size="28" style="width:250px;height:400px;" onChange="javaScript:showDetails(this.value,'<%=sortedList%>')">
<%
	int count =threadNamesList.size();
	if(count==1) 
	{
		if(threadNamesList.contains("Nil*:*Nil"))
			count=0;
	}
	for(int k=0;k<threadNamesList.size();k++)
	{
		String tmpName= (String)threadNamesList.get(k);
		String displayThreadName = tmpName.substring(0,tmpName.indexOf("*:*"));
		String selected="";
		selected = (k==0)?"selected":"";
%>
												<OPTION VALUE="<%=tmpName%>" <%=selected%> title='No of Threads=<%=count%>'><%=displayThreadName%></option>
<%
	}
%>
											</SELECT>
										</td>
										<td style="padding:0px" style="width:6px" class="linebottomtop"> <img src = "/final/monitor/eg_images/spacer.gif" width="6px"></td>
										<td valign="top" class="linesquare eg_whitebg" width="100%" style="padding:0px" ><form name="ThreadForm" style="margin:0px;padding:0px" id="ThreadForm"> <div id ="ThreadDiv" class="div_scroll" style="border:0px solid #ff0000;height:400px;width:100%"></div> </form> </td>
									</tr>
									<tr>
										<td colspan="3" class="eg_blankspace" height="10">&nbsp;</td>
									</tr>
<%
	if(ht != null && ht.size() > 0 && ht.size() == 5)
	{
		String tkey ="";
		for(int k=1;k<=ht.size();k++)
		{
			switch(k)
			{
				case 1: tkey = "Runnable threads" ; break;
				case 2: tkey = "Blocked threads" ; break;
				case 3: tkey = "Waiting threads" ; break;
				case 4: tkey = "Timed Waiting threads" ; break;
				case 5: tkey = "Deadlock threads" ; break;
			}
			ArrayList arrList = (ArrayList) ht.get(tkey);
			if(arrList!=null && arrList.size() > 0 )
			{
%>
									<tr>
										<td width="100%" align="center" colspan="3">
											<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" >
												<tr>
													<td >
														<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
															<tr>
																<td id="subhead_left" width="7"><img border="0" width="7" src="/final/admin/eg_images/spacer.gif"></td>
																<td id="eg_subheadbg" style="border-left-width: 0px; border-right-width: 0px;padding:4px" align="center" width="100%"><b><%=tkey%></b>&nbsp;&nbsp;&nbsp; @ &nbsp; <%=date%></b></td>
																<td id="subhead_right" width="7"><img border="0" width="7" src="/final/admin/eg_images/spacer.gif" ></td>
															</tr>
														</table>
													</td>
												</tr>
												<tr>
													<td >
														<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" class="cell_border1" style="border-bottom-width:0px"><col width="35%"><col width="65%">
															<tr>
																<td align="center" class="table_head"><b> Thread Name	</b></td>
																<td align="center" class="table_head"><b> StackTrace</b></td>
															</tr>
<%
				for(int y=0;y<arrList.size();y=y+12)
				{
					String tName = (String)arrList.get(y);
					String state = (String)arrList.get(y+2);
					String sTrace = (String)arrList.get(y+11);
%>
															<tr>
																<td id="linebottomright" style="word-break:break-all;"><b><%=tName%></b>
<%
					if(!state.equals("RUNNABLE") && !state.equals("TIMED_WAITING"))
					{
%>
																	<br><br><%=state%>
<%
					}
%>
																</td>
																<td id="linebottomright"><%=sTrace%></td>
															</tr>
<%
				}
%>
														</table>
													</td>
												</tr>
											</table>
										</td>
									</tr>
									<tr>
										<td colspan="3" class="eg_blankspace" height="10">&nbsp;</td>
									</tr>
<%
			}
		}
	}
%>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
<%
	if(threadNamesList.size() >0 && threadNamesList != null)
	{
%>
		<script type="text/javascript">
			var t=setTimeout("showDetails('<%=(String)threadNamesList.get(0)%>','<%=sortedList%>')",0)
			var x = document.getElementById("threadname");
			x.selectedIndex=0;
		</script>
<%
	}
}
catch(Exception e)
{
	System.out.println("Exception in EgStack.jsp....");
	e.printStackTrace();
}
%>
	</body>
</html>



