<%
/******************************************************************************
*	Name			:	addDefaultAggTests.jsp
*	Purpose			:	used to create default aggregate tests
*	Version			:	5.2
*	Creation Date	:	18th January 2011
*	Author			:	James Thomas P
******************************************************************************/
%>
<%@ page import = "com.eg.*"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "java.util.*"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%

	String sessionInUse = request.getParameter("sessionInUse");
	if(sessionInUse == null || sessionInUse.equals("null") )
	{
		String redirectURL = request.getContextPath()+"/toolkit?reqFrom=aggsupport&tools=aggsupport";
		response.sendRedirect(redirectURL);
	}

	EgMappingInfo mappingInfo = new EgMappingInfo("en_US");
	boolean browser = false;
	String ua = request.getHeader("user-agent");
	browser = (!StringUtils.isNull(ua) && ua.indexOf("MSIE") > -1)?true:false;

	String test = request.getParameter("s_tests");
	String operation = request.getParameter("operation");

	String s_component_type = request.getParameter("s_component_type");
	s_component_type=StringUtils.isNull(s_component_type)?"-1":s_component_type;

	ArrayList testList = new ArrayList();
	EgSpecsInfo egSpecsInfo = new EgSpecsInfo("manager");
	EgTablesInfo tableConfig = new EgTablesInfo("manager");
	EgThresholdInfo threshConfig = new EgThresholdInfo("manager");
	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");

	ArrayList componentTypes = new ArrayList();
	componentTypes.add(s_component_type);
	String comp_tests[] = egSpecsInfo.getDefaultTestsForServer(s_component_type);
	ArrayList templates = new ArrayList();
	if(comp_tests != null && comp_tests.length>0)
	{
		Vector temp = (Vector)aggregateInfo.getAllValues("PRE_DEFINED_AGGREGATE_TEST").clone();
		for(int i=0;i<comp_tests.length;i++)
		{
			String s = comp_tests[i];
			if(s.endsWith("_ex") || s.endsWith("_cf") || temp.contains(s))
			{
				continue;
			}
			testList.add(s);
		}
	}
	Hashtable testMeasureHt = new Hashtable();
	String s_tests_array[] = StringUtils.getTokens(test,",");
	for(int i=0;i<s_tests_array.length;i++)
	{
		String temptest = s_tests_array[i];
		String s_measures[] = threshConfig.getMeasurementsForTest(temptest);
		testMeasureHt.put(temptest,s_measures);
	}

	String descriptorAggregation = "no";
	MappingNameSorter sorter = new MappingNameSorter("en_US");
	testList = sorter.getSortedTestList(testList);

	String minArray[] = aggregateInfo.getVariables("MIN");
	String maxArray[] = aggregateInfo.getVariables("MAX");
	String avgArray[] = aggregateInfo.getVariables("AVG");
	String sumArray[] = aggregateInfo.getVariables("SUM");
	String avgSumArray[] = aggregateInfo.getVariables("AVG_SUM");

	Vector minV = new Vector();
	Vector maxV = new Vector();
	Vector avgV = new Vector();
	Vector sumV = new Vector();
	Vector avgSumV = new Vector();

	if(minArray != null && minArray.length>0)
	{
		minV.addAll(Arrays.asList(minArray));
	}
	if(maxArray != null && maxArray.length>0)
	{
		maxV.addAll(Arrays.asList(maxArray));
	}
	if(avgArray != null && avgArray.length>0)
	{
		avgV.addAll(Arrays.asList(avgArray));
	}
	if(sumArray != null && sumArray.length>0)
	{
		sumV.addAll(Arrays.asList(sumArray));
	}
	if(avgSumArray != null && avgSumArray.length>0)
	{
		avgSumV.addAll(Arrays.asList(avgSumArray));
	}

	String avg_desc = mappingInfo.getTextDescription("admin.common.avg");
	String avg_sum_desc = mappingInfo.getTextDescription("admin.common.avg_sum");
	String min_desc = mappingInfo.getTextDescription("admin.common.min");
	String max_desc = mappingInfo.getTextDescription("admin.common.max");
	String sum_desc = mappingInfo.getTextDescription("admin.common.sum");

	Hashtable fnMapping = new Hashtable();
	fnMapping.put("avg",avg_desc);
	fnMapping.put("avg_sum",avg_sum_desc);
	fnMapping.put("min",min_desc);
	fnMapping.put("max",max_desc);
	fnMapping.put("sum",sum_desc);

	Hashtable testMapping = new Hashtable();
%>
<html>
<head>
<link REL = "StyleSheet" href = "/final/admin/eg_styles/adminstyle_blue.css"/>
<script language="javascript" src="/final/admin/eg_scripts/timeout.js"></script>
<script language="javascript">
function changeTestNames(a)
{
	var thisForm = document.list;
	var val="";
	for(i=0;i<thisForm.avail_tests.options.length;i++)
	{
		if(thisForm.avail_tests.options[i].selected)
		{
			val += thisForm.avail_tests.options[i].value+",";
		}
	}
	if(val.length>0)
	{
		thisForm.s_tests.value = val.substring(0,val.lastIndexOf(","));
		thisForm.action = "addDefaultAggTests.jsp?sessionInUse=true";
		thisForm.submit();
	}
}
function update()
{
	var measuresSelected = "false";
	var thisForm = document.list;
	for(var i=0;i<thisForm.elements.length;i++)
	{
		if(thisForm[i].type=="checkbox" && thisForm[i].checked)
		{
			measuresSelected = "true";
			break;
		}
	}
	if(measuresSelected == "false")
	{
		alert("Please select measure(s) to aggregate test(s).");
	}
	else
	{
		thisForm.action="addDefaultAggTestsp.jsp?sessionInUse=true";
		thisForm.submit();
	}
}
function updateSelectAllCheckboxStatus(from)
{
	var key = from.substring(0,from.indexOf('$')+1);
	var key2 = from.substring(from.indexOf('$')+1);
	state = true;
	var thisForm = document.list;
	for(var i=0;i<thisForm.elements.length;i++)
	{
		if(thisForm.elements[i].type=='checkbox' && thisForm.elements[i].name.indexOf(key+"all")!=0 && thisForm.elements[i].id.indexOf(from)==0)
		{
			if(!thisForm.elements[i].checked)
			{
				state = false;
				break;
			}
		}
	}
	thisForm.elements[key+'all'+key2].checked = state;
}
function selectAllCheckboxes(status,from,managersCount)
{
	for(var i=0;i<managersCount;i++)
	{
		var thisCheckBox=document.getElementById(from+i);
		if(thisCheckBox==null || thisCheckBox=="undefined")
		{
			continue;
		}
		if(status != null)
		{
			if(!thisCheckBox.disabled)
			{
				thisCheckBox.checked=status;
			}
		}
	}
}
function goback()
{
	window.location.href = "/final/misc/defaultAggTests.jsp?sessionInUse=true&s_component_type=<%=s_component_type%>";
}
</script>
</head>
<body style="overflow:auto" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0">
	<form name="list" method="POST" action="javascript:update();" style="margin:0px">
		<input type="hidden" name="operation" value="<%=operation%>">
		<input type="hidden" name="s_component_type" value="<%=s_component_type%>">
		<input type="hidden" name="s_tests" value="">
		<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
			<tr>
				<td width="100%">
					<table border="0" cellspacing="0" cellpadding="0" width="100%">
						<tr>
							<td height="20" align="left" class="eg_cellbglits" colspan="2">
								<table width="100%" align="center" cellspacing="0" cellpadding="4" border="0">
									<tr>
										<td align="right" width="40%" nowrap><img src="/final/admin/eg_images/info2.gif"> </td>
										<td align="left" width="50%" height="24" nowrap>This page is used to add default aggregate tests</td>
										<td width="10%" nowrap align="center"><input type="button" value='<egui:intnl text="admin.common.Back"/>' style="width:80px" class="eg_lightbutton" onClick="javascript:goback();"></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td background="/final/admin/eg_images/in_titleshadowbg1.gif" height="7" id="eg_blankspace" width="100%" colspan="2">&nbsp;</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td width="100%" id="eg_whitebg" align="center" height="100%" valign="middle">
					<table align="center" cellspacing="0" cellpadding="0" width="50%" border="0" style="table-layout:auto">
						<tr>
							<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							<td height="6" id="eg_subcontentbg" width="100%" colspan="6"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
							<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
						</tr>
						<tr>
							<td class="eg_subcontentbg" id="form_border">&nbsp;</td>
							<td align="left" width="142" class="eg_subcontentbg" nowrap height="20" id="form_border"><egui:intnl text="admin.threshold.Component type"/></td>
							<td width="5" class="eg_subcontentbg" id="form_border">:</td>
							<td class="eg_subcontentbg" id="form_border" style="padding-left:10px;"><b><%=((EgName)sorter.getSortedCompTypeList(componentTypes).get(0)).getLocalName()%></b></td>
							<td colspan="4" class="eg_subcontentbg" id="form_border">&nbsp;</td>
						</tr>
						<tr>
							<td class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
							<td align="left" width="170" class="eg_subcontentbg" nowrap height="20" id="form_spacing" valign="top"><egui:intnl text="admin.threshold.Tests to be aggregated"/></td>
							<td width="5" class="eg_subcontentbg" id="form_spacing" valign="top">:</td>
							<td class="eg_subcontentbg" id="form_spacing" style="padding-left:10px;" width="73%">
								<select name="avail_tests" style='width:<%=browser?"285":"298"%>px' <%=testList.size()>5?"size=\'10\'":"size=\'5\'"%> onchange="javascript:changeTestNames();">
<%
								for(int i=0;i<testList.size();i++)
								{
									EgName egName=(EgName)testList.get(i);
									String actualName=egName.getActualName();
									String localName = egName.getLocalName();
									String sel = testMeasureHt.containsKey(actualName)?"selected":"";
									testMapping.put(actualName,localName);
%>
									<option value='<%=actualName%>' <%=sel%>><%=localName%></option>
<%
								}
%>
								</select>
							</td>
							<td colspan="4" class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
						</tr>
						<tr>
							<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
							<td id="eg_subcontentbg" width="100%" colspan="6" valign="top"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
							<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
						</tr>
<%
			String allCheckboxSelection = "checked";
			String defaultTemplate = "no";
			Iterator itr = testMeasureHt.keySet().iterator();
			while(itr.hasNext())
			{
				String sitn = (String)itr.next();//selected individual test name
				String measures_available[] = (String[])testMeasureHt.get(sitn);
				if(measures_available == null || measures_available.length == 0)
				{
					continue;
				}
				boolean isSiteRelevantForTest = egSpecsInfo.isSiteRelevantForTest(sitn);
%>
						<tr>
							<td class="eg_subcontentbg">&nbsp;</td>
							<td width="142" nowrap height="20" class="eg_subcontentbg" align="left"> 
							<egui:intnl text="admin.threshold.Selected test name"/></td>
							<td width="5" class="eg_subcontentbg">:</td>
							<td class="eg_subcontentbg" style="padding-left:10px;"><b><%=testMapping.get(sitn)%></b></td>
							</td>
						</tr>
<%
				if(isSiteRelevantForTest)
				{
%>
					<input type="hidden" name="<%=sitn%>$siteOrientedTest" value="true" checked>
<%
				}
%>
						<tr>
							<td class="eg_subcontentbg">&nbsp;</td>
							<td width="142" nowrap height="22" class="eg_subcontentbg" align="left"><egui:intnl text="admin.threshold.Report by descriptors"/></td>
							<td width="5" class="eg_subcontentbg">:</td>
							<td class="eg_subcontentbg" style="padding-left:10px;">
								<table width="38%" cellspacing="0" cellpadding="0" border="0">
									<tr>
										<td class="eg_morelight" width="20">
											<input type="radio" class="eg_input" name="<%=sitn%>descriptorAggregation" value="true" <%=descriptorAggregation.equals("yes")?"checked":""%>>
										</td>
										<td class="eg_morelight"><egui:intnl text="admin.common.Yes"/></td>
										<td class="eg_morelight" width="20">
											<input type="radio" class="eg_input" name="<%=sitn%>descriptorAggregation" value="false" <%=descriptorAggregation.equals("no")?"checked":""%>>
										</td>
										<td class="eg_morelight"><egui:intnl text="admin.common.No"/></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td class="eg_subcontentbg">&nbsp;</td>
							<td width="142" nowrap height="22" class="eg_subcontentbg" align="left"><egui:intnl text="admin.threshold.Enable this test by default"/></td>
							<td width="5" class="eg_subcontentbg">:</td>
							<td class="eg_subcontentbg" style="padding-left:10px;">
								<table width="38%" cellspacing="0" cellpadding="0" border="0">
									<tr>
										<td class="eg_morelight" width="20">
											<input type="radio" class="eg_input" name="<%=sitn%>default_enabled_template" value="true" <%=defaultTemplate.equals("yes")?"checked":""%>>
										</td>
										<td class="eg_morelight"><egui:intnl text="admin.common.Yes"/></td>
										<td class="eg_morelight" width="20">
											<input type="radio" class="eg_input" name="<%=sitn%>default_enabled_template" value="false" <%=defaultTemplate.equals("no")?"checked":""%>>
										</td>
										<td class="eg_morelight"><egui:intnl text="admin.common.No"/></td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td id="eg_blankspace" height="10">&nbsp;</td>
			</tr>
			<tr>
				<td>
					<table align="center" cellspacing="0" cellpadding="0" width="85%" border="0" style="table-layout:fixed">
						<tr>
							<td id="table_border" class="eg_morelight">
								<table align="center" width="100%" cellspacing="0" cellpadding="3" border="0" id="cell_border1"><col width="3%"><col width="77%"><col width="19%"><col width="1%">
									<tr>
										<td id="table_head" style="padding-left:6px;padding-right:6px" align="right" height="20"><input type="checkbox" id="<%=sitn%>$allmanagedManagerCheckbox" name="<%=sitn%>$allmanagedManagerCheckbox" value="selectAll" class="eg_input" style="border:0px" onClick="javascript:selectAllCheckboxes(this.checked,'<%=sitn%>$managedManagerCheckbox','<%=measures_available.length%>');" <%=allCheckboxSelection%>></td>
										<td id="table_head" align="left"><b><egui:intnl text="admin.common.Available Measures Name"/></b><br></td>
										<td id="table_head" align="center"><b><egui:intnl text="admin.common.Aggregate Function"/></b></td>
										<td id="table_head" align="center">&nbsp;</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td id="table_border" class="padding6 eg_morelight">
								<table align="center" width="100%" cellspacing="0" cellpadding="3" border="2" id="cell_border1"><col width="2%"><col width="78%"><col width="20%">
<%
										String AGGREGATE_FUNCTIONS[] = aggregateInfo.getGroupFunctions();
										for(int i=0;i<measures_available.length;i++)
										{
											String measure = measures_available[i];
											String id=(i%2==0)?"cell_border3":"cell_border4";
											String unit = tableConfig.getUnitForMeasure(test,measure);
											String defaultFunction="-1";
											if(minV.contains(unit))
											{
												defaultFunction = "min";
											}
											else if(maxV.contains(unit))
											{
												defaultFunction = "max";
											}
											else if(sumV.contains(unit))
											{
												defaultFunction = "sum";
											}
											else if(avgSumV.contains(unit) || unit.indexOf("/")>0)
											{
												defaultFunction = "avg_sum";
											}
											else
											{
												defaultFunction = "avg";
											}
%>
									<tr>
										<td id="<%=id%>" class="space3" height="22"><input type="checkbox" id="<%=sitn%>$managedManagerCheckbox<%=i%>" name="<%=sitn+"$"+measure+"$msr"%>" value="<%=measure%>" class="eg_input" style="border:0px" onclick="updateSelectAllCheckboxStatus('<%=sitn%>$managedManagerCheckbox');" checked></td>
										<td id="<%=id%>" class="space3"><%=mappingInfo.getMeasureDescription(test,measure)%></td>
										<td id="<%=id%>" class="space3" align="center">
											<select id='<%=sitn+"$"+measure%>' name='<%=sitn+"$"+measure+"$fun"%>' style="width:150px">
												 <option value="-1" <%=defaultFunction.equals("-1")?"selected":""%>><egui:intnl text="admin.ic.Select a function"/></option> 
<%
											for(int j=0;j<AGGREGATE_FUNCTIONS.length;j++)
											{
												String fn = AGGREGATE_FUNCTIONS[j];
												if (fnMapping.get(fn) != null)
												{
%>
													<option value='<%=fn%>' <%=defaultFunction.equals(fn)?"selected":""%>> <%=fnMapping.get(fn).toString()%></option>
<%
												}
												
											}
%>
											</select>
										</td>
									</tr>
<%
										}
%>
								</table>
							</td>
						</tr>
						<tr>
							<td id="eg_blnkspace" height="10">&nbsp;</td>
						</tr>
					</table>
				</td>
			</tr>
<%
			}
%>
			<tr>
				<td align="center"><input type="button" value='<egui:intnl text="admin.common.Add"/>' style="width:80px" class="eg_darkbutton" onClick="javascript:update();">&nbsp;&nbsp;<input type="button" value='<egui:intnl text="admin.common.Back"/>' style="width:80px" class="eg_darkbutton" onClick="javascript:goback();"></td>
			</tr>
			<tr>
				<td id="eg_blankspace" height="10">&nbsp;</td>
			</tr>
		</table>
	</form>
</body>
</html>



