<%
/******************************************************************************
*	Name			:	modifyDefaultAggTest.jsp
*	Purpose			:	used to modify already created aggregate tests
*	Version			:	5.2
*	Creation Date	:	18th January 2011
*	Author			:	James Thomas P
******************************************************************************/
%>
<%@ page import = "com.eg.*"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "java.util.*"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%

	String sessionInUse = request.getParameter("sessionInUse");
	if(sessionInUse == null || sessionInUse.equals("null") )
	{
		String redirectURL = request.getContextPath()+"/toolkit?reqFrom=aggsupport&tools=aggsupport";
		response.sendRedirect(redirectURL);
	}

	EgMappingInfo _mapping = new EgMappingInfo("en_US");
	boolean browser = false;
	String ua = request.getHeader("user-agent");
	browser = (!StringUtils.isNull(ua) && ua.indexOf("MSIE") > -1)?true:false;

	String test = request.getParameter("s_tests");
	String operation = request.getParameter("operation");
	String s_component_type = request.getParameter("s_component_type");
	s_component_type=StringUtils.isNull(s_component_type)?"-1":s_component_type;
	String[] measures = null;
	String descriptorAggregation = "no";
	Vector includedMeasures = new Vector();
	Vector excludedMeasures = new Vector();
	EgTablesInfo tableConfig = new EgTablesInfo("manager");
	EgThresholdInfo threshConfig = new EgThresholdInfo("manager");
	EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
	ArrayList componentTypes = null;

	String s_aggtest = aggregateInfo.getRelatedAggregateTest(test);
	IniFile specsini = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_specs.ini");
	Vector TEST_SPECIFICATION_VARS = (Vector)specsini.getVariables("TEST_SPECIFICATION",true).clone();
	Vector TEST_SPECIFICATION_VALS = (Vector)specsini.getAllValues("TEST_SPECIFICATION").clone();
	for(int i=0;i<TEST_SPECIFICATION_VARS.size();i++)
	{
		String s = (String)TEST_SPECIFICATION_VARS.get(i);
		if(s!= null && s.startsWith(s_aggtest+":"))
		{
			s = (String) TEST_SPECIFICATION_VALS.get(i);
			String key = "-aggregateDescriptor";
			s = s.substring(s.indexOf(key)+key.length()).trim();
			s = s.substring(0,s.indexOf(" "));
			if(s.equals("true"))
			{
				descriptorAggregation = "yes";
			}
			break;
		}
	}
	TEST_SPECIFICATION_VARS.clear();
	TEST_SPECIFICATION_VALS.clear();

	Vector templateVars = aggregateInfo.getVariables(test+"_Template",true);
	if(templateVars != null && !templateVars.isEmpty())
	{
		for(int i=0;i<templateVars.size();i++)
		{
			String s = (String)templateVars.get(i);
			int index = s.indexOf(":");
			if(index==-1)
			{
				includedMeasures.clear();
				break;
			}
			includedMeasures.add(s.substring(index+1));
		}
	}
	/*
	measures = threshConfig.getMeasurementsForTest(s_aggtest);
	if(measures != null && measures.length>0)
	{
		includedMeasures.addAll(Arrays.asList(measures));
	}
	*/
	measures = threshConfig.getMeasurementsForTest(test);
	if(measures != null && measures.length>0)
	{
		for(int i=0;i<measures.length;i++)
		{
			if(!includedMeasures.contains(measures[i]))
				excludedMeasures.add(measures[i]);
		}
	}

	String minArray[] = aggregateInfo.getVariables("MIN");
	String maxArray[] = aggregateInfo.getVariables("MAX");
	String avgArray[] = aggregateInfo.getVariables("AVG");
	String sumArray[] = aggregateInfo.getVariables("SUM");
	String avgSumArray[] = aggregateInfo.getVariables("AVG_SUM");

	Vector minV = new Vector();
	Vector maxV = new Vector();
	Vector avgV = new Vector();
	Vector sumV = new Vector();
	Vector avgSumV = new Vector();

	if(minArray != null && minArray.length>0)
	{
		minV.addAll(Arrays.asList(minArray));
	}
	if(maxArray != null && maxArray.length>0)
	{
		maxV.addAll(Arrays.asList(maxArray));
	}
	if(avgArray != null && avgArray.length>0)
	{
		avgV.addAll(Arrays.asList(avgArray));
	}
	if(sumArray != null && sumArray.length>0)
	{
		sumV.addAll(Arrays.asList(sumArray));
	}
	if(avgSumArray != null && avgSumArray.length>0)
	{
		avgSumV.addAll(Arrays.asList(avgSumArray));
	}

	String avg_desc = _mapping.getTextDescription("admin.common.avg");
	String avg_sum_desc = _mapping.getTextDescription("admin.common.avg_sum");
	String min_desc = _mapping.getTextDescription("admin.common.min");
	String max_desc = _mapping.getTextDescription("admin.common.max");
	String sum_desc = _mapping.getTextDescription("admin.common.sum");
	String pct_desc = _mapping.getTextDescription("admin.common.pct");

	Hashtable fnMapping = new Hashtable();
	fnMapping.put("avg",avg_desc);
	fnMapping.put("avg_sum",avg_sum_desc);
	fnMapping.put("min",min_desc);
	fnMapping.put("max",max_desc);
	fnMapping.put("sum",sum_desc);
	fnMapping.put("pct",pct_desc);

	String defaultTemplate = "no";
	ArrayList templates = aggregateInfo.getDefaultEnbaledTemplates();
	if(templates.contains(test+"_Template"))
	{
		defaultTemplate = "yes";
	}
	boolean isSiteRelevantForTest = new EgSpecsInfo("manager").isSiteRelevantForTest(test);
	boolean showBothButtons = true;
%>
<html>
<head>
	<link REL = "StyleSheet" href = "/final/admin/eg_styles/adminstyle_blue.css"/>
	<script language="javascript" src="/final/admin/eg_scripts/timeout.js"></script>
	<script language="javascript">
	function recreateTest()
	{
		var selectedMeasures = "";
		var thisForm = window.document.list;
		var agg_test_name = '<%=s_aggtest%>';
		for(var i=0;i<thisForm.elements.length;i++)
		{
			if(thisForm[i].type=="checkbox")
			{
				if(thisForm[i].name=="allunmanagedManagerCheckbox" || thisForm[i].name=="allmanagedManagerCheckbox")
				{
					continue;
				}
				else if(thisForm[i].checked)
				{
					var msr = thisForm[i].value;
					var fun_selected = document.getElementById(msr).value;
					if(fun_selected=="-1")
					{
						selectedMeasures="";
						break;
					}
					selectedMeasures += msr + ':' + fun_selected + "$";
				}
			}
		}
		if(selectedMeasures.length>0)
		{
			selectedMeasures = selectedMeasures.substring(0,selectedMeasures.lastIndexOf("$"));
			thisForm.measureNames.value = selectedMeasures;
			thisForm.action="addDefaultAggTestsp.jsp?sessionInUse=true";
			thisForm.submit();
		}
		else
		{
			alert("Aggregate function is not selected for measure.");
		}
	}
	function updateSelectAllCheckboxStatus(from)
	{
		state = true;
		var thisForm = document.list;
		for(var i=0;i<thisForm.elements.length;i++)
		{
			if(thisForm.elements[i].type=='checkbox' && thisForm.elements[i].name.indexOf("all")!=0 && thisForm.elements[i].id.indexOf(from)==0)
			{
				if(!thisForm.elements[i].checked)
				{
					state = false;
					break;
				}
			}
		}
		thisForm.elements['all'+from].checked = state;
	}
	function selectAllCheckboxes(status,from,managersCount)
	{
		for (var i=0;i<managersCount;i++)
		{
			var thisCheckBox=document.getElementById(from+i);
			if (thisCheckBox==null || thisCheckBox=="undefined")
			{
				continue;
			}
			if(status != null)
			{
				if(!thisCheckBox.disabled)
				{
					thisCheckBox.checked=status;
				}
			}
		}
	}
	function goback()
	{
		window.location.href = "/final/misc/defaultAggTests.jsp?sessionInUse=true&s_component_type=<%=s_component_type%>";
	}
	</script>
</head>
<body style="overflow:auto" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0">
	<form name="list" method="post" action="javascript:recreateTest();" style="margin:0px">
		<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
			<tr>
				<td width="100%">
					<table border="0" cellspacing="0" cellpadding="0" width="100%">
						<tr>
							<td height="20" align="left" class="eg_cellbglits" colspan="2">
								<table width="100%" align="center" cellspacing="0" cellpadding="4" border="0">
									<tr>
										<td align="right" width="40%" nowrap><img src="/final/admin/eg_images/info2.gif"> </td>
										<td align="left" width="50%" height="24" nowrap>This page is used to modify default aggregate tests</td>
										<td width="10%" nowrap align="center"><input type="button" value='<egui:intnl text="admin.common.Back"/>' style="width:80px" class="eg_lightbutton" onClick="javascript:goback();"></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td background="/final/admin/eg_images/in_titleshadowbg1.gif" height="7" id="eg_blankspace" width="100%" colspan="2">&nbsp;</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td width="100%" id="eg_whitebg" align="center" height="100%" valign="middle">
					<table align="center" cellspacing="0" cellpadding="0" width="40%" border="0" style="table-layout:auto">
						<tr>
							<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
							<td height="6" id="eg_subcontentbg" width="100%" colspan="6"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
							<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
						</tr>
						<tr>
							<td class="eg_subcontentbg" id="form_border">&nbsp;</td>
							<td align="left" width="142" class="eg_subcontentbg" nowrap height="20" id="form_border" style="padding-left:10px;"><egui:intnl text="admin.threshold.Component type"/></td>
							<td align="right" width="5" class="eg_subcontentbg" id="form_border">:</td>
							<td class="eg_subcontentbg" id="form_border" style="padding-left:10px;"><b><%=_mapping.getComponentTypeDescription(s_component_type)%></b></td>
							<td colspan="4" class="eg_subcontentbg" id="form_border">&nbsp;</td>
						</tr>
						<tr>
							<td class="eg_subcontentbg" id="form_border">&nbsp;</td>
							<td align="left" width="142" class="eg_subcontentbg" nowrap height="20" id="form_border" style="padding-left:10px;"><egui:intnl text="admin.threshold.Test name"/></td>
							<td align="right" width="5" class="eg_subcontentbg" id="form_border">:</td>
							<td class="eg_subcontentbg" id="form_border" style="padding-left:10px;"><b><%=_mapping.getTestDescription(test)%></b></td>
							<td colspan="4" class="eg_subcontentbg" id="form_border">&nbsp;</td>
						</tr>
<%
	if(isSiteRelevantForTest)
	{
%>
						<input type="radio" name="isSiteRelevantTest" value="true">
<%
	}
%>
						<tr>
							<td class="eg_subcontentbg" id="form_border">&nbsp;</td>
							<td align="left" width="142" class="eg_subcontentbg" nowrap height="20" id="form_border" style="padding-left:10px;"><egui:intnl text="admin.threshold.Report by descriptors"/></td>
							<td align="right" width="5" class="eg_subcontentbg" id="form_border">:</td>
							<td class="eg_subcontentbg" id="form_border" style="padding-left:10px;">
								<table width="63%" cellspacing="0" cellpadding="0" border="0">
									<tr>
										<td class="eg_morelight" width="20">
											<input type="radio" class="eg_input" name="descriptorAggregation" value="true" <%=descriptorAggregation.equals("yes")?"checked":""%>>
										</td>
										<td class="eg_morelight"><egui:intnl text="admin.common.Yes"/></td>
										<td class="eg_morelight" width="20">
											<input type="radio" class="eg_input" name="descriptorAggregation" value="false" <%=descriptorAggregation.equals("no")?"checked":""%>>
										</td>
										<td class="eg_morelight"><egui:intnl text="admin.common.No"/></td>
									</tr>
								</table>
							</td>
							<td colspan="4" class="eg_subcontentbg" id="form_border">&nbsp;</td>
						</tr>
						<tr>
							<td class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
							<td align="left" width="142" class="eg_subcontentbg" nowrap height="20" id="form_spacing" style="padding-left:10px;"><egui:intnl text="admin.threshold.Enable this test by default"/></td>
							<td align="right" width="5" class="eg_subcontentbg" id="form_spacing">:</td>
							<td class="eg_subcontentbg" id="form_spacing" style="padding-left:10px;">
								<table width="63%" cellspacing="0" cellpadding="0" border="0">
									<tr>
										<td class="eg_morelight" width="20">
											<input type="radio" class="eg_input" name="default_enabled_template" value="true" <%=defaultTemplate.equals("yes")?"checked":""%>>
										</td>
										<td class="eg_morelight"><egui:intnl text="admin.common.Yes"/></td>
										<td class="eg_morelight" width="20">
											<input type="radio" class="eg_input" name="default_enabled_template" value="false" <%=defaultTemplate.equals("no")?"checked":""%>>
										</td>
										<td class="eg_morelight"><egui:intnl text="admin.common.No"/></td>
									</tr>
								</table>
							</td>
							<td colspan="4" class="eg_subcontentbg" id="form_spacing">&nbsp;</td>
						</tr>
						<tr>
							<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
							<td id="eg_subcontentbg" width="100%" colspan="6" valign="top"><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
							<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td id="eg_blankspace" height="10">&nbsp;</td>
			</tr>
<%
			if(measures != null && measures.length>0)
			{
				int disabledFnCount = includedMeasures.size();
%>
			<tr>
				<td>
					<table align="center" cellspacing="0" cellpadding="0" width="85%" border="0" style="table-layout:fixed">
						<tr>
							<td width="100%" id="eg_whitebg" class="head_padding4">
								<table align="center" width="100%" cellspacing="0" cellpadding="3" border="0"><col width="50%"><col width="50%">
									<tr>
										<td id="eg_whitebg" class="head_padding4" align="left"><egui:intnl text="admin.common.Included measures for"/>&nbsp;<b><%=_mapping.getTestDescription(s_aggtest)%></b></td>
										<td id="eg_whitebg" class="head_padding4" align="right"></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td id="table_border" class="eg_morelight">
								<table align="center" width="100%" cellspacing="0" cellpadding="3" border="0" id="cell_border1"><col width="3%">
								<col width="77%"><col width="19%">
									<tr>
										<td id="table_head" style="padding-left:6px;padding-right:6px" align="right" height="20"><input type="checkbox" name="allmanagedManagerCheckbox" value="selectAll" class="eg_input" style="border:0px" onClick="javascript:selectAllCheckboxes(this.checked,'managedManagerCheckbox',<%=measures.length%>);" checked disabled></td>
										<td id="table_head" align="left"><b><egui:intnl text="admin.common.Measures Name"/></b><br></td>
										<td id="table_head" align="center"><b><egui:intnl text="admin.common.Aggregate Function"/></b></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td id="table_border" class="padding6 eg_morelight">
								<table align="center" width="100%" cellspacing="0" cellpadding="3" border="2" id="cell_border1"><col width="2%">
								<col width="78%"><col width="20%">
<%
										String[] function_names = aggregateInfo.getGroupFunctions();
										for(int i=0;i<includedMeasures.size();i++)
										{
											String measure = (String)includedMeasures.get(i);
											String id=(i%2==0)?"cell_border3":"cell_border4";
											String defaultFunction = aggregateInfo.getValue("AGGREGATE_FUNCTION",s_aggtest+":"+measure.toUpperCase());
											if(StringUtils.isNull(defaultFunction))
											{
												defaultFunction="";
											}
											else
											{
												defaultFunction=defaultFunction.substring(defaultFunction.indexOf(":")+1,defaultFunction.lastIndexOf(":"));
											}
											String disabledStr = "";
											if(defaultFunction.equals("pct"))
											{
												disabledStr = "disabled";
												--disabledFnCount;
											}
%>
									<tr>
										<td id="<%=id%>" class="space3" height="22"><input type="checkbox" disabled id="managedManagerCheckbox<%=i%>" value="<%=measure%>" class="eg_input" style="border:0px" onclick="updateSelectAllCheckboxStatus('managedManagerCheckbox');" <%=(!StringUtils.isNull(operation) && !operation.equals("addMeasures"))?"checked":""%>></td>
										<td id="<%=id%>" class="space3"><%=_mapping.getMeasureDescription(test,measure)%></td>
										<td id="<%=id%>" class="space3" align="center">
											<select id='<%=measure%>' name='<%=measure%>' style="width:150px" <%=disabledStr%>>
<%
											if(disabledStr.length()>0)
											{
%>
												<option value="pct"><%=fnMapping.get("pct")%></option>
<%
											}
											else
											{
												for(int j=0;j<function_names.length;j++)
												{
													String fn = function_names[j];
													if (fnMapping.get(fn) != null)
													{
%>
														<option value='<%=fn%>' <%=defaultFunction.equals(fn)?"selected":""%>> <%=fnMapping.get(fn).toString()%></option>
<%
													}
												}
											}
%>
											</select>
										</td>
									</tr>
<%
										}
%>
								</table>
							</td>
						</tr>
						<tr>
							<td id="eg_blnkspace" height="10">&nbsp;</td>
						</tr>
					</table>
				</td>
			</tr>
<%
				showBothButtons = disabledFnCount==0?false:true;
			}
			if(excludedMeasures.size()>0)
			{
%>
			<tr>
				<td>
					<table align="center" cellspacing="0" cellpadding="0" width="85%" border="0" style="table-layout:fixed">
						<tr>
							<td width="100%" id="eg_whitebg" class="head_padding4">
								<table align="center" width="100%" cellspacing="0" cellpadding="3" border="0"><col width="50%"><col width="50%">
									<tr>
										<td id="eg_whitebg" class="head_padding4" align="left"><egui:intnl text="admin.common.Excluded measures for"/>&nbsp;<b><%=_mapping.getTestDescription(s_aggtest)%></b></b></td>
										<td id="eg_whitebg" class="head_padding4" align="right"></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td id="table_border" class="eg_morelight">
								<table align="center" width="100%" cellspacing="0" cellpadding="3" border="0" id="cell_border1"><col width="3%">
								<col width="77%"><col width="19%">
									<tr>
										<td id="table_head" style="padding-left:6px;padding-right:6px" align="right" height="20"><input class="eg_input" style="border:0px" type="checkbox" name="allunmanagedManagerCheckbox" value="selectAll" onClick="javascript:selectAllCheckboxes(this.checked,'unmanagedManagerCheckbox',<%=excludedMeasures.size()%>);"></td>
										<td id="table_head" align="left"><b><egui:intnl text="admin.common.Measures Name"/></b></b></td>
										<td id="table_head" align="center"><b><egui:intnl text="admin.common.Aggregate Function"/></b></td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td id="table_border" class="padding6 eg_morelight">
								<table align="center" width="100%" cellspacing="0" cellpadding="3" border="2" id="cell_border1"><col width="2%"><col width="78%"><col width="20%">
<%
										String[] function_names = aggregateInfo.getGroupFunctions();
										for(int i=0;i<excludedMeasures.size();i++)
										{
											String measure = (String)excludedMeasures.get(i);
											String id=(i%2==0)?"cell_border3":"cell_border4";
											String unit = tableConfig.getUnitForMeasure(test,measure);
											String defaultFunction="-1";
											if(minV.contains(unit))
											{
												defaultFunction = "min";
											}
											else if(maxV.contains(unit))
											{
												defaultFunction = "max";
											}
											else if(sumV.contains(unit))
											{
												defaultFunction = "sum";
											}
											else if(avgSumV.contains(unit) || unit.indexOf("/")>0)
											{
												defaultFunction = "avg_sum";
											}
											else
											{
												defaultFunction = "avg";
											}
%>
									<tr>
										<td id="<%=id%>" class="space3" height="22"><input class="eg_input" style="border:0px" type="checkbox" id="unmanagedManagerCheckbox<%=i%>" value="<%=measure%>" onclick="updateSelectAllCheckboxStatus('unmanagedManagerCheckbox');"></td>
										<td id="<%=id%>" class="space3"><%=_mapping.getMeasureDescription(test,measure)%></td>
										<td id="<%=id%>" class="space3" align="center">
											<select id='<%=measure%>' name='<%=measure%>' style="width:150px">
												<option value="-1" <%=defaultFunction.equals("-1")?"selected":""%>><egui:intnl text="admin.ic.Select a function"/></option>
<%
											for(int j=0;j<function_names.length;j++)
											{
												String fn = function_names[j];
												if (fnMapping.get(fn) != null)
												{
%>
													<option value='<%=fn%>' <%=defaultFunction.equals(fn)?"selected":""%>> <%=fnMapping.get(fn).toString()%></option>
<%
												}
											}
%>
											</select>
										</td>
									</tr>
<%
										}
%>
								</table>
							</td>
						</tr>
						<tr>
							<td id="eg_blnkspace" height="10">&nbsp;</td>
						</tr>
					</table>
				</td>
			</tr>
<%
			}
			if(showBothButtons)
			{
%>
			<tr>
				<td align="center"><input type="button" value='<egui:intnl text="admin.common.Modify"/>' style="width:80px" class="eg_darkbutton" onClick="javascript:recreateTest();">&nbsp;<input type="button" value='<egui:intnl text="admin.common.Back"/>' style="width:80px" class="eg_darkbutton" onClick="javascript:goback();"></td>
			</tr>
<%
			}
			else
			{
%>
			<tr>
				<td align="center"><input type="button" value='<egui:intnl text="admin.common.Back"/>' style="width:80px" class="eg_darkbutton" onClick="javascript:goback();"></td>
			</tr>
<%
			}
%>
		</table>
		<input type='hidden' name="aggTest" value="<%=s_aggtest%>">
		<input type='hidden' name="measureNames" value="">
		<input type='hidden' name="operation" value="modifyMeasures">
		<input type='hidden' name="test" value="<%=test%>">
		<input type='hidden' name="s_component_type" value="<%=s_component_type%>">
	</form>
</body>
</html>



